// ---------------------------------------------------------------------------
// - Finalize.cpp                                                            -
// - standard object library - object finalizer class implementation         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Finalize.hpp"

namespace aleph {

  // default fifo size
  const long FIFO_SIZE = 1024;

  // create a new finalizer class

  Finalize::Finalize (void) {
    d_size = FIFO_SIZE;
    d_pos  = FIFO_SIZE-1;
    d_lock = false;
    p_fifo = new (Object*)[d_size];
    for (long i = 0; i < d_size; i++) p_fifo[i] = nilp;
  }

  // destroy this finalizer class

  Finalize::~Finalize (void) {
    d_lock = true;
    for (long i = 0; i < d_size; i++) Object::dref (p_fifo[i]);
    delete [] p_fifo;
  }

  // append an object for finalization

  void Finalize::append (Object* object) {
    if (object == nilp) return;
    // if we are locked we simply destroy
    if (d_lock == true) {
      delete object;
      return;
    }
    // recompute position and destroy current
    d_pos = ++d_pos % d_size;
    delete p_fifo[d_pos];
    p_fifo[d_pos] = object;
  }
}
