// ---------------------------------------------------------------------------
// - t_cdir.cpp                                                              -
// - standard system library - simple directory tester module                -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cdir.hpp"
#include "cstr.hpp"

int main (int, char**) {
  using namespace aleph;

  // check simple path
  char buf[512];
  c_strcpy (buf, "hello");
  char* fname = c_xname (buf);
  if (c_strcmp (fname, "hello") == false) return 1;

  // check root name
  buf[0] = c_dirsep ();
  buf[1] = nilc;
  c_strcat (buf, "hello");
  fname = c_xname (buf);
  if (c_strcmp (fname, "hello") == false) return 1;
  delete [] fname;

  // check multiple name
  buf[6] = c_dirsep ();
  buf[7] = nilc;
  c_strcat (buf, "world");
  fname =  c_xname (buf);
  if (c_strcmp (fname, "world") == false) return 1;
  delete [] fname;

  // ok this is enough
  return 0;
}
