// ---------------------------------------------------------------------------
// - Constant.hpp                                                            -
// - aleph engine - constant object class definition                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CONSTANT_HPP
#define  ALEPH_CONSTANT_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Constant class is a special object which holds a literal object
  /// and that evaluates to a brand new object. The evaluation is done by
  /// cloning the literal object. A constant object is built by the lexical
  /// analyzer with a literal value.
  /// @author amaury darsch

  class Constant : public Literal {
  private:
    /// the literal object
    Literal* p_lobj;

  public:
    /// create an empty constant
    Constant (void);

    /// create a new constant
    /// @param lobj the literal object
    Constant (Literal* lobj);

    /// copy construct this constant
    /// @param that the constant to copy
    Constant (const Constant& that);

    /// destroy this constant
    ~Constant (void);

    /// @return the class name
    String repr (void) const;

    /// make this constant a shared object
    void mksho (void);

    /// @return a literal representation of this constant
    String toliteral (void) const;

    /// @return a string representation of this constant
    String tostring (void) const;

    /// @return a clone of this constant
    Object* clone (void) const;

    /// @return the lexical serial code
    t_byte serialid (void) const;

    /// serialize this lexical to an output stream
    /// @param os the output stream to write
    void wrstream (class Output& os) const;

    /// deserialize a lexical from an input stream
    /// @param is the input steam to read in
    void rdstream (class Input& is);

    /// evaluate this constant in the current nameset
    /// @param robj   the current runnable
    /// @param nset   the current nameset
    Object* eval (Runnable* robj, Nameset* nset);

  private:
    // make the assignment operator private
    Constant& operator = (const Constant&);
  };
}

#endif
