//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "loadSave.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString LoadSave::filename()
{
  return QString("%1/saveLoad.html").arg(TEMP_DIR);
}
//==============================================
void LoadSave::generateHTML(QTextStream::Encoding type, QString charSet)
{
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Saving & Loading") << "</font></td>\n";
    stream << "</tr></table>\n";

    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Saving Albums:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    
    stream << HelpWindow::tr("To save an album, choose <font color='red'>File &rarr; Save</font>. The first time an album is saved, or whenever using the <font color='red'>Save As</font> command, you will be presented with the dialog pictured at the right. First, choose a theme to use when saving your album on the left. Preview images and additional details of the selected theme are shown to the right. Themes determine the look and feel of the generated web album. At the bottom you can choose the location you wish to save to.") << "\n";
    
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("If you wish to switch themes in the future, use the <font color='red'>Save As</font> command, pick the new theme, and save over the top of the old album.") << "\n";
    
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/saveAs.png'>\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Loading Albums:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/recentAlbums.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper makes loading albums easy. Use the <font color='red'>File &rarr; Open Recent</font> menu. If you have a lot of albums, or if you are opening an album created on a different machine, select <font color='red'>File &rarr; Open</font>, browse to the album's location, and open the <font color='red'>Album.xml</font> file within this directory.") << "\n";
    
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("If you want to restore an album to its last saved state, you can either load it again, or use <font color='red'>File &rarr; Revert to Saved</font>.") << "\n";
    
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Exporting:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    
    stream << HelpWindow::tr("In addition to producing web galleries, Album Shaper can export your photos in a number of other formats.") << "\n";
    
    stream << "<p align='justify'><ul>\n";
    stream << "<li>" << HelpWindow::tr("To use a photo as your desktop wallpaper, select the photo and click the <font color='red'>Desktop</font> button at the bottom of the organize view.") << "\n";
    
    stream << "<p align='justify'>\n";
    stream << "<li>" << HelpWindow::tr("To export a small web gallery that does not include full-size images, select <font color='red'>File &rarr; Export &rarr; Small Web Gallery</font>.") << "\n";
    
    stream << "<p align='justify'>\n";
    stream << "<li>" << HelpWindow::tr("To export an entire album's contents for printing, select <font color='red'>File &rarr; Export &rarr; Images for Printing</font>. Only the full-size images will be exported to a directory along side your album on disk.") << "\n";
    
    stream << "</ul>\n";

    stream << "</td></tr></table>\n";
    stream << "</td></tr>\n";
    stream << "</font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
