#ifndef _SPELL_H
#define _SPELL_H

#include "mudtypes.h"
#include "ability.h"
#include "flags.h"

class Builder;

class Spell : public Ability {
 public:

   Spell();
   virtual ~Spell();
   Spell(char *spell_name);

   void set_min_intel(int new_min_intel);
   int get_min_intel();

   Flags *get_spellflags();
   
   int read_spell_attrib(FILE *read_file, ErrLog *error_log);

   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);

   int set_attrib_spellflags(Parse *the_parsed, Builder *the_builder);

   virtual void write_object(FILE *the_file, int build_format);
   virtual int copy_object(Entity *copy_obj);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:


   int     min_intel;
   Flags   *spell_flags;
};

#endif
