#ifndef _SKILL_H
#define _SKILL_H

#include "mudtypes.h"
#include "ability.h"
#include "flags.h"

class Builder;

class Skill : public Ability {
 public:

   Skill();
   virtual ~Skill();
   Skill(char *skill_name);

   void set_min_str(int new_str);
   int get_min_str();
   void set_min_dex(int new_dex);
   int get_min_dex();

   Flags *get_skillflags();

   int read_skill_attrib(FILE *read_file, ErrLog *error_log);   

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int set_attrib_skillflags(Parse *the_parsed, Builder *the_builder);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();


 private:


   int     min_str;
   int     min_dex;
   Flags   *skill_flags;
};

#endif
