#ifndef LEXER_H_
#define LEXER_H_

#include <stdio.h>

/*******************************************************************************
 **                           Lexer Stuff                                  
 ******************************************************************************/

#define TOKENSTRLEN   512   /* the max string length of a token string */

/* defines for token types */

#define T_AMPER      1  
#define T_LBRAQ      2  
#define T_RBRAQ      3 
#define T_LPAREN     4  
#define T_RPAREN     5  
#define T_CARROT     6  
#define T_QUOTE      7  
#define T_PLUS       8  
#define T_MINUS      9  
#define T_MULT       10  
#define T_DIVIDE     11   
#define T_AND        12  
#define T_OR         13  
#define T_SEMICOLON  14  
#define T_EQUALS     15  
#define T_POUND      16  
#define T_COLON      17  
#define T_LSQUIG     18  
#define T_RSQUIG     19  
#define T_PERCENT    20  
#define T_COMMA      21 
#define T_APOST      22 
#define T_RIGHTAPOST 23
#define T_EXPOINT    24
#define T_LOCATION   25
#define T_MOBILE     26
#define T_MARKER     27
#define T_DOOR       28
#define T_MOVEABLE   29
#define T_KEY        30
#define T_BOOK       31
#define T_MERGER     32
#define T_MONEY      33
#define T_WEAPON     34
#define T_WEARABLE   35
#define T_FOOD       36
#define T_SPECIAL    37
#define T_SPELL      38
#define T_SKILL      39
#define T_ROPE       40
#define T_BOAT       41
#define T_LEVEL      42
#define T_QUEST      43
#define T_RACE       44
#define T_MASK       45
#define T_INCLINAT   46
#define T_TALENT     47
#define T_CHATLINE   48
#define T_LAST       49 
#define T_NUMERICAL  50 
#define T_STRING     51
#define T_IDENTIFIER 52 
#define T_BOOLEAN    53 
#define T_OTHER      54 


#ifdef LEXER_C
/* table for finding or displaying the token type based on the numerical value */
char *TokenNames[] = {
      "@",        "[",         "]",         "(",
      ")",        "^",         "\"",        "+",
      "-",        "*",         "/",         "and",
      "or",       ";",         "=",         "#",
      ":",        "{",         "}",         "%",
      ",",        "'",         "`",         "!", 
      "loc",      "mob",       "marker",    "door", 
      "moveable", "key",       "book",      "merger",
      "money",    "weapon",    "wearable",  "food",
      "special",  "spell",     "skill",     "rope",
      "boat",     "level",     "quest",     "race",
      "mask",     "incl",      "talent",    "chatline"
        };
#endif

struct token_data {
   char       *token_name;
   int        token_type;
   token_data *left;
   token_data *right;
};

/* token record, holds data for the token taken from the file */
typedef struct _token_record {
   int                  token_type;   /* type from def. above, type of token */
   char                 the_string[TOKENSTRLEN]; /* Holds the token string */
   struct _token_record *more;        /* more strings, used for desc */
   struct _token_record *next_tok;    /* used for keeping track so we can free
                                         the tokens easily */
} token_record;

/* to hold a list of strings, uses less memory than keeping them in 
   token form */
typedef struct _string_record {
   char			 *the_string;  /* holds the string */
   struct _string_record *nextstr;     /* pointer to the next string record */
} string_record;


struct _string_record *get_str_until(FILE *thefile, char until1, char until2);
int goto_next_char(FILE *thefile);
char check_next_char(FILE *thefile);
int xend_of_line(FILE *thefile);
int next_line(FILE *the_file);
char *xlowercase (char *str, int thesize);
void free_token(token_record *tokenptr);
void free_token_data(token_data *tokenptr);
// FILE *xfopen(char *filename);
token_record *get_token(FILE *thefile, char until);
void free_all(void);
int  create_tree();

#endif




