#ifndef _INP_HANDLER_H
#define _INP_HANDLER_H

#include "mudtypes.h"
#include "strings.h"
#include "pager.h"
#include "editor.h"
#include "mailer.h"
#include "bulletin.h"

#define HANDLER_DATA_NONE      0 
#define HANDLER_DATA_INT       1
#define HANDLER_DATA_PAGER     2
#define HANDLER_DATA_EDITOR    3
#define HANDLER_DATA_MAILER    4
#define HANDLER_DATA_BULLETIN  5
#define HANDLER_DATA_BULLENTRY 6

class Inp_Handler;

typedef int (*Pop_Func)(Inp_Handler *, char *, char *, char *, Strings *);

union handler_dtypes {
   int       *the_int;
   Pager     *the_pager;
   Editor    *the_editor;
   Mailer    *the_mailer;
   Bulletin  *the_board;
   BullEntry *the_entry;
};

struct handler_struct {
   Inp_Func       the_command;
   Strings        *the_prompt;
   int            delete_prompt;
   int            data_type;
   handler_dtypes the_data;
   int            del_data;
   Pop_Func       pop_command;
   Strings        *pop_string;
   Strings        pop_identifier1;
   Strings        pop_identifier2;
   Strings        pop_identifier3;
   int            lines_per_handle;
   Strings        last_command;
   handler_struct *next_handler;
};


class Inp_Handler {
public:

   Inp_Handler();
   ~Inp_Handler();

   int  push_input_handler(Inp_Func funct_name, char *prompt, int data_type);
   int  push_input_handler(Inp_Func funct_name, Strings *prompt, int del_prompt,
                                              int data_type, int del_data);
   int  push_input_handler(Inp_Func funct_name, Strings *prompt, int del_prompt,
                           int data_type, int del_data, int lines_per_handle);
   int  pop_input_handler();
   int  replace_input_handler(Inp_Func funct_name, Strings *prompt, 
                               int del_prompt, int data_type, int del_data);
   int  replace_input_handler(Inp_Func funct_name, Strings *prompt, 
          int del_prompt, int data_type, int del_data, int lines_per_handle);
   int  replace_input_handler(Inp_Func funct_name, char *prompt, int data_type);
   int  exec_input_handler(MudObject *the_user, char *the_input);
   int  add_pop_function(Pop_Func the_function, char *id1, char *id2,
                                         char *id3, Strings *the_string);
   int  repeat_last_command(MudObject *the_user);
   char *get_prompt(void);
   void swap_prompt(Strings *new_prompt);
   
   int get_lines_per_handle();
   void *get_data();
   void *get_pop_data(void);
   void set_data(void *the_data);

   int  has_handler(Inp_Func funct_name);
   Inp_Func get_command();

   void remove_pop_function();
   void set_delete_data();

private:

   handler_struct *input_stack;
   handler_struct *pop_handler;

};

#endif
