#ifndef _CODE_H
#define _CODE_H

#include "specials.h"
#include "mudtypes.h"

#define FORMAT_FUNC 0
#define FORMAT_EQ   1

struct params {
   int       param_type;
   var_ptrs  the_param;
   params    *next_param;
};

struct in_params {
   MudObject *primary_obj;
   MudObject *secondary_obj;
   MudObject *this_obj;
};


class Code {
public:
   Code(char *the_funct);
   Code(Spec_Func the_funct);
   virtual ~Code();
   int    check_valid();

   int    add_param(params *the_param);
   int    add_pass_param(params *the_param);
   params *get_param(int the_num);
   
   params *execute_command(Specials *the_special, Player *the_player, 
        in_params *player_params, int *the_results, special_env *environment);
   int    load_from_file(FILE *the_file, ErrLog *the_log);
   int    load_from_file(FILE *the_file, ErrLog *the_log, int the_format);

   int       delete_param_list(params *the_list);
   Code      *get_next_code();
   int       set_next_code(Code *the_code);
   Code      **get_next_ptr();
   Spec_Func get_funct_ptr();
   int       copy_code(Code *copy_from);
   params    *copy_param_list();
   void      set_var_name(char *new_name);
   char      *get_var_name();

   virtual int get_mem_size_dynamic();
   virtual int get_mem_size();

private:

   Code();

   Spec_Func the_mudcode;
   params    *param_list;
   params    *pass_list;
   int       valid;

   Strings   var_name;

   Code      *next_code;
};

#endif




