#ifndef _BUILDER_H
#define _BUILDER_H

#include "strings.h"
#include "individual.h"
#include "location.h"
#ifdef WIN32
#include "../win32/winconnection.h"
#else
#include "connection.h"
#endif
#include "area_dbase.h"
#include "errlog.h"
#include "inp_handler.h"
#include "flags.h"
#include "door.h"
#include "key.h"
#include "book.h"
#include "spell.h"
#include "skill.h"
#include "entity.h"

class Builder : public MudObject
{
public:
	int init_object(Connection *the_conn);

   Builder();  /* constructor */
   Builder(Connection *the_conn);

   virtual ~Builder(); /* destructor */

   Builder *get_next_builder();  /* returns a pointer to the next player */
   void set_next_builder(Builder *the_player); /* sets next player to.. */
   int send_bldr(char *the_str, ...);  /* sends a string to player */
   int check_connection();             /* checks the connection for data */
   //   int get_input(Strings *the_input, int remove_newline);
   int get_long_input(Strings *the_input);
   int get_long_input(Strings *the_input, int remove_newline);
   int set_pname(char *the_name);
   int is_on();
   void set_off();
   void set_quitting();
   int is_quitting();
   int unload_area(void);
   int load_area(char *areaname, FILE *the_file, ErrLog *error_log, 
                                                       int build_format);
   int load_area(DirRead *the_dir, char *areaname, char *pattern, 
		 ErrLog *error_log, int build_format);
   int modify_object(char *the_name);
   char *get_areaname();
   void set_areaname(char *new_name);
   Area_Dbase *get_area(void);
   int delete_area(void);
   void clr_modify();
   Entity *get_modify();
   int is_in_thread();
   void set_in_thread(int the_val);
   char *get_passwd();
   int set_passwd(char *the_passwd);
   int echo_on();
   int echo_off();
   int find_host_name();
   char *get_host_addr();
   char *get_ip_addr();
   Flags *get_comflags();
   int set_comflags(save_flags *the_flags);
   Flags *get_gameflags();
   int set_gameflags(save_flags *the_flags);
   Flags *get_adminflags();
   int set_adminflags(save_flags *the_flags);
   Connection *get_connection();
   int check_builder();
   char *get_prompt();
   Inp_Handler *get_input_handler(void);

   int  set_prompt();
   time_t get_idle();


   int       swap_connection(Builder *swap_builder);
   void      set_connection(Connection *new_connection);
   void      flush_builder(void);
   void      display_prompt(void);

   int       get_pager_lines();
   void      set_pager_lines(int new_val);

private:

   Connection  *the_socket;    /* the socket of this builder */
   int         still_on;       /* if the builder is still on or not */
   int         quitting;       /* if the builder is quitting */

   Builder     *next_builder;  /* pointer to the next builder */
   Location    *curr_loc;      /* the current location of the builder */

   Area_Dbase  *the_area;      /* the area dbase this builder points to */

   Strings     name_area;
   Entity      *modifying;
   Strings     passwd;         /* the builder's encrypted password */   
   Strings     prompt;

   int         in_thread;
   Flags       command_flags;  /* flags allowing commands to execute */
   Flags       game_flags;     /* flags for game play, used in the builder
                                  port for color */
   Flags       admin_flags;    /* flags for the game admins */

   Inp_Handler input_handler;

   int          pager_lines;
};

#endif



