// ---------------------------------------------------------------------------
// - Axs.hpp                                                                 -
// - afnix cross spreadsheet - interpreter class definition                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_AXS_HPP
#define  AFNIX_AXS_HPP

#ifndef  AFNIX_INTERP_HPP
#include "Interp.hpp"
#endif

#ifndef  AFNIX_FOLIO_HPP
#include "Folio.hpp"
#endif

namespace afnix {

  /// The Axs class is a derived class from the afnix interpreter that
  /// provide facility to manage the afnix spreadsheets. The class 
  /// works with the standard i/o streams and provides a special nameset 
  /// called axs. Such nameset incorporates all commands needed to perform 
  /// cell query and manipulation.
  /// @author amaury darsch

  class Axs : public Interp {
  private:
    /// the spreadsheet folio
    Folio* p_sps;
    /// the current sheet
    Sheet* p_sht;
    /// the axs command nameset
    Nameset* p_cset;

  public:
    /// create a new interpreter
    Axs (void);

    /// create a new interpreter withor without a terminal
    /// @param tflg the terminal flag
    Axs (const bool tflg);

    /// create a stream based interpreter
    /// @param is the input  stream
    /// @param os the output stream
    /// @param es the error  stream
    Axs (Input* is, Output* os, Output* es);

    /// destroy this interpreter
    ~Axs (void);

    /// @return the class name
    String repr (void) const;

    /// create a new folio
    Folio* newf (void);

    /// create a new folio by name
    /// @param name the folio name
    Folio* newf (const String& name);

    /// create a new folio by name and info
    /// @param name the folio name
    /// @param info the folio info
    Folio* newf (const String& name, const String& info);

    /// open a folio by name
    /// @param fname the folio to open
    Folio* open (const String& fname);

    /// save a folio by name
    /// @param fname the file name to write
    void save (const String& fname);

    /// print some folio information
    void info (Output* os) const;

    /// print the folio contents
    void flist (Output* os) const;

    /// create a new sheet and make it the default
    Sheet* create (void);

    /// import data into a sheet by name
    /// @param fname the file name to use
    void import (const String& fname);

    /// select a sheet by index
    /// @param index the sheet index
    Sheet* select (const long index);

    /// select a sheet by tag
    /// @param tag the sheet tag
    Sheet* select (const String& tag);

    /// add tag in the current sheet
    /// @param tag the tag to add
    void addtag (const String& tag);

    /// add elements marker in the current sheet
    /// @param elems the elements to insert
    void addmark (Vector* elems);

    /// add elements header in the current sheet
    /// @param elems the elements to insert
    void addhead (Vector* elems);

    /// add elements footer in the current sheet
    /// @param elems the elements to insert
    void addfoot (Vector* elems);

    /// add elements body in the current sheet
    /// @param elems the elements to insert
    void insert (Vector* elems);

    /// view a sheet content by index 
    /// @param os    the output stream
    /// @param max   the maximum number of rows
    /// @param start the start index
    /// @param flag  the string or literal flag
    void view (Output* os, long max, long start, bool flag) const;

    /// sort the default sheet by index and flag
    /// @param col  the column index
    /// @param mode the sorting mode
    void sort (const long col, const bool mode);

  private:
    // make the copy constructor private
    Axs (const Axs&);
    // make the assignment operator private
    Axs& operator = (const Axs&);
  };
}

#endif
