# coding=utf-8
from __future__ import print_function, absolute_import, unicode_literals

#
# Copyright (c) Justus Winter <4winter@informatik.uni-hamburg.de>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

try:
    # py3k
    import configparser
except ImportError:
    import ConfigParser as configparser

class GetListMixIn(object):
    def get_list(self, section, key, delimiter = ';',
                 filter_ = lambda value: value.strip(),
                 include_falsish = False):
        result = (filter_(value)
                  for value in self.get(section, key).split(delimiter))

        if include_falsish:
            return result
        else:
            return filter(None, result)

class SafeConfigParser(configparser.SafeConfigParser, GetListMixIn): pass
class RawConfigParser(configparser.RawConfigParser, GetListMixIn): pass
