/*
 * windowmenu.cc
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 18 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#include "aewm.hh"

WindowMenu::WindowMenu() : GenericMenu()
{
	updateWindowMenu();
}

WindowMenu::~WindowMenu()
{
}

void WindowMenu::updateWindowMenu()
{
	char* temp = new char[wm->getMaxDesktops()];
	for(int i=0; i<wm->getMaxDesktops(); i++)
	{
		sprintf(temp, "%d", i);
		
		insert(temp,"", SEND_TO_DESKTOP);
	}		
	delete [] temp;

	updateMenu();
	
	addToMenuList(this);
}

void WindowMenu::handle_button_release_event(XButtonEvent *e)
{
	int desktop=0;
	
	GenericMenu::handle_button_release_event(e);

	switch (e->button) 
	{
		case Button1:
			if (curr) 
			{
				switch(	curr->function )
				{
					case SEND_TO_DESKTOP:
						desktop = atoi(curr->name.c_str());
						client->set_desktop(desktop);
						hideAllVisibleSubmenus();
					break;
				
				}										
			}	
		break;
	} 
}
