/*
 * iconmenu.hh
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 1 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _ICONMENU_HH
#define _ICONMENU_HH

#include "aewm.hh"

class IconMenu : public GenericMenu
{
private:
	Client *client;

public:
	IconMenu();
	virtual ~IconMenu();

	virtual void handle_button_release_event(XButtonEvent *e);

	void updateIconMenu();

	void setThisClient(Client *c) { client = c; }

	void addThisClient(Client *c);
	void removeClientFromIconMenu(Client *c);
};

#endif 
