/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.run;

import com.acgvision.agent.action.Check;
import com.acgvision.agent.action.ExecResult;
import com.acgvision.agent.action.ServiceActions;
import com.acgvision.core.ws.Cpu;
import com.acgvision.core.ws.FileSystem;
import com.acgvision.core.ws.Measure;
import com.acgvision.core.ws.Memory;
import com.acgvision.core.ws.Monitor;
import com.acgvision.core.ws.Script;
import com.acgvision.core.ws.Service;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class Worker extends Thread {

    protected static final Logger logger = Logger.getLogger(Manager.class);
    private Task t;

    /**
     * Task to execute by the thread.
     * Tests if the work is allowed and executes it.
     */
    @Override
    public void run() {
        this.setName(t.toString());
        logger.debug("Run ");
        Date date = new Date();
        if (ServiceActions.validate(Main.host.getProduction(), date)) {
            Iterator<Service> it = t.getJob().getServices().iterator();
            boolean result = true;
            while (it.hasNext() && result) {
                result = ServiceActions.validate(it.next(), date);
            }
            if (result) {
                logger.debug("Checks");
                this.work();
            } else {
                logger.debug("Work not allowed");
            }
        }
        logger.debug("Fin du thread");
    }

    /**
     * Sens the measure to the Server
     * @param m
     */
    private void send(Measure m) {
        Main.measuresSpooler.add(m);
        Main.measuresSpooler.send();
        //com.acgvision.agent.run.Main.sender.sendMeasure(m);
    }

    public Worker(Task t) {
        this.t = t;
    }

    private void saveMeasure(int value) {
    //On envoie que si c'est un monitor
        if (t.getJob() instanceof Monitor) {
            //on sauvegarde que si c'ets prévu
            if (((Monitor) t.getJob()).isSaveValues()) {
                //Creates values to send
                try {
                    XMLGregorianCalendar xmlGC = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                    com.acgvision.core.ws.Measure measure = new com.acgvision.core.ws.Measure();
                    measure.setValue(value);
                    measure.setDate(xmlGC);
                    measure.setHost(Main.host);
                    measure.setMonitor((Monitor) t.getJob());
                    
                    send(measure);//sends the measure to the core
                } catch (DatatypeConfigurationException ex) {
                    logger.error(ex);
                }
            }
        }
    }

    /**
     * Runs checks and measures.
     */
    private void work() {
        if (t.getJob() instanceof Monitor) {

            ExecResult value = null;
            if (t.getJob() instanceof Cpu) {
                value = Check.get((Cpu) t.getJob(), Main.getConfigFile());
            } else if (t.getJob() instanceof Memory) {
                value = Check.get((Memory) t.getJob(), Main.getConfigFile());
            } else if (t.getJob() instanceof FileSystem) {
                value = Check.get((FileSystem) t.getJob(), Main.getConfigFile());
            } else if (t.getJob() instanceof Script) {
                value = Check.get((Script) t.getJob());
            }

            if (logger.isDebugEnabled()) {
                logger.debug(t.getJob() + " - Value :" + value.getCode());
            }
            saveMeasure(value.getCode());
            Check.check(value, (Monitor) t.getJob());//checks averages and limits

        //Check.check(value, (Monitor)t.getJob(), (List<Control>)((Monitor)t.getJob()).getLimitValues());
        } else {
            logger.error("Trying to check average or limitvalue...");
        }


    }
}
