


//***************************IMPORTANT**********************************
//
// The following implementation is not meant to be production 
// quality code. Actualy it is a quicky hacked up solution that
// needs much improvement. The current goal is to provide an 
// implementation that conforms to the spec defined RepositoryManager
// We will be using this code only for testing purposes. There WILL be 
// MAJOR performance improvements in the future. The code also needs 
// exhaustive testing because I have not tested all test cases.
//
// Best regards, Stoyan
//
//***************************IMPORTANT**********************************






// -*- C++ -*-
//
// RepositoryManager_Impl.cpp,v 1.2 2005/08/01 19:58:08 mxiong Exp

// ****  Code generated by the The ACE ORB (TAO) IDL Compiler ****
// TAO and the TAO IDL Compiler have been developed by:
//       Center for Distributed Object Computing
//       Washington University
//       St. Louis, MO
//       USA
//       http://www.cs.wustl.edu/~schmidt/doc-center.html
// and
//       Distributed Object Computing Laboratory
//       University of California at Irvine
//       Irvine, CA
//       USA
//       http://doc.ece.uci.edu/
// and
//       Institute for Software Integrated Systems
//       Vanderbilt University
//       Nashville, TN
//       USA
//       http://www.isis.vanderbilt.edu/
//
// Information about TAO is available at:
//     http://www.cs.wustl.edu/~schmidt/TAO.html

// TAO_IDL - Generated from 
// .\be\be_codegen.cpp:925





///====================================================================
// filename: RepositoryManager_Impl.cpp
// Author: Stoyan Paunov	spaunov@isis.vanderbilt.edu
//

#include "RepositoryManager_Impl.h"

#include "ace/OS_NS_fcntl.h"			//for open
#include "ace/OS_NS_unistd.h"			//for close
#include "ace/OS_NS_sys_stat.h"			//for filesize and fstat and mkdir
#include "ace/OS_NS_string.h"			//for ACE_CString


//to remove a file or dir from the local filesystem need remove () from stdio.h
// ---> need to include ace/OS_NS_stdio.h which would include the correct file for any OS!
#include "ace/OS_NS_stdio.h"

#include "ZIP_Wrapper.h"					//Wrapper around zzip
#include "ace/Containers_T.h"				//for ACE_Double_Linked_List
#include "ace/Malloc_Allocator.h"			//for ACE_New_Allocator needed by the doubly link list

//for the PackageConfiguration parsing
#include "Config_Handlers/STD_PC_Intf.h"
#include "Config_Handlers/Deployment.hpp"
#include "ciao/Deployment_DataC.h"
#include "Config_Handlers/XML_Helper.h"
#include "xercesc/dom/DOM.hpp"

#include "ace/Thread.h"					//for obtaining the ID of the current thread
#include "ace/OS_NS_stdlib.h"			//for itoa ()



#include <iostream>
using namespace std;



// Implementation skeleton constructor
CIAO_RepositoryManagerDaemon_i::CIAO_RepositoryManagerDaemon_i (CORBA::ORB_ptr the_orb)
: the_orb_ (CORBA::ORB::_duplicate (the_orb))
{
	//create directory in which the packages will be stored

	ACE_OS::mkdir(RM_STORAGE_PATH);	
	//if dir already exists a -1 is returned
	//we ignore this, just need to make sure the directory exists
}

// Implementation skeleton destructor
CIAO_RepositoryManagerDaemon_i::~CIAO_RepositoryManagerDaemon_i (void)
{
	this->names_.unbind_all ();
	this->uuids_.unbind_all ();
}

void CIAO_RepositoryManagerDaemon_i::shutdown (
    
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
  // Add your implementation here
	this->names_.unbind_all ();
	this->uuids_.unbind_all ();

	this->the_orb_->shutdown (0);
}


void CIAO_RepositoryManagerDaemon_i::installPackage (
    const char * installationName,
    const char * location
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException,
    ::Deployment::NameExists,
    ::Deployment::PackageError
  ))
{
  // Add your implementation here
	
	ACE_Hash_Map_Entry <ACE_CString, ACE_CString> *entry;

	if (this->names_.find (ACE_CString (installationName), entry) == 0)
		ACE_THROW (Deployment::NameExists ());

	//check is URL or local
	//download or load into memory

	size_t length = 0;	 
	CORBA::Octet* file = 0;

	if (strstr (location, "http://"))
		ACE_THROW (CORBA::NO_IMPLEMENT ());
	else
	{
		//read the package from disk and store in the RM directory
		//see if you can substiture this with a memory mapped file
		//for better perofrmance (mimic zero copy here)
		file = read_from_disk (location, length);

		if (!file)
			ACE_THROW (CORBA::INTERNAL ());
	}

	//need to make this an absolute path since I am changing the working dir
	char temp[512];
	char* cwd = ACE_OS::getcwd (temp, 512);
	ACE_CString path (cwd);
	path += "/";
	path += RM_STORAGE_PATH;
	path += "/";
	path += installationName;
	path += ".cpk";

	//Store the package in the local RM dir for future retrieval
	if (this->write_to_disk (path.c_str (), file, length) == -1)
		ACE_THROW (CORBA::INTERNAL ());

	Deployment::PackageConfiguration_var pc = retrieve_PC( const_cast<char*> (path.c_str ()), cwd);

	//insert the package into the database
	this->names_.bind (ACE_CString (installationName), path);

	//ALSO NEED THE UUID here
	this->uuids_.bind (ACE_CString (pc->UUID), path);

	cout << pc->label << endl;
	cout << pc->UUID << endl;
}

void CIAO_RepositoryManagerDaemon_i::createPackage (
    const char * installationName,
    const ::Deployment::PackageConfiguration & package,
    const char * baseLocation,
    ::CORBA::Boolean replace
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException,
    ::Deployment::NameExists,
    ::Deployment::PackageError
  ))
{
  // Add your implementation here
	ACE_THROW (CORBA::NO_IMPLEMENT ());
}

::Deployment::PackageConfiguration * CIAO_RepositoryManagerDaemon_i::findPackageByName (
    const char * name
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException,
    ::Deployment::NoSuchName
  ))
{
  // Add your implementation here

    // Find out if the PackageConfiguration was installed in the repository,
	// return it if found or throw and exception otherwise

    ACE_Hash_Map_Entry <ACE_CString, ACE_CString> *entry = 0;

      if (this->names_.find (ACE_CString (name), entry) != 0)
		  ACE_THROW (Deployment::NoSuchName ());							
		  //PackageConfiguration was not found

	char temp[512];
	char* cwd = ACE_OS::getcwd (temp, 512);

	Deployment::PackageConfiguration_var pc = retrieve_PC(const_cast<char*> (entry->int_id_.c_str ()), cwd);

	return pc._retn ();
}

::Deployment::PackageConfiguration * CIAO_RepositoryManagerDaemon_i::findPackageByUUID (
    const char * UUID
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException,
    ::Deployment::NoSuchName
  ))
{
  // Add your implementation here
 
	//NOTE: The following code actually works but I have not gotten 
	//the DELETE to remove the UUIDs and I am not allowing this code 
	//to be used for right now because the RM stays in an inconsistent 
	//state. A package can be deleted but it is still retrievable by is UUID.
	ACE_THROW_RETURN (CORBA::NO_IMPLEMENT (), 0);


	// Find out if the PackageConfiguration was installed in the repository,
	// return it if found or throw and exception otherwise

    ACE_Hash_Map_Entry <ACE_CString, ACE_CString> *entry = 0;

    if (this->uuids_.find (ACE_CString (UUID), entry) != 0)
		  ACE_THROW (Deployment::NoSuchName ());							
		  //PackageConfiguration was not found

	char temp[512];
	char* cwd = ACE_OS::getcwd (temp, 512);

	Deployment::PackageConfiguration_var pc = retrieve_PC(const_cast<char*> (entry->int_id_.c_str ()), cwd);

	return pc._retn ();
}

::CORBA::StringSeq * CIAO_RepositoryManagerDaemon_i::findNamesByType (
    const char * type
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
  // Add your implementation here
	ACE_THROW_RETURN (CORBA::NO_IMPLEMENT (), 0);
}

::CORBA::StringSeq * CIAO_RepositoryManagerDaemon_i::getAllNames (
    
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
  // Add your implementation here

	CORBA::ULong num_entries = this->names_.current_size (); 
	CORBA::StringSeq_var seq = new CORBA::StringSeq (num_entries);

	CORBA::ULong index = 0;
	for (PCMap_Iterator iter = this->names_.begin ();
									 iter != this->names_.end () && index < num_entries;
									 iter++)

		seq[index] = const_cast<char*> (((*iter).int_id_).c_str ());	//this looks hideous, but as lond as it works!


	return seq._retn ();		//release the underlying CORBA::StringSeq
}

::CORBA::StringSeq * CIAO_RepositoryManagerDaemon_i::getAllTypes (
    
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException
  ))
{
  // Add your implementation here
	ACE_THROW_RETURN (CORBA::NO_IMPLEMENT (), 0);
}

void CIAO_RepositoryManagerDaemon_i::deletePackage (
    const char * installationName
  )
  ACE_THROW_SPEC ((
    CORBA::SystemException,
    ::Deployment::NoSuchName
  ))
{
  // Add your implementation here

    ACE_Hash_Map_Entry <ACE_CString, ACE_CString> *entry;

    if (this->names_.find (ACE_CString (installationName), entry) != 0)
		ACE_THROW (Deployment::NoSuchName ());
	else
		this->names_.unbind (installationName);

	//do the same for the UUID!!!!
	//TODO: NEED TO DO THIS LATER


	//actually delete the package here!
	// I need to figure out how to do that without causing some race condition
	bool purge = false;
	if (purge)
	{
		ACE_CString path (RM_STORAGE_PATH);
		path += "/";
		path += installationName;
		path += ".cpk";

		remove (path.c_str ());
	}
}

//==========================================HELPER METHODS========================================================

Deployment::PackageConfiguration* CIAO_RepositoryManagerDaemon_i::retrieve_PC (char* package, char* cwd)
{
	char temp[128];
	unsigned int thread_id = ACE_Thread::self ();
	char* PID = ACE_OS::itoa (thread_id, temp, 10);

	ACE_OS::mkdir(PID);	
	//if dir already exists a -1 is returned
	//we ignore this, just need to make sure the directory exists

	//change the working dir
	ACE_OS::chdir (PID);

	ACE_CString pcd_name;
	//extract the necessary descriptors
	if (extract_necessary_files (package,
							     PID,
							     pcd_name) < 0)
	{
		ACE_ERROR ((LM_ERROR,
                   "(%P|%t) RepositoryManager: error extracting necessary files\n"));
		ACE_THROW (CORBA::INTERNAL ());
	}

	Deployment::PackageConfiguration_var pc;
	//parse the PCD to make sure that there are no package errors
	ACE_TRY
	{
		CIAO::Config_Handlers::STD_PC_Intf intf (pcd_name.c_str ());
    
		pc = intf.get_PC ();
	}
	ACE_CATCHALL
    {
        ACE_ERROR ((LM_ERROR,
                   "(%P|%t) RepositoryManager: Error parsing the PCD\n"));
		ACE_THROW (Deployment::PackageError ());
    }
    ACE_ENDTRY;
	//able to parse the PC. So lets install the package in the repo

	//change back the the old working dir
	ACE_OS::chdir (cwd);

	//we no longer need the descriptors, so lets erase them!
	ACE_OS::rmdir (PID);
	//the ACE_OS::rmdir does not work. Possibly because we need to delete
	//the contents first. I will look into it more closely when I am back.

	return pc._retn ();
}



//We are using Xercesc in the Config_Handlers and unfortunately its API only
//takes a file in the local file system as an argument, thus need to
//write out the contents of the deployent plan to a file
//in the current directory. I use the thread id to guarrantee 
//lack of race conditions if multithreading is enabled

int CIAO_RepositoryManagerDaemon_i::extract_necessary_files (char* package, char* PID, ACE_CString& pcd_name) 
{
	//create a ZIP wrapper
	ZIP_Wrapper zip;

	//create a doubly link list
	ACE_New_Allocator allocator;
	ACE_Double_Linked_List<ZIP_File_Info> list (&allocator);


	char temp[512];
	char* cwd = ACE_OS::getcwd (temp, 512);
	
	//get the list of files in the package and figure out the names of all necessary files
	if (!(zip.file_list_info (package, list)))
		return -1;

	size_t skip_len = ACE_OS::strlen ("descriptors") + 1;

	while (!list.is_empty ())
	{
		ZIP_File_Info* inf = list.delete_head ();
		if (ACE_OS::strstr (inf->name_.c_str (), "descriptors"))
		{
			if (ACE_OS::strstr (inf->name_.c_str (), ".pcd"))
				pcd_name = inf->name_.c_str () + skip_len;

			//extract the descriptor from the package
			ACE_Message_Block file (0,0);
			if (!zip.get_file(const_cast<char*> (package), 
							  const_cast<char*> (inf->name_.c_str ()), 
							  file))
			{
				ACE_TEXT ("[RM::install] Unable to retrieve file!\n");
				return -1;
			}


			//write the file to disk
			if(!this->write_to_disk (inf->name_.c_str () + skip_len, file))
			{
				ACE_TEXT ("[RM::install] Unable to write out descriptor to disk!\n");
				return -1;
			}
		}
		//deallocate the head of the filename list
		delete inf;
	}

    return 1;
}


//---------------------------------------------------------------------
//These are a bit obsolete but until I am sure I will keep them

//This function attempts to write a sequence of bytes to
//a specified location. A -1 is returned in the case of an error
//and a 1 upon success

int CIAO_RepositoryManagerDaemon_i::write_to_disk (
	const char* full_path, 
	const CORBA::Octet* buffer, 
	size_t length
	)
{
	
	// Open a file handle to the local filesystem
    ACE_HANDLE handle = ACE_OS::open (full_path, O_CREAT | O_TRUNC | O_WRONLY);
    if (handle == ACE_INVALID_HANDLE)
        ACE_ERROR_RETURN ((LM_ERROR,
                           ACE_TEXT ("%p\n"),
                           ACE_TEXT ("[RM::write_to_disk] file creation error")),
                           -1);

	//write the data to the file
	if (ACE_OS::write (handle, buffer, length) == -1)
        ACE_ERROR_RETURN ((LM_ERROR,
                           ACE_TEXT ("%p\n"),
						   ACE_TEXT ("[RM::write_to_disk] file write error")),
                           -1);

	// Close the file handle
    ACE_OS::close (handle);

	return 1;
}


//This function attempts to read a sequence of bytes into an
//ACE_Message_Block from a specified location. A -1 is returned 
//in the case of an error and a 1 upon success

int CIAO_RepositoryManagerDaemon_i::write_to_disk 
	(const char* full_path, 
	 ACE_Message_Block& mb,
	 bool replace
	 )
{

	ACE_stat stat;

	if (ACE_OS::stat(full_path, &stat) != -1 && !replace)
		return 0;
	
	// Open a file handle to the local filesystem
    ACE_HANDLE handle = ACE_OS::open (full_path, O_CREAT | O_TRUNC | O_WRONLY);
    if (handle == ACE_INVALID_HANDLE)
        ACE_ERROR_RETURN ((LM_ERROR,
                           ACE_TEXT ("%p\n"),
                           ACE_TEXT ("[RM::write_to_disk] file creation error")),
                           -1);

	//write the data to the file
	for (ACE_Message_Block * curr = &mb; curr != 0; curr = curr->cont ())
		if (ACE_OS::write_n (handle, curr->rd_ptr(), curr->length()) == -1)
		    ACE_ERROR_RETURN ((LM_ERROR,
		                       ACE_TEXT ("%p\n"),
		                       ACE_TEXT ("write error")),
		                      -1);
		
	// Close the file handle
    ACE_OS::close (handle);

	return 1;
}

//This function attempts to read a sequence of bytes from a specified 
//location and returns an octet sequence. A -1 is returned 
//in the case of an error and a 1 upon success

CORBA::Octet* CIAO_RepositoryManagerDaemon_i::read_from_disk (
	const char* full_path,
	size_t &length
	)
{
	//open the file

	ACE_HANDLE handle = ACE_OS::open (full_path, O_RDONLY);
    if (handle == ACE_INVALID_HANDLE)
        ACE_ERROR_RETURN ((LM_ERROR,
                           ACE_TEXT ("%p\n"),
                           ACE_TEXT ("[RM::read_from_disk] file open error")),
                           0);

	ACE_stat file_info;

	ACE_OS::fstat (handle, &file_info);

	CORBA::Octet* buffer = new CORBA::Octet[file_info.st_size];

	if (buffer == 0)
		return 0;

	//read the contents of the file into the buffer
	if (ACE_OS::read_n (handle, buffer, file_info.st_size) == -1)
        ACE_ERROR_RETURN ((LM_ERROR,
                           ACE_TEXT ("%p\n"),
						   ACE_TEXT ("[RM::write_to_disk] file write error")),
                           0);

	// Close the file handle
    ACE_OS::close (handle);

	length = file_info.st_size;
	return buffer;
}

