//CompIntrDesc_Handler.cpp,v 1.1 2005/03/19 23:11:47 jai Exp

#ifndef CompIntrDesc_HANDLER_C
#define CompIntrDesc_HANDLER_C

#include "tao/Exception.h"
#include "ace/Auto_Ptr.h"
#include "ace/Log_Msg.h"
#include "Utils.h"
#include "Process_Element.h"
#include "Property_Handler.h"
#include "CompIntrDesc_Handler.h"
#include "DT_Handler.h"
#include "CPK_Handler.h"
#include <iostream>

BEGIN_DEPLOYMENT_NAMESPACE

/// handle the package configuration and populate it
void CompIntrDesc_Handler::process_ComponentInterfaceDescription
(::Deployment::ComponentInterfaceDescription &ccd)
{
  for (DOMNode* node = this->iter_->nextNode();
       node != 0;
       node = this->iter_->nextNode())
    {
      XStr node_name (node->getNodeName());

      if (node_name == XStr
               (ACE_TEXT ("Deployment:ComponentInterfaceDescription")))
        {
        }
      else if
        (CIAO::Config_Handler::Utils::process_string
              (this->iter_, node_name, "label", ccd.label));
      else if
        (CIAO::Config_Handler::Utils::process_string
              (this->iter_, node_name, "UUID", ccd.UUID));
      else if
        (CIAO::Config_Handler::Utils::process_string
              (this->iter_, node_name, "specificType", 
                        ccd.specificType));
      else if
        (CIAO::Config_Handler::Utils::process_string_seq
              (this->iter_, node_name, "supportedType", 
                            ccd.supportedType));
      else if
        (CIAO::Config_Handler::Utils::process_string_seq
              (this->iter_, node_name, "idlFile", ccd.idlFile));
      else if
        (process_sequence_common<Deployment::Property>
           (this->doc_, this->iter_, node,
            node_name, "configProperty", ccd.configProperty,
            &Property_Handler::process_Property,
            this->id_map_));
      else if
        (process_sequence_local<Deployment::ComponentPortDescription>
           (this->doc_, this->iter_, node,
            node_name, "port", ccd.port,
            this, &CompIntrDesc_Handler::process_port));
      else if
        (process_sequence_local<Deployment::ComponentPropertyDescription>
           (this->doc_, this->iter_, node,
            node_name, "property", ccd.property,
            this, &CompIntrDesc_Handler::process_comp_property));
      else if
        (process_sequence_common<Deployment::Property>
           (this->doc_, this->iter_, node,
            node_name, "infoProperty", ccd.infoProperty,
            &Property_Handler::process_Property,
            this->id_map_));
      else
        {
          this->iter_->previousNode ();
          return;
        }
    }
  return;
}

/// process component property element
void CompIntrDesc_Handler::process_comp_property (DOMNodeIterator* iter,
                                                  Deployment::
                                                  ComponentPropertyDescription&
                                                  property)
{
  for (DOMNode* node = iter->nextNode();
       node != 0;
       node = iter->nextNode ())
    {
      XStr node_name (node->getNodeName());

      if (node_name == XStr
               (ACE_TEXT ("Deployment:ComponentPropertyDescription")))
        {
        }
      else if (CIAO::Config_Handler::Utils::process_string
                  (iter, node_name, "name", property.name));
      else if (node_name == XStr (ACE_TEXT ("type")))
        {
          int argc = 0;
          char ** argv = 0;
          CORBA::ORB_ptr orb = CORBA::ORB_init (argc, argv, "");
          DT_Handler::process_DataType (iter, property.type.out (), orb);
        }
      else
        {
          iter->previousNode();
          return;
        }
    }
}

/// process port element
void CompIntrDesc_Handler::process_port (DOMNodeIterator* iter,
                                         Deployment::
                                         ComponentPortDescription& port)
{
  for (DOMNode* node = iter->nextNode();
       node != 0;
       node = iter->nextNode ())
    {
      XStr node_name (node->getNodeName());

      if (node_name == XStr
               (ACE_TEXT ("Deployment:ComponentPortDescription")))
        {
        }
      else if (CIAO::Config_Handler::Utils::process_string
                   (iter, node_name, "name", port.name));
      else if
        (CIAO::Config_Handler::Utils::process_string
                   (iter, node_name, "specificType", port.specificType));
      else if
        (CIAO::Config_Handler::Utils::process_string_seq
                   (iter, node_name, "supportedType", port.supportedType));
      else if
        (CIAO::Config_Handler::Utils::process_boolean
                   (iter, node_name, "provider", port.provider));
      else if
        (CIAO::Config_Handler::Utils::process_boolean
                   (iter, node_name, "exclusiveProvider", 
                         port.exclusiveProvider));
      else if
        (CIAO::Config_Handler::Utils::process_boolean
                  (iter, node_name, "exclusiveUser", port.exclusiveUser));
      else if
        (CIAO::Config_Handler::Utils::process_boolean
                 (iter, node_name, "optional", port.optional));
      else if (node_name == XStr(ACE_TEXT("kind")))
        {
          CPK_Handler::process_CCMComponentPortKind (iter, port.kind);
        }
      else
        {
          iter->previousNode();
          return;
        }
    }
}

END_DEPLOYMENT_NAMESPACE

#endif /* CompIntrDesc_HANDLER_C */
