//==============================================================
/**
 *  @file  Any_Handler.h
 *
 *  Any_Handler.h,v 1.3 2005/03/19 22:22:21 jai Exp
 *
 *  @author Jules White <jules@dre.vanderbilt.edu>
 */
//================================================================

#ifndef CIAO_CONFIG_HANDLERS_ANY_HANDLER_H
#define CIAO_CONFIG_HANDLERS_ANY_HANDLER_H
#include /**/ "ace/pre.h"

#include "Config_Handlers_Export.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace CORBA
{
  class Any;
}

namespace CIAO
{
  namespace Config_Handlers
  {
    class Any;

   /*
    * @class Any_Handler
    *
    * @brief Handler class for <ComponentInterfaceDescription> types.
    *
    * This class defines handler methods to map values from
    * XSC Any objects, parsed from the descriptor files, to the
    * corresponding CORBA IDL Any type.
    *
    */
    class Config_Handlers_Export Any_Handler
    {
      public:
      Any_Handler (void);
      virtual ~Any_Handler (void);

      static void extract_into_any (const Any& desc,
                                    ::CORBA::Any& toconfig);

      static Any get_any (const CORBA::Any &src);
    };
  }
}

#include /**/ "ace/post.h"
#endif /* CIAO_CONFIG_HANDLERS_ANY_HANDLER_H*/
