/* ------------------------------------------------------------------------
 * $Id: Store.hh,v 1.2 2001/06/29 15:00:39 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Store_hh_
#define _Store_hh_

// -- System Includes
#include <map>
#include <string>
#include <iostream>

// -- Zorn Includes
#include "Value.hh"

namespace Zorn {

    /**
     * Associative memory storage class.
     **/
    class Store {
    
    public:

	/**
	 * Constructor.
	 **/
	Store();

	/**
	 * Destructor.
	 **/
	virtual ~Store();

	/**
	 * Set a value into the store and associate it with an
	 * identifier.
	 *
	 * @param id identifier.
	 * @param value value to store.
	 **/
	void set(const std::string &id, const Value &value);
	
	/**
	 * Retrieve a value from the store given its identifier.
	 *
	 * @param id identifier.
	 * @return value associated with the identifier.
	 **/
	const Value &get(const std::string &id); 
	
	/**
	 * Remove an identifier and its associated value from the
	 * store.
	 *
	 * @param id identifier.
	 **/
	void remove(const std::string &id);

	/**
	 * Check to see whether a given identifier is defined in the
	 * store.
	 * 
	 * @param id identifier.
	 * @return true if the identifier exists, false if not.
	 **/
	bool exists(const std::string &id) const;

	/**
	 * Dump the contents of the store to an output stream (such as
	 * standard output).
	 *
	 * @param os output stream to use.
	 **/
	void dump(std::ostream &os) const;

    private:

	std::map<std::string, Value> _store;
    };

};

#endif /* Store.hh */
