/* ------------------------------------------------------------------------
 * Runnable.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-19 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Runnable_hh_
#define _Runnable_hh_

// -- Class Declarations

/**
 * Thread runnable abstract class. Provides a Java-like Runnable
 * interface to be used for defining the objects to be executed in
 * Threads. This class _only_ contains pure virtual functions, so
 * should be inherited from and overridden by implementing classes.
 **/
class Runnable {
  
public:

    /**
     * Thread execution method. Will be called by the corresponding
     * Thread object when run() is invoked on the thread. 
     **/
    virtual void run() = 0;

    
protected:
    
    /**
     * Constructor. (Abstract, so private constructor.)
     **/
    Runnable() { }

    
    /**
     * Destructor. (Abstract, so private destructor.)
     **/
    virtual ~Runnable() { }
    
};

#endif /* Runnable.hh */
