use jsparagus::stencil::opcode_info;

fn compare(name: &str, orig: &str, copied: &str) {
    if copied != orig {
        panic!(
            "{} is out of sync. \
                It's possible that the bytecode generated by jsparagus is \
                based on older opcodes. Please run \
                crates/emitter/scripts/update_opcodes.py in jsparagus.",
            name
        );
    }
}

fn main() {
    compare(
        "Opcodes.h",
        include_str!("../../vm/Opcodes.h"),
        opcode_info::get_opcodes_source(),
    );
}
