/* $Id: imap_conf.cpp,v 1.6 2001/07/10 03:22:58 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2001 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"

extern cfgfile Config;
extern FD_POPacc *pacc_obj;
static FD_acc_imap *imap_acc_obj;
static int ready = 0;

void IMAP_Host_Call(FL_OBJECT * obj, long param) {
}

void IMAP_Port_Call(FL_OBJECT * obj, long param) {
}

void IMAP_User_Call(FL_OBJECT * obj, long param) {
}

void IMAP_Pwd_Call(FL_OBJECT * obj, long param) {
}

void IMAP_Use_Trash_Call(FL_OBJECT * obj, long param) {
}

void IMAP_Store_Pwd_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(imap_acc_obj->IMAP_Store_Pwd))
        fl_show_alert("WARNING", "This is very unsecure option",
                      "make sure your config file (.xfmsources) is not readable by anyone else",
                      1);

}

void IMAP_Extra_Call(FL_OBJECT * obj, long param) {
}

void IMAP_Autocon_Call(FL_OBJECT * obj, long param) {
}

void imap_account(struct _imap_src *imap) {
    char title[64];

    if(ready)
        return;

    ready = 1;

    snprintf(title, sizeof(title), "Login to '%s' on", imap->source->name);

    fl_set_input(pacc_obj->P_Username, imap->username);
    fl_set_input(pacc_obj->P_Password, imap->password);
    fl_set_object_label(pacc_obj->P_Server, imap->hostname);
    fl_set_object_label(pacc_obj->P_Title, title);

    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "IMAP login");

    fl_do_only_forms();

    strncpy(imap->username, (char *) fl_get_input(pacc_obj->P_Username),
            IMAP_MAX_USERNAME_LEN);
    imap->username[IMAP_MAX_USERNAME_LEN] = '\0';
    strncpy(imap->password, (char *) fl_get_input(pacc_obj->P_Password),
            IMAP_MAX_PASSWD_LEN);
    imap->password[IMAP_MAX_PASSWD_LEN] = '\0';

    fl_hide_form(pacc_obj->POPacc);

    ready = 0;
    return;
}

void imap_acc(struct _retrieve_src *source) {
    struct _imap_src *imap;

    imap = (struct _imap_src *) source->spec;
    if(ready)
        return;
    ready = 1;
    imap_acc_obj = create_form_acc_imap();

    fl_set_input(imap_acc_obj->IMAP_Host, imap->hostname);
    fl_set_input(imap_acc_obj->IMAP_Port, imap->service);
    fl_set_input(imap_acc_obj->IMAP_User, imap->username);
    fl_set_input(imap_acc_obj->IMAP_Pwd, imap->password);
    fl_set_input(imap_acc_obj->IMAP_Extra, imap->list);

    fl_set_button(imap_acc_obj->IMAP_Autocon,
                  (imap->flags & ISRC_AUTOCON) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_Store_Pwd,
                  (imap->flags & ISRC_STOREPWD) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_Log,
                  (imap->flags & ISRC_LOGSESSION) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_Use_Trash,
                  (imap->flags & ISRC_TRASH) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_Cache,
                  (imap->flags & ISRC_CACHE) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_NExpunge,
                  (imap->flags & ISRC_NOEXPUNGE) ? 1 : 0);
    fl_set_button(imap_acc_obj->IMAP_Retrieve,
                  (imap->flags & ISRC_RETRIEVE) ? 1 : 0);

    fl_show_form(imap_acc_obj->acc_imap, FL_PLACE_CENTER, FL_TRANSIENT,
                 "IMAP server");
    fl_do_only_forms();

    strncpy(imap->hostname, fl_get_input(imap_acc_obj->IMAP_Host),
            MAX_HOST - 1);
    imap->hostname[MAX_HOST - 1] = '\0';
    strncpy(imap->service, fl_get_input(imap_acc_obj->IMAP_Port), 15);
    imap->service[15] = '\0';
    strncpy(imap->username, fl_get_input(imap_acc_obj->IMAP_User),
	    IMAP_MAX_USERNAME_LEN);
    imap->username[IMAP_MAX_USERNAME_LEN] = '\0';
    strncpy(imap->password, fl_get_input(imap_acc_obj->IMAP_Pwd), 
	    IMAP_MAX_PASSWD_LEN);
    imap->password[IMAP_MAX_PASSWD_LEN] = '\0';
    strncpy(imap->list, fl_get_input(imap_acc_obj->IMAP_Extra), 127);
    imap->list[127] = '\0';

    imap->flags = 0;
    if(fl_get_button(imap_acc_obj->IMAP_Autocon))
        imap->flags |= ISRC_AUTOCON;
    if(fl_get_button(imap_acc_obj->IMAP_Store_Pwd))
        imap->flags |= ISRC_STOREPWD;
    if(fl_get_button(imap_acc_obj->IMAP_Log))
        imap->flags |= ISRC_LOGSESSION;
    if(fl_get_button(imap_acc_obj->IMAP_Use_Trash))
        imap->flags |= ISRC_TRASH;
    if(fl_get_button(imap_acc_obj->IMAP_Cache))
        imap->flags |= ISRC_CACHE;
    if(fl_get_button(imap_acc_obj->IMAP_NExpunge))
        imap->flags |= ISRC_NOEXPUNGE;
    if(fl_get_button(imap_acc_obj->IMAP_Retrieve))
        imap->flags |= ISRC_RETRIEVE;

    fl_hide_form(imap_acc_obj->acc_imap);
    fl_free_form(imap_acc_obj->acc_imap);
    fl_free(imap_acc_obj);
    imap_acc_obj = NULL;

    ready = 0;
    return;
}

void set_imap_timer() {
	int itimeset = Config.getInt("imaptime", 600);
	int i, k, timerset = 0, itime = itimeset;
	time_t tnow = time(NULL);
	struct _imap_src *imap;

	for(i = 0; i < MAX_RETR_SOURCES; i++) {
		if(!*retrieve_srcs[i].name || (retrieve_srcs[i].type != RSRC_IMAP)) 
			continue;
		imap = (struct _imap_src *) retrieve_srcs[i].spec;
		if(!imap_isconnected(imap))
			continue;
		k = itimeset - (tnow - imap->lastcom);
		if(k <= 0)
			k = 1;
		if(k < itime)
			itime = k;
		timerset = 1;
	}

	fl_set_timer(imap_timer, timerset ? itime : 0);

	return;
}
