

        
            
--------------------------------------------------------------------------
-- TURBINE_PERMISSION
--------------------------------------------------------------------------
drop table if exists TURBINE_PERMISSION;

CREATE TABLE TURBINE_PERMISSION
(
    PERMISSION_ID INTEGER NOT NULL AUTO_INCREMENT,
    PERMISSION_NAME VARCHAR (99) NOT NULL,
    OBJECTDATA MEDIUMBLOB,
    PRIMARY KEY(PERMISSION_ID),
    UNIQUE (PERMISSION_NAME)
  
);

            
--------------------------------------------------------------------------
-- TURBINE_ROLE
--------------------------------------------------------------------------
drop table if exists TURBINE_ROLE;

CREATE TABLE TURBINE_ROLE
(
    ROLE_ID INTEGER NOT NULL AUTO_INCREMENT,
    ROLE_NAME VARCHAR (99) NOT NULL,
    OBJECTDATA MEDIUMBLOB,
    PRIMARY KEY(ROLE_ID),
    UNIQUE (ROLE_NAME)
  
);

            
--------------------------------------------------------------------------
-- TURBINE_GROUP
--------------------------------------------------------------------------
drop table if exists TURBINE_GROUP;

CREATE TABLE TURBINE_GROUP
(
    GROUP_ID INTEGER NOT NULL AUTO_INCREMENT,
    GROUP_NAME VARCHAR (99) NOT NULL,
    OBJECTDATA MEDIUMBLOB,
    PRIMARY KEY(GROUP_ID),
    UNIQUE (GROUP_NAME)
  
);

            
--------------------------------------------------------------------------
-- TURBINE_ROLE_PERMISSION
--------------------------------------------------------------------------
drop table if exists TURBINE_ROLE_PERMISSION;

CREATE TABLE TURBINE_ROLE_PERMISSION
(
    ROLE_ID INTEGER NOT NULL,
    PERMISSION_ID INTEGER NOT NULL,
    PRIMARY KEY(ROLE_ID,PERMISSION_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID),
    FOREIGN KEY (PERMISSION_ID) REFERENCES TURBINE_PERMISSION (PERMISSION_ID)
);

            
--------------------------------------------------------------------------
-- TURBINE_USER
--------------------------------------------------------------------------
drop table if exists TURBINE_USER;

CREATE TABLE TURBINE_USER
(
    USER_ID INTEGER NOT NULL AUTO_INCREMENT,
    LOGIN_NAME VARCHAR (32) NOT NULL,
    PASSWORD_VALUE VARCHAR (32) NOT NULL,
    FIRST_NAME VARCHAR (99) NOT NULL,
    LAST_NAME VARCHAR (99) NOT NULL,
    EMAIL VARCHAR (99),
    CONFIRM_VALUE VARCHAR (99),
    MODIFIED TIMESTAMP,
    CREATED TIMESTAMP,
    LAST_LOGIN TIMESTAMP,
    OBJECTDATA MEDIUMBLOB,
    PRIMARY KEY(USER_ID),
    UNIQUE (LOGIN_NAME)
  
);

            
--------------------------------------------------------------------------
-- TURBINE_USER_GROUP_ROLE
--------------------------------------------------------------------------
drop table if exists TURBINE_USER_GROUP_ROLE;

CREATE TABLE TURBINE_USER_GROUP_ROLE
(
    USER_ID INTEGER NOT NULL,
    GROUP_ID INTEGER NOT NULL,
    ROLE_ID INTEGER NOT NULL,
    PRIMARY KEY(USER_ID,GROUP_ID,ROLE_ID),
    FOREIGN KEY (USER_ID) REFERENCES TURBINE_USER (USER_ID),
    FOREIGN KEY (GROUP_ID) REFERENCES TURBINE_GROUP (GROUP_ID),
    FOREIGN KEY (ROLE_ID) REFERENCES TURBINE_ROLE (ROLE_ID)
);

            
--------------------------------------------------------------------------
-- TURBINE_SCHEDULED_JOB
--------------------------------------------------------------------------
drop table if exists TURBINE_SCHEDULED_JOB;

CREATE TABLE TURBINE_SCHEDULED_JOB
(
    JOB_ID INTEGER NOT NULL AUTO_INCREMENT,
    SECOND INTEGER default -1 NOT NULL,
    MINUTE INTEGER default -1 NOT NULL,
    HOUR INTEGER default -1 NOT NULL,
    WEEK_DAY INTEGER default -1 NOT NULL,
    DAY_OF_MONTH INTEGER default -1 NOT NULL,
    TASK VARCHAR (99) NOT NULL,
    EMAIL VARCHAR (99),
    PROPERTY MEDIUMBLOB,
    PRIMARY KEY(JOB_ID)
);

    
