package org.apache.turbine.services.rundata;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Turbine" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Java Servlet Classes
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

// Turbine Utility Classes
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.CookieParser;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.pool.Recyclable;

/**
 * TurbineRunData is an extension to the RunData interface to be
 * implemented by RunData implementations to be distributed by
 * the Turbine RunData Service. The extensions define methods
 * that are used by the service for initilizing the implementation,
 * but which are not meant to be called by the actual client objects.
 *
 * <p>TurbineRunData extends also the Recyclable interface making
 * it possible to pool its implementations for recycling.
 *
 * @author <a href="mailto:ilkka.priha@simsoft.fi">Ilkka Priha</a>
 * @author <a href="mailto:jon@latchkey.com">Jon S. Stevens</a>
 * @author <a href="mailto:bhoeneis@ee.ethz.ch">Bernie Hoeneisen</a>
 * @author <a href="mailto:dlr@finemaltcoding.com">Daniel Rall</a>
 * @version $Id: TurbineRunData.java,v 1.1 2001/03/16 00:06:37 ilkka Exp $
 */
public interface TurbineRunData extends RunData,
                                        Recyclable
{
    /**
     * Gets the parameter parser without parsing the parameters.
     *
     * @return the parameter parser.
     */
    public ParameterParser getParameterParser();

    /**
     * Sets the parameter parser.
     *
     * @param parser a parameter parser.
     */
    public void setParameterParser(ParameterParser parser);

    /**
     * Gets the cookie parser without parsing the cookies.
     *
     * @return the cookie parser.
     */
    public CookieParser getCookieParser();

    /**
     * Sets the cookie parser.
     *
     * @param parser a cookie parser.
     */
    public void setCookieParser(CookieParser parser);

    /**
     * Sets the servlet request.
     *
     * @param req a request.
     */
    public void setRequest(HttpServletRequest req);

    /**
     * Sets the servlet response.
     *
     * @param res a response.
     */
    public void setResponse(HttpServletResponse res);

    /**
     * Sets the servlet session information.
     *
     * @param sess a session.
     */
    public void setSession(HttpSession sess);

    /**
     * Sets the servlet configuration used during servlet init.
     *
     * @param config a configuration.
     */
    public void setServletConfig(ServletConfig config);

    /**
     * Sets the server data of the request.
     *
     * @param serverData server data.
     */
    public void setServerData(ServerData serverData);
}
