package test.peer;



import com.workingdogs.village.*;
import org.apache.turbine.om.peer.*;
import org.apache.turbine.util.*;
import org.apache.turbine.util.db.*;
import org.apache.turbine.util.db.map.*;
import java.util.*;
import test.map.*;
import test.*;

/** This class was autogenerated by XMLSchemaToObjectModel on: Sun Aug 27 15:53:55 EDT 2000 */
public class JobentryPeer extends BasePeer
{
    /** the mapbuilder for this class */
    private static final JobentryMapBuilder mapBuilder = (JobentryMapBuilder)getMapBuilder(JobentryMapBuilder.CLASS_NAME);

    /** the table name for this class */
    public static final String TABLE_NAME = mapBuilder.getTable();

    /** the column name for the TASK id field */
    public static final String TASK = mapBuilder.getJobentry_Task();
    /** the column name for the HOUR id field */
    public static final String HOUR = mapBuilder.getJobentry_Hour();
    /** the column name for the MINUTE id field */
    public static final String MINUTE = mapBuilder.getJobentry_Minute();
    /** the column name for the DAY_OF_MONTH id field */
    public static final String DAY_OF_MONTH = mapBuilder.getJobentry_DayOfMonth();
    /** the column name for the WEEKDAY id field */
    public static final String WEEKDAY = mapBuilder.getJobentry_Weekday();
    /** the column name for the EMAIL id field */
    public static final String EMAIL = mapBuilder.getJobentry_Email();
    /** the column name for the JOBID id field */
    public static final String JOBID = mapBuilder.getJobentry_Jobid();

    /** Method to do inserts */ 
    public static Object doInsert( Criteria criteria ) throws Exception
    {
        return BasePeer.doInsert( criteria );
    }

    /** Method to do selects */ 
    public static Vector doSelect( Criteria criteria ) throws Exception
    {
        criteria.addSelectColumn( TASK );
        criteria.addSelectColumn( HOUR );
        criteria.addSelectColumn( MINUTE );
        criteria.addSelectColumn( DAY_OF_MONTH );
        criteria.addSelectColumn( WEEKDAY );
        criteria.addSelectColumn( EMAIL );
        criteria.addSelectColumn( JOBID );

        // BasePeer returns a Vector of Value (Village) arrays.  The array
        // order follows the order columns were placed in the Select clause.
        Vector rows = BasePeer.doSelect(criteria);
        Vector results = new Vector();

        // populate the object(s)
        for ( int i=0; i<rows.size(); i++ )
        {
           Jobentry obj = new Jobentry();
            Record row = (Record)rows.elementAt(i);
            obj.setTask( row.getValue(1).asString() );
            obj.setHour( row.getValue(2).asInt() );
            obj.setMinute( row.getValue(3).asInt() );
            obj.setDayOfMonth( row.getValue(4).asInt() );
            obj.setWeekday( row.getValue(5).asInt() );
            obj.setEmail( row.getValue(6).asString() );
            obj.setJobid( row.getValue(7).asInt() );
            results.addElement( obj );
         }
         return results;
    }

    /**
     * @param Criteria object containing data that is used to create the UPDATE statement.
     */
     public static void doUpdate(Criteria criteria) throws Exception
     {
         Criteria selectCriteria = new Criteria(2);
         selectCriteria.put( JOBID, criteria.remove(JOBID) );
         BasePeer.doUpdate( selectCriteria, criteria );
     }

    /**
     * @param Criteria object containing data that is used DELETE from database.
     */
     public static void doDelete(Criteria criteria) throws Exception
     {
         BasePeer.doDelete ( criteria );
     }

    /** Method to do inserts */
    public static Object doInsert( Jobentry obj ) throws Exception
    {
        return JobentryPeer.doInsert(buildCriteria(obj));
    }

    /** Build a Criteria object from the data object for this peer */
    public static Criteria buildCriteria( Jobentry obj )
    {
        Criteria criteria = new Criteria();
        criteria.add( JobentryPeer.TASK, obj.getTask() );
        criteria.add( JobentryPeer.HOUR, obj.getHour() );
        criteria.add( JobentryPeer.MINUTE, obj.getMinute() );
        criteria.add( JobentryPeer.DAY_OF_MONTH, obj.getDayOfMonth() );
        criteria.add( JobentryPeer.WEEKDAY, obj.getWeekday() );
        criteria.add( JobentryPeer.EMAIL, obj.getEmail() );
        if( obj.getJobid() > 0 )
            criteria.add( JobentryPeer.JOBID, obj.getJobid() );
        return criteria;
    }


    /**
     * @param obj the data object to update in the database.
     */
    public static void doUpdate(Jobentry obj) throws Exception
    {
        JobentryPeer.doUpdate(buildCriteria(obj));
    }
    /**
     * @param obj the data object to delete in the database.
     */
    public static void doDelete(Jobentry obj) throws Exception
    {
        JobentryPeer.doDelete(buildCriteria(obj));
    }

}
