/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Builder;

public abstract class Expression {
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (Expression.isNumber(object)) {
            return Expression.numberValue(object) != 0L;
        }
        return object != null;
    }

    public static boolean isNumber(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte;
    }

    public static long numberValue(Object object) {
        return ((Number)object).longValue();
    }

    public static class CompareGtBuilder
    extends BinaryOperationBuilder {
        public CompareGtBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareGt compareGt = new CompareGt(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareGt;
            }
            try {
                return compareGt.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class CompareGeBuilder
    extends BinaryOperationBuilder {
        public CompareGeBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareGe compareGe = new CompareGe(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareGe;
            }
            try {
                return compareGe.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class CompareLtBuilder
    extends BinaryOperationBuilder {
        public CompareLtBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareLt compareLt = new CompareLt(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareLt;
            }
            try {
                return compareLt.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class CompareLeBuilder
    extends BinaryOperationBuilder {
        public CompareLeBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareLe compareLe = new CompareLe(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareLe;
            }
            try {
                return compareLe.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class CompareNeBuilder
    extends BinaryOperationBuilder {
        public CompareNeBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareNe compareNe = new CompareNe(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareNe;
            }
            try {
                return compareNe.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class CompareEqBuilder
    extends BinaryOperationBuilder {
        public CompareEqBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            CompareEq compareEq = new CompareEq(object, object2);
            if (object instanceof Macro || object2 instanceof Macro) {
                return compareEq;
            }
            try {
                return compareEq.operate(object, object2);
            }
            catch (ContextException contextException) {
                throw new BuildException(contextException.toString());
            }
        }
    }

    public static class DivideBuilder
    extends BinaryOperationBuilder {
        public DivideBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            if (!(object instanceof Macro) && !(object2 instanceof Macro)) {
                if (Expression.isNumber(object) && Expression.isNumber(object2)) {
                    long l = Expression.numberValue(object2);
                    if (l == 0L) {
                        throw new BuildException("Divide by zero");
                    }
                    return new Long(Expression.numberValue(object) / l);
                }
                throw new BuildException("Divide requires numeric operands");
            }
            return new DivideOperation(object, object2);
        }
    }

    public static class MultiplyBuilder
    extends BinaryOperationBuilder {
        public MultiplyBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            if (!(object instanceof Macro) && !(object2 instanceof Macro)) {
                if (Expression.isNumber(object) && Expression.isNumber(object2)) {
                    return new Long(Expression.numberValue(object) * Expression.numberValue(object2));
                }
                throw new BuildException("Multiply requires numeric operands");
            }
            return new MultiplyOperation(object, object2);
        }
    }

    public static class SubtractBuilder
    extends BinaryOperationBuilder {
        public SubtractBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            if (!(object instanceof Macro) && !(object2 instanceof Macro)) {
                if (Expression.isNumber(object) && Expression.isNumber(object2)) {
                    return new Long(Expression.numberValue(object) - Expression.numberValue(object2));
                }
                throw new BuildException("Subtract requires numeric operands");
            }
            return new SubtractOperation(object, object2);
        }
    }

    public static class AddBuilder
    extends BinaryOperationBuilder {
        public AddBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) throws BuildException {
            if (!(object instanceof Macro) && !(object2 instanceof Macro)) {
                if (Expression.isNumber(object) && Expression.isNumber(object2)) {
                    return new Long(Expression.numberValue(object) + Expression.numberValue(object2));
                }
                throw new BuildException("Add requires numeric operands");
            }
            return new AddOperation(object, object2);
        }
    }

    public static class NotBuilder
    extends UnaryOperationBuilder {
        public NotBuilder(Object object) {
            super(object);
        }

        public Object build(Object object) {
            if (object instanceof Macro) {
                return new NotOperation(object);
            }
            return !Expression.isTrue(object) ? TRUE : FALSE;
        }
    }

    public static class OrBuilder
    extends BinaryOperationBuilder {
        public OrBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) {
            if (object instanceof Macro) {
                if (object2 instanceof Macro) {
                    return new OrOperation(object, object2);
                }
                return Expression.isTrue(object2) ? TRUE : object;
            }
            if (object2 instanceof Macro) {
                return Expression.isTrue(object) ? TRUE : object2;
            }
            return Expression.isTrue(object) || Expression.isTrue(object2) ? TRUE : FALSE;
        }
    }

    public static class AndBuilder
    extends BinaryOperationBuilder {
        public AndBuilder(Object object, Object object2) {
            super(object, object2);
        }

        public Object build(Object object, Object object2) {
            if (object instanceof Macro) {
                if (object2 instanceof Macro) {
                    return new AndOperation(object, object2);
                }
                return Expression.isTrue(object2) ? object : FALSE;
            }
            if (object2 instanceof Macro) {
                return Expression.isTrue(object) ? object2 : FALSE;
            }
            return Expression.isTrue(object) && Expression.isTrue(object2) ? TRUE : FALSE;
        }
    }

    public static abstract class UnaryOperationBuilder
    implements Builder {
        private Object _o;

        public UnaryOperationBuilder(Object object) {
            this._o = object;
        }

        public abstract Object build(Object var1) throws BuildException;

        public Object build(BuildContext buildContext) throws BuildException {
            Object object = this._o instanceof Builder ? ((Builder)this._o).build(buildContext) : this._o;
            return this.build(object);
        }
    }

    public static abstract class BinaryOperationBuilder
    implements Builder {
        private Object _l;
        private Object _r;

        public BinaryOperationBuilder(Object object, Object object2) {
            this._l = object;
            this._r = object2;
        }

        public abstract Object build(Object var1, Object var2) throws BuildException;

        public Object build(BuildContext buildContext) throws BuildException {
            Object object = this._l instanceof Builder ? ((Builder)this._l).build(buildContext) : this._l;
            Object object2 = this._r instanceof Builder ? ((Builder)this._r).build(buildContext) : this._r;
            return this.build(object, object2);
        }
    }

    public static class CompareGt
    extends Compare {
        public CompareGt(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(String string, String string2) {
            return string.compareTo(string2) > 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l > l2 ? TRUE : FALSE;
        }
    }

    public static class CompareGe
    extends Compare {
        public CompareGe(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(String string, String string2) {
            return string.compareTo(string2) >= 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l >= l2 ? TRUE : FALSE;
        }
    }

    public static class CompareLt
    extends Compare {
        public CompareLt(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(String string, String string2) {
            return string.compareTo(string2) < 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l < l2 ? TRUE : FALSE;
        }
    }

    public static class CompareLe
    extends Compare {
        public CompareLe(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(String string, String string2) {
            return string.compareTo(string2) <= 0 ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l <= l2 ? TRUE : FALSE;
        }
    }

    public static class CompareNe
    extends Compare {
        public CompareNe(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(Object object, Object object2) {
            return object.equals(object2) ? TRUE : FALSE;
        }

        public Boolean compare(String string, String string2) {
            return !string.equals(string2) ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l != l2 ? TRUE : FALSE;
        }

        public Boolean compareNull(Object object) {
            return object != null ? TRUE : FALSE;
        }
    }

    public static class CompareEq
    extends Compare {
        public CompareEq(Object object, Object object2) {
            super(object, object2);
        }

        public Boolean compare(Object object, Object object2) {
            return object.equals(object2) ? TRUE : FALSE;
        }

        public Boolean compare(String string, String string2) {
            return string.equals(string2) ? TRUE : FALSE;
        }

        public Boolean compare(long l, long l2) {
            return l == l2 ? TRUE : FALSE;
        }

        public Boolean compareNull(Object object) {
            return object == null ? TRUE : FALSE;
        }
    }

    public static abstract class Compare
    extends BinaryOperation {
        public Compare(Object object, Object object2) {
            super(object, object2);
        }

        public abstract Boolean compare(String var1, String var2);

        public abstract Boolean compare(long var1, long var3);

        public Boolean compare(Object object, Object object2) {
            return null;
        }

        public Boolean compareNull(Object object) {
            return null;
        }

        public Object operate(Object object, Object object2) throws ContextException {
            Boolean bl = null;
            bl = object instanceof String && object2 instanceof String ? this.compare((String)object, (String)object2) : (Expression.isNumber(object) && Expression.isNumber(object2) ? this.compare(Expression.numberValue(object), Expression.numberValue(object2)) : (object instanceof String && Expression.isNumber(object2) ? this.compare((String)object, Long.toString(Expression.numberValue(object2))) : (Expression.isNumber(object) && object2 instanceof String ? this.compare(Long.toString(Expression.numberValue(object)), (String)object2) : (object == null ? this.compareNull(object2) : (object2 == null ? this.compareNull(object) : this.compare(object, object2))))));
            if (bl == null) {
                throw new ContextException("Objects not comparable");
            }
            return bl;
        }
    }

    public static class DivideOperation
    extends BinaryOperation {
        public DivideOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) throws ContextException {
            if (!Expression.isNumber(object) || !Expression.isNumber(object2)) {
                throw new ContextException("Divide requires numeric operands");
            }
            long l = Expression.numberValue(object2);
            if (l == 0L) {
                throw new ContextException("Divide by zero");
            }
            return new Long(Expression.numberValue(object) / l);
        }
    }

    public static class MultiplyOperation
    extends BinaryOperation {
        public MultiplyOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) throws ContextException {
            if (!Expression.isNumber(object) || !Expression.isNumber(object2)) {
                throw new ContextException("Multiply requires numeric operands");
            }
            return new Long(Expression.numberValue(object) * Expression.numberValue(object2));
        }
    }

    public static class SubtractOperation
    extends BinaryOperation {
        public SubtractOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) throws ContextException {
            if (!Expression.isNumber(object) || !Expression.isNumber(object2)) {
                throw new ContextException("Subtract requires numeric operands");
            }
            return new Long(Expression.numberValue(object) - Expression.numberValue(object2));
        }
    }

    public static class AddOperation
    extends BinaryOperation {
        public AddOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) throws ContextException {
            if (!Expression.isNumber(object) || !Expression.isNumber(object2)) {
                throw new ContextException("Add requires numeric operands");
            }
            return new Long(Expression.numberValue(object) + Expression.numberValue(object2));
        }
    }

    public static class NotOperation
    extends UnaryOperation {
        public NotOperation(Object object) {
            super(object);
        }

        public Object operate(Object object) {
            return !Expression.isTrue(object) ? TRUE : FALSE;
        }
    }

    public static class OrOperation
    extends BinaryOperation {
        public OrOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) {
            return Expression.isTrue(object) || Expression.isTrue(object2) ? TRUE : FALSE;
        }
    }

    public static class AndOperation
    extends BinaryOperation {
        public AndOperation(Object object, Object object2) {
            super(object, object2);
        }

        public Object operate(Object object, Object object2) {
            return Expression.isTrue(object) && Expression.isTrue(object2) ? TRUE : FALSE;
        }
    }

    public static abstract class UnaryOperation
    extends ExpressionBase {
        private Object _o;

        UnaryOperation(Object object) {
            this._o = object;
        }

        public abstract Object operate(Object var1);

        public Object evaluate(Context context) throws ContextException {
            Object object = this._o instanceof Macro ? ((Macro)this._o).evaluate(context) : this._o;
            return this.operate(object);
        }
    }

    public static abstract class BinaryOperation
    extends ExpressionBase {
        private Object _l;
        private Object _r;

        BinaryOperation(Object object, Object object2) {
            this._l = object;
            this._r = object2;
        }

        public abstract Object operate(Object var1, Object var2) throws ContextException;

        public Object evaluate(Context context) throws ContextException {
            Object object;
            Object object2;
            try {
                object2 = this._l instanceof Macro ? ((Macro)this._l).evaluate(context) : this._l;
            }
            catch (Exception exception) {
                object2 = null;
            }
            try {
                object = this._r instanceof Macro ? ((Macro)this._r).evaluate(context) : this._r;
            }
            catch (Exception exception) {
                object = null;
            }
            return this.operate(object2, object);
        }
    }

    public static abstract class ExpressionBase
    implements Macro {
        protected ExpressionBase() {
        }

        public final void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
            fastWriter.write(this.evaluate(context).toString());
        }

        public abstract Object evaluate(Context var1) throws ContextException;
    }
}

