/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.webmacro.NotFoundException;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceInitException;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.engine.DirectiveBuilder;
import org.webmacro.engine.Engine;
import org.webmacro.engine.IntrospectionException;
import org.webmacro.util.Log;

public final class DirectiveProvider
implements ResourceProvider {
    private final Hashtable _prototypes = new Hashtable();
    private static final Log _log = new Log("dir", "Directive Provider");
    private static final String[] _types = new String[]{"directive"};

    public final void register(String string) throws IntrospectionException, ResourceInitException {
        String string2 = DirectiveProvider.extractName(string);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IntrospectionException("No class " + string);
        }
        DirectiveBuilder directiveBuilder = (DirectiveBuilder)this._prototypes.get(string2);
        if (directiveBuilder == null) {
            directiveBuilder = new DirectiveBuilder(string2, clazz);
            this._prototypes.put(string2, directiveBuilder);
            _log.info("Registered directive: " + string2);
        } else if (!clazz.equals(directiveBuilder.getDirectiveClass())) {
            throw new ResourceInitException("Attempt to register directive " + clazz + " failed because " + directiveBuilder.getDirectiveClass() + " is already registered for type " + string2);
        }
    }

    private static String extractName(String string) throws IntrospectionException {
        if (!string.endsWith("Directive")) {
            throw new IntrospectionException("Malformed classname, must end with Directive");
        }
        int n = string.length() - 9;
        int n2 = string.lastIndexOf(46, n) + 1;
        String string2 = string.substring(n2, n);
        if (string.startsWith("org.webmacro.")) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    public final DirectiveBuilder getBuilder(String string) throws ClassNotFoundException {
        DirectiveBuilder directiveBuilder = (DirectiveBuilder)this._prototypes.get(string);
        if (null == directiveBuilder) {
            throw new ClassNotFoundException("No directive matched the name " + string);
        }
        try {
            return (DirectiveBuilder)directiveBuilder.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getTypes() {
        return _types;
    }

    public void init(ResourceBroker resourceBroker) throws ResourceInitException {
        try {
            String string = (String)resourceBroker.getValue("config", "Directives");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                try {
                    this.register(string2);
                }
                catch (Exception exception) {
                    Engine.log.exception(exception);
                    Engine.log.error("Could not load directive: " + string2);
                }
            }
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            throw new ResourceInitException("Could not init DirectiveProvider: " + exception);
        }
    }

    public void destroy() {
        this._prototypes.clear();
    }

    public void resourceRequest(RequestResourceEvent requestResourceEvent) throws NotFoundException {
        try {
            requestResourceEvent.set(this.getBuilder(requestResourceEvent.getName()));
        }
        catch (Exception exception) {
            throw new NotFoundException("No such directive: " + requestResourceEvent.getName() + ":" + exception.getMessage());
        }
    }

    public void resourceCreate(CreateResourceEvent createResourceEvent) throws NotFoundException, InterruptedException {
    }

    public boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public int resourceThreads() {
        return 0;
    }

    public int resourceExpireTime() {
        return 0;
    }
}

