/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc.fesi;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import helma.xmlrpc.WebServer;
import helma.xmlrpc.XmlRpcHandler;
import helma.xmlrpc.fesi.FesiRpcUtil;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class FesiRpcServer
extends ObjectPrototype {
    public WebServer srv;
    Evaluator evaluator;

    public FesiRpcServer(int n, ESObject eSObject, Evaluator evaluator) throws IOException, EcmaScriptException {
        super(eSObject, evaluator);
        this.evaluator = evaluator;
        this.srv = new WebServer(n);
    }

    public FesiRpcServer(WebServer webServer, ESObject eSObject, Evaluator evaluator) throws IOException, EcmaScriptException {
        super(eSObject, evaluator);
        this.evaluator = evaluator;
        this.srv = webServer;
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        this.srv.removeHandler(string);
        super.deleteProperty(string, n);
        return true;
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (eSValue instanceof ESObject) {
            this.srv.addHandler(string, new FesiInvoker((ESObject)eSValue));
        }
        super.putProperty(string, eSValue, n);
    }

    class FesiInvoker
    implements XmlRpcHandler {
        ESObject target;

        public FesiInvoker(ESObject eSObject) {
            this.target = eSObject;
        }

        public Object execute(String string, Vector vector) throws Exception {
            int n;
            Object object;
            int n2 = vector.size();
            ESObject eSObject = this.target;
            if (string.indexOf(".") > -1) {
                object = new StringTokenizer(string, ".");
                n = ((StringTokenizer)object).countTokens();
                int n3 = 1;
                while (n3 < n) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    try {
                        eSObject = (ESObject)eSObject.getProperty(string2, string2.hashCode());
                    }
                    catch (Exception exception) {
                        throw new EcmaScriptException("The property \"" + string2 + "\" is not defined in the remote object.");
                    }
                    ++n3;
                }
                string = ((StringTokenizer)object).nextToken();
            }
            object = new ESValue[n2];
            n = 0;
            while (n < n2) {
                object[n] = FesiRpcUtil.convertJ2E(vector.elementAt(n), FesiRpcServer.this.evaluator);
                ++n;
            }
            Object object2 = FesiRpcUtil.convertE2J(eSObject.doIndirectCall(FesiRpcServer.this.evaluator, eSObject, string, (ESValue[])object));
            return object2;
        }
    }
}

