/*
 * Decompiled with CFR 0.152.
 */
package junit.swingui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.swingui.TestRunner;
import junit.swingui.TestTreeModel;

class TestBrowser
extends JFrame
implements TestListener {
    private JButton fClose;
    private JButton fRun;
    private JButton fReload;
    private JTree fTree;
    private TestTreeModel fModel;
    private TestRunner fRunner;

    public TestBrowser(TestRunner runner) {
        this.fRunner = runner;
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)this).setBackground(SystemColor.control);
        ((Component)this).setSize(403, 300);
        this.setTitle("Test Browser");
        this.fTree = new JTree();
        this.fTree.setRowHeight(20);
        ToolTipManager.sharedInstance().registerComponent(this.fTree);
        this.fTree.putClientProperty("JTree.lineStyle", "Angled");
        JScrollPane scrolledTree = new JScrollPane(this.fTree);
        this.fClose = new JButton("Close");
        this.fClose.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestBrowser.this.dispose();
            }
        });
        this.fRun = new JButton("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestBrowser.this.runSelection();
            }
        });
        this.fReload = new JButton("Reload");
        this.fReload.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                TestBrowser.this.reloadTestTree();
            }
        });
        this.fTree.addTreeSelectionListener(new TreeSelectionListener(){

            public final void valueChanged(TreeSelectionEvent e) {
                TestBrowser.this.checkEnableRun(e);
            }
        });
        GridBagConstraints treeConstraints = new GridBagConstraints();
        treeConstraints.gridx = 0;
        treeConstraints.gridy = 0;
        treeConstraints.gridwidth = 3;
        treeConstraints.gridheight = 1;
        treeConstraints.fill = 1;
        treeConstraints.anchor = 10;
        treeConstraints.weightx = 1.0;
        treeConstraints.weighty = 1.0;
        treeConstraints.insets = new Insets(8, 8, 8, 8);
        this.getContentPane().add((Component)scrolledTree, treeConstraints);
        GridBagConstraints runConstraints = new GridBagConstraints();
        runConstraints.gridx = 0;
        runConstraints.gridy = 1;
        runConstraints.gridwidth = 1;
        runConstraints.gridheight = 1;
        runConstraints.anchor = 13;
        runConstraints.weightx = 0.0;
        runConstraints.weighty = 0.0;
        runConstraints.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fRun, runConstraints);
        GridBagConstraints reloadConstraints = new GridBagConstraints();
        reloadConstraints.gridx = 1;
        reloadConstraints.gridy = 1;
        reloadConstraints.gridwidth = 1;
        reloadConstraints.gridheight = 1;
        reloadConstraints.anchor = 13;
        reloadConstraints.weightx = 0.0;
        reloadConstraints.weighty = 0.0;
        reloadConstraints.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fReload, reloadConstraints);
        GridBagConstraints closeConstraints = new GridBagConstraints();
        closeConstraints.gridx = 2;
        closeConstraints.gridy = 1;
        closeConstraints.gridwidth = 1;
        closeConstraints.gridheight = 1;
        closeConstraints.anchor = 13;
        closeConstraints.weightx = 0.0;
        closeConstraints.weighty = 0.0;
        closeConstraints.insets = new Insets(0, 8, 8, 8);
        this.getContentPane().add((Component)this.fClose, closeConstraints);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                TestBrowser.this.dispose();
            }
        });
    }

    public void addError(Test test, Throwable t) {
        this.fModel.addError(test);
        this.fireTestChanged(test, true);
    }

    public void addFailure(Test test, Throwable t) {
        this.fModel.addFailure(test);
        this.fireTestChanged(test, true);
    }

    public void endTest(Test test) {
        this.fModel.addRunTest(test);
        this.fireTestChanged(test, false);
    }

    public void startTest(Test test) {
    }

    public void checkEnableRun(TreeSelectionEvent e) {
        this.fRun.setEnabled(this.fTree.getSelectionCount() == 1);
    }

    public TestListener getTestListener() {
        return this;
    }

    public void runSelection() {
        this.fModel.resetResults();
        TreePath[] paths = this.fTree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            this.fRunner.runTest((Test)path.getLastPathComponent());
            ++i;
        }
    }

    public void reloadTestTree() {
        Test t = this.fRunner.getTest(this.fRunner.getSuiteText());
        this.showTestTree(t);
    }

    public void showTestTree(Test root) {
        this.fModel = new TestTreeModel(root);
        this.fTree.setModel(this.fModel);
        this.fTree.setCellRenderer(new TestTreeCellRenderer());
    }

    private void fireTestChanged(final Test test, final boolean expand) {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                Vector vpath = new Vector();
                int index = TestBrowser.this.fModel.findTest(test, (Test)TestBrowser.this.fModel.getRoot(), vpath);
                if (index >= 0) {
                    Object[] path = new Object[vpath.size()];
                    vpath.copyInto(path);
                    TreePath treePath = new TreePath(path);
                    TestBrowser.this.fModel.fireNodeChanged(treePath, index);
                    if (expand) {
                        Object child = TestBrowser.this.fModel.getChild(treePath.getLastPathComponent(), index);
                        Object[] fullPath = new Object[vpath.size() + 1];
                        vpath.copyInto(fullPath);
                        fullPath[vpath.size()] = child;
                        TreePath fullTreePath = new TreePath(fullPath);
                        TestBrowser.this.fTree.scrollPathToVisible(fullTreePath);
                    }
                }
            }
        });
    }

    static class TestTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon fErrorIcon;
        private ImageIcon fOkIcon;
        private ImageIcon fFailureIcon;

        TestTreeCellRenderer() {
            URL url = this.getClass().getResource("error.gif");
            this.fErrorIcon = new ImageIcon(url);
            url = this.getClass().getResource("ok.gif");
            this.fOkIcon = new ImageIcon(url);
            url = this.getClass().getResource("failure.gif");
            this.fFailureIcon = new ImageIcon(url);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreeModel model = tree.getModel();
            if (model instanceof TestTreeModel) {
                TestTreeModel testModel = (TestTreeModel)model;
                Test t = (Test)value;
                String s = "";
                if (testModel.isFailure(t)) {
                    this.setIcon(this.fFailureIcon);
                    s = " - Failed";
                } else if (testModel.isError(t)) {
                    this.setIcon(this.fErrorIcon);
                    s = " - Error";
                } else if (testModel.wasRun(t)) {
                    this.setIcon(this.fOkIcon);
                    s = " - Passed";
                }
                if (c instanceof JComponent) {
                    ((JComponent)c).setToolTipText(String.valueOf(this.getText()) + s);
                }
            }
            return c;
        }
    }
}

