/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient NodeIterator m_nodeSet;
    private transient Node m_peek = null;

    public FilterExprWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public short acceptNode(Node node) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(node, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker filterExprWalker = (FilterExprWalker)super.clone();
        if (this.m_nodeSet != null) {
            filterExprWalker.m_nodeSet = (NodeIterator)((ContextNodeList)((Object)this.m_nodeSet)).clone();
        }
        return filterExprWalker;
    }

    protected int getLevelMax() {
        return 1;
    }

    public Node getNextNode() {
        Node node;
        if (this.m_peek != null) {
            node = this.m_peek;
            this.m_peek = null;
        } else if (this.m_nodeSet != null) {
            Node node2 = this.getCurrentNode();
            if (node2 instanceof NodeTestFilter) {
                ((NodeTestFilter)((Object)node2)).setNodeTest(this);
            }
            node = this.m_nodeSet.nextNode();
        } else {
            node = null;
        }
        this.m_nextLevelAmount = node == null ? 0 : (node.hasChildNodes() ? 1 : 0);
        return this.setCurrentIfNotNull(node);
    }

    public void init(Compiler compiler, int n, int n2) throws TransformerException {
        super.init(compiler, n, n2);
        switch (n2) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(n);
                break;
            }
            default: {
                this.m_expr = compiler.compile(n + 2);
            }
        }
    }

    public void setRoot(Node node) {
        XPathContext xPathContext = this.m_lpi.getXPathContext();
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        try {
            try {
                XObject xObject;
                xPathContext.pushCurrentNode(node);
                xPathContext.setNamespaceContext(this.m_lpi.getPrefixResolver());
                if (this.m_lpi.getIsTopLevel()) {
                    VariableStack variableStack = this.m_lpi.m_execContext.getVarStack();
                    int n = variableStack.getSearchStart();
                    variableStack.setSearchStart(this.m_lpi.m_varStackPos);
                    variableStack.pushContextPosition(this.m_lpi.m_varStackContext);
                    xObject = this.m_expr.execute(this.m_lpi.getXPathContext());
                    variableStack.setSearchStart(n);
                    variableStack.popContextPosition();
                } else {
                    xObject = this.m_expr.execute(this.m_lpi.getXPathContext());
                }
                this.m_nodeSet = xObject != null ? xObject.nodeset() : null;
                this.m_peek = null;
            }
            catch (TransformerException transformerException) {
                throw new WrappedRuntimeException(transformerException);
            }
            Object var5_8 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
            throw throwable;
        }
        super.setRoot(node);
    }
}

