/* xm.c: Guile/Ruby bindings for X/Xt/Xpm/Xm/Xp
 *   needs xen.h
 *   for tests and examples see snd-motif.scm and snd-test.scm
 */

/* SOMEDAY: finish selection-oriented Xt callbacks
 * SOMEDAY: XmVaCreateSimple* (need special arglist handlers)
 * TODO: callback struct print (and tie makers into Ruby)
 * TODO: finish the -> converters
 * TODO: add_resource
 * SOMEDAY: get Xprt to work and test the Xp stuff
 */

/* HISTORY: 
 *   29-Mar:    XmParseProc.
 *   20-Mar:    XpmGetErrorString omitted inadvertently earlier.
 *   4-Mar:     XWindowChanges and XSetWindowAttributes struct creators.
 *   1-Mar:     XmTabListFree, various ->* conversions.
 *   25-Feb:    XmTextBlock fields
 *   22-Feb:    #f = NULL and vice-versa throughout
 *   21-Feb:    added various callback struct makers, changed XtCallCallbacks to be compatible with them.
 *   18-Feb:    removed undocumented functions: XmCvtFromHorizontalPixels, XmCvtFromVerticalPixels, XmCvtToHorizontalPixels, XInitImage
 *                XmCvtToVerticalPixels, XmGetIconFileName, XmStringCreateFontList, XmStringCreateFontList_r, XmStringLtoRCreate
 *              added XM_DISABLE_DEPRECATED which affects:
 *                XtError, XtSetErrorHandler, XtSetWarningHandler, XtSetErrorMsgHandler, XtSetWarningMsgHandler, XtWarningMsg, XtAppWarning, XtErrorMsg
 *                XtSetSelectionTimeout, XtInitialize , XtAddActions, XtAddInput, XtAddTimeout, XtAddWorkProc, XtCreateApplicationShell
 *                XtNextEvent, XtPeekEvent, XtPending, XtProcessEvent, XtMainLoop, XtGetSelectionTimeout, XtWarning,
 *                XmNdefaultFontList, XmNshellUnitType, XmNfontList, XmFontList*, XmNchildType, XmGetMenuCursor, 
 *                XmNstringDirection, XmListGetSelectedPos, XmMainWindowSep1, XmMainWindowSep2, XmMainWindowSep3, XmMainWindowSetAreas, 
 *                XmNwhichButton, XmScrolledWindowSetAreas, XmSetFontUnit, XmSetFontUnits, XmNdefaultFontList, 
 *                XmSetMenuCursor, XmStringByteCompare, XmStringCreateLtoR, XmSTRING_COMPONENT_CHARSET, XmSTRING_COMPONENT_FONTLIST_ELEMENT_TAG,
 *                XmStringCreateSimple, XmStringGetLtoR, XmStringGetNextComponent, XmStringGetNextSegment, XmStringLength, XmStringNConcat
 *                XmStringNCopy, XmStringPeekNextComponent, XmStringSegmentCreate, XmTrackingLocate, XmRemoveFrom|AddTo|PostFromList
 *              added XmWidgetGetDisplayRect inadvertently omitted earlier.
 *   14-Feb:    XUniqueContext added, XExtentsOfFontSet and XGetErrorDatabaseText deleted.
 *              X save-set and X host-address stuff deleted.
 *              XVisualInfo fields added. 
 *              Cursor type added.
 *   1-Feb:     Motif 2.2 additions (tooltip).
 *   21-Jan:    Ruby fixups (XEN_COPY_ARG to protect lists)
 *   7-Jan-02:  XEvent fields settable. added XtCallCallbacks-raw.
 *   12-Sep:    xm-version.
 *   13-Aug:    Xp bindings, X11 predefined Atoms.
 *   6-Aug:     XmTransfer functions inadvertently omitted earlier.
 *   3-Aug:     type checks in XtSetValues.
 *   23-Jul-01: use lists rather than vectors.
 */

#if defined(HAVE_CONFIG_H)
  #include "config.h"
#endif

#if HAVE_MOTIF
  #include <Xm/XmAll.h>
#else
  #include <X11/Xlib.h>
  #include <X11/Intrinsic.h>
  #include <X11/Shell.h>
  #include <X11/Xatom.h>
#endif

#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <stdio.h>

/* compile-time flags are HAVE_XPM  HAVE_MOTIF  HAVE_XP  HAVE_GUILE|HAVE_RUBY  XM_DISABLE_DEPRECATED */

/* if the loader complains about XtIsSubClass, define NEED_XtIsSubClass */
/* I haven't managed to get this to work with Lesstif -- probably just a matter of a million HAVE_<mumble> macros */
  
/* if you're using g++ and it complains about XmRemoveFromPostFromList, update Motif (you need 2.1.30) */

#if USE_SND
  /* USE_SND causes xm to use Snd's error handlers which are much smarter than xen's fallback versions */
  #include "snd.h"
#else
  #include "xen.h"
#endif
#ifndef CALLOC
  #define CALLOC(a, b)  calloc((size_t)(a), (size_t)(b))
  #define FREE(a)       free(a)
#endif

#if HAVE_XPM
  #include <X11/xpm.h>
#endif

/* prefix for all names */
#if HAVE_GUILE
  #define XM_PREFIX "|"
  #define XM_POSTFIX ""
#else
/* for Ruby, XM PREFIX needs to be uppercase */
  #define XM_PREFIX "R"
  #define XM_POSTFIX ""
#endif

#if HAVE_MOTIF
  #define MOTIF_2 (XmVERSION >= 2)
  /* 2.1 really -- I don't have a test system for 2.0 -- I'm using LessTif's headers to blindly check 1.2 */
  #ifdef XmNtoolTipString
    #define MOTIF_2_2 1
  #endif
#endif


/* layout of file:
 *    preliminaries
 *    type manglers
 *    arglist handlers
 *    Motif procedures
 *    X procedures
 *    Xt procedures
 *    Xp procedures
 *    Xpm procedures
 *    struct handlers
 *    string constants
 *    integer constants
 *    pointer constants
 *    atom constants
 */

/* --------------------------------------------------------------------------------
 * a sample program (using "|" as prefix)

(let* ((shell-app (|XtVaOpenApplication 
		    "Test" 0 0 0 '() 0 |applicationShellWidgetClass
		    (list |XmNallowShellResize #t)))
       (app (cadr shell-app))
       (shell (car shell-app))
       (black (|BlackPixelOfScreen 
		(|DefaultScreenOfDisplay 
		  (|XtDisplay shell)))))
  (if (not (|XtIsApplicationShell shell))
      (display "not appshell"?))
  (|XtSetValues shell (list |XmNtitle "Hi!"))
  (let* ((main-pane 
	  (|XtVaCreateManagedWidget 
	    "main-pane" |xmFormWidgetClass shell
	    (list |XmNforeground       black
		  |XmNtopAttachment    |XmATTACH_FORM
		  |XmNbottomAttachment |XmATTACH_FORM
		  |XmNleftAttachment   |XmATTACH_FORM
		  |XmNrightAttachment  |XmATTACH_FORM
		  |XmNallowResize      #t)))
	 (button (|XtCreateManagedWidget 
		   "push me" |xmPushButtonWidgetClass main-pane '() 0)))
    (|XtAddCallback button |XmNactivateCallback 
		    (lambda (widget context event-info)
		      (display widget)
		      (display (|reason event-info))
		      (display context))
		    123)
    (|XtRealizeWidget shell)
    (|XtAppMainLoop app)))
 */


/* --------------------------------------------------------------------------------
 * differences from C:
 *
 *    Arg list is lisp list of name/value pairs and the "len" arg associated with it is optional
 *    ref args are usually returned by proc, and not passed in unless init val is needed
 *    array args are passed as lists, returned as lists
 *    pointers to structs are '(type val) where val is opaque except via accessors 
 *      that is, all non-simple types are lists in xm where the first element is a symbol describing the type
 *      and the second is usually the C value stored directly as an unsigned long
 *    "Va" args are passed and returned as lists
 *    XtCallback procedure args are passed by value
 *    various "client data" args are optional
 *    XtCallbackLists are passed as lists of procedure/data pairs
 *    where explicit NULL is needed as arg, use #f (or '() for list args)
 *
 * omitted:       
 *
 *    Xwc*, Xrm*, XIM*, XOM*, XIC*, XOC*, Xcms*, 
 *    "resource" handlers and "quark" stuff (XtAppSetTypeConverter etc)
 *    all XTextProperty, XClassHint, XSizeHints support, XSetIconSizes
 *    XConnection internal stuff, XVaCreateNestedList, XSetAuthorization
 *    XtQueryGeometry and XtMakeGeometryRequest, all text16 stuff
 *    XtGetKeySymTable, XtChangeManagedSet (undocumented), XtAppGet|SetExitFlag
 *    XtSetEventDispatcher (undoc), XtSignal stuff (undoc), XtGetErrorDatabaseText
 *    XtBlockHook stuff (undoc), XtRegisterExtensionSelector (undoc)
 *    XmResolvePartOffsets, XmResolveAllPartOffsets
 *    XpSet|GetLocaleHinter
 *    XtHooksOfDisplay, XtRegiserDrawable, XtUnregisterDrawable
 *
 * added:
 *
 *    Widget w -> bare Widget (pointer) wrapped for xm 
 *    XtAppContext app -> bare XtAppContext (pointer) wrapped for xm 
 *    XGCValues -> a blank XGCValues struct (for XCreateGC etc)
 *    XColor &optional pixel red green blue flags pad
 *    XArc XRectangle XPoint XSegment XEvent Pixel GC XWindowChanges XSetWindowAttributes
 *    XTextItem XpmImage XpmColorSymbol
 *    XDrawLinesDirect same as XDrawLines but takes (opaque) ptr to XPoint array
 *    vector->XPoints vect packages point data in vector as (opaque) array of XPoints 
 *    freeXPoints to free (opaque) XPoint array created by vector->Xpoints
 *    moveXPoints to move XPoint array created by vector->Xpoints
 *    <name>? -> #t if arg is of type <name>
 *    <name> -> empty struct of type <name>
 *
 * Structs are accessed by the field name and the lisp variable (which contains the struct type)
 *   (|pixel color) for example, or (|foreground gcvalue)
 */
 


/* -------------------------------- smob for GC -------------------------------- */

/* "smob" for locally created stuff (X graphics entities mainly) */

static char *xm_obj_to_string(XEN obj); /* see structs (far) below */

static XEN_OBJECT_TYPE xm_obj_tag;

#if HAVE_GUILE
static size_t xm_obj_free(XEN obj)
{
  FREE((void *)XEN_OBJECT_REF(obj));
  return(0);
}
#endif
#if HAVE_RUBY
static void *xm_obj_free(XEN obj)
{
  FREE((void *)obj);
  return(NULL);
}
#endif

static XEN make_xm_obj(void *ptr)
{
  XEN_MAKE_AND_RETURN_OBJECT(xm_obj_tag, ptr, 0, xm_obj_free);
}

static void define_xm_obj(void)
{
  xm_obj_tag = XEN_MAKE_OBJECT_TYPE("XmObj", sizeof(void *));
#if HAVE_GUILE
  scm_set_smob_free(xm_obj_tag, xm_obj_free);
#endif
}  


/* -------------------------------- type manglers -------------------------------- */

/* most non-simple vars are handled as a list: (type ptr) where ptr is the (un-interpreted) C value
 *   the _OBJ form is used where we need to eventually free the memory
 *   the _PTR form treats NULL as #f and vice-versa
 */

#define WRAP_FOR_XEN(Name, Value) XEN_LIST_2(C_STRING_TO_XEN_SYMBOL(Name), C_TO_XEN_ULONG((unsigned long)Value))
#define WRAP_FOR_XEN_OBJ(Name, Value) XEN_LIST_3(C_STRING_TO_XEN_SYMBOL(Name), C_TO_XEN_ULONG((unsigned long)Value), make_xm_obj(Value))
#define WRAP_P(Name, Value) (XEN_LIST_P(Value) && \
                            (XEN_LIST_LENGTH(Value) >= 2) && \
                            (XEN_SYMBOL_P(XEN_CAR(Value))) && \
                            (strcmp(Name, XEN_SYMBOL_TO_C_STRING(XEN_CAR(Value))) == 0))

#define XM_TYPE(Name, XType) \
  static XEN C_TO_XEN_ ## Name (XType val) {return(WRAP_FOR_XEN(#Name, val));} \
  static XType XEN_TO_C_ ## Name (XEN val) {return((XType)XEN_TO_C_ULONG(XEN_CADR(val)));} \
  static int XEN_ ## Name ## _P(XEN val) {return(WRAP_P(#Name, val));} \
  static XEN XEN_ ## Name ## _p(XEN val) {return(C_TO_XEN_BOOLEAN(WRAP_P(#Name, val)));}

#define XM_TYPE_PTR(Name, XType) \
  static XEN C_TO_XEN_ ## Name (XType val) {if (val) return(WRAP_FOR_XEN(#Name, val)); return(XEN_FALSE);} \
  static XType XEN_TO_C_ ## Name (XEN val) {if (XEN_FALSE_P(val)) return((XType)NULL); return((XType)XEN_TO_C_ULONG(XEN_CADR(val)));} \
  static int XEN_ ## Name ## _P(XEN val) {return(WRAP_P(#Name, val));} \
  static XEN XEN_ ## Name ## _p(XEN val) {return(C_TO_XEN_BOOLEAN(WRAP_P(#Name, val)));}

#define XM_TYPE_PTR_OBJ(Name, XType) \
  static XEN C_TO_XEN_ ## Name (XType val) {if (val) return(WRAP_FOR_XEN_OBJ(#Name, val)); return(XEN_FALSE);} \
  static XType XEN_TO_C_ ## Name (XEN val) {if (XEN_FALSE_P(val)) return(NULL); return((XType)XEN_TO_C_ULONG(XEN_CADR(val)));} \
  static int XEN_ ## Name ## _P(XEN val) {return(WRAP_P(#Name, val));} \
  static XEN XEN_ ## Name ## _p(XEN val) {return(C_TO_XEN_BOOLEAN(WRAP_P(#Name, val)));}


#define XEN_TO_C_Dimension(Arg)  (Dimension)(XEN_TO_C_INT(Arg))
#define C_TO_XEN_Dimension(Arg)  (C_TO_XEN_INT((int)Arg))
#define XEN_Dimension_P(Arg)     (XEN_INTEGER_P(Arg))

#define XEN_TO_C_Position(Arg)   (Position)(XEN_TO_C_INT(Arg))
#define C_TO_XEN_Position(Arg)   (C_TO_XEN_INT((int)Arg))
#define XEN_Position_P(Arg)      (XEN_INTEGER_P(Arg))

#define XEN_TO_C_char(Arg)       (char)(XEN_TO_C_INT(Arg))
#define C_TO_XEN_char(Arg)       (C_TO_XEN_INT(Arg))
#define XEN_char_P(Arg)          (XEN_INTEGER_P(Arg))

#define XEN_TO_C_Modifiers(Arg)  (Modifiers)(XEN_TO_C_ULONG(Arg))
#define C_TO_XEN_Modifiers(Arg)  (C_TO_XEN_ULONG(Arg))
#define XEN_Modifiers_P(Arg)     (XEN_ULONG_P(Arg))

XM_TYPE(Cursor, Cursor)
XM_TYPE_PTR(Screen, Screen *)
XM_TYPE_PTR_OBJ(XRectangle, XRectangle *)
XM_TYPE_PTR_OBJ(XArc, XArc *)
XM_TYPE_PTR_OBJ(XPoint, XPoint *)
XM_TYPE_PTR_OBJ(XSegment, XSegment *)
XM_TYPE_PTR_OBJ(XColor, XColor *)
XM_TYPE(Atom, Atom)
XM_TYPE_PTR(Colormap, Colormap)
XM_TYPE_PTR(Depth, Depth *)
XM_TYPE_PTR(Display, Display *)
XM_TYPE(Font, Font)
XM_TYPE(GC, GC)
XM_TYPE(KeySym, KeySym)
XM_TYPE(Pixel, Pixel)
XM_TYPE(Pixmap, Pixmap)
XM_TYPE(Region, Region)
XM_TYPE(Time, Time)
XM_TYPE_PTR(Visual, Visual *)
XM_TYPE_PTR(Window, Window)
XM_TYPE_PTR(XCharStruct, XCharStruct *)
XM_TYPE_PTR(XFontProp, XFontProp *)
XM_TYPE(XFontSet, XFontSet)
XM_TYPE_PTR(XFontStruct, XFontStruct *)
XM_TYPE_PTR(XGCValues, XGCValues *)
XM_TYPE_PTR(XTextItem, XTextItem *)
XM_TYPE_PTR(XModifierKeymap, XModifierKeymap *) /* opaque in this implementation */
XM_TYPE_PTR(XImage, XImage *)
static XAnyEvent *XEN_TO_C_XAnyEvent(XEN val) {return((XAnyEvent *)XEN_TO_C_ULONG(XEN_CADR(val)));}
XM_TYPE_PTR(XButtonEvent, XButtonEvent *)
XM_TYPE_PTR(XCirculateEvent, XCirculateEvent *)
XM_TYPE_PTR(XCirculateRequestEvent, XCirculateRequestEvent *)
XM_TYPE_PTR(XClientMessageEvent, XClientMessageEvent *)
XM_TYPE_PTR(XColormapEvent, XColormapEvent *)
XM_TYPE_PTR(XConfigureEvent, XConfigureEvent *)
XM_TYPE_PTR(XConfigureRequestEvent, XConfigureRequestEvent *)
XM_TYPE_PTR(XCreateWindowEvent, XCreateWindowEvent *)
XM_TYPE_PTR(XCrossingEvent, XCrossingEvent *)
XM_TYPE_PTR(XDestroyWindowEvent, XDestroyWindowEvent *)
XM_TYPE_PTR(XErrorEvent, XErrorEvent *)
XM_TYPE_PTR(XExposeEvent, XExposeEvent *)
XM_TYPE_PTR(XFocusChangeEvent, XFocusChangeEvent *)
XM_TYPE_PTR(XGraphicsExposeEvent, XGraphicsExposeEvent *)
XM_TYPE_PTR(XGravityEvent, XGravityEvent *)
XM_TYPE_PTR(XKeyEvent, XKeyEvent *)
XM_TYPE_PTR(XKeymapEvent, XKeymapEvent *)
XM_TYPE_PTR(XMapEvent, XMapEvent *)
XM_TYPE_PTR(XMapRequestEvent, XMapRequestEvent *)
XM_TYPE_PTR(XMappingEvent, XMappingEvent *)
XM_TYPE_PTR(XMotionEvent, XMotionEvent *)
XM_TYPE_PTR(XNoExposeEvent, XNoExposeEvent *)
XM_TYPE_PTR(XPropertyEvent, XPropertyEvent *)
XM_TYPE_PTR(XReparentEvent, XReparentEvent *)
XM_TYPE_PTR(XResizeRequestEvent, XResizeRequestEvent *)
XM_TYPE_PTR(XSelectionClearEvent, XSelectionClearEvent *)
XM_TYPE_PTR(XSelectionEvent, XSelectionEvent *)
XM_TYPE_PTR(XSelectionRequestEvent, XSelectionRequestEvent *)
XM_TYPE_PTR(XUnmapEvent, XUnmapEvent *)
XM_TYPE_PTR(XVisibilityEvent, XVisibilityEvent *)
XM_TYPE_PTR_OBJ(XSetWindowAttributes, XSetWindowAttributes *)
XM_TYPE_PTR(XVisualInfo, XVisualInfo *)
XM_TYPE_PTR(XWMHints, XWMHints *)
XM_TYPE_PTR(XWindowAttributes, XWindowAttributes *)
XM_TYPE_PTR_OBJ(XWindowChanges, XWindowChanges *)
XM_TYPE_PTR(XStandardColormap, XStandardColormap *)
XM_TYPE(KeyCode, KeyCode)
XM_TYPE(XContext, XContext)
XM_TYPE(Substitution, Substitution)
XM_TYPE_PTR(XIconSize, XIconSize *)

#if HAVE_XP
XM_TYPE(XPContext, XPContext)
#endif

#if HAVE_MOTIF
XM_TYPE_PTR(Widget, Widget)
XM_TYPE(WidgetClass, WidgetClass)
XM_TYPE(XtAppContext, XtAppContext)
XM_TYPE(XtRequestId, XtRequestId)
XM_TYPE(XtWorkProcId, XtWorkProcId)
XM_TYPE(XtInputId, XtInputId)
XM_TYPE(XtIntervalId, XtIntervalId)
XM_TYPE(XtActionHookId, XtActionHookId)
XM_TYPE(XtTranslations, XtTranslations)
XM_TYPE_PTR(XmString, XmString)
XM_TYPE_PTR(XmAnyCallbackStruct, XmAnyCallbackStruct *)
XM_TYPE_PTR(XmArrowButtonCallbackStruct, XmArrowButtonCallbackStruct *)
XM_TYPE_PTR(XmCommandCallbackStruct, XmCommandCallbackStruct *)
XM_TYPE_PTR(XmDragDropFinishCallbackStruct, XmDragDropFinishCallbackStruct *)
XM_TYPE_PTR(XmDragMotionCallbackStruct, XmDragMotionCallbackStruct *)
XM_TYPE_PTR(XmDragProcCallbackStruct, XmDragProcCallbackStruct *)
XM_TYPE_PTR(XmDrawingAreaCallbackStruct, XmDrawingAreaCallbackStruct *)
XM_TYPE_PTR(XmDrawnButtonCallbackStruct, XmDrawnButtonCallbackStruct *)
XM_TYPE_PTR(XmDropFinishCallbackStruct, XmDropFinishCallbackStruct *)
XM_TYPE_PTR(XmDropProcCallbackStruct, XmDropProcCallbackStruct *)
XM_TYPE_PTR(XmDropSiteEnterCallbackStruct, XmDropSiteEnterCallbackStruct *)
XM_TYPE_PTR(XmDropSiteLeaveCallbackStruct, XmDropSiteLeaveCallbackStruct *)
XM_TYPE_PTR(XmDropStartCallbackStruct, XmDropStartCallbackStruct *)
XM_TYPE_PTR(XmFileSelectionBoxCallbackStruct, XmFileSelectionBoxCallbackStruct *)
XM_TYPE_PTR(XmListCallbackStruct, XmListCallbackStruct *)
#if MOTIF_2
XM_TYPE(XmTab, XmTab) /*opaque */
XM_TYPE_PTR(XmDragStartCallbackStruct, XmDragStartCallbackStruct *)
XM_TYPE_PTR(XmDisplayCallbackStruct, XmDisplayCallbackStruct *)
XM_TYPE_PTR(XmDestinationCallbackStruct, XmDestinationCallbackStruct *)
XM_TYPE_PTR(XmConvertCallbackStruct, XmConvertCallbackStruct *)
XM_TYPE_PTR(XmComboBoxCallbackStruct, XmComboBoxCallbackStruct *)
XM_TYPE_PTR(XmContainerOutlineCallbackStruct, XmContainerOutlineCallbackStruct *)
XM_TYPE_PTR(XmContainerSelectCallbackStruct, XmContainerSelectCallbackStruct *)
XM_TYPE_PTR(XmNotebookCallbackStruct, XmNotebookCallbackStruct *)
XM_TYPE_PTR_OBJ(XmNotebookPageInfo, XmNotebookPageInfo *)
XM_TYPE_PTR(XmRenderTable, XmRenderTable)
XM_TYPE_PTR(XmRendition, XmRendition)
XM_TYPE_PTR(XmSpinBoxCallbackStruct, XmSpinBoxCallbackStruct *)
XM_TYPE_PTR(XmTraverseObscuredCallbackStruct, XmTraverseObscuredCallbackStruct *)
XM_TYPE_PTR(XmTopLevelLeaveCallbackStruct, XmTopLevelLeaveCallbackStruct *)
XM_TYPE_PTR(XmTopLevelEnterCallbackStruct, XmTopLevelEnterCallbackStruct *)
#if HAVE_XP
XM_TYPE_PTR(XmPrintShellCallbackStruct, XmPrintShellCallbackStruct *)
#endif
XM_TYPE_PTR(XmPopupHandlerCallbackStruct, XmPopupHandlerCallbackStruct *)
XM_TYPE_PTR(XmSelectionCallbackStruct, XmSelectionCallbackStruct *)
XM_TYPE_PTR(XmTransferDoneCallbackStruct, XmTransferDoneCallbackStruct *)
XM_TYPE_PTR(XmTabList, XmTabList) /* opaque */
XM_TYPE(XmParseMapping, XmParseMapping)
#endif
XM_TYPE_PTR(XmOperationChangedCallbackStruct, XmOperationChangedCallbackStruct *)
XM_TYPE_PTR(XmPushButtonCallbackStruct, XmPushButtonCallbackStruct *)
XM_TYPE_PTR(XmRowColumnCallbackStruct, XmRowColumnCallbackStruct *)
XM_TYPE_PTR(XmScaleCallbackStruct, XmScaleCallbackStruct *)
XM_TYPE_PTR(XmScrollBarCallbackStruct, XmScrollBarCallbackStruct *)
XM_TYPE_PTR(XmSelectionBoxCallbackStruct, XmSelectionBoxCallbackStruct *)
XM_TYPE_PTR(XmTextVerifyCallbackStruct, XmTextVerifyCallbackStruct *)
XM_TYPE_PTR(XmTextBlock, XmTextBlock)
XM_TYPE_PTR(XmToggleButtonCallbackStruct, XmToggleButtonCallbackStruct *)
#if (!XM_DISABLE_DEPRECATED)
  XM_TYPE(XmFontContext, XmFontContext) /* opaque */
  XM_TYPE(XmFontList, XmFontList) /* opaque, obsolete == XmRenderTable in motif 2 */
  XM_TYPE(XmFontListEntry, XmFontListEntry) /* opaque */
#else
  #define XEN_TO_C_XmFontList(Arg) XEN_TO_C_XmRenderTable(Arg)
#endif
XM_TYPE(XmTextSource, XmTextSource)
XM_TYPE(XmStringContext, XmStringContext)

static int XEN_XmFontList_or_XmRenderTable_P(XEN arg)
{
#if (!XM_DISABLE_DEPRECATED)
#if MOTIF_2
  return(XEN_XmFontList_P(arg) || XEN_XmRenderTable_P(arg));
#else
  return(XEN_XmFontList_P(arg));
#endif
#else
  return(XEN_XmRenderTable_P(arg));
#endif
}
#endif

static XEN type_to_event_symbol(int utype)
{
  char *type;
  type = "XErrorEvent"; /* -1 for an error event? */
  switch (utype)
    {
    case 0:                type = "XAnyEvent"; break;
    case KeyPress:
    case KeyRelease:       type = "XKeyEvent"; break;
    case ButtonPress:
    case ButtonRelease:    type = "XButtonEvent"; break;
    case MotionNotify:     type = "XMotionEvent"; break;
    case EnterNotify:
    case LeaveNotify:      type = "XCrossingEvent"; break;
    case FocusIn:
    case FocusOut:         type = "XFocusChangeEvent"; break;
    case KeymapNotify:     type = "XKeymapEvent"; break;
    case Expose:           type = "XExposeEvent"; break;
    case GraphicsExpose:   type = "XGraphicsExposeEvent"; break;
    case NoExpose:         type = "XNoExposeEvent"; break;
    case VisibilityNotify: type = "XVisibilityEvent"; break;
    case CreateNotify:     type = "XCreateWindowEvent"; break;
    case DestroyNotify:    type = "XDestroyWindowEvent"; break;
    case UnmapNotify:      type = "XUnmapEvent"; break;
    case MapNotify:        type = "XMapEvent"; break;
    case MapRequest:       type = "XMapRequestEvent"; break;
    case ReparentNotify:   type = "XReparentEvent"; break;
    case ConfigureNotify:  type = "XConfigureEvent"; break;
    case ConfigureRequest: type = "XConfigureRequestEvent"; break;
    case GravityNotify:    type = "XGravityEvent"; break;
    case ResizeRequest:    type = "XResizeRequestEvent"; break;
    case CirculateNotify:  type = "XCirculateEvent"; break;
    case CirculateRequest: type = "XCirculateRequestEvent"; break;
    case PropertyNotify:   type = "XPropertyEvent"; break;
    case SelectionClear:   type = "XSelectionClearEvent"; break;
    case SelectionRequest: type = "XSelectionRequestEvent"; break;
    case SelectionNotify:  type = "XSelectionEvent"; break;
    case ColormapNotify:   type = "XColormapEvent"; break;
    case ClientMessage:    type = "XClientMessageEvent"; break;
    case MappingNotify:    type = "XMappingEvent"; break;
    }
  return(C_STRING_TO_XEN_SYMBOL(type));
}

static XEN C_TO_XEN_XEvent_1(XEvent *e, int need_free)
{
  if (need_free)
    return(XEN_LIST_4(type_to_event_symbol(e->type),
		      C_TO_XEN_ULONG((unsigned long)e),
		      make_xm_obj(e),
		      C_STRING_TO_XEN_SYMBOL("XEvent")));
  return(XEN_LIST_4(type_to_event_symbol(e->type),
		    C_TO_XEN_ULONG((unsigned long)e),
		    XEN_FALSE,
		    C_STRING_TO_XEN_SYMBOL("XEvent")));
}


#define C_TO_XEN_XEvent(e)     C_TO_XEN_XEvent_1(e, FALSE)
#define C_TO_XEN_XEvent_OBJ(e) C_TO_XEN_XEvent_1(e, TRUE)
#define XEN_TO_C_XEvent(Arg)   (XEvent *)XEN_TO_C_ULONG(XEN_CADR(Arg))
#define XEN_XEvent_P(Value)    (XEN_LIST_P(Value) &&\
                               (XEN_LIST_LENGTH(Value) == 4) &&\
                               (XEN_SYMBOL_P(XEN_CADDDR(Value))) &&\
                               (strcmp("XEvent", XEN_SYMBOL_TO_C_STRING(XEN_CADDDR(Value))) == 0))

static XEN XEN_XEvent_p(XEN val) 
{
  return(C_TO_XEN_BOOLEAN(XEN_XEvent_P(val)));
}

static XEN gxm_XEvent(XEN type)
{
  XEvent *e;
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(type), type, XEN_ONLY_ARG, "XEvent", "an X event type (integer)");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  e->type = XEN_TO_C_INT_OR_ELSE(type, 0);
  return(XEN_LIST_4(type_to_event_symbol(e->type),
		    C_TO_XEN_ULONG((unsigned long)e),
		    make_xm_obj(e),
		    C_STRING_TO_XEN_SYMBOL("XEvent")));
}

static XEN gxm_XGCValues(void) 
{
  XGCValues *e;
  e = (XGCValues *)CALLOC(1, sizeof(XGCValues));
  return(WRAP_FOR_XEN_OBJ("XGCValues", e));
}

#if HAVE_MOTIF
#define XM_Make(Name) \
  static XEN gxm_ ## Name (void) {Name *e; e = (Name *)CALLOC(1, sizeof(Name)); return(WRAP_FOR_XEN_OBJ(#Name, e));}
#define XM_Declare(Name) \
  XEN_DEFINE_PROCEDURE(XM_PREFIX #Name XM_POSTFIX, gxm_ ## Name, 0, 0, 0, "Make an " #Name " struct")

XM_Make(XmAnyCallbackStruct)
XM_Make(XmArrowButtonCallbackStruct)
XM_Make(XmCommandCallbackStruct)
XM_Make(XmDragDropFinishCallbackStruct)
XM_Make(XmDragMotionCallbackStruct)
XM_Make(XmDragProcCallbackStruct)
XM_Make(XmDrawingAreaCallbackStruct)
XM_Make(XmDrawnButtonCallbackStruct)
XM_Make(XmDropFinishCallbackStruct)
XM_Make(XmDropProcCallbackStruct)
XM_Make(XmDropSiteEnterCallbackStruct)
XM_Make(XmDropSiteLeaveCallbackStruct)
XM_Make(XmDropStartCallbackStruct)
XM_Make(XmFileSelectionBoxCallbackStruct)
XM_Make(XmListCallbackStruct)
XM_Make(XmOperationChangedCallbackStruct)
XM_Make(XmPushButtonCallbackStruct)
XM_Make(XmRowColumnCallbackStruct)
XM_Make(XmScaleCallbackStruct)
XM_Make(XmScrollBarCallbackStruct)
XM_Make(XmSelectionBoxCallbackStruct)
XM_Make(XmTextVerifyCallbackStruct)
XM_Make(XmToggleButtonCallbackStruct)
XM_Make(XmTextBlock)
#if MOTIF_2
XM_Make(XmDestinationCallbackStruct)
XM_Make(XmConvertCallbackStruct)
XM_Make(XmComboBoxCallbackStruct)
XM_Make(XmContainerOutlineCallbackStruct)
XM_Make(XmContainerSelectCallbackStruct)
XM_Make(XmNotebookCallbackStruct)
XM_Make(XmSpinBoxCallbackStruct)
XM_Make(XmTraverseObscuredCallbackStruct)
XM_Make(XmTopLevelLeaveCallbackStruct)
XM_Make(XmTopLevelEnterCallbackStruct)
XM_Make(XmPopupHandlerCallbackStruct)
XM_Make(XmSelectionCallbackStruct)
XM_Make(XmTransferDoneCallbackStruct)
#endif

static void define_makes(void)
{
  XM_Declare(XmAnyCallbackStruct);
  XM_Declare(XmArrowButtonCallbackStruct);
  XM_Declare(XmCommandCallbackStruct);
  XM_Declare(XmDragDropFinishCallbackStruct);
  XM_Declare(XmDragMotionCallbackStruct);
  XM_Declare(XmDragProcCallbackStruct);
  XM_Declare(XmDrawingAreaCallbackStruct);
  XM_Declare(XmDrawnButtonCallbackStruct);
  XM_Declare(XmDropFinishCallbackStruct);
  XM_Declare(XmDropProcCallbackStruct);
  XM_Declare(XmDropSiteEnterCallbackStruct);
  XM_Declare(XmDropSiteLeaveCallbackStruct);
  XM_Declare(XmDropStartCallbackStruct);
  XM_Declare(XmFileSelectionBoxCallbackStruct);
  XM_Declare(XmListCallbackStruct);
  XM_Declare(XmOperationChangedCallbackStruct);
  XM_Declare(XmPushButtonCallbackStruct);
  XM_Declare(XmRowColumnCallbackStruct);
  XM_Declare(XmScaleCallbackStruct);
  XM_Declare(XmScrollBarCallbackStruct);
  XM_Declare(XmSelectionBoxCallbackStruct);
  XM_Declare(XmTextVerifyCallbackStruct);
  XM_Declare(XmToggleButtonCallbackStruct);
  XM_Declare(XmTextBlock);
#if MOTIF_2
  XM_Declare(XmDestinationCallbackStruct);
  XM_Declare(XmConvertCallbackStruct);
  XM_Declare(XmComboBoxCallbackStruct);
  XM_Declare(XmContainerOutlineCallbackStruct);
  XM_Declare(XmContainerSelectCallbackStruct);
  XM_Declare(XmNotebookCallbackStruct);
  XM_Declare(XmSpinBoxCallbackStruct);
  XM_Declare(XmTraverseObscuredCallbackStruct);
  XM_Declare(XmTopLevelLeaveCallbackStruct);
  XM_Declare(XmTopLevelEnterCallbackStruct);
  XM_Declare(XmPopupHandlerCallbackStruct);
  XM_Declare(XmSelectionCallbackStruct);
  XM_Declare(XmTransferDoneCallbackStruct);
#endif
}

static int its_a_callbackstruct(char *name)
{
  int len;
  char *end_name;
  if (name)
    {
      len = strlen(name);
      if (len > 16)
	{
	  end_name = (char *)(name + len - 14);
	  return(strcmp(end_name, "CallbackStruct") == 0);
	}
    }
  return(0);
}

#define XEN_AnyCallbackStruct_P(Value) (XEN_LIST_P(Value) && \
                                       (XEN_LIST_LENGTH(Value) >= 2) && \
                                       (XEN_SYMBOL_P(XEN_CAR(Value))) && \
                                       (its_a_callbackstruct(XEN_SYMBOL_TO_C_STRING(XEN_CAR(Value)))))
#endif

static int xm_protect(XEN obj);
static void xm_unprotect_at(int ind);

#if HAVE_MOTIF

/* in XtGetValues we need to return tagged-types (etc) for arbitrarily named resources,
 *   and in XtSetValues we need to do type checks, so resources are hashed by
 *   name and type:
 */

enum {XM_INT, XM_ULONG, XM_UCHAR, XM_FLOAT, XM_STRING, XM_XMSTRING, XM_STRING_TABLE,
      XM_INT_TABLE, XM_RENDER_TABLE, XM_TAB_LIST, XM_WIDGET, XM_WIDGET_LIST, 
      XM_BOOLEAN, XM_CALLBACK, XM_PIXEL, XM_PIXMAP, XM_XFONTSTRUCT, XM_DIMENSION,
      XM_ATOM, XM_ATOM_LIST, XM_STRING_LIST, XM_CHARSET_TABLE, XM_TEXT_SOURCE,
      XM_FONTLIST, XM_COLORMAP, XM_KEYSYM, XM_KEYSYM_TABLE, XM_SCREEN, XM_WINDOW,
      XM_VISUAL, XM_RECTANGLE_LIST, XM_WIDGET_CLASS, XM_STRING_OR_INT,
      XM_TRANSFER_CALLBACK, XM_CONVERT_CALLBACK, XM_SEARCH_CALLBACK, XM_ORDER_CALLBACK,
      XM_QUALIFY_CALLBACK, XM_ALLOC_COLOR_CALLBACK, XM_POPUP_CALLBACK, XM_SCREEN_COLOR_CALLBACK,
      XM_DROP_CALLBACK, XM_TRANSFER_ENTRY_LIST, XM_DRAG_CALLBACK, XM_STRING_OR_XMSTRING, XM_PARSE_CALLBACK
};

static int resource_type(char *resource);

/* ADD: Widget w -> bare Widget (pointer) wrapped for xm */
/* ADD: XtAppContext app -> bare XtAppContext (pointer) wrapped for xm */
/* ADD: XGCValues -> new blank XGCValues struct (may need more of these) */
/* ADD: GC -> cast ulong to GC */
/* ADD: Pixel -> cast ulong to Pixel */

static XEN gxm_Widget(XEN w) {if (XEN_LIST_P(w)) return(w); else return(C_TO_XEN_Widget((Widget)XEN_TO_C_ULONG(w)));}
static XEN gxm_XtAppContext(XEN w) {if (XEN_LIST_P(w)) return(w); else return(C_TO_XEN_XtAppContext((XtAppContext)XEN_TO_C_ULONG(w)));}
static XEN gxm_Pixel(XEN w) {if (XEN_LIST_P(w)) return(w); else return(C_TO_XEN_Pixel((Pixel)XEN_TO_C_ULONG(w)));}
static XEN gxm_GC(XEN w) {if (XEN_LIST_P(w)) return(w); else return(C_TO_XEN_GC((GC)XEN_TO_C_ULONG(w)));}

static XEN C_TO_XEN_Widgets(Widget *array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_Widget(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN C_TO_XEN_XmStringTable(XmStringTable array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_XmString(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static Widget *XEN_TO_C_Widgets(XEN lst, int n)
{
  Widget *ws;
  int i;
  ws = (Widget *)CALLOC(n, sizeof(Widget));
  for (i = 0; (i < n) && (XEN_NOT_NULL_P(lst)); i++, lst = XEN_CDR(lst))
    if (XEN_Widget_P(XEN_CAR(lst)))
      ws[i] = XEN_TO_C_Widget(XEN_CAR(lst));
    else XEN_ASSERT_TYPE(0, XEN_CAR(lst), i, __FUNCTION__, "a Widget");
  return(ws);
}

static XmString *XEN_TO_C_XmStrings(XEN v, int len)
{
  XmString *str;
  int i;
  str = (XmString *)CALLOC(len, sizeof(XmString));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_XmString_P(XEN_CAR(v)))
      str[i] = (XmString)XEN_TO_C_XmString(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an XmString");
  return(str);
}

static XmDropTransferEntryRec *XEN_TO_C_XmDropTransferEntryRecs(XEN v, int len)
{
  XmDropTransferEntryRec *ps;
  int i;
  ps = (XmDropTransferEntryRec *)CALLOC(len, sizeof(XmDropTransferEntryRec));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    {
      if (XEN_LIST_P(XEN_CAR(v)))
	{
	  if (XEN_Atom_P(XEN_CAR(v)))
	    ps[i].target = XEN_TO_C_Atom(XEN_CAR(XEN_CAR(v)));
	  else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an Atom");
	  ps[i].client_data = (XtPointer)XEN_CADR(XEN_CAR(v));
	}
      else
	{
	  if (XEN_Atom_P(XEN_CAR(v)))
	    ps[i].target = XEN_TO_C_Atom(XEN_CAR(v));
	  else XEN_ASSERT_TYPE(0, XEN_CAR(v), 0, __FUNCTION__, "a list (Atom data)");
	}
    }
  return(ps);
}

static XmStringTable XEN_TO_C_XmStringTable(XEN v, int len)
{
  XmStringTable str;
  int i;
  str = (XmStringTable)CALLOC(len + 1, sizeof(XmString));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_XmString_P(XEN_CAR(v)))
      str[i] = XEN_TO_C_XmString(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an XmString");
  return(str);
}

#endif

static XEN C_TO_XEN_Ints(int *array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_INT(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN c_to_xen_ints(XEN array, XEN len)
{
  return(C_TO_XEN_Ints((int *)XEN_TO_C_ULONG(array), XEN_TO_C_INT(len)));
}

static XEN C_TO_XEN_Atoms(Atom *array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_Atom(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN c_to_xen_atoms(XEN array, XEN len)
{
  return(C_TO_XEN_Atoms((Atom *)XEN_TO_C_ULONG(array), XEN_TO_C_INT(len)));
}

static XEN C_TO_XEN_Strings(char **array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_STRING(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN c_to_xen_strings(XEN array, XEN len)
{
  return(C_TO_XEN_Strings((char **)XEN_TO_C_ULONG(array), XEN_TO_C_INT(len)));
}

static XEN c_to_xen_string(XEN str)
{
  return(C_TO_XEN_STRING((char *)XEN_TO_C_ULONG(str)));
}

static XEN C_TO_XEN_XRectangles(XRectangle *array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_XRectangle(&(array[i])), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN c_to_xen_xrectangles(XEN array, XEN len)
{
  return(C_TO_XEN_XRectangles((XRectangle *)XEN_TO_C_ULONG(array), XEN_TO_C_INT(len)));
}

static XEN C_TO_XEN_KeySyms(KeySym *array, int len)
{
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  if (array)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_KeySym(array[i]), lst);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static Window *XEN_TO_C_Windows(XEN lst, int n)
{
  Window *ws;
  int i;
  ws = (Window *)CALLOC(n, sizeof(Window));
  for (i = 0; (i < n) && (XEN_NOT_NULL_P(lst)); i++, lst = XEN_CDR(lst))
    if (XEN_Window_P(XEN_CAR(lst)))
      ws[i] = XEN_TO_C_Window(XEN_CAR(lst));
    else XEN_ASSERT_TYPE(0, XEN_CAR(lst), i, __FUNCTION__, "a Window");
  return(ws);
}

#if MOTIF_2
static XmRendition *XEN_TO_C_XmRenditions(XEN lst, int n)
{
  XmRendition *ws;
  int i;
  ws = (XmRendition *)CALLOC(n, sizeof(XmRendition));
  for (i = 0; (i < n) && (XEN_NOT_NULL_P(lst)); i++, lst = XEN_CDR(lst))
    if (XEN_XmRendition_P(XEN_CAR(lst)))
      ws[i] = XEN_TO_C_XmRendition(XEN_CAR(lst));
    else XEN_ASSERT_TYPE(0, XEN_CAR(lst), i, __FUNCTION__, "an XmRendition");
  return(ws);
}

static XmTab *XEN_TO_C_XmTabs(XEN v, int len)
{
  XmTab *str;
  int i;
  str = (XmTab *)CALLOC(len, sizeof(XmTab));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_XmTab_P(XEN_CAR(v)))
      str[i] = (XmTab)XEN_TO_C_XmTab(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an XmTab");
  return(str);
}
#endif

static Atom *XEN_TO_C_Atoms(XEN v, int len)
{
  Atom *str;
  int i;
  str = (Atom *)CALLOC(len, sizeof(Atom));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_Atom_P(XEN_CAR(v)))
      str[i] = (Atom)XEN_TO_C_Atom(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an Atom");
  return(str);
}

static Pixel *XEN_TO_C_Pixels(XEN v, int len)
{
  Pixel *str;
  int i;
  str = (Pixel *)CALLOC(len, sizeof(Pixel));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_Pixel_P(XEN_CAR(v)))
      str[i] = (Pixel)XEN_TO_C_Pixel(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "a Pixel");
  return(str);
}

static KeySym *XEN_TO_C_KeySyms(XEN v, int len)
{
  KeySym *str;
  int i;
  str = (KeySym *)CALLOC(len, sizeof(KeySym));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_KeySym_P(XEN_CAR(v)))
      str[i] = (KeySym)XEN_TO_C_KeySym(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "a KeySym");
  return(str);
}

static char **XEN_TO_C_Strings(XEN v, int len)
{
  char **str;
  int i;
  str = (char **)CALLOC(len, sizeof(char *));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_STRING_P(XEN_CAR(v)))
      str[i] = XEN_TO_C_STRING(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "a char*");
  return(str);
}

static int *XEN_TO_C_Ints(XEN v, int len)
{
  int *ps;
  int i;
  ps = (int *)CALLOC(len, sizeof(int));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_INTEGER_P(XEN_CAR(v)))
      ps[i] = XEN_TO_C_INT(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an int");
  return(ps);
}

static Cardinal *XEN_TO_C_Cardinals(XEN v, int len)
{
  Cardinal *ps;
  int i;
  ps = (Cardinal *)CALLOC(len, sizeof(int));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    if (XEN_INTEGER_P(XEN_CAR(v)))
      ps[i] = (Cardinal)XEN_TO_C_INT(XEN_CAR(v));
    else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "a Cardinal");
  return(ps);
}

static XRectangle *XEN_TO_C_XRectangles(XEN v, int len)
{
  XRectangle *str, *dat;
  int i;
  str = (XRectangle *)CALLOC(len, sizeof(XRectangle));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(v)); i++, v = XEN_CDR(v))
    {
      if (XEN_XRectangle_P(XEN_CAR(v)))
	dat = (XRectangle *)XEN_TO_C_XRectangle(XEN_CAR(v));
      else XEN_ASSERT_TYPE(0, XEN_CAR(v), i, __FUNCTION__, "an XRectangle");
      str[i].x = dat->x;
      str[i].y = dat->y;
      str[i].width = dat->width;
      str[i].height = dat->height;
    }
  return(str);
}


#if HAVE_MOTIF

/* -------- arglists -------- */

static XEN wrap_callback_struct(int type, XtPointer info);
static int map_over_protected_elements(int (*func)(XEN val, int loc, unsigned long fid), unsigned long id);
static XEN xm_protected_element(int loc);
static int callback_struct_type(Widget w, char *name);
static void xm_unprotect(XEN obj);

enum {CALLBACK_TYPE, CALLBACK_FUNC, CALLBACK_DATA, CALLBACK_STRUCT_TYPE, CALLBACK_GC_LOC};

#define C_TO_XEN_XM_XtCallback(Code, Context) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("XtCallback"), Code, Context, XEN_ZERO, XEN_ZERO)
#define XM_XtCallback_P(Arg) WRAP_P("XtCallback", Arg)

static void gxm_XtCallbackProc(Widget w, XtPointer context, XtPointer info)
{
  XEN descr = (XEN)context;
  /* XEN_ASSERT_TYPE(XM_XtCallback_P(descr) && (XEN_LIST_LENGTH(descr) == 5), descr, XEN_ONLY_ARG, "XtCallback", "list of 5 elements"); */
  XEN_CALL_3(XEN_LIST_REF(descr, CALLBACK_FUNC),    /* descr: (list "XtCallback" func user-data struct-type gc-loc) */
	     C_TO_XEN_Widget(w),
	     XEN_LIST_REF(descr, CALLBACK_DATA),
	     wrap_callback_struct(XEN_TO_C_INT(XEN_LIST_REF(descr, CALLBACK_STRUCT_TYPE)), info),
	     __FUNCTION__);
}

#define C_TO_XEN_XM_Drop_Callback(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("Drop_Callback"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_Drop_Callback_P(Arg) WRAP_P("Drop_Callback", Arg)

static int find_dropproc(XEN val, int loc, unsigned long w)
{
  return((XM_Drop_Callback_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static void gxm_Drop_Callback(Widget w, XtPointer context, XtPointer info)
{
  XEN code;
  int i;
  XmDropProcCallbackStruct *cb = (XmDropProcCallbackStruct *)info;
  i = map_over_protected_elements(find_dropproc, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	XEN_CALL_3(code,
		   C_TO_XEN_Widget(w),
		   XEN_FALSE,
		   C_TO_XEN_XmDropProcCallbackStruct(cb),
		   __FUNCTION__);
    }
  cb->dropSiteStatus = XmINVALID_DROP_SITE; /* try to exit cleanly from on-going drop */
}

#define C_TO_XEN_XM_Drag_Callback(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("Drag_Callback"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_Drag_Callback_P(Arg) WRAP_P("Drag_Callback", Arg)

static int find_dragproc(XEN val, int loc, unsigned long w)
{
  return((XM_Drag_Callback_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static void gxm_Drag_Callback(Widget w, XtPointer context, XtPointer info)
{
  XEN code;
  int i;
  XmDragProcCallbackStruct *cb = (XmDragProcCallbackStruct *)info;
  i = map_over_protected_elements(find_dragproc, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	XEN_CALL_3(code,
		   C_TO_XEN_Widget(w),
		   XEN_FALSE,
		   C_TO_XEN_XmDragProcCallbackStruct(cb),
		   __FUNCTION__);
    }
}

#define C_TO_XEN_XM_XtPopupChild(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("XtPopupChild"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_XtPopupChild_P(Arg) WRAP_P("XtPopupChild", Arg)

static int find_popupchild(XEN val, int loc, unsigned long w)
{
  return((XM_XtPopupChild_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static void gxm_XtPopupChild(Widget w)
{
  /* since all we have to go by is the widget, we have to scan the gc table for any associated code */
  XEN code;
  int i;
  i = map_over_protected_elements(find_popupchild, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	XEN_CALL_1(code,
		   C_TO_XEN_Widget(w),
		   __FUNCTION__);
    }
}

#define C_TO_XEN_XM_XmSearchProc(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("XmSearchProc"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_XmSearchProc_P(Arg) WRAP_P("XmSearchProc", Arg)

static int find_searchproc(XEN val, int loc, unsigned long w)
{
  return((XM_XmSearchProc_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static void gxm_XmSearchProc(Widget w, XmFileSelectionBoxCallbackStruct *info)
{
  /* here we again have to go by the widget */
  XEN code;
  int i;
  i = map_over_protected_elements(find_searchproc, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	XEN_CALL_2(code,
		   C_TO_XEN_Widget(w),
		   C_TO_XEN_XmFileSelectionBoxCallbackStruct(info),
		   __FUNCTION__);
    }
}

#define C_TO_XEN_XM_XmQualifyProc(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("XmQualifyProc"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_XmQualifyProc_P(Arg) WRAP_P("XmQualifyProc", Arg)

static int find_qualifyproc(XEN val, int loc, unsigned long w)
{
  return((XM_XmQualifyProc_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static void gxm_XmQualifyProc(Widget w, XtPointer indata, XtPointer outdata)
{
  /* here we again have to go by the widget */
  XEN code;
  int i;
  i = map_over_protected_elements(find_qualifyproc, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	XEN_CALL_3(code,
		   C_TO_XEN_Widget(w),
		   C_TO_XEN_XmFileSelectionBoxCallbackStruct((XmFileSelectionBoxCallbackStruct *)indata),
		   C_TO_XEN_XmFileSelectionBoxCallbackStruct((XmFileSelectionBoxCallbackStruct *)outdata),
		   __FUNCTION__);
    }
}

#define C_TO_XEN_XM_XtOrderProc(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("XtOrderProc"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_XtOrderProc_P(Arg) WRAP_P("XtOrderProc", Arg)

static int find_orderproc(XEN val, int loc, unsigned long w)
{
  return((XM_XtOrderProc_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_Widget_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static Cardinal gxm_XtOrderProc(Widget w)
{
  /* here we again have to go by the widget */
  XEN code;
  int i, result = 0;
  i = map_over_protected_elements(find_orderproc, (unsigned long)w);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	result = XEN_TO_C_INT(XEN_CALL_1(code,
					 C_TO_XEN_Widget(w),
					 __FUNCTION__));
    }
  return((Cardinal)result);
}

#define C_TO_XEN_XM_Parse_Callback(Code) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("Parse_Callback"), Code, XEN_FALSE, XEN_ZERO, XEN_ZERO)
#define XM_Parse_Callback_P(Arg) WRAP_P("Parse_Callback", Arg)

static int find_parseproc(XEN val, int loc, unsigned long w)
{
  return((XM_Parse_Callback_P(val)) &&
	 (((XEN_FALSE_P((XEN)w)) && 
	   (XEN_FALSE_P(XEN_LIST_REF(val, CALLBACK_DATA)))) ||
	  ((XEN_XmParseMapping_P(XEN_LIST_REF(val, CALLBACK_DATA))) &&
	   (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, CALLBACK_DATA))) == w))));
}

static XmIncludeStatus gxm_Parse_Callback(XtPointer *in_out, XtPointer text_end, XmTextType type, XmStringTag locale_tag,
					  XmParseMapping entry, int pattern_length, XmString *str_include, XtPointer call_data)
{
  XEN code;
  int i;
  i = map_over_protected_elements(find_parseproc, (unsigned long)entry);
  if (i >= 0)
    {
      code = XEN_LIST_REF(xm_protected_element(i), CALLBACK_FUNC);
      if (XEN_PROCEDURE_P(code))
	return(XEN_TO_C_INT(XEN_APPLY(code,
				      XEN_LIST_8(C_TO_XEN_STRING((char *)(*in_out)),
						 C_TO_XEN_ULONG(text_end), /* can't work... */
						 C_TO_XEN_INT(type),
						 C_TO_XEN_STRING(locale_tag),
						 C_TO_XEN_XmParseMapping(entry),
						 C_TO_XEN_INT(pattern_length),
						 C_TO_XEN_XmString((*str_include)), /* can't work... */
						 (XEN)call_data),
				      __FUNCTION__)));
    }
  return(0);
}

static XEN xm_XmColorAllocationProc = XEN_FALSE;

static void gxm_XmAllocColorProc(Display *dpy, Colormap color, XColor *bs)
{
  /* DIFF: XmAllocColorProc should return new XColor value
   */
  XEN val;
  val = XEN_CALL_3(xm_XmColorAllocationProc,
		   C_TO_XEN_Display(dpy),
		   C_TO_XEN_Colormap(color),
		   C_TO_XEN_XColor(bs),
		   __FUNCTION__);
  bs = XEN_TO_C_XColor(val);
}

static XEN xm_XmColorCalculationProc = XEN_FALSE;

static void gxm_XmColorCalculationProc(Screen *scr, XColor *bg, XColor *fg, XColor *sel, XColor *ts, XColor *bs)
{
  /* DIFF: XmColorCalculationProc takes 2 args, returns list of 4 colors
   */
  XEN lst;
  int loc;
  lst = XEN_CALL_2(xm_XmColorCalculationProc,
		   C_TO_XEN_Screen(scr),
		   C_TO_XEN_XColor(bg),
		   __FUNCTION__);
  loc = xm_protect(lst);
  if (XEN_LIST_P(lst))
    {
      fg = XEN_TO_C_XColor(XEN_LIST_REF(lst, 0)); 
      sel = XEN_TO_C_XColor(XEN_LIST_REF(lst, 1));
      ts = XEN_TO_C_XColor(XEN_LIST_REF(lst, 2));
      bs = XEN_TO_C_XColor(XEN_LIST_REF(lst, 3));
   }
  xm_unprotect_at(loc);
}

static XEN xm_XmColorProc = XEN_FALSE; /* XmColorProc is not the same as XmScreen color calculation proc */

static void gxm_XmColorProc(XColor *bg, XColor *fg, XColor *sel, XColor *ts, XColor *bs)
{
  XEN lst;
  int loc;
  lst = XEN_CALL_1(xm_XmColorProc,
		   C_TO_XEN_XColor(bg),
		   __FUNCTION__);
  loc = xm_protect(lst);
  if (XEN_LIST_P(lst))
    {
      fg = XEN_TO_C_XColor(XEN_LIST_REF(lst, 0)); 
      sel = XEN_TO_C_XColor(XEN_LIST_REF(lst, 1));
      ts = XEN_TO_C_XColor(XEN_LIST_REF(lst, 2));
      bs = XEN_TO_C_XColor(XEN_LIST_REF(lst, 3));
   }
  xm_unprotect_at(loc);
}

static XtCallbackList XEN_TO_C_XtCallbackList(XEN call_list1)
{
  XEN descr, func, data, call_list;
  int call_i, call_len;
  XtCallbackRec *cl = NULL;
  call_list = XEN_COPY_ARG(call_list1);
  call_len = XEN_LIST_LENGTH(call_list) / 2;
  if (call_len == 0) return(NULL);
  cl = (XtCallbackRec *)CALLOC(call_len + 1, sizeof(XtCallbackRec));
  for (call_i = 0; call_i < call_len; call_i++, call_list = XEN_CDDR(call_list))
    {
      func = XEN_CAR(call_list);
      if (XEN_LIST_LENGTH(call_list) == 2)
	data = XEN_CADR(call_list);
      else data = XEN_FALSE;
      if ((XEN_PROCEDURE_P(func)) && (XEN_REQUIRED_ARGS(func) == 3))
	{
	  cl[call_i].callback = gxm_XtCallbackProc;
	  descr = C_TO_XEN_XM_XtCallback(XEN_CAR(call_list), data);
	  cl[call_i].closure = (XtPointer)descr;
	  XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	}
    }
  return(cl);
}

static XEN C_TO_XEN_STRING_WITH_TERMINATION(char *str, int len)
{
  str[len] = '\0';
  return(C_TO_XEN_STRING(str));
}

static XEN xm_XtSelectionCallback_Descr = XEN_FALSE;
static void gxm_XtSelectionCallbackProc(Widget w, XtPointer x, Atom* a1, Atom* a2, XtPointer x1, unsigned long* l, int* i)
{
  XEN_APPLY(XEN_CAR(xm_XtSelectionCallback_Descr),
	    XEN_LIST_7(C_TO_XEN_Widget(w),
		       XEN_CADR(xm_XtSelectionCallback_Descr),
		       C_TO_XEN_Atom(*a1),
		       C_TO_XEN_Atom(*a2),
		       C_TO_XEN_STRING_WITH_TERMINATION((char *)x1, *l), /* should we handle Atom -> Lisp type conversions? */
		       C_TO_XEN_ULONG(*l),
		       C_TO_XEN_INT(*i)),
	    __FUNCTION__);
}

static XEN xm_XtConvertSelectionIncr_Descr = XEN_FALSE;
static Boolean gxm_XtConvertSelectionIncrProc(Widget w, Atom* selection, Atom* target, 
					   Atom* type_return, XtPointer *value_return, 
					   unsigned long *length_return, int *format_return, 
					   unsigned long *max_length, XtPointer client_data, 
					   XtRequestId *request_id)
{
  /* DIFF: user callback here takes 6 args (w selection target max_length client_data request_id)
   *       should return (list ...) if ok, #f if not
   *       the list should be (type value length format)
   */
  XEN result;
  result = XEN_APPLY(xm_XtConvertSelectionIncr_Descr,
		     XEN_LIST_6(C_TO_XEN_Widget(w),
				C_TO_XEN_Atom(*selection),
				C_TO_XEN_Atom(*target),
				C_TO_XEN_INT(*max_length),
				C_TO_XEN_ULONG(client_data),
				C_TO_XEN_INT((int)(*request_id))),
		     __FUNCTION__);
  if (XEN_FALSE_P(result))
    return(False);
  (*type_return) = XEN_TO_C_Atom(XEN_LIST_REF(result, 0));
  (*value_return) = (XtPointer)XEN_TO_C_ULONG(XEN_LIST_REF(result, 1));
  (*length_return) = (unsigned long)XEN_TO_C_INT(XEN_LIST_REF(result, 2));
  (*format_return) = XEN_TO_C_INT(XEN_LIST_REF(result, 3));
  return(True);
}

static Arg *XEN_TO_C_Args(XEN inargl)
{
  /* an Arg array in xm is a list of name value pairs */
  Arg *args = NULL;
  int i, len, type;
  XtCallbackRec *cl = NULL;
  XEN descr, value, xname, inarg;
  char *name;
  /* if XtVaNestedList supported, scan for it here, and increase length as needed,
   *   then make recursive call to XEN_TO_C_Args in that branch, unloading afterwards
   *   this is not actually needed in xm -- just use append!
   */
  inarg = XEN_COPY_ARG(inargl);
  len = XEN_LIST_LENGTH(inarg) / 2;
  if (len == 0) return(NULL);
  args = (Arg *)CALLOC(len, sizeof(Arg));
  for (i = 0; i < len; i++, inarg = XEN_CDDR(inarg))
    {
      xname = XEN_CAR(inarg);
      XEN_ASSERT_TYPE(XEN_STRING_P(xname), xname, 0, __FUNCTION__, "string");
      name = XEN_TO_C_STRING(xname);
      type = resource_type(name);
      value = XEN_CADR(inarg);
      switch (type)
	{
	  /* here the XtSetArg call wants an XtCallbackList, the incoming XEN type is a list of callback data pairs
	   *   the new callback rec.callback = gxm_XtCallback (etc -- chosen by resource type)
	   *   the rec.closure will be the wrapped func/data info
	   *   we don't have all the data we need for the actual wrapped list here since we need the widget to choose the callback struct type
	   *   so fixup_args should always follow if there's a possible callback list in the resource settings 
	   * also, which callback is invoked may depend on callback type 
	   */
	case XM_CALLBACK:
	  cl = XEN_TO_C_XtCallbackList(value);
	  if (cl) XtSetArg(args[i], name, cl);
	  break;

	case XM_PARSE_CALLBACK:
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 8))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_Parse_Callback);
	      descr = C_TO_XEN_XM_Parse_Callback(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 8 args");
	    }
	  break;

	case XM_DROP_CALLBACK:
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 3))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_Drop_Callback);
	      descr = C_TO_XEN_XM_Drop_Callback(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 3 args");
	    }
	  break;
	case XM_DRAG_CALLBACK:
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 3))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_Drag_Callback);
	      descr = C_TO_XEN_XM_Drag_Callback(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 3 args");
	    }
	  break;
	case XM_SEARCH_CALLBACK:    /* XmNfileSearchProc and XmNdirSearchProc, XmSearchProc XmFileSelectionBox 756 */
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 2))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XmSearchProc);
	      descr = C_TO_XEN_XM_XmSearchProc(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 2 args");
	    }
	  break;
	case XM_QUALIFY_CALLBACK:   /* XmNqualifySearchDataProc, XmQualifyProc */
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 3))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XmQualifyProc);
	      descr = C_TO_XEN_XM_XmQualifyProc(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 3 args");
	    }
	  break;
	case XM_ORDER_CALLBACK:
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 1))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XtOrderProc);
	      descr = C_TO_XEN_XM_XtOrderProc(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 1 arg");
	    }
	  break;
	case XM_TRANSFER_CALLBACK:  /* XmNtransferProc, XtSelectionCallbackProc, XmDropTransfer */
	  /* for now I'll assume no collisions here */
	  xm_XtSelectionCallback_Descr = XEN_LIST_2(value, XEN_FALSE);
	  XtSetArg(args[i], name, (unsigned long)gxm_XtSelectionCallbackProc);
	  break;
	case XM_CONVERT_CALLBACK:   /* XmNconvertProc, XtConvertSelectionIncrProc, XmDragContext */
	  xm_XtConvertSelectionIncr_Descr = value;
	  XtSetArg(args[i], name, (unsigned long)gxm_XtConvertSelectionIncrProc);
	  break;
	case XM_ALLOC_COLOR_CALLBACK:     /* XmNcolorAllocationProc, XmAllocColorProc XmScreen 921 */
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 3))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XmAllocColorProc);
	      if (XEN_PROCEDURE_P(xm_XmColorAllocationProc)) xm_unprotect(xm_XmColorAllocationProc);
	      xm_protect(value);
	      xm_XmColorAllocationProc = value;
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 3 args");
	    }
	  break;
	case XM_SCREEN_COLOR_CALLBACK:     /* XmNcolorCalculationProc, XmScreen 921 */
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 2))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XmColorCalculationProc);
	      if (XEN_PROCEDURE_P(xm_XmColorCalculationProc)) xm_unprotect(xm_XmColorCalculationProc);
	      xm_protect(value);
	      xm_XmColorCalculationProc = value;
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 2 args");
	    }
	  break;
	case XM_POPUP_CALLBACK:     /* XmNcreatePopupChildProc, XtCreatePopupChildProc */
	  if ((XEN_PROCEDURE_P(value)) && (XEN_REQUIRED_ARGS(value) == 1))
	    {
	      XtSetArg(args[i], name, (unsigned long)gxm_XtPopupChild);
	      descr = C_TO_XEN_XM_XtPopupChild(value);
	      XEN_LIST_SET(descr, CALLBACK_GC_LOC, C_TO_XEN_INT(xm_protect(descr)));
	    }
	  else 
	    {
	      if (XEN_FALSE_P(value))
		XtSetArg(args[i], name, NULL);
	      else XEN_ASSERT_TYPE(0, value, 0, name, "procedure of 1 arg");
	    }
	  break;

	  /* the rest are just doing type checks before the conversion to C */

	case XM_INT:
	  XEN_ASSERT_TYPE(XEN_INTEGER_P(value), value, XEN_ONLY_ARG, name, "an integer");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_INT(value)));
	  break;
	case XM_STRING:	      
	  XEN_ASSERT_TYPE(XEN_STRING_P(value), value, XEN_ONLY_ARG, name, "a string");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_STRING(value)));
	  break;
	case XM_STRING_OR_INT:
	  XEN_ASSERT_TYPE(XEN_STRING_P(value) || XEN_INTEGER_P(value), value, XEN_ONLY_ARG, name, "an integer or a string");      
	  if (XEN_STRING_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_STRING(value)));
	  else XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_INT(value)));
	  break;
	case XM_XMSTRING:
	  XEN_ASSERT_TYPE(XEN_XmString_P(value), value, XEN_ONLY_ARG, name, "an XmString");      	      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmString(value)));
	  break;
	case XM_STRING_OR_XMSTRING:
	  XEN_ASSERT_TYPE(XEN_XmString_P(value) || XEN_STRING_P(value), value, XEN_ONLY_ARG, name, "a string or an XmString");  
	  if (XEN_STRING_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_STRING(value)));
	  else XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmString(value)));
	  break;
	case XM_STRING_TABLE:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "an XmStringTable");      	           
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmStringTable(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_TRANSFER_ENTRY_LIST:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list");      	           
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmDropTransferEntryRecs(value, XEN_LIST_LENGTH(value))));
	  break;
#if MOTIF_2
	case XM_RENDER_TABLE: 
	  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(value), value, XEN_ONLY_ARG, name, "an XmRenderTable");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmRenderTable(value)));
	  break;
	case XM_TAB_LIST:
	  XEN_ASSERT_TYPE(XEN_XmTabList_P(value), value, XEN_ONLY_ARG, name, "an XmTabList"); 
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmTabList(value)));
	  break;
#endif
	case XM_WIDGET:
	  XEN_ASSERT_TYPE(XEN_Widget_P(value), value, XEN_ONLY_ARG, name, "a Widget"); 
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Widget(value)));
	  break;
	case XM_BOOLEAN:
	  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(value), value, XEN_ONLY_ARG, name, "a boolean"); 
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_BOOLEAN(value)));
	  break;
	case XM_PIXEL:
	  XEN_ASSERT_TYPE(XEN_Pixel_P(value), value, XEN_ONLY_ARG, name, "a pixel"); 
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Pixel(value)));
	  break;
	case XM_PIXMAP:
	  XEN_ASSERT_TYPE(XEN_Pixmap_P(value), value, XEN_ONLY_ARG, name, "a pixmap"); 
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Pixmap(value)));
	  break;
	case XM_DIMENSION:
	  XEN_ASSERT_TYPE(XEN_NUMBER_P(value), value, XEN_ONLY_ARG, name, "a number");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Dimension(value)));
	  break;
	case XM_ATOM:
	  XEN_ASSERT_TYPE(XEN_Atom_P(value), value, XEN_ONLY_ARG, name, "an Atom");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Atom(value)));
	  break;
	case XM_TEXT_SOURCE:
	  XEN_ASSERT_TYPE(XEN_XmTextSource_P(value), value, XEN_ONLY_ARG, name, "an XmTextSource");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmTextSource(value)));
	  break;
#if (!XM_DISABLE_DEPRECATED)
	case XM_FONTLIST:
	  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(value), value, XEN_ONLY_ARG, name, "an XmFontList");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XmFontList(value)));
	  break;
#endif
	case XM_COLORMAP:
	  XEN_ASSERT_TYPE(XEN_Colormap_P(value), value, XEN_ONLY_ARG, name, "a Colormap");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Colormap(value)));
	  break;
	case XM_KEYSYM:
	  XEN_ASSERT_TYPE(XEN_KeySym_P(value), value, XEN_ONLY_ARG, name, "a KeySym");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_KeySym(value)));
	  break;
	case XM_SCREEN:
	  XEN_ASSERT_TYPE(XEN_Screen_P(value), value, XEN_ONLY_ARG, name, "a Screen");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Screen(value)));
	  break;
	case XM_WINDOW:
	  XEN_ASSERT_TYPE(XEN_Window_P(value), value, XEN_ONLY_ARG, name, "a Window");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Window(value)));
	  break;
	case XM_VISUAL:
	  XEN_ASSERT_TYPE(XEN_Visual_P(value), value, XEN_ONLY_ARG, name, "a Visual");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Visual(value)));
	  break;
	case XM_WIDGET_CLASS:
	  XEN_ASSERT_TYPE(XEN_WidgetClass_P(value), value, XEN_ONLY_ARG, name, "a WidgetClass");      
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_WidgetClass(value)));
	  break;

	case XM_ATOM_LIST:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of Atoms");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Atoms(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_INT_TABLE:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of ints");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Ints(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_WIDGET_LIST:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of Widgets");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Widgets(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_KEYSYM_TABLE:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of KeySyms");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_KeySyms(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_STRING_LIST:
	case XM_CHARSET_TABLE:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of char *");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_Strings(value, XEN_LIST_LENGTH(value))));
	  break;
	case XM_RECTANGLE_LIST:
	  XEN_ASSERT_TYPE(XEN_LIST_P(value), value, XEN_ONLY_ARG, name, "a list of XRectangles");
	  XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_XRectangles(value, XEN_LIST_LENGTH(value))));
	  break;

	default:
	  if (XEN_ULONG_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_ULONG(value)));
	  else if (XEN_INTEGER_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_INT(value)));
	  else if (XEN_BOOLEAN_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_BOOLEAN(value)));
	  else if (XEN_STRING_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_STRING(value)));
	  else if (XEN_LIST_P(value))
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_ULONG(XEN_CADR(value))));  /* all tagged types */
	  else 
	    XtSetArg(args[i], name, (XtArgVal)(XEN_TO_C_ULONG(value)));
	  break;
	}
    }
  return(args);
}

static void fixup_args(Widget w, Arg *args, int len)
{
  /* search for and fill-in incompletely specified callback info now that we have the widget type */
  int i, j;
  XEN data;
  char *name;
  XtCallbackRec *cl = NULL;
  for (i = 0; i < len; i++)
    {
      name = args[i].name;
      if (name)
	{
	  switch (resource_type(name))
	    {
	    case XM_STRING_TABLE:
	      FREE((XmStringTable *)(args[i].value));
	      break;
	    case XM_WIDGET_LIST:
	      FREE((Widget *)(args[i].value));
	      break;
	    case XM_CALLBACK:
	      cl = (XtCallbackRec *)(args[i].value);
	      for (j = 0 ;; j++)
		{
		  if (cl[j].callback == NULL) break;
		  data = (XEN)(cl[j].closure);
		  XEN_LIST_SET(data, CALLBACK_STRUCT_TYPE, C_TO_XEN_INT(callback_struct_type(w, name)));
		}
	      FREE(cl);
	      break;

	    case XM_DROP_CALLBACK:
	      j = map_over_protected_elements(find_dropproc, (unsigned long)w);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_dropproc, (unsigned long)XEN_FALSE);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      else fprintf(stderr,"can't fixup drop proc!");
	      break;
	    case XM_DRAG_CALLBACK:
	      j = map_over_protected_elements(find_dragproc, (unsigned long)w);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_dragproc, (unsigned long)XEN_FALSE);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      else fprintf(stderr,"can't fixup drag proc!");
	      break;
	    case XM_QUALIFY_CALLBACK:
	      j = map_over_protected_elements(find_qualifyproc, (unsigned long)w); /* see if one already exists */
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_qualifyproc, (unsigned long)XEN_FALSE); /* i.e. find the unset one */
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      break;
	    case XM_SEARCH_CALLBACK:
	      j = map_over_protected_elements(find_searchproc, (unsigned long)w);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_searchproc, (unsigned long)XEN_FALSE);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      break;
	    case XM_ORDER_CALLBACK:
	      j = map_over_protected_elements(find_orderproc, (unsigned long)w);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_orderproc, (unsigned long)XEN_FALSE);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      break;
	    case XM_POPUP_CALLBACK:
	      j = map_over_protected_elements(find_popupchild, (unsigned long)w);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(data, CALLBACK_GC_LOC)));
		}
	      j = map_over_protected_elements(find_popupchild, (unsigned long)XEN_FALSE);
	      if (j >= 0)
		{
		  data = xm_protected_element(j);
		  XEN_LIST_SET(data, CALLBACK_DATA, C_TO_XEN_Widget(w));
		}
	      break;
	    default:
	      break;
	    }
	}
    }
}

static int xmstringtable_length(Widget w, char *name)
{
  /* it's not safe here to search for 0 as end of table, so where possible we'll match resources with counts */
  int len = 0;
  if (strcmp(name, XmNitems) == 0) XtVaGetValues(w, XmNitemCount, &len, NULL);
  else if (strcmp(name, XmNlistItems) == 0) XtVaGetValues(w, XmNlistItemCount, &len, NULL);
  else if (strcmp(name, XmNselectedItems) == 0) XtVaGetValues(w, XmNselectedItemCount, &len, NULL);
  else if (strcmp(name, XmNhistoryItems) == 0) XtVaGetValues(w, XmNhistoryItemCount, &len, NULL);
  else if (strcmp(name, XmNfileListItems) == 0) XtVaGetValues(w, XmNfileListItemCount, &len, NULL);
  else if (strcmp(name, XmNdirListItems) == 0) XtVaGetValues(w, XmNdirListItemCount, &len, NULL);
#if MOTIF_2
  else if (strcmp(name, XmNdetail) == 0) XtVaGetValues(w, XmNdetailCount, &len, NULL);
  else if (strcmp(name, XmNvalues) == 0) XtVaGetValues(w, XmNnumValues, &len, NULL);
#endif
  else XtVaGetValues(w, XmNbuttonCount, &len, NULL);
  return(len);
}

static XEN C_TO_XEN_ANY(Widget w, char *name, unsigned long *v)
{
  /* XtGetValues -- a list of pairs: resource-name place-holder where we fill in the 2nd element */
  unsigned long value, len;
  Arg a[1];
  int j;
  value = v[0];
  switch (resource_type(name))
    {
    case XM_INT:	      return(C_TO_XEN_INT(value));
    case XM_ULONG:	      return(C_TO_XEN_ULONG(value));
    case XM_UCHAR:	      return(C_TO_XEN_char(value));
    case XM_FLOAT:	      return(C_TO_XEN_DOUBLE(value));
    case XM_STRING:	      return(C_TO_XEN_STRING((char *)value));
    case XM_STRING_OR_XMSTRING: /* fileselectionbox here , not parsemapping */
    case XM_XMSTRING:	      return(C_TO_XEN_XmString((XmString)value));
    case XM_STRING_TABLE:     return(C_TO_XEN_XmStringTable((XmStringTable)value, xmstringtable_length(w, name)));
#if MOTIF_2
    case XM_RENDER_TABLE:     return(C_TO_XEN_XmRenderTable((XmRenderTable)value));
    case XM_TAB_LIST:	      return(C_TO_XEN_XmTabList((XmTabList)value));
#endif
    case XM_WIDGET:	      return(C_TO_XEN_Widget((Widget)value));
    case XM_WIDGET_LIST:      /* (|XtGetValues c1 (list |XmNchildren 0) 1) */
#if MOTIF_2
      if (strcmp(name, XmNchildren) == 0)
	XtSetArg(a[0], XmNnumChildren, &len);             /* Composite */
      else XtSetArg(a[0], XmNselectedObjectCount, &len);  /* Container */
#else
      XtSetArg(a[0], XmNnumChildren, &len);
#endif
      XtGetValues(w, a, 1);
      return(C_TO_XEN_Widgets((Widget *)value, (int)len));
      break;
    case XM_BOOLEAN:	      return(C_TO_XEN_BOOLEAN(value));
    case XM_SEARCH_CALLBACK:
      j = map_over_protected_elements(find_searchproc, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_DROP_CALLBACK:
      j = map_over_protected_elements(find_dropproc, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_DRAG_CALLBACK:
      j = map_over_protected_elements(find_dragproc, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_ORDER_CALLBACK:
      j = map_over_protected_elements(find_orderproc, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_QUALIFY_CALLBACK:
      j = map_over_protected_elements(find_qualifyproc, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_ALLOC_COLOR_CALLBACK:
      return(xm_XmColorAllocationProc);
      break;
    case XM_SCREEN_COLOR_CALLBACK:
      return(xm_XmColorCalculationProc);
      break;
    case XM_POPUP_CALLBACK:
      j = map_over_protected_elements(find_popupchild, (unsigned long)w);
      if (j >= 0) return(XEN_LIST_REF(xm_protected_element(j), CALLBACK_FUNC));
      break;
    case XM_TRANSFER_CALLBACK:
      return(xm_XtSelectionCallback_Descr);
    case XM_CONVERT_CALLBACK:
      return(xm_XtConvertSelectionIncr_Descr);
    case XM_CALLBACK:	   
      /* this can't work because we don't know what the desired callback was, so we can't search the gc table */
      /*   and if the callback was a C procedure, what good would its address be in this context? */
      /*   (XtGetValues_1 would need to pass the entire Arg or something) */
      return(C_TO_XEN_ULONG(value));
      break;

    case XM_PIXEL:	      return(C_TO_XEN_Pixel(value));
    case XM_PIXMAP:	      return(C_TO_XEN_Pixmap(value));
    case XM_XFONTSTRUCT:      return(C_TO_XEN_XFontStruct((XFontStruct *)value));
    case XM_DIMENSION:	      return(C_TO_XEN_Dimension(value));
    case XM_ATOM:	      return(C_TO_XEN_Atom(value));
    case XM_TEXT_SOURCE:      return(C_TO_XEN_XmTextSource((XmTextSource)value));
    case XM_ATOM_LIST:	      
      if (strcmp(name, XmNexportTargets) == 0)            /* DragContext */
	XtSetArg(a[0], XmNnumExportTargets, &len);        /* DropSite */
      else XtSetArg(a[0], XmNnumImportTargets, &len);
      XtGetValues(w, a, 1);
      return(C_TO_XEN_Atoms((Atom *)value, (int)len));
      break;
    case XM_STRING_LIST:                                  /* ApplicationShell */
      XtSetArg(a[0], XmNargc, &len);
      XtGetValues(w, a, 1);
      return(C_TO_XEN_Strings((char **)value, (int)len));
      break;
    case XM_CHARSET_TABLE:    
      XtSetArg(a[0], XmNbuttonCount, &len); /* may not be long enough... */
      XtGetValues(w, a, 1);
      return(C_TO_XEN_Strings((char **)value, (int)len));
      break;
#if (!XM_DISABLE_DEPRECATED)
    case XM_FONTLIST:	      return(C_TO_XEN_XmFontList((XmFontList)value));
#endif
    case XM_COLORMAP:	      return(C_TO_XEN_Colormap(value));
    case XM_KEYSYM:	      return(C_TO_XEN_KeySym(value));
    case XM_KEYSYM_TABLE:     
      XtSetArg(a[0], XmNbuttonCount, &len);
      XtGetValues(w, a, 1);
      return(C_TO_XEN_KeySyms((KeySym *)value, (int)len));
      break;
    case XM_SCREEN:	      return(C_TO_XEN_Screen((Screen *)value));
    case XM_WINDOW:	      return(C_TO_XEN_Window((Window)value));
    case XM_VISUAL:	      return(C_TO_XEN_Visual((Visual *)value));
    case XM_INT_TABLE:	      
#if MOTIF_2
      if (strcmp(name, XmNdetailOrder) == 0) 
	XtSetArg(a[0], XmNdetailOrderCount, &len); 
      else
	{
	  if (strcmp(name, XmNselectionArray) == 0) 
	    XtSetArg(a[0], XmNselectionArrayCount, &len); 
	  else XtSetArg(a[0], XmNselectedPositionCount, &len);
	}
      XtGetValues(w, a, 1);
      return(C_TO_XEN_Ints((int *)value, (int)len));
#endif
      break;
    case XM_RECTANGLE_LIST:                              /* XmNrectangles exists but is not documented */
      XtSetArg(a[0], XmNnumDropRectangles, &len);
      XtGetValues(w, a, 1);
      return(C_TO_XEN_XRectangles((XRectangle *)value, (int)len));
      break;
    case XM_WIDGET_CLASS:     return(C_TO_XEN_WidgetClass((WidgetClass)value));
    case XM_STRING_OR_INT:
      if ((w) &&
	  ((XmIsText(w)) || (XmIsTextField(w))))
	return(C_TO_XEN_STRING((char *)value));
      else return(C_TO_XEN_INT((int)value));
    }
  return(C_TO_XEN_ULONG(value)); /* fallback */
}

static XEN C_TO_XEN_Args(Widget w, Arg *args, int len)
{
  /* here XtGetValues (or equivalent) has filled in the resource values and we need to pass them back
   *   to scheme properly wrapped
   */
  int i, loc;
  XEN lst = XEN_EMPTY_LIST;
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--) 
    lst = XEN_CONS_2(C_TO_XEN_STRING(args[i].name),
		     C_TO_XEN_ANY(w, args[i].name, 
				  (unsigned long *)(args[i].value)),
		     lst);
  xm_unprotect_at(loc);
  return(lst);
}

/* (|XtGetValues c1 (list |XmNx 0) 1) */

static XEN gxm_XtGetValues_1(XEN arg1, XEN larg2, int len)
{
  Arg *args;
  unsigned long *locs;
  Widget w;
  XEN val, arg2;
  int i;
  char *name;
  /* here we need to make sure the ref args are ok from C's point of view */
  if (len <= 0) return(XEN_FALSE);
  w = XEN_TO_C_Widget(arg1);
  arg2 = XEN_COPY_ARG(larg2);
  args = (Arg *)CALLOC(len, sizeof(Arg));
  locs = (unsigned long *)CALLOC(len, sizeof(unsigned long));
  for (i = 0; i < len; i++, arg2 = XEN_CDDR(arg2))
    {
      name = XEN_TO_C_STRING(XEN_CAR(arg2));
      XtSetArg(args[i], name, &(locs[i]));
    }
  XtGetValues(w, args, len);
  val = C_TO_XEN_Args(w, args, len);
  FREE(args);
  FREE(locs);
  return(val);
}

#endif


/* -------------------------------- gc protection -------------------------------- */

static XEN xm_protected = XEN_FALSE;
static int xm_protected_size = 0;
static XEN xm_gc_table = XEN_FALSE;
static int last_xm_unprotect = -1;

static int xm_protect(XEN obj)
{
  int i, new_size;
  XEN new_table;
  XEN *older, *newer;
  older = XEN_VECTOR_ELEMENTS(xm_protected);
  if (last_xm_unprotect >= 0)
    {
      i = last_xm_unprotect;
      if (XEN_FALSE_P(older[i]))
	{
	  older[i] = obj;
	  last_xm_unprotect = -1;
	  return(i);
	}
      last_xm_unprotect = -1;
    }
  for (i = 0; i < xm_protected_size; i++)
    if (XEN_FALSE_P(older[i]))
      {
	older[i] = obj;
	return(i);
      }
  new_size = xm_protected_size * 2;
  new_table = XEN_MAKE_VECTOR(new_size, XEN_FALSE);
  newer = XEN_VECTOR_ELEMENTS(new_table);
  for (i = 0; i < xm_protected_size; i++)
    {
      newer[i] = older[i];
      older[i] = XEN_FALSE;
    }
  newer[xm_protected_size] = obj;
  XEN_VECTOR_SET(xm_gc_table, 0, new_table);
  i = xm_protected_size;
  xm_protected_size = new_size;
  xm_protected = new_table;
  return(i);
}

static void xm_unprotect(XEN obj)
{
  int i;
  XEN *velts;
  velts = XEN_VECTOR_ELEMENTS(xm_protected);
  for (i = 0; i < xm_protected_size; i++)
    if (XEN_EQ_P(velts[i], obj))
      {
	velts[i] = XEN_FALSE;
	last_xm_unprotect = i;
	return;
      }
}

static void xm_unprotect_at(int ind)
{
  XEN *velts;
  velts = XEN_VECTOR_ELEMENTS(xm_protected);
  velts[ind] = XEN_FALSE;
  last_xm_unprotect = ind;
}

static int map_over_protected_elements(int (*func)(XEN val, int loc, unsigned long fid), unsigned long id)
{
  int i;
  XEN *velts;
  velts = XEN_VECTOR_ELEMENTS(xm_protected);
  for (i = 0; i < xm_protected_size; i++)
    if (func(velts[i], i, id))
      return(i);
  return(-1);
}

static XEN xm_protected_element(int loc)
{
  XEN *velts;
  velts = XEN_VECTOR_ELEMENTS(xm_protected);
  return(velts[loc]);
}

static XEN xm_gc_elements(void)
{
  return(xm_protected);
}

/* 
   (define (gc-summary)
     (map (lambda (n) 
            (car n))
          (remove-if (lambda (n) 
                       (not (list? n))) 
                     (vector->list (xm-gc-elements)))))
*/



/* ----------------------------------------------------------------------------------------------------
 *
 *                            *         *  *         *
 *                             *       *   **       **
 *                              *     *    * *     * *
 *                               *   *     *  *   *  *
 *                                * *      *   * *   *
 *                                 *       *    *    *
 *                                * *      *         *
 *                               *   *     *         *
 *                              *     *    *         *
 *                             *       *   *         *
 *                            *         *  *         *
 * ----------------------------------------------------------------------------------------------------
 */

/* Motif */
#if HAVE_MOTIF

#if NEED_XtIsSubClass
static int XtIsSubClass(Widget w, WidgetClass wc) {return(0);}
#endif

/* weird order of procedures here and throughout caused by the C-header scripts --
 *   basically I forgot to reverse the main lists before pouring out the code,
 *   so everything is slightly backwards
 */

static int XEN_TO_C_INT_DEF(XEN len, XEN lst) 
{
  if (XEN_INTEGER_P(len))
    return(XEN_TO_C_INT(len));
  else
    {
      int list_len;
      list_len = XEN_LIST_LENGTH(lst);
      return((int)(list_len / 2));
    }
}

#if MOTIF_2
static XEN gxm_XmTransferDone(XEN arg1, XEN arg2)
{
  #define H_XmTransferDone "void XmTransferDone(XtPointer transfer_id, XmTransferStatus status) completes a data transfer"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XmTransferDone", "XtPointer");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTransferDone", "XmTransferStatus");
  XmTransferDone((XtPointer)XEN_TO_C_ULONG(arg1), (XmTransferStatus)XEN_TO_C_INT(arg2));
  return(arg1);
}

static XEN gxm_XmTransferSendRequest(XEN arg1, XEN arg2)
{
  #define H_XmTransferSendRequest "void XmTransferSendRequest(XtPointer transfer_id, Time time) transfers a MULTIPLE request"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XmTransferSendRequest", "XtPointer");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTransferSendRequest", "Time");
  XmTransferSendRequest((XtPointer)XEN_TO_C_ULONG(arg1), XEN_TO_C_Time(arg2));
  return(arg1);
}

static XEN gxm_XmTransferStartRequest(XEN arg1)
{
  #define H_XmTransferStartRequest "void XmTransferStartRequest(XtPointer transfer_id) begins a MULTIPLE transfer"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XmTransferStartRequest", "XtPointer");
  XmTransferStartRequest((XtPointer)XEN_TO_C_ULONG(arg1));
  return(arg1);
}

static XEN gxm_XmTransferSetParameters(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmTransferSetParameters "void XmTransferSetParameters(XtPointer transfer_id, XtPointer parm, int parm_fmt, \
unsigned long parm_length, Atom parm_type)  establishes parameters to be passed by the next call to XmTransferValue"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XmTransferSetParameters", "XtPointer");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmTransferSetParameters", "XtPointer");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTransferSetParameters", "an integer");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XmTransferSetParameters", "unsigned long");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg5), arg5, 5, "XmTransferSetParameters", "an Atom");
  XmTransferSetParameters((XtPointer)XEN_TO_C_ULONG(arg1), 
			  (XtPointer)XEN_TO_C_ULONG(arg2), 
			  XEN_TO_C_INT(arg3),
			  XEN_TO_C_ULONG(arg4), 
			  XEN_TO_C_Atom(arg5));
  return(arg1);
}

static void gxm_TransferValueProc(Widget w, XtPointer context, XtPointer info)
{
  XEN descr = (XEN)context;
  XEN_CALL_3(XEN_LIST_REF(descr, 0),
	     C_TO_XEN_Widget(w),
	     XEN_LIST_REF(descr, 1),
	     C_TO_XEN_XmSelectionCallbackStruct((XmSelectionCallbackStruct *)info),
	     __FUNCTION__);
}

static XEN gxm_XmTransferValue(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmTransferValue "void XmTransferValue(XtPointer transfer_id, Atom target, XtCallbackProc proc, XtPointer client_data, Time time) \
transfers data to a destination"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XmTransferValue", "XtPointer");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmTransferValue", "an Atom");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 3), arg3, 3, "XmTransferValue", "XtCallbackProc (3 args)");
  XEN_ASSERT_TYPE(XEN_Time_P(arg5), arg5, 5, "XmTransferValue", "Time");
  XmTransferValue((XtPointer)XEN_TO_C_ULONG(arg1), 
		  XEN_TO_C_Atom(arg2), 
		  gxm_TransferValueProc,
		  (XtPointer)XEN_LIST_2(arg3, arg4),
		  XEN_TO_C_Time(arg5));
  return(arg1);
}
#endif

static XEN gxm_new_widget(const char *caller, Widget (*func)(Widget parent, char *name, ArgList al, Cardinal ac), XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, caller, "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, caller, "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, caller, "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, caller, "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg3);
    w = (*func)(XEN_TO_C_Widget(arg1), 
		XEN_TO_C_STRING(arg2), 
		args, 
		arglen = XEN_TO_C_INT_DEF(arg4, arg3));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmCreateMenuShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateMenuShell "Widget XmCreateMenuShell(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MenuShell widget creation function"
  return(gxm_new_widget("XmCreateMenuShell", XmCreateMenuShell, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmProcessTraversal(XEN arg1, XEN arg2)
{
  #define H_XmProcessTraversal "Boolean XmProcessTraversal(Widget widget, XmTraversalDirection direction) determines which \
component receives keyboard events when a widget has the focus"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmProcessTraversal", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmProcessTraversal", "XmTraversalDirection");
  return(C_TO_XEN_BOOLEAN(XmProcessTraversal(XEN_TO_C_Widget(arg1), (XmTraversalDirection)XEN_TO_C_INT(arg2))));
}

static XEN gxm_XmGetFocusWidget(XEN arg1)
{
  #define H_XmGetFocusWidget "Widget XmGetFocusWidget(Widget widget) returns the ID of the widget that has keyboard focus"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetFocusWidget", "Widget");
  return(C_TO_XEN_Widget(XmGetFocusWidget(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmGetTabGroup(XEN arg1)
{
  #define H_XmGetTabGroup "Widget XmGetTabGroup(Widget widget) returns the widget ID of a tab group"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetTabGroup", "Widget");
  return(C_TO_XEN_Widget(XmGetTabGroup(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmGetVisibility(XEN arg1)
{
  #define H_XmGetVisibility "XmVisibility XmGetVisibility(Widget widget) determines if a widget is visible"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetVisibility", "Widget");
  return(C_TO_XEN_INT(XmGetVisibility(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmIsTraversable(XEN arg1)
{
  #define H_XmIsTraversable "Boolean XmIsTraversable(Widget widget) identifies whether a widget can be traversed"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmIsTraversable", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsTraversable(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmGetDestination(XEN arg1)
{
  #define H_XmGetDestination "Widget XmGetDestination(Display *display) gets the current destination widget for paste etc"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmGetDestination", "Display*");
  return(C_TO_XEN_Widget(XmGetDestination(XEN_TO_C_Display(arg1))));
}

#if MOTIF_2
static XEN gxm_XmRenderTableAddRenditions(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmRenderTableAddRenditions "XmRenderTable XmRenderTableAddRenditions(XmRenderTable oldtable, \
XmRendition *renditions, Cardinal rendition_count, XmMergeMode merge_mode) adds renditions to a render table"
  /* DIFF: XmRenderTableAddRenditions arg2 is list of Renditions, arg1 can be #f = NULL
   */
  int len, listlen;
  XmRendition *rs;
  XmRenderTable res;
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1) || XEN_FALSE_P(arg1), arg1, 1, "XmRenderTableAddRenditions", "XmRenderTable");
  XEN_ASSERT_TYPE(XEN_LIST_P_WITH_LENGTH(arg2, listlen), arg2, 2, "XmRenderTableAddRenditions", "list of XmRendition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmRenderTableAddRenditions", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmRenderTableAddRenditions", "XmMergeMode");
  len = XEN_TO_C_INT(arg3);
  if (len > listlen) len = listlen;
  if (len <= 0) return(XEN_FALSE);
  rs = XEN_TO_C_XmRenditions(arg2, len);
  res = XmRenderTableAddRenditions(XEN_FALSE_P(arg1) ? NULL : XEN_TO_C_XmRenderTable(arg1), 
				   rs, (Cardinal)len, 
				   (XmMergeMode)XEN_TO_C_INT(arg4));
  FREE(rs);
  return(C_TO_XEN_XmRenderTable(res));
}

static XEN gxm_XmRenderTableRemoveRenditions(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmRenderTableRemoveRenditions "XmRenderTable XmRenderTableRemoveRenditions(XmRenderTable oldtable, XmStringTag *tags, int tag_count) \
removes renditions"
  /* DIFF: XmRenderTableRemoveRenditions arg2 is list of strings
   */
  int len = 0;
  XmStringTag *tags = NULL;
  XmRenderTable rt = NULL;
  if (XEN_NOT_BOUND_P(arg1) || XEN_FALSE_P(arg1)) return(XEN_FALSE);
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1) || XEN_FALSE_P(arg1), arg1, 1, "XmRenderTableRemoveRenditions", "XmRenderTable");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2) || XEN_FALSE_P(arg2) || XEN_NOT_BOUND_P(arg2), arg2, 2, "XmRenderTableRemoveRenditions", "XmStringTag*");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmRenderTableRemoveRenditions", "int");
  if (XEN_INTEGER_P(arg3)) 
    {
      len = XEN_TO_C_INT(arg3); 
      if (len <= 0) return(XEN_FALSE);
    }
  else 
    {
      if (XEN_LIST_P(arg2))
	len = XEN_LIST_LENGTH(arg2);
    }
  if (XEN_BOUND_P(arg2)) tags = (XmStringTag *)XEN_TO_C_Strings(arg2, len);
  rt = XmRenderTableRemoveRenditions(XEN_TO_C_XmRenderTable(arg1), tags, len);
  if (tags) FREE(tags);
  return(C_TO_XEN_XmRenderTable(rt));
}

static XEN gxm_XmRenderTableCopy(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmRenderTableCopy "XmRenderTable XmRenderTableCopy(XmRenderTable table, XmStringTag *tags, int tag_count) copies renditions"
  /* DIFF: XmRenderTableCopy arg2 is list of strings
   */
  int len = 0;
  XmStringTag *tags = NULL;
  XmRenderTable rt = NULL;
  if (XEN_NOT_BOUND_P(arg1) || XEN_FALSE_P(arg1)) return(XEN_FALSE);
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1), arg1, 1, "XmRenderTableCopy", "XmRenderTable");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2) || XEN_FALSE_P(arg2) || XEN_NOT_BOUND_P(arg2), arg2, 2, "XmRenderTableCopy", "XmStringTag*");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmRenderTableCopy", "int");
  if (XEN_INTEGER_P(arg3)) 
    {
      len = XEN_TO_C_INT(arg3); 
      if (len <= 0) return(XEN_FALSE);
    }
  else 
    {
      if (XEN_LIST_P(arg2))
	len = XEN_LIST_LENGTH(arg2);
    }
  if (XEN_BOUND_P(arg2)) tags = (XmStringTag *)XEN_TO_C_Strings(arg2, len);
  rt = XmRenderTableCopy(XEN_TO_C_XmRenderTable(arg1), tags, len);
  if (tags) FREE(tags);
  return(C_TO_XEN_XmRenderTable(rt));
}

static XEN gxm_XmRenderTableFree(XEN arg1)
{
  #define H_XmRenderTableFree "void XmRenderTableFree(XmRenderTable table)  recovers memory"
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1), arg1, 1, "XmRenderTableFree", "XmRenderTable");
  XmRenderTableFree(XEN_TO_C_XmRenderTable(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmRenderTableGetTags(XEN arg1)
{
  #define H_XmRenderTableGetTags "int XmRenderTableGetTags(XmRenderTable table) gets rendition tags (list of strings)"
  /* DIFF: XmRenderTableGetTags omits arg2, returns list of strings
   */
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  XmStringTag *str;
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1), arg1, 1, "XmRenderTableGetTags", "XmRenderTable");
  loc = xm_protect(lst);
  len = XmRenderTableGetTags(XEN_TO_C_XmRenderTable(arg1), &str);
  if (str)
    {
      for (i = len - 1; i >= 0; i--)
	{
	  lst = XEN_CONS(C_TO_XEN_STRING(str[i]), lst);
	  free(str[i]);
	}
      free(str);
    }
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmRenderTableGetRendition(XEN arg1, XEN arg2)
{
  #define H_XmRenderTableGetRendition "XmRendition XmRenderTableGetRendition(XmRenderTable table, XmStringTag tag) \
matches a rendition tag"
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1), arg1, 1, "XmRenderTableGetRendition", "XmRenderTable");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmRenderTableGetRendition", "XmStringTag");
  return(C_TO_XEN_XmRendition(XmRenderTableGetRendition(XEN_TO_C_XmRenderTable(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmRenderTableGetRenditions(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmRenderTableGetRenditions "XmRendition *XmRenderTableGetRenditions(XmRenderTable table, XmStringTag *tags, Cardinal tag_count) \
matches rendition tags"
  /* DIFF: XmRenderTableGetRenditions returns list of XmRenditions, arg2 is list of strings
   */
  int i, len = 0, loc;
  XEN lst = XEN_EMPTY_LIST;
  XmRendition *rs;
  XmStringTag *tags;
  if ((XEN_NOT_BOUND_P(arg1)) || XEN_NOT_BOUND_P(arg2) || XEN_FALSE_P(arg2)) return(XEN_FALSE);
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg1), arg1, 1, "XmRenderTableGetRenditions", "XmRenderTable");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmRenderTableGetRenditions", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmRenderTableGetRenditions", "int");
  if (XEN_BOUND_P(arg3))
    len = XEN_TO_C_INT(arg3);
  else len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) return(XEN_FALSE);
  loc = xm_protect(lst);
  tags = (XmStringTag *)XEN_TO_C_Strings(arg2, len);
  rs = XmRenderTableGetRenditions(XEN_TO_C_XmRenderTable(arg1), tags, (Cardinal)len);
  FREE(tags);
  for (i = len - 1; i >= 0; i--)
    {
      lst = XEN_CONS(C_TO_XEN_XmRendition(rs[i]), lst);
      XmRenditionFree(rs[i]);
    }
  free(rs);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmRenditionCreate(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmRenditionCreate "XmRendition XmRenditionCreate(Widget widget, XmStringTag tag, ArgList arglist, Cardinal argcount) \
creates a rendition"
  XmRendition w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRenditionCreate", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmRenditionCreate", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmRenditionCreate", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmRenditionCreate", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg3);
    w = XmRenditionCreate(XEN_TO_C_Widget(arg1), 
			  XEN_TO_C_STRING(arg2), 
			  args, arglen = XEN_TO_C_INT_DEF(arg4, arg3));
    if (args) FREE(args);
  }
  return(C_TO_XEN_XmRendition(w));
}

static XEN gxm_XmRenditionFree(XEN arg1)
{
  #define H_XmRenditionFree "void XmRenditionFree(XmRendition rendition) frees a rendition"
  XEN_ASSERT_TYPE(XEN_XmRendition_P(arg1), arg1, 1, "XmRenditionFree", "XmRendition");
  XmRenditionFree(XEN_TO_C_XmRendition(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmRenditionRetrieve(XEN arg1, XEN larg2, XEN arg3)
{
  #define H_XmRenditionRetrieve "void XmRenditionRetrieve(XmRendition rendition, ArgList arglist, Cardinal argcount) \
retrieves rendition resources"
  XEN_ASSERT_TYPE(XEN_XmRendition_P(arg1), arg1, 1, "XmRenditionRetrieve", "XmRendition");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg2), larg2, 2, "XmRenditionRetrieve", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmRenditionRetrieve", "int");
  {
    /* this is a kind of XtGetvalues, not set
     */
    Arg *args;
    unsigned long *locs;
    XEN val;
    int i, len;
    XmRendition r;
    char *name;
    XEN arg2;
    arg2 = XEN_COPY_ARG(larg2);
    /* here we need to make sure the ref args are ok from C's point of view */
    r = XEN_TO_C_XmRendition(arg1);
    len = XEN_TO_C_INT_DEF(arg3, arg2);
    if (len <= 0) XEN_ASSERT_TYPE(0, arg3, 3, "XmRenditionRetrieve", "positive integer");
    args = (Arg *)CALLOC(len, sizeof(Arg));
    locs = (unsigned long *)CALLOC(len, sizeof(unsigned long));
    for (i = 0; i < len; i++, arg2 = XEN_CDDR(arg2))
      {
	name = XEN_TO_C_STRING(XEN_CAR(arg2));
	XtSetArg(args[i], name, &(locs[i]));
      }
    XmRenditionRetrieve(r, args, len);
    val = C_TO_XEN_Args((Widget)r, args, len);
    FREE(args);
    FREE(locs);
    return(val);
  }
}

static XEN gxm_XmRenditionUpdate(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmRenditionUpdate "void XmRenditionUpdate(XmRendition rendition, ArgList arglist, Cardinal argcount) \
modifies resources"
  XEN_ASSERT_TYPE(XEN_XmRendition_P(arg1), arg1, 1, "XmRenditionUpdate", "XmRendition");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmRenditionUpdate", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmRenditionUpdate", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg2);
    XmRenditionUpdate(XEN_TO_C_XmRendition(arg1), 
		      args, arglen = XEN_TO_C_INT_DEF(arg3, arg2));
    if (args) FREE(args);
  }
  return(XEN_FALSE);
}

static XEN gxm_XmRenderTableCvtToProp(XEN arg1, XEN arg2)
{
  #define H_XmRenderTableCvtToProp "unsigned int XmRenderTableCvtToProp(Widget widget, XmRenderTable table) \
converts a render table to a string representation -> (val props)"
  /* DIFF: XmRenderTableCvtToProp omits and rtns arg3
   */
  char *buf;
  unsigned int val;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRenderTableCvtToProp", "Widget");
  XEN_ASSERT_TYPE(XEN_XmRenderTable_P(arg2), arg2, 2, "XmRenderTableCvtToProp", "XmRenderTable");
  val = XmRenderTableCvtToProp(XEN_TO_C_Widget(arg1), XEN_TO_C_XmRenderTable(arg2), &buf);
  return(XEN_LIST_2(C_TO_XEN_ULONG(val),
		    C_TO_XEN_STRING(buf)));
}

static XEN gxm_XmRenderTableCvtFromProp(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmRenderTableCvtFromProp "XmRenderTable XmRenderTableCvtFromProp(Widget widget, char *property, unsigned int length) \
converts from a string representation to a render table"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRenderTableCvtFromProp", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmRenderTableCvtFromProp", "char*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XmRenderTableCvtFromProp", "unsigned int");
  return(C_TO_XEN_XmRenderTable(XmRenderTableCvtFromProp(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_ULONG(arg3))));
}

static XEN gxm_XmTabListInsertTabs(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTabListInsertTabs "XmTabList XmTabListInsertTabs(XmTabList oldlist, XmTab *tabs, Cardinal tab_count, int position) \
inserts tabs into a tab list"
  /* DIFF: XmTabListInsertTabs arg2 is list of XmTabs (can be #f = NULL)
   */
  int len, listlen;
  XmTab *tabs;
  XmTabList tl;
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1) || XEN_FALSE_P(arg1), arg1, 1, "XmTabListInsertTabs", "XmTabList");
  XEN_ASSERT_TYPE(XEN_LIST_P_WITH_LENGTH(arg2, listlen), arg2, 2, "XmTabListInsertTabs", "list of XmTab");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTabListInsertTabs", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTabListInsertTabs", "int");
  len = XEN_TO_C_INT(arg3);
  if (len > listlen) len = listlen;
  if (len <= 0) return(XEN_FALSE);
  tabs = XEN_TO_C_XmTabs(arg2, len);
  tl = XmTabListInsertTabs(XEN_FALSE_P(arg1) ? NULL : XEN_TO_C_XmTabList(arg1), 
			   tabs, len, XEN_TO_C_INT(arg4));
  FREE(tabs);
  return(C_TO_XEN_XmTabList(tl));
}

static XEN gxm_XmTabListCopy(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTabListCopy "XmTabList XmTabListCopy(XmTabList tablist, int offset, Cardinal count) creates \
a new tab list from an existing list"
  /* Motif documentation incorrectly calls this "XmTabListTabCopy" */
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListCopy", "XmTabList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTabListCopy", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTabListCopy", "int");
  return(C_TO_XEN_XmTabList(XmTabListCopy(XEN_TO_C_XmTabList(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmTabListTabCount(XEN arg1)
{
  #define H_XmTabListTabCount "Cardinal XmTabListTabCount(XmTabList tablist) returns length of tablist"
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListTabCount", "XmTabList");  
  return(C_TO_XEN_INT(XmTabListTabCount(XEN_TO_C_XmTabList(arg1))));
}


static XEN gxm_XmTabListGetTab(XEN arg1, XEN arg2)
{
  #define H_XmTabListGetTab "XmTab XmTabListGetTab(XmTabList tablist, Cardinal position) returns a copy of a tab"
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListGetTab", "XmTabList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTabListGetTab", "int");
  return(C_TO_XEN_XmTab(XmTabListGetTab(XEN_TO_C_XmTabList(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XmTabListReplacePositions(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTabListReplacePositions "XmTabList XmTabListReplacePositions(XmTabList oldlist, Cardinal *position_list, XmTab *tabs, Cardinal tab_count) \
creates a new tab list with replacement tabs"
  /* DIFF: XmTabListReplacePositions arg2 is list of ints, arg3 is list of XmTabs
   */
  Cardinal *ts;
  int len;
  XEN res;
  XmTab *tabs;
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListReplacePositions", "XmTabList");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmTabListReplacePositions", "list of ints");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmTabListReplacePositions", "list of XmTab");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmTabListReplacePositions", "int");
  if (XEN_INTEGER_P(arg4)) len = XEN_TO_C_INT(arg4); else len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) return(XEN_FALSE);
  ts = XEN_TO_C_Cardinals(arg2, len);
  tabs = XEN_TO_C_XmTabs(arg3, len);
  res = C_TO_XEN_XmTabList(XmTabListReplacePositions(XEN_TO_C_XmTabList(arg1), ts, tabs, len));
  FREE(ts);
  FREE(tabs);
  return(res);
}

static XEN gxm_XmTabListRemoveTabs(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTabListRemoveTabs "XmTabList XmTabListRemoveTabs(XmTabList oldlist, Cardinal *position_list, Cardinal position_count) \
removes noncontiguous tabs"
  /* DIFF: XmTabListRemoveTabs arg2 is list of ints
   */
  Cardinal *ts;
  int len;
  XEN res;
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListRemoveTabs", "XmTabList");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmTabListRemoveTabs", "list of int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmTabListRemoveTabs", "int");
  if (XEN_INTEGER_P(arg3)) len = XEN_TO_C_INT(arg3); else len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) return(XEN_FALSE);
  ts = XEN_TO_C_Cardinals(arg2, len);
  res = C_TO_XEN_XmTabList(XmTabListRemoveTabs(XEN_TO_C_XmTabList(arg1), ts, len));
  FREE(ts);
  return(res);
}

static XEN gxm_XmTabCreate(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmTabCreate "XmTab XmTabCreate(float value, unsigned char units, XmOffsetModel offset_model, unsigned char alignment, char *decimal) \
creates a tab stop"
  XEN_ASSERT_TYPE(XEN_DOUBLE_P(arg1), arg1, 1, "XmTabCreate", "float");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTabCreate", "unsigned char");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTabCreate", "XmOffsetModel"); 
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTabCreate", "unsigned char");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XmTabCreate", "char*");
  return(C_TO_XEN_XmTab(XmTabCreate((float)XEN_TO_C_DOUBLE(arg1), 
				    (unsigned char)(XEN_TO_C_INT(arg2)),
				    (XmOffsetModel)XEN_TO_C_INT(arg3), 
				    (unsigned char)(XEN_TO_C_INT(arg4)),
				    XEN_TO_C_STRING(arg5))));
}

static XEN gxm_XmTabListFree(XEN arg1)
{
  #define H_XmTabListFree "void XmTabListFree(XmTabList tab) frees a tab list"
  XEN_ASSERT_TYPE(XEN_XmTabList_P(arg1), arg1, 1, "XmTabListFree", "XmTabList");
  XmTabListFree(XEN_TO_C_XmTabList(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmTabFree(XEN arg1)
{
  #define H_XmTabFree "void XmTabFree(XmTab tab) frees a tab"
  XEN_ASSERT_TYPE(XEN_XmTab_P(arg1), arg1, 1, "XmTabFree", "XmTab");
  XmTabFree(XEN_TO_C_XmTab(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmTabGetValues(XEN arg1)
{
  #define H_XmTabGetValues "float XmTabGetValues(XmTab tab) returns tab values"
  /* DIFF: XmTabGetValues tab [units offset align decimal] -> (list val units ofset align decimal)
     arg2/3/4/5 omit rtn with float 
  */
  XmOffsetModel off;
  unsigned char a1, a2;
  char **a3;
  float res;
  XEN val;
  XEN_ASSERT_TYPE(XEN_XmTab_P(arg1), arg1, 1, "XmTabGetValues", "XmTab");
  a3 = (char **)CALLOC(1, sizeof(char *));
  res = XmTabGetValues(XEN_TO_C_XmTab(arg1), &a1, &off, &a2, a3);
  val = XEN_LIST_5(C_TO_XEN_DOUBLE((double)res),
		   C_TO_XEN_INT((int)a1),
		   C_TO_XEN_INT((int)off),
		   C_TO_XEN_INT((int)a2),
		   C_TO_XEN_STRING(a3[0]));
  FREE(a3);
  return(val);
}

static XEN gxm_XmTabSetValue(XEN arg1, XEN arg2)
{
  #define H_XmTabSetValue "void XmTabSetValue(XmTab tab, float value) sets a tab stop"
  XEN_ASSERT_TYPE(XEN_XmTab_P(arg1), arg1, 1, "XmTabSetValue", "XmTab");
  XEN_ASSERT_TYPE(XEN_DOUBLE_P(arg2), arg2, 2, "XmTabSetValue", "float");
  XmTabSetValue(XEN_TO_C_XmTab(arg1), (float)XEN_TO_C_DOUBLE(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmStringTableProposeTablist(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmStringTableProposeTablist "XmTabList XmStringTableProposeTablist(XmStringTable strings, Cardinal num_strings, Widget widget, \
float pad_value, XmOffsetModel offset_model) returns a tab list"
  /* DIFF: XmStringTableProposetablist 1st arg is list of XmStrings
   */
  XmStringTable tab;
  XmTabList tabl;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XmStringTableProposeTablist", "XmStringTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmStringTableProposeTablist", "int");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XmStringTableProposeTablist", "Widget");
  XEN_ASSERT_TYPE(XEN_DOUBLE_P(arg4), arg4, 4, "XmStringTableProposeTablist", "float");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmStringTableProposeTablist", "XmOffsetModel");
  tab = XEN_TO_C_XmStringTable(arg1, XEN_TO_C_INT(arg2)); 
  tabl = XmStringTableProposeTablist(tab,
				     XEN_TO_C_INT(arg2), 
				     XEN_TO_C_Widget(arg3),
				     (float)XEN_TO_C_DOUBLE(arg4), 
				     (XmOffsetModel)XEN_TO_C_INT(arg5));
  FREE(tab);
  return(C_TO_XEN_XmTabList(tabl));
}

#define XEN_XmParseTable_P(Arg) XEN_LIST_P(Arg)

static XmParseTable XEN_TO_C_XmParseTable(XEN lst, int size)
{
  int i;
  XmParseTable pt;
  XEN val;
  if (size <= 0) return(NULL);
  pt = (XmParseTable)XtCalloc(size, sizeof(XmParseMapping));
  for (i = 0; i < size; i++)
    {
      val = XEN_LIST_REF(lst, i);
      if (XEN_XmParseMapping_P(val))
	pt[i] = XEN_TO_C_XmParseMapping(val);
      else XEN_ASSERT_TYPE(0, val, i, __FUNCTION__, "an XmParseMapping");
    }
  return(pt);
}

static XEN gxm_XmParseTableFree(XEN arg1, XEN arg2)
{
  #define H_XmParseTableFree "void XmParseTableFree(XmParseTable parse_table, Cardinal count) recovers memory"
  int len;
  XmParseTable pt;
  XEN_ASSERT_TYPE(XEN_XmParseTable_P(arg1), arg1, 1, "XmParseTableFree", "XmParseTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg2), arg2, 2, "XmParseTableFree", "int");
  if (XEN_INTEGER_P(arg2)) len = XEN_TO_C_INT(arg2); else len = XEN_LIST_LENGTH(arg1);
  pt = XEN_TO_C_XmParseTable(arg1, len);
  if (pt) XmParseTableFree(pt, len);
  return(XEN_FALSE);
}

static XEN gxm_XmParseMappingFree(XEN arg1)
{
  #define H_XmParseMappingFree "void XmParseMappingFree(XmParseMapping parse_mapping) frees a parse mapping"
  XEN_ASSERT_TYPE(XEN_XmParseMapping_P(arg1), arg1, 1, "XmParseMappingFree", "XmParseMapping");
  XmParseMappingFree(XEN_TO_C_XmParseMapping(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmParseMappingGetValues(XEN arg1, XEN larg2, XEN arg3)
{
  #define H_XmParseMappingGetValues "void XmParseMappingGetValues(XmParseMapping parse_mapping, ArgList arglist, Cardinal argcount) \
retrieves attributes of a parse mapping"
  XEN_ASSERT_TYPE(XEN_XmParseMapping_P(arg1), arg1, 1, "XmParseMappingGetValues", "XmParseMapping");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg2), larg2, 2, "XmParseMappingGetValues", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmParseMappingGetValues", "int");
  {
    Arg *args;
    unsigned long *locs;
    int len;
    XEN val, arg2;
    int i;
    char *name;
    len = XEN_TO_C_INT_DEF(arg3, larg2);
    arg2 = XEN_COPY_ARG(larg2);
    args = (Arg *)CALLOC(len, sizeof(Arg));
    locs = (unsigned long *)CALLOC(len, sizeof(unsigned long));
    for (i = 0; i < len; i++, arg2 = XEN_CDDR(arg2))
      {
	name = XEN_TO_C_STRING(XEN_CAR(arg2));
	XtSetArg(args[i], name, &(locs[i]));
      }
    XmParseMappingGetValues(XEN_TO_C_XmParseMapping(arg1), args, len);
    val = C_TO_XEN_Args(NULL, args, len);
    FREE(args);
    FREE(locs);
    return(val);
  }
}

static XEN gxm_XmParseMappingSetValues(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmParseMappingSetValues "void XmParseMappingSetValues(XmParseMapping parse_mapping, ArgList arglist, Cardinal argcount) \
sets attributes of a parse mapping"
  XEN_ASSERT_TYPE(XEN_XmParseMapping_P(arg1), arg1, 1, "XmParseMappingSetValues", "XmParseMapping");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmParseMappingSetValues", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmParseMappingSetValues", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg2);
    arglen = XEN_TO_C_INT_DEF(arg3, arg2);
    XmParseMappingSetValues(XEN_TO_C_XmParseMapping(arg1), args, arglen);
    if (args) FREE(args);
    return(XEN_FALSE);
  }
}

static XEN gxm_XmParseMappingCreate(XEN arg1, XEN arg2)
{
  #define H_XmParseMappingCreate "XmParseMapping XmParseMappingCreate(ArgList arglist, Cardinal argcount) create a parse mapping"
  XmParseMapping w;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XmParseMappingCreate", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg2), arg2, 2, "XmParseMappingCreate", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg1);
    w = XmParseMappingCreate(args, arglen = XEN_TO_C_INT_DEF(arg2, arg1));
    if (args) FREE(args);
  }
  return(C_TO_XEN_XmParseMapping(w));
}

static XEN gxm_XmStringPutRendition(XEN arg1, XEN arg2)
{
  #define H_XmStringPutRendition "XmString XmStringPutRendition(XmString string, XmStringTag rendition) places \
renditions around strings"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringPutRendition", "XmString");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringPutRendition", "XmStringTag");
  return(C_TO_XEN_XmString(XmStringPutRendition(XEN_TO_C_XmString(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmStringGenerate(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmStringGenerate "XmString XmStringGenerate(XtPointer text, XmStringTag tag, XmTextType type, XmStringTag rendition) \
generates a compound string"

  XmTextType type;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringGenerate", "XtPointer");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2) || XEN_FALSE_P(arg2), arg2, 2, "XmStringGenerate", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmStringGenerate", "XmTextType");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmStringGenerate", "XmStringTag");
  type = (XmTextType)XEN_TO_C_INT(arg3);
  if ((type < 0) || (type > 1)) XEN_ASSERT_TYPE(0, arg3, 3, "XmStringGenerate", "XmTextType");
  return(C_TO_XEN_XmString(XmStringGenerate((XtPointer)XEN_TO_C_STRING(arg1), 
					    XEN_FALSE_P(arg2) ? NULL : XEN_TO_C_STRING(arg2), 
					    type,
					    XEN_TO_C_STRING(arg4))));
}

static XEN gxm_XmStringDirectionToDirection(XEN arg1)
{
  #define H_XmStringDirectionToDirection "XmDirection XmStringDirectionToDirection(XmStringDirection direction) converts \
from XmStringDirection to XmDirection"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XmStringDirectionToDirection", "XmStringDirection");
  return(C_TO_XEN_INT(XmStringDirectionToDirection(XEN_TO_C_INT(arg1))));
}

static XEN gxm_XmDirectionToStringDirection(XEN arg1)
{
  #define H_XmDirectionToStringDirection "XmStringDirection XmDirectionToStringDirection (dir) converts an XmDirection \
value to an XmStringDirection value"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XmDirectionToStringDirection", "XmDirection");
  return(C_TO_XEN_INT(XmDirectionToStringDirection(XEN_TO_C_INT(arg1))));
}

static XEN gxm_XmStringTableParseStringArray(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmStringTableParseStringArray "XmStringTable XmStringTableParseStringArray(XtPointer *strings, Cardinal count, XmStringTag tag, \
XmTextType type, XmParseTable parse, Cardinal parse_count, XtPointer call_data) converts an array of strings \
to a compound string table"
  /* DIFF: XmStringTableParseStringArray arg1 is list of strings
   */
  char **strs;
  int len;
  XmStringTable val;
  XEN lst;
  XmTextType type;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XmStringTableParseStringArray", "list of strings");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmStringTableParseStringArray", "int");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg3) || XEN_STRING_P(arg3), arg3, 3, "XmStringTableParseStringArray", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmStringTableParseStringArray", "XmTextType");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg5) || XEN_XmParseTable_P(arg5), arg5, 5, "XmStringTableParseStringArray", "XmParseTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringTableParseStringArray", "int");
  type = (XmTextType)XEN_TO_C_INT(arg4);
  if ((type < 0) || (type > 1)) XEN_ASSERT_TYPE(0, arg4, 4, "XmStringTableParseStringArray", "XmTextType");
  len = XEN_TO_C_INT(arg2);
  if (len <= 0) return(XEN_FALSE);
  strs = XEN_TO_C_Strings(arg1, len);
  val = XmStringTableParseStringArray((XtPointer *)strs, 
				      (Cardinal)len, 
				      (XEN_FALSE_P(arg3)) ? NULL : XEN_TO_C_STRING(arg3),
				      type,
				      (XEN_FALSE_P(arg5)) ? NULL : XEN_TO_C_XmParseTable(arg5, len), 
				      XEN_TO_C_INT(arg6),
				      (XtPointer)arg7);
  FREE(strs);
  lst = C_TO_XEN_XmStringTable(val, len);
  free(val);
  return(lst);
}

static XEN gxm_XmStringTableUnparse(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XmStringTableUnparse "XtPointer * XmStringTableUnparse(XmStringTable table, Cardinal count, XmStringTag tag, XmTextType tag_type, \
XmTextType output_type, XmParseTable parse, Cardinal parse_count, XmParseModel parse_model) converts a table of \
compound strings to an array of text"
  /* DIFF: XmStringTableUnparse returns list of strings, 1st arg is list of XmStrings
   */
  XEN lst = XEN_EMPTY_LIST;
  char **tab;
  XmStringTable tb;
  int i, len, loc;
  XmTextType type1, type2;
  XmParseTable pt = NULL;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XmStringTableUnparse", "XmStringTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmStringTableUnparse", "int");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg3) || XEN_STRING_P(arg3), arg3, 3, "XmStringTableUnparse", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmStringTableUnparse", "XmTextType");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmStringTableUnparse", "XmTextType");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg6) || XEN_XmParseTable_P(arg6), arg6, 6, "XmStringTableUnparse", "XmParseTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmStringTableUnparse", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XmStringTableUnparse", "XmParseModel");
  type1 = (XmTextType)XEN_TO_C_INT(arg4);
  if ((type1 < 0) || (type1 > 1)) XEN_ASSERT_TYPE(0, arg4, 4, "XmStringTableUnparse", "XmTextType");
  type2 = (XmTextType)XEN_TO_C_INT(arg5);
  if ((type2 < 0) || (type2 > 1)) XEN_ASSERT_TYPE(0, arg5, 5, "XmStringTableUnparse", "XmTextType");
  len = XEN_TO_C_INT(arg2);
  if (len <= 0) return(XEN_FALSE);
  loc = xm_protect(lst);
  tb = XEN_TO_C_XmStringTable(arg1, len);
  if (XEN_XmParseTable_P(arg6)) pt = XEN_TO_C_XmParseTable(arg6, len);
  tab = (char **)XmStringTableUnparse(tb,
				      len, 
				      (XEN_FALSE_P(arg3)) ? NULL : XEN_TO_C_STRING(arg3), 
				      type1,
				      type2,
				      pt,
				      XEN_TO_C_INT(arg7), 
				      (XmParseModel)XEN_TO_C_INT(arg8));
  FREE(tb);
  for (i = len - 1; i >= 0; i--)
    {
      lst = XEN_CONS(C_TO_XEN_STRING(tab[i]), lst);
      free(tab[i]);
    }
  free(tab);
  free(pt);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmStringTableToXmString(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmStringTableToXmString "XmString XmStringTableToXmString(XmStringTable table, Cardinal count, XmString break_component) \
converts a compound string table to a single compound string"
  /* DIFF: XmStringTableToXmString 1st arg is list of XmStrings
   */
  int count;
  XmStringTable tab;
  XmString val;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XmStringTableToXmString", "XmStringTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmStringTableToXmString", "int");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XmStringTableToXmString", "XmString");
  count = XEN_TO_C_INT(arg2);
  if (count <= 0) return(XEN_FALSE);
  tab = XEN_TO_C_XmStringTable(arg1, count);
  val = XmStringTableToXmString(tab,
				count,
				(XEN_XmString_P(arg3)) ? XEN_TO_C_XmString(arg3) : NULL);
  FREE(tab);
  return(C_TO_XEN_XmString(val));
}

static XEN gxm_XmStringToXmStringTable(XEN arg1, XEN arg2)
{
  #define H_XmStringToXmStringTable "Cardinal XmStringToXmStringTable(XmString string, XmString break_component) \
converts a single compound string to a table of compound strings"
  /* DIFF: XmStringToXmStringTable omits and rtns (list len table)
   */
  XmStringTable tab;
  Cardinal val;
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringToXmStringTable", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2) || XEN_FALSE_P(arg2), arg2, 2, "XmStringToXmStringTable", "XmString");
  val = XmStringToXmStringTable(XEN_TO_C_XmString(arg1), 
				(XEN_XmString_P(arg2)) ? XEN_TO_C_XmString(arg2) : NULL,
				&tab);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XmStringTable(tab, val)));
}

static XEN gxm_XmStringParseText(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmStringParseText "XmString XmStringParseText(XtPointer text, XtPointer *text_end, XmStringTag tag, XmTextType type, \
XmParseTable parse_table, Cardinal parse_count, XtPointer call_data) converts a character string to a compound string"
  /* DIFF: XmStringParseText arg1 is string, arg2 is int
   */
  int loc, len;
  char *str, *tag = NULL;
  XmTextType type;
  XtPointer *intext = NULL;
  XmParseTable pt = NULL;
  XEN rtn;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringParseText", "string");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2) || XEN_FALSE_P(arg2), arg2, 2, "XmStringParseText", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XmStringParseText", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmStringParseText", "XmTextType");
  XEN_ASSERT_TYPE(XEN_XmParseTable_P(arg5), arg5, 5, "XmStringParseText", "XmParseTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringParseText", "int");
  type = (XmTextType)XEN_TO_C_INT(arg4);
  if ((type < 0) || (type > 1)) XEN_ASSERT_TYPE(0, arg4, 4, "XmStringParseText", "XmTextType");
  str = XEN_TO_C_STRING(arg1);
  if (XEN_INTEGER_P(arg2)) 
    {
      loc = XEN_TO_C_INT(arg2);
      intext = (XtPointer *)(str + loc);
    }
  if (XEN_STRING_P(arg3)) tag = XEN_TO_C_STRING(arg3);
  len = XEN_TO_C_INT(arg6);
  if (XEN_XmParseTable_P(arg5)) pt = XEN_TO_C_XmParseTable(arg5, len);
  rtn = C_TO_XEN_XmString(XmStringParseText(str, intext, tag, type, pt, len, (XtPointer)arg7));
  free(pt);
  return(rtn);
}

static XEN gxm_XmStringUnparse(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmStringUnparse "XtPointer XmStringUnparse(XmString string, XmStringTag tag, XmTextType tag_type, XmTextType output_type, \
XmParseTable parse_table, Cardinal parse_count, XmParseModel parse_model) unparses text"
  XmTextType type1, type2;
  XEN rtn;
  XmParseTable pt = NULL;
  int len;
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringUnparse", "XmString");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringUnparse", "XmStringTag");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmStringUnparse", "XmTextType");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmStringUnparse", "XmTextType");
  XEN_ASSERT_TYPE(XEN_XmParseTable_P(arg5) || XEN_FALSE_P(arg5), arg5, 5, "XmStringUnparse", "XmParseTable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringUnparse", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmStringUnparse", "XmParseModel");
  type1 = (XmTextType)XEN_TO_C_INT(arg3);
  if ((type1 < 0) || (type1 > 1)) XEN_ASSERT_TYPE(0, arg3, 3, "XmStringUnparse", "XmTextType");
  type2 = (XmTextType)XEN_TO_C_INT(arg4);
  if ((type2 < 0) || (type2 > 1)) XEN_ASSERT_TYPE(0, arg4, 4, "XmStringUnparse", "XmTextType");
  len = XEN_TO_C_INT(arg6);
  if (XEN_XmParseTable_P(arg5)) pt = XEN_TO_C_XmParseTable(arg5, len);
  rtn = C_TO_XEN_STRING((const char *)XmStringUnparse(XEN_TO_C_XmString(arg1), 
						      XEN_TO_C_STRING(arg2), 
						      type1, type2, pt, len,
						      (XmParseModel)XEN_TO_C_INT(arg7)));
  free(pt);
  return(rtn);
}

static XEN gxm_XmStringComponentCreate(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmStringComponentCreate "XmString XmStringComponentCreate(XmStringComponentType c_type, unsigned int length, XtPointer value) \
creates arbitrary components"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XmStringComponentCreate", "XmStringComponentType");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmStringComponentCreate", "unsigned int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XmStringComponentCreate", "XtPointer");
  return(C_TO_XEN_XmString(XmStringComponentCreate(XEN_TO_C_INT(arg1), 
						   XEN_TO_C_ULONG(arg2), 
						   XEN_FALSE_P(arg3) ? NULL : XEN_TO_C_STRING(arg3))));
}

static XEN gxm_XmStringGetNextTriple(XEN arg1)
{
  #define H_XmStringGetNextTriple "XmStringComponentType XmStringGetNextTriple(XmStringContext context) \
returns the type, length, and value of the next component in the compound string"
  /* DIFF: XmStringGetNextTriple omits last 2 args, returns val
   */
  unsigned int len;
  int val;
  char *ptr;
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringGetNextTriple", "XmStringContext");
  val = XmStringGetNextTriple(XEN_TO_C_XmStringContext(arg1), &len, (XtPointer *)(&ptr));
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_INT((int)len),
		    (val == XmSTRING_COMPONENT_TEXT) ? C_TO_XEN_STRING(ptr) : C_TO_XEN_ULONG((unsigned long)ptr)));
}

static XEN gxm_XmStringPeekNextTriple(XEN arg1)
{
  #define H_XmStringPeekNextTriple "XmStringComponentType XmStringPeekNextTriple(XmStringContext context) returns the \
component type of the next component"
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringPeekNextTriple", "XmStringContext");
  return(C_TO_XEN_INT(XmStringPeekNextTriple(XEN_TO_C_XmStringContext(arg1))));
}
#endif
/* MOTIF_2 */

static XEN gxm_XmStringDrawUnderline(XEN args)
{
  #define H_XmStringDrawUnderline "void XmStringDrawUnderline(Display * d, Window w, XmRenderTable rendertable, XmString string, GC gc, \
Position x, Position y, Dimension width, unsigned char alignment, unsigned char layout_direction, XRectangle * clip, XmString underline) \
underlines a string drawn in an X Window"
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11; XEN arg12;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  arg12 = XEN_LIST_REF(args, 11);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmStringDrawUnderline", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmStringDrawUnderline", "Window");
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg3), arg3, 3, "XmStringDrawUnderline", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg4), arg4, 4, "XmStringDrawUnderline", "XmString");
  XEN_ASSERT_TYPE(XEN_GC_P(arg5), arg5, 5, "XmStringDrawUnderline", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringDrawUnderline", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmStringDrawUnderline", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XmStringDrawUnderline", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg9), arg9, 9, "XmStringDrawUnderline", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg10), arg10, 10, "XmStringDrawUnderline", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XRectangle_P(arg11), arg11, 11, "XmStringDrawUnderline", "XRectangle");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg12), arg12, 12, "XmStringDrawUnderline", "XmString");
  XmStringDrawUnderline(XEN_TO_C_Display(arg1), 
			XEN_TO_C_Window(arg2), 
			XEN_TO_C_XmFontList(arg3), 
			XEN_TO_C_XmString(arg4), 
			XEN_TO_C_GC(arg5), 
			XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7), XEN_TO_C_INT(arg8), 
			XEN_TO_C_ULONG(arg9), XEN_TO_C_ULONG(arg10), 
			XEN_TO_C_XRectangle(arg11), 
			XEN_TO_C_XmString(arg12));
  return(XEN_FALSE);
}

static XEN gxm_XmStringDrawImage(XEN args)
{
  #define H_XmStringDrawImage "void XmStringDrawImage(Display * d, Window w, XmRenderTable rendertable, XmString string, GC gc, Position x, \
Position y, Dimension width, unsigned char alignment, unsigned char layout_direction, XRectangle * clip) \
draws a compound string in an X Window and creates an image"
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmStringDrawImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmStringDrawImage", "Window");
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg3), arg3, 3, "XmStringDrawImage", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg4), arg4, 4, "XmStringDrawImage", "XmString");
  XEN_ASSERT_TYPE(XEN_GC_P(arg5), arg5, 5, "XmStringDrawImage", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringDrawImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmStringDrawImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XmStringDrawImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg9), arg9, 9, "XmStringDrawImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg10), arg10, 10, "XmStringDrawImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XRectangle_P(arg11), arg11, 11, "XmStringDrawImage", "XRectangle*");
  XmStringDrawImage(XEN_TO_C_Display(arg1), 
		    XEN_TO_C_Window(arg2), 
		    XEN_TO_C_XmFontList(arg3), 
		    XEN_TO_C_XmString(arg4), 
		    XEN_TO_C_GC(arg5), 
		    XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7), XEN_TO_C_INT(arg8), 
		    XEN_TO_C_ULONG(arg9), XEN_TO_C_ULONG(arg10), 
		    XEN_TO_C_XRectangle(arg11));
  return(XEN_FALSE);
}

static XEN gxm_XmStringDraw(XEN args)
{
  #define H_XmStringDraw "void XmStringDraw(Display * d, Window w, XmRenderTable rendertable, XmString string, GC gc, Position x, Position y, \
Dimension width, unsigned char alignment, unsigned char layout_direction, XRectangle * clip) draws a compound \
string in an X window"
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmStringDraw", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmStringDraw", "Window");
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg3), arg3, 3, "XmStringDraw", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg4), arg4, 4, "XmStringDraw", "XmString");
  XEN_ASSERT_TYPE(XEN_GC_P(arg5), arg5, 5, "XmStringDraw", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XmStringDraw", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmStringDraw", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XmStringDraw", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg9), arg9, 9, "XmStringDraw", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg10), arg10, 10, "XmStringDraw", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XRectangle_P(arg11), arg11, 11, "XmStringDraw", "XRectangle*");
  XmStringDraw(XEN_TO_C_Display(arg1), 
	       XEN_TO_C_Window(arg2), 
	       XEN_TO_C_XmFontList(arg3), 
	       XEN_TO_C_XmString(arg4), 
	       XEN_TO_C_GC(arg5), 
	       XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7), XEN_TO_C_INT(arg8), 
	       XEN_TO_C_ULONG(arg9), XEN_TO_C_ULONG(arg10), 
	       XEN_TO_C_XRectangle(arg11));
  return(XEN_FALSE);
}

static XEN gxm_XmStringLineCount(XEN arg1)
{
  #define H_XmStringLineCount "int XmStringLineCount(XmString string) returns the number of separators plus one \
in the provided compound string"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringLineCount", "XmString");
  return(C_TO_XEN_INT(XmStringLineCount(XEN_TO_C_XmString(arg1))));
}

static XEN gxm_XmStringExtent(XEN arg1, XEN arg2)
{
  #define H_XmStringExtent "void XmStringExtent(XmRenderTable rendertable, XmString string) \
determines the size of the smallest rectangle that will enclose the compound string"
  /* DIFF: XmStringExtent omits and returns the last 2 args
   */
  Dimension w, h;
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmStringExtent", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringExtent", "XmString");
  XmStringExtent(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XmString(arg2), &w, &h);
  return(XEN_LIST_2(C_TO_XEN_Dimension(w),
		    C_TO_XEN_Dimension(h)));
}

static XEN gxm_XmStringHeight(XEN arg1, XEN arg2)
{
  #define H_XmStringHeight "Dimension XmStringHeight(XmRenderTable rendertable, XmString string) returns the line \
height of the given compound string"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmStringHeight", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringHeight", "XmString");
  return(C_TO_XEN_Dimension(XmStringHeight(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmStringWidth(XEN arg1, XEN arg2)
{
  #define H_XmStringWidth "Dimension XmStringWidth(XmRenderTable rendertable, XmString string) returns \
the width of the widest line in a compound string"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmStringWidth", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringWidth", "XmString");
  return(C_TO_XEN_Dimension(XmStringWidth(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmStringBaseline(XEN arg1, XEN arg2)
{
  #define H_XmStringBaseline "Dimension XmStringBaseline(XmRenderTable rendertable, XmString string) returns \
the number of pixels between \
the top of the character box and the baseline of the first line of text"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmStringBaseline", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringBaseline", "XmString");
  return(C_TO_XEN_Dimension(XmStringBaseline(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmStringFree(XEN arg1)
{
  #define H_XmStringFree "void XmStringFree(XmString string) conditionally deallocates memory"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringFree", "XmString");
  XmStringFree(XEN_TO_C_XmString(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmStringHasSubstring(XEN arg1, XEN arg2)
{
  #define H_XmStringHasSubstring "Boolean XmStringHasSubstring(XmString string, XmString substring) indicates \
whether one compound string is contained within another"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringHasSubstring", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringHasSubstring", "XmString");
  return(C_TO_XEN_BOOLEAN(XmStringHasSubstring(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2))));
}

#if MOTIF_2
static XEN gxm_XmStringIsVoid(XEN arg1)
{
  #define H_XmStringIsVoid "Boolean XmStringIsVoid(XmString s1) provides information on the existence of non-zero-length text \
components, tab components, or separator components"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringIsVoid", "XmString");
  return(C_TO_XEN_BOOLEAN(XmStringIsVoid(XEN_TO_C_XmString(arg1))));
}
#endif

static XEN gxm_XmStringEmpty(XEN arg1)
{
  #define H_XmStringEmpty "Boolean XmStringEmpty(XmString s1) provides information on the existence of \
non-zero-length text components"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringEmpty", "XmString");
  return(C_TO_XEN_BOOLEAN(XmStringEmpty(XEN_TO_C_XmString(arg1))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringLength(XEN arg1)
{
  #define H_XmStringLength "int XmStringLength(XmString s1) obtains the length of a compound string"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringLength", "XmString");
  return(C_TO_XEN_INT(XmStringLength(XEN_TO_C_XmString(arg1))));
}
#endif

static XEN gxm_XmStringCompare(XEN arg1, XEN arg2)
{
  #define H_XmStringCompare "Boolean XmStringCompare(XmString s1, XmString s2) compares two strings"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringCompare", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringCompare", "XmString");
  return(C_TO_XEN_BOOLEAN(XmStringCompare(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringByteCompare(XEN arg1, XEN arg2)
{
  #define H_XmStringByteCompare "Boolean XmStringByteCompare(XmString s1, XmString s2) indicates the results of a \
byte-by-byte comparison"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringByteCompare", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringByteCompare", "XmString");
  return(C_TO_XEN_BOOLEAN(XmStringByteCompare(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmStringNCopy(XEN arg1, XEN arg2)
{
  #define H_XmStringNCopy "XmString XmStringNCopy(XmString s1, int num_bytes) creates a copy of a compound string"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringNCopy", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmStringNCopy", "int");
  return(C_TO_XEN_XmString(XmStringNCopy(XEN_TO_C_XmString(arg1), XEN_TO_C_INT(arg2))));
}
#endif

static XEN gxm_XmStringCopy(XEN arg1)
{
  #define H_XmStringCopy "XmString XmStringCopy(XmString s1)  makes a copy of a string"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringCopy", "XmString");
  return(C_TO_XEN_XmString(XmStringCopy(XEN_TO_C_XmString(arg1))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringNConcat(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmStringNConcat "XmString XmStringNConcat(XmString s1, XmString s2, int num_bytes) appends a specified \
number of bytes to a compound string"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringNConcat", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringNConcat", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmStringNConcat", "int");
  return(C_TO_XEN_XmString(XmStringNConcat(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_INT(arg3))));
}
#endif

#if MOTIF_2
static XEN gxm_XmStringConcatAndFree(XEN arg1, XEN arg2)
{
  #define H_XmStringConcatAndFree "XmString XmStringConcatAndFree(XmString s1, XmString s2) appends one string to \
another and frees the original strings"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringConcatAndFree", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringConcatAndFree", "XmString");
  return(C_TO_XEN_XmString(XmStringConcatAndFree(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2))));
}
#endif

static XEN gxm_XmStringConcat(XEN arg1, XEN arg2)
{
  #define H_XmStringConcat "XmString XmStringConcat(XmString s1, XmString s2) appends one string to another"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringConcat", "XmString");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmStringConcat", "XmString");
  return(C_TO_XEN_XmString(XmStringConcat(XEN_TO_C_XmString(arg1), XEN_TO_C_XmString(arg2))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmFontListFreeFontContext(XEN arg1)
{
  #define H_XmFontListFreeFontContext "void XmFontListFreeFontContext(XmFontContext context) instructs the toolkit that \
the font list context is no longer needed"
  XEN_ASSERT_TYPE(XEN_XmFontContext_P(arg1), arg1, 1, "XmFontListFreeFontContext", "XmFontContext");
  XmFontListFreeFontContext(XEN_TO_C_XmFontContext(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmFontListGetNextFont(XEN arg1)
{
  #define H_XmFontListGetNextFont "Boolean XmFontListGetNextFont(XmFontContext context) \
allows applications to access the fonts and character sets in a font list"
  /* DIFF: XmFontListGetNextFont omits args 2 3, returns list
   */
  XmStringCharSet s;
  XFontStruct *f;
  int b;
  XEN_ASSERT_TYPE(XEN_XmFontContext_P(arg1), arg1, 1, "XmFontListGetNextFont", "XmFontContext");
  b = XmFontListGetNextFont(XEN_TO_C_XmFontContext(arg1), &s, &f);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(b),
		    C_TO_XEN_STRING(s),
		    C_TO_XEN_XFontStruct(f)));
}

static XEN gxm_XmFontListInitFontContext(XEN arg1)
{
  #define H_XmFontListInitFontContext "Boolean XmFontListInitFontContext(XmFontList fontlist) \
allows applications to access the entries in a font list"
  /* DIFF: XmFontListInitFontContext omits arg1 and rtns it
   */
  XmFontContext fc;
  Boolean b;
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmFontListInitFontContext", "XmFontList");
  b = XmFontListInitFontContext(&fc, XEN_TO_C_XmFontList(arg1));
  if (b == False)
    return(XEN_FALSE);
  return(C_TO_XEN_XmFontContext(fc));
}

static XEN gxm_XmFontListCopy(XEN arg1)
{
  #define H_XmFontListCopy "XmFontList XmFontListCopy(XmFontList fontlist) copies a font list"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmFontListCopy", "XmFontList");
  return(C_TO_XEN_XmFontList(XmFontListCopy(XEN_TO_C_XmFontList(arg1))));
}

static XEN gxm_XmFontListAdd(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmFontListAdd "XmFontList XmFontListAdd(XmFontList oldlist, XFontStruct *font, XmStringCharSet charset) \
creates a new font list"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmFontListAdd", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg2), arg2, 2, "XmFontListAdd", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmFontListAdd", "XmStringCharSet");
  return(C_TO_XEN_XmFontList(XmFontListAdd(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XFontStruct(arg2), XEN_TO_C_STRING(arg3))));
}

static XEN gxm_XmFontListFree(XEN arg1)
{
  #define H_XmFontListFree "void XmFontListFree(XmFontList list) recovers memory used by a font list"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmFontListFree", "XmFontList");
  XmFontListFree(XEN_TO_C_XmFontList(arg1));
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmFontListCreate_r(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmFontListCreate_r "XmFontList XmFontListCreate_r(XFontStruct *font, XmStringCharSet charset, Widget wid)"
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg1), arg1, 1, "XmFontListCreate_r", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmFontListCreate_r", "XmStringCharSet");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XmFontListCreate_r", "Widget");
  return(C_TO_XEN_XmFontList(XmFontListCreate_r(XEN_TO_C_XFontStruct(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_Widget(arg3))));
}
#endif

static XEN gxm_XmFontListCreate(XEN arg1, XEN arg2)
{
  #define H_XmFontListCreate "XmFontList XmFontListCreate(XFontStruct * font, XmStringCharSet charset) creates a font list"
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg1), arg1, 1, "XmFontListCreate", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmFontListCreate", "XmStringCharSet");
  return(C_TO_XEN_XmFontList(XmFontListCreate(XEN_TO_C_XFontStruct(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmFontListEntryLoad(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmFontListEntryLoad "XmFontListEntry XmFontListEntryLoad(Display *display, char *font_name, XmFontType type, char *tag) \
loads a font or creates a font set and creates an accompanying font list entry"

  XmFontType type;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmFontListEntryLoad", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmFontListEntryLoad", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmFontListEntryLoad", "XmFontType");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmFontListEntryLoad", "char*");
  type = (XmFontType)XEN_TO_C_INT(arg3);
  if ((type < 0) || (type > 1)) XEN_WRONG_TYPE_ARG_ERROR("XmFontListEntryLoad", 3, arg3, "XmFontType");
  return(C_TO_XEN_XmFontListEntry(XmFontListEntryLoad(XEN_TO_C_Display(arg1),
						      XEN_TO_C_STRING(arg2),
						      type,
						      XEN_TO_C_STRING(arg4))));
}

static XEN gxm_XmFontListRemoveEntry(XEN arg1, XEN arg2)
{
  #define H_XmFontListRemoveEntry "XmFontList XmFontListRemoveEntry(XmFontList oldlist, XmFontListEntry entry) removes a \
font list entry from a font list"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1), arg1, 1, "XmFontListRemoveEntry", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmFontListEntry_P(arg2), arg2, 2, "XmFontListRemoveEntry", "XmFontListEntry");
  return(C_TO_XEN_XmFontList(XmFontListRemoveEntry(XEN_TO_C_XmFontList(arg1), XEN_TO_C_XmFontListEntry(arg2))));
}

static XEN gxm_XmFontListNextEntry(XEN arg1)
{
  #define H_XmFontListNextEntry "XmFontListEntry XmFontListNextEntry(XmFontContext context) returns the next entry in a font list"
  XEN_ASSERT_TYPE(XEN_XmFontContext_P(arg1), arg1, 1, "XmFontListNextEntry", "XmFontContext");
  return(C_TO_XEN_XmFontListEntry(XmFontListNextEntry(XEN_TO_C_XmFontContext(arg1))));
}

static XEN gxm_XmFontListAppendEntry(XEN arg1, XEN arg2)
{
  #define H_XmFontListAppendEntry "XmFontList XmFontListAppendEntry(XmFontList oldlist, XmFontListEntry entry) appends an \
entry to a font list"
  XEN_ASSERT_TYPE(XEN_XmFontList_or_XmRenderTable_P(arg1) || XEN_FALSE_P(arg1), arg1, 1, "XmFontListAppendEntry", "XmFontList");
  XEN_ASSERT_TYPE(XEN_XmFontListEntry_P(arg2), arg2, 2, "XmFontListAppendEntry", "XmFontListEntry");
  return(C_TO_XEN_XmFontList(XmFontListAppendEntry((XEN_FALSE_P(arg1)) ? NULL : XEN_TO_C_XmFontList(arg1), 
						   XEN_TO_C_XmFontListEntry(arg2))));
}

static XEN gxm_XmFontListEntryGetTag(XEN arg1)
{
  #define H_XmFontListEntryGetTag "char* XmFontListEntryGetTag(XmFontListEntry entry) retrieves the tag of a font list entry"
  XEN_ASSERT_TYPE(XEN_XmFontListEntry_P(arg1), arg1, 1, "XmFontListEntryGetTag", "XmFontListEntry");
  return(C_TO_XEN_STRING(XmFontListEntryGetTag(XEN_TO_C_XmFontListEntry(arg1))));
}

static XEN gxm_XmFontListEntryGetFont(XEN arg1, XEN arg2)
{
  #define H_XmFontListEntryGetFont "XtPointer XmFontListEntryGetFont(XmFontListEntry entry) \
retrieves font information from a font list entry -> fontstruct"
  /* DIFF: XmFontListEntryGetFont omits arg2
   */
  XmFontType f;
  XtPointer ptr;
  XEN_ASSERT_TYPE(XEN_XmFontListEntry_P(arg1), arg1, 1, "XmFontListEntryGetFont", "XmFontListEntry");
  ptr  = XmFontListEntryGetFont(XEN_TO_C_XmFontListEntry(arg1), &f);
  if (f == XmFONT_IS_FONTSET)
    return(C_TO_XEN_XFontSet((XFontSet)ptr)); 
  return(C_TO_XEN_XFontStruct((XFontStruct *)ptr));
}

static XEN gxm_XmFontListEntryFree(XEN arg1)
{
  #define H_XmFontListEntryFree "void XmFontListEntryFree(XmFontListEntry *entry) recovers memory used by a font list entry"
  /* DIFF: XmFontListEntryFree takes FontListEntry (not ptr to it)
   */
  XmFontListEntry f;
  XEN_ASSERT_TYPE(XEN_XmFontListEntry_P(arg1), arg1, 1, "XmFontListEntryFree", "XmFontListEntry");
  f = XEN_TO_C_XmFontListEntry(arg1);
  XmFontListEntryFree(&f);
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmFontListEntryCreate_r(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  XmFontType type;
  XtPointer gad;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmFontListEntryCreate_r", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmFontListEntryCreate_r", "XmFontType");
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg3) || XEN_XFontSet_P(arg3), arg3, 3, "XmFontListEntryCreate_r", "XFontSet or XFontStruct");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg4), arg4, 4, "XmFontListEntryCreate_r", "Widget");
  type = (XmFontType)XEN_TO_C_INT(arg2);
  if ((type < 0) || (type > 1)) XEN_WRONG_TYPE_ARG_ERROR("XmFontListEntryCreate_r", 2, arg2, "XmFontType");
  if (type == XmFONT_IS_FONTSET)
    gad = (XtPointer)XEN_TO_C_XFontSet(arg3);
  else gad = (XtPointer)XEN_TO_C_XFontStruct(arg3);
  return(C_TO_XEN_XmFontListEntry(XmFontListEntryCreate_r(XEN_TO_C_STRING(arg1), 
							  type,
							  gad,
							  XEN_TO_C_Widget(arg4))));
}
#endif

static XEN gxm_XmFontListEntryCreate(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmFontListEntryCreate "XmFontListEntry XmFontListEntryCreate(char *tag, XmFontType type, XtPointer font) \
creates a font list entry"
  XmFontType type;
  XtPointer gad;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmFontListEntryCreate", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmFontListEntryCreate", "XmFontType");
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg3) || XEN_XFontSet_P(arg3), arg3, 3, "XmFontListEntryCreate", "XFontSet or XFontStruct");
  type = (XmFontType)XEN_TO_C_INT(arg2);
  if ((type < 0) || (type > 1)) XEN_WRONG_TYPE_ARG_ERROR("XmFontListEntryCreate", 2, arg2, "XmFontType");
  if (type == XmFONT_IS_FONTSET)
    gad = (XtPointer)XEN_TO_C_XFontSet(arg3);
  else gad = (XtPointer)XEN_TO_C_XFontStruct(arg3);
  return(C_TO_XEN_XmFontListEntry(XmFontListEntryCreate(XEN_TO_C_STRING(arg1), 
							type,
							gad)));
}
#endif

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringGetLtoR(XEN arg1, XEN arg2)
{
  #define H_XmStringGetLtoR "Boolean XmStringGetLtoR(XmString string, XmStringCharSet tag) searches \
for a text segment in the input compound string"
  /* DIFF: XmStringGetLtoR omits and rtns last arg
   */
  char *str;
  Boolean b;
  XEN val;
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmStringGetLtoR", "XmString");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringGetLtoR", "XmStringCharSet");
  b = XmStringGetLtoR(XEN_TO_C_XmString(arg1), XEN_TO_C_STRING(arg2), &str);
  val = C_TO_XEN_STRING(str);
  free(str);
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(b), val));
}

static XEN gxm_XmStringGetNextSegment(XEN arg1)
{
  #define H_XmStringGetNextSegment "Boolean XmStringGetNextSegment(XmStringContext context) fetches the bytes in the next segment of a compound string"
  /* DIFF: XmStringGetNextSegment omits last args, returns them
   */
  Boolean b; /* returned boolean omitted arg 5 */
  int val;
  unsigned char c;
  XmStringCharSet tag;
  char *text;
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringGetNextSegment", "XmStringContext");
  val = XmStringGetNextSegment(XEN_TO_C_XmStringContext(arg1), 
			       &text, &tag, &c, &b);
  return(XEN_LIST_5(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_STRING(text),
		    C_TO_XEN_STRING(tag),
		    C_TO_XEN_INT((int)c),
		    C_TO_XEN_BOOLEAN(b)));
}

static XEN gxm_XmStringPeekNextComponent(XEN arg1)
{
  #define H_XmStringPeekNextComponent "XmStringComponentType XmStringPeekNextComponent(XmStringContext context) \
returns the component type of the next component to be fetched"
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringPeekNextComponent", "XmStringContext");
  return(C_TO_XEN_INT(XmStringPeekNextComponent(XEN_TO_C_XmStringContext(arg1))));
}

static XEN gxm_XmStringGetNextComponent(XEN arg1)
{
  #define H_XmStringGetNextComponent "XmStringComponentType XmStringGetNextComponent(XmStringContext context) \
returns the type and value of the next component in a compound string (list val text tag direction component len value)"
  /* DIFF: XmStringGetNextComponent omits all but 1st arg, returns list
   */
  unsigned char direction = 0;
  unsigned short len;
  unsigned char *value;
  unsigned char component;
  XmStringCharSet tag;
  char *text = NULL;
  int val;
  XEN xtext = XEN_FALSE, xdir = XEN_FALSE, xtag = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringGetNextComponent", "XmStringContext");
  val = XmStringGetNextComponent(XEN_TO_C_XmStringContext(arg1), &text, &tag, &direction, &component, &len, &value);
  if ((val == XmSTRING_COMPONENT_TEXT) || (val == XmSTRING_COMPONENT_LOCALE_TEXT))
    xtext = C_TO_XEN_STRING(text);
  else
    {
      if (val == XmSTRING_COMPONENT_DIRECTION)
	xdir = C_TO_XEN_INT((int)direction);
      else 
	{
#if MOTIF_2
	  if ((val == XmSTRING_COMPONENT_FONTLIST_ELEMENT_TAG) || (val == XmSTRING_COMPONENT_CHARSET))
#else
	  if (val == XmSTRING_COMPONENT_CHARSET)
#endif
	    xtag = C_TO_XEN_STRING(tag);
	}
    }
  return(XEN_LIST_7(C_TO_XEN_INT(val),
		    xtext,
		    xtag,
		    xdir,
		    C_TO_XEN_INT((int)component),
		    C_TO_XEN_INT((int)len),
		    C_TO_XEN_INT((int)value)));
}
#endif

static XEN gxm_XmStringFreeContext(XEN arg1)
{
  #define H_XmStringFreeContext "void XmStringFreeContext(XmStringContext context) releases the string scanning \
context data structure"
  XEN_ASSERT_TYPE(XEN_XmStringContext_P(arg1), arg1, 1, "XmStringFreeContext", "XmStringContext");
  XmStringFreeContext(XEN_TO_C_XmStringContext(arg1));
  return(XEN_FALSE);
}

static XmStringContext gxm_initxmsc;
static XEN gxm_XmStringInitContext(XEN arg2)
{
  #define H_XmStringInitContext "Boolean XmStringInitContext(XmString string) creates \
a data structure for scanning an XmString component by component"
  /* DIFF XmStringInitContext 1st arg omitted and rtn
   */
  int val;
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 1, "XmStringInitContext", "XmString");
  val = XmStringInitContext(&gxm_initxmsc, XEN_TO_C_XmString(arg2));
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(val), C_TO_XEN_XmStringContext(gxm_initxmsc)));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringCreateLtoR(XEN arg1, XEN arg2)
{
  #define H_XmStringCreateLtoR "XmString XmStringCreateLtoR(char *text, char *tag) creates a compound string"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringCreateLtoR", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringCreateLtoR", "XmStringCharSet");
  return(C_TO_XEN_XmString(XmStringCreateLtoR(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmStringSegmentCreate(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmStringSegmentCreate "XmString XmStringSegmentCreate(char * text, XmStringTag tag, XmStringDirection direction, Boolean separator) \
creates a compound string"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringSegmentCreate", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringSegmentCreate", "XmStringCharSet");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmStringSegmentCreate", "int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg4), arg4, 4, "XmStringSegmentCreate", "boolean");
  return(C_TO_XEN_XmString(XmStringSegmentCreate(XEN_TO_C_STRING(arg1), 
						 XEN_TO_C_STRING(arg2), 
						 XEN_TO_C_INT(arg3), 
						 XEN_TO_C_BOOLEAN(arg4))));
}
#endif

static XEN gxm_XmStringSeparatorCreate(void)
{
  #define H_XmStringSeparatorCreate "XmString XmStringSeparatorCreate(void) creates a compound string"
  return(C_TO_XEN_XmString(XmStringSeparatorCreate()));
}

static XEN gxm_XmStringDirectionCreate(XEN arg1)
{
  #define H_XmStringDirectionCreate "XmString XmStringDirectionCreate(XmStringDirection direction) creates a compound string"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XmStringDirectionCreate", "int");
  return(C_TO_XEN_XmString(XmStringDirectionCreate(XEN_TO_C_INT(arg1))));
}

static XEN gxm_XmStringCreateLocalized(XEN arg1)
{
  #define H_XmStringCreateLocalized "XmString XmStringCreateLocalized(char *text) creates a compound string in the current locale"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringCreateLocalized", "String");
  return(C_TO_XEN_XmString(XmStringCreateLocalized(XEN_TO_C_STRING(arg1))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmStringCreateSimple(XEN arg1)
{
  #define H_XmStringCreateSimple "XmString XmStringCreateSimple(char * text) creates a compound string in the \
language environment of a widget"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringCreateSimple", "char*");
  return(C_TO_XEN_XmString(XmStringCreateSimple(XEN_TO_C_STRING(arg1))));
}
#endif

static XEN gxm_XmStringCreate(XEN arg1, XEN arg2)
{
  #define H_XmStringCreate "XmString XmStringCreate(char *text, char *tag) creates a compound string"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmStringCreate", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmStringCreate", "XmStringCharSet");
  return(C_TO_XEN_XmString(XmStringCreate(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmChangeColor(XEN arg1, XEN arg2)
{
  #define H_XmChangeColor "void XmChangeColor(Widget widget, Pixel background) recalculates all associated colors of a widget"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmChangeColor", "Widget");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg2), arg2, 2, "XmChangeColor", "Pixel");
  XmChangeColor(XEN_TO_C_Widget(arg1), XEN_TO_C_Pixel(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmGetColors(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmGetColors "void XmGetColors(Screen * screen, Colormap colormap, Pixel background) generates foreground, select, and shadow colors"
  /* DIFF: XmGetColors omits trailing 4 args and returns them
   */
  Pixel fg,ts, bs, sr;
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmGetColors", "Screen*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XmGetColors", "Colormap");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XmGetColors", "Pixel");
  XmGetColors(XEN_TO_C_Screen(arg1), 
	      XEN_TO_C_Colormap(arg2), 
	      XEN_TO_C_Pixel(arg3),
	      &fg, &ts, &bs, &sr);
  return(XEN_LIST_4(C_TO_XEN_Pixel(fg),
		    C_TO_XEN_Pixel(ts),
		    C_TO_XEN_Pixel(bs),
		    C_TO_XEN_Pixel(sr)));
}

static XEN gxm_XmGetColorCalculation(void)
{
  #define H_XmGetColorCalculation "XmColorProc XmGetColorCalculation(void) get the procedure used for default color calculation"
  return(xm_XmColorProc);
}

static XEN gxm_XmSetColorCalculation(XEN arg1)
{
  #define H_XmSetColorCalculation "XmColorProc XmSetColorCalculation(XmColorProc color_proc) set the procedure used for default color calculation"
  /* DIFF: XmSetColorCalculation NULL -> #f
   */
  if (XEN_PROCEDURE_P(xm_XmColorProc)) xm_unprotect(xm_XmColorProc);
  if (XEN_FALSE_P(arg1))
    {
      xm_XmColorProc = XEN_FALSE;
      XmSetColorCalculation(NULL);
    }
  else
    {
      XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg1) && (XEN_REQUIRED_ARGS(arg1) == 1), arg1, 1, "XmSetColorCalculation", "(XmColorProc but 1 arg)");
      xm_protect(arg1);
      xm_XmColorProc = arg1;
      XmSetColorCalculation((XmColorProc)gxm_XmColorProc);
    }
  return(arg1);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmTrackingLocate(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTrackingLocate "Widget XmTrackingLocate(Widget widget, Cursor cursor, Boolean confine_to) allows for modal \
selection of a component (obsolete)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmTrackingLocate", "Widget");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg2), arg2, 2, "XmTrackingLocate", "Cursor");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmTrackingLocate", "boolean");
  return(C_TO_XEN_Widget(XmTrackingLocate(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_BOOLEAN(arg3))));
}
#endif

static XEN gxm_XmTrackingEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTrackingEvent "Widget XmTrackingEvent(Widget widget, Cursor cursor, Boolean confine_to) -> (widget event)"
  /* DIFF: XmTrackingEvent widget cursor confine [event] -> (list widget event)
   */
  XEvent *e; /* do we need to allocate? */
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmTrackingEvent", "Widget");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg2), arg2, 2, "XmTrackingEvent", "Cursor");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmTrackingEvent", "boolean");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  w = XmTrackingEvent(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_BOOLEAN(arg3), e);
  return(XEN_LIST_2(C_TO_XEN_Widget(w), C_TO_XEN_XEvent_OBJ(e)));
}


/* The various XmVaCreateSimple{object} require special arg handling --
     these are not "normal" resource lists, but can also contain special indicators
     -- not immediately clear how to handle these things!
     Apparently we need to run through the args, split out the special args,
     collect arglists, add to arglist buttons, buttonCount etc, then call the
     underlying simple creator. (see lesstif lib/Xm/VaSimple.c)

   rowcol = XmVaCreateSimpleCheckBox(toplevel, "checkBox", cb,
				     XmNspacing, 2,
				     XmNmarginHeight, 4,
				     XmVaCHECKBUTTON, s1, 0, NULL, NULL,
				     XmVaCHECKBUTTON, s2, 0, NULL, NULL,
				     NULL);

   option = XmVaCreateSimpleOptionMenu(form, "option", cs("MyLabel"), 
				      (KeySym) 'M', 1, SimpleCallbackProc,
				      XmVaPUSHBUTTON, cs("Red"), (int) 'R', 
				      "", XmNULL,
				      XmVaCASCADEBUTTON, cs("Help"), (int) 'H',
				      XmVaSEPARATOR,
				      XmVaPUSHBUTTON, cs("Green"), (int) 'G', 
				      "", XmNULL,
				      XmVaSEPARATOR,
				      XmVaPUSHBUTTON, cs("Blue"), (int) 'B', 
				      "", XmNULL,
				      NULL);				    
*/

static XEN gxm_XmVaCreateSimpleCheckBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmVaCreateSimpleCheckBox "Widget XmVaCreateSimpleCheckBox(Widget parent, String name, XtCallbackProc callback, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimpleCheckBox", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimpleCheckBox", "String");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 3), arg3, 3, "XmVaCreateSimpleCheckBox", "XtCallbackProc (3 args)");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmVaCreateSimpleCheckBox", "List");
  arg4 = XEN_CONS_2(C_TO_XEN_STRING(XmNvalueChangedCallback),
		    XEN_LIST_2(arg3, XEN_FALSE), /* XtCallbackList technically */
		    arg4);
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg4);
    w = XmCreateSimpleCheckBox(XEN_TO_C_Widget(arg1), 
			       XEN_TO_C_STRING(arg2), 
			       args,
			       arglen = XEN_LIST_LENGTH(arg4) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));

}

static XEN gxm_XmVaCreateSimpleRadioBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmVaCreateSimpleRadioBox "Widget XmVaCreateSimpleRadioBox(Widget parent, String name, int button_set, XtCallbackProc callback, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimpleRadioBox", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimpleRadioBox", "String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmVaCreateSimpleRadioBox", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XmVaCreateSimpleRadioBox", "XtCallbackProc (3 args");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XmVaCreateSimpleRadioBox", "List");
  arg5 = XEN_CONS_2(C_TO_XEN_STRING(XmNvalueChangedCallback),
		    XEN_LIST_2(arg4, XEN_FALSE),
		    arg5);
  /* can't handle button set here since the menuHistory resource is the widget allocated later */
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg5);
    w = XmCreateSimpleRadioBox(XEN_TO_C_Widget(arg1), 
			       XEN_TO_C_STRING(arg2), 
			       args,
			       arglen = XEN_LIST_LENGTH(arg5) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmVaCreateSimpleOptionMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmVaCreateSimpleOptionMenu "Widget XmVaCreateSimpleOptionMenu(Widget parent, String name, XmString option_label, \
KeySym option_mnemonic, int button_set, XtCallbackProc callback, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimpleOptionMenu", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimpleOptionMenu", "String");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg3), arg3, 3, "XmVaCreateSimpleOptionMenu", "XmString");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg4), arg4, 4, "XmVaCreateSimpleOptionMenu", "KeySym");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmVaCreateSimpleOptionMenu", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg6) && (XEN_REQUIRED_ARGS(arg6) == 3), arg6, 6, "XmVaCreateSimpleOptionMenu", "XtCallbackProc (3 args)");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg7), arg7, 7, "XmVaCreateSimpleOptionMenu", "List");
  arg7 = XEN_CONS_2(C_TO_XEN_STRING(XmNlabelString),
		    arg3,
		    XEN_CONS_2(C_TO_XEN_STRING(XmNmnemonic),
			       arg4,
			       XEN_CONS_2(C_TO_XEN_STRING(XmNvalueChangedCallback),
					  XEN_LIST_2(arg6, XEN_FALSE),
					  arg7)));
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg7);
    w = XmCreateSimpleOptionMenu(XEN_TO_C_Widget(arg1), 
				 XEN_TO_C_STRING(arg2), 
				 args,
				 arglen = XEN_LIST_LENGTH(arg7) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmVaCreateSimplePulldownMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmVaCreateSimplePulldownMenu "Widget XmVaCreateSimplePulldownMenu(Widget parent, String name, int post_from_button, XtCallbackProc callback, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimplePulldownMenu", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimplePulldownMenu", "String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmVaCreateSimplePulldownMenu", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XmVaCreateSimplePulldownMenu", "XtCallbackProc (3 args)");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XmVaCreateSimplePulldownMenu", "List");
  arg5 = XEN_CONS_2(C_TO_XEN_STRING(XmNvalueChangedCallback),
		    XEN_LIST_2(arg4, XEN_FALSE),
		    arg5);
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg5);
    w = XmCreateSimplePulldownMenu(XEN_TO_C_Widget(arg1), 
				   XEN_TO_C_STRING(arg2), 
				   args,
				   arglen = XEN_LIST_LENGTH(arg5) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmVaCreateSimplePopupMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmVaCreateSimplePopupMenu "Widget XmVaCreateSimplePopupMenu(Widget parent, String name, XtCallbackProc callback, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimplePopupMenu", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimplePopupMenu", "String");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 3), arg3, 3, "XmVaCreateSimplePopupMenu", "XtCallbackProc (3 args)");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmVaCreateSimplePopupMenu", "List");
  arg4 = XEN_CONS_2(C_TO_XEN_STRING(XmNvalueChangedCallback),
		    XEN_LIST_2(arg3, XEN_FALSE),
		    arg4);
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg4);
    w = XmCreateSimplePopupMenu(XEN_TO_C_Widget(arg1), 
				XEN_TO_C_STRING(arg2), 
				args,
				arglen = XEN_LIST_LENGTH(arg4) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmVaCreateSimpleMenuBar(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmVaCreateSimpleMenuBar "Widget XmVaCreateSimpleMenuBar(Widget parent, String name, args)"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmVaCreateSimpleMenuBar", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmVaCreateSimpleMenuBar", "String");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmVaCreateSimpleMenuBar", "List");
  {
    int arglen;
    Arg *args;
    args = XEN_TO_C_Args(arg3);
    w = XmVaCreateSimpleMenuBar(XEN_TO_C_Widget(arg1), 
				XEN_TO_C_STRING(arg2),
				args,
				arglen = XEN_LIST_LENGTH(arg3) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmCreateSimpleCheckBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimpleCheckBox "Widget XmCreateSimpleCheckBox(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimpleCheckBox", XmCreateSimpleCheckBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSimpleRadioBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimpleRadioBox "Widget XmCreateSimpleRadioBox(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimpleRadioBox", XmCreateSimpleRadioBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSimpleOptionMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimpleOptionMenu "Widget XmCreateSimpleOptionMenu(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimpleOptionMenu", XmCreateSimpleOptionMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSimplePulldownMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimplePulldownMenu "Widget XmCreateSimplePulldownMenu(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimplePulldownMenu", XmCreateSimplePulldownMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSimplePopupMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimplePopupMenu "Widget XmCreateSimplePopupMenu(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimplePopupMenu", XmCreateSimplePopupMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSimpleMenuBar(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimpleMenuBar "Widget XmCreateSimpleMenuBar(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateSimpleMenuBar", XmCreateSimpleMenuBar, arg1, arg2, arg3, arg4));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmGetMenuCursor(XEN arg1)
{
  #define H_XmGetMenuCursor "Cursor XmGetMenuCursor(Display * display) returns the cursor ID for the current menu cursor"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmGetMenuCursor", "Display*");
  return(C_TO_XEN_Cursor(XmGetMenuCursor(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XmSetMenuCursor(XEN arg1, XEN arg2)
{
  #define H_XmSetMenuCursor "void XmSetMenuCursor(Display * display, Cursor cursorId) modifies the menu cursor for a client"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmSetMenuCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg2), arg2, 2, "XmSetMenuCursor", "Cursor");
  XmSetMenuCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Cursor(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmSetFontUnit(XEN arg1, XEN arg2)
{
  #define H_XmSetFontUnit "void XmSetFontUnit(Display * display, int font_unit_value) sets the font unit value for a display"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmSetFontUnit", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmSetFontUnit", "int");
  XmSetFontUnit(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmSetFontUnits(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmSetFontUnits "void XmSetFontUnits(Display * display, int h_value, int v_value) sets the font unit value for a display"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmSetFontUnits", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmSetFontUnits", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmSetFontUnits", "int");
  XmSetFontUnits(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmConvertUnits(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmConvertUnits "int XmConvertUnits(Widget widget, int orientation, int from_unit_type, int from_value, int to_unit_type) \
converts a value in one unit type to another unit type"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmConvertUnits", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmConvertUnits", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmConvertUnits", "register");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmConvertUnits", "register");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmConvertUnits", "register");
  return(C_TO_XEN_INT(XmConvertUnits(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5))));
}

#if MOTIF_2
static XEN gxm_XmConvertStringToUnits(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmConvertStringToUnits "int XmConvertStringToUnits(Screen *screen, String spec, int orientation, int to_type, XtEnum *parse_error) \
converts a string specification to a unit value"
  /* DIFF: XmConvertStringToUnits scr spec orient type [err] -> #f (err) or val
   */
  XtEnum err = 0;
  int val;
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmConvertStringToUnits", "Screen*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmConvertStringToUnits", "String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmConvertStringToUnits", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmConvertStringToUnits", "int");
  val = XmConvertStringToUnits(XEN_TO_C_Screen(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), &err);
  if (err == 0)
    return(C_TO_XEN_INT(val));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmCvtXmStringToCT(XEN arg1)
{
  #define H_XmCvtXmStringToCT "char * XmCvtXmStringToCT(XmString string) converts a compound string to compound text"
  XEN_ASSERT_TYPE(XEN_XmString_P(arg1), arg1, 1, "XmCvtXmStringToCT", "XmString");
  return(C_TO_XEN_STRING(XmCvtXmStringToCT(XEN_TO_C_XmString(arg1))));
}

static XEN gxm_XmCvtCTToXmString(XEN arg1)
{
  #define H_XmCvtCTToXmString "XmString XmCvtCTToXmString(char * text) converts compound text to a compound string"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmCvtCTToXmString", "char*");
  return(C_TO_XEN_XmString(XmCvtCTToXmString(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XmMapSegmentEncoding(XEN arg1)
{
  #define H_XmMapSegmentEncoding "char * XmMapSegmentEncoding(char *fontlist_tag) returns the compound text \
encoding format associated with the specified font list tag"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmMapSegmentEncoding", "char*");
  return(C_TO_XEN_STRING(XmMapSegmentEncoding(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XmRegisterSegmentEncoding(XEN arg1, XEN arg2)
{
  #define H_XmRegisterSegmentEncoding "char * XmRegisterSegmentEncoding(char *fontlist_tag, char *ct_encoding) \
registers a compound text encoding format for a specified font list element tag"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XmRegisterSegmentEncoding", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmRegisterSegmentEncoding", "char*");
  return(C_TO_XEN_STRING(XmRegisterSegmentEncoding(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmWidgetGetBaselines(XEN arg1)
{
  #define H_XmWidgetGetBaselines "Boolean XmWidgetGetBaselines(Widget widget) retrieves baseline information for a widget"
  /* DIFF: XmWidgetGetBaselines omits args 2 and 3, returns list of Dimensions
   */
  Dimension *ds;
  int len, i, loc;
  Boolean b;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmWidgetGetBaselines", "Widget");
  b = XmWidgetGetBaselines(XEN_TO_C_Widget(arg1), &ds, &len);
  if (b == False)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Dimension(ds[i]), lst);
  free(ds);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmWidgetGetDisplayRect(XEN arg1)
{
  #define H_XmWidgetGetDisplayRect "Boolean XmWidgetGetDisplayRect(Widget widget) returns widget's bounding box as XRectangle"
  XRectangle *r;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmWidgetGetDisplayRect", "Widget");
  r = (XRectangle *)CALLOC(1, sizeof(XRectangle));
  if (XmWidgetGetDisplayRect(XEN_TO_C_Widget(arg1), r) == False)
    {
      FREE(r);
      return(XEN_FALSE);
    }
  return(C_TO_XEN_XRectangle(r));
}

#if MOTIF_2
static XEN gxm_XmObjectAtPoint(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmObjectAtPoint "Widget XmObjectAtPoint(Widget widget, Position x, Position y) determines which child \
intersects or comes closest to a specified point"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmObjectAtPoint", "Widget");
  XEN_ASSERT_TYPE(XEN_Position_P(arg2), arg2, 2, "XmObjectAtPoint", "Position");
  XEN_ASSERT_TYPE(XEN_Position_P(arg3), arg3, 3, "XmObjectAtPoint", "Position");
  return(C_TO_XEN_Widget(XmObjectAtPoint(XEN_TO_C_Widget(arg1), XEN_TO_C_Position(arg2), XEN_TO_C_Position(arg3))));
}
#endif

static XEN gxm_XmUpdateDisplay(XEN arg1)
{
  #define H_XmUpdateDisplay "void XmUpdateDisplay (widget) processes all pending exposure events immediately"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmUpdateDisplay", "Widget");
  XmUpdateDisplay(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmDestroyPixmap(XEN arg1, XEN arg2)
{
  #define H_XmDestroyPixmap "Boolean XmDestroyPixmap(Screen * screen, Pixmap pixmap) removes a pixmap from the pixmap cache"
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmDestroyPixmap", "Screen*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg2), arg2, 2, "XmDestroyPixmap", "Pixmap");
  return(C_TO_XEN_BOOLEAN(XmDestroyPixmap(XEN_TO_C_Screen(arg1), 
					  XEN_TO_C_Pixmap(arg2))));
}

static XEN gxm_XmGetPixmapByDepth(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmGetPixmapByDepth "Pixmap XmGetPixmapByDepth(Screen *screen, char *image_name, Pixel foreground, Pixel background, int depth) \
generates a pixmap, stores it in a pixmap cache, and returns the pixmap"
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmGetPixmapByDepth", "Screen*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmGetPixmapByDepth", "char*");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XmGetPixmapByDepth", "Pixel");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg4), arg4, 4, "XmGetPixmapByDepth", "Pixel");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmGetPixmapByDepth", "int");
  return(C_TO_XEN_Pixmap(XmGetPixmapByDepth(XEN_TO_C_Screen(arg1), 
					    XEN_TO_C_STRING(arg2), 
					    XEN_TO_C_Pixel(arg3), 
					    XEN_TO_C_Pixel(arg4), 
					    XEN_TO_C_INT(arg5))));
}

static XEN gxm_XmGetPixmap(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmGetPixmap "Pixmap XmGetPixmap(Screen *screen, char *image_name, Pixel foreground, Pixel background) A pixmap caching function \
that generates a pixmap, stores it in a pixmap cache, and returns the pixmap"
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmGetPixmap", "Screen*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmGetPixmap", "char*");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XmGetPixmap", "Pixel");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg4), arg4, 4, "XmGetPixmap", "Pixel");
  return(C_TO_XEN_Pixmap(XmGetPixmap(XEN_TO_C_Screen(arg1), 
				     XEN_TO_C_STRING(arg2), 
				     XEN_TO_C_Pixel(arg3), 
				     XEN_TO_C_Pixel(arg4))));
}

static XEN gxm_XmUninstallImage(XEN arg1)
{
  #define H_XmUninstallImage "Boolean XmUninstallImage(XImage * image) removes an image from the image cache"
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XmUninstallImage", "XImage*");
  return(C_TO_XEN_BOOLEAN(XmUninstallImage(XEN_TO_C_XImage(arg1))));
}

static XEN gxm_XmInstallImage(XEN arg1, XEN arg2)
{
  #define H_XmInstallImage "Boolean XmInstallImage(XImage * image, char * image_name) adds an image to the image cache"
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XmInstallImage", "XImage*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmInstallImage", "char*");
  return(C_TO_XEN_BOOLEAN(XmInstallImage(XEN_TO_C_XImage(arg1), 
					 XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XmCreateMainWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateMainWindow "Widget XmCreateMainWindow(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MainWindow widget creation function"
  return(gxm_new_widget("XmCreateMainWindow", XmCreateMainWindow, arg1, arg2, arg3, arg4));
}

#if (!XM_DISABLE_DEPRECATED)
#define XEN_MainWindowWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsMainWindow(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmMainWindowSep3(XEN arg1)
{
  #define H_XmMainWindowSep3 "Widget XmMainWindowSep3(Widget widget) returns the widget ID of the third Separator widget"
  XEN_ASSERT_TYPE(XEN_MainWindowWidget_P(arg1), arg1, 1, "XmMainWindowSep3", "MainWindow Widget");
  return(C_TO_XEN_Widget(XmMainWindowSep3(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmMainWindowSep2(XEN arg1)
{
  #define H_XmMainWindowSep2 "Widget XmMainWindowSep2(Widget widget) the widget ID of the second Separator widget"
  XEN_ASSERT_TYPE(XEN_MainWindowWidget_P(arg1), arg1, 1, "XmMainWindowSep2", "MainWindow Widget");
  return(C_TO_XEN_Widget(XmMainWindowSep2(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmMainWindowSep1(XEN arg1)
{
  #define H_XmMainWindowSep1 "Widget XmMainWindowSep1(Widget widget) returns the widget ID of the first Separator"
  XEN_ASSERT_TYPE(XEN_MainWindowWidget_P(arg1), arg1, 1, "XmMainWindowSep1", "MainWindow Widget");
  return(C_TO_XEN_Widget(XmMainWindowSep1(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmMainWindowSetAreas(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XmMainWindowSetAreas "void XmMainWindowSetAreas(Widget widget, Widget menu_bar, Widget command_window, Widget horizontal_scrollbar, \
Widget vertical_scrollbar, Widget work_region) identifies manageable children for each area"
  XEN_ASSERT_TYPE(XEN_MainWindowWidget_P(arg1), arg1, 1, "XmMainWindowSetAreas", "MainWindow Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2) || XEN_BOOLEAN_P(arg2), arg2, 2, "XmMainWindowSetAreas", "Widget or #f=NULL");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3) || XEN_BOOLEAN_P(arg3), arg3, 3, "XmMainWindowSetAreas", "Widget or #f=NULL");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg4) || XEN_BOOLEAN_P(arg4), arg4, 4, "XmMainWindowSetAreas", "Widget or #f=NULL");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg5) || XEN_BOOLEAN_P(arg5), arg5, 5, "XmMainWindowSetAreas", "Widget or #f=NULL");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg6) || XEN_BOOLEAN_P(arg6), arg6, 6, "XmMainWindowSetAreas", "Widget or #f=NULL");
  XmMainWindowSetAreas(XEN_TO_C_Widget(arg1),
		       (XEN_Widget_P(arg2) ? XEN_TO_C_Widget(arg2) : NULL),
		       (XEN_Widget_P(arg3) ? XEN_TO_C_Widget(arg3) : NULL),
		       (XEN_Widget_P(arg4) ? XEN_TO_C_Widget(arg4) : NULL),
		       (XEN_Widget_P(arg5) ? XEN_TO_C_Widget(arg5) : NULL),
		       (XEN_Widget_P(arg6) ? XEN_TO_C_Widget(arg6) : NULL));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmTranslateKey(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTranslateKey "void XmTranslateKey(Display *display, KeyCode keycode, Modifiers modifiers) \
The default keycode-to-keysym translator -> (modifiers keysym)"
  /* DIFF: XmTranslateKey omit and rtn last 2 args
   */
  Modifiers m;
  KeySym k;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmTranslateKey", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmTranslateKey", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XmTranslateKey", "Modifiers");
  XmTranslateKey(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_Modifiers(arg3), &m, &k);
  return(XEN_LIST_2(C_TO_XEN_Modifiers(m),
		    C_TO_XEN_KeySym(k)));
}

static XEN gxm_XmCreateScrolledList(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateScrolledList "Widget XmCreateScrolledList(Widget parent, String name, ArgList arglist, Cardinal argcount) The List \
ScrolledList creation function"
  return(gxm_new_widget("XmCreateScrolledList", XmCreateScrolledList, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateList(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateList "Widget XmCreateList(Widget parent, String name, ArgList arglist, Cardinal argcount) The List widget creation function"
  return(gxm_new_widget("XmCreateList", XmCreateList, arg1, arg2, arg3, arg4));
}

#define XEN_ListWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsList(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmListPosSelected(XEN arg1, XEN arg2)
{
  #define H_XmListPosSelected "Boolean XmListPosSelected(Widget widget, int position) determines if the list item at a \
specified position is selected"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListPosSelected", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListPosSelected", "int");
  return(C_TO_XEN_BOOLEAN(XmListPosSelected(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XmListUpdateSelectedList(XEN arg1)
{
  #define H_XmListUpdateSelectedList "void XmListUpdateSelectedList(Widget widget) updates the XmNselectedItems resource"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListUpdateSelectedList", "List Widget");
  XmListUpdateSelectedList(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmListSetHorizPos(XEN arg1, XEN arg2)
{
  #define H_XmListSetHorizPos "void XmListSetHorizPos(Widget widget, int position) scrolls to the specified position in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetHorizPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListSetHorizPos", "int");
  XmListSetHorizPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmListGetSelectedPos(XEN arg1)
{
  #define H_XmListGetSelectedPos "Boolean XmListGetSelectedPos(Widget widget) A List function that returns the position of every selected item in the list"
  /* DIFF: XmListGetSelectedPos omits args 2 and 3, returns list of positions
   */
  int *ps;
  int i, len, loc;
  Boolean b;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListGetSelectedPos", "List Widget");
  b = XmListGetSelectedPos(XEN_TO_C_Widget(arg1), &ps, &len);
  if (b == False)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_INT(ps[i]), lst);
  free(ps);
  xm_unprotect_at(loc);
  return(lst);
}
#endif

static XEN gxm_XmListGetMatchPos(XEN arg1, XEN arg2)
{
  #define H_XmListGetMatchPos "Boolean XmListGetMatchPos(Widget widget, XmString item) returns all instances of an item in the list"
  /* DIFF: XmListGetSelectedPos omits args 3 and 4, returns list of positions
   */
  int *ps;
  int i, len, loc;
  Boolean b;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListGetMatchPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListGetMatchPos", "XmString");
  b = XmListGetMatchPos(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), &ps, &len);
  if (b == False)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_INT(ps[i]), lst);
  free(ps);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmListPosToBounds(XEN arg1, XEN arg2)
{
  #define H_XmListPosToBounds "Boolean XmListPosToBounds(Widget widget, int position) returns the bounding box of an item at a specified position in a list"
  /* DIFF: XmListPosToBounds last 4 args omitted and returned 
   */
  Position x, y;
  Dimension w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListPosToBounds", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListPosToBounds", "int");
  val = XmListPosToBounds(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), &x, &y, &w, &h);
  return(XEN_LIST_5(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_Position(x),
		    C_TO_XEN_Position(y),
		    C_TO_XEN_Dimension(w),
		    C_TO_XEN_Dimension(h)));
}


static XEN gxm_XmListYToPos(XEN arg1, XEN arg2)
{
  #define H_XmListYToPos "int XmListYToPos(Widget widget, Position y) returns the position of the item at a specified y-coordinate"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListYToPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_Position_P(arg2), arg2, 2, "XmListYToPos", "Position");
  return(C_TO_XEN_INT(XmListYToPos(XEN_TO_C_Widget(arg1), XEN_TO_C_Position(arg2))));
}

static XEN gxm_XmListSetKbdItemPos(XEN arg1, XEN arg2)
{
  #define H_XmListSetKbdItemPos "Boolean XmListSetKbdItemPos(Widget widget, int position) sets the location cursor at a specified position"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetKbdItemPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListSetKbdItemPos", "int");
  return(C_TO_XEN_BOOLEAN(XmListSetKbdItemPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XmListGetKbdItemPos(XEN arg1)
{
  #define H_XmListGetKbdItemPos "int XmListGetKbdItemPos(Widget widget) returns the position of the item at the location cursor"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListGetKbdItemPos", "List Widget");
  return(C_TO_XEN_INT(XmListGetKbdItemPos(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmListItemPos(XEN arg1, XEN arg2)
{
  #define H_XmListItemPos "int XmListItemPos(Widget widget, XmString item) returns the position of an item in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListItemPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListItemPos", "XmString");
  return(C_TO_XEN_INT(XmListItemPos(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmListItemExists(XEN arg1, XEN arg2)
{
  #define H_XmListItemExists "Boolean XmListItemExists(Widget widget, XmString item) checks if a specified item is in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListItemExists", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListItemExists", "XmString");
  return(C_TO_XEN_BOOLEAN(XmListItemExists(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2))));
}

static XEN gxm_XmListSetAddMode(XEN arg1, XEN arg2)
{
  #define H_XmListSetAddMode "void XmListSetAddMode(Widget widget, Boolean state) sets add mode in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetAddMode", "List Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmListSetAddMode", "boolean");
  XmListSetAddMode(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListSetBottomItem(XEN arg1, XEN arg2)
{
  #define H_XmListSetBottomItem "void XmListSetBottomItem(Widget widget, XmString item) makes an existing item the last \
visible item in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetBottomItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListSetBottomItem", "XmString");
  XmListSetBottomItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListSetItem(XEN arg1, XEN arg2)
{
  #define H_XmListSetItem "void XmListSetItem(Widget widget, XmString item) makes an existing item the first visible item in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListSetItem", "XmString");
  XmListSetItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListSetBottomPos(XEN arg1, XEN arg2)
{
  #define H_XmListSetBottomPos "void XmListSetBottomPos(Widget widget, int position) makes a specified item the last visible item in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetBottomPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListSetBottomPos", "int");
  XmListSetBottomPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListSetPos(XEN arg1, XEN arg2)
{
  #define H_XmListSetPos "void XmListSetPos(Widget widget, int position) makes the item at the given position the first \
visible position in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSetPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListSetPos", "int");
  XmListSetPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeselectAllItems(XEN arg1)
{
  #define H_XmListDeselectAllItems "void XmListDeselectAllItems(Widget widget) unhighlights and removes all items from the selected list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeselectAllItems", "List Widget");
  XmListDeselectAllItems(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeselectPos(XEN arg1, XEN arg2)
{
  #define H_XmListDeselectPos "void XmListDeselectPos(Widget widget, int position) deselects an item at a specified position in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeselectPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListDeselectPos", "int");
  XmListDeselectPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeselectItem(XEN arg1, XEN arg2)
{
  #define H_XmListDeselectItem "void XmListDeselectItem(Widget widget, XmString item) deselects the specified item from the selected list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeselectItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListDeselectItem", "XmString");
  XmListDeselectItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListSelectPos(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListSelectPos "void XmListSelectPos(Widget widget, int position, Boolean notify) selects an item at a specified \
position in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSelectPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListSelectPos", "int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmListSelectPos", "boolean");
  XmListSelectPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_BOOLEAN(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmListSelectItem(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListSelectItem "void XmListSelectItem(Widget widget, XmString item, Boolean notify) selects an item in the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListSelectItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListSelectItem", "XmString");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmListSelectItem", "boolean");
  XmListSelectItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_BOOLEAN(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmListReplacePositions(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListReplacePositions "void XmListReplacePositions(Widget widget, int *position_list, XmString *item_list, int item_count) \
replaces items in a list based on position"
  /* DIFF: XmListReplacePositions arg 2 is list of ints, arg3 is list of XmStrings
   */
  int *ps;
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListReplacePositions", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListReplacePositions", "list of int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmListReplacePositions", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmListReplacePositions", "int");
  if (XEN_INTEGER_P(arg4)) len = XEN_TO_C_INT(arg4); else len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) return(XEN_FALSE);
  ps = XEN_TO_C_Ints(arg2, len);
  str = XEN_TO_C_XmStrings(arg3, len);
  XmListReplacePositions(XEN_TO_C_Widget(arg1), ps, str, len);
  FREE(ps);
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListReplaceItemsPosUnselected(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListReplaceItemsPosUnselected "void XmListReplaceItemsPosUnselected(Widget widget, XmString *new_items, int item_count, int position) \
replaces items in a list without selecting the replacement items"
  /* DIFF: XmListReplaceItemsPosUnselected arg 2 is list of XmStrings
   */
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListReplaceItemsPosUnselected", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListReplaceItemsPosUnselected", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListReplaceItemsPosUnselected", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmListReplaceItemsPosUnselected", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_XmStrings(arg2, len);
  XmListReplaceItemsPosUnselected(XEN_TO_C_Widget(arg1), str, len, XEN_TO_C_INT(arg4));
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListReplaceItemsUnselected(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListReplaceItemsUnselected "void XmListReplaceItemsUnselected(Widget widget, XmString *old_items, int item_count, XmString *new_items) \
replaces items in a list"
  /* DIFF: XmListReplaceItemsUnselected args 2 and 4 are lists of XmStrings
   */
  XmString *str1, *str2;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListReplaceItemsUnselected", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListReplaceItemsUnselected", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListReplaceItemsUnselected", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmListReplaceItemsUnselected", "list of XmString");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str1 = XEN_TO_C_XmStrings(arg2, len);
  str2 = XEN_TO_C_XmStrings(arg4, len);
  XmListReplaceItemsUnselected(XEN_TO_C_Widget(arg1), str1, len, str2);
  FREE(str1);
  FREE(str2);
  return(XEN_FALSE);
}

static XEN gxm_XmListReplaceItemsPos(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListReplaceItemsPos "void XmListReplaceItemsPos(Widget widget, XmString *new_items, int item_count, int position) \
replaces the specified elements in the list"
  /* DIFF: XmListReplaceItemsPos arg 2 is list of XmStrings
   */
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListReplaceItemsPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListReplaceItemsPos", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListReplaceItemsPos", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmListReplaceItemsPos", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_XmStrings(arg2, len);
  XmListReplaceItemsPos(XEN_TO_C_Widget(arg1), str, len, XEN_TO_C_INT(arg4));
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListReplaceItems(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListReplaceItems "void XmListReplaceItems(Widget widget, XmString *old_items, int item_count, XmString *new_items) \
replaces the specified elements in the list"
  /* DIFF: XmListReplaceItems args 2 and 4 are lists of XmStrings
   */
  XmString *str1, *str2;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListReplaceItems", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListReplaceItems", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListReplaceItems", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmListReplaceItems", "XmString*");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str1 = XEN_TO_C_XmStrings(arg2, len);
  str2 = XEN_TO_C_XmStrings(arg4, len);
  XmListReplaceItems(XEN_TO_C_Widget(arg1), str1, len, str2);
  FREE(str1);
  FREE(str2);
  return(XEN_FALSE);
}

static XEN gxm_XmListDeleteAllItems(XEN arg1)
{
  #define H_XmListDeleteAllItems "void XmListDeleteAllItems(Widget widget) deletes all items from the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeleteAllItems", "List Widget");
  XmListDeleteAllItems(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeleteItemsPos(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListDeleteItemsPos "void XmListDeleteItemsPos(Widget widget, int item_count, int position) deletes \
items from the list starting at the given position"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeleteItemsPos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListDeleteItemsPos", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListDeleteItemsPos", "int");
  XmListDeleteItemsPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeletePos(XEN arg1, XEN arg2)
{
  #define H_XmListDeletePos "void XmListDeletePos(Widget widget, int position) deletes an item from a list at a specified position"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeletePos", "List Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmListDeletePos", "int");
  XmListDeletePos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListDeletePositions(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListDeletePositions "void XmListDeletePositions(Widget widget, int *position_list, int position_count) deletes \
items from a list based on an array of positions"
  /* DIFF: XmListDeletePositions arg2 is list of ints
   */
  int *pos;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeletePositions", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListDeletePositions", "list of int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmListDeletePositions", "int");
  if (XEN_INTEGER_P(arg3)) len = XEN_TO_C_INT(arg3); else len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) return(XEN_FALSE);
  pos = XEN_TO_C_Ints(arg2, len);
  XmListDeletePositions(XEN_TO_C_Widget(arg1), pos, len);
  FREE(pos);
  return(XEN_FALSE);
}

static XEN gxm_XmListDeleteItems(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListDeleteItems "void XmListDeleteItems(Widget widget, XmString *items, int item_count) deletes items from the list"
  /* DIFF: XmListDeleteItems arg 2 is list of XmStrings
   */
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeleteItems", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListDeleteItems", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmListDeleteItems", "int");
  if (XEN_INTEGER_P(arg3)) len = XEN_TO_C_INT(arg3); else len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_XmStrings(arg2, len);
  XmListDeleteItems(XEN_TO_C_Widget(arg1), str, len);
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListDeleteItem(XEN arg1, XEN arg2)
{
  #define H_XmListDeleteItem "void XmListDeleteItem(Widget widget, XmString item) deletes an item from the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListDeleteItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListDeleteItem", "XmString");
  XmListDeleteItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmListAddItemUnselected(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListAddItemUnselected "void XmListAddItemUnselected(Widget widget, XmString item, int position) adds an item to the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListAddItemUnselected", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListAddItemUnselected", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListAddItemUnselected", "int");
  XmListAddItemUnselected(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmListAddItemsUnselected(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListAddItemsUnselected "void XmListAddItemsUnselected(Widget widget, XmString *items, int item_count, int position) \
adds items to a list"
  /* DIFF: XmListAddItemsUnselected arg 2 is list of XmStrings
   */
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListAddItemsUnselected", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListAddItemsUnselected", "list of XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListAddItemsUnselected", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmListAddItemsUnselected", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_XmStrings(arg2, len);
  XmListAddItemsUnselected(XEN_TO_C_Widget(arg1), str, len, XEN_TO_C_INT(arg4));
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListAddItems(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmListAddItems "void XmListAddItems(Widget widget, XmString *items, int item_count, int position) adds items to the list"
  /* DIFF: XmListAddItems arg 2 is list of XmStrings
   */
  XmString *str;
  int len;
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListAddItems", "List Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmListAddItems", "XmString*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListAddItems", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmListAddItems", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_XmStrings(arg2, len);
  XmListAddItems(XEN_TO_C_Widget(arg1), str, len, XEN_TO_C_INT(arg4));
  FREE(str);
  return(XEN_FALSE);
}

static XEN gxm_XmListAddItem(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmListAddItem "void XmListAddItem(Widget widget, XmString item, int position) adds an item to the list"
  XEN_ASSERT_TYPE(XEN_ListWidget_P(arg1), arg1, 1, "XmListAddItem", "List Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmListAddItem", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmListAddItem", "int");
  XmListAddItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmIsMotifWMRunning(XEN arg1)
{
  #define H_XmIsMotifWMRunning "Boolean XmIsMotifWMRunning(Widget shell)  determines whether the window manager is running"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmIsMotifWMRunning", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsMotifWMRunning(XEN_TO_C_Widget(arg1))));
}

/* DIFF: all XmCreate<Obj> arglist is a list of args 
 */
static XEN gxm_XmCreateLabel(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateLabel "Widget XmCreateLabel(Widget parent, String name, ArgList arglist, Cardinal argcount) The Label widget creation function"
  return(gxm_new_widget("XmCreateLabel", XmCreateLabel, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateLabelGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateLabelGadget "Widget XmCreateLabelGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) The LabelGadget creation function"
  return(gxm_new_widget("XmCreateLabelGadget", XmCreateLabelGadget, arg1, arg2, arg3, arg4));
}

#if MOTIF_2_2
static XEN gxm_XmToolTipGetLabel(XEN arg1)
{
  #define H_XmToolTipGetLabel "Widget XmToolTipGetLabel(Widget wid) apparently returns the tooltip label associated with its argument"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, XEN_ONLY_ARG, "XmToolTipGetLabel", "Widget");
  return(C_TO_XEN_Widget(XmToolTipGetLabel(XEN_TO_C_Widget(arg1))));
}
#endif

#if MOTIF_2
static XEN gxm_XmCreateIconHeader(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateIconHeader "Widget XmCreateIconHeader(Widget parent, String name, ArgList arglist, Cardinal argcount)"
  return(gxm_new_widget("XmCreateIconHeader", XmCreateIconHeader, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateIconGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateIconGadget "Widget XmCreateIconGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The IconGadget widget creation function"
  return(gxm_new_widget("XmCreateIconGadget", XmCreateIconGadget, arg1, arg2, arg3, arg4));
}
#endif

static XEN gxm_XmCreateToggleButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateToggleButton "Widget XmCreateToggleButton(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ToggleButton widget creation function"
  return(gxm_new_widget("XmCreateToggleButton", XmCreateToggleButton, arg1, arg2, arg3, arg4));
}

#define XEN_ToggleButtonWidget_P(Arg) (XEN_Widget_P(Arg) && (XmIsToggleButton(XEN_TO_C_Widget(Arg)) || XmIsToggleButtonGadget(XEN_TO_C_Widget(Arg))))

#if MOTIF_2
static XEN gxm_XmToggleButtonSetValue(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmToggleButtonSetValue "void XmToggleButtonSetValue(Widget widget, XmToggleButtonState state, Boolean notify) \
sets or changes the current state"
  XEN_ASSERT_TYPE(XEN_ToggleButtonWidget_P(arg1), arg1, 1, "XmToggleButtonSetValue", "ToggleButton Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmToggleButtonSetValue", "int (actually XmToggleButtonState)");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmToggleButtonSetValue", "boolean");
  return(C_TO_XEN_BOOLEAN(XmToggleButtonSetValue(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_BOOLEAN(arg3))));
}
#endif

static XEN gxm_XmToggleButtonSetState(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmToggleButtonSetState "void XmToggleButtonSetState(Widget widget, Boolean state, Boolean notify) \
sets or changes the current state"
  XEN_ASSERT_TYPE(XEN_ToggleButtonWidget_P(arg1), arg1, 1, "XmToggleButtonSetState", "ToggleButton Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmToggleButtonSetState", "boolean");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmToggleButtonSetState", "boolean");
  XmToggleButtonSetState(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2), XEN_TO_C_BOOLEAN(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmToggleButtonGetState(XEN arg1)
{
  #define H_XmToggleButtonGetState "Boolean XmToggleButtonGetState(Widget widget) obtains the state of a ToggleButton"
  XEN_ASSERT_TYPE(XEN_ToggleButtonWidget_P(arg1), arg1, 1, "XmToggleButtonGetState", "ToggleButton Widget");
  return(C_TO_XEN_BOOLEAN(XmToggleButtonGetState(XEN_TO_C_Widget(arg1))));
}


static XEN gxm_XmCreateToggleButtonGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateToggleButtonGadget "Widget XmCreateToggleButtonGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ToggleButtonGadget creation function"
  return(gxm_new_widget("XmCreateToggleButtonGadget", XmCreateToggleButtonGadget, arg1, arg2, arg3, arg4));
}

#if MOTIF_2
static XEN gxm_XmToggleButtonGadgetSetValue(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmToggleButtonGadgetSetValue "Boolean XmToggleButtonGadgetSetValue(Widget w, XmToggleButtonState newstate, Boolean notify)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmToggleButtonGadgetSetValue", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmToggleButtonGadgetSetValue", "int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmToggleButtonGadgetSetValue", "boolean");
  return(C_TO_XEN_BOOLEAN(XmToggleButtonGadgetSetValue(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_BOOLEAN(arg3))));
}

static XEN gxm_XmCreateGrabShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateGrabShell "Widget XmCreateGrabShell(Widget parent, char *name, ArgList al, Cardinal ac) -> a new GrabShell"
  return(gxm_new_widget("XmCreateGrabShell", XmCreateGrabShell, arg1, arg2, arg3, arg4));
}

#endif

static XEN gxm_XmToggleButtonGadgetSetState(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmToggleButtonGadgetSetState "void XmToggleButtonGadgetSetState(Widget widget, Boolean state, Boolean notify) \
sets or changes the current state"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmToggleButtonGadgetSetState", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmToggleButtonGadgetSetState", "boolean");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmToggleButtonGadgetSetState", "boolean");
  XmToggleButtonGadgetSetState(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2), XEN_TO_C_BOOLEAN(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmToggleButtonGadgetGetState(XEN arg1)
{
  #define H_XmToggleButtonGadgetGetState "Boolean XmToggleButtonGadgetGetState(Widget widget) obtains \
the state of a ToggleButtonGadget"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmToggleButtonGadgetGetState", "Widget");
  return(C_TO_XEN_BOOLEAN(XmToggleButtonGadgetGetState(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmCreateFrame(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateFrame "Widget XmCreateFrame(Widget parent, String name, ArgList arglist, Cardinal argcount) The Frame widget creation function"
  return(gxm_new_widget("XmCreateFrame", XmCreateFrame, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateFormDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateFormDialog "Widget XmCreateFormDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A Form FormDialog creation function"
  return(gxm_new_widget("XmCreateFormDialog", XmCreateFormDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateForm(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateForm "Widget XmCreateForm(Widget parent, String name, ArgList arglist, Cardinal argcount) The Form widget creation function"
  return(gxm_new_widget("XmCreateForm", XmCreateForm, arg1, arg2, arg3, arg4));
}

#define XEN_TextWidget_P(Arg) (XEN_Widget_P(Arg) && (XmIsText(XEN_TO_C_Widget(Arg)) || XmIsTextField(XEN_TO_C_Widget(Arg))))
#define XEN_JustTextWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsText(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmTextFindString(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextFindString "Boolean XmTextFindString(Widget widget, XmTextPosition start, char *string, XmTextDirection direction) \
finds the beginning position of a text string"
  /* DIFF: XmTextFindString widget start string dir [pos] -> pos or #f
  */
  XmTextPosition pos;
  int res;
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextFindString", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFindString", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmTextFindString", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTextFindString", "XmTextDirection");
  res = XmTextFindString(XEN_TO_C_Widget(arg1), 
			 (XmTextPosition)XEN_TO_C_INT(arg2), 
			 XEN_TO_C_STRING(arg3), 
			 (XmTextDirection)XEN_TO_C_INT(arg4), 
			 &pos);
  if (res != False)
    return(C_TO_XEN_INT(pos));
  return(XEN_FALSE);
}

static XEN gxm_XmTextEnableRedisplay(XEN arg1)
{
  #define H_XmTextEnableRedisplay "void XmTextEnableRedisplay(Widget widget) forces the visual update of a Text widget"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextEnableRedisplay", "Text or TextField Widget");
  XmTextEnableRedisplay(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmTextDisableRedisplay(XEN arg1)
{
  #define H_XmTextDisableRedisplay "void XmTextDisableRedisplay(Widget widget) temporarily prevents visual update of the Text widget"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextDisableRedisplay", "Text or TextField Widget");
  XmTextDisableRedisplay(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmTextGetCenterline(XEN arg1)
{
  #define H_XmTextGetCenterline "int XmTextGetCenterline(Widget widget) Return the height (length) of a character string when the writing direction is vertical"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetCenterline", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetCenterline(XEN_TO_C_Widget(arg1))));
}
#endif

static XEN gxm_XmTextGetBaseline(XEN arg1)
{
  #define H_XmTextGetBaseline "int XmTextGetBaseline(Widget widget) accesses the y position of the baseline"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetBaseline", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetBaseline(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextScroll(XEN arg1, XEN arg2)
{
  #define H_XmTextScroll "void XmTextScroll(Widget widget, int lines) scrolls text"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextScroll", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextScroll", "int");
  XmTextScroll(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextShowPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextShowPosition "void XmTextShowPosition(Widget widget, XmTextPosition position) forces text at a given position to be displayed"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextShowPosition", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextShowPosition", "XmTextPosition");
  XmTextShowPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextSetSource(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextSetSource "void XmTextSetSource(Widget widget, XmTextSource source, XmTextPosition top_character, \
XmTextPosition cursor_position) sets the source of the widget"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextSetSource", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_XmTextSource_P(arg2), arg2, 2, "XmTextSetSource", "XmTextSource");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextSetSource", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTextSetSource", "XmTextPosition");
  XmTextSetSource(XEN_TO_C_Widget(arg1), XEN_TO_C_XmTextSource(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetSource(XEN arg1)
{
  #define H_XmTextGetSource "XmTextSource XmTextGetSource(Widget widget) accesses the source of the widget"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextGetSource", "Text or TextField Widget");
  return(C_TO_XEN_XmTextSource(XmTextGetSource(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextPosToXY(XEN arg1, XEN arg2)
{
  #define H_XmTextPosToXY "Boolean XmTextPosToXY(Widget widget, XmTextPosition position) A Text function \
that returns the x and y position of a character position"
  /* DIFF: XmTextPosToXY omits last 2 args and returns them
   */
  Position x, y;
  int val;
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextPosToXY", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextPosToXY", "XmTextPosition");
  val = XmTextPosToXY(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), &x, &y);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_Position(x),
		    C_TO_XEN_Position(y)));
}

static XEN gxm_XmTextXYToPos(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTextXYToPos "XmTextPosition XmTextXYToPos(Widget widget, Position x, Position y) accesses \
the character position nearest an x and y position"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextXYToPos", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextXYToPos", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextXYToPos", "int");
  return(C_TO_XEN_INT(XmTextXYToPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmTextGetSelectionPosition(XEN arg1)
{
  #define H_XmTextGetSelectionPosition "Boolean XmTextGetSelectionPosition(Widget widget) returns the position of the primary selection"
  /* DIFF: XmTextGetSelectionPosition widget [left right] -> (list res left right)
     no arg2 arg3, returns (owner left right) instead */
  XmTextPosition pos1, pos2;
  int res;
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetSelectionPosition", "Text or TextField Widget");
  res = XmTextGetSelectionPosition(XEN_TO_C_Widget(arg1), &pos1, &pos2);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(res),
		    C_TO_XEN_INT(pos1),
		    C_TO_XEN_INT(pos2)));
}

static XEN gxm_XmTextClearSelection(XEN arg1, XEN arg2)
{
  #define H_XmTextClearSelection "void XmTextClearSelection(Widget widget, Time time) clears the primary selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextClearSelection", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextClearSelection", "Time");
  XmTextClearSelection(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextSetSelection(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextSetSelection "void XmTextSetSelection(Widget widget, XmTextPosition first, XmTextPosition last, Time time) \
sets the primary selection of the text"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetSelection", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetSelection", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextSetSelection", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XmTextSetSelection", "Time");
  XmTextSetSelection(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_Time(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetSelection(XEN arg1)
{
  #define H_XmTextGetSelection "char * XmTextGetSelection(Widget widget) retrieves the value of the primary selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetSelection", "Text or TextField Widget");
  return(C_TO_XEN_STRING(XmTextGetSelection(XEN_TO_C_Widget(arg1))));
}

#if MOTIF_2
static XEN gxm_XmTextPasteLink(XEN arg1)
{
  #define H_XmTextPasteLink "Boolean XmTextPasteLink(Widget widget) inserts a link to the clipboard selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextPasteLink", "Text or TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextPasteLink(XEN_TO_C_Widget(arg1))));
}
#endif

static XEN gxm_XmTextPaste(XEN arg1)
{
  #define H_XmTextPaste "Boolean XmTextPaste(Widget widget) inserts the clipboard selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextPaste", "Text or TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextPaste(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextCut(XEN arg1, XEN arg2)
{
  #define H_XmTextCut "Boolean XmTextCut(Widget widget, Time time) copies the primary selection to the clipboard and deletes the selected text"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextCut", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextCut", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextCut(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

#if MOTIF_2
static XEN gxm_XmTextCopyLink(XEN arg1, XEN arg2)
{
  #define H_XmTextCopyLink "Boolean XmTextCopyLink(Widget widget, Time time) copies a link to the primary selection to the clipboard"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextCopyLink", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextCopyLink", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextCopyLink(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}
#endif

static XEN gxm_XmTextCopy(XEN arg1, XEN arg2)
{
  #define H_XmTextCopy "Boolean XmTextCopy(Widget widget, Time time) copies the primary selection to the clipboard"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextCopy", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextCopy", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextCopy(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmTextRemove(XEN arg1)
{
  #define H_XmTextRemove "Boolean XmTextRemove(Widget widget) deletes the primary selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextRemove", "Text or TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextRemove(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextSetCursorPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextSetCursorPosition "void XmTextSetCursorPosition(Widget w, int position) sets the insertion cursor position"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetCursorPosition", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetCursorPosition", "XmTextPosition");
  XmTextSetCursorPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextSetInsertionPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextSetInsertionPosition "void XmTextSetInsertionPosition(Widget widget, XmTextPosition position) \
sets the position of the insert cursor"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetInsertionPosition", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetInsertionPosition", "XmTextPosition");
  XmTextSetInsertionPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetInsertionPosition(XEN arg1)
{
  #define H_XmTextGetInsertionPosition "XmTextPosition XmTextGetInsertionPosition(Widget widget) accesses the \
position of the insert cursor"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetInsertionPosition", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetInsertionPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextGetCursorPosition(XEN arg1)
{
  #define H_XmTextGetCursorPosition "int XmTextGetCursorPosition(Widget w) presumably returns the widget's insertion cursor position"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetCursorPosition", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetCursorPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextSetTopCharacter(XEN arg1, XEN arg2)
{
  #define H_XmTextSetTopCharacter "void XmTextSetTopCharacter(Widget widget, XmTextPosition top_character) sets \
the position of the first character displayed"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextSetTopCharacter", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetTopCharacter", "XmTextPosition");
  XmTextSetTopCharacter(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetTopCharacter(XEN arg1)
{
  #define H_XmTextGetTopCharacter "XmTextPosition XmTextGetTopCharacter(Widget widget) accesses the position of the first character displayed"
  XEN_ASSERT_TYPE(XEN_JustTextWidget_P(arg1), arg1, 1, "XmTextGetTopCharacter", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetTopCharacter(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextSetMaxLength(XEN arg1, XEN arg2)
{
  #define H_XmTextSetMaxLength "void XmTextSetMaxLength(Widget widget, int max_length) sets the value of the current \
maximum allowable length of a text string entered from the keyboard"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetMaxLength", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetMaxLength", "int");
  XmTextSetMaxLength(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetMaxLength(XEN arg1)
{
  #define H_XmTextGetMaxLength "int XmTextGetMaxLength(Widget widget) accesses the value of the current maximum allowable \
length of a text string entered from the keyboard"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetMaxLength", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetMaxLength(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextSetEditable(XEN arg1, XEN arg2)
{
  #define H_XmTextSetEditable "void XmTextSetEditable(Widget widget, Boolean editable) sets the edit permission"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetEditable", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmTextSetEditable", "boolean");
  XmTextSetEditable(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetEditable(XEN arg1)
{
  #define H_XmTextGetEditable "Boolean XmTextGetEditable(Widget widget) accesses the edit permission state"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetEditable", "Text or TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextGetEditable(XEN_TO_C_Widget(arg1))));
}

#if MOTIF_2
static XEN gxm_XmTextGetAddMode(XEN arg1)
{
  #define H_XmTextGetAddMode "Boolean XmTextGetAddMode(Widget w) presumably returns the widget's current add mode."
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetAddMode", "Text or TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextGetAddMode(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextSetAddMode(XEN arg1, XEN arg2)
{
  #define H_XmTextSetAddMode "void XmTextSetAddMode(Widget widget, Boolean state) sets the widget's add mode -- \
this determines whether you can move the insertion cursor without changing the primary selection"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetAddMode", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmTextSetAddMode", "boolean");
  XmTextSetAddMode(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmTextInsert(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTextInsert "void XmTextInsert(Widget widget, XmTextPosition position, char * value) inserts a character \
string into a text string"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextInsert", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextInsert", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmTextInsert", "char*");
  XmTextInsert(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_STRING(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmTextReplace(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextReplace "void XmTextReplace(Widget widget, XmTextPosition from_pos, XmTextPosition to_pos, char * value) \
replaces part of a text string"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextReplace", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextReplace", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextReplace", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmTextReplace", "char*");
  XmTextReplace(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_STRING(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextSetString(XEN arg1, XEN arg2)
{
  #define H_XmTextSetString "void XmTextSetString(Widget widget, char * value) sets the string value"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetString", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmTextSetString", "char*");
  XmTextSetString(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextGetLastPosition(XEN arg1)
{
  #define H_XmTextGetLastPosition "XmTextPosition XmTextGetLastPosition(Widget widget) accesses the last position in the text"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetLastPosition", "Text or TextField Widget");
  return(C_TO_XEN_INT(XmTextGetLastPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextGetString(XEN arg1)
{
  #define H_XmTextGetString "char * XmTextGetString(Widget widget) accesses the string value"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetString", "Text or TextField Widget");
  return(C_TO_XEN_STRING(XmTextGetString(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextGetSubstring(XEN arg1, XEN arg2, XEN arg3)
{
  /* DIFF: omit and rtn last 2 args */
  #define H_XmTextGetSubstring "int XmTextGetSubstring(Widget widget, XmTextPosition start, int num_chars) \
retrieves a copy of a portion of the internal text buffer"
  int rtn, len;
  char *buf;
  XEN str = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextGetSubstring", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextGetSubstring", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextGetSubstring", "int");
  len = XEN_TO_C_INT(arg3);
  buf = (char *)CALLOC(len + 1, sizeof(char));
  rtn = XmTextGetSubstring(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), len, len + 1, buf);
  if (rtn != XmCOPY_FAILED)
    str = C_TO_XEN_STRING(buf);
  FREE(buf);
  return(str);
}

static XEN gxm_XmCreateText(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateText "Widget XmCreateText(Widget parent, String name, ArgList arglist, Cardinal argcount) The Text widget creation function"
  return(gxm_new_widget("XmCreateText", XmCreateText, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateScrolledText(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateScrolledText "Widget XmCreateScrolledText(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Text ScrolledText creation function"
  return(gxm_new_widget("XmCreateScrolledText", XmCreateScrolledText, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmTextSetHighlight(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextSetHighlight "void XmTextSetHighlight(Widget widget, XmTextPosition left, XmTextPosition right, XmHighlightMode mode) \
highlights text"
  XEN_ASSERT_TYPE(XEN_TextWidget_P(arg1), arg1, 1, "XmTextSetHighlight", "Text or TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextSetHighlight", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextSetHighlight", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTextSetHighlight", "XmHighlightMode");
  XmTextSetHighlight(XEN_TO_C_Widget(arg1), 
		     (XmTextPosition)XEN_TO_C_INT(arg2), 
		     (XmTextPosition)XEN_TO_C_INT(arg3), 
		     (XmHighlightMode)XEN_TO_C_INT(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateFileSelectionDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateFileSelectionDialog "Widget XmCreateFileSelectionDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The FileSelectionBox FileSelectionDialog creation function"
  return(gxm_new_widget("XmCreateFileSelectionDialog", XmCreateFileSelectionDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateFileSelectionBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateFileSelectionBox "Widget XmCreateFileSelectionBox(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The FileSelectionBox widget creation function"
  return(gxm_new_widget("XmCreateFileSelectionBox", XmCreateFileSelectionBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmFileSelectionDoSearch(XEN arg1, XEN arg2)
{
  #define H_XmFileSelectionDoSearch "void XmFileSelectionDoSearch(Widget widget, XmString dirmask) \
initiates a directory search"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmFileSelectionDoSearch", "Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2) || XEN_FALSE_P(arg2), arg2, 2, "XmFileSelectionDoSearch", "XmString");
  XmFileSelectionDoSearch(XEN_TO_C_Widget(arg1), XEN_FALSE_P(arg2) ? NULL : XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmFileSelectionBoxGetChild(XEN arg1, XEN arg2)
{
  #define H_XmFileSelectionBoxGetChild "Widget XmFileSelectionBoxGetChild(Widget widget, unsigned char child) \
used to access a component"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmFileSelectionBoxGetChild", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmFileSelectionBoxGetChild", "unsigned int");
  return(C_TO_XEN_Widget(XmFileSelectionBoxGetChild(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XmCreateTextField(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateTextField "Widget XmCreateTextField(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The TextField widget creation function"
  return(gxm_new_widget("XmCreateTextField", XmCreateTextField, arg1, arg2, arg3, arg4));
}

#define XEN_TextFieldWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsTextField(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmTextFieldGetBaseline(XEN arg1)
{
  #define H_XmTextFieldGetBaseline "int XmTextFieldGetBaseline(Widget widget) accesses the y position of the baseline"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetBaseline", "TextField Widget");
  return(C_TO_XEN_INT(XmTextFieldGetBaseline(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldSetHighlight(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextFieldSetHighlight "void XmTextFieldSetHighlight(Widget widget, XmTextPosition left, XmTextPosition right, XmHighlightMode mode) \
highlights text"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetHighlight", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldSetHighlight", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextFieldSetHighlight", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmTextFieldSetHighlight", "XmHighlightMode");
  XmTextFieldSetHighlight(XEN_TO_C_Widget(arg1), 
			  (XmTextPosition)XEN_TO_C_INT(arg2), 
			  (XmTextPosition)XEN_TO_C_INT(arg3), 
			  (XmHighlightMode)XEN_TO_C_INT(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldShowPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldShowPosition "void XmTextFieldShowPosition(Widget widget, XmTextPosition position) \
forces text at a given position to be displayed"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldShowPosition", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldShowPosition", "XmTextPosition");
  XmTextFieldShowPosition(XEN_TO_C_Widget(arg1), 
			  (XmTextPosition)XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldPosToXY(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldPosToXY "Boolean XmTextFieldPosToXY(Widget widget, XmTextPosition position) returns the x and y position of a character position"
  /* DIFF: XmTextFieldPosToXY omits last 2 args and returns them
   */
  Position x, y;
  int val;
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldPosToXY", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldPosToXY", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmTextPosToXY", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextPosToXY", "XmTextPosition");
  val = XmTextFieldPosToXY(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), &x, &y);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_Position(x),
		    C_TO_XEN_Position(y)));
}

static XEN gxm_XmTextFieldXYToPos(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTextFieldXYToPos "XmTextPosition XmTextFieldXYToPos(Widget widget, Position x, Position y) \
accesses the character position nearest an x and y position"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldXYToPos", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldXYToPos", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextFieldXYToPos", "int");
  return(C_TO_XEN_INT(XmTextFieldXYToPos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmTextFieldSetSelection(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextFieldSetSelection "void XmTextFieldSetSelection(Widget widget, XmTextPosition first, XmTextPosition last, Time time) \
sets the primary selection of the text"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetSelection", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldSetSelection", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextFieldSetSelection", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XmTextFieldSetSelection", "Time");
  XmTextFieldSetSelection(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_Time(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldClearSelection(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldClearSelection "void XmTextFieldClearSelection(Widget widget, Time time) clears the primary selection"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldClearSelection", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextFieldClearSelection", "Time");
  XmTextFieldClearSelection(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2));
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmTextFieldPasteLink(XEN arg1)
{
  #define H_XmTextFieldPasteLink "Boolean XmTextFieldPasteLink(Widget widget) inserts a link to the clipboard selection"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldPasteLink", "TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextFieldPasteLink(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldCopyLink(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldCopyLink "Boolean XmTextFieldCopyLink(Widget widget, Time time) copies a link to the \
primary selection to the clipboard"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldCopyLink", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextFieldCopyLink", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextFieldCopyLink(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}
#endif

static XEN gxm_XmTextFieldPaste(XEN arg1)
{
  #define H_XmTextFieldPaste "Boolean XmTextFieldPaste(Widget widget) inserts the clipboard selection"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldPaste", "TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextFieldPaste(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldCut(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldCut "Boolean XmTextFieldCut(Widget widget, Time time) copies the primary selection \
to the clipboard and deletes the selected text"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldCut", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextFieldCut", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextFieldCut(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmTextFieldCopy(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldCopy "Boolean XmTextFieldCopy(Widget widget, Time time) copies the primary selection to the clipboard"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldCopy", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmTextFieldCopy", "Time");
  return(C_TO_XEN_BOOLEAN(XmTextFieldCopy(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmTextFieldRemove(XEN arg1)
{
  #define H_XmTextFieldRemove "Boolean XmTextFieldRemove(Widget widget) deletes the primary selection"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldRemove", "TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextFieldRemove(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldGetSelection(XEN arg1)
{
  #define H_XmTextFieldGetSelection "char * XmTextFieldGetSelection(Widget widget) retrieves the value of the primary selection"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetSelection", "TextField Widget");
  return(C_TO_XEN_STRING(XmTextFieldGetSelection(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldGetSelectionPosition(XEN arg1)
{
  #define H_XmTextFieldGetSelectionPosition "Boolean XmTextFieldGetSelectionPosition(Widget widget) \
returns the position of the primary selection"
  /* DIFF: XmTextFieldGetSelectionPosition widget [left right] -> (list res left right)
     no arg2 arg3, returns (owner left right) instead 
  */
  XmTextPosition pos1, pos2;
  int res;
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetSelectionPosition", "TextField Widget");
  res = XmTextFieldGetSelectionPosition(XEN_TO_C_Widget(arg1), &pos1, &pos2);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(res),
		    C_TO_XEN_INT(pos1),
		    C_TO_XEN_INT(pos2)));
}

static XEN gxm_XmTextFieldSetInsertionPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetInsertionPosition "void XmTextFieldSetInsertionPosition(Widget widget, XmTextPosition position) \
sets the position of the insertion cursor"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetInsertionPosition", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldSetInsertionPosition", "XmTextPosition");
  XmTextFieldSetInsertionPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldSetCursorPosition(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetCursorPosition "void XmTextFieldSetCursorPosition(Widget w, int position) sets the insertion cursor position"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetCursorPosition", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldSetCursorPosition", "XmTextPosition");
  XmTextFieldSetCursorPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldGetInsertionPosition(XEN arg1)
{
  #define H_XmTextFieldGetInsertionPosition "XmTextPosition XmTextFieldGetInsertionPosition(Widget widget) \
accesses the position of the insertion cursor"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetInsertionPosition", "TextField Widget");
  return(C_TO_XEN_INT(XmTextFieldGetInsertionPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldGetCursorPosition(XEN arg1)
{
  #define H_XmTextFieldGetCursorPosition "int XmTextFieldGetCursorPosition(Widget w) presumably returns the widget's insertion cursor position"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetCursorPosition", "TextField Widget");
  return(C_TO_XEN_INT(XmTextFieldGetCursorPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldSetMaxLength(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetMaxLength "void XmTextFieldSetMaxLength(Widget widget, int max_length) sets the \
value of the current maximum allowable length of a text string \
entered from the keyboard"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetMaxLength", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldSetMaxLength", "int");
  XmTextFieldSetMaxLength(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldGetMaxLength(XEN arg1)
{
  #define H_XmTextFieldGetMaxLength "int XmTextFieldGetMaxLength(Widget widget) accesses the value of the \
current maximum allowable length of a text string \
entered from the keyboard"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetMaxLength", "TextField Widget");
  return(C_TO_XEN_INT(XmTextFieldGetMaxLength(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldSetEditable(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetEditable "void XmTextFieldSetEditable(Widget widget, Boolean editable) sets the edit permission"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetEditable", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmTextFieldSetEditable", "boolean");
  XmTextFieldSetEditable(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldGetEditable(XEN arg1)
{
  #define H_XmTextFieldGetEditable "Boolean XmTextFieldGetEditable(Widget widget) accesses the edit permission state"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetEditable", "TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextFieldGetEditable(XEN_TO_C_Widget(arg1))));
}

#if MOTIF_2
static XEN gxm_XmTextFieldGetAddMode(XEN arg1)
{
  #define H_XmTextFieldGetAddMode "Boolean XmTextFieldGetAddMode(Widget w) presumably returns the widget's current add mode."
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetAddMode", "TextField Widget");
  return(C_TO_XEN_BOOLEAN(XmTextFieldGetAddMode(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldSetAddMode(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetAddMode "void XmTextFieldSetAddMode(Widget widget, Boolean state) sets the state of Add mode"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetAddMode", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmTextFieldSetAddMode", "boolean");
  XmTextFieldSetAddMode(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmTextFieldInsert(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmTextFieldInsert "void XmTextFieldInsert(Widget widget, XmTextPosition position, char * value) \
inserts a character string into a text string"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldInsert", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldInsert", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmTextFieldInsert", "char*");
  XmTextFieldInsert(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_STRING(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldReplace(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmTextFieldReplace "void XmTextFieldReplace(Widget widget, XmTextPosition from_pos, XmTextPosition to_pos, char * value) \
replaces part of a text string"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldReplace", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldReplace", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextFieldReplace", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmTextFieldReplace", "char*");
  XmTextFieldReplace(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_STRING(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldSetString(XEN arg1, XEN arg2)
{
  #define H_XmTextFieldSetString "void XmTextFieldSetString(Widget widget, char * value) sets the string value"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldSetString", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmTextFieldSetString", "char*");
  XmTextFieldSetString(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmTextFieldGetLastPosition(XEN arg1)
{
  #define H_XmTextFieldGetLastPosition "XmTextPosition XmTextFieldGetLastPosition(Widget widget) accesses \
the position of the last text character"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetLastPosition", "TextField Widget");
  return(C_TO_XEN_INT(XmTextFieldGetLastPosition(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmTextFieldGetSubstring(XEN arg1, XEN arg2, XEN arg3)
{
  /* DIFF: omit and rtn last 2 args */
  #define H_XmTextFieldGetSubstring "int XmTextFieldGetSubstring(Widget widget, XmTextPosition start, int num_chars) \
retrieves a copy of a portion of the internal text buffer"
  int rtn, len;
  char *buf;
  XEN str = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetSubstring", "TextField Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmTextFieldGetSubstring", "XmTextPosition");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTextFieldGetSubstring", "int");
  len = XEN_TO_C_INT(arg3);
  buf = (char *)CALLOC(len + 1, sizeof(char));
  rtn = XmTextFieldGetSubstring(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), len, len + 1, buf);
  if (rtn != XmCOPY_FAILED)
    str = C_TO_XEN_STRING(buf);
  FREE(buf);
  return(str);
}

static XEN gxm_XmTextFieldGetString(XEN arg1)
{
  #define H_XmTextFieldGetString "char * XmTextFieldGetString(Widget widget) accesses the string value"
  XEN_ASSERT_TYPE(XEN_TextFieldWidget_P(arg1), arg1, 1, "XmTextFieldGetString", "TextField Widget");
  return(C_TO_XEN_STRING(XmTextFieldGetString(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmDropTransferAdd(XEN arg1, XEN arg2)
{
  #define H_XmDropTransferAdd "void XmDropTransferAdd(Widget drop_transfer, XmDropTransferEntryRec *transfers) \
enables additional drop transfer entries to be processed after initiating a drop transfer"
  /* DIFF: XmDropTransferAdd  arg2 is list of (atom data) lists, arg3 omitted
   */
  int len;
  XmDropTransferEntryRec *entries;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropTransferAdd", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmDropTransferAdd", "XmDropTransferEntry");
  len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) return(XEN_FALSE);
  entries = XEN_TO_C_XmDropTransferEntryRecs(arg2, len);
  XmDropTransferAdd(XEN_TO_C_Widget(arg1), entries, len);
  FREE(entries);
  return(XEN_FALSE);
}

static XEN gxm_XmDropTransferStart(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDropTransferStart "Widget XmDropTransferStart(Widget widget, ArgList arglist, Cardinal argcount) \
initiates a drop transfer"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropTransferStart", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmDropTransferStart", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmDropTransferStart", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg2);
    w = XmDropTransferStart(XEN_TO_C_Widget(arg1), 
			    args, arglen = XEN_TO_C_INT_DEF(arg3, arg2));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmDropSiteConfigureStackingOrder(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDropSiteConfigureStackingOrder "void XmDropSiteConfigureStackingOrder(Widget widget, Widget sibling, Cardinal stack_mode) \
reorders a stack of widgets that are registered drop sites"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteConfigureStackingOrder", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmDropSiteConfigureStackingOrder", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmDropSiteConfigureStackingOrder", "int");
  XmDropSiteConfigureStackingOrder(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmDropSiteQueryStackingOrder(XEN arg1)
{
  #define H_XmDropSiteQueryStackingOrder "Status XmDropSiteQueryStackingOrder(Widget widget) -> (list parent child ...)"
  /* DIFF: XmDropSiteQueryStackingOrder widget [parent child numchild] -> (list parent child ...)
     no parent children num_children -- returned as '(parent child1...) or #f 
  */
  Widget parent;
  Widget *children;
  XEN lst = XEN_EMPTY_LIST;
  unsigned int num_children;
  int res, i, loc;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteQueryStackingOrder", "Widget");
  res = XmDropSiteQueryStackingOrder(XEN_TO_C_Widget(arg1), &parent, &children, &num_children);
  if (res == 0)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = num_children - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Widget(children[i]), lst);
  xm_unprotect_at(loc);
  return(XEN_CONS(C_TO_XEN_Widget(parent), lst));
}

static XEN gxm_XmDropSiteRetrieve(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDropSiteRetrieve "void XmDropSiteRetrieve(Widget widget, ArgList arglist, Cardinal argcount) \
retrieves resource values set on a drop site"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteRetrieve", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmDropSiteRetrieve", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmDropSiteRetrieve", "int");
  {  
    Arg *args;
    args = XEN_TO_C_Args(arg2);
    XmDropSiteRetrieve(XEN_TO_C_Widget(arg1), 
		       args, XEN_TO_C_INT_DEF(arg3, arg2));
    if (args) FREE(args);
  }
  return(XEN_FALSE);
}

static XEN gxm_XmDropSiteEndUpdate(XEN arg1)
{
  #define H_XmDropSiteEndUpdate "void XmDropSiteEndUpdate(Widget widget) facilitates processing updates to multiple drop sites"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteEndUpdate", "Widget");
  XmDropSiteEndUpdate(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmDropSiteUpdate(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDropSiteUpdate "void XmDropSiteUpdate(Widget widget, ArgList arglist, Cardinal argcount) sets \
resource values for a drop site"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteUpdate", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmDropSiteUpdate", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmDropSiteUpdate", "int");
  {
    Widget w;
    Arg *args;
    int arglen;
    w = XEN_TO_C_Widget(arg1);
    args = XEN_TO_C_Args(arg2);
    XmDropSiteUpdate(w, args, arglen = XEN_TO_C_INT_DEF(arg3, arg2));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(XEN_FALSE);
}

static XEN gxm_XmDropSiteStartUpdate(XEN arg1)
{
  #define H_XmDropSiteStartUpdate "void XmDropSiteStartUpdate(Widget widget) facilitates processing updates \
to multiple drop sites"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteStartUpdate", "Widget");
  XmDropSiteStartUpdate(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmDropSiteRegistered(XEN arg1)
{
  #define H_XmDropSiteRegistered "Boolean XmDropSiteRegistered(Widget widget) determines if a drop site has been registered"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteRegistered", "Widget");
  return(C_TO_XEN_BOOLEAN(XmDropSiteRegistered(XEN_TO_C_Widget(arg1))));
}
#endif

static XEN gxm_XmDropSiteUnregister(XEN arg1)
{
  #define H_XmDropSiteUnregister "void XmDropSiteUnregister(Widget widget) frees drop site information"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteUnregister", "Widget");
  XmDropSiteUnregister(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmDropSiteRegister(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDropSiteRegister "void XmDropSiteRegister(Widget widget, ArgList arglist, Cardinal argcount) \
identifies a drop site and assigns resources that specify its behavior"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDropSiteRegister", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmDropSiteRegister", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XmDropSiteRegister", "int");
  {
    Widget w;
    Arg *args;
    int arglen;
    w = XEN_TO_C_Widget(arg1);
    args = XEN_TO_C_Args(arg2);
    XmDropSiteRegister(w, args, arglen = XEN_TO_C_INT_DEF(arg3, arg2));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(XEN_FALSE);
}

#if MOTIF_2
static XEN gxm_XmSimpleSpinBoxSetItem(XEN arg1, XEN arg2)
{
  #define H_XmSimpleSpinBoxSetItem "void XmSimpleSpinBoxSetItem(Widget w, XmString item) set an item in the XmSimpleSpinBox list"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSimpleSpinBoxSetItem", "Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmSimpleSpinBoxSetItem", "XmString");
  XmSimpleSpinBoxSetItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmSimpleSpinBoxDeletePos(XEN arg1, XEN arg2)
{
  #define H_XmSimpleSpinBoxDeletePos "void XmSimpleSpinBoxDeletePos(Widget w, int pos) delete a XmSimpleSpinBox item"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSimpleSpinBoxDeletePos", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmSimpleSpinBoxDeletePos", "int");
  XmSimpleSpinBoxDeletePos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmSimpleSpinBoxAddItem(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmSimpleSpinBoxAddItem "void XmSimpleSpinBoxAddItem(Widget w, XmString item, int pos) add an item to the XmSimpleSpinBox"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSimpleSpinBoxAddItem", "Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmSimpleSpinBoxAddItem", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmSimpleSpinBoxAddItem", "int");
  XmSimpleSpinBoxAddItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateSimpleSpinBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSimpleSpinBox "Widget XmCreateSimpleSpinBox(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The SimpleSpinBox widget creation function"
  return(gxm_new_widget("XmCreateSimpleSpinBox", XmCreateSimpleSpinBox, arg1, arg2, arg3, arg4));
}
#endif

static XEN gxm_XmCreateDrawnButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDrawnButton "Widget XmCreateDrawnButton(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The DrawnButton widget creation function"
  return(gxm_new_widget("XmCreateDrawnButton", XmCreateDrawnButton, arg1, arg2, arg3, arg4));
}

#if MOTIF_2
static XEN gxm_XmSpinBoxValidatePosition(XEN arg1)
{
  #define H_XmSpinBoxValidatePosition "int XmSpinBoxValidatePosition(Widget textfield) translate the current value of \
the specified XmSpinBox child into a valid position"
  /* DIFF: XmSpinBoxValidatePosition omits arg2, returns pos
   */
  int pos;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSpinBoxValidatePosition", "Widget");
  XmSpinBoxValidatePosition(XEN_TO_C_Widget(arg1), &pos);
  return(C_TO_XEN_INT(pos));
}

static XEN gxm_XmCreateSpinBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSpinBox "The SpinBox creation function"
  return(gxm_new_widget("XmCreateSpinBox", XmCreateSpinBox, arg1, arg2, arg3, arg4));
}
#endif

static XEN gxm_XmCreateDrawingArea(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDrawingArea "Widget XmCreateDrawingArea(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The DrawingArea widget creation function"
  return(gxm_new_widget("XmCreateDrawingArea", XmCreateDrawingArea, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSeparator(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSeparator "Widget XmCreateSeparator(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Separator widget creation function"
  return(gxm_new_widget("XmCreateSeparator", XmCreateSeparator, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateDragIcon(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDragIcon "Widget XmCreateDragIcon(Widget widget, String name, ArgList arglist, Cardinal argcount) \
creates a DragIcon widget"
  return(gxm_new_widget("XmCreateDragIcon", XmCreateDragIcon, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSeparatorGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSeparatorGadget "Widget XmCreateSeparatorGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The SeparatorGadget creation function"
  return(gxm_new_widget("XmCreateSeparatorGadget", XmCreateSeparatorGadget, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmTargetsAreCompatible(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmTargetsAreCompatible "Boolean XmTargetsAreCompatible(Display *display, Atom *export_targets, Cardinal num_export_targets, \
Atom *import_targets, Cardinal num_import_targets)  tests whether the target types match between a drop site and source object"
  /* DIFF: XmTargetsAreCompatible arg2 and arg4 are lists of Atoms
   */
  Atom *outs, *ins;
  int val, len1, len2;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmTargetsAreCompatible", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmTargetsAreCompatible", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmTargetsAreCompatible", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmTargetsAreCompatible", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmTargetsAreCompatible", "int");
  len1 = XEN_TO_C_INT(arg3);
  outs = XEN_TO_C_Atoms(arg2, len1);
  len2 = XEN_TO_C_INT(arg5);
  ins = XEN_TO_C_Atoms(arg4, len2);
  val = XmTargetsAreCompatible(XEN_TO_C_Display(arg1), outs, len1, ins, len2);
  FREE(outs);
  FREE(ins);
  return(C_TO_XEN_BOOLEAN(val));
}

static XEN gxm_XmDragCancel(XEN arg1)
{
  #define H_XmDragCancel "void XmDragCancel(Widget dragcontext) terminates a drag transaction"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDragCancel", "Widget");
  XmDragCancel(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmDragStart(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmDragStart "Widget XmDragStart(Widget widget, XEvent *event, ArgList arglist, Cardinal argcount) \
initiates a drag and drop transaction"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDragStart", "Widget");
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg2), arg2, 2, "XmDragStart", "XEvent*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmDragStart", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmDragStart", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg3);
    w = XmDragStart(XEN_TO_C_Widget(arg1), 
		    XEN_TO_C_XEvent(arg2), 
		    args, arglen = XEN_TO_C_INT_DEF(arg4, arg3));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XmCreatePromptDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePromptDialog "Widget XmCreatePromptDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The SelectionBox PromptDialog creation function"
  return(gxm_new_widget("XmCreatePromptDialog", XmCreatePromptDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSelectionDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSelectionDialog "Widget XmCreateSelectionDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The SelectionBox SelectionDialog creation function"
  return(gxm_new_widget("XmCreateSelectionDialog", XmCreateSelectionDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateSelectionBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateSelectionBox "Widget XmCreateSelectionBox(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The SelectionBox widget creation function"
  return(gxm_new_widget("XmCreateSelectionBox", XmCreateSelectionBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmSelectionBoxGetChild(XEN arg1, XEN arg2)
{
  #define H_XmSelectionBoxGetChild "Widget XmSelectionBoxGetChild(Widget widget, unsigned char child) used to access a SelectionBox component"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSelectionBoxGetChild", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmSelectionBoxGetChild", "unsigned int");
  return(C_TO_XEN_Widget(XmSelectionBoxGetChild(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XmGetXmDisplay(XEN arg1)
{
  #define H_XmGetXmDisplay "Widget XmGetXmDisplay(Display *display) A Display function that returns the"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmGetXmDisplay", "Display*");
  return(C_TO_XEN_Widget(XmGetXmDisplay(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XmGetDragContext(XEN arg1, XEN arg2)
{
  #define H_XmGetDragContext "Widget XmGetDragContext(Widget refwidget, Time timestamp) retrieves \
the DragContext widget ID associated with a timestamp"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetDragContext", "Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmGetDragContext", "Time");
  return(C_TO_XEN_Widget(XmGetDragContext(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmScrollVisible(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmScrollVisible "void XmScrollVisible(Widget scrollw_widget, Widget widget, Dimension left_right_margin, Dimension top_bottom_margin) \
makes an invisible  descendant of a ScrolledWindow work area visible"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmScrollVisible", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmScrollVisible", "Widget");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg3), arg3, 3, "XmScrollVisible", "Dimension");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg4), arg4, 4, "XmScrollVisible", "Dimension");
  XmScrollVisible(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2), 
		  XEN_TO_C_Dimension(arg3), XEN_TO_C_Dimension(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateScrolledWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateScrolledWindow "Widget XmCreateScrolledWindow(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ScrolledWindow widget creation function"
  return(gxm_new_widget("XmCreateScrolledWindow", XmCreateScrolledWindow, arg1, arg2, arg3, arg4));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmScrolledWindowSetAreas(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmScrolledWindowSetAreas "void XmScrolledWindowSetAreas(Widget widget, Widget horizontal_scrollbar, Widget vertical_scrollbar, \
Widget work_region) adds or changes a window work region and a horizontal or vertical \
ScrollBar widget to the ScrolledWindow widget"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmScrolledWindowSetAreas", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmScrolledWindowSetAreas", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XmScrolledWindowSetAreas", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg4), arg4, 4, "XmScrolledWindowSetAreas", "Widget");
  XmScrolledWindowSetAreas(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2), 
			   XEN_TO_C_Widget(arg3), XEN_TO_C_Widget(arg4));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmCreateDialogShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDialogShell "Widget XmCreateDialogShell(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The DialogShell widget creation function"
  return(gxm_new_widget("XmCreateDialogShell", XmCreateDialogShell, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmScrollBarSetValues(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XmScrollBarSetValues "void XmScrollBarSetValues (widget, value, slider_size, increment, page_increment, notify) \
changes ScrollBar's increment values and the slider's size and position"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmScrollBarSetValues", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmScrollBarSetValues", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmScrollBarSetValues", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmScrollBarSetValues", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XmScrollBarSetValues", "int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg6), arg6, 6, "XmScrollBarSetValues", "boolean");
  XmScrollBarSetValues(XEN_TO_C_Widget(arg1), 
		       XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), 
		       XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
		       XEN_TO_C_BOOLEAN(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XmScrollBarGetValues(XEN arg1)
{
  #define H_XmScrollBarGetValues "void XmScrollBarGetValues (widget) returns the ScrollBar's increment values (list val size incr page)"
  /* DIFF: XmScrollBarGetValues omits and returns last 4 args
   */
  int val, size, incr, page;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmScrollBarGetValues", "Widget");
  XmScrollBarGetValues(XEN_TO_C_Widget(arg1), &val, &size, &incr, &page);
  return(XEN_LIST_4(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(size),
		    C_TO_XEN_INT(incr),
		    C_TO_XEN_INT(page)));
}

static XEN gxm_XmCreateScrollBar(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateScrollBar "Widget XmCreateScrollBar(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ScrollBar widget creation function"
  return(gxm_new_widget("XmCreateScrollBar", XmCreateScrollBar, arg1, arg2, arg3, arg4));
}

#if MOTIF_2
static XEN gxm_XmGetXmScreen(XEN arg1)
{
  #define H_XmGetXmScreen "Widget XmGetXmScreen(Screen *screen) returns the XmScreen object ID for a specified screen"
  /* this is the Motif Screen "widget" */
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XmGetXmScreen", "Screen*");
  return(C_TO_XEN_Widget(XmGetXmScreen(XEN_TO_C_Screen(arg1))));
}
#endif

static XEN gxm_XmClipboardRegisterFormat(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardRegisterFormat "int XmClipboardRegisterFormat (display, format_name, format_length) registers a new format"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardRegisterFormat", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmClipboardRegisterFormat", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardRegisterFormat", "int");
  return(C_TO_XEN_INT(XmClipboardRegisterFormat(XEN_TO_C_Display(arg1), 
						XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmClipboardInquirePendingItems(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardInquirePendingItems "int XmClipboardInquirePendingItems (display, window, format_name) \
returns a list of data ID/private ID pairs"
  /* DIFF: XmClipboardInquirePendingItems omits last 2 args, returns list of pairs
   */
  unsigned long len;
  XmClipboardPendingList clst;
  int i, loc, rtn;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardInquirePendingItems", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardInquirePendingItems", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmClipboardInquirePendingItems", "char*");
  rtn = XmClipboardInquirePendingItems(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Window(arg2), 
				       XEN_TO_C_STRING(arg3), 
				       &clst,
				       &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(XEN_LIST_2(C_TO_XEN_INT(clst[i].DataId), 
			      C_TO_XEN_INT(clst[i].PrivateId)),
		   lst);
  lst = XEN_CONS(C_TO_XEN_INT(rtn), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XmClipboardInquireLength(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardInquireLength "int XmClipboardInquireLength (display, window, format_name) returns the length of the stored data"
  /* DIFF: XmClipboardInquireLength omit and rtn last arg
   */
  unsigned long len;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardInquireLength", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardInquireLength", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmClipboardInquireLength", "char*");
  val = XmClipboardInquireLength(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_STRING(arg3), &len);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(len)));
}

static XEN gxm_XmClipboardInquireFormat(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmClipboardInquireFormat "int XmClipboardInquireFormat (display, window, index, buffer_len) \
returns a specified format name"
  /* DIFF: XmClipboardInquireFormat omits arg4 (XtPointer buffer) and arg6, returns them
   */
  XtPointer buf;
  unsigned long len, n;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardInquireFormat", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardInquireFormat", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardInquireFormat", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XmClipboardInquireFormat", "ulong");
  len = XEN_TO_C_ULONG(arg4);
  if (len == 0) return(XEN_FALSE);
  buf = (XtPointer)MALLOC(len);
  val = XmClipboardInquireFormat(XEN_TO_C_Display(arg1), 
				 XEN_TO_C_Window(arg2), 
				 XEN_TO_C_INT(arg3), 
				 buf, len, &n);
  FREE(buf);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_STRING((char *)buf)));
}

static XEN gxm_XmClipboardInquireCount(XEN arg1, XEN arg2)
{
  #define H_XmClipboardInquireCount "int XmClipboardInquireCount (display, window) returns the number of data item formats"
  /* DIFF: XmClipboardInquireCount omits and rtns last 2 args
   */
  int count, val;
  unsigned long len;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardInquireCount", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardInquireCount", "Window");
  val = XmClipboardInquireCount(XEN_TO_C_Display(arg1), 
				XEN_TO_C_Window(arg2),
				&count, &len);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(count),
		    C_TO_XEN_ULONG(len)));
}

static XEN gxm_XmClipboardRetrieve(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmClipboardRetrieve "int XmClipboardRetrieve (display, window, format_name, length) retrieves a data item from the clipboard"
  /* DIFF: XmClipboardRetrieve omits buf arg, and last 2, returning them and a list of ulongs
   */
  unsigned long n;
  long id;
  XtPointer buf;
  int len, val;
  XEN str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardRetrieve", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardRetrieve", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmClipboardRetrieve", "char*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XmClipboardRetrieve", "ulong");
  len = XEN_TO_C_ULONG(arg4);
  if (len <= 0) return(XEN_FALSE);
  buf = (XtPointer)MALLOC(len);
  val = XmClipboardRetrieve(XEN_TO_C_Display(arg1), 
			    XEN_TO_C_Window(arg2), 
			    XEN_TO_C_STRING(arg3), 
			    buf, len, &n, &id);
  str = C_TO_XEN_STRING((char *)buf);
  FREE(buf);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    str,
		    C_TO_XEN_ULONG(id)));
}

static XEN gxm_XmClipboardEndRetrieve(XEN arg1, XEN arg2)
{
  #define H_XmClipboardEndRetrieve "int XmClipboardEndRetrieve (display, window) completes retrieval of \
data from the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardEndRetrieve", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardEndRetrieve", "Window");
  return(C_TO_XEN_INT(XmClipboardEndRetrieve(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XmClipboardStartRetrieve(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardStartRetrieve "int XmClipboardStartRetrieve (display, window, timestamp) \
prepares to retrieve data from the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardStartRetrieve", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardStartRetrieve", "Window");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XmClipboardStartRetrieve", "Time");
  return(C_TO_XEN_INT(XmClipboardStartRetrieve(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Time(arg3))));
}

static XEN gxm_XmClipboardUnlock(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardUnlock "int XmClipboardUnlock (display, window, remove_all_locks) unlocks the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardUnlock", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardUnlock", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardUnlock", "int");
  return(C_TO_XEN_INT(XmClipboardUnlock(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmClipboardLock(XEN arg1, XEN arg2)
{
  #define H_XmClipboardLock "int XmClipboardLock (display, window) locks the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardLock", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardLock", "Window");
  return(C_TO_XEN_INT(XmClipboardLock(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XmClipboardUndoCopy(XEN arg1, XEN arg2)
{
  #define H_XmClipboardUndoCopy "int XmClipboardUndoCopy (display, window) deletes the last item placed on the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardUndoCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardUndoCopy", "Window");
  return(C_TO_XEN_INT(XmClipboardUndoCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XmClipboardCopyByName(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XmClipboardCopyByName "int XmClipboardCopyByName (display, window, data_id,  buf, len, id) copies a data item passed by name"
  /* DIFF: XmClipboardCopyByName arg4 is string
   */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardCopyByName", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardCopyByName", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardCopyByName", "long");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmClipboardCopyByName", "XtPointer");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XmClipboardCopyByName", "ulong");
  return(C_TO_XEN_INT(XmClipboardCopyByName(XEN_TO_C_Display(arg1), 
					    XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), 
					    (XtPointer)XEN_TO_C_STRING(arg4), 
					    XEN_TO_C_ULONG(arg5), 
					    (unsigned long)arg6)));
}

static XEN gxm_XmClipboardWithdrawFormat(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardWithdrawFormat "int XmClipboardWithdrawFormat (display, window, data_id) \
indicates that the application no longer wants to supply a data item"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardWithdrawFormat", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardWithdrawFormat", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardWithdrawFormat", "long");
  return(C_TO_XEN_INT(XmClipboardWithdrawFormat(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmClipboardCancelCopy(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardCancelCopy "int XmClipboardCancelCopy (display, window, item_id) cancels a copy to the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardCancelCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardCancelCopy", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardCancelCopy", "long");
  return(C_TO_XEN_INT(XmClipboardCancelCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmClipboardEndCopy(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmClipboardEndCopy "int XmClipboardEndCopy (display, window, item_id) completes the \
copying of data to the clipboard"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardEndCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardEndCopy", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardEndCopy", "long");
  return(C_TO_XEN_INT(XmClipboardEndCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XmClipboardCopy(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmClipboardCopy "int XmClipboardCopy (display, window, item_id, format_name, buffer, len, id) copies a data item \
to temporary storage for later copying to clipboard"
  /* DIFF: XmClipboardCopy omits and returns last arg, arg5 is string
   */
  long id;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardCopy", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmClipboardCopy", "long");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XmClipboardCopy", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XmClipboardCopy", "XtPointer");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XmClipboardCopy", "ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XmClipboardCopy", "long");
  val = XmClipboardCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			XEN_TO_C_INT(arg3), XEN_TO_C_STRING(arg4), 
			(XtPointer)XEN_TO_C_STRING(arg5), XEN_TO_C_ULONG(arg6), 
			XEN_TO_C_INT(arg7), &id);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(id)));
}

/* There's just one clipboard, I think, so these callbacks must be globals */
static XEN xm_XmCutPasteProc = XEN_FALSE;

static void gxm_XmCutPasteProc(Widget w, long *data, long *privater, int *reason)
{
  XEN_CALL_4(xm_XmCutPasteProc, 
	     C_TO_XEN_Widget(w),
	     C_TO_XEN_ULONG(*data),
	     C_TO_XEN_ULONG(*privater),
	     C_TO_XEN_INT(*reason),
	     __FUNCTION__);
}

static XEN gxm_XmClipboardStartCopy(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XmClipboardStartCopy "int XmClipboardStartCopy (display, window, clip_label, timestamp, widget, callback) \
sets up a storage and data structure, returns id"
  /* DIFF: XmClipboardStartCopy omits and returns last arg
   */
  long id;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardStartCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardStartCopy", "Window");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg3), arg3, 3, "XmClipboardStartCopy", "XmString");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XmClipboardStartCopy", "Time");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg5), arg5, 5, "XmClipboardStartCopy", "Widget");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg6) && (XEN_REQUIRED_ARGS(arg6) == 4), arg6, 6, "XmClipboardStartCopy", "(XmCutPasteProc widget data priv reason)");
  xm_protect(arg6);
  if (XEN_PROCEDURE_P(xm_XmCutPasteProc)) xm_unprotect(xm_XmCutPasteProc);
  xm_XmCutPasteProc = arg6;
  val = XmClipboardStartCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_XmString(arg3), 
			     XEN_TO_C_Time(arg4), XEN_TO_C_Widget(arg5), (XmCutPasteProc)gxm_XmCutPasteProc, &id);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(id)));
}

static XEN xm_XmVoidProc = XEN_FALSE;
static void gxm_XmVoidProc(Widget w, int *data, int *privater, int *reason)
{
  XEN_CALL_4(xm_XmVoidProc, 
	     C_TO_XEN_Widget(w),
	     C_TO_XEN_ULONG(*data),
	     C_TO_XEN_ULONG(*privater),
	     C_TO_XEN_INT(*reason),
	     __FUNCTION__);
}

static XEN gxm_XmClipboardBeginCopy(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmClipboardBeginCopy "int XmClipboardBeginCopy(display, window, XmString label, widget, callback)"
  /* DIFF: XmClipboardBeinCopy omits and returns last arg
   */
  long id;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmClipboardBeginCopy", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XmClipboardBeginCopy", "Window");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg3), arg3, 3, "XmClipboardBeginCopy", "XmString");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg4), arg4, 4, "XmClipboardBeginCopy", "Widget");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg5) && (XEN_REQUIRED_ARGS(arg5) == 4), arg5, 5, "XmClipboardBeginCopy", "(XmVoidProc widget data priv reason)");
  xm_protect(arg5);
  if (XEN_PROCEDURE_P(xm_XmVoidProc)) xm_unprotect(xm_XmVoidProc);
  xm_XmVoidProc = arg5;
  val = XmClipboardBeginCopy(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			     XEN_TO_C_XmString(arg3), XEN_TO_C_Widget(arg4), 
			     gxm_XmVoidProc, &id);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(id)));
}

#define XEN_ScaleWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsScale(XEN_TO_C_Widget(Arg)))

#if MOTIF_2
static XEN gxm_XmScaleSetTicks(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmScaleSetTicks "void XmScaleSetTicks(Widget scale, int big_every, Cardinal num_medium, Cardinal num_small, Dimension size_big, \
Dimension size_medium, Dimension size_small) controls Scale tick marks"
  XEN_ASSERT_TYPE(XEN_ScaleWidget_P(arg1), arg1, 1, "XmScaleSetTicks", "Scale Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmScaleSetTicks", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmScaleSetTicks", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XmScaleSetTicks", "int");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg5), arg5, 5, "XmScaleSetTicks", "Dimension");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg6), arg6, 6, "XmScaleSetTicks", "Dimension");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg7), arg7, 7, "XmScaleSetTicks", "Dimension");
  XmScaleSetTicks(XEN_TO_C_Widget(arg1), 
		  XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
		  XEN_TO_C_Dimension(arg5), XEN_TO_C_Dimension(arg6), XEN_TO_C_Dimension(arg7));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmCreateScale(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateScale "Widget XmCreateScale(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Scale widget creation function"
  return(gxm_new_widget("XmCreateScale", XmCreateScale, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmScaleGetValue(XEN arg1)
{
  #define H_XmScaleGetValue "void XmScaleGetValue(Widget widget) returns the current (scale) slider position"
  /* DIFF: XmScaleGetValue omits and returns arg2
   */
  int val;
  XEN_ASSERT_TYPE(XEN_ScaleWidget_P(arg1), arg1, 1, "XmScaleGetValue", "Scale Widget");
  XmScaleGetValue(XEN_TO_C_Widget(arg1), &val);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XmScaleSetValue(XEN arg1, XEN arg2)
{
  #define H_XmScaleSetValue "void XmScaleSetValue(Widget widget, int value) sets a Scale slider value"
  XEN_ASSERT_TYPE(XEN_ScaleWidget_P(arg1), arg1, 1, "XmScaleSetValue", "Scale Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmScaleSetValue", "int");
  XmScaleSetValue(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

#define XEN_ContainerWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsContainer(XEN_TO_C_Widget(Arg)))

#if MOTIF_2
static XEN gxm_XmContainerPasteLink(XEN arg1)
{
  #define H_XmContainerPasteLink "Boolean XmContainerPasteLink(Widget container) container function to insert links from the clipboard"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerPasteLink", "Container Widget");
  return(C_TO_XEN_BOOLEAN(XmContainerPasteLink(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmContainerCopyLink(XEN arg1, XEN arg2)
{
  #define H_XmContainerCopyLink "Boolean XmContainerCopyLink(Widget container, Time timestamp) Container function to copy links to the clipboard"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerCopyLink", "Container Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmContainerCopyLink", "Time");
  return(C_TO_XEN_BOOLEAN(XmContainerCopyLink(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmContainerPaste(XEN arg1)
{
  #define H_XmContainerPaste "Boolean XmContainerPaste(Widget container) Container function to insert items from the clipboard"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerPaste", "Container Widget");
  return(C_TO_XEN_BOOLEAN(XmContainerPaste(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmContainerCopy(XEN arg1, XEN arg2)
{
  #define H_XmContainerCopy "Boolean XmContainerCopy(Widget container, Time timestamp) Container function to copy primary selection to the clipboard"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerCopy", "Container Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmContainerCopy", "Time");
  return(C_TO_XEN_BOOLEAN(XmContainerCopy(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmContainerCut(XEN arg1, XEN arg2)
{
  #define H_XmContainerCut "Boolean XmContainerCut(Widget container, Time timestamp) Container function to move items to the clipboard"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerCut", "Container Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XmContainerCut", "Time");
  return(C_TO_XEN_BOOLEAN(XmContainerCut(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XmContainerReorder(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmContainerReorder "void XmContainerReorder(Widget container, WidgetList widgets, int num_widgets) Container function to reorder children"
  /* DIFF: XmContainerReorder arg2 is list of Widgets
   */
  WidgetList ws;
  int len;
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerReorder", "Container Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XmContainerReorder", "WidgetList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmContainerReorder", "int");
  len = XEN_TO_C_INT(arg3);
  if (len > 0)
    {
      ws = XEN_TO_C_Widgets(arg2, len);
      XmContainerReorder(XEN_TO_C_Widget(arg1), ws, len);
      if (ws) FREE(ws);
    }
  return(XEN_FALSE);
}

static XEN gxm_XmContainerRelayout(XEN arg1)
{
  #define H_XmContainerRelayout "void XmContainerRelayout(Widget container) Container relayout function"
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerRelayout", "Container Widget");
  XmContainerRelayout(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmContainerGetItemChildren(XEN arg1, XEN arg2)
{
  #define H_XmContainerGetItemChildren "int XmContainerGetItemChildren(Widget container, Widget item) \
returns a list of all children of an item"
  /* DIFF: XmContainerGetItemChildren omits arg3, rtns widget list
   */
  Widget *ws;
  int len;
  XEN_ASSERT_TYPE(XEN_ContainerWidget_P(arg1), arg1, 1, "XmContainerGetItemChildren", "Container Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmContainerGetItemChildren", "Widget");
  len = XmContainerGetItemChildren(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2), &ws);
  return(C_TO_XEN_Widgets(ws, len));
}

static XEN gxm_XmCreateContainer(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateContainer "Widget XmCreateContainer(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Container creation function"
  return(gxm_new_widget("XmCreateContainer", XmCreateContainer, arg1, arg2, arg3, arg4));
}
#endif

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XmRemoveFromPostFromList(XEN arg1, XEN arg2)
{
  #define H_XmRemoveFromPostFromList "void XmRemoveFromPostFromList(Widget menu, Widget post_from_widget) \
disables a menu for a particular widget"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRemoveFromPostFromList", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmRemoveFromPostFromList", "Widget");
  XmRemoveFromPostFromList(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmAddToPostFromList(XEN arg1, XEN arg2)
{
  #define H_XmAddToPostFromList "void XmAddToPostFromList(Widget menu, Widget post_from_widget) \
makes a menu accessible from more than one widget"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmAddToPostFromList", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmAddToPostFromList", "Widget");
  XmAddToPostFromList(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XmGetTearOffControl(XEN arg1)
{
  #define H_XmGetTearOffControl "Widget XmGetTearOffControl(Widget menu) obtains the widget ID for the tear-off control in a menu"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetTearOffControl", "Widget");
  return(C_TO_XEN_Widget(XmGetTearOffControl(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmGetPostedFromWidget(XEN arg1)
{
  #define H_XmGetPostedFromWidget "Widget XmGetPostedFromWidget(Widget menu) returns the widget from which a menu was posted"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmGetPostedFromWidget", "Widget");
  return(C_TO_XEN_Widget(XmGetPostedFromWidget(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmCreatePulldownMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePulldownMenu "Widget XmCreatePulldownMenu(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A RowColumn widget creation function"
  return(gxm_new_widget("XmCreatePulldownMenu", XmCreatePulldownMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreatePopupMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePopupMenu "Widget XmCreatePopupMenu(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A RowColumn widget creation function"
  return(gxm_new_widget("XmCreatePopupMenu", XmCreatePopupMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateMenuBar(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateMenuBar "Widget XmCreateMenuBar(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A RowColumn widget creation function"
  return(gxm_new_widget("XmCreateMenuBar", XmCreateMenuBar, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmOptionButtonGadget(XEN arg1)
{
  #define H_XmOptionButtonGadget "Widget XmOptionButtonGadget(Widget option_menu) obtains \
the widget ID for the CascadeButtonGadget in an OptionMenu"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmOptionButtonGadget", "Widget");
  return(C_TO_XEN_Widget(XmOptionButtonGadget(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmOptionLabelGadget(XEN arg1)
{
  #define H_XmOptionLabelGadget "Widget XmOptionLabelGadget(Widget option_menu) obtains the \
widget ID for the LabelGadget in an OptionMenu"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmOptionLabelGadget", "Widget");
  return(C_TO_XEN_Widget(XmOptionLabelGadget(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XmCreateOptionMenu(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateOptionMenu "Widget XmCreateOptionMenu(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A RowColumn widget creation function"
  return(gxm_new_widget("XmCreateOptionMenu", XmCreateOptionMenu, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateRadioBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateRadioBox "Widget XmCreateRadioBox(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A RowColumn widget creation function"
  return(gxm_new_widget("XmCreateRadioBox", XmCreateRadioBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateWorkArea(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateWorkArea "Widget XmCreateWorkArea(Widget parent, String name, ArgList arglist, Cardinal argcount) \
creates a RowColumn WorkArea"
  return(gxm_new_widget("XmCreateWorkArea", XmCreateWorkArea, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateRowColumn(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateRowColumn "Widget XmCreateRowColumn(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The RowColumn widget creation function"
  return(gxm_new_widget("XmCreateRowColumn", XmCreateRowColumn, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmMenuPosition(XEN arg1, XEN arg2)
{
  #define H_XmMenuPosition "void XmMenuPosition(Widget menu, XButtonPressedEvent * event) positions a Popup menu pane"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmMenuPosition", "Widget");
  XEN_ASSERT_TYPE(XEN_XButtonEvent_P(arg2), arg2, 2, "XmMenuPosition", "XButtonPressedEvent*");
  XmMenuPosition(XEN_TO_C_Widget(arg1), XEN_TO_C_XButtonEvent(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateCommandDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateCommandDialog "Widget XmCreateCommandDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Command CommandDialog creation function"
  return(gxm_new_widget("XmCreateCommandDialog", XmCreateCommandDialog, arg1, arg2, arg3, arg4));
}

#define XEN_CommandWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsCommand(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmCommandError(XEN arg1, XEN arg2)
{
  #define H_XmCommandError "void XmCommandError(Widget widget, XmString error) Command function that displays an error message"
  XEN_ASSERT_TYPE(XEN_CommandWidget_P(arg1), arg1, 1, "XmCommandError", "Command Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmCommandError", "XmString");
  XmCommandError(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCommandAppendValue(XEN arg1, XEN arg2)
{
  #define H_XmCommandAppendValue "void XmCommandAppendValue(Widget widget, XmString command) \
appends the passed XmString to the end of the string displayed in the command area of the widget"
  XEN_ASSERT_TYPE(XEN_CommandWidget_P(arg1), arg1, 1, "XmCommandAppendValue", "Command Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmCommandAppendValue", "XmString");
  XmCommandAppendValue(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCommandSetValue(XEN arg1, XEN arg2)
{
  #define H_XmCommandSetValue "void XmCommandSetValue(Widget widget, XmString command) A Command function that replaces a displayed string"
  XEN_ASSERT_TYPE(XEN_CommandWidget_P(arg1), arg1, 1, "XmCommandSetValue", "Command Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmCommandSetValue", "XmString");
  XmCommandSetValue(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCommandGetChild(XEN arg1, XEN arg2)
{
  #define H_XmCommandGetChild "Widget XmCommandGetChild(Widget widget, unsigned char child) A Command function that is used to access a component"
  XEN_ASSERT_TYPE(XEN_CommandWidget_P(arg1), arg1, 1, "XmCommandGetChild", "Command Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmCommandGetChild", "unsigned int");
  return(C_TO_XEN_Widget(XmCommandGetChild(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XmCreateCommand(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateCommand "Widget XmCreateCommand(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The Command widget creation function"
  return(gxm_new_widget("XmCreateCommand", XmCreateCommand, arg1, arg2, arg3, arg4));
}

#if MOTIF_2

#define XEN_ComboBoxWidget_P(Arg) (XEN_Widget_P(Arg) && XmIsComboBox(XEN_TO_C_Widget(Arg)))

static XEN gxm_XmComboBoxUpdate(XEN arg1)
{
  #define H_XmComboBoxUpdate "void XmComboBoxUpdate(Widget widget) A ComboBox function that resynchronizes data"
  XEN_ASSERT_TYPE(XEN_ComboBoxWidget_P(arg1), arg1, 1, "XmComboBoxUpdate", "ComboBox Widget");
  XmComboBoxUpdate(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmComboBoxSetItem(XEN arg1, XEN arg2)
{
  #define H_XmComboBoxSetItem "void XmComboBoxSetItem(Widget w, XmString item) set an item in the XmComboBox list"
  XEN_ASSERT_TYPE(XEN_ComboBoxWidget_P(arg1), arg1, 1, "XmComboBoxSetItem", "ComboBox Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmComboBoxSetItem", "XmString");
  XmComboBoxSetItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmComboBoxSelectItem(XEN arg1, XEN arg2)
{
  #define H_XmComboBoxSelectItem "void XmComboBoxSelectItem(Widget w, XmString item) select a XmComboBox item"
  XEN_ASSERT_TYPE(XEN_ComboBoxWidget_P(arg1), arg1, 1, "XmComboBoxSelectItem", "ComboBox Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmComboBoxSelectItem", "XmString");
  XmComboBoxSelectItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmComboBoxDeletePos(XEN arg1, XEN arg2)
{
  #define H_XmComboBoxDeletePos "void XmComboBoxDeletePos(Widget w, int pos)  Delete a XmComboBox item"
  XEN_ASSERT_TYPE(XEN_ComboBoxWidget_P(arg1), arg1, 1, "XmComboBoxDeletePos", "ComboBox Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmComboBoxDeletePos", "int");
  XmComboBoxDeletePos(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmComboBoxAddItem(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmComboBoxAddItem "void XmComboBoxAddItem(Widget w, XmString item, int pos, Boolean unique) add an item to the ComboBox widget"
  XEN_ASSERT_TYPE(XEN_ComboBoxWidget_P(arg1), arg1, 1, "XmComboBoxAddItem", "ComboBox Widget");
  XEN_ASSERT_TYPE(XEN_XmString_P(arg2), arg2, 2, "XmComboBoxAddItem", "XmString");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XmComboBoxAddItem", "int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg4), arg4, 4, "XmComboBoxAddItem", "Boolean");
  XmComboBoxAddItem(XEN_TO_C_Widget(arg1), XEN_TO_C_XmString(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_BOOLEAN(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateDropDownList(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDropDownList "Widget XmCreateDropDownList(Widget parent, String name, ArgList arglist, Cardinal arg_count) \
The Drop-down list ComboBox widget creation function"
  return(gxm_new_widget("XmCreateDropDownList", XmCreateDropDownList, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateDropDownComboBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateDropDownComboBox "Widget XmCreateDropDownComboBox(Widget parent, String name, ArgList arglist, Cardinal arg_count) \
The Drop-down ComboBox widget creation function"
  return(gxm_new_widget("XmCreateDropDownComboBox", XmCreateDropDownComboBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateComboBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateComboBox "Widget XmCreateComboBox(Widget parent, String name, ArgList arglist, Cardinal arg_count) \
The default ComboBox widget creation function"
  return(gxm_new_widget("XmCreateComboBox", XmCreateComboBox, arg1, arg2, arg3, arg4));
}
#endif

static XEN gxm_XmCreatePushButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePushButton "Widget XmCreatePushButton(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The PushButton widget creation function"
  return(gxm_new_widget("XmCreatePushButton", XmCreatePushButton, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreatePushButtonGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePushButtonGadget "Widget XmCreatePushButtonGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The PushButtonGadget creation function"
  return(gxm_new_widget("XmCreatePushButtonGadget", XmCreatePushButtonGadget, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCascadeButtonHighlight(XEN arg1, XEN arg2)
{
  #define H_XmCascadeButtonHighlight "void XmCascadeButtonHighlight(Widget cascadeButton, Boolean highlight) A CascadeButton and \
CascadeButtonGadget function that sets the highlight state"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmCascadeButtonHighlight", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmCascadeButtonHighlight", "boolean");
  XmCascadeButtonHighlight(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateCascadeButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateCascadeButton "Widget XmCreateCascadeButton(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The CascadeButton widget creation function"
  return(gxm_new_widget("XmCreateCascadeButton", XmCreateCascadeButton, arg1, arg2, arg3, arg4));
}

static void gxm_ProtocolProc(Widget w, XtPointer context, XtPointer info)
{
  XEN descr = (XEN)context;
  XEN_CALL_3(XEN_CADR(descr),
	     C_TO_XEN_Widget(w),
	     XEN_CADDR(descr),
	     C_TO_XEN_ULONG(info), /* what's this? */
	     __FUNCTION__);
}

#define C_TO_XEN_XM_ProtocolHook(Code, Context, PropertyAtom, ProtocolAtom) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("ProtocolHook"), Code, Context, PropertyAtom, ProtocolAtom)
#define XM_ProtocolHook_P(Arg) WRAP_P("ProtocolHook", Arg)

#define C_TO_XEN_XM_ProtocolProc(Code, Context, PropertyAtom, ProtocolAtom) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("ProtocolProc"), Code, Context, PropertyAtom, ProtocolAtom)
#define XM_ProtocolProc_P(Arg) WRAP_P("ProtocolProc", Arg)

static XEN gxm_XmSetProtocolHooks(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XmSetProtocolHooks "void XmSetProtocolHooks(Widget shell, Atom property, Atom protocol, XtCallbackProc prehook, \
XtPointer pre_closure, XtCallbackProc posthook, XtPointer post_closure) A VendorShell function that allows preactions and postactions \
to be executed when a protocol message is received from MWM"
  XEN descr1, descr2;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmSetProtocolHooks", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmSetProtocolHooks", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XmSetProtocolHooks", "Atom");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XmSetProtocolHooks", "(XtCallbackProc widget data callb)");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg6) && (XEN_REQUIRED_ARGS(arg6) == 3), arg6, 6, "XmSetProtocolHooks", "(XtCallbackProc widget data callb)");
  descr1 = C_TO_XEN_XM_ProtocolHook(arg4, arg5, arg2, arg3);
  descr2 = C_TO_XEN_XM_ProtocolHook(arg6, arg7, arg2, arg3);
  XmSetProtocolHooks(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Atom(arg3),
		     gxm_ProtocolProc, (XtPointer)descr1,
		     gxm_ProtocolProc, (XtPointer)descr2);
  return(XEN_FALSE);
}

static XEN gxm_XmDeactivateProtocol(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmDeactivateProtocol "void XmDeactivateProtocol(Widget shell, Atom property, Atom protocol) \
deactivates a protocol without removing it"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmDeactivateProtocol", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmDeactivateProtocol", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XmDeactivateProtocol", "Atom");
  XmDeactivateProtocol(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Atom(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XmActivateProtocol(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmActivateProtocol "oid XmActivateProtocol(Widget shell, Atom property, Atom protocol) activates a protocol"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmActivateProtocol", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmActivateProtocol", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XmActivateProtocol", "Atom");
  XmActivateProtocol(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Atom(arg3));
  return(XEN_FALSE);
}

static int unprotect_protocolproc(XEN val, int loc, unsigned long udescr)
{
  XEN descr = (XEN)udescr; /* ('protocolproc func data propatom protoatom) */
  return((XM_ProtocolProc_P(val)) &&
	 (XEN_TO_C_ULONG(XEN_CADR(val)) == XEN_TO_C_ULONG(XEN_CADR(descr))) &&
	 (XEN_TO_C_ULONG(XEN_CADDR(val)) == XEN_TO_C_ULONG(XEN_CADDR(descr))) &&
	 (XEN_TO_C_Atom(XEN_LIST_REF(val, 3)) == XEN_TO_C_Atom(XEN_LIST_REF(val,3))) &&
	 (XEN_TO_C_Atom(XEN_LIST_REF(val, 4)) == XEN_TO_C_Atom(XEN_LIST_REF(val,4))));
}

static XEN gxm_XmRemoveProtocolCallback(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmRemoveProtocolCallback "void XmRemoveProtocolCallback(Widget shell, Atom property, Atom protocol, XtCallbackProc callback, \
XtPointer closure) removes a callback from the internal list"
  XEN descr;
  int loc;
  XEN *velts;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRemoveProtocolCallback", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmRemoveProtocolCallback", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XmRemoveProtocolCallback", "Atom"); 
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XmRemoveProtocolCallback", "XtCallbackProc (3 args)");
  descr = C_TO_XEN_XM_ProtocolProc(arg4, arg5, arg2, arg3);
  xm_protect(descr);
  loc = map_over_protected_elements(unprotect_protocolproc, (unsigned long)descr);
  velts = XEN_VECTOR_ELEMENTS(xm_protected);
  XmRemoveProtocolCallback(XEN_TO_C_Widget(arg1), 
			   XEN_TO_C_Atom(arg2), 
			   XEN_TO_C_Atom(arg3), 
			   gxm_ProtocolProc,
			   (XtPointer)(velts[loc])); /* this was the original tag passed in */
  /* now unprotect the proc and our descr */
  xm_unprotect(descr);
  xm_unprotect_at(loc);
  return(XEN_FALSE);
}

static XEN gxm_XmAddProtocolCallback(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmAddProtocolCallback "void XmAddProtocolCallback(Widget shell, Atom property, Atom protocol, XtCallbackProc callback, \
XtPointer closure) adds client callbacks for a protocol"
  XEN descr;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmAddProtocolCallback", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmAddProtocolCallback", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XmAddProtocolCallback", "Atom");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XmAddProtocolCallback", "(XtCallbackProc widget data callb)");
  descr = C_TO_XEN_XM_ProtocolProc(arg4, arg5, arg2, arg3);
  XmAddProtocolCallback(XEN_TO_C_Widget(arg1), 
			XEN_TO_C_Atom(arg2),
			XEN_TO_C_Atom(arg3),
			gxm_ProtocolProc,
			(XtPointer)descr);
  return(XEN_FALSE);
}

static XEN gxm_XmRemoveProtocols(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmRemoveProtocols "void XmRemoveProtocols(Widget shell, Atom property, Atom * protocols, Cardinal num_protocols) \
removes the protocols from the protocol manager and deallocates the internal tables"
  /* DIFF: XmRemoveProtocols takes list of Atoms
   */
  Atom *outs;
  int len;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRemoveProtocols", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmRemoveProtocols", "Atom");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmRemoveProtocols", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmRemoveProtocols", "int");
  if (XEN_INTEGER_P(arg4)) len = XEN_TO_C_INT(arg4); else len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  XmRemoveProtocols(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), outs, len);
  FREE(outs);
  return(XEN_FALSE);
}

static XEN gxm_XmAddProtocols(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmAddProtocols "void XmAddProtocols(Widget shell, Atom property, Atom *protocols, Cardinal num_protocols) \
adds the protocols to the protocol manager and allocates the internal tables"
  /* DIFF: XmAddProtocols takes list of Atoms
   */
  Atom *outs;
  int len;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmAddProtocols", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmAddProtocols", "Atom");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XmAddProtocols", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XmAddProtocols", "int");
  if (XEN_INTEGER_P(arg4)) len = XEN_TO_C_INT(arg4); else len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  XmAddProtocols(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), outs, len);
  FREE(outs);
  return(XEN_FALSE);
}

static XEN gxm_XmCascadeButtonGadgetHighlight(XEN arg1, XEN arg2)
{
  #define H_XmCascadeButtonGadgetHighlight "void XmCascadeButtonGadgetHighlight(Widget cascadeButtonGadget, Boolean highlight) \
A CascadeButtonGadget function that sets the highlight state"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmCascadeButtonGadgetHighlight", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XmCascadeButtonGadgetHighlight", "boolean");
  XmCascadeButtonGadgetHighlight(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XmCreateCascadeButtonGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateCascadeButtonGadget "Widget XmCreateCascadeButtonGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The CascadeButtonGadget creation function"
  return(gxm_new_widget("XmCreateCascadeButtonGadget", XmCreateCascadeButtonGadget, arg1, arg2, arg3, arg4));
}

#if MOTIF_2 && HAVE_XP
static XEN gxm_XmRedisplayWidget(XEN arg1)
{
  #define H_XmRedisplayWidget "voidXmRedisplayWidget(Widgetwidget) Synchronously activates the expose method of a widget to draw its content"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmRedisplayWidget", "Widget");
  XmRedisplayWidget(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XmPrintPopupPDM(XEN arg1, XEN arg2)
{
  #define H_XmPrintPopupPDM "XtEnum XmPrintPopupPDM(Widgetprint_shell, Widget video_transient_for) Send a notification for the PDM to be popped up"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmPrintPopupPDM", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XmPrintPopupPDM", "Widget");
  return(C_TO_XEN_INT(XmPrintPopupPDM(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2))));
}

static void gxm_XPFinishProc(Display *display, XPContext context, XPGetDocStatus status, XPointer client_data);

static XEN gxm_XmPrintToFile(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmPrintToFile "XtEnumXmPrintToFile(Display*dpy, Stringfilename, XPFinishProcfinish_proc, XtPointerclient_data) \
retrieves and saves data that would normally be printed by the X Print Server"
  XEN descr;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmPrintToFile", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmPrintToFile", "char*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 4), arg3, 3, "XmPrintToFile", "XPFinishProc (4 args)");
  descr = XEN_LIST_3(XEN_FALSE, arg3, arg4);
  xm_protect(descr);
  return(C_TO_XEN_INT(XmPrintToFile(XEN_TO_C_Display(arg1), 
				    XEN_TO_C_STRING(arg2), 
				    (XPFinishProc)gxm_XPFinishProc,
				    (char *)descr)));
}

static XEN gxm_XmPrintSetup(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XmPrintSetup "Widget XmPrintSetup(Widget video_widget, Screen *print_screen, String print_shell_name, ArgList args, Cardinal num_args) \
setup and create a Print Shell widget"
  Widget w;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmPrintSetup", "Widget");
  XEN_ASSERT_TYPE(XEN_Screen_P(arg2), arg2, 2, "XmPrintSetup", "Screen*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XmPrintSetup", "String");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XmPrintSetup", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XmPrintSetup", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg4);
    w = XmPrintSetup(XEN_TO_C_Widget(arg1), 
		     XEN_TO_C_Screen(arg2), 
		     XEN_TO_C_STRING(arg3), 
		     args, arglen = XEN_TO_C_INT_DEF(arg5, arg4));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}
#endif

static XEN gxm_XmCreateBulletinBoardDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateBulletinBoardDialog "Widget XmCreateBulletinBoardDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The BulletinBoard BulletinBoardDialog creation function"
  return(gxm_new_widget("XmCreateBulletinBoardDialog", XmCreateBulletinBoardDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateBulletinBoard(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateBulletinBoard "Widget XmCreateBulletinBoard(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The BulletinBoard widget creation function"
  return(gxm_new_widget("XmCreateBulletinBoard", XmCreateBulletinBoard, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreatePanedWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreatePanedWindow "Widget XmCreatePanedWindow(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The PanedWindow widget creation function"
  return(gxm_new_widget("XmCreatePanedWindow", XmCreatePanedWindow, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmGetAtomName(XEN arg1, XEN arg2)
{
  #define H_XmGetAtomName "String XmGetAtomName(Display * display, Atom atom)  returns the string representation for an atom"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmGetAtomName", "Display*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XmGetAtomName", "Atom");
  return(C_TO_XEN_STRING(XmGetAtomName(XEN_TO_C_Display(arg1), XEN_TO_C_Atom(arg2))));
}

static XEN gxm_XmInternAtom(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XmInternAtom "A macro that returns an atom for a given name"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XmInternAtom", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XmInternAtom", "String");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XmInternAtom", "Boolean");
  return(C_TO_XEN_Atom(XmInternAtom(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_BOOLEAN(arg3))));
}

#if MOTIF_2
static XEN gxm_XmNotebookGetPageInfo(XEN arg1, XEN arg2)
{
  #define H_XmNotebookGetPageInfo "XmNotebookPageStatus XmNotebookGetPageInfo(Widget notebook, int page_number) \
A Notebook function that returns page information"
  XmNotebookPageInfo *info;
  int err;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmNotebookGetPageInfo", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XmNotebookGetPageInfo", "int");
  info = (XmNotebookPageInfo *)CALLOC(1, sizeof(XmNotebookPageInfo));
  err = XmNotebookGetPageInfo(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), info);
  return(XEN_LIST_2(C_TO_XEN_INT(err), C_TO_XEN_XmNotebookPageInfo(info)));
}

static XEN gxm_XmCreateNotebook(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateNotebook "void XmCreateNotebook(Widget parent, String name, ArgList arglist, Cardinal argcount) The Notebook widget creation function"
  return(gxm_new_widget("XmCreateNotebook", XmCreateNotebook, arg1, arg2, arg3, arg4));
}
#endif

static XEN gxm_XmCreateArrowButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateArrowButton "Widget XmCreateArrowButton(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ArrowButton widget creation function"
  return(gxm_new_widget("XmCreateArrowButton", XmCreateArrowButton, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateArrowButtonGadget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateArrowButtonGadget "Widget XmCreateArrowButtonGadget(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The ArrowButtonGadget creation function"
  return(gxm_new_widget("XmCreateArrowButtonGadget", XmCreateArrowButtonGadget, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmMessageBoxGetChild(XEN arg1, XEN arg2)
{
  #define H_XmMessageBoxGetChild "Widget XmMessageBoxGetChild(Widget widget, unsigned char child) A MessageBox function that is used to access a component"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XmMessageBoxGetChild", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XmMessageBoxGetChild", "unsigned int");
  return(C_TO_XEN_Widget(XmMessageBoxGetChild(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XmCreateTemplateDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateTemplateDialog "Widget XmCreateTemplateDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
A MessageBox TemplateDialog creation function"
  return(gxm_new_widget("XmCreateTemplateDialog", XmCreateTemplateDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateWorkingDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateWorkingDialog "Widget XmCreateWorkingDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox WorkingDialog creation function"
  return(gxm_new_widget("XmCreateWorkingDialog", XmCreateWorkingDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateWarningDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateWarningDialog "Widget XmCreateWarningDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox WarningDialog creation function"
  return(gxm_new_widget("XmCreateWarningDialog", XmCreateWarningDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateQuestionDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateQuestionDialog "Widget XmCreateQuestionDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox QuestionDialog creation function"
  return(gxm_new_widget("XmCreateQuestionDialog", XmCreateQuestionDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateInformationDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateInformationDialog "Widget XmCreateInformationDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox InformationDialog creation function"
  return(gxm_new_widget("XmCreateInformationDialog", XmCreateInformationDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateErrorDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateErrorDialog "Widget XmCreateErrorDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox ErrorDialog creation function"
  return(gxm_new_widget("XmCreateErrorDialog", XmCreateErrorDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateMessageDialog(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateMessageDialog "Widget XmCreateMessageDialog(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox MessageDialog creation function"
  return(gxm_new_widget("XmCreateMessageDialog", XmCreateMessageDialog, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmCreateMessageBox(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XmCreateMessageBox "Widget XmCreateMessageBox(Widget parent, String name, ArgList arglist, Cardinal argcount) \
The MessageBox widget creation function"
  return(gxm_new_widget("XmCreateMessageBox", XmCreateMessageBox, arg1, arg2, arg3, arg4));
}

static XEN gxm_XmIsMessageBox(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsMessageBox", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsMessageBox(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsArrowButtonGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsArrowButtonGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsArrowButtonGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsArrowButton(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsArrowButton", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsArrowButton(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsNotebook(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsNotebook", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsNotebook(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsPanedWindow(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsPanedWindow", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsPanedWindow(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsBulletinBoard(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsBulletinBoard", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsBulletinBoard(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsPrimitive(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsPrimitive", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsPrimitive(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2 && HAVE_XP
static XEN gxm_XmIsPrintShell(XEN arg)
{
  #define H_XmIsPrintShell "Boolean XmIsPrintShell(Widget)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsPrintShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsPrintShell(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsCascadeButtonGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsCascadeButtonGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsCascadeButtonGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsCascadeButton(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsCascadeButton", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsCascadeButton(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsPushButtonGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsPushButtonGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsPushButtonGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsPushButton(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsPushButton", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsPushButton(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsComboBox(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsComboBox", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsComboBox(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsCommand(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsCommand", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsCommand(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsRowColumn(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsRowColumn", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsRowColumn(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsContainer(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsContainer", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsContainer(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsScreen", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsScreen(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsScale(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsScale", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsScale(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsScrollBar(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsScrollBar", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsScrollBar(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDialogShell(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDialogShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDialogShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsScrolledWindow(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsScrolledWindow", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsScrolledWindow(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDisplay(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDisplay", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDisplay(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsSelectionBox(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsSelectionBox", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsSelectionBox(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDragContext(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDragContext", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDragContext(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsSeparatorGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsSeparatorGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsSeparatorGadget(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsDragIconObjectClass(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDragIconObjectClass", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDragIconObjectClass(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsSeparator(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsSeparator", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsSeparator(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDrawingArea(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDrawingArea", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDrawingArea(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDrawnButton(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDrawnButton", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDrawnButton(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDropSiteManager(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDropSiteManager", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDropSiteManager(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsDropTransfer(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsDropTransfer", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsDropTransfer(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsTextField(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsTextField", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsTextField(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsFileSelectionBox(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsFileSelectionBox", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsFileSelectionBox(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsText(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsText", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsText(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsForm(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsForm", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsForm(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsFrame(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsFrame", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsFrame(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsToggleButtonGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsToggleButtonGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsToggleButtonGadget(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsGrabShell(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsGrabShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsGrabShell(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsToggleButton(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsToggleButton", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsToggleButton(XEN_TO_C_Widget(arg))));
}

#if MOTIF_2
static XEN gxm_XmIsIconGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsIconGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsIconGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsIconHeader(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsIconHeader", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsIconHeader(XEN_TO_C_Widget(arg))));
}
#endif

static XEN gxm_XmIsLabelGadget(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsLabelGadget", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsLabelGadget(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsLabel(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsLabel", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsLabel(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsVendorShell(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsVendorShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsVendorShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsList(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsList", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsList(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsMainWindow(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsMainWindow", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsMainWindow(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsManager(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsManager", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsManager(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XmIsMenuShell(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XmIsMenuShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XmIsMenuShell(XEN_TO_C_Widget(arg))));
}


#endif
/* end HAVE_MOTIF */

/* ----------------------------------------------------------------------------------------------------
 *
 *                            *         *
 *                             *       *
 *                              *     *
 *                               *   *
 *                                * *
 *                                 *
 *                                * *
 *                               *   *
 *                              *     *
 *                             *       *
 *                            *         *
 * ----------------------------------------------------------------------------------------------------
 */

static XEN gxm_XXorRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XXorRegion "XXorRegion(sra, srb, dr_return) calculates the difference between the union and intersection of two regions."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XXorRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XXorRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XXorRegion", "Region");
  return(C_TO_XEN_INT(XXorRegion(XEN_TO_C_Region(arg1), XEN_TO_C_Region(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XUnionRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XUnionRegion "XUnionRegion(sra, srb, dr_return) computes the union of two regions."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XUnionRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XUnionRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XUnionRegion", "Region");
  return(C_TO_XEN_INT(XUnionRegion(XEN_TO_C_Region(arg1), XEN_TO_C_Region(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XUnionRectWithRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XUnionRectWithRegion "XUnionRectWithRegion(rectangle, src_region, dest_region_return) updates the destination region from a \
union of the specified rectangle and the specified source region."
  XEN_ASSERT_TYPE(XEN_XRectangle_P(arg1), arg1, 1, "XUnionRectWithRegion", "XRectangle*");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XUnionRectWithRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XUnionRectWithRegion", "Region");
  return(C_TO_XEN_INT(XUnionRectWithRegion(XEN_TO_C_XRectangle(arg1), XEN_TO_C_Region(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XSubtractRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSubtractRegion "XSubtractRegion(sra, srb, dr_return) subtracts srb from sra and stores the results in dr_return."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XSubtractRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XSubtractRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XSubtractRegion", "Region");
  return(C_TO_XEN_INT(XSubtractRegion(XEN_TO_C_Region(arg1), XEN_TO_C_Region(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XShrinkRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XShrinkRegion "XShrinkRegion(r, dx, dy) reduces the specified region by a specified amount."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XShrinkRegion", "Region");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XShrinkRegion", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XShrinkRegion", "int");
  return(C_TO_XEN_INT(XShrinkRegion(XEN_TO_C_Region(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetStandardColormap(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetStandardColormap "XSetStandardColormap(dpy, window, colormap, atom) sets the standard colormap property"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetStandardColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetStandardColormap", "Window");
  XEN_ASSERT_TYPE(XEN_XStandardColormap_P(arg3), arg3, 3, "XSetStandardColormap", "XStandardColormap*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg4), arg4, 4, "XSetStandardColormap", "Atom");
  XSetStandardColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_XStandardColormap(arg3), XEN_TO_C_Atom(arg4));
  return(XEN_FALSE);
}

static XEN gxm_XSetRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetRegion "XSetRegion(display, gc, r) sets the clip-mask in the GC to the specified region."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetRegion", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetRegion", "GC");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XSetRegion", "Region");
  return(C_TO_XEN_INT(XSetRegion(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XSetWMHints(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWMHints "XSetWMHints(display, w, wmhints) sets the window manager hints that include icon information and location, the \
initial state of the window, and whether the application relies on the window manager to get keyboard input."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWMHints", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWMHints", "Window");
  XEN_ASSERT_TYPE(XEN_XWMHints_P(arg3), arg3, 3, "XSetWMHints", "XWMHints*");
  return(C_TO_XEN_INT(XSetWMHints(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_XWMHints(arg3))));
}

static XEN gxm_XSetRGBColormaps(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XSetRGBColormaps "void XSetRGBColormaps(display, w, std_colormap, count, property) replaces the RGB colormap definition in the \
specified property on the named window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetRGBColormaps", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetRGBColormaps", "Window");
  XEN_ASSERT_TYPE(XEN_XStandardColormap_P(arg3), arg3, 3, "XSetRGBColormaps", "XStandardColormap*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetRGBColormaps", "int");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg5), arg5, 5, "XSetRGBColormaps", "Atom");
  XSetRGBColormaps(XEN_TO_C_Display(arg1), 
		   XEN_TO_C_Window(arg2), 
		   XEN_TO_C_XStandardColormap(arg3), 
		   XEN_TO_C_INT(arg4), 
		   XEN_TO_C_Atom(arg5));
  return(XEN_FALSE);
}

static XEN gxm_XUniqueContext(void)
{
  #define H_XUniqueContext "XContext XUniqueContext() creates a unique context type that may be used in subsequent calls to XSaveContext."
  return(C_TO_XEN_XContext(XUniqueContext()));
}

static XEN gxm_XSaveContext(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSaveContext "XSaveContext(dpy, rid, context) saves a context"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSaveContext", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XSaveContext", "XID");
  XEN_ASSERT_TYPE(XEN_XContext_P(arg3), arg3, 3, "XSaveContext", "XContext");
  return(C_TO_XEN_INT(XSaveContext(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_XContext(arg3), (caddr_t)arg4)));
}

static XEN gxm_XRectInRegion(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XRectInRegion "int XRectInRegion(r, x, y, width, height) returns RectangleIn if the rectangle is entirely in the specified region, \
RectangleOut if the rectangle is entirely out of the specified region, and RectanglePart if the rectangle is partially in the specified region. "
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XRectInRegion", "Region");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XRectInRegion", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XRectInRegion", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XRectInRegion", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XRectInRegion", "unsigned int");
  return(C_TO_XEN_INT(XRectInRegion(XEN_TO_C_Region(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5))));
}

static XEN gxm_XPolygonRegion(XEN larg1, XEN arg2, XEN arg3)
{
  #define H_XPolygonRegion "Region XPolygonRegion(points, n, fill_rule) returns a region for the polygon defined by the points list."
  /* DIFF: XPolygonRegion XPoint* arg (arg 1) is list of XPoints
   */
  XPoint *pt, *pt1;
  int i, len;
  Region res;
  XEN arg1, xp;
  XEN_ASSERT_TYPE(XEN_LIST_P(larg1), larg1, 1, "XPolygonRegion", "list of XPoints");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XPolygonRegion", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XPolygonRegion", "int");
  arg1 = XEN_COPY_ARG(larg1);
  len = XEN_TO_C_INT(arg2);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg2, 2, "XPolygonRegion", "positive integer");
  pt = (XPoint *)CALLOC(len, sizeof(XPoint));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg1)); i++, arg1 = XEN_CDR(arg1))
    {
      xp = XEN_CAR(arg1);
      if (!(XEN_XPoint_P(xp))) XEN_ASSERT_TYPE(0, xp, i, "XPolygonRegion", "XPoint");
      pt1 = XEN_TO_C_XPoint(XEN_CAR(arg1));
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
    }
  res = XPolygonRegion(pt, len, XEN_TO_C_INT(arg3));
  FREE(pt);
  return(C_TO_XEN_Region(res));
}

static XEN gxm_XPointInRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XPointInRegion "Bool XPointInRegion(r, x, y) returns #t if the point (x, y) is contained in the region r."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XPointInRegion", "Region");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XPointInRegion", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XPointInRegion", "int");
  return(C_TO_XEN_BOOLEAN(XPointInRegion(XEN_TO_C_Region(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XOffsetRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XOffsetRegion "XOffsetRegion(r, dx, dy) moves the specified region by a specified amount."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XOffsetRegion", "Region");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XOffsetRegion", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XOffsetRegion", "int");
  return(C_TO_XEN_INT(XOffsetRegion(XEN_TO_C_Region(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XVisualInfo *match_visual_info;
static XEN gxm_XMatchVisualInfo(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XMatchVisualInfo "Status XMatchVisualInfo(display, screen, depth, class) returns the visual information for a \
visual that matches the specified depth and class for a screen."
  /* DIFF: XMatchVisualInfo dpy scr dep class [visual] -> #f or visual
   */
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMatchVisualInfo", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XMatchVisualInfo", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XMatchVisualInfo", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XMatchVisualInfo", "int");
  match_visual_info = (XVisualInfo *)CALLOC(1, sizeof(XVisualInfo));
  val = XMatchVisualInfo(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), match_visual_info);
  if (val)
    return(C_TO_XEN_XVisualInfo(match_visual_info));
  return(XEN_FALSE);
}

static XEN gxm_XLookupString(XEN arg1)
{
  #define H_XLookupString "int XLookupString(event_struct) translates a key event to a KeySym and a string -> (len str keysym)."
  /* DIFF: XLookupString last arg is ignored, keyevent and all but last omitted -> (list len str keysym)
   */
  KeySym key;
  char *str;
  int len;
  XEN res;
  XEN_ASSERT_TYPE(XEN_XKeyEvent_P(arg1), arg1, 1, "XLookupString", "XKeyEvent*");/* user-created */
  str = (char *)CALLOC(16, sizeof(char));
  len = XLookupString(XEN_TO_C_XKeyEvent(arg1), str, 16, &key, NULL);
  res = XEN_LIST_3(C_TO_XEN_INT(len),
		   C_TO_XEN_STRING(str),
		   C_TO_XEN_KeySym(key));
  FREE(str);
  return(res);
}

static XEN gxm_XConvertCase(XEN arg1)
{
  #define H_XConvertCase "void XConvertCase(keysym) returns the uppercase and lowercase forms of the specified \
Keysym, if the KeySym is subject to case conversion; otherwise, the specified KeySym is returned to both lower_return and upper_return."
  /* DIFF: XConvertCase keysym [k1 k2] -> (list k1 k2)
   */
  KeySym k1, k2;
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg1), arg1, 1, "XConvertCase", "KeySym");
  XConvertCase(XEN_TO_C_KeySym(arg1), &k1, &k2);
  return(XEN_LIST_2(C_TO_XEN_KeySym(k1),
		    C_TO_XEN_KeySym(k2)));
}

static XEN gxm_XIntersectRegion(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XIntersectRegion "XIntersectRegion(sra, srb, dr_return) computes the intersection of two regions."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XIntersectRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XIntersectRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg3), arg3, 3, "XIntersectRegion", "Region");
  return(C_TO_XEN_INT(XIntersectRegion(XEN_TO_C_Region(arg1), XEN_TO_C_Region(arg2), XEN_TO_C_Region(arg3))));
}

static XEN gxm_XGetWMHints(XEN arg1, XEN arg2)
{
  #define H_XGetWMHints "XWMHints *XGetWMHints(display, w) reads the window manager hints and returns NULL if no WM_HINTS property was \
set on the window or returns a pointer to a XWMHints structure if it succeeds."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetWMHints", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetWMHints", "Window");
  return(C_TO_XEN_XWMHints(XGetWMHints(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XGetVisualInfo(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetVisualInfo "XVisualInfo *XGetVisualInfo(display, vinfo_mask, vinfo_template) returns a list of visual \
structures that have attributes equal to the attributes specified by vinfo_template."
  /* DIFF: XGetVisualInfo dpy mask template [nitems] -> '() or (list visual...)
   */
  XVisualInfo *v;
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetVisualInfo", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XGetVisualInfo", "long");
  XEN_ASSERT_TYPE(XEN_XVisualInfo_P(arg3), arg3, 3, "XGetVisualInfo", "XVisualInfo*");
  v = XGetVisualInfo(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_XVisualInfo(arg3), &len);
  loc = xm_protect(lst);
  if (v)
    for (i = len - 1; i >= 0; i--)
      lst = XEN_CONS(C_TO_XEN_XVisualInfo(v + i), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XGetStandardColormap(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetStandardColormap "XGetStandardColormap(dpy, window, atom) gets the standard colormap property"
  /* DIFF: XGetStandardColormap omits colormap arg and returns it or #f
   */
  XStandardColormap *c;
  Status val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetStandardColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetStandardColormap", "Window");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XGetStandardColormap", "Atom");
  c = (XStandardColormap *)CALLOC(1, sizeof(XStandardColormap));
  val = XGetStandardColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), c, XEN_TO_C_Atom(arg3));
  if (val != 0)
    return(C_TO_XEN_XStandardColormap(c));
  FREE(c);
  return(XEN_FALSE);
}

static XEN gxm_XGetRGBColormaps(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetRGBColormaps "Status XGetRGBColormaps(display, w, property) returns the RGB colormap \
definitions stored in the specified property on the named window."
  /* DIFF: XGetRGBColormaps omits arg 3 and 4, returns list of XStandardColormaps 
   */
  int len, i, loc;
  Status val;
  XEN lst = XEN_EMPTY_LIST;
  XStandardColormap **cs = NULL; /* do I allocate this?? */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetRGBColormaps", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetRGBColormaps", "Window");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XGetRGBColormaps", "Atom");
  val = XGetRGBColormaps(XEN_TO_C_Display(arg1), 
			 XEN_TO_C_Window(arg2), 
			 cs, &len,
			 XEN_TO_C_Atom(arg3));
  if (val == 0)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_XStandardColormap(cs[i]), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XGetIconSizes(XEN arg1, XEN arg2)
{
  #define H_XGetIconSizes "Status XGetIconSizes(display, w) returns #f if the window manager has not \
set icon sizes; otherwise, it return nonzero and a list of XIconSize structs."
  /* DIFF: XGetIconSizes omit last 2 args, return list of XIconSizes
   */
  XIconSize *sizes;
  int i, len, val, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetIconSizes", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetIconSizes", "Window");
  val = XGetIconSizes(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &sizes, &len);
  if (val == 0)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_XIconSize(&(sizes[i])), lst);
  XFree(sizes);
  xm_unprotect_at(loc);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    lst));
}

static XEN gxm_XFindContext(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XFindContext "XFindContext(dpy, rid, context) gets data from the context manager"
  /* DIFF: XFindContext last arg omitted, val returned
   */
  caddr_t x;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFindContext", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XFindContext", "XID");
  XEN_ASSERT_TYPE(XEN_XContext_P(arg3), arg3, 3, "XFindContext", "XContext");
  val = XFindContext(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_XContext(arg3), &x);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    (XEN)x));
}

static XEN gxm_XEqualRegion(XEN arg1, XEN arg2)
{
  #define H_XEqualRegion "Bool XEqualRegion(r1, r2) returns #t if the two regions have the same offset, size, and shape."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XEqualRegion", "Region");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XEqualRegion", "Region");
  return(C_TO_XEN_BOOLEAN(XEqualRegion(XEN_TO_C_Region(arg1), XEN_TO_C_Region(arg2))));
}

static XEN gxm_XEmptyRegion(XEN arg1)
{
  #define H_XEmptyRegion "Bool XEmptyRegion(r) returns #t if the region is empty."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XEmptyRegion", "Region");
  return(C_TO_XEN_BOOLEAN(XEmptyRegion(XEN_TO_C_Region(arg1))));
}

static XEN gxm_XDestroyRegion(XEN arg1)
{
  #define H_XDestroyRegion "XDestroyRegion(r) deallocates the storage associated with a specified region."
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XDestroyRegion", "Region");
  return(C_TO_XEN_INT(XDestroyRegion(XEN_TO_C_Region(arg1))));
}

static XEN gxm_XDeleteContext(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XDeleteContext "int XDeleteContext(display, rid, context) deletes the entry for the given resource ID and type from the data structure."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDeleteContext", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XDeleteContext", "XID");
  XEN_ASSERT_TYPE(XEN_XContext_P(arg3), arg3, 3, "XDeleteContext", "XContext");
  return(C_TO_XEN_INT(XDeleteContext(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_XContext(arg3))));
}

static XEN gxm_XDefaultString(void)
{
  #define H_XDefaultString "char *XDefaultString() returns the default string used by Xlib for text conversion"
  return(C_TO_XEN_STRING(XDefaultString()));
}

static XEN gxm_XCreateRegion(void)
{
  #define H_XCreateRegion "Region XCreateRegion()"
  return(C_TO_XEN_Region(XCreateRegion()));
}

static XEN gxm_XClipBox(XEN arg1)
{
  #define H_XClipBox "XClipBox(r) returns the smallest rectangle enclosing the specified region."
  /* DIFF: XClipBox region [rectangle] -> (list val rectangle)
   */
  XRectangle *r;
  int val;
  XEN_ASSERT_TYPE(XEN_Region_P(arg1), arg1, 1, "XClipBox", "Region");
  r = (XRectangle *)CALLOC(1, sizeof(XRectangle));
  val = XClipBox(XEN_TO_C_Region(arg1), r);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XRectangle(r)));
}

static XEN gxm_XAllocWMHints(void)
{
  #define H_XAllocWMHints "XAllocWMHints() allocates a window manager hints structure"
  return(C_TO_XEN_XWMHints(XAllocWMHints()));
}

static XEN gxm_XAllocStandardColormap(void)
{
  #define H_XAllocStandardColormap "XStandardColormap *XAllocStandardColormap() allocates and returns a pointer to a XStandardColormap structure."
  return(C_TO_XEN_XStandardColormap(XAllocStandardColormap()));
}

static XEN gxm_XAllocIconSize(void)
{
  #define H_XAllocIconSize "XIconSize *XAllocIconSize() allocates and returns a pointer to a XIconSize structure."
  return(C_TO_XEN_XIconSize(XAllocIconSize()));
}

static XEN gxm_XFilterEvent(XEN arg1, XEN arg2)
{
  #define H_XFilterEvent "Bool XFilterEvent(event, w)"
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg1), arg1, 1, "XFilterEvent", "XEvent*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFilterEvent", "Window");
  return(C_TO_XEN_BOOLEAN(XFilterEvent(XEN_TO_C_XEvent(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XContextualDrawing(XEN arg1)
{
  #define H_XContextualDrawing "Bool XContextualDrawing(font_set) returns #t if text drawn with the font set might include context-dependent drawing."
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XContextualDrawing", "XFontSet");
  return(C_TO_XEN_BOOLEAN(XContextualDrawing(XEN_TO_C_XFontSet(arg1))));
}

static XEN gxm_XDirectionalDependentDrawing(XEN arg1)
{
  #define H_XDirectionalDependentDrawing "Bool XDirectionalDependentDrawing(font_set) returns #t if the drawing functions implement \
implicit text directionality."
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XDirectionalDependentDrawing", "XFontSet");
  return(C_TO_XEN_BOOLEAN(XDirectionalDependentDrawing(XEN_TO_C_XFontSet(arg1))));
}

static XEN gxm_XContextDependentDrawing(XEN arg1)
{
  #define H_XContextDependentDrawing "Bool XContextDependentDrawing(font_set) returns #t if the drawing functions implement implicit \
text directionality or if text drawn with the font_set might include context-dependent drawing."
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XContextDependentDrawing", "XFontSet");
  return(C_TO_XEN_BOOLEAN(XContextDependentDrawing(XEN_TO_C_XFontSet(arg1))));
}

static XEN gxm_XLocaleOfFontSet(XEN arg1)
{
  #define H_XLocaleOfFontSet "char *XLocaleOfFontSet(font_set) returns the name of the locale bound to the specified XFontSet, as a \
null-terminated string."
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XLocaleOfFontSet", "XFontSet");
  return(C_TO_XEN_STRING(XLocaleOfFontSet(XEN_TO_C_XFontSet(arg1))));
}

static XEN gxm_XBaseFontNameListOfFontSet(XEN arg1)
{
  #define H_XBaseFontNameListOfFontSet "char *XBaseFontNameListOfFontSet(font_set) returns the original base font name list supplied \
by the client when the  XFontSet was created."
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XBaseFontNameListOfFontSet", "XFontSet");
  return(C_TO_XEN_STRING(XBaseFontNameListOfFontSet(XEN_TO_C_XFontSet(arg1))));
}

static XEN gxm_XFontsOfFontSet(XEN arg1)
{
  #define H_XFontsOfFontSet "int XFontsOfFontSet(font_set) returns a list of one or more \
XFontStructs and font names for the fonts used by the Xmb and Xwc layers, for the given font set."
  /* DIFF: XFontsOfFontSet omit last 2 args, return 2 lists
   */
  int i, len, loc1, loc2;
  char **names;
  XEN lst1 = XEN_EMPTY_LIST, lst2 = XEN_EMPTY_LIST;
  XFontStruct **fs;
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg1), arg1, 1, "XFontsOfFontSet", "XFontSet");
  len = XFontsOfFontSet(XEN_TO_C_XFontSet(arg1), &fs, &names);
  loc1 = xm_protect(lst1);
  loc2 = xm_protect(lst2);
  for (i = len - 1; i >= 0; i--)
    {
      lst1 = XEN_CONS(C_TO_XEN_XFontStruct(fs[1]), lst1);
      lst2 = XEN_CONS(C_TO_XEN_STRING(names[i]), lst2);
    }
  xm_unprotect_at(loc1);
  xm_unprotect_at(loc2);
  return(XEN_LIST_2(lst1, lst2));
}

static XEN gxm_XFreeFontSet(XEN arg1, XEN arg2)
{
  #define H_XFreeFontSet "void XFreeFontSet(display, font_set) frees the specified font set."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeFontSet", "Display*");
  XEN_ASSERT_TYPE(XEN_XFontSet_P(arg2), arg2, 2, "XFreeFontSet", "XFontSet");
  XFreeFontSet(XEN_TO_C_Display(arg1), XEN_TO_C_XFontSet(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XCreateFontSet(XEN arg1, XEN arg2)
{
  #define H_XCreateFontSet "XFontSet XCreateFontSet(display, base_font_name_list) creates a font set for the specified display."
  /* DIFF: XCreateFontSet ignores (omits) the 3 trailing missing glyph args
   */
  char **cs;
  int len;
  char *str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateFontSet", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XCreateFontSet", "char*");
  return(C_TO_XEN_XFontSet(XCreateFontSet(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), &cs, &len, &str)));
}

static XEN gxm_XSetLocaleModifiers(XEN arg1)
{
  #define H_XSetLocaleModifiers "char *XSetLocaleModifiers(modifier_list) sets the X modifiers for the current locale setting."
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XSetLocaleModifiers", "char*");
  return(C_TO_XEN_STRING(XSetLocaleModifiers(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XSupportsLocale(void)
{
  #define H_XSupportsLocale "Bool XSupportsLocale() returns #t if Xlib functions are capable of operating under the current locale."
  return(C_TO_XEN_BOOLEAN(XSupportsLocale()));
}

static XEN gxm_XWriteBitmapFile(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XWriteBitmapFile "int XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot) writes a bitmap out to a file in \
the X Version 11 format."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XWriteBitmapFile", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XWriteBitmapFile", "char*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XWriteBitmapFile", "Pixmap");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XWriteBitmapFile", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XWriteBitmapFile", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XWriteBitmapFile", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XWriteBitmapFile", "int");
  return(C_TO_XEN_INT(XWriteBitmapFile(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_STRING(arg2), 
				       XEN_TO_C_Pixmap(arg3), 
				       XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5), 
				       XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XWindowEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XWindowEvent "XWindowEvent(display, w, event_mask) searches the event queue for an event that matches both \
the specified window and event mask, and removes it or waits until it arrives."
  /* DIFF: XWindowEvent dpy win ev [evrtn] -> (list val evrtn)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XWindowEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XWindowEvent", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XWindowEvent", "long");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XWindowEvent(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), e);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XWidthOfScreen(XEN arg1)
{
  #define H_WidthOfScreen "XWidthOfScreen(screen) returns the width of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XWidthOfScreen", "Screen*");
  return(C_TO_XEN_INT(XWidthOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XWidthMMOfScreen(XEN arg1)
{
  #define H_WidthMMOfScreen "XWidthMMOfScreen(screen) returns the width of the specified screen in millimeters."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XWidthMMOfScreen", "Screen*");
  return(C_TO_XEN_INT(XWidthMMOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XWarpPointer(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XWarpPointer "XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XWarpPointer", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XWarpPointer", "Window");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XWarpPointer", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XWarpPointer", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XWarpPointer", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XWarpPointer", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XWarpPointer", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XWarpPointer", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XWarpPointer", "int");
  return(C_TO_XEN_INT(XWarpPointer(XEN_TO_C_Display(arg1), 
				   XEN_TO_C_Window(arg2), XEN_TO_C_Window(arg3), 
				   XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				   XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7), 
				   XEN_TO_C_INT(arg8), XEN_TO_C_INT(arg9))));
}

static XEN gxm_XVendorRelease(XEN arg1)
{
  #define H_VendorRelease "VendorRelease(display) returns a number related to a vendor's release of the X server."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XVendorRelease", "Display*");
  return(C_TO_XEN_INT(XVendorRelease(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XUnmapWindow(XEN arg1, XEN arg2)
{
  #define H_XUnmapWindow "XUnmapWindow(display, w) unmaps the specified window and causes the X server to generate an UnmapNotify event."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUnmapWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XUnmapWindow", "Window");
  return(C_TO_XEN_INT(XUnmapWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XUnmapSubwindows(XEN arg1, XEN arg2)
{
  #define H_XUnmapSubwindows "XUnmapSubwindows(display, w) unmaps all subwindows for the specified window in bottom-to-top stacking order."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUnmapSubwindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XUnmapSubwindows", "Window");
  return(C_TO_XEN_INT(XUnmapSubwindows(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XUnloadFont(XEN arg1, XEN arg2)
{
  #define H_XUnloadFont "XUnloadFont(display, font) deletes the association between the font resource ID and the specified font."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUnloadFont", "Display*");
  XEN_ASSERT_TYPE(XEN_Font_P(arg2), arg2, 2, "XUnloadFont", "Font");
  return(C_TO_XEN_INT(XUnloadFont(XEN_TO_C_Display(arg1), XEN_TO_C_Font(arg2))));
}

static XEN gxm_XUninstallColormap(XEN arg1, XEN arg2)
{
  #define H_XUninstallColormap "XUninstallColormap(display, colormap) removes the specified colormap from the required list for its screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUninstallColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XUninstallColormap", "Colormap");
  return(C_TO_XEN_INT(XUninstallColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2))));
}

static XEN gxm_XUngrabServer(XEN arg1)
{
  #define H_XUngrabServer "XUngrabServer(display) restarts processing of requests and close downs on other connections."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUngrabServer", "Display*");
  return(C_TO_XEN_INT(XUngrabServer(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XUngrabPointer(XEN arg1, XEN arg2)
{
  #define H_XUngrabPointer "XUngrabPointer(display, time) releases the pointer and any queued events if this client has actively grabbed the \
pointer from XGrabPointer, XGrabButton,or from a normal button press."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUngrabPointer", "Display*");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XUngrabPointer", "Time");
  return(C_TO_XEN_INT(XUngrabPointer(XEN_TO_C_Display(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XUngrabKeyboard(XEN arg1, XEN arg2)
{
  #define H_XUngrabKeyboard "XUngrabKeyboard(display, time) releases the keyboard and any queued events if this client has it actively grabbed \
from either XGrabKeyboard or XGrabKey."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUngrabKeyboard", "Display*");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XUngrabKeyboard", "Time");
  return(C_TO_XEN_INT(XUngrabKeyboard(XEN_TO_C_Display(arg1), XEN_TO_C_Time(arg2))));
}

static XEN gxm_XUngrabKey(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XUngrabKey "XUngrabKey(display, keycode, modifiers, grab_window) releases the key combination on the specified window if it was \
grabbed by this client."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUngrabKey", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XUngrabKey", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XUngrabKey", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg4), arg4, 4, "XUngrabKey", "Window");
  return(C_TO_XEN_INT(XUngrabKey(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_Window(arg4))));
}

static XEN gxm_XUngrabButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XUngrabButton "XUngrabButton(display, button, modifiers, grab_window) releases the passive button/key combination on the specified \
window if it was grabbed by this client."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUngrabButton", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XUngrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XUngrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg4), arg4, 4, "XUngrabButton", "Window");
  return(C_TO_XEN_INT(XUngrabButton(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_Window(arg4))));
}

static XEN gxm_XUndefineCursor(XEN arg1, XEN arg2)
{
  #define H_XUndefineCursor "XUndefineCursor(display, w) undoes the effect of a previous XDefineCursor for this window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUndefineCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XUndefineCursor", "Window");
  return(C_TO_XEN_INT(XUndefineCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XTranslateCoordinates(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XTranslateCoordinates "Bool XTranslateCoordinates(display, src_w, dest_w, src_x, src_y) \
takes the src_x and src_y coordinates relative to the source window's origin and returns these coordinates to dest_x_return and dest_y_return \
relative to the destination window's origin -> (rtn x y win)."
  /* DIFF: XTranslateCoordinates omit last 3 args
   */
  Window w;
  int x, y, rtn;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XTranslateCoordinates", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XTranslateCoordinates", "Window");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XTranslateCoordinates", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XTranslateCoordinates", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XTranslateCoordinates", "int");
  rtn = XTranslateCoordinates(XEN_TO_C_Display(arg1), 
			      XEN_TO_C_Window(arg2), 
			      XEN_TO_C_Window(arg3), 
			      XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
			      &x, &y, &w);
  return(XEN_LIST_4(C_TO_XEN_BOOLEAN(rtn),
		    C_TO_XEN_INT(x),
		    C_TO_XEN_INT(y),
		    C_TO_XEN_Window(w)));
}

static XEN gxm_XTextWidth(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XTextWidth "int XTextWidth(font_struct, string, count) returns the width of the specified 8-bit string."
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg1), arg1, 1, "XTextWidth", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XTextWidth", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XTextWidth", "int");
  return(C_TO_XEN_INT(XTextWidth(XEN_TO_C_XFontStruct(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XTextExtents(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XTextExtents "XTextExtents(font_struct, string, nchars) returns an XCharStruct structure describing the text."
  /* DIFF: XTextExtents omit final 4 args and returns them [Xcharset returned as embedded list)
   */
  int dir, fa, fd, rtn;
  XCharStruct val;
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg1), arg1, 1, "XTextExtents", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XTextExtents", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XTextExtents", "int");
  rtn = XTextExtents(XEN_TO_C_XFontStruct(arg1), 
		     XEN_TO_C_STRING(arg2), 
		     XEN_TO_C_INT(arg3), 
		     &dir, &fa, &fd, &val);
  return(XEN_LIST_5(C_TO_XEN_INT(rtn),
		    C_TO_XEN_INT(dir),
		    C_TO_XEN_INT(fa),
		    C_TO_XEN_INT(fd),
		    XEN_LIST_6(C_TO_XEN_INT((int)(val.lbearing)),
			       C_TO_XEN_INT((int)(val.rbearing)),
			       C_TO_XEN_INT((int)(val.width)),
			       C_TO_XEN_INT((int)(val.ascent)),
			       C_TO_XEN_INT((int)(val.descent)),
			       C_TO_XEN_INT((int)(val.attributes)))));
}

static XEN gxm_XSync(XEN arg1, XEN arg2)
{
  #define H_XSync "XSync(display, discard) flushes the output buffer and then waits until all requests have been received and processed by the X server."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSync", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XSync", "Bool");
  return(C_TO_XEN_INT(XSync(XEN_TO_C_Display(arg1), XEN_TO_C_BOOLEAN(arg2))));
}

static XEN gxm_XStoreNamedColor(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XStoreNamedColor "XStoreNamedColor(display, colormap, color, pixel, flags) looks up the named color with respect to the screen \
associated with the colormap and stores the result in the specified colormap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreNamedColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XStoreNamedColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XStoreNamedColor", "char*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XStoreNamedColor", "ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XStoreNamedColor", "int");
  return(C_TO_XEN_INT(XStoreNamedColor(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Colormap(arg2), 
				       XEN_TO_C_STRING(arg3), XEN_TO_C_ULONG(arg4), XEN_TO_C_INT(arg5))));
}

static XEN gxm_XStoreName(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XStoreName "XStoreName(display, w, window_name) assigns the name passed to window_name to the specified window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreName", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XStoreName", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XStoreName", "char*");
  return(C_TO_XEN_INT(XStoreName(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_STRING(arg3))));
}

static XEN gxm_XStoreColors(XEN arg1, XEN arg2, XEN larg3, XEN arg4)
{
  #define H_XStoreColors "XStoreColors(display, colormap, color, ncolors) changes the colormap entries of the pixel values specified in the \
pixel members of the XColor structures."
  /* DIFF: XStoreColors arg 3 is list of XColor 
   */
  XColor *xc, *xc1;
  int i, len;
  XEN arg3;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreColors", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XStoreColors", "Colormap");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg3), larg3, 3, "XStoreColors", "list of XColor");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XStoreColors", "int");
  arg3 = XEN_COPY_ARG(larg3);
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg4, 4, "XStoreColors", "positive integer");
  xc = (XColor *)CALLOC(len, sizeof(XColor));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg3)); i++, arg3 = XEN_CDR(arg3))
    {
      xc1 = XEN_TO_C_XColor(XEN_CAR(arg3));
      xc[i].pixel = xc1->pixel;
      xc[i].red = xc1->red;
      xc[i].green = xc1->green;
      xc[i].blue = xc1->blue;
      xc[i].flags = xc1->flags;
      xc[i].pad = xc1->pad;
    }
  XStoreColors(XEN_TO_C_Display(arg1), 
	       XEN_TO_C_Colormap(arg2),
	       xc, len);
  FREE(xc);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XStoreColor(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XStoreColor "XStoreColor(display, colormap, color) changes the colormap entry of the pixel value specified in the pixel member \
of the XColor structure."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XStoreColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg3), arg3, 3, "XStoreColor", "XColor"); 
  return(C_TO_XEN_INT(XStoreColor(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2), XEN_TO_C_XColor(arg3))));
}

static XEN gxm_XStoreBytes(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XStoreBytes "XStoreBytes(display, bytes, nbytes)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreBytes", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XStoreBytes", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XStoreBytes", "int");
  return(C_TO_XEN_INT(XStoreBytes(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3) + 1)));
}

static XEN gxm_XStoreBuffer(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XStoreBuffer "XStoreBuffer(display, bytes, nbytes, buffer)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XStoreBuffer", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XStoreBuffer", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XStoreBuffer", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XStoreBuffer", "int");
  return(C_TO_XEN_INT(XStoreBuffer(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3) + 1, XEN_TO_C_INT(arg4))));
}

static XEN gxm_XSetWindowColormap(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowColormap "XSetWindowColormap(display, w, colormap) sets the specified colormap of the specified window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowColormap", "Window");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg3), arg3, 3, "XSetWindowColormap", "Colormap");
  return(C_TO_XEN_INT(XSetWindowColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Colormap(arg3))));
}

static XEN gxm_XSetWindowBorderWidth(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowBorderWidth "XSetWindowBorderWidth(display, w, width) sets the specified window's border width to the specified width."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowBorderWidth", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowBorderWidth", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XSetWindowBorderWidth", "unsigned int");
  return(C_TO_XEN_INT(XSetWindowBorderWidth(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3))));
}

static XEN gxm_XSetWindowBorderPixmap(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowBorderPixmap "XSetWindowBorderPixmap(display, w, border_pixmap) sets the border pixmap of the window to the pixmap you specify."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowBorderPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowBorderPixmap", "Window");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3) || XEN_INTEGER_P(arg3), arg3, 3, "XSetWindowBorderPixmap", "Pixmap");
  return(C_TO_XEN_INT(XSetWindowBorderPixmap(XEN_TO_C_Display(arg1), 
					     XEN_TO_C_Window(arg2),
					     (XEN_Pixmap_P(arg3)) ? XEN_TO_C_Pixmap(arg3) : CopyFromParent)));
}

static XEN gxm_XSetWindowBorder(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowBorder "XSetWindowBorder(display, w, border_pixel) sets the border of the window to the pixel value you specify."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowBorder", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowBorder", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XSetWindowBorder", "ulong");
  return(C_TO_XEN_INT(XSetWindowBorder(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3))));
}

static XEN gxm_XSetWindowBackgroundPixmap(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowBackgroundPixmap "XSetWindowBackgroundPixmap(display, w, background_pixmap) sets the background pixmap of the window to \
the specified pixmap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowBackgroundPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowBackgroundPixmap", "Window");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3) || XEN_INTEGER_P(arg3), arg3, 3, "XSetWindowBackgroundPixmap", "Pixmap");
  return(C_TO_XEN_INT(XSetWindowBackgroundPixmap(XEN_TO_C_Display(arg1), 
						 XEN_TO_C_Window(arg2), 
						 (XEN_Pixmap_P(arg3)) ? XEN_TO_C_Pixmap(arg3) : XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetWindowBackground(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetWindowBackground "XSetWindowBackground(display, w, background_pixel) sets the background of the window to the specified pixel value."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWindowBackground", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWindowBackground", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XSetWindowBackground", "ulong");
  return(C_TO_XEN_INT(XSetWindowBackground(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3))));
}

static XEN gxm_XSetTile(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetTile "XSetTile(display, gc, tile) sets the fill tile in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetTile", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetTile", "GC");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XSetTile", "Pixmap");
  return(C_TO_XEN_INT(XSetTile(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Pixmap(arg3))));
}

static XEN gxm_XSetTSOrigin(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetTSOrigin "XSetTSOrigin(display, gc, ts_x_origin, ts_y_origin) sets the tile/stipple origin in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetTSOrigin", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetTSOrigin", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetTSOrigin", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetTSOrigin", "int");
  return(C_TO_XEN_INT(XSetTSOrigin(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4))));
}

static XEN gxm_XSetSubwindowMode(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetSubwindowMode "XSetSubwindowMode(display, gc, subwindow_mode) sets the subwindow mode in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetSubwindowMode", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetSubwindowMode", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetSubwindowMode", "int");
  return(C_TO_XEN_INT(XSetSubwindowMode(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetStipple(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetStipple "XSetStipple(display, gc, stipple) sets the stipple in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetStipple", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetStipple", "GC");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XSetStipple", "Pixmap");
  return(C_TO_XEN_INT(XSetStipple(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Pixmap(arg3))));
}

static XEN gxm_XSetState(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XSetState "XSetState(display, gc, foreground, background, function, plane_mask) sets the foreground, background, plane mask, and \
function components for the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetState", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetState", "GC");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XSetState", "Pixel");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg4), arg4, 4, "XSetState", "Pixel");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XSetState", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XSetState", "ulong");
  return(C_TO_XEN_INT(XSetState(XEN_TO_C_Display(arg1), 
				XEN_TO_C_GC(arg2), 
				XEN_TO_C_Pixel(arg3), XEN_TO_C_Pixel(arg4), 
				XEN_TO_C_INT(arg5), XEN_TO_C_ULONG(arg6))));
}

static XEN gxm_XSetSelectionOwner(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetSelectionOwner "XSetSelectionOwner(display, selection, owner, time) changes the owner and last-change time for the specified selection"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetSelectionOwner", "Display*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XSetSelectionOwner", "Atom");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XSetSelectionOwner", "Window");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XSetSelectionOwner", "Time");
  return(C_TO_XEN_INT(XSetSelectionOwner(XEN_TO_C_Display(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Window(arg3), XEN_TO_C_Time(arg4))));
}

static XEN gxm_XSetScreenSaver(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XSetScreenSaver "XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures) enables the screen saver."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetScreenSaver", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XSetScreenSaver", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetScreenSaver", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetScreenSaver", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XSetScreenSaver", "int");
  return(C_TO_XEN_INT(XSetScreenSaver(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5))));
}

static XEN gxm_XSetPointerMapping(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetPointerMapping "int XSetPointerMapping(display, map, nmap) sets the mapping of the pointer."
  int i, len, rtn;
  unsigned char *map;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetPointerMapping", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XSetPointerMapping", "list of ints");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XSetPointerMapping", "int");
  if (XEN_INTEGER_P(arg3)) len = XEN_TO_C_INT(arg3); else len = XEN_LIST_LENGTH(arg2);
  map = (unsigned char *)CALLOC(len, sizeof(unsigned char));
  for (i = 0; i < len; i++)
    map[i] = (unsigned char)XEN_TO_C_INT(XEN_LIST_REF(arg2, i));
  rtn = XSetPointerMapping(XEN_TO_C_Display(arg1), map, len);
  FREE(map);
  return(C_TO_XEN_INT(rtn));
}

static XEN gxm_XSetPlaneMask(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetPlaneMask "XSetPlaneMask(display, gc, plane_mask) sets the plane mask in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetPlaneMask", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetPlaneMask", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XSetPlaneMask", "ulong");
  return(C_TO_XEN_INT(XSetPlaneMask(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_ULONG(arg3))));
}

static XEN gxm_XSetModifierMapping(XEN arg1, XEN arg2)
{
  #define H_XSetModifierMapping "int XSetModifierMapping(display, modmap) specifies the KeyCodes of the keys (if any) that are to be used as modifiers."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetModifierMapping", "Display*");
  XEN_ASSERT_TYPE(XEN_XModifierKeymap_P(arg2), arg2, 2, "XSetModifierMapping", "XModifierKeymap*");
  return(C_TO_XEN_INT(XSetModifierMapping(XEN_TO_C_Display(arg1), XEN_TO_C_XModifierKeymap(arg2))));
}

static XEN gxm_XSetLineAttributes(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XSetLineAttributes "XSetLineAttributes(display, gc, line_width, line_style, cap_style, join_style) sets the line drawing components \
in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetLineAttributes", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetLineAttributes", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XSetLineAttributes", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetLineAttributes", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XSetLineAttributes", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XSetLineAttributes", "int");
  return(C_TO_XEN_INT(XSetLineAttributes(XEN_TO_C_Display(arg1), 
					 XEN_TO_C_GC(arg2), 
					 XEN_TO_C_ULONG(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6))));
}

static XEN gxm_XSetInputFocus(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetInputFocus "XSetInputFocus(display, focus, revert_to, time) changes the input focus and the last-focus-change time."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetInputFocus", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetInputFocus", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetInputFocus", "int");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XSetInputFocus", "Time");
  return(C_TO_XEN_INT(XSetInputFocus(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_Time(arg4))));
}

static XEN gxm_XSetIconName(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetIconName "XSetIconName(display, w, icon_name) sets the name to be displayed in a window's icon."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetIconName", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetIconName", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XSetIconName", "char*");
  return(C_TO_XEN_INT(XSetIconName(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_STRING(arg3))));
}

static XEN gxm_XSetGraphicsExposures(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetGraphicsExposures "XSetGraphicsExposures(display, gc, graphics_exposures) sets the graphics-exposures flag in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetGraphicsExposures", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetGraphicsExposures", "GC");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XSetGraphicsExposures", "Bool");
  return(C_TO_XEN_INT(XSetGraphicsExposures(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_BOOLEAN(arg3))));
}

static XEN gxm_XSetFunction(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetFunction "XSetFunction(display, gc, function) sets a specified value in the specified GC"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetFunction", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetFunction", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetFunction", "int");
  return(C_TO_XEN_INT(XSetFunction(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetForeground(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetForeground "XSetForeground(display, gc, foreground) sets the foreground in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetForeground", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetForeground", "GC");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XSetForeground", "Pixel");
  return(C_TO_XEN_INT(XSetForeground(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Pixel(arg3))));
}

static XEN gxm_XSetFontPath(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetFontPath "XSetFontPath(display, directories, ndirs) defines the directory search path for font lookup."
  /* DIFF: XSetFontPath arg2 is list of strings
   */
  char **paths;
  int len, rtn;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetFontPath", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XSetFontPath", "list of char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetFontPath", "int");
  len = XEN_TO_C_INT(arg3);
  if (len > 0)
    paths = XEN_TO_C_Strings(arg2, len);
  else paths = NULL;
  rtn = XSetFontPath(XEN_TO_C_Display(arg1), paths, len);
  if (paths) FREE(paths);
  return(C_TO_XEN_INT(rtn));
}

static XEN gxm_XSetFont(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetFont "XSetFont(display, gc, font) sets the current font in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetFont", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetFont", "GC");
  XEN_ASSERT_TYPE(XEN_Font_P(arg3), arg3, 3, "XSetFont", "Font");
  return(C_TO_XEN_INT(XSetFont(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Font(arg3))));
}

static XEN gxm_XSetFillStyle(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetFillStyle "XSetFillStyle(display, gc, fill_style) sets the fill-style in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetFillStyle", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetFillStyle", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetFillStyle", "int");
  return(C_TO_XEN_INT(XSetFillStyle(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetFillRule(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetFillRule "XSetFillRule(display, gc, fill_rule) sets the fill-rule in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetFillRule", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetFillRule", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetFillRule", "int");
  return(C_TO_XEN_INT(XSetFillRule(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetDashes(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XSetDashes "XSetDashes(display, gc, dash_offset, dash_list, n) sets the dash-offset and dash-list attributes for dashed line styles \
in the specified GC."
  char *dashes;
  int i, len = 0, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetDashes", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetDashes", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetDashes", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XSetDashes", "list of ints");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XSetDashes", "optional length of list (int)");
  if (XEN_INTEGER_P(arg5)) len = XEN_TO_C_INT(arg5);
  if (len <= 0) len = XEN_LIST_LENGTH(arg4);
  dashes = (char *)CALLOC(len, sizeof(char));
  for (i = 0; i < len; i++) dashes[i] = (char)(XEN_TO_C_INT(XEN_LIST_REF(arg4, i)));
  val = XSetDashes(XEN_TO_C_Display(arg1), 
		   XEN_TO_C_GC(arg2), 
		   XEN_TO_C_INT(arg3),
		   dashes, len);
  FREE(dashes);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XSetCommand(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetCommand "XSetCommand(display, w, argv, argc) sets the command and arguments used to invoke the application."
  /* DIFF: XSetCommand argv is list of strings
   */
  int len, val;
  char **str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetCommand", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetCommand", "Window");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XSetCommand", "list of char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetCommand", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  str = XEN_TO_C_Strings(arg3, len);
  val = XSetCommand(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), str, len);
  FREE(str);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XSetCloseDownMode(XEN arg1, XEN arg2)
{
  #define H_XSetCloseDownMode "XSetCloseDownMode(display, close_mode) defines what will happen to the client's resources at connection close."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetCloseDownMode", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XSetCloseDownMode", "int");
  return(C_TO_XEN_INT(XSetCloseDownMode(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XSetClipRectangles(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN larg5, XEN arg6, XEN arg7)
{
  #define H_XSetClipRectangles "XSetClipRectangles(display, gc, clip_x_origin, clip_y_origin, rectangles, n, ordering) changes the clip-mask in \
the specified GC to the specified list of rectangles and sets the clip origin."
  /* DIFF: XSetClipRectangles XRectangle* arg (arg 5) is list of XRectangles
   */
  XRectangle *pt, *pt1;
  int i, len;
  XEN arg5;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetClipRectangles", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetClipRectangles", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetClipRectangles", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetClipRectangles", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg5), larg5, 5, "XSetClipRectangles", "list of XRectangles");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XSetClipRectangles", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XSetClipRectangles", "int");
  arg5 = XEN_COPY_ARG(larg5);
  len = XEN_TO_C_INT(arg6);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg6, 6, "XSetClipRectangles", "positive integer");
  pt = (XRectangle *)CALLOC(len, sizeof(XRectangle));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg5)); i++, arg5 = XEN_CDR(arg5))
    {
      pt1 = XEN_TO_C_XRectangle(XEN_CAR(arg5));
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
      pt[i].width = pt1->width;
      pt[i].height = pt1->height;
    }
  XSetClipRectangles(XEN_TO_C_Display(arg1), 
		     XEN_TO_C_GC(arg2), 
		     XEN_TO_C_INT(arg3), 
		     XEN_TO_C_INT(arg4), 
		     pt, len,
		     XEN_TO_C_INT(arg7));
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XSetClipOrigin(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetClipOrigin "XSetClipOrigin(display, gc, clip_x_origin, clip_y_origin) sets the clip origin in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetClipOrigin", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetClipOrigin", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetClipOrigin", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetClipOrigin", "int");
  return(C_TO_XEN_INT(XSetClipOrigin(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4))));
}

static XEN gxm_XSetClipMask(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetClipMask "XSetClipMask(display, gc, pixmap) sets the clip-mask in the specified GC to the specified pixmap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetClipMask", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetClipMask", "GC");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XSetClipMask", "Pixmap");
  return(C_TO_XEN_INT(XSetClipMask(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Pixmap(arg3))));
}

static XEN gxm_XSetBackground(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetBackground "XSetBackground(display, gc, background) sets the background in the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetBackground", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetBackground", "GC");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg3), arg3, 3, "XSetBackground", "Pixel");
  return(C_TO_XEN_INT(XSetBackground(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_Pixel(arg3))));
}

static XEN gxm_XSetArcMode(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetArcMode "XSetArcMode(display, gc, arc_mode)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetArcMode", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XSetArcMode", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSetArcMode", "int");
  return(C_TO_XEN_INT(XSetArcMode(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetAccessControl(XEN arg1, XEN arg2)
{
  #define H_XSetAccessControl "XSetAccessControl(display, mode) either enables or disables the use of the access control list at each connection setup."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetAccessControl", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XSetAccessControl", "int");
  return(C_TO_XEN_INT(XSetAccessControl(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XSendEvent(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XSendEvent "Status XSendEvent(display, w, propagate, event_mask, event_send) identifies the destination window, determines which \
clients should receive the specified events, "
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSendEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSendEvent", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XSendEvent", "Bool");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSendEvent", "long");
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg5), arg5, 5, "XSendEvent", "XEvent*");
  return(C_TO_XEN_INT(XSendEvent(XEN_TO_C_Display(arg1), 
				 XEN_TO_C_Window(arg2), 
				 XEN_TO_C_BOOLEAN(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_XEvent(arg5))));
}

static XEN gxm_XSelectInput(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSelectInput "XSelectInput(dpy, window, event_mask) selects input events"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSelectInput", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSelectInput", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSelectInput", "long");
  return(C_TO_XEN_INT(XSelectInput(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XScreenCount(XEN arg1)
{
  #define H_ScreenCount "returns the number of available screens."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XScreenCount", "Display*");
  return(C_TO_XEN_INT(XScreenCount(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XRotateWindowProperties(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XRotateWindowProperties "XRotateWindowProperties(display, w, properties, num_prop, npositions) allows you to rotate properties on a \
window and causes the X server to generate PropertyNotify events."
  /* DIFF: XRotateWindowProperties arg3 is list of atoms
   */
  Atom *outs;
  int val, len;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRotateWindowProperties", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XRotateWindowProperties", "Window");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XRotateWindowProperties", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XRotateWindowProperties", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XRotateWindowProperties", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  val = XRotateWindowProperties(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), outs, len, XEN_TO_C_INT(arg5));
  FREE(outs);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XRotateBuffers(XEN arg1, XEN arg2)
{
  #define H_XRotateBuffers "XRotateBuffers(display, rotate) rotates the cut buffers, such that buffer 0 becomes buffer n, buffer 1 becomes n + 1 \
mod 8, and so on. "
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRotateBuffers", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XRotateBuffers", "int");
  return(C_TO_XEN_INT(XRotateBuffers(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XRestackWindows(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XRestackWindows "XRestackWindows(display, windows, nwindows) restacks the windows in the order specified, from top to bottom."
  /* DIFF: XRestackWindows arg2 is list of Windows
   */
  int len, rtn;
  Window *ws;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRestackWindows", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XRestackWindows", "list of Windows");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XRestackWindows", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) return(XEN_FALSE);
  ws = XEN_TO_C_Windows(arg2, len);
  rtn = XRestackWindows(XEN_TO_C_Display(arg1), ws, len);
  FREE(ws);
  return(C_TO_XEN_INT(rtn));
}

static XEN gxm_XResizeWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XResizeWindow "XResizeWindow(display, w, width, height) changes the inside dimensions of the specified window, not including its borders."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XResizeWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XResizeWindow", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XResizeWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XResizeWindow", "unsigned int");
  return(C_TO_XEN_INT(XResizeWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_ULONG(arg4))));
}

static XEN gxm_XResetScreenSaver(XEN arg1)
{
  #define H_XResetScreenSaver "XResetScreenSaver(display) resets the screen saver."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XResetScreenSaver", "Display*");
  return(C_TO_XEN_INT(XResetScreenSaver(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XReparentWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XReparentWindow "XReparentWindow(display, w, parent, x, y)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XReparentWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XReparentWindow", "Window");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XReparentWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XReparentWindow", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XReparentWindow", "int");
  return(C_TO_XEN_INT(XReparentWindow(XEN_TO_C_Display(arg1), 
				      XEN_TO_C_Window(arg2), 
				      XEN_TO_C_Window(arg3), 
				      XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5))));
}

static XEN gxm_XRefreshKeyboardMapping(XEN arg1)
{
  #define H_XRefreshKeyboardMapping "XRefreshKeyboardMapping(event_map) refreshes the stored modifier and keymap information."
  XEN_ASSERT_TYPE(XEN_XMappingEvent_P(arg1), arg1, 1, "XRefreshKeyboardMapping", "XMappingEvent*");
  return(C_TO_XEN_INT(XRefreshKeyboardMapping(XEN_TO_C_XMappingEvent(arg1))));
}

static XEN gxm_XRecolorCursor(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XRecolorCursor "XRecolorCursor(display, cursor, foreground_color, background_color) changes the color of the specified cursor, and if \
the cursor is being displayed on a screen, the change is visible immediately."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRecolorCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg2), arg2, 2, "XRecolorCursor", "Cursor");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg3), arg3, 3, "XRecolorCursor", "XColor");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg4), arg4, 4, "XRecolorCursor", "XColor");
  return(C_TO_XEN_INT(XRecolorCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Cursor(arg2), 
				     XEN_TO_C_XColor(arg3), XEN_TO_C_XColor(arg4))));
}

static XEN gxm_XRebindKeysym(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XRebindKeysym "XRebindKeysym(display, keysym, list, mod_count, string, num_bytes) can be used to rebind the meaning of a KeySym for the client."
  /* DIFF: XRebindKeysym mod_list is list of keysyms
   */
  KeySym *ks;
  int len, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRebindKeysym", "Display*");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg2), arg2, 2, "XRebindKeysym", "KeySym");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XRebindKeysym", "list of KeySym");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XRebindKeysym", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XRebindKeysym", "string");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XRebindKeysym", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  ks = XEN_TO_C_KeySyms(arg3, len);
  val = XRebindKeysym(XEN_TO_C_Display(arg1), 
		      XEN_TO_C_KeySym(arg2),
		      ks, len, 
		      (unsigned char *)XEN_TO_C_STRING(arg5), XEN_TO_C_INT(arg6));
  FREE(ks);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XReadBitmapFileData(XEN arg1)
{
  #define H_XReadBitmapFileData "int XReadBitmapFileData(filename) reads in a \
file containing a bitmap, in the same manner as XReadBitmapFile, but returns the data directly rather than creating a pixmap in the server."
  /* DIFF: XReadBitmapFileData omits last 5 args, returns as list
   */
  unsigned int w, h, i, j;
  int x, y;
  unsigned char **str = NULL; /* allocated by X? */
  int val, loc;
  XEN bits = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XReadBitmapFileData", "char*");
  val = XReadBitmapFileData(XEN_TO_C_STRING(arg1), &w, &h, str, &x, &y);
  loc = xm_protect(bits);
  for (i = 0; i < h; i++)
    for (j = 0; j < w; j++)
      bits = XEN_CONS(C_TO_XEN_INT((int)(str[i][j])), bits);
  if (str) free(str);
  xm_unprotect_at(loc);
  return(XEN_LIST_6(C_TO_XEN_INT(val),
		    C_TO_XEN_INT((int)w),
		    C_TO_XEN_INT((int)h),
		    bits,
		    C_TO_XEN_INT((int)x),
		    C_TO_XEN_INT((int)y)));
}

static XEN gxm_XReadBitmapFile(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XReadBitmapFile "int XReadBitmapFile(display, d, filename) reads in a file containing a bitmap."
  /* DIFF: XReadBitmapFile omits last 5 args, returns as list
   */
  unsigned int w, h;
  int x, y;
  int val;
  Pixmap *p = NULL; /* allocated by X? */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XReadBitmapFile", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XReadBitmapFile", "Drawable");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XReadBitmapFile", "char*");
  val = XReadBitmapFile(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_STRING(arg3), &w, &h, p, &x, &y);
  return(XEN_LIST_6(C_TO_XEN_INT(val),
		    C_TO_XEN_INT((int)w),
		    C_TO_XEN_INT((int)h),
		    C_TO_XEN_Pixmap(*p),
		    C_TO_XEN_INT((int)x),
		    C_TO_XEN_INT((int)y)));
}

static XEN gxm_XRaiseWindow(XEN arg1, XEN arg2)
{
  #define H_XRaiseWindow "XRaiseWindow(display, w)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRaiseWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XRaiseWindow", "Window");
  return(C_TO_XEN_INT(XRaiseWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XQueryTree(XEN arg1, XEN arg2)
{
  #define H_XQueryTree "Status XQueryTree(display, w) returns the root ID, the \
parent window ID, a pointer to the list of children windows and the number of children in the list for the specified window."
  /* DIFF: XQueryTree last 4 arg omit, returns (list val root parent (list children))
   */
  unsigned int arrlen;
  Window *ws;
  Window root, parent;
  int i, val, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryTree", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XQueryTree", "Window");
  val = XQueryTree(XEN_TO_C_Display(arg1), 
		   XEN_TO_C_Window(arg2), 
		   &root, &parent, &ws, &arrlen);
  loc = xm_protect(lst);
  for (i = arrlen - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Window(ws[i]), lst);
  XFree(ws);
  xm_unprotect_at(loc);
  return(XEN_LIST_4(C_TO_XEN_INT(val),
		    C_TO_XEN_Window(root),
		    C_TO_XEN_Window(parent),
		    lst));
}

static XEN gxm_XQueryTextExtents(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XQueryTextExtents "XQueryTextExtents(display, font, string) returns the bounding box of the specified 8-bit string."
  /* DIFF: XQueryTextExtents omits last 5 args, returns list 
   */
  XCharStruct *c;
  int fa, fd, dr, val;
  char *str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryTextExtents", "Display*");
  XEN_ASSERT_TYPE(XEN_Font_P(arg2), arg2, 2, "XQueryTextExtents", "Font");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XQueryTextExtents", "char*");
  str = XEN_TO_C_STRING(arg3);
  c = (XCharStruct *)CALLOC(1, sizeof(XCharStruct));
  val = XQueryTextExtents(XEN_TO_C_Display(arg1), 
			  XEN_TO_C_Font(arg2), 
			  str, strlen(str), &dr, &fa, &fd, c); 
  return(XEN_LIST_5(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(dr),
		    C_TO_XEN_INT(fa),
		    C_TO_XEN_INT(fd),
		    WRAP_FOR_XEN_OBJ("XCharStruct", c)));
}

static XEN gxm_XQueryPointer(XEN arg1, XEN arg2)
{
  #define H_XQueryPointer "Bool XQueryPointer(display, w) returns the root window the pointer is logically on and the pointer \
coordinates relative to the root window's origin."
  /* DIFF: XQueryPointer last 7 args omit and rtn
   */
  Window w1, w2;
  int rx, ry, wx, wy;
  unsigned int mask;
  int rtn;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryPointer", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XQueryPointer", "Window");
  rtn = XQueryPointer(XEN_TO_C_Display(arg1), 
		      XEN_TO_C_Window(arg2), 
		      &w1, &w2, &rx, &ry, &wx, &wy, &mask);
  return(XEN_LIST_8(C_TO_XEN_BOOLEAN(rtn),
		    C_TO_XEN_Window(w1),
		    C_TO_XEN_Window(w2),
		    C_TO_XEN_INT(rx),
		    C_TO_XEN_INT(ry),
		    C_TO_XEN_INT(wx),
		    C_TO_XEN_INT(wy),
		    C_TO_XEN_ULONG((unsigned long)mask)));
}

static XEN gxm_XQueryKeymap(XEN arg1)
{
  #define H_XQueryKeymap "XQueryKeymap(display) returns a bit vector for the logical state of the keyboard, where each bit \
set to 1 indicates that the corresponding key is currently pressed down."
  /* DIFF: XQueryKeymap omits keys -> (list val keys)
   */
  char keys[32];
  int val, i, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryKeymap", "Display*");
  val = XQueryKeymap(XEN_TO_C_Display(arg1), keys);
  loc = xm_protect(lst);
  for (i = 31; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_INT((int)keys[i]), lst);
  xm_unprotect_at(loc);
  return(XEN_CONS(C_TO_XEN_INT(val), lst));
}

static XEN gxm_XQueryExtension(XEN arg1, XEN arg2)
{
  #define H_XQueryExtension "Bool XQueryExtension(dpy, name) gets extension version information"
  /* DIFF: XQueryExtension dpy name [op er er] -> (list val op er er)
   */
  int op, err1, err2, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryExtension", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XQueryExtension", "char*");
  val = XQueryExtension(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), &op, &err1, &err2);
  return(XEN_LIST_4(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_INT(op),
		    C_TO_XEN_INT(err1),
		    C_TO_XEN_INT(err2)));
}

static XEN gxm_XQueryColors(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XQueryColors "XQueryColors(display, colormap, defs_in_out, ncolors)"
  int i, len, rtn;
  XEN lst;
  XColor *cols;
  XColor *col;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryColors", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XQueryColors", "Colormap");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XQueryColors", "XColor list");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XQueryColors", "int");
  if (XEN_INTEGER_P(arg4)) len = XEN_TO_C_INT(arg4); else len = XEN_LIST_LENGTH(arg3);
  lst = XEN_COPY_ARG(arg3);
  cols = (XColor *)CALLOC(len, sizeof(XColor));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(lst)); i++, lst = XEN_CDR(lst))
    {
      if (XEN_XColor_P(XEN_CAR(lst)))
	{
	  col = XEN_TO_C_XColor(XEN_CAR(lst));
	  cols[i].pixel = col->pixel;
	}
      else XEN_ASSERT_TYPE(0, XEN_CAR(lst), i, __FUNCTION__, "an XColor");
    }
  rtn = XQueryColors(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2), cols, len);
  for (i = 0; i < len; i++)
    {
      col = XEN_TO_C_XColor(XEN_LIST_REF(arg3, i));
      col->red = cols[i].red;
      col->green = cols[i].green;
      col->blue = cols[i].blue;
      col->flags = cols[i].flags;
    }
  FREE(cols);
  return(C_TO_XEN_INT(rtn));
}

static XEN gxm_XQueryColor(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XQueryColor "XQueryColor(display, colormap, def_in_out) returns the current RGB value for the pixel in the XColor structure \
and sets the DoRed, DoGreen, DoBlue flags."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XQueryColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg3), arg3, 3, "XQueryColor", "XColor*");
  return(C_TO_XEN_INT(XQueryColor(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2), XEN_TO_C_XColor(arg3))));
}

static XEN gxm_XQueryBestTile(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XQueryBestTile "Status XQueryBestTile(display, which_screen, width, height)  returns the best or \
closest size, that is, the size that can be tiled fastest on the screen specified by which_screen."
  /* DIFF: XQueryBestTile dpy scr wid hgt [wd hg] -> (list status wd hg)
   */
  unsigned int w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryBestTile", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XQueryBestTile", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XQueryBestTile", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XQueryBestTile", "unsigned int");
  val = XQueryBestTile(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
		       XEN_TO_C_ULONG(arg3), XEN_TO_C_ULONG(arg4), &w, &h);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(w),
		    C_TO_XEN_ULONG(h)));
}

static XEN gxm_XQueryBestStipple(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XQueryBestStipple "Status XQueryBestStipple(display, which_screen, width, height)  returns the \
best or closest size, that is, the size that can be stippled fastest on the screen specified by which_screen."
  /* DIFF: XQueryBestStipple dpy scr wid hgt [wd hg] -> (list status wd hg)
   */
  unsigned int w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryBestStipple", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XQueryBestStipple", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XQueryBestStipple", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XQueryBestStipple", "unsigned int");
  val = XQueryBestStipple(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			  XEN_TO_C_ULONG(arg3), XEN_TO_C_ULONG(arg4), 
			  &w, &h);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(w),
		    C_TO_XEN_ULONG(h)));
}

static XEN gxm_XQueryBestSize(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XQueryBestSize "Status XQueryBestSize(display, class, which_screen, width, height)  returns the \
best or closest size to the specified size."
  /* DIFF: XQueryBestSize dpy cls scr wid hgt [wd hg] -> (list status wd hg)
   */
  unsigned int w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryBestSize", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XQueryBestSize", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XQueryBestSize", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XQueryBestSize", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XQueryBestSize", "unsigned int");
  val = XQueryBestSize(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_Window(arg3), 
		       XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5), 
		       &w, &h);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(w),
		    C_TO_XEN_ULONG(h)));
}

static XEN gxm_XQueryBestCursor(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XQueryBestCursor "Status XQueryBestCursor(display, d, width, height) provides a way to find \
out what size cursors are actually possible on the display."
  /* DIFF: XQueryBestCursor dpy d wid hgt [wd hg] -> (list status wd hg)
   */
  unsigned int w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryBestCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XQueryBestCursor", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XQueryBestCursor", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XQueryBestCursor", "unsigned int");
  val = XQueryBestCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			 XEN_TO_C_ULONG(arg3), XEN_TO_C_ULONG(arg4), 
			 &w, &h);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(w),
		    C_TO_XEN_ULONG(h)));
}

static XEN gxm_XQLength(XEN arg1)
{
  #define H_QLength "returns the length of the event queue for the connected display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQLength", "Display*");
  return(C_TO_XEN_INT(XQLength(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XPutImage(XEN args)
{
  #define H_XPutImage "XPutImage(display, d, gc, image, src_x, src_y, dest_x, dest_y, width, height) combines an image with a rectangle \
of the specified drawable."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XPutImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XPutImage", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XPutImage", "GC");
  XEN_ASSERT_TYPE(XEN_XImage_P(arg4), arg4, 4, "XPutImage", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XPutImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XPutImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XPutImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XPutImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg9), arg9, 9, "XPutImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg10), arg10, 10, "XPutImage", "unsigned int");
  return(C_TO_XEN_INT(XPutImage(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
				XEN_TO_C_GC(arg3), XEN_TO_C_XImage(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), 
				XEN_TO_C_INT(arg7), XEN_TO_C_INT(arg8), XEN_TO_C_ULONG(arg9), XEN_TO_C_ULONG(arg10))));
}

static XEN gxm_XPutBackEvent(XEN arg1, XEN arg2)
{
  #define H_XPutBackEvent "XPutBackEvent(display, event) pushes an event back onto the head of the display's event queue by copying the event into the queue."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XPutBackEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg2), arg2, 2, "XPutBackEvent", "XEvent*");
  return(C_TO_XEN_INT(XPutBackEvent(XEN_TO_C_Display(arg1), XEN_TO_C_XEvent(arg2))));
}

static XEN gxm_XProtocolVersion(XEN arg1)
{
  #define H_ProtocolVersion "ProtocolVersion(display) returns the major version number (11) of the X protocol associated with the connected display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XProtocolVersion", "Display*");
  return(C_TO_XEN_INT(XProtocolVersion(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XProtocolRevision(XEN arg1)
{
  #define H_ProtocolRevision "ProtocolRevision(display) returns the minor protocol revision number of the X server."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XProtocolRevision", "Display*");
  return(C_TO_XEN_INT(XProtocolRevision(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XPlanesOfScreen(XEN arg1)
{
  #define H_PlanesOfScreen "PlanesOfScreen(screen) returns the number of planes in the root window of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XPlanesOfScreen", "Screen*");
  return(C_TO_XEN_INT(XPlanesOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XPending(XEN arg1)
{
  #define H_XPending "int XPending(display) returns the number of events that have been received from the X server but have not been removed \
from the event queue."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XPending", "Display*");
  return(C_TO_XEN_INT(XPending(XEN_TO_C_Display(arg1))));
}

static XEN xm_XPeekIfEventProc = XEN_FALSE;
static Bool gxm_XPeekIfEventProc(Display *dpy, XEvent *e, XtPointer p)
{
  return(XEN_TO_C_BOOLEAN(XEN_CALL_3(xm_XPeekIfEventProc, C_TO_XEN_Display(dpy), C_TO_XEN_XEvent(e), (XEN)(p), __FUNCTION__)));
}

static XEN gxm_XPeekIfEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XPeekIfEvent "XPeekIfEvent(display, predicate, arg) returns only when the specified predicate procedure returns #t for an event."
  /* DIFF: XPeekIfEvent dpy [evrtn] proc ptr -> (list val evrtn)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XPeekIfEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 3), arg2, 2, "XPeekIfEvent", "(Bool_Proc dpy ev data)");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XPeekIfEvent(XEN_TO_C_Display(arg1), 
		     e, 
		     (Bool (*)(Display *d, XEvent *ev, char *p))gxm_XPeekIfEventProc, /* C++ insists on the cast */
		     (XPointer)arg3);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XPeekEvent(XEN arg1)
{
  #define H_XPeekEvent "XPeekEvent(display) returns the first event from the event queue, but it does not remove the event from the queue."
  /* DIFF: XPeekEvent dpy [ev] -> (list int event)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XPeekEvent", "Display*");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XPeekEvent(XEN_TO_C_Display(arg1), e);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XParseGeometry(XEN arg1)
{
  #define H_XParseGeometry "int XParseGeometry(parsestring) returns a bitmask that \
indicates which of the four values (width, height, xoffset, and yoffset) were actually found in the string and whether the x and y values are negative. "
  /* DIFF: XParseGeometry str [x y w h] -> (list bit x y w h)
   */
  int x, y, val;
  unsigned int w, h;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XParseGeometry", "char*");
  val = XParseGeometry(XEN_TO_C_STRING(arg1), &x, &y, &w, &h);
  return(XEN_LIST_5(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(x),
		    C_TO_XEN_INT(y),
		    C_TO_XEN_INT(w),
		    C_TO_XEN_INT(h)));
}

static XEN gxm_XParseColor(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XParseColor "Status XParseColor(display, colormap, spec, exact_def_return) looks up the string name of a color with respect \
to the screen associated with the specified colormap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XParseColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XParseColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XParseColor", "char*");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg4), arg4, 4, "XParseColor", "XColor");
  return(C_TO_XEN_INT(XParseColor(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2), XEN_TO_C_STRING(arg3), XEN_TO_C_XColor(arg4))));
}

static XEN gxm_XNoOp(XEN arg1)
{
  #define H_XNoOp "XNoOp(dpy) sends the server a no-op for exercise"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XNoOp", "Display*");
  return(C_TO_XEN_INT(XNoOp(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XNextEvent(XEN arg1)
{
  #define H_XNextEvent "XNextEvent(display) copies the first event from the event queue into the specified XEvent structure \
and then removes it from the queue."
  /* DIFF: XNextEvent dpy [ev] -> (list int event)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XNextEvent", "Display*");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XNextEvent(XEN_TO_C_Display(arg1), e);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XMoveWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XMoveWindow "XMoveWindow(display, w, x, y) moves the specified window to the specified x and y coordinates, but it does not \
change the window's size, raise the window, or change the mapping state of the window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMoveWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XMoveWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XMoveWindow", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XMoveWindow", "int");
  return(C_TO_XEN_INT(XMoveWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4))));
}

static XEN gxm_XMoveResizeWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XMoveResizeWindow "XMoveResizeWindow(display, w, x, y, width, height) changes the size and location of the specified window without raising it."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMoveResizeWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XMoveResizeWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XMoveResizeWindow", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XMoveResizeWindow", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XMoveResizeWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XMoveResizeWindow", "unsigned int");
  return(C_TO_XEN_INT(XMoveResizeWindow(XEN_TO_C_Display(arg1), 
					XEN_TO_C_Window(arg2), 
					XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
					XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6))));
}

static XEN gxm_XMinCmapsOfScreen(XEN arg1)
{
  #define H_MinCmapsOfScreen "returns the minimum number of installed colormaps supported by the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XMinCmapsOfScreen", "Screen*");
  return(C_TO_XEN_INT(XMinCmapsOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XMaxCmapsOfScreen(XEN arg1)
{
  #define H_MaxCmapsOfScreen "returns the maximum number of installed colormaps supported by the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XMaxCmapsOfScreen", "Screen*");
  return(C_TO_XEN_INT(XMaxCmapsOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XMaskEvent(XEN arg1, XEN arg2)
{
  #define H_XMaskEvent "XMaskEvent(display, event_mask) searches the event queue for the events associated with the specified mask."
  /* DIFF: XMaskEvent dpy mask [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMaskEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XMaskEvent", "long");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XMaskEvent(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), e);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XMapWindow(XEN arg1, XEN arg2)
{
  #define H_XMapWindow "XMapWindow(display, w) maps the window and all of its subwindows that have had map requests."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMapWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XMapWindow", "Window");
  return(C_TO_XEN_INT(XMapWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XMapSubwindows(XEN arg1, XEN arg2)
{
  #define H_XMapSubwindows "XMapSubwindows(display, w) maps all subwindows for a specified window in top-to-bottom stacking order."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMapSubwindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XMapSubwindows", "Window");
  return(C_TO_XEN_INT(XMapSubwindows(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XMapRaised(XEN arg1, XEN arg2)
{
  #define H_XMapRaised "XMapRaised(display, w) maps the window and all of its subwindows that have had map requests, and raises the \
specified window to the top of the stack."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMapRaised", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XMapRaised", "Window");
  return(C_TO_XEN_INT(XMapRaised(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XLowerWindow(XEN arg1, XEN arg2)
{
  #define H_XLowerWindow "XLowerWindow(display, w) lowers the specified window to the bottom of the stack so that it does not obscure any sibling windows."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLowerWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XLowerWindow", "Window");
  return(C_TO_XEN_INT(XLowerWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XLookupColor(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XLookupColor "Status XLookupColor(display, colormap, color_name, exact_def_return, screen_def_return) looks up the string name \
of a color with respect to the screen associated with the specified colormap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLookupColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XLookupColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XLookupColor", "char*");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg4), arg4, 4, "XLookupColor", "XColor*");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg5), arg5, 5, "XLookupColor", "XColor*");
  return(C_TO_XEN_INT(XLookupColor(XEN_TO_C_Display(arg1), 
				   XEN_TO_C_Colormap(arg2), 
				   XEN_TO_C_STRING(arg3), 
				   XEN_TO_C_XColor(arg4), XEN_TO_C_XColor(arg5))));
}

static XEN gxm_XKillClient(XEN arg1, XEN arg2)
{
  #define H_XKillClient "XKillClient(display, resource) forces a close-down of the client that created the resource"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XKillClient", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XKillClient", "XID");
  return(C_TO_XEN_INT(XKillClient(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XKeysymToKeycode(XEN arg1, XEN arg2)
{
  #define H_XKeysymToKeycode "KeyCode XKeysymToKeycode(display, keysym)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XKeysymToKeycode", "Display*");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg2), arg2, 2, "XKeysymToKeycode", "KeySym");
  return(C_TO_XEN_KeyCode(XKeysymToKeycode(XEN_TO_C_Display(arg1), XEN_TO_C_KeySym(arg2))));
}

static XEN gxm_XInstallColormap(XEN arg1, XEN arg2)
{
  #define H_XInstallColormap "XInstallColormap(display, colormap) installs the specified colormap for its associated screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XInstallColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XInstallColormap", "Colormap");
  return(C_TO_XEN_INT(XInstallColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2))));
}

static XEN gxm_XImageByteOrder(XEN arg1)
{
  #define H_ImageByteOrder "specifies the required byte order for images for each scanline unit in XY format (bitmap) or for each pixel value in Z format."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XImageByteOrder", "Display*");
  return(C_TO_XEN_INT(XImageByteOrder(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XIfEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XIfEvent "XIfEvent(display, predicate, arg) completes only when the specified predicate procedure returns #t for \
an event, which indicates an event in the queue matches."
  /* DIFF: XIfEvent dpy [ev] proc ptr -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XIfEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 3), arg2, 2, "XIfEvent", "(Bool_Proc dpy ev data)");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XIfEvent(XEN_TO_C_Display(arg1), 
		 e, 
		 (Bool (*)(Display *d, XEvent *e, char *p))gxm_XPeekIfEventProc, 
		 (char *)arg3);
  return(XEN_LIST_2(C_TO_XEN_INT(val), C_TO_XEN_XEvent_OBJ(e)));
}

static XEN gxm_XHeightOfScreen(XEN arg1)
{
  #define H_HeightOfScreen "XHeightOfScreen(screen) returns the height of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XHeightOfScreen", "Screen*");
  return(C_TO_XEN_INT(XHeightOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XHeightMMOfScreen(XEN arg1)
{
  #define H_HeightMMOfScreen "XHeightMMOfScreen(screen) returns the height of the specified screen in millimeters."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XHeightMMOfScreen", "Screen*");
  return(C_TO_XEN_INT(XHeightMMOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XGrabServer(XEN arg1)
{
  #define H_XGrabServer "XGrabServer(display) disables processing of requests and close downs on all other connections than the one this request arrived on."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGrabServer", "Display*");
  return(C_TO_XEN_INT(XGrabServer(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XGrabPointer(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XGrabPointer "int XGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, time) \
actively grabs control of the pointer and returns GrabSuccess if the grab was successful."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGrabPointer", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGrabPointer", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XGrabPointer", "Bool");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XGrabPointer", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XGrabPointer", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XGrabPointer", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg7), arg7, 7, "XGrabPointer", "Window");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg8), arg8, 8, "XGrabPointer", "Cursor");
  XEN_ASSERT_TYPE(XEN_Time_P(arg9), arg9, 9, "XGrabPointer", "Time");
  return(C_TO_XEN_INT(XGrabPointer(XEN_TO_C_Display(arg1), 
				   XEN_TO_C_Window(arg2), 
				   XEN_TO_C_BOOLEAN(arg3), 
				   XEN_TO_C_ULONG(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), 
				   XEN_TO_C_Window(arg7), XEN_TO_C_Cursor(arg8), 
				   XEN_TO_C_Time(arg9))));
}

static XEN gxm_XGrabKeyboard(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XGrabKeyboard "int XGrabKeyboard(display, grab_window, owner_events, pointer_mode, keyboard_mode, time) actively grabs control of \
the keyboard and generates FocusIn and FocusOut events."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGrabKeyboard", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGrabKeyboard", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XGrabKeyboard", "Bool");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XGrabKeyboard", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XGrabKeyboard", "int");
  XEN_ASSERT_TYPE(XEN_Time_P(arg6), arg6, 6, "XGrabKeyboard", "Time");
  return(C_TO_XEN_INT(XGrabKeyboard(XEN_TO_C_Display(arg1), 
				    XEN_TO_C_Window(arg2), 
				    XEN_TO_C_BOOLEAN(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				    XEN_TO_C_Time(arg6))));
}

static XEN gxm_XGrabKey(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XGrabKey "XGrabKey(display, keycode, modifiers, grab_window, owner_events, pointer_mode, keyboard_mode) establishes a passive \
grab on the keyboard."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGrabKey", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XGrabKey", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XGrabKey", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg4), arg4, 4, "XGrabKey", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg5), arg5, 5, "XGrabKey", "Bool");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XGrabKey", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XGrabKey", "int");
  return(C_TO_XEN_INT(XGrabKey(XEN_TO_C_Display(arg1), 
			       XEN_TO_C_INT(arg2), XEN_TO_C_ULONG(arg3), 
			       XEN_TO_C_Window(arg4), 
			       XEN_TO_C_BOOLEAN(arg5), XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XGrabButton(XEN args)
{
  #define H_XGrabButton "XGrabButton(display, button, modifiers, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor) \
establishes a passive grab."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGrabButton", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XGrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XGrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg4), arg4, 4, "XGrabButton", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg5), arg5, 5, "XGrabButton", "Bool");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XGrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XGrabButton", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XGrabButton", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg9), arg9, 9, "XGrabButton", "Window");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg10), arg10, 10, "XGrabButton", "Cursor");
  return(C_TO_XEN_INT(XGrabButton(XEN_TO_C_Display(arg1), 
				  XEN_TO_C_ULONG(arg2), XEN_TO_C_ULONG(arg3), 
				  XEN_TO_C_Window(arg4), XEN_TO_C_BOOLEAN(arg5), 
				  XEN_TO_C_ULONG(arg6), XEN_TO_C_INT(arg7), 
				  XEN_TO_C_INT(arg8), 
				  XEN_TO_C_Window(arg9), XEN_TO_C_Cursor(arg10))));
}

static XEN gxm_XGetWindowAttributes(XEN arg1, XEN arg2)
{ 
  #define H_XGetWindowAttributes "Status XGetWindowAttributes(display, w) returns the current attributes for the \
specified window to an XWindowAttributes structure."
  /* DIFF: XGetWindowAttributes omits and rtns arg3 
   */
  XWindowAttributes *w;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetWindowAttributes", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetWindowAttributes", "Window");
  w = (XWindowAttributes *)CALLOC(1, sizeof(XWindowAttributes));
  XGetWindowAttributes(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), w);
  return(C_TO_XEN_XWindowAttributes(w));
}

static XEN gxm_XGetWindowProperty(XEN args)
{
  #define H_XGetWindowProperty "int XGetWindowProperty(display, w, property, long_offset, long_length, delete, req_type) \
returns the actual type of the property; the actual format of the property; the \
number of 8-bit, 16-bit, or 32-bit items transferred; the number of bytes remaining to be read in the property; and a pointer to the data \
actually returned."
  /* DIFF: XGetWindowProperty omit trailing 5 args, rtn as list
   */
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; 
  Atom a;
  int ret, val;
  unsigned long len, bytes;
  unsigned char *data;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetWindowProperty", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetWindowProperty", "Window");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XGetWindowProperty", "Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XGetWindowProperty", "long");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XGetWindowProperty", "long");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg6), arg6, 6, "XGetWindowProperty", "Bool");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg7), arg7, 7, "XGetWindowProperty", "Atom");
  val = XGetWindowProperty(XEN_TO_C_Display(arg1), 
			   XEN_TO_C_Window(arg2), 
			   XEN_TO_C_Atom(arg3), 
			   XEN_TO_C_INT(arg4), 
			   XEN_TO_C_INT(arg5), 
			   XEN_TO_C_BOOLEAN(arg6), 
			   XEN_TO_C_Atom(arg7), 
			   &a, &ret, &len, &bytes, &data);
  return(XEN_LIST_6(C_TO_XEN_INT(val),
		    C_TO_XEN_Atom(a),
		    C_TO_XEN_INT(ret),
		    C_TO_XEN_ULONG(len),
		    C_TO_XEN_ULONG(bytes),
		    C_TO_XEN_STRING((char *)data)));
}

static XEN gxm_XGetTransientForHint(XEN arg1, XEN arg2)
{
  #define H_XGetTransientForHint "Status XGetTransientForHint(display, w) returns the WM_TRANSIENT_FOR property for the specified window."
  /* DIFF: XGetTransientForHint omit and rtn last arg
   */
  Window w;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetTransientForHint", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetTransientForHint", "Window");
  val = XGetTransientForHint(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &w);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_Window(w)));
}

static XEN gxm_XGetScreenSaver(XEN arg1)
{
  #define H_XGetScreenSaver "XGetScreenSaver(display) gets the current screen saver values."
  /* DIFF: XGetScreenSaver omit and rtn last 4 args
   */
  int a, b, c ,d, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetScreenSaver", "Display*");
  val = XGetScreenSaver(XEN_TO_C_Display(arg1), &a, &b, &c, &d);
  return(XEN_LIST_5(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(a),
		    C_TO_XEN_INT(b),
		    C_TO_XEN_INT(c),
		    C_TO_XEN_INT(d)));
}

static XEN gxm_XGetPointerMapping(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetPointerMapping "int XGetPointerMapping(display, ignored, len) returns the current mapping of the pointer."
  /* DIFF: XGetPointerMapping ignores arg2, returns list
   * (|XGetPointerMapping (|XtDisplay (cadr (main-widgets))) 0 3)
   */
  int i, len, loc, rtn;
  unsigned char *map;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetPointerMapping", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XGetPointerMapping", "int");
  len = XEN_TO_C_INT(arg3);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg3, 3, "XGetPointerMapping", "positive integer");
  map = (unsigned char *)CALLOC(len, sizeof(unsigned char));
  rtn = XGetPointerMapping(XEN_TO_C_Display(arg1), map, len);
  if (len > rtn) len = rtn;
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_INT((int)(map[i])), lst);
  FREE(map);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XGetPointerControl(XEN arg1)
{
  #define H_XGetPointerControl "XGetPointerControl(display) \
returns the pointer's current acceleration multiplier and acceleration threshold."
  /* DIFF: XGetPointerControl omits and return last 3 args
   */
  int val, num, den, thresh;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetPointerControl", "Display*");
  val = XGetPointerControl(XEN_TO_C_Display(arg1), &num, &den, &thresh);
  return(XEN_LIST_4(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(num),
		    C_TO_XEN_INT(den),
		    C_TO_XEN_INT(thresh)));
}

static XEN gxm_XGetKeyboardControl(XEN arg1)
{
  #define H_XGetKeyboardControl "XGetKeyboardControl(display) returns the current control values for the keyboard \
to the XKeyboardState structure."
  /* DIFF: XGetKeyboardControl omits arg2 and rtns list of fields
   */
  XKeyboardState ks;
  XEN v;
  XEN *velts;
  int i, loc;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetKeyboardControl", "Display*");
  XGetKeyboardControl(XEN_TO_C_Display(arg1), &ks);
  v = XEN_MAKE_VECTOR(32, XEN_ZERO);
  loc = xm_protect(v);
  velts = XEN_VECTOR_ELEMENTS(v);
  for (i = 0; i < 32; i++)
    velts[i] = C_TO_XEN_INT((int)(ks.auto_repeats[i]));
  xm_unprotect_at(loc);
  return(XEN_LIST_7(C_TO_XEN_INT(ks.key_click_percent),
		    C_TO_XEN_INT(ks.bell_percent),
		    C_TO_XEN_INT(ks.bell_pitch),
		    C_TO_XEN_INT(ks.bell_duration),
		    C_TO_XEN_INT(ks.led_mask),
		    C_TO_XEN_INT(ks.global_auto_repeat),
		    v));
}

static XEN gxm_XGetInputFocus(XEN arg1)
{
  #define H_XGetInputFocus "XGetInputFocus(display) returns the focus window and the current focus state."
  /* DIFF: XGetInputFocus omit and rtn last 2 args
   */
  Window w;
  int r, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetInputFocus", "Display*");
  val = XGetInputFocus(XEN_TO_C_Display(arg1), &w, &r);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_Window(w),
		    C_TO_XEN_INT(r)));
}

static XEN gxm_XGetIconName(XEN arg1, XEN arg2)
{
  #define H_XGetIconName "Status XGetIconName(display, w) returns the name to be displayed in the specified window's icon."
  /* DIFF: XGetIconName omits and returns arg3
   */
  char *str;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetIconName", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetIconName", "Window");
  val = XGetIconName(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &str);
  if (val == 0)
    return(XEN_FALSE);
  return(C_TO_XEN_STRING(str));
}

static XEN gxm_XGetGeometry(XEN arg1, XEN arg2)
{
  #define H_XGetGeometry "Status XGetGeometry(display, d) returns the root window and the current geometry of the drawable."
  /* DIFF: XGetGeometry omits last 7 args and returns list
   */
  unsigned int wr, hr, br, dr;
  int xr, yr, val;
  Window root;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetGeometry", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetGeometry", "Drawable");
  val = XGetGeometry(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
		     &root, &xr, &yr, &wr, &hr, &br, &dr);
  return(XEN_LIST_8(C_TO_XEN_INT(val),
		    C_TO_XEN_Window(root),
		    C_TO_XEN_INT(xr),
		    C_TO_XEN_INT(yr),
		    C_TO_XEN_ULONG(wr),
		    C_TO_XEN_ULONG(hr),
		    C_TO_XEN_ULONG(br),
		    C_TO_XEN_ULONG(dr)));
}

static XEN gxm_XGetGCValues(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetGCValues "Status XGetGCValues(display, gc, valuemask) returns the components specified by valuemask for the specified GC."
  /* DIFF: XGetGCValues omits and returns last arg
   */
  XGCValues *val;
  int rtn;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetGCValues", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XGetGCValues", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XGetGCValues", "ulong");
  val = (XGCValues *)CALLOC(1, sizeof(XGCValues));
  rtn = XGetGCValues(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_ULONG(arg3), val);
  return(XEN_LIST_2(C_TO_XEN_INT(rtn),
		    C_TO_XEN_XGCValues(val)));
}

static XEN gxm_XGetFontProperty(XEN arg1, XEN arg2)
{
  #define H_XGetFontProperty "Bool XGetFontProperty(font_struct, atom) returns the value of the specified font property. "
  /* DIFF: XGetFontProperty omits and rtns last arg
   */
  Bool val;
  unsigned long prop;
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg1), arg1, 1, "XGetFontProperty", "XFontStruct*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XGetFontProperty", "Atom");
  val = XGetFontProperty(XEN_TO_C_XFontStruct(arg1), XEN_TO_C_Atom(arg2), &prop);
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_ULONG(prop)));
}

static XEN gxm_XGetErrorText(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XGetErrorText "XGetErrorText(display, code, buffer_return, length) copies a null-terminated string describing the specified error \
code into the specified buffer."
  /* DIFF: XGetErrorText ignores arg3, returns text
   */
  char *buf;
  int len, val;
  XEN str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetErrorText", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XGetErrorText", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XGetErrorText", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg4, 4, "XGetErrorText", "positive integer");
  buf = (char *)CALLOC(len, sizeof(char));
  val = XGetErrorText(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), buf, len);
  str = C_TO_XEN_STRING(buf);
  FREE(buf);
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    str));
}

static XEN gxm_XGeometry(XEN args)
{
  #define H_XGeometry "int XGeometry(dpy, screen, position, default_position, bwidth, fwidth, fheight, xadder, yadder) calculates \
window geometry given user geometry string and default geometry"
  /* DIFF: XGetGeometry omits trailing 4 args and returns them
   */
  int x, y, w, h, val;
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGeometry", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XGeometry", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XGeometry", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XGeometry", "char*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XGeometry", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XGeometry", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XGeometry", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XGeometry", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XGeometry", "int");
  val = XGeometry(XEN_TO_C_Display(arg1), 
		  XEN_TO_C_INT(arg2), 
		  XEN_TO_C_STRING(arg3), 
		  XEN_TO_C_STRING(arg4), 
		  XEN_TO_C_ULONG(arg5), 
		  XEN_TO_C_ULONG(arg6), 
		  XEN_TO_C_ULONG(arg7), 
		  XEN_TO_C_INT(arg8), 
		  XEN_TO_C_INT(arg9), 
		  &x, &y, &w, &h);
  return(XEN_LIST_5(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(x),
		    C_TO_XEN_INT(y),
		    C_TO_XEN_INT(w),
		    C_TO_XEN_INT(h)));
}

static XEN gxm_XFreePixmap(XEN arg1, XEN arg2)
{
  #define H_XFreePixmap "XFreePixmap(display, pixmap) first deletes the association between the pixmap ID and the pixmap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreePixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg2), arg2, 2, "XFreePixmap", "Pixmap");
  return(C_TO_XEN_INT(XFreePixmap(XEN_TO_C_Display(arg1), XEN_TO_C_Pixmap(arg2))));
}

static XEN gxm_XFreeModifiermap(XEN arg1)
{
  #define H_XFreeModifiermap "XFreeModifiermap(modmap) frees the specified XModifierKeymap structure."
  XEN_ASSERT_TYPE(XEN_XModifierKeymap_P(arg1), arg1, 1, "XFreeModifiermap", "XModifierKeymap*");
  return(C_TO_XEN_INT(XFreeModifiermap(XEN_TO_C_XModifierKeymap(arg1))));
}

static XEN gxm_XFreeGC(XEN arg1, XEN arg2)
{
  #define H_XFreeGC "XFreeGC(display, gc) destroys the specified GC as well as all the associated storage."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeGC", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XFreeGC", "GC");
  return(C_TO_XEN_INT(XFreeGC(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2))));
}

static XEN gxm_XFreeFontPath(XEN arg1)
{
  #define H_XFreeFontPath "XFreeFontPath(list) frees the data allocated by XGetFontPath (a no-op in xm)."
  /* DIFF: XFreeFontPath is no-op
   */
  return(XEN_FALSE);
}

static XEN gxm_XFreeFontNames(XEN arg1)
{
  #define H_XFreeFontNames "XFreeFontNames(list) frees the array and strings returned by XListFonts or XListFontsWithInfo (a no-op in xm)."
  /* DIFF: XFreeFontNames is no-op
   */
  return(XEN_FALSE);
}

static XEN gxm_XFreeFontInfo(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XFreeFontInfo "XFreeFontInfo(names, free_info, actual_count) frees a font structure or an array of font structures, and \
optionally an array of font names (a no-op in xm)."
  /* DIFF: XFreeFontInfo is a no-op 
   */
  return(XEN_FALSE);
}

static XEN gxm_XFreeFont(XEN arg1, XEN arg2)
{
  #define H_XFreeFont "XFreeFont(display, font_struct) deletes the association between the font resource ID and the specified font and \
frees the XFontStruct structure."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeFont", "Display*");
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(arg2), arg2, 2, "XFreeFont", "XFontStruct*");
  return(C_TO_XEN_INT(XFreeFont(XEN_TO_C_Display(arg1), XEN_TO_C_XFontStruct(arg2))));
}

static XEN gxm_XFreeExtensionList(XEN arg1)
{
  /* DIFF: XFreeExtensionList is a no-op
   */
  return(XEN_FALSE);
}

static XEN gxm_XFreeCursor(XEN arg1, XEN arg2)
{
  #define H_XFreeCursor "XFreeCursor(display, cursor) deletes the association between the cursor resource ID and the specified cursor."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg2), arg2, 2, "XFreeCursor", "Cursor");
  return(C_TO_XEN_INT(XFreeCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Cursor(arg2))));
}

static XEN gxm_XFreeColors(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XFreeColors "XFreeColors(display, colormap, pixels, npixels, planes) frees the cells represented by pixels whose values are in the pixels array."
  /* DIFF: XFreeColors pixel array (arg3) is list of pixels
   */
  unsigned long *ps;
  int len, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeColors", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XFreeColors", "Colormap");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XFreeColors", "list of ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XFreeColors", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XFreeColors", "ulong");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  ps = XEN_TO_C_Pixels(arg3, len);
  val = XFreeColors(XEN_TO_C_Display(arg1), 
		    XEN_TO_C_Colormap(arg2), 
		    ps, len, 
		    XEN_TO_C_ULONG(arg5));
  FREE(ps);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XFreeColormap(XEN arg1, XEN arg2)
{
  #define H_XFreeColormap "XFreeColormap(display, colormap) deletes the association between the colormap resource ID and the colormap and \
frees the colormap storage."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFreeColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XFreeColormap", "Colormap");
  return(C_TO_XEN_INT(XFreeColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2))));
}

static XEN gxm_XFree(XEN arg1)
{
  #define H_XFree "XFree(data) is a general-purpose Xlib routine that frees the specified data."
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XFree", "void*");
  return(C_TO_XEN_INT(XFree((void *)XEN_TO_C_ULONG(arg1))));
}

static XEN gxm_XForceScreenSaver(XEN arg1, XEN arg2)
{
  #define H_XForceScreenSaver "XForceScreenSaver(display, mode) activates the screen saver"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XForceScreenSaver", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XForceScreenSaver", "int");
  return(C_TO_XEN_INT(XForceScreenSaver(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XFlush(XEN arg1)
{
  #define H_XFlush "XFlush(display) flushes the output buffer."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFlush", "Display*");
  return(C_TO_XEN_INT(XFlush(XEN_TO_C_Display(arg1))));
}


static XEN gxm_XFillRectangles(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5)
{
  #define H_XFillRectangles "XFillRectangles(display, d, gc, rectangles, nrectangles)"
  /* DIFF: XFillRectangles XRectangle* arg (arg 4) is list of XRectangles
   */
  XRectangle *pt, *pt1;
  int i, len;
  XEN arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFillRectangles", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFillRectangles", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XFillRectangles", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XFillRectangles", "list of XRectangle");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XFillRectangles", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XFillRectangles", "positive integer");
  pt = (XRectangle *)CALLOC(len, sizeof(XRectangle));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      pt1 = XEN_TO_C_XRectangle(XEN_CAR(arg4));
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
      pt[i].width = pt1->width;
      pt[i].height = pt1->height;
    }
  XFillRectangles(XEN_TO_C_Display(arg1), 
		  XEN_TO_C_Window(arg2), 
		  XEN_TO_C_GC(arg3),
		  pt, len);
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XFillRectangle(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XFillRectangle "XFillRectangle(display, d, gc, x, y, width, height)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFillRectangle", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFillRectangle", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XFillRectangle", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XFillRectangle", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XFillRectangle", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XFillRectangle", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XFillRectangle", "unsigned int");
  return(C_TO_XEN_INT(XFillRectangle(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
				     XEN_TO_C_GC(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				     XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7))));
}

static XEN gxm_XFillPolygon(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XFillPolygon "XFillPolygon(display, d, gc, points, npoints, shape, mode)"
  /* DIFF: XFillPolygon Point* arg (arg 4) is list of XPoint
   */
  XPoint *pt, *pt1;
  int i, len;
  XEN xp, arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFillPolygon", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFillPolygon", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XFillPolygon", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XFillPolygon", "list of XPoints");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XFillPolygon", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XFillPolygon", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XFillPolygon", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XFillPolygon", "positive integer");
  pt = (XPoint *)CALLOC(len, sizeof(XPoint));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      xp = XEN_CAR(arg4);
      if (!(XEN_XPoint_P(xp))) XEN_ASSERT_TYPE(0, xp, i, "XFillRegion", "XPoint");
      pt1 = XEN_TO_C_XPoint(xp);
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
    }
  XFillPolygon(XEN_TO_C_Display(arg1), 
	       XEN_TO_C_Window(arg2), 
	       XEN_TO_C_GC(arg3), 
	       pt, len, 
	       XEN_TO_C_INT(arg6), 
	       XEN_TO_C_INT(arg7));
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XFillArcs(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5)
{
  #define H_XFillArcs "XFillArcs(display, d, gc, arcs, narcs)"
  /* DIFF: XFillArcs Arc* arg (arg 4) is list of XArcs
   */
  XArc *arc;
  int i, len;
  Display *dpy;
  Drawable draw;
  GC gc;
  XEN arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFillArcs", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFillArcs", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XFillArcs", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XFillArcs", "list of XArcs");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XFillArcs", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) return(XEN_FALSE);
  dpy = XEN_TO_C_Display(arg1);
  draw = XEN_TO_C_Window(arg2);
  gc = XEN_TO_C_GC(arg3);
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      arc = XEN_TO_C_XArc(XEN_CAR(arg4));
      XFillArc(dpy, draw, gc, arc->x, arc->y, arc->width, arc->height, arc->angle1, arc->angle2);
    }
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XFillArc(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XFillArc "XFillArc(display, d, gc, x, y, width, height, angle1, angle2) fills the region described by the specified arc."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFillArc", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFillArc", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XFillArc", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XFillArc", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XFillArc", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XFillArc", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XFillArc", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XFillArc", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XFillArc", "int");
  return(C_TO_XEN_INT(XFillArc(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			       XEN_TO_C_GC(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
			       XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7), 
			       XEN_TO_C_INT(arg8), XEN_TO_C_INT(arg9))));
}

static XEN gxm_XFetchName(XEN arg1, XEN arg2)
{
  #define H_XFetchName "Status XFetchName(display, w) returns the name of the specified window."
  /* DIFF: XFetchName omits and rtns arg3
   */
  char *name;
  int val;
  XEN str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFetchName", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XFetchName", "Window");
  val = XFetchName(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &name);
  if (val == 0)
    return(XEN_FALSE);
  str = C_TO_XEN_STRING(name);
  free(name);
  return(str);
}

static XEN gxm_XEventsQueued(XEN arg1, XEN arg2)
{
  #define H_XEventsQueued "int XEventsQueued(display, mode)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XEventsQueued", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XEventsQueued", "int");
  return(C_TO_XEN_INT(XEventsQueued(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XEnableAccessControl(XEN arg1)
{
  #define H_XEnableAccessControl "XEnableAccessControl(display) enables the use of the access control list at each connection setup."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XEnableAccessControl", "Display*");
  return(C_TO_XEN_INT(XEnableAccessControl(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XDrawText(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XDrawText "XDrawText(display, d, gc, x, y, items, nitems) draws text"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawText", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawText", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawText", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawText", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawText", "int");
  XEN_ASSERT_TYPE(XEN_XTextItem_P(arg6), arg6, 6, "XDrawText", "XTextItem*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XDrawText", "int");
  return(C_TO_XEN_INT(XDrawText(XEN_TO_C_Display(arg1), 
				XEN_TO_C_Window(arg2), 
				XEN_TO_C_GC(arg3), 
				XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				XEN_TO_C_XTextItem(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XDrawString(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XDrawString "XDrawString(display, d, gc, x, y, string, length)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawString", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawString", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawString", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawString", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawString", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg6), arg6, 6, "XDrawString", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XDrawString", "int");
  return(C_TO_XEN_INT(XDrawString(XEN_TO_C_Display(arg1), 
				  XEN_TO_C_Window(arg2), 
				  XEN_TO_C_GC(arg3), 
				  XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				  XEN_TO_C_STRING(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XDrawSegments(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5)
{
  #define H_XDrawSegments "XDrawSegments(display, d, gc, segments, nsegments) draws multiple, unconnected lines. "
  /* DIFF: XDrawSegments XSegment* arg (arg 4) is list of XSegments
   */
  XSegment *pt, *pt1;
  int i, len;
  XEN arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawSegments", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawSegments", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawSegments", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XDrawSegments", "list of XSegments");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawSegments", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XDrawSegments", "positive integer");
  pt = (XSegment *)CALLOC(len, sizeof(XSegment));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      pt1 = XEN_TO_C_XSegment(XEN_CAR(arg4));
      pt[i].x1 = pt1->x1;
      pt[i].y1 = pt1->y1;
      pt[i].x2 = pt1->x2;
      pt[i].y2 = pt1->y2;
    }
  XDrawSegments(XEN_TO_C_Display(arg1), 
		XEN_TO_C_Window(arg2), 
		XEN_TO_C_GC(arg3),
		pt, len);
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XDrawRectangles(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5)
{
  #define H_XDrawRectangles "XDrawRectangles(display, d, gc, rectangles, nrectangles) draws the outlines of the specified rectangles."
  /* DIFF: XDrawRectangles XRectangle* arg (arg 4) is list of XRectangles
   */
  XRectangle *pt, *pt1;
  int i, len;
  XEN arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawRectangles", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawRectangles", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawRectangles", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XDrawRectangles", "list of XRectangles");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawRectangles", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XDrawRectangles", "positive integer");
  pt = (XRectangle *)CALLOC(len, sizeof(XRectangle));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      pt1 = XEN_TO_C_XRectangle(XEN_CAR(arg4));
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
      pt[i].width = pt1->width;
      pt[i].height = pt1->height;
    }
  XDrawRectangles(XEN_TO_C_Display(arg1), 
		  XEN_TO_C_Window(arg2), 
		  XEN_TO_C_GC(arg3),
		  pt, len);
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XDrawRectangle(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XDrawRectangle "XDrawRectangle(display, d, gc, x, y, width, height) draws the outlines of the specified rectangle."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawRectangle", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawRectangle", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawRectangle", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawRectangle", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawRectangle", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XDrawRectangle", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XDrawRectangle", "unsigned int");
  return(C_TO_XEN_INT(XDrawRectangle(XEN_TO_C_Display(arg1), 
				     XEN_TO_C_Window(arg2), 
				     XEN_TO_C_GC(arg3), 
				     XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7))));
}

static XEN gxm_XDrawPoints(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5, XEN arg6)
{
  #define H_XDrawPoints "XDrawPoints(display, d, gc, points, npoints, mode) draws multiple points."
  /* DIFF: XDrawPoints XPoint* arg (arg 4) is list of XPoints
   */
  XPoint *pt, *pt1;
  int i, len;
  XEN xp, arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawPoints", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawPoints", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawPoints", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XDrawPoints", "list of XPoints");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawPoints", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XDrawPoints", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XDrawPoints", "positive integer");
  pt = (XPoint *)CALLOC(len, sizeof(XPoint));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      xp = XEN_CAR(arg4);
      if (!(XEN_XPoint_P(xp))) XEN_ASSERT_TYPE(0, xp, i, "XDrawPoints", "XPoint");
      pt1 = XEN_TO_C_XPoint(xp);
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
    }
  XDrawPoints(XEN_TO_C_Display(arg1), 
	      XEN_TO_C_Window(arg2), 
	      XEN_TO_C_GC(arg3), 
	      pt, len, 
	      XEN_TO_C_INT(arg6));
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XDrawPoint(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XDrawPoint "XDrawPoint(display, d, gc, x, y) uses the foreground pixel and function components of the GC to draw a single \
point into the specified drawable."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawPoint", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawPoint", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawPoint", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawPoint", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawPoint", "int");
  return(C_TO_XEN_INT(XDrawPoint(XEN_TO_C_Display(arg1), 
				 XEN_TO_C_Window(arg2), 
				 XEN_TO_C_GC(arg3), 
				 XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5))));
}

static XEN gxm_XDrawLines(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5, XEN arg6)
{
  #define H_XDrawLines "XDrawLines(display, d, gc, points, npoints, mode) uses the components of the specified GC to draw npoints lines \
between each pair of points (point[i], point[i+1]) in the array of XPoint structures."
  /* DIFF: XDrawLines XPoint* arg (arg 4) is list of XPoints
   */
  XPoint *pt, *pt1;
  int i, len;
  XEN xp, arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawLines", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawLines", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawLines", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XDrawLines", "list of XPoints");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawLines", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XDrawLines", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XDrawLines", "positive integer");
  pt = (XPoint *)CALLOC(len, sizeof(XPoint));
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      xp = XEN_CAR(arg4);
      if (!(XEN_XPoint_P(xp))) XEN_ASSERT_TYPE(0, xp, i, "XDrawLines", "XPoint");
      pt1 = XEN_TO_C_XPoint(xp);
      pt[i].x = pt1->x;
      pt[i].y = pt1->y;
    }
  XDrawLines(XEN_TO_C_Display(arg1), 
	     XEN_TO_C_Window(arg2), 
	     XEN_TO_C_GC(arg3), 
	     pt, len, 
	     XEN_TO_C_INT(arg6));
  FREE(pt);
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XDrawLinesDirect(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XDrawLinesDirect "XDrawLinesDirect is the same as XDrawLines but takes an (opaque) pointer to an XPoint array"
  XPoint *pt;
  int len;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawLinesDirect", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawLinesDirect", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawLinesDirect", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XDrawLinesDirect", "array of XPoints");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawLines", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XDrawLines", "int");
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) return(XEN_FALSE);
  pt = (XPoint *)XEN_TO_C_ULONG(arg4);
  XDrawLines(XEN_TO_C_Display(arg1), 
	     XEN_TO_C_Window(arg2), 
	     XEN_TO_C_GC(arg3), 
	     pt, len, 
	     XEN_TO_C_INT(arg6));
  return(C_TO_XEN_INT(len));
}

static XEN gxm_Vector2XPoints(XEN arg1)
{
  #define H_vector2XPoints "(vector->XPoints vect) packages point data in vect as (opaque) array of XPoints"
  int i, j, len;
  XEN *velts;
  /* vector assumed to be sequence of x y pairs (not XPoints from local view)
   */
  XPoint *pt;
  XEN_ASSERT_TYPE(XEN_VECTOR_P(arg1), arg1, XEN_ONLY_ARG, "vector->XPoints", "vector of x,y values");
  len = XEN_VECTOR_LENGTH(arg1) / 2;
  if (len <= 0) XEN_ASSERT_TYPE(0, arg1, 1, "vector->XPoints", "positive integer");
  velts = XEN_VECTOR_ELEMENTS(arg1);
  pt = (XPoint *)CALLOC(len, sizeof(XPoint));
  for (i = 0, j = 0; i < len; i++, j += 2)
    {
      pt[i].x = XEN_TO_C_INT(velts[j]);
      pt[i].y = XEN_TO_C_INT(velts[j + 1]);
    }
  return(C_TO_XEN_ULONG((unsigned long)pt));
}

static XEN gxm_FreeXPoints(XEN arg1)
{
  #define H_freeXPoints "(freeXPoints vect) frees an (opaque) XPoint array created by vector->Xpoints"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, XEN_ONLY_ARG, "freeXPoints", "opaque XPoint array");
  FREE((void *)(XEN_TO_C_ULONG(arg1)));
  return(XEN_FALSE);
}


static XEN gxm_MoveXPoints(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_moveXPoints "(moveXPoints vect len dx dy) moves an XPoint array created by vector->Xpoints"
  XPoint *pt;
  int i, len, x, y;
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, XEN_ARG_1, "moveXPoints", "opaque XPoint array");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, XEN_ARG_2, "moveXPoints", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, XEN_ARG_3, "moveXPoints", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, XEN_ARG_4, "moveXPoints", "int");
  pt = ((XPoint *)(XEN_TO_C_ULONG(arg1)));
  len = XEN_TO_C_INT(arg2);
  x = XEN_TO_C_INT(arg3);
  y = XEN_TO_C_INT(arg4);
  for (i = 0; i < len; i++)
    {
      pt[i].x += x;
      pt[i].y += y;
    }
  return(XEN_FALSE);
}


static XEN gxm_XDrawLine(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XDrawLine "XDrawLine(display, d, gc, x1, y1, x2, y2) uses the components of the specified GC to draw a line between the \
specified set of points (x1, y1) and (x2, y2)."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawLine", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawLine", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawLine", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawLine", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawLine", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XDrawLine", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XDrawLine", "int");
  return(C_TO_XEN_INT(XDrawLine(XEN_TO_C_Display(arg1), 
				XEN_TO_C_Window(arg2), 
				XEN_TO_C_GC(arg3), 
				XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XDrawImageString(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XDrawImageString "XDrawImageString(display, d, gc, x, y, string, length)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawImageString", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawImageString", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawImageString", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawImageString", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawImageString", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg6), arg6, 6, "XDrawImageString", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XDrawImageString", "int");
  return(C_TO_XEN_INT(XDrawImageString(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Window(arg2), 
				       XEN_TO_C_GC(arg3), 
				       XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_STRING(arg6), XEN_TO_C_INT(arg7))));
}

static XEN gxm_XDrawArcs(XEN arg1, XEN arg2, XEN arg3, XEN larg4, XEN arg5)
{
  #define H_XDrawArcs "XDrawArcs(display, d, gc, arcs, narcs) draws multiple circular or elliptical arcs."
  /* DIFF: XDrawArcs Arc* arg (arg 4) is list of XArcs
   */
  XArc *arc;
  int i, len;
  Display *dpy;
  Drawable draw;
  GC gc;
  XEN arg4;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawArcs", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawArcs", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawArcs", "GC");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg4), larg4, 4, "XDrawArcs", "list of XArcs");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawArcs", "int");
  arg4 = XEN_COPY_ARG(larg4);
  len = XEN_TO_C_INT(arg5);
  dpy = XEN_TO_C_Display(arg1);
  draw = XEN_TO_C_Window(arg2);
  gc = XEN_TO_C_GC(arg3);
  for (i = 0; (i < len) && (XEN_NOT_NULL_P(arg4)); i++, arg4 = XEN_CDR(arg4))
    {
      arc = XEN_TO_C_XArc(XEN_CAR(arg4));
      XDrawArc(dpy, draw, gc, arc->x, arc->y, arc->width, arc->height, arc->angle1, arc->angle2);
    }
  return(C_TO_XEN_INT(len));
}

static XEN gxm_XDrawArc(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XDrawArc "XDrawArc(display, d, gc, x, y, width, height, angle1, angle2) draws a single circular or elliptical arc."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDrawArc", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDrawArc", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg3), arg3, 3, "XDrawArc", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XDrawArc", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XDrawArc", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XDrawArc", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XDrawArc", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XDrawArc", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XDrawArc", "int");
  return(C_TO_XEN_INT(XDrawArc(XEN_TO_C_Display(arg1), 
			       XEN_TO_C_Window(arg2), 
			       XEN_TO_C_GC(arg3), 
			       XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
			       XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7), XEN_TO_C_INT(arg8), XEN_TO_C_INT(arg9))));
}

static XEN gxm_XDisplayWidthMM(XEN arg1, XEN arg2)
{
  #define H_DisplayWidthMM "DisplayWidthMM(display, screen_number) returns the width of the specified screen in millimeters."
  #define H_XDisplayWidthMM "XDisplayWidthMM(display, screen_number) returns the width of the specified screen in millimeters."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayWidthMM", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayWidthMM", "int");
  return(C_TO_XEN_INT(XDisplayWidthMM(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayWidth(XEN arg1, XEN arg2)
{
  #define H_DisplayWidth "DisplayWidth(display, screen_number) returns the width of the screen in pixels."
  #define H_XDisplayWidth "XDisplayWidth(display, screen_number) returns the width of the screen in pixels."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayWidth", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayWidth", "int");
  return(C_TO_XEN_INT(XDisplayWidth(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayPlanes(XEN arg1, XEN arg2)
{
  #define H_DisplayPlanes "DisplayPlanes(display, screen_number) returns the depth of the root window of the specified screen."
  #define H_XDisplayPlanes "XDisplayPlanes(display, screen_number) returns the depth of the root window of the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayPlanes", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayPlanes", "int");
  return(C_TO_XEN_INT(XDisplayPlanes(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayKeycodes(XEN arg1)
{
  #define H_XDisplayKeycodes "XDisplayKeycodes(display) returns the min-keycodes and max-keycodes supported by the specified display."
  /* DIFF: XDisplayKeycodes omit and rtn arg 2 and 3
   */
  int m1, m2, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayKeycodes", "Display*");
  val = XDisplayKeycodes(XEN_TO_C_Display(arg1), &m1, &m2);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_INT(m1),
		    C_TO_XEN_INT(m2)));
}

static XEN gxm_XDisplayHeightMM(XEN arg1, XEN arg2)
{
  #define H_DisplayHeightMM "DisplayHeightMM(display, screen_number) returns the height of the specified screen in millimeters."
  #define H_XDisplayHeightMM "XDisplayHeightMM(display, screen_number) returns the height of the specified screen in millimeters."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayHeightMM", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayHeightMM", "int");
  return(C_TO_XEN_INT(XDisplayHeightMM(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayHeight(XEN arg1, XEN arg2)
{
  #define H_DisplayHeight "DisplayHeight(display, screen_number) returns the height of the specified screen in pixels."
  #define H_XDisplayHeight "XDisplayHeight(display, screen_number) returns the height of the specified screen in pixels."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayHeight", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayHeight", "int");
  return(C_TO_XEN_INT(XDisplayHeight(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayCells(XEN arg1, XEN arg2)
{
  #define H_DisplayCells "DisplayCells(display, screen_number) returns the number of entries in the default colormap."
  #define H_XDisplayCells "XDisplayCells(display, screen_number) returns the number of entries in the default colormap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayCells", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDisplayCells", "int");
  return(C_TO_XEN_INT(XDisplayCells(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisableAccessControl(XEN arg1)
{
  #define H_XDisableAccessControl "XDisableAccessControl(display) disables the use of the access control list at each connection setup."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisableAccessControl", "Display*");
  return(C_TO_XEN_INT(XDisableAccessControl(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XDoesSaveUnders(XEN arg1)
{
  #define H_DoesSaveUnders "DoesSaveUnders(screen) returns a Boolean value indicating whether the screen supports save unders."
  #define H_XDoesSaveUnders "XDoesSaveUnders(screen) returns a Boolean value indicating whether the screen supports save unders."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDoesSaveUnders", "Screen*");
  return(C_TO_XEN_BOOLEAN(XDoesSaveUnders(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDoesBackingStore(XEN arg1)
{
  #define H_DoesBackingStore "DoesBackingStore(screen) returns WhenMapped, NotUseful,or Always,which indicate whether the screen supports backing stores."
  #define H_XDoesBackingStore "XDoesBackingStore(screen) returns WhenMapped, NotUseful,or Always,which indicate whether the screen supports backing stores."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDoesBackingStore", "Screen*");
  return(C_TO_XEN_BOOLEAN(XDoesBackingStore(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDestroySubwindows(XEN arg1, XEN arg2)
{
  #define H_XDestroySubwindows "XDestroySubwindows(display, w) destroys all inferior windows of the specified window, in bottom-to-top stacking order."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDestroySubwindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDestroySubwindows", "Window");
  return(C_TO_XEN_INT(XDestroySubwindows(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XDestroyWindow(XEN arg1, XEN arg2)
{
  #define H_XDestroyWindow "XDestroyWindow(display, w) destroys the specified window as well as all of its subwindows and causes the X server \
to generate a DestroyNotify event for each window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDestroyWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDestroyWindow", "Window");
  return(C_TO_XEN_INT(XDestroyWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XDeleteProperty(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XDeleteProperty "XDeleteProperty(display, w, property) deletes the specified property only if the property was defined on the specified \
window and causes the X server to generate a PropertyNotify event on the window unless the property does not exist."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDeleteProperty", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDeleteProperty", "Window");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XDeleteProperty", "Atom");
  return(C_TO_XEN_INT(XDeleteProperty(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Atom(arg3))));
}

static XEN gxm_XDefineCursor(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XDefineCursor "XDefineCursor(display, w, cursor)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefineCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XDefineCursor", "Window");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg3), arg3, 3, "XDefineCursor", "Cursor");
  return(C_TO_XEN_INT(XDefineCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Cursor(arg3))));
}

static XEN gxm_XDefaultScreen(XEN arg1)
{
  #define H_XDefaultScreen "XDefaultScreen(display)"
  #define H_DefaultScreenOfDisplay "returns the default screen of the specified display."
  #define H_XDefaultScreenOfDisplay "returns the default screen of the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultScreen", "Display*");
  return(C_TO_XEN_INT(XDefaultScreen(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XDefaultDepthOfScreen(XEN arg1)
{
  #define H_DefaultDepthOfScreen "returns the default depth of the root window of the specified screen."
  #define H_XDefaultDepthOfScreen "returns the default depth of the root window of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDefaultDepthOfScreen", "Screen*");
  return(C_TO_XEN_INT(XDefaultDepthOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultDepth(XEN arg1, XEN arg2)
{
  #define H_DefaultDepth "returns the depth (number of planes) of the default root window for the specified screen."
  #define H_XDefaultDepth "returns the depth (number of planes) of the default root window for the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultDepth", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDefaultDepth", "int");
  return(C_TO_XEN_INT(XDefaultDepth(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XCopyPlane(XEN args)
{
  #define H_XCopyPlane "XCopyPlane(display, src, dest, gc, src_x, src_y, width, height, dest_x, dest_y, plane) uses a single bit plane of the \
specified source rectangle combined with the specified GC to modify the specified rectangle of dest."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCopyPlane", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCopyPlane", "Drawable");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XCopyPlane", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg4), arg4, 4, "XCopyPlane", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XCopyPlane", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XCopyPlane", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCopyPlane", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg8), arg8, 8, "XCopyPlane", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XCopyPlane", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg10), arg10, 10, "XCopyPlane", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg11), arg11, 11, "XCopyPlane", "ulong");
  return(C_TO_XEN_INT(XCopyPlane(XEN_TO_C_Display(arg1), 
				 XEN_TO_C_Window(arg2), 
				 XEN_TO_C_Window(arg3), 
				 XEN_TO_C_GC(arg4), 
				 XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), XEN_TO_C_ULONG(arg7), 
				 XEN_TO_C_ULONG(arg8), XEN_TO_C_INT(arg9), 
				 XEN_TO_C_INT(arg10), XEN_TO_C_ULONG(arg11))));
}

static XEN gxm_XCopyGC(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XCopyGC "XCopyGC(display, src, valuemask, dest) copies the specified components from the source GC to the destination GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCopyGC", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XCopyGC", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XCopyGC", "ulong");
  XEN_ASSERT_TYPE(XEN_GC_P(arg4), arg4, 4, "XCopyGC", "GC");
  return(C_TO_XEN_INT(XCopyGC(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_GC(arg4))));
}

static XEN gxm_XCopyArea(XEN args)
{
  #define H_XCopyArea "XCopyArea(display, src, dest, gc, src_x, src_y, width, height, dest_x, dest_y) combines the specified rectangle of src \
with the specified rectangle of dest."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCopyArea", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCopyArea", "Drawable");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XCopyArea", "Drawable");
  XEN_ASSERT_TYPE(XEN_GC_P(arg4), arg4, 4, "XCopyArea", "GC");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XCopyArea", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XCopyArea", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCopyArea", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg8), arg8, 8, "XCopyArea", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XCopyArea", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg10), arg10, 10, "XCopyArea", "int");
  return(C_TO_XEN_INT(XCopyArea(XEN_TO_C_Display(arg1), 
				XEN_TO_C_Window(arg2), 
				XEN_TO_C_Window(arg3), 
				XEN_TO_C_GC(arg4), 
				XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), XEN_TO_C_ULONG(arg7), 
				XEN_TO_C_ULONG(arg8), XEN_TO_C_INT(arg9), XEN_TO_C_INT(arg10))));
}

static XEN gxm_XConvertSelection(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XConvertSelection "void XConvertSelection(display, selection, target, property, requestor, time)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XConvertSelection", "Display*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XConvertSelection", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XConvertSelection", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg4), arg4, 4, "XConvertSelection", "Atom");
  XEN_ASSERT_TYPE(XEN_Window_P(arg5), arg5, 5, "XConvertSelection", "Window");
  XEN_ASSERT_TYPE(XEN_Time_P(arg6), arg6, 6, "XConvertSelection", "Time");
  return(C_TO_XEN_INT(XConvertSelection(XEN_TO_C_Display(arg1), 
					XEN_TO_C_Atom(arg2), XEN_TO_C_Atom(arg3), XEN_TO_C_Atom(arg4), 
					XEN_TO_C_Window(arg5), XEN_TO_C_Time(arg6))));
}

static XEN gxm_XConnectionNumber(XEN arg1)
{
  #define H_ConnectionNumber "returns a connection number for the specified display."
  #define H_XConnectionNumber "returns a connection number for the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XConnectionNumber", "Display*");
  return(C_TO_XEN_INT(XConnectionNumber(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XConfigureWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XConfigureWindow "XConfigureWindow(display, w, value_mask, values) uses the values specified in the XWindowChanges structure to \
reconfigure a window's size, position, border, and stacking order."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XConfigureWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XConfigureWindow", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XConfigureWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XWindowChanges_P(arg4), arg4, 4, "XConfigureWindow", "XWindowChanges*");
  return(C_TO_XEN_INT(XConfigureWindow(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_XWindowChanges(arg4))));
}

static XEN gxm_XCloseDisplay(XEN arg1)
{
  #define H_XCloseDisplay "XCloseDisplay(display) closes the connection to the X server for the display specified in the Display structure and \
destroys all windows, resource IDs etc."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCloseDisplay", "Display*");
  return(C_TO_XEN_INT(XCloseDisplay(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XClearWindow(XEN arg1, XEN arg2)
{
  #define H_XClearWindow "XClearWindow(display, w) clears the entire area in the specified window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XClearWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XClearWindow", "Window");
  return(C_TO_XEN_INT(XClearWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XClearArea(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XClearArea "XClearArea(display, w, x, y, width, height, exposures) paints a rectangular area in the specified window according to the \
specified dimensions with the window's background pixel or pixmap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XClearArea", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XClearArea", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XClearArea", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XClearArea", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XClearArea", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XClearArea", "unsigned int");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg7), arg7, 7, "XClearArea", "Bool");
  return(C_TO_XEN_INT(XClearArea(XEN_TO_C_Display(arg1), 
				 XEN_TO_C_Window(arg2), 
				 XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
				 XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6), XEN_TO_C_BOOLEAN(arg7))));
}

static XEN gxm_XCirculateSubwindowsUp(XEN arg1, XEN arg2)
{
  #define H_XCirculateSubwindowsUp "XCirculateSubwindowsUp(display, w) raises the lowest mapped child of the specified window that is partially or \
completely occluded by another child."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCirculateSubwindowsUp", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCirculateSubwindowsUp", "Window");
  return(C_TO_XEN_INT(XCirculateSubwindowsUp(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XCirculateSubwindowsDown(XEN arg1, XEN arg2)
{
  #define H_XCirculateSubwindowsDown "XCirculateSubwindowsDown(display, w) lowers the highest mapped child of the specified window that partially or \
completely occludes another child."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCirculateSubwindowsDown", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCirculateSubwindowsDown", "Window");
  return(C_TO_XEN_INT(XCirculateSubwindowsDown(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XCirculateSubwindows(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XCirculateSubwindows "XCirculateSubwindows(display, w, direction) circulates children of the specified window in the specified direction."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCirculateSubwindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCirculateSubwindows", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XCirculateSubwindows", "int");
  return(C_TO_XEN_INT(XCirculateSubwindows(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XCheckWindowEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XCheckWindowEvent "Bool XCheckWindowEvent(display, w, event_mask) searches the event queue and then the events available \
on the server connection for the first event that matches the specified window and event mask."
  /* DIFF: XCheckWindowEvent dpy win mask [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCheckWindowEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCheckWindowEvent", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XCheckWindowEvent", "long");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XCheckWindowEvent(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), e);
  if (val)
    return(C_TO_XEN_XEvent_OBJ(e));
  else
    {
      FREE(e);
      return(XEN_FALSE);
    }
}

static XEN gxm_XCheckTypedWindowEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XCheckTypedWindowEvent "Bool XCheckTypedWindowEvent(display, w, event_type) searches the event queue and then any events \
available on the server connection for the first event that matches the specified event mask"
  /* DIFF: XCheckTypedWindowEvent dpy win mask [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCheckTypedWindowEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCheckTypedWindowEvent", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XCheckTypedWindowEvent", "int");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XCheckTypedWindowEvent(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), e);
  if (val)
    return(C_TO_XEN_XEvent_OBJ(e));
  else
    {
      FREE(e);
      return(XEN_FALSE);
    }
}

static XEN gxm_XCheckTypedEvent(XEN arg1, XEN arg2)
{
  #define H_XCheckTypedEvent "Bool XCheckTypedEvent(display, event_type) searches the event queue and then any events available  \
on the server connection for the first event that matches the specified type."
  /* DIFF: XCheckTypedEvent dpy mask [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCheckTypedEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XCheckTypedEvent", "int");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XCheckTypedEvent(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), e);
  if (val)
    return(C_TO_XEN_XEvent_OBJ(e));
  else
    {
      FREE(e);
      return(XEN_FALSE);
    }
}

static XEN gxm_XCheckMaskEvent(XEN arg1, XEN arg2)
{
  #define H_XCheckMaskEvent "Bool XCheckMaskEvent(display, event_mask) searches the event queue and then any events available on \
the server connection for the first event that matches the specified mask."
  /* DIFF: XCheckMaskEvent dpy mask [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCheckMaskEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XCheckMaskEvent", "long");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XCheckMaskEvent(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), e);
  if (val)
    return(C_TO_XEN_XEvent_OBJ(e));
  else
    {
      FREE(e);
      return(XEN_FALSE);
    }
}

static XEN gxm_XCheckIfEvent(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XCheckIfEvent "Bool XCheckIfEvent(display, predicate, arg)"
  /* DIFF: XCheckIfEvent dpy [ev] proc ptr -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCheckIfEvent", "Display*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 3), arg2, 2, "XCheckIfEvent", "(Bool_Proc dpy ev data)");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XCheckIfEvent(XEN_TO_C_Display(arg1), 
		      e, 
		      (Bool (*)(Display *d, XEvent *ev, char *p))gxm_XPeekIfEventProc, 
		      (char*)arg3);
  if (val)
    return(C_TO_XEN_XEvent_OBJ(e));
  else
    {
      FREE(e);
      return(XEN_FALSE);
    }
}

static XEN gxm_XChangeWindowAttributes(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XChangeWindowAttributes "XChangeWindowAttributes(display, w, valuemask, attributes) uses the window attributes in the XSetWindowAttributes \
structure to change the specified window attributes."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeWindowAttributes", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XChangeWindowAttributes", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XChangeWindowAttributes", "ulong");
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(arg4), arg4, 4, "XChangeWindowAttributes", "XSetWindowAttributes*");
  return(C_TO_XEN_INT(XChangeWindowAttributes(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3), 
					      XEN_TO_C_XSetWindowAttributes(arg4))));
}

static XEN gxm_XChangeProperty(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XChangeProperty "XChangeProperty(display, w, property, type, format, mode, data, nelements) alters the property for the specified \
window and causes the X server to generate a PropertyNotify event on that window."
  char *command;
  int len;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeProperty", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XChangeProperty", "Window");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XChangeProperty", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg4), arg4, 4, "XChangeProperty", "Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XChangeProperty", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XChangeProperty", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg7), arg7, 7, "XChangeProperty", "unsigned char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg8), arg8, 8, "XChangeProperty", "int");
  command = XEN_TO_C_STRING(arg7);
  if (XEN_INTEGER_P(arg8)) len = XEN_TO_C_INT(arg8); else len = strlen(command) + 1;
  return(C_TO_XEN_INT(XChangeProperty(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
				      XEN_TO_C_Atom(arg3), XEN_TO_C_Atom(arg4), 
				      XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6), 
				      (unsigned char *)command, len)));
}

static XEN gxm_XChangePointerControl(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XChangePointerControl "XChangePointerControl(display, do_accel, do_threshold, accel_numerator, accel_denominator, threshold) \
defines how the pointing device moves."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangePointerControl", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XChangePointerControl", "Bool");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XChangePointerControl", "Bool");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XChangePointerControl", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XChangePointerControl", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XChangePointerControl", "int");
  return(C_TO_XEN_INT(XChangePointerControl(XEN_TO_C_Display(arg1), 
					    XEN_TO_C_BOOLEAN(arg2), XEN_TO_C_BOOLEAN(arg3), 
					    XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6))));
}

static XEN gxm_XChangeKeyboardMapping(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XChangeKeyboardMapping "XChangeKeyboardMapping(display, first_keycode, keysyms_per_keycode, keysyms, num_codes) defines the \
symbols for the specified number of KeyCodes starting with first_keycode."
  /* DIFF: XChangeKeyboardMapping takes list of KeySyms
   */
  KeySym *ks;
  int len, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeKeyboardMapping", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XChangeKeyboardMapping", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XChangeKeyboardMapping", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XChangeKeyboardMapping", "list of KeySym");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XChangeKeyboardMapping", "int");
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) return(XEN_FALSE);
  ks = XEN_TO_C_KeySyms(arg4, len);
  val = XChangeKeyboardMapping(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), ks, len);
  FREE(ks);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XChangeKeyboardControl(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XChangeKeyboardControl "XChangeKeyboardControl(display, value_mask, values) controls the keyboard characteristics defined by \
the XKeyboardControl structure."
  /* DIFF: XChangeKeyboardControl arg3 is list of XKeyboardControl fields
   */
  XKeyboardControl kc;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeKeyboardControl", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XChangeKeyboardControl", "ulong");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XChangeKeyboardControl", "XKeyboardControl*");
  kc.key_click_percent = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
  if (!(XEN_NULL_P(arg3))) 
    {
      kc.bell_percent = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
      if (!(XEN_NULL_P(arg3)))
	{
	  kc.bell_pitch = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
	  if (!(XEN_NULL_P(arg3)))
	    {
	      kc.bell_duration = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
	      if (!(XEN_NULL_P(arg3)))
		{
		  kc.led = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
		  if (!(XEN_NULL_P(arg3)))
		    {
		      kc.led_mode = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
		      if (!(XEN_NULL_P(arg3)))
			{
			  kc.key = XEN_TO_C_INT(XEN_CAR(arg3)); arg3 = XEN_CDR(arg3);
			  if (!(XEN_NULL_P(arg3)))
			    {
			      kc.auto_repeat_mode = XEN_TO_C_INT(XEN_CAR(arg3));
			    }}}}}}}
  return(C_TO_XEN_INT(XChangeKeyboardControl(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), &kc)));
}

static XEN gxm_XChangeGC(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XChangeGC "XChangeGC(display, gc, valuemask, values) changes the components specified by valuemask for the specified GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeGC", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XChangeGC", "GC");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XChangeGC", "ulong");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(arg4), arg4, 4, "XChangeGC", "XGCValues*");
  return(C_TO_XEN_INT(XChangeGC(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_XGCValues(arg4))));
}

static XEN gxm_XChangeActivePointerGrab(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XChangeActivePointerGrab "XChangeActivePointerGrab(display, event_mask, cursor, time) changes the specified dynamic parameters \
if the pointer is actively grabbed by the client and if the specified time is no earlier than the last-pointer-grab time and no later than \
the current X server time."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XChangeActivePointerGrab", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XChangeActivePointerGrab", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg3), arg3, 3, "XChangeActivePointerGrab", "Cursor");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XChangeActivePointerGrab", "Time");
  return(C_TO_XEN_INT(XChangeActivePointerGrab(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_Cursor(arg3), XEN_TO_C_Time(arg4))));
}

static XEN gxm_XCellsOfScreen(XEN arg1)
{
  #define H_CellsOfScreen "CellsOfScreen(screen) returns the number of colormap cells in the default colormap of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XCellsOfScreen", "Screen*");
  return(C_TO_XEN_INT(XCellsOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XBitmapUnit(XEN arg1)
{
  #define H_BitmapUnit "BitmapUnit(display) returns the size of a bitmap's scanline unit in bits."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XBitmapUnit", "Display*");
  return(C_TO_XEN_INT(XBitmapUnit(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XBitmapPad(XEN arg1)
{
  #define H_BitmapPad "BitmapPad(display) returns the number of bits that each scanline must be padded."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XBitmapPad", "Display*");
  return(C_TO_XEN_INT(XBitmapPad(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XBitmapBitOrder(XEN arg1)
{
  #define H_BitmapBitOrder "BitmapBitOrder(display) returns LSBFirst or MSBFirst to indicate whether the leftmost bit in the bitmap as \
displayed on the screen is the least or most significant bit in the unit."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XBitmapBitOrder", "Display*");
  return(C_TO_XEN_INT(XBitmapBitOrder(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XBell(XEN arg1, XEN arg2)
{
  #define H_XBell "XBell(display, percent) rings the bell on the keyboard on the specified display, if possible."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XBell", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XBell", "int");
  return(C_TO_XEN_INT(XBell(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XAutoRepeatOn(XEN arg1)
{
  #define H_XAutoRepeatOn "XAutoRepeatOn(display) turns on auto-repeat for the keyboard on the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAutoRepeatOn", "Display*");
  return(C_TO_XEN_INT(XAutoRepeatOn(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XAutoRepeatOff(XEN arg1)
{
  #define H_XAutoRepeatOff "XAutoRepeatOff(display) turns off auto-repeat for the keyboard on the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAutoRepeatOff", "Display*");
  return(C_TO_XEN_INT(XAutoRepeatOff(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XAllowEvents(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XAllowEvents "XAllowEvents(display, event_mode, time)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAllowEvents", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XAllowEvents", "int");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XAllowEvents", "Time");
  return(C_TO_XEN_INT(XAllowEvents(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_Time(arg3))));
}

static XEN gxm_XAllocNamedColor(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XAllocNamedColor "Status XAllocNamedColor(display, colormap, color_name, screen_def_return, exact_def_return) looks up the \
named color with respect to the screen that is associated with the specified colormap."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAllocNamedColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XAllocNamedColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XAllocNamedColor", "char*");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg4), arg4, 4, "XAllocNamedColor", "XColor");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg5), arg5, 5, "XAllocNamedColor", "XColor");
  return(C_TO_XEN_INT(XAllocNamedColor(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Colormap(arg2), 
				       XEN_TO_C_STRING(arg3), 
				       XEN_TO_C_XColor(arg4), XEN_TO_C_XColor(arg5))));
}

static XEN gxm_XAllocColorPlanes(XEN args)
{
  #define H_XAllocColorPlanes "Status XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return)"
  /* DIFF: XAllocColorPlanes omits pixel array (arg4) and trailing 3 args, returns them and embedded list of pixels
   */
  unsigned long r,g,b;
  unsigned long *ps;
  int i, len, val, loc;
  XEN lst = XEN_FALSE, plist = XEN_EMPTY_LIST;
  XEN arg1; XEN arg2; XEN arg3; XEN arg5; XEN arg6; XEN arg7; XEN arg8;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg5 = XEN_LIST_REF(args, 3);
  arg6 = XEN_LIST_REF(args, 4);
  arg7 = XEN_LIST_REF(args, 5);
  arg8 = XEN_LIST_REF(args, 6);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAllocColorPlanes", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XAllocColorPlanes", "Colormap");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XAllocColorPlanes", "Bool");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XAllocColorPlanes", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XAllocColorPlanes", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XAllocColorPlanes", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XAllocColorPlanes", "int");
  len = XEN_TO_C_INT(arg5);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg5, 5, "XAllocColorPlanes", "positive integer");
  ps = (unsigned long *)CALLOC(len, sizeof(unsigned long));
  val = XAllocColorPlanes(XEN_TO_C_Display(arg1), 
			  XEN_TO_C_Colormap(arg2), 
			  XEN_TO_C_BOOLEAN(arg3), 
			  ps, len, 
			  XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7), XEN_TO_C_INT(arg8), 
			  &r, &g, &b);
  if (val != 0)
    {
      loc = xm_protect(plist);
      for (i = len - 1; i >= 0; i--)
	plist = XEN_CONS(C_TO_XEN_ULONG(ps[i]), plist);
      xm_unprotect_at(loc);
      lst = XEN_LIST_5(C_TO_XEN_INT(val),
		       plist,
		       C_TO_XEN_ULONG(r),
		       C_TO_XEN_ULONG(g),
		       C_TO_XEN_ULONG(b));
    }
  FREE(ps);
  return(lst);
}

static XEN gxm_XAllocColorCells(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XAllocColorCells "Status XAllocColorCells(display, colormap, contig, nplanes, npixels) \
allocates read/write color cells."
  /* DIFF: XAllocColorCells arg 4 and 6 omitted and returned as (embedded) lists 
   */
  int mlen, plen, i, val, loc1, loc2;
  XEN mlst = XEN_EMPTY_LIST, plst = XEN_EMPTY_LIST;
  unsigned long *ms, *ps;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAllocColorCells", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XAllocColorCells", "Colormap");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XAllocColorCells", "Bool");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XAllocColorCells", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XAllocColorCells", "unsigned int");
  mlen = XEN_TO_C_INT(arg4);
  if (mlen <= 0) return(XEN_FALSE);
  plen = XEN_TO_C_INT(arg5);
  if (plen <= 0) return(XEN_FALSE);
  ms = (unsigned long *)CALLOC(mlen, sizeof(unsigned long));
  ps = (unsigned long *)CALLOC(plen, sizeof(unsigned long));
  val = XAllocColorCells(XEN_TO_C_Display(arg1), 
			 XEN_TO_C_Colormap(arg2), 
			 XEN_TO_C_BOOLEAN(arg3), 
			 ms, mlen, 
			 ps, plen);
  loc1 = xm_protect(mlst);
  loc2 = xm_protect(plst);
  for (i = mlen - 1; i >= 0; i--) 
    mlst = XEN_CONS(C_TO_XEN_ULONG(ms[i]), mlst);
  for (i = plen - 1; i >= 0; i--) 
    mlst = XEN_CONS(C_TO_XEN_ULONG(ps[i]), plst);
  xm_unprotect_at(loc1);
  xm_unprotect_at(loc2);
  FREE(ms);
  FREE(ps);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    mlst,
		    plst));
}

static XEN gxm_XAllocColor(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XAllocColor "Status XAllocColor(display, colormap, screen_in_out) allocates a read-only colormap entry corresponding to the \
closest RGB value supported by the hardware."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XAllocColor", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XAllocColor", "Colormap");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg3), arg3, 3, "XAllocColor", "XColor"); 
  return(C_TO_XEN_INT(XAllocColor(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2), XEN_TO_C_XColor(arg3))));
}

static XEN gxm_XActivateScreenSaver(XEN arg1)
{
  #define H_XActivateScreenSaver "XActivateScreenSaver(display) activates the screen saver."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XActivateScreenSaver", "Display*");
  return(C_TO_XEN_INT(XActivateScreenSaver(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XSetTransientForHint(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XSetTransientForHint "XSetTransientForHint(display, w, prop_window) sets the WM_TRANSIENT_FOR property of the specified \
window to the specified prop_window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetTransientForHint", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetTransientForHint", "Window");
  XEN_ASSERT_TYPE(XEN_Window_P(arg3), arg3, 3, "XSetTransientForHint", "Window");
  return(C_TO_XEN_INT(XSetTransientForHint(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Window(arg3))));
}

static XEN gxm_XFreeStringList(XEN arg1)
{
  #define H_XFreeStringList "void XFreeStringList(list) releases memory allocated by  XTextPropertyToStringList and the missing charset \
list allocated by  XCreateFontSet (a no-op in xm)."
  /* DIFF: XFreeStringList is a no-op
   */
  return(XEN_FALSE);
}

static XEN gxm_XSetWMColormapWindows(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetWMColormapWindows "Status XSetWMColormapWindows(display, w, colormap_windows, count) replaces the WM_COLORMAP_WINDOWS property \
on the specified window with the list of windows specified by the colormap_windows argument."
  /* DIFF: XSetWMColormapWindows arg 3 is list of Windows
   */
  int len, rtn;
  Window *ws;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWMColormapWindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWMColormapWindows", "Window");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XSetWMColormapWindows", "list of Windows");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetWMColormapWindows", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  ws = XEN_TO_C_Windows(arg3, len);
  rtn = XSetWMColormapWindows(XEN_TO_C_Display(arg1), 
			      XEN_TO_C_Window(arg2),
			      ws, len);
  FREE(ws);
  return(C_TO_XEN_INT(rtn));
}

static XEN gxm_XGetWMColormapWindows(XEN arg1, XEN arg2)
{
  #define H_XGetWMColormapWindows "Status XGetWMColormapWindows(display, w) returns the list of \
window identifiers stored in the WM_COLORMAP_WINDOWS property on the specified window."
  /* DIFF: XGetWMColormapWindows omit last 2 args, return list of windows
   */
  XEN lst = XEN_EMPTY_LIST;
  int i, len, rtn, loc;
  Window *ws;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetWMColormapWindows", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetWMColormapWindows", "Window");
  rtn = XGetWMColormapWindows(XEN_TO_C_Display(arg1), 
			      XEN_TO_C_Window(arg2), 
			      &ws, &len);
  if (rtn == 0)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Window(ws[i]), lst);
  xm_unprotect_at(loc);
  XFree(ws);
  return(lst);
}

static XEN gxm_XGetCommand(XEN arg1, XEN arg2)
{
  #define H_XGetCommand "Status XGetCommand(display, w) reads the WM_COMMAND property from the specified window \
and returns a string list."
  /* DIFF: XGetCommand omits last 2 args, returns list
   */
  char **argv;
  int argc;
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  Status err;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetCommand", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetCommand", "Window");
  err = XGetCommand(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &argv, &argc);
  if (err != 0)
    {
      loc = xm_protect(lst);
      for (i = argc - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_STRING(argv[i]), lst);
      XFreeStringList(argv);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN gxm_XWithdrawWindow(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XWithdrawWindow "Status XWithdrawWindow(display, w, screen_number) unmaps the specified window and sends a synthetic  \
UnmapNotify event to the root window of the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XWithdrawWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XWithdrawWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XWithdrawWindow", "int");
  return(C_TO_XEN_INT(XWithdrawWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XIconifyWindow(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XIconifyWindow "Status XIconifyWindow(display, w, screen_number) sends a WM_CHANGE_STATE  ClientMessage event with a format of \
32 and a first data element of IconicState to the root window of the specified screen with an event mask set to \
SubstructureNotifyMask | SubstructureRedirectMask."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XIconifyWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XIconifyWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XIconifyWindow", "int");
  return(C_TO_XEN_INT(XIconifyWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XSetWMProtocols(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XSetWMProtocols "Status XSetWMProtocols(display, w, protocols, count) replaces the WM_PROTOCOLS property on the \
specified window with the list of atoms specified by the protocols argument."
  /* DIFF: XSetWMProtocols arg3 is list of atoms
   */
  Atom *outs;
  int val, len;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetWMProtocols", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XSetWMProtocols", "Window");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XSetWMProtocols", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XSetWMProtocols", "int");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  val = XSetWMProtocols(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), outs, len);
  FREE(outs);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XGetWMProtocols(XEN arg1, XEN arg2)
{
  #define H_XGetWMProtocols "Status XGetWMProtocols(display, w) returns the list of atoms stored in the \
WM_PROTOCOLS property on the specified window."
  /* DIFF: XGetWMProtocols omits last 2 args, returns list
   */
  Atom *ats;
  int len, i, val, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetWMProtocols", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetWMProtocols", "Window");
  val = XGetWMProtocols(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &ats, &len);
  if (val == 0)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Atom(ats[i]), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XReconfigureWMWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XReconfigureWMWindow "Status XReconfigureWMWindow(display, w, screen_number, value_mask, values) issues a  ConfigureWindow \
request on the specified top-level window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XReconfigureWMWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XReconfigureWMWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XReconfigureWMWindow", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XReconfigureWMWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XWindowChanges_P(arg5), arg5, 5, "XReconfigureWMWindow", "XWindowChanges*");
  return(C_TO_XEN_INT(XReconfigureWMWindow(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_ULONG(arg4), 
					   XEN_TO_C_XWindowChanges(arg5))));
}

static XEN gxm_XListDepths(XEN arg1, XEN arg2)
{
  #define H_XListDepths "int *XListDepths(display, screen_number) returns the array of depths that are available on the \
specified screen."
  /* DIFF: XListDepths omits last arg, returns list of depths
   */
  XEN lst = XEN_EMPTY_LIST;
  int i, len, loc;
  int *ds;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListDepths", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XListDepths", "int");
  ds = XListDepths(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2), &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_INT(ds[i]), lst);
  XFree(ds);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XListPixmapFormats(XEN arg1)
{
  #define H_XListPixmapFormats "XPixmapFormatValues *XListPixmapFormats(display) returns an array of XPixmapFormatValues \
structures that describe the types of Z format images supported by the specified display."
  /* DIFF: XListPixmapFormats omits arg2, rtns list of lists, each holding XPixmapFormatValues data
   */
  XPixmapFormatValues *ps;
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListPixmapFormats", "Display*");
  ps = XListPixmapFormats(XEN_TO_C_Display(arg1), &len);
  loc = xm_protect(lst);
  if (ps)
    {
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(XEN_LIST_3(C_TO_XEN_INT(ps[i].depth),
				  C_TO_XEN_INT(ps[i].bits_per_pixel),
				  C_TO_XEN_INT(ps[i].scanline_pad)),
		       lst);
      free(ps);
    }
  xm_unprotect_at(loc);
  return(lst);
}


static XEN xm_XIOErrorHandler = XEN_FALSE;
static int gxm_XIOErrorHandler(Display *dpy)
{
  XEN_CALL_1(xm_XIOErrorHandler, C_TO_XEN_Display(dpy), __FUNCTION__);
  return(0); /* never happens */
}

static XEN gxm_XSetIOErrorHandler(XEN arg1)
{
  #define H_XSetIOErrorHandler "int (*XSetIOErrorHandler(handler))() sets the fatal I/O error handler. "
  XEN old_val;
  xm_protect(arg1);
  old_val = xm_XIOErrorHandler;
  xm_XIOErrorHandler = arg1;
  XSetIOErrorHandler(gxm_XIOErrorHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val); /* hmmm... what if we're gc'd on the way back? */
  return(old_val);
}

static XEN xm_XErrorHandler = XEN_FALSE;
static int gxm_XErrorHandler(Display *dpy, XErrorEvent *e)
{
  XEN_CALL_2(xm_XErrorHandler, C_TO_XEN_Display(dpy), C_TO_XEN_XEvent((XEvent *)e), __FUNCTION__);
  return(0); /* never happens */
}

static XEN gxm_XSetErrorHandler(XEN arg1)
{
  #define H_XSetErrorHandler "XSetErrorHandler(proc) causes proc to be called is an error occurs"
  XEN old_val;
  xm_protect(arg1);
  old_val = xm_XErrorHandler;
  xm_XErrorHandler = arg1;
  XSetErrorHandler(gxm_XErrorHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val); /* hmmm... what if we're gc'd on the way back? */
  return(old_val);
}

static XEN gxm_XScreenNumberOfScreen(XEN arg1)
{
  #define H_XScreenNumberOfScreen "int XScreenNumberOfScreen(screen) returns the screen index number of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XScreenNumberOfScreen", "Screen*");
  return(C_TO_XEN_INT(XScreenNumberOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XEventMaskOfScreen(XEN arg1)
{
  #define H_EventMaskOfScreen "EventMaskOfScreen(screen) returns the root event mask of the root window for the specified screen at connection setup."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XEventMaskOfScreen", "Screen*");
  return(C_TO_XEN_ULONG(XEventMaskOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultScreenOfDisplay(XEN arg1)
{
  /* #define DefaultScreenOfDisplay(display) */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultScreenOfDisplay", "Display*");
  return(C_TO_XEN_Screen(XDefaultScreenOfDisplay(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XScreenOfDisplay(XEN arg1, XEN arg2)
{
  #define H_ScreenOfDisplay "ScreenOfDisplay(display, screen_number) returns a pointer to the screen of the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XScreenOfDisplay", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XScreenOfDisplay", "int");
  return(C_TO_XEN_Screen(XScreenOfDisplay(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayOfScreen(XEN arg1)
{
  #define H_DisplayOfScreen "DisplayOfScreen(screen) returns the display of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDisplayOfScreen", "Screen*");
  return(C_TO_XEN_Display(XDisplayOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultColormapOfScreen(XEN arg1)
{
  #define H_DefaultColormapOfScreen "DefaultColormapOfScreen(screen) returns the default colormap of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDefaultColormapOfScreen", "Screen*");
  return(C_TO_XEN_Colormap(XDefaultColormapOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultColormap(XEN arg1, XEN arg2)
{
  #define H_DefaultColormap "DefaultColormap(display, screen_number) returns the default colormap ID for allocation on the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDefaultColormap", "int");
  return(C_TO_XEN_Colormap(XDefaultColormap(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDisplayString(XEN arg1)
{
  #define H_DisplayString "DisplayString(display) returns the string that was passed to XOpenDisplay when the current display was opened."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayString", "Display*");
  return(C_TO_XEN_STRING(XDisplayString(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XServerVendor(XEN arg1)
{
  #define H_ServerVendor "ServerVendor(display) returns a pointer to a null-terminated string that provides some identification of the \
owner of the X server implementation."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XServerVendor", "Display*");
  return(C_TO_XEN_STRING(XServerVendor(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XLastKnownRequestProcessed(XEN arg1)
{
  #define H_LastKnownRequestProcessed "LastKnownRequestProcessed(display) extracts the full serial number of the last request known by Xlib \
to have been processed by the X server."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLastKnownRequestProcessed", "Display*");
  return(C_TO_XEN_ULONG(XLastKnownRequestProcessed(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XNextRequest(XEN arg1)
{
  #define H_NextRequest "NextRequest(display) extracts the full serial number that is to be used for the next request."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XNextRequest", "Display*");
  return(C_TO_XEN_ULONG(XNextRequest(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XWhitePixelOfScreen(XEN arg1)
{
  #define H_WhitePixelOfScreen "WhitePixelOfScreen(screen) returns the white pixel value of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XWhitePixelOfScreen", "Screen*");
  return(C_TO_XEN_Pixel(XWhitePixelOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XBlackPixelOfScreen(XEN arg1)
{
  #define H_BlackPixelOfScreen "BlackPixelOfScreen(screen) returns the black pixel value of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XBlackPixelOfScreen", "Screen*");
  return(C_TO_XEN_Pixel(XBlackPixelOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XAllPlanes(void)
{
  #define H_AllPlanes "Allplanes() returns a value with all bits set to 1 suitable for use in a plane argument to a procedure."
  return(C_TO_XEN_ULONG(XAllPlanes()));
}

static XEN gxm_XWhitePixel(XEN arg1, XEN arg2)
{
  #define H_WhitePixel "WhitePixel(display, screen_number) returns the white pixel value for the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XWhitePixel", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XWhitePixel", "int");
  return(C_TO_XEN_Pixel(XWhitePixel(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XBlackPixel(XEN arg1, XEN arg2)
{
  #define H_BlackPixel "BlackPixel(display, screen_number) returns the black pixel value for the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XBlackPixel", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XBlackPixel", "int");
  return(C_TO_XEN_Pixel(XBlackPixel(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDefaultGCOfScreen(XEN arg1)
{
  #define H_DefaultGCOfScreen "DefaultGCOfScreen(screen) returns the default GC of the specified screen, which has the same depth as the root \
window of the screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDefaultGCOfScreen", "Screen*");
  return(C_TO_XEN_GC(XDefaultGCOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultGC(XEN arg1, XEN arg2)
{
  #define H_DefaultGC "DefaultGC(display, screen_number) returns the default GC for the root window of the "
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultGC", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDefaultGC", "int");
  return(C_TO_XEN_GC(XDefaultGC(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XDefaultVisualOfScreen(XEN arg1)
{
  #define H_DefaultVisualOfScreen "DefaultVisualOfScreen(screen) returns the default visual of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XDefaultVisualOfScreen", "Screen*");
  return(C_TO_XEN_Visual(XDefaultVisualOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultVisual(XEN arg1, XEN arg2)
{
  #define H_DefaultVisual "DefaultVisual(display, screen_number) returns the default visual type for the specified screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultVisual", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XDefaultVisual", "int");
  return(C_TO_XEN_Visual(XDefaultVisual(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XRootWindowOfScreen(XEN arg1)
{
  #define H_RootWindowOfScreen "RootWindowOfScreen(screen) returns the root window of the specified screen."
  XEN_ASSERT_TYPE(XEN_Screen_P(arg1), arg1, 1, "XRootWindowOfScreen", "Screen*");
  return(C_TO_XEN_Window(XRootWindowOfScreen(XEN_TO_C_Screen(arg1))));
}

static XEN gxm_XDefaultRootWindow(XEN arg1)
{
  #define H_DefaultRootWindow "DefaultRootWindow(display) returns the root window for the default screen."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDefaultRootWindow", "Display*");
  return(C_TO_XEN_Window(XDefaultRootWindow(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XRootWindow(XEN arg1, XEN arg2)
{
  #define H_RootWindow "RootWindow(display, screen_number) returns the root window."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XRootWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XRootWindow", "int");
  return(C_TO_XEN_Window(XRootWindow(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XUnlockDisplay(XEN arg1)
{
  #define H_XUnlockDisplay "void XUnlockDisplay(display) allows other threads to use the specified display again."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XUnlockDisplay", "Display*");
  XUnlockDisplay(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XLockDisplay(XEN arg1)
{
  #define H_XLockDisplay "void XLockDisplay(display) locks out all other threads from using the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLockDisplay", "Display*");
  XLockDisplay(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XInitThreads(void)
{
  #define H_XInitThreads "Status XInitThreads() initializes Xlib support for concurrent threads."
  return(C_TO_XEN_INT(XInitThreads()));
}

static XEN gxm_XVisualIDFromVisual(XEN arg1)
{
  #define H_XVisualIDFromVisual "VisualID XVisualIDFromVisual(visual) returns the visual ID for the specified visual type."
  XEN_ASSERT_TYPE(XEN_Visual_P(arg1), arg1, 1, "XVisualIDFromVisual", "Visual*");
  return(C_TO_XEN_ULONG(XVisualIDFromVisual(XEN_TO_C_Visual(arg1))));
}

static XEN gxm_XDisplayMotionBufferSize(XEN arg1)
{
  #define H_XDisplayMotionBufferSize "unsigned long XDisplayMotionBufferSize(display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XDisplayMotionBufferSize", "Display*");
  return(C_TO_XEN_ULONG(XDisplayMotionBufferSize(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XExtendedMaxRequestSize(XEN arg1)
{
  #define H_XExtendedMaxRequestSize "long XExtendedMaxRequestSize(display) returns zero if the specified display does not support an \
extended-length protocol encoding; otherwise, it returns the maximum request size (in 4-byte units) supported by the server using the \
extended-length encoding."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XExtendedMaxRequestSize", "Display*");
  return(C_TO_XEN_INT(XExtendedMaxRequestSize(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XMaxRequestSize(XEN arg1)
{
  #define H_XMaxRequestSize "long XMaxRequestSize(display) returns the maximum request size (in 4-byte units) supported by the server \
without using an extended-length protocol encoding."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XMaxRequestSize", "Display*");
  return(C_TO_XEN_INT(XMaxRequestSize(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XStringToKeysym(XEN arg1)
{
  #define H_XStringToKeysym "KeySym XStringToKeysym(string)"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XStringToKeysym", "char*");
  return(C_TO_XEN_KeySym(XStringToKeysym(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XGetKeyboardMapping(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetKeyboardMapping "KeySym *XGetKeyboardMapping(display, first_keycode, keycode_count) returns \
the symbols for the specified number of KeyCodes starting with first_keycode."
  /* DIFF: XGetKeyboardMapping omits last arg, returns list of keys
   */
  int n, i, len, count, loc;
  KeySym *keys;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetKeyboardMapping", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XGetKeyboardMapping", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XGetKeyboardMapping", "int");
  count = XEN_TO_C_INT(arg3);
  keys = XGetKeyboardMapping(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), count, &n);
  len = count * n;
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_KeySym(keys[i]), lst);
  XFree(keys);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XLookupKeysym(XEN arg1, XEN arg2)
{
  #define H_XLookupKeysym "KeySym XLookupKeysym(key_event, index) uses a given keyboard event and the index you specified to return \
the KeySym from the list that corresponds to the KeyCode member in the XKeyPressedEvent or XKeyReleasedEvent structure."
  XEN_ASSERT_TYPE(XEN_XKeyEvent_P(arg1), arg1, 1, "XLookupKeysym", "XKeyEvent*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XLookupKeysym", "int");
  return(C_TO_XEN_KeySym(XLookupKeysym(XEN_TO_C_XKeyEvent(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XKeycodeToKeysym(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XKeycodeToKeysym "KeySym XKeycodeToKeysym(display, keycode, index) uses internal Xlib tables and returns the KeySym defined \
for the specified KeyCode and the element of the KeyCode vector."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XKeycodeToKeysym", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XKeycodeToKeysym", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XKeycodeToKeysym", "int");
  return(C_TO_XEN_KeySym(XKeycodeToKeysym(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XListProperties(XEN arg1, XEN arg2)
{
  #define H_XListProperties "Atom *XListProperties(display, w) returns a pointer to an array of atom properties that \
are defined for the specified window or returns NULL if no properties were found."
  /* DIFF: XListProperties returns list, no arg3
   */
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  Atom *ats;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListProperties", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XListProperties", "Window");
  ats = XListProperties(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &len);
  if (ats == NULL)
    return(XEN_FALSE);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Atom(ats[i]), lst);
  xm_unprotect_at(loc);
  XFree(ats);
  return(lst);
}

static XEN gxm_XListExtensions(XEN arg1)
{
  #define H_XListExtensions "XListExtensions(dpy) -> list of strings describing available extensions"
  /* DIFF: XListExtensions omits arg2, returns list
   */
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  char **str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListExtensions", "Display*");
  str = XListExtensions(XEN_TO_C_Display(arg1), &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_STRING(str[i]), lst);
  XFreeExtensionList(str);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XGetFontPath(XEN arg1)
{
  #define H_XGetFontPath "char **XGetFontPath(display) allocates and returns an array of strings containing the search path."
  /* DIFF: XGetFontPath omits arg2, returns list
   */
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  char **str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetFontPath", "Display*");
  str = XGetFontPath(XEN_TO_C_Display(arg1), &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_STRING(str[i]), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XListFontsWithInfo(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XListFontsWithInfo "char **XListFontsWithInfo(display, pattern, maxnames) returns a list of \
font names that match the specified pattern and their associated font information."
  /* DIFF: XListFontsWithInfo omit last 2 args, returns list of lists
   */
  int i, count, loc;
  XFontStruct *info;
  char **val;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListFontsWithInfo", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XListFontsWithInfo", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XListFontsWithInfo", "int");
  val = XListFontsWithInfo(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3), &count, &info);
  loc = xm_protect(lst);
  for (i = count - 1; i >= 0; i--)
    lst = XEN_CONS(XEN_LIST_2(C_TO_XEN_STRING(val[i]), 
			      C_TO_XEN_XFontStruct(&(info[i]))),
		   lst);
  XFreeFontNames(val);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XListFonts(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XListFonts "char **XListFonts(display, pattern, maxnames) returns an array of available font names that match \
the string you passed to the pattern argument."
  /* DIFF: XListFonts omits arg4, returns list
   */
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  char **str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListFonts", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XListFonts", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XListFonts", "int");
  str = XListFonts(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_INT(arg3), &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_STRING(str[i]), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XListInstalledColormaps(XEN arg1, XEN arg2)
{
  #define H_XListInstalledColormaps "Colormap *XListInstalledColormaps(display, w) returns a list of the currently installed \
colormaps for the screen of the specified window."
  /* DIFF: XListInstalledColormaps omits last arg, rtns list of XColormaps
   */
  Colormap *cm;
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XListInstalledColormaps", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XListInstalledColormaps", "Window");
  cm = XListInstalledColormaps(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), &len);
  loc = xm_protect(lst);
  for (i = len - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Colormap(cm[i]), lst);
  free(cm);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XCreateWindow(XEN args)
{
  #define H_XCreateWindow "Window XCreateWindow(display, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes) \
creates an unmapped subwindow for a specified parent window, returns the window ID of the created window, and causes the X server to generate \
a CreateNotify event."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11; XEN arg12;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  arg12 = XEN_LIST_REF(args, 11);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreateWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XCreateWindow", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XCreateWindow", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreateWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XCreateWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCreateWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XCreateWindow", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg9), arg9, 9, "XCreateWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Visual_P(arg10), arg10, 10, "XCreateWindow", "Visual*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg11), arg11, 11, "XCreateWindow", "ulong");
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(arg12), arg12, 12, "XCreateWindow", "XSetWindowAttributes*");
  return(C_TO_XEN_Window(XCreateWindow(XEN_TO_C_Display(arg1), 
				       XEN_TO_C_Window(arg2), 
				       XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
				       XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6), 
				       XEN_TO_C_ULONG(arg7), XEN_TO_C_INT(arg8), 
				       XEN_TO_C_ULONG(arg9), XEN_TO_C_Visual(arg10), 
				       XEN_TO_C_ULONG(arg11), 
				       XEN_TO_C_XSetWindowAttributes(arg12))));
}

static XEN gxm_XGetSelectionOwner(XEN arg1, XEN arg2)
{
  #define H_XGetSelectionOwner "Window XGetSelectionOwner(display, selection) returns the window ID associated with the window that \
currently owns the specified selection."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetSelectionOwner", "Display*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XGetSelectionOwner", "Atom");
  return(C_TO_XEN_Window(XGetSelectionOwner(XEN_TO_C_Display(arg1), XEN_TO_C_Atom(arg2))));
}

static XEN gxm_XCreateSimpleWindow(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XCreateSimpleWindow "Window XCreateSimpleWindow(display, parent, x, y, width, height, border_width, border, background) \
creates an unmapped InputOutput subwindow for a specified parent window, returns the window ID of the created window, and causes the X \
server to generate a CreateNotify event."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateSimpleWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreateSimpleWindow", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XCreateSimpleWindow", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XCreateSimpleWindow", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreateSimpleWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XCreateSimpleWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCreateSimpleWindow", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg8), arg8, 8, "XCreateSimpleWindow", "Pixel");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg9), arg9, 9, "XCreateSimpleWindow", "Pixel");
  return(C_TO_XEN_Window(XCreateSimpleWindow(XEN_TO_C_Display(arg1), 
					     XEN_TO_C_Window(arg2), 
					     XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
					     XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6), 
					     XEN_TO_C_ULONG(arg7), XEN_TO_C_Pixel(arg8), 
					     XEN_TO_C_Pixel(arg9))));
}

static XEN gxm_XCreatePixmapFromBitmapData(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XCreatePixmapFromBitmapData "Pixmap XCreatePixmapFromBitmapData(display, d, data, width, height, fg, bg, depth) creates a \
pixmap of the given depth and then does a bitmap-format XPutImage of the data into it."
  /* DIFF: XCreatePixmapFromBitmapData takes list of chars as arg3 (not char *)
   */
  char *bits;
  int i, len;
  Pixmap p;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreatePixmapFromBitmapData", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreatePixmapFromBitmapData", "Drawable");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XCreatePixmapFromBitmapData", "list of char");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XCreatePixmapFromBitmapData", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreatePixmapFromBitmapData", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XCreatePixmapFromBitmapData", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCreatePixmapFromBitmapData", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg8), arg8, 8, "XCreatePixmapFromBitmapData", "unsigned int");
  len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg3, 3, "XCreatePixmapFromBitmapData", "positive integer");
  bits = (char *)CALLOC(len, sizeof(char));
  for (i = 0; i < len; i++, arg3 = XEN_CDR(arg3))
    bits[i] = (char)XEN_TO_C_INT(XEN_CAR(arg3));
  p = XCreatePixmapFromBitmapData(XEN_TO_C_Display(arg1), 
				  XEN_TO_C_Window(arg2), 
				  bits,
				  XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5), 
				  XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7), 
				  XEN_TO_C_ULONG(arg8));
  FREE(bits);
  return(C_TO_XEN_Pixmap(p));
}

static XEN gxm_XCreateBitmapFromData(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XCreateBitmapFromData "Pixmap XCreateBitmapFromData(display, d, data, width, height) allows you to include in your C \
program a bitmap file that was written out by XWriteBitmapFile"
  /* DIFF: XCreateBitmapFromData takes list of chars as arg3 (not char *)
   */
  char *bits;
  int i, len;
  Pixmap p;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateBitmapFromData", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreateBitmapFromData", "Drawable");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XCreateBitmapFromData", "list of char");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XCreateBitmapFromData", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreateBitmapFromData", "unsigned int");
  len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg3, 3, "XCreateBitmapFromData", "positive integer");
  bits = (char *)CALLOC(len, sizeof(char));
  for (i = 0; i < len; i++, arg3 = XEN_CDR(arg3))
    bits[i] = (char)XEN_TO_C_INT(XEN_CAR(arg3));
  p = XCreateBitmapFromData(XEN_TO_C_Display(arg1), 
			    XEN_TO_C_Window(arg2),
			    bits, 
			    XEN_TO_C_ULONG(arg4), 
			    XEN_TO_C_ULONG(arg5));
  FREE(bits);
  return(C_TO_XEN_Pixmap(p));
}

static XEN gxm_XCreatePixmap(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XCreatePixmap "Pixmap XCreatePixmap(display, d, width, height, depth)"
  #define H_XCreatePixmapCursor "Cursor XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y) creates \
a cursor and returns the cursor ID associated with it."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreatePixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreatePixmap", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XCreatePixmap", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XCreatePixmap", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreatePixmap", "unsigned int");
  return(C_TO_XEN_Pixmap(XCreatePixmap(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
				       XEN_TO_C_ULONG(arg3), XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5))));
}

static XEN gxm_XFlushGC(XEN arg1, XEN arg2)
{
  #define H_XFlushGC "XFlushGC(dpy, gc) forces cached GC changes to X server"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFlushGC", "Display*");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XFlushGC", "GC");
  XFlushGC(XEN_TO_C_Display(arg1), XEN_TO_C_GC(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XCreateGC(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XCreateGC "GC XCreateGC(display, d, valuemask, values) creates a graphics context and returns a GC."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateGC", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreateGC", "Drawable");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XCreateGC", "ulong");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(arg4), arg4, 4, "XCreateGC", "XGCValues*");
  return(C_TO_XEN_GC(XCreateGC(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_XGCValues(arg4))));
}

static XEN gxm_XLoadFont(XEN arg1, XEN arg2)
{
  #define H_XLoadFont "Font XLoadFont(display, name) loads the specified font and returns its associated font ID."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLoadFont", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XLoadFont", "char*");
  return(C_TO_XEN_Font(XLoadFont(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XCreateFontCursor(XEN arg1, XEN arg2)
{
  #define H_XCreateFontCursor "Cursor XCreateFontCursor(display, shape)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateFontCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XCreateFontCursor", "unsigned int");
  return(C_TO_XEN_Cursor(XCreateFontCursor(XEN_TO_C_Display(arg1), XEN_TO_C_ULONG(arg2))));
}

static XEN gxm_XCreateGlyphCursor(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XCreateGlyphCursor "Cursor XCreateGlyphCursor(display, source_font, mask_font, source_char, mask_char, foreground_color, \
background_color) is similar to XCreatePixmapCursor except that the source and mask bitmaps are obtained from the specified font glyphs."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateGlyphCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Font_P(arg2), arg2, 2, "XCreateGlyphCursor", "Font");
  XEN_ASSERT_TYPE(XEN_Font_P(arg3) || XEN_INTEGER_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XCreateGlyphCursor", "Font");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XCreateGlyphCursor", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XCreateGlyphCursor", "unsigned int");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg6), arg6, 6, "XCreateGlyphCursor", "XColor");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg7), arg7, 7, "XCreateGlyphCursor", "XColor");
  return(C_TO_XEN_Cursor(XCreateGlyphCursor(XEN_TO_C_Display(arg1), XEN_TO_C_Font(arg2), 
					    (XEN_Font_P(arg3)) ? XEN_TO_C_Font(arg3) : None,
					    XEN_TO_C_ULONG(arg4),
					    XEN_TO_C_ULONG(arg5), 
					    XEN_TO_C_XColor(arg6), XEN_TO_C_XColor(arg7))));
}

static XEN gxm_XCreatePixmapCursor(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreatePixmapCursor", "Display*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg2), arg2, 2, "XCreatePixmapCursor", "Pixmap");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3) || XEN_INTEGER_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XCreatePixmapCursor", "Pixmap");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg4), arg4, 4, "XCreatePixmapCursor", "XColor");
  XEN_ASSERT_TYPE(XEN_XColor_P(arg5), arg5, 5, "XCreatePixmapCursor", "XColor");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XCreatePixmapCursor", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCreatePixmapCursor", "unsigned int");
  return(C_TO_XEN_Cursor(XCreatePixmapCursor(XEN_TO_C_Display(arg1), 
					     XEN_TO_C_Pixmap(arg2), 
					     (XEN_Pixmap_P(arg3)) ? XEN_TO_C_Pixmap(arg3) : None,
					     XEN_TO_C_XColor(arg4), 
					     XEN_TO_C_XColor(arg5), 
					     XEN_TO_C_ULONG(arg6), XEN_TO_C_ULONG(arg7))));
}

static XEN gxm_XCreateColormap(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XCreateColormap "Colormap XCreateColormap(display, w, visual, alloc) creates a colormap of the specified visual type for \
the screen on which the specified window resides and returns the colormap ID associated with it."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XCreateColormap", "Window");
  XEN_ASSERT_TYPE(XEN_Visual_P(arg3), arg3, 3, "XCreateColormap", "Visual*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XCreateColormap", "int");
  return(C_TO_XEN_Colormap(XCreateColormap(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Visual(arg3), XEN_TO_C_INT(arg4))));
}

static XEN gxm_XCopyColormapAndFree(XEN arg1, XEN arg2)
{
  #define H_XCopyColormapAndFree "Colormap XCopyColormapAndFree(display, colormap) creates a colormap of the same visual type and \
for the same screen as the specified colormap and returns the new colormap ID."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCopyColormapAndFree", "Display*");
  XEN_ASSERT_TYPE(XEN_Colormap_P(arg2), arg2, 2, "XCopyColormapAndFree", "Colormap");
  return(C_TO_XEN_Colormap(XCopyColormapAndFree(XEN_TO_C_Display(arg1), XEN_TO_C_Colormap(arg2))));
}

static XEN gxm_XInternAtom(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XInternAtom "Atom XInternAtom(display, atom_name, only_if_exists) returns the atom identifier associated with the specified atom_name string."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XInternAtom", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XInternAtom", "char*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XInternAtom", "Bool");
  return(C_TO_XEN_Atom(XInternAtom(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_BOOLEAN(arg3))));
}

static XEN xm_AfterFunction = XEN_FALSE;
static int default_after_function(Display *dpy) {return(0);}
static int gxm_AfterFunction(Display *dpy)
{
  return(XEN_TO_C_INT_OR_ELSE(XEN_CALL_1(xm_AfterFunction, 
					 C_TO_XEN_Display(dpy),
					 __FUNCTION__),
			      0));
}

static XEN gxm_XSetAfterFunction(XEN arg1, XEN arg2)
{
  #define H_XSetAfterFunction "XSetAfterFunction(dpy, proc) sets a function (one arg: dpy) to be called after every X function call"
  XEN old_func;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSetAfterFunction", "Display*");
  xm_protect(arg2);
  old_func = xm_AfterFunction;
  xm_AfterFunction = arg2;
  if (XEN_PROCEDURE_P(arg2))
    XSetAfterFunction(XEN_TO_C_Display(arg1), gxm_AfterFunction);
  else XSetAfterFunction(XEN_TO_C_Display(arg1), default_after_function);
  if (XEN_PROCEDURE_P(old_func)) xm_unprotect(old_func);
  return(old_func);
}

static XEN gxm_XSynchronize(XEN arg1, XEN arg2)
{
  #define H_XSynchronize "int (*XSynchronize(display, onoff))() turns on/off synchronous behavior."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XSynchronize", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XSynchronize", "boolean");
  XSynchronize(XEN_TO_C_Display(arg1),
	       XEN_TO_C_BOOLEAN(arg2));
  return(xm_AfterFunction);
}

static XEN gxm_XKeysymToString(XEN arg1)
{
  #define H_XKeysymToString "char *XKeysymToString(keysym)"
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg1), arg1, 1, "XKeysymToString", "KeySym");
  return(C_TO_XEN_STRING(XKeysymToString(XEN_TO_C_KeySym(arg1))));
}

static XEN gxm_XDisplayName(XEN arg1)
{
  #define H_XDisplayName "char *XDisplayName(string) returns the name of the display that  XOpenDisplay would attempt to use."
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XDisplayName", "char*");
  return(C_TO_XEN_STRING(XDisplayName(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XGetAtomName(XEN arg1, XEN arg2)
{
  #define H_XGetAtomName "char *XGetAtomName(display, atom) returns the name associated with the specified atom."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetAtomName", "Display*");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XGetAtomName", "Atom");
  return(C_TO_XEN_STRING(XGetAtomName(XEN_TO_C_Display(arg1), XEN_TO_C_Atom(arg2))));
}

static XEN gxm_XFetchBuffer(XEN arg1, XEN arg2)
{
  #define H_XFetchBuffer "char *XFetchBuffer(display, buffer) returns #f if there \
is no data in the buffer or if an invalid buffer is specified, otherwise a string."
  int len = 0;
  char *buf;
  XEN lst = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFetchBuffer", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XFetchBuffer", "int");
  buf = XFetchBuffer(XEN_TO_C_Display(arg1), &len, XEN_TO_C_INT(arg2));
  if (len > 0) 
    {
      lst = C_TO_XEN_STRING(buf);
      free(buf);
    }
  return(lst);
}

static XEN gxm_XFetchBytes(XEN arg1)
{
  #define H_XFetchBytes "char *XFetchBytes(display) returns the string in cut buffer 0"
  /* DIFF: XFetchBytes returns string, omits arg2
   */
  int len = 0;
  char *buf;
  XEN lst = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XFetchBytes", "Display*");
  buf = XFetchBytes(XEN_TO_C_Display(arg1), &len);
  if (len > 0) 
    {
      lst = C_TO_XEN_STRING(buf);
      free(buf);
    }
  return(lst);
}

static XEN gxm_XOpenDisplay(XEN arg1)
{
  #define H_XOpenDisplay "Display *XOpenDisplay(display_name) returns a Display structure that serves as the connection to the X server \
and that contains all the information about that X server."
  Display *dpy;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1) || XEN_FALSE_P(arg1), arg1, 1, "XOpenDisplay", "char*");
  dpy = XOpenDisplay(XEN_FALSE_P(arg1) ? NULL : XEN_TO_C_STRING(arg1));
  if (dpy)
    return(C_TO_XEN_Display(dpy));
  return(XEN_FALSE);
}

static XEN gxm_XGetSubImage(XEN args)
{
  #define H_XGetSubImage "XImage *XGetSubImage(display, d, x, y, width, height, plane_mask, format, dest_image, dest_x, dest_y) updates \
dest_image with the specified subimage in the same manner as "
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10; XEN arg11;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  arg11 = XEN_LIST_REF(args, 10);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetSubImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetSubImage", "Drawable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XGetSubImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XGetSubImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XGetSubImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XGetSubImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XGetSubImage", "ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XGetSubImage", "int");
  XEN_ASSERT_TYPE(XEN_XImage_P(arg9), arg9, 9, "XGetSubImage", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg10), arg10, 10, "XGetSubImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg11), arg11, 11, "XGetSubImage", "int");
  return(C_TO_XEN_XImage(XGetSubImage(XEN_TO_C_Display(arg1),
				      XEN_TO_C_Window(arg2), 
				      XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
				      XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6), 
				      XEN_TO_C_ULONG(arg7), XEN_TO_C_INT(arg8), 
				      XEN_TO_C_XImage(arg9), 
				      XEN_TO_C_INT(arg10), XEN_TO_C_INT(arg11))));
}

static XEN gxm_XGetImage(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XGetImage "XImage *XGetImage(display, d, x, y, width, height, plane_mask, format) returns a pointer to an XImage structure."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetImage", "Drawable");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XGetImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XGetImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XGetImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XGetImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XGetImage", "ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg8), arg8, 8, "XGetImage", "int");
  return(C_TO_XEN_XImage(XGetImage(XEN_TO_C_Display(arg1), 
				   XEN_TO_C_Window(arg2), 
				   XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), 
				   XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6), 
				   XEN_TO_C_ULONG(arg7), XEN_TO_C_INT(arg8))));
}

static XEN gxm_XCreateImage(XEN args)
{
  #define H_XCreateImage "XImage *XCreateImage(display, visual, depth, format, offset, data, width, height, bitmap_pad, bytes_per_line) \
allocates the memory needed for an XImage structure for the specified display but does not allocate space for the image itself."
  XEN arg1; XEN arg2; XEN arg3; XEN arg4; XEN arg5; XEN arg6; XEN arg7; XEN arg8; XEN arg9; XEN arg10;
  arg1 = XEN_LIST_REF(args, 0);
  arg2 = XEN_LIST_REF(args, 1);
  arg3 = XEN_LIST_REF(args, 2);
  arg4 = XEN_LIST_REF(args, 3);
  arg5 = XEN_LIST_REF(args, 4);
  arg6 = XEN_LIST_REF(args, 5);
  arg7 = XEN_LIST_REF(args, 6);
  arg8 = XEN_LIST_REF(args, 7);
  arg9 = XEN_LIST_REF(args, 8);
  arg10 = XEN_LIST_REF(args, 9);
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XCreateImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Visual_P(arg2), arg2, 2, "XCreateImage", "Visual*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XCreateImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XCreateImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XCreateImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XCreateImage", "pointer");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg7), arg7, 7, "XCreateImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg8), arg8, 8, "XCreateImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XCreateImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg10), arg10, 10, "XCreateImage", "int");
  return(C_TO_XEN_XImage(XCreateImage(XEN_TO_C_Display(arg1), 
				      XEN_TO_C_Visual(arg2), 
				      XEN_TO_C_ULONG(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				      (char *)XEN_TO_C_ULONG(arg6),
				      XEN_TO_C_ULONG(arg7), XEN_TO_C_ULONG(arg8),
				      XEN_TO_C_INT(arg9), XEN_TO_C_INT(arg10))));
}

static XEN gxm_XNewModifiermap(XEN arg1)
{
  #define H_XNewModifiermap "XModifierKeymap *XNewModifiermap(max_keys_per_mod) returns a pointer to XModifierKeymap structure for later use."
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XNewModifiermap", "int");
  return(C_TO_XEN_XModifierKeymap(XNewModifiermap(XEN_TO_C_INT(arg1))));
}

static XEN gxm_XInsertModifiermapEntry(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XInsertModifiermapEntry "XModifierKeymap *XInsertModifiermapEntry(modmap, keycode_entry, modifier) adds the specified KeyCode to \
the set that controls the specified modifier and returns the resulting XModifierKeymap structure (expanded as needed)."
  XEN_ASSERT_TYPE(XEN_XModifierKeymap_P(arg1), arg1, 1, "XInsertModifiermapEntry", "XModifierKeymap*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XInsertModifiermapEntry", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XInsertModifiermapEntry", "int");
  return(C_TO_XEN_XModifierKeymap(XInsertModifiermapEntry(XEN_TO_C_XModifierKeymap(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XGetModifierMapping(XEN arg1)
{
  #define H_XGetModifierMapping "XModifierKeymap *XGetModifierMapping(display) returns a pointer to a newly created XModifierKeymap structure \
that contains the keys being used as modifiers."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetModifierMapping", "Display*");
  return(C_TO_XEN_XModifierKeymap(XGetModifierMapping(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XDeleteModifiermapEntry(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XDeleteModifiermapEntry "XModifierKeymap *XDeleteModifiermapEntry(modmap, keycode_entry, modifier) deletes the specified KeyCode \
from the set that controls the specified modifier and returns a pointer to the resulting XModifierKeymap structure."
  XEN_ASSERT_TYPE(XEN_XModifierKeymap_P(arg1), arg1, 1, "XDeleteModifiermapEntry", "XModifierKeymap*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XDeleteModifiermapEntry", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XDeleteModifiermapEntry", "int");
  return(C_TO_XEN_XModifierKeymap(XDeleteModifiermapEntry(XEN_TO_C_XModifierKeymap(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XGetMotionEvents(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XGetMotionEvents "XTimeCoord *XGetMotionEvents(display, w, start, stop) returns all events in the motion history \
buffer that fall between the specified start and stop times, inclusive, and that have coordinates that lie within the specified window \
(including its borders) at its present placement."
  /* DIFF: XGetMotionEvents omits last arg, return time coords as list of lists
   */
  int n, i, loc;
  XTimeCoord *tcs;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XGetMotionEvents", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XGetMotionEvents", "Window");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XGetMotionEvents", "Time");
  XEN_ASSERT_TYPE(XEN_Time_P(arg4), arg4, 4, "XGetMotionEvents", "Time");
  tcs = XGetMotionEvents(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), XEN_TO_C_Time(arg3), XEN_TO_C_Time(arg4), &n);
  loc = xm_protect(lst);
  for (i = n - 1; i > 0; i--)
    lst = XEN_CONS(XEN_LIST_3(C_TO_XEN_Time(tcs->time),
			      C_TO_XEN_INT((int)(tcs->x)),
			      C_TO_XEN_INT((int)(tcs->y))),
		   lst);
  XFree(tcs); /* free each as well? */
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XQueryFont(XEN arg1, XEN arg2)
{
  #define H_XQueryFont "XFontStruct *XQueryFont(display, font) returns a pointer to the XFontStruct structure, which contains information \
associated with the font."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XQueryFont", "Display*");
  XEN_ASSERT_TYPE(XEN_Font_P(arg2), arg2, 2, "XQueryFont", "Font");
  return(C_TO_XEN_XFontStruct(XQueryFont(XEN_TO_C_Display(arg1), XEN_TO_C_Font(arg2))));
}

static XEN gxm_XLoadQueryFont(XEN arg1, XEN arg2)
{
  #define H_XLoadQueryFont "XFontStruct *XLoadQueryFont(display, name) provides the most common way for accessing a font. XLoadQueryFont \
both opens (loads) the specified font and returns a pointer to the appropriate XFontStruct structure."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XLoadQueryFont", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XLoadQueryFont", "char*");
  return(C_TO_XEN_XFontStruct(XLoadQueryFont(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_DefaultScreen(XEN arg)
{
  #define H_DefaultScreen "returns the default screen number referenced in the XOpenDisplay routine."
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "DefaultScreen", "Display*");
  return(C_TO_XEN_INT(DefaultScreen(XEN_TO_C_Display(arg))));
}

static XEN gxm_DefaultRootWindow(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "DefaultRootWindow", "Display*");
  return(C_TO_XEN_Window(DefaultRootWindow(XEN_TO_C_Display(arg))));
}

static XEN gxm_QLength(XEN arg)
{
  /* QLength(display) */
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "QLength", "Display*");
  return(C_TO_XEN_INT(QLength(XEN_TO_C_Display(arg))));
}

static XEN gxm_ScreenCount(XEN arg1)
{
  /* ScreenCount(display) */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "ScreenCount", "Display*");
  return(C_TO_XEN_INT(XScreenCount(XEN_TO_C_Display(arg1))));
}

static XEN gxm_ServerVendor(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "ServerVendor", "Display*");
  return(C_TO_XEN_STRING(ServerVendor(XEN_TO_C_Display(arg))));
}

static XEN gxm_ProtocolVersion(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "ProtocolVersion", "Display*");
  return(C_TO_XEN_INT(ProtocolVersion(XEN_TO_C_Display(arg))));
}

static XEN gxm_ProtocolRevision(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "ProtocolRevision", "Display*");
  return(C_TO_XEN_INT(ProtocolRevision(XEN_TO_C_Display(arg))));
}

static XEN gxm_VendorRelease(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "VendorRelease", "Display*");
  return(C_TO_XEN_INT(VendorRelease(XEN_TO_C_Display(arg))));
}

static XEN gxm_DisplayString(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "DisplayString", "Display*");
  return(C_TO_XEN_STRING(DisplayString(XEN_TO_C_Display(arg))));
}

static XEN gxm_BitmapUnit(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "BitmapUnit", "Display*");
  return(C_TO_XEN_INT(BitmapUnit(XEN_TO_C_Display(arg))));
}

static XEN gxm_BitmapBitOrder(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "BitmapBitOrder", "Display*");
  return(C_TO_XEN_INT(BitmapBitOrder(XEN_TO_C_Display(arg))));
}

static XEN gxm_BitmapPad(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "BitmapPad", "Display*");
  return(C_TO_XEN_INT(BitmapPad(XEN_TO_C_Display(arg))));
}

static XEN gxm_ImageByteOrder(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "ImageByteOrder", "Display*");
  return(C_TO_XEN_INT(ImageByteOrder(XEN_TO_C_Display(arg))));
}

static XEN gxm_NextRequest(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "NextRequest", "Display*");
  return(C_TO_XEN_ULONG(NextRequest(XEN_TO_C_Display(arg))));
}

static XEN gxm_LastKnownRequestProcessed(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "LastKnownRequestProcessed", "Display*");
  return(C_TO_XEN_ULONG(LastKnownRequestProcessed(XEN_TO_C_Display(arg))));
}

static XEN gxm_DefaultScreenOfDisplay(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg), arg, 0, "DefaultScreenOfDisplay", "Display");
  return(C_TO_XEN_Screen(DefaultScreenOfDisplay(XEN_TO_C_Display(arg))));
}

static XEN gxm_DisplayOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DisplayOfScreen", "Screen");
  return(C_TO_XEN_Display(DisplayOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_RootWindowOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "RootWindowOfScreen", "Screen");
  return(C_TO_XEN_Window(RootWindowOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_BlackPixelOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "BlackPixelOfScreen", "Screen");
  return(C_TO_XEN_Pixel(BlackPixelOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_WhitePixelOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "WhitePixelOfScreen", "Screen");
  return(C_TO_XEN_Pixel(WhitePixelOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DefaultColormapOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DefaultColormapOfScreen", "Screen");
  return(C_TO_XEN_Colormap(DefaultColormapOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DefaultDepthOfScreen(XEN arg)
{
  /* DefaultDepthOfScreen(screen) */
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DefaultDepthOfScreen", "Screen");
  return(C_TO_XEN_INT(DefaultDepthOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DefaultGCOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DefaultGCOfScreen", "Screen");
  return(C_TO_XEN_GC(DefaultGCOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DefaultVisualOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DefaultVisualOfScreen", "Screen");
  return(C_TO_XEN_Visual(DefaultVisualOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_WidthOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "WidthOfScreen", "Screen");
  return(C_TO_XEN_INT(WidthOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_HeightOfScreen(XEN arg)
{
  /* HeightOfScreen(screen) */
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "HeightOfScreen", "Screen");
  return(C_TO_XEN_INT(HeightOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_WidthMMOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "WidthMMOfScreen", "Screen");
  return(C_TO_XEN_INT(WidthMMOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_HeightMMOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "HeightMMOfScreen", "Screen");
  return(C_TO_XEN_INT(HeightMMOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_PlanesOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "PlanesOfScreen", "Screen");
  return(C_TO_XEN_INT(PlanesOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_CellsOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "CellsOfScreen", "Screen");
  return(C_TO_XEN_INT(CellsOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_MinCmapsOfScreen(XEN arg)
{
  /* MinCmapsOfScreen(screen) */
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "MinCmapsOfScreen", "Screen");
  return(C_TO_XEN_INT(MinCmapsOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_MaxCmapsOfScreen(XEN arg)
{
  /* MaxCmapsOfScreen(screen) */
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "MaxCmapsOfScreen", "Screen");
  return(C_TO_XEN_INT(MaxCmapsOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DoesSaveUnders(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DoesSaveUnders", "Screen");
  return(C_TO_XEN_BOOLEAN(DoesSaveUnders(XEN_TO_C_Screen(arg))));
}

static XEN gxm_DoesBackingStore(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "DoesBackingStore", "Screen");
  return(C_TO_XEN_BOOLEAN(DoesBackingStore(XEN_TO_C_Screen(arg))));
}

static XEN gxm_EventMaskOfScreen(XEN arg)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(arg), arg, 0, "EventMaskOfScreen", "Screen");
  return(C_TO_XEN_ULONG(EventMaskOfScreen(XEN_TO_C_Screen(arg))));
}

static XEN gxm_RootWindow(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "RootWindow", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "RootWindow", "int");
  return(C_TO_XEN_Window(RootWindow(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DefaultVisual(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DefaultVisual", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DefaultVisual", "int");
  return(C_TO_XEN_Visual(DefaultVisual(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DefaultGC(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DefaultGC", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DefaultGC", "int");
  return(C_TO_XEN_GC(DefaultGC(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_BlackPixel(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "BlackPixel", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "BlackPixel", "int");
  return(C_TO_XEN_Pixel(BlackPixel(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_WhitePixel(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "WhitePixel", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "WhitePixel", "int");
  return(C_TO_XEN_Pixel(WhitePixel(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayWidth(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayWidth", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayWidth", "int");
  return(C_TO_XEN_INT(DisplayWidth(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayHeight(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayHeight", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayHeight", "int");
  return(C_TO_XEN_INT(DisplayHeight(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayWidthMM(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayWidthMM", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayWidthMM", "int");
  return(C_TO_XEN_INT(DisplayWidthMM(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayHeightMM(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayHeightMM", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayHeightMM", "int");
  return(C_TO_XEN_INT(DisplayHeightMM(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayPlanes(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayPlanes", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayPlanes", "int");
  return(C_TO_XEN_INT(DisplayPlanes(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DisplayCells(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DisplayCells", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DisplayCells", "int");
  return(C_TO_XEN_INT(DisplayCells(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DefaultColormap(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DefaultColormap", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DefaultColormap", "int");
  return(C_TO_XEN_Colormap(DefaultColormap(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_ScreenOfDisplay(XEN arg1, XEN arg2)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "ScreenOfDisplay", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "ScreenOfDisplay", "int");
  return(C_TO_XEN_Screen(ScreenOfDisplay(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_DefaultDepth(XEN arg1, XEN arg2)
{
  /* DefaultDepth(display, screen_number) */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "DefaultDepth", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "DefaultDepth", "int");
  return(C_TO_XEN_INT(DefaultDepth(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_IsKeypadKey(XEN arg)
{
  #define H_IsKeypadKey "IsKeypadKey(keysym) returns #t if the specified KeySym is a keypad key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsKeypadKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsKeypadKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsPrivateKeypadKey(XEN arg)
{
  #define H_IsPrivateKeypadKey "IsPrivateKeypadKey(keysym) returns #t if the specified KeySym is a vendor-private keypad key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsPrivateKeypadKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsPrivateKeypadKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsCursorKey(XEN arg)
{
  #define H_IsCursorKey "IsCursorKey(keysym) returns #t if the specified KeySym is a cursor key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsCursorKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsCursorKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsPFKey(XEN arg)
{
  #define H_IsPFKey "IsPFKey(keysym) returns #t if the specified KeySym is a PF key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsPFKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsPFKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsFunctionKey(XEN arg)
{
  #define H_IsFunctionKey "IsFunctionKey(keysym) returns #t if the KeySym is a function key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsFunctionKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsFunctionKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsMiscFunctionKey(XEN arg)
{
  #define H_IsMiscFunctionKey "IsMiscFunctionKey(keysym) returns #t if the specified KeySym is a miscellaneous function key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsMiscFunctionKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsMiscFunctionKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_IsModifierKey(XEN arg)
{
  #define H_IsModifierKey "IsModifierKey(keysym) returns #t if the specified KeySym is a modifier key."
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg), arg, 0, "IsModifierKey", "KeySym");
  return(C_TO_XEN_BOOLEAN(IsModifierKey(XEN_TO_C_KeySym(arg))));
}

static XEN gxm_XAddPixel(XEN arg1, XEN arg2)
{
  #define H_XAddPixel "XAddPixel(ximage, value) adds a constant value to every pixel in an image."
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XAddPixel", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XAddPixel", "long");
  return(C_TO_XEN_INT(XAddPixel(XEN_TO_C_XImage(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XSubImage(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XSubImage "XImage *XSubImage(ximage, x, y, subimage_width, subimage_height) creates a new image that is a subsection of an existing one."
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XSubImage", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XSubImage", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XSubImage", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg4), arg4, 4, "XSubImage", "unsigned int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XSubImage", "unsigned int");
  return(C_TO_XEN_XImage(XSubImage(XEN_TO_C_XImage(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_ULONG(arg4), XEN_TO_C_ULONG(arg5))));
}

static XEN gxm_XPutPixel(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XPutPixel "XPutPixel(ximage, x, y, pixel) overwrites the pixel in the named image with the specified pixel value."
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XPutPixel", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XPutPixel", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XPutPixel", "int");
  XEN_ASSERT_TYPE(XEN_Pixel_P(arg4), arg4, 4, "XPutPixel", "Pixel");
  return(C_TO_XEN_INT(XPutPixel(XEN_TO_C_XImage(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_Pixel(arg4))));
}

static XEN gxm_XGetPixel(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XGetPixel "Pixel XGetPixel(ximage, x, y) returns the specified pixel from the named image."
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XGetPixel", "XImage*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XGetPixel", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XGetPixel", "int");
  return(C_TO_XEN_Pixel(XGetPixel(XEN_TO_C_XImage(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3))));
}

static XEN gxm_XDestroyImage(XEN arg1)
{
  #define H_XDestroyImage "XDestroyImage(ximage) deallocates the memory associated with the XImage structure."
  XEN_ASSERT_TYPE(XEN_XImage_P(arg1), arg1, 1, "XDestroyImage", "XImage*");
  return(C_TO_XEN_INT(XDestroyImage(XEN_TO_C_XImage(arg1))));
}




/* ----------------------------------------------------------------------------------------------------
 *
 *                            *         *  ***********
 *                             *       *        *
 *                              *     *         *
 *                               *   *          *
 *                                * *           *
 *                                 *            *
 *                                * *           *
 *                               *   *          *
 *                              *     *         *
 *                             *       *        *
 *                            *         *       *
 * ----------------------------------------------------------------------------------------------------
 */

#if HAVE_MOTIF

/* I think these are globals in the sense that only one such procedure per selection atom  */
static void gxm_XtCancelConvertSelectionProc(Widget w, Atom* a1, Atom* a2, XtRequestId* id, XtPointer x) {} 
static void gxm_XtConvertSelectionProc(Widget w, Atom* a1, Atom* a2, Atom* a3, XtPointer* x, unsigned long* l, int* i) {}
static void gxm_XtLoseSelectionIncrProc(Widget w, Atom* a, XtPointer x) {}
static void gxm_XtLoseSelectionProc(Widget w, Atom* a) {}
static void gxm_XtSelectionDoneProc(Widget w, Atom* a1, Atom* a2) {}
static void gxm_XtSelectionDoneIncrProc(Widget w, Atom* a1, Atom* a2, XtRequestId* i, XtPointer x) {}

static XEN gxm_XtAppUnlock(XEN arg1)
{
  #define H_XtAppUnlock "void XtAppUnlock(app_context) unlocks the application context."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppUnlock", "XtAppContext");
  XtAppUnlock(XEN_TO_C_XtAppContext(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtAppLock(XEN arg1)
{
  #define H_XtAppLock "void XtAppLock(app_context) locks the application context including all its related displays and widgets."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppLock", "XtAppContext");
  XtAppLock(XEN_TO_C_XtAppContext(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtToolkitThreadInitialize(void)
{
  #define H_XtToolkitThreadInitialize "Boolean XtToolkitThreadInitialize()"
  return(C_TO_XEN_BOOLEAN(XtToolkitThreadInitialize()));
}

static XEN gxm_XtGetDisplays(XEN arg1)
{
  #define H_XtGetDisplays "void XtGetDisplays(app_context) -> list of displays"
  /* DIFF: XtGetDisplays not arg2 arg3 returns list
   */
  unsigned int x;
  Display **ds;
  int i, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtGetDisplays", "XtAppContext");
  XtGetDisplays(XEN_TO_C_XtAppContext(arg1), &ds, &x);
  loc = xm_protect(lst);
  for (i = x - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_Display(ds[i]), lst);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XtGetApplicationNameAndClass(XEN arg1)
{
  #define H_XtGetApplicationNameAndClass "void XtGetApplicationNameAndClass(display) returns the application name \
and class passed to XtDisplayInitialize for the specified display."
  /* DIFF: XtGetApplicationNameAndClass omits and rtns args 2 and 3
   */
  char *name, *clas;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtGetApplicationNameAndClass", "Display*");
  XtGetApplicationNameAndClass(XEN_TO_C_Display(arg1), &name, &clas);
  return(XEN_LIST_2(C_TO_XEN_STRING(name),
		    C_TO_XEN_STRING(clas)));
}

static XEN gxm_XtUngrabPointer(XEN arg1, XEN arg2)
{
  #define H_XtUngrabPointer "void XtUngrabPointer(widget, time) calls XUngrabPointer with the specified time."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUngrabPointer", "Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XtUngrabPointer", "Time");
  XtUngrabPointer(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtGrabPointer(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtGrabPointer "int XtGrabPointer(widget, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, time) calls \
XGrabPointer specifying the widget's window as the grab window."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGrabPointer", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XtGrabPointer", "boolean");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XtGrabPointer", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtGrabPointer", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XtGrabPointer", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg6), arg6, 6, "XtGrabPointer", "Window");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg7), arg7, 7, "XtGrabPointer", "Cursor");
  XEN_ASSERT_TYPE(XEN_Time_P(arg8), arg8, 8, "XtGrabPointer", "Time");
  return(C_TO_XEN_INT(XtGrabPointer(XEN_TO_C_Widget(arg1), 
				    XEN_TO_C_BOOLEAN(arg2), XEN_TO_C_ULONG(arg3), 
				    XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5), 
				    XEN_TO_C_Window(arg6), XEN_TO_C_Cursor(arg7), 
				    XEN_TO_C_Time(arg8))));
}

static XEN gxm_XtUngrabButton(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtUngrabButton "void XtUngrabButton(widget, button, modifiers) calls XUngrabButton specifying the widget's window as the ungrab \
window if the widget is realized. "
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUngrabButton", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtUngrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtUngrabButton", "Modifiers");
  XtUngrabButton(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_Modifiers(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XtGrabButton(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XtGrabButton "void XtGrabButton(widget, button, modifiers, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor) \
calls XGrabButton specifying the widget's window as the grab window if the widget is realized."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGrabButton", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtGrabButton", "int");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtGrabButton", "Modifiers");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg4), arg4, 4, "XtGrabButton", "boolean");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XtGrabButton", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtGrabButton", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtGrabButton", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(arg8), arg8, 8, "XtGrabButton", "Window");
  XEN_ASSERT_TYPE(XEN_Cursor_P(arg9), arg9, 9, "XtGrabButton", "Cursor");
  XtGrabButton(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), 
	       XEN_TO_C_Modifiers(arg3), XEN_TO_C_BOOLEAN(arg4), XEN_TO_C_ULONG(arg5), XEN_TO_C_INT(arg6), XEN_TO_C_INT(arg7), 
	       XEN_TO_C_Window(arg8), XEN_TO_C_Cursor(arg9));
  return(XEN_FALSE);
}

static XEN gxm_XtUngrabKeyboard(XEN arg1, XEN arg2)
{
  #define H_XtUngrabKeyboard "void XtUngrabKeyboard(widget, time) calls XUngrabKeyboard with the specified time."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUngrabKeyboard", "Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XtUngrabKeyboard", "Time");
  XtUngrabKeyboard(XEN_TO_C_Widget(arg1), XEN_TO_C_Time(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtGrabKeyboard(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtGrabKeyboard "int XtGrabKeyboard(widget, owner_events, pointer_mode, keyboard_mode, time)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGrabKeyboard", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XtGrabKeyboard", "boolean");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XtGrabKeyboard", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtGrabKeyboard", "int");
  XEN_ASSERT_TYPE(XEN_Time_P(arg5), arg5, 5, "XtGrabKeyboard", "Time");
  return(C_TO_XEN_INT(XtGrabKeyboard(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2), XEN_TO_C_INT(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_Time(arg5))));
}

static XEN gxm_XtUngrabKey(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtUngrabKey "void XtUngrabKey(widget, keycode, modifiers) calls XUngrabKey specifying the widget's window as the ungrab window \
if the widget is realized."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUngrabKey", "Widget");
  XEN_ASSERT_TYPE(XEN_KeyCode_P(arg2), arg2, 2, "XtUngrabKey", "KeyCode");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtUngrabKey", "Modifiers");
  XtUngrabKey(XEN_TO_C_Widget(arg1), XEN_TO_C_KeyCode(arg2), XEN_TO_C_Modifiers(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XtGrabKey(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtGrabKey "void XtGrabKey(widget, keycode, modifiers, owner_events, pointer_mode, keyboard_mode) calls XGrabKey specifying the \
widget's window as the grab window if the widget is realized."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGrabKey", "Widget");
  XEN_ASSERT_TYPE(XEN_KeyCode_P(arg2), arg2, 2, "XtGrabKey", "KeyCode");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtGrabKey", "Modifiers");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg4), arg4, 4, "XtGrabKey", "boolean");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XtGrabKey", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtGrabKey", "int");
  XtGrabKey(XEN_TO_C_Widget(arg1), XEN_TO_C_KeyCode(arg2), XEN_TO_C_Modifiers(arg3), XEN_TO_C_BOOLEAN(arg4), XEN_TO_C_INT(arg5), XEN_TO_C_INT(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XtCancelSelectionRequest(XEN arg1, XEN arg2)
{
  #define H_XtCancelSelectionRequest "void XtCancelSelectionRequest(requestor, selection)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCancelSelectionRequest", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtCancelSelectionRequest", "Atom");
  XtCancelSelectionRequest(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtSendSelectionRequest(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtSendSelectionRequest "void XtSendSelectionRequest(requestor, selection, time)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSendSelectionRequest", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtSendSelectionRequest", "Atom");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XtSendSelectionRequest", "Time");
  XtSendSelectionRequest(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Time(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XtCreateSelectionRequest(XEN arg1, XEN arg2)
{
  #define H_XtCreateSelectionRequest "void XtCreateSelectionRequest(requestor, selection)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCreateSelectionRequest", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtCreateSelectionRequest", "Atom");
  XtCreateSelectionRequest(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtGetSelectionValuesIncremental(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XtGetSelectionValuesIncremental "void XtGetSelectionValuesIncremental(w, selection, targets, count, callback, client_data, time) \
is similar to XtGetSelectionValueIncremental except that it takes a list of target types and a list of client data and obtains the current \
value of the selection converted to each of the targets."
  /* DIFF: XtGetSelectionValuesIncremental arg 3 is list of Atoms
   */
  Atom *outs;
  int len;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetSelectionValuesIncremental", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtGetSelectionValuesIncremental", "Atom");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtGetSelectionValuesIncremental", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtGetSelectionValuesIncremental", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg5) && (XEN_REQUIRED_ARGS(arg5) == 7), arg5, 5, "XtGetSelectionValuesIncremental", "XtSelectionCallbackProc");
  XEN_ASSERT_TYPE(XEN_Time_P(arg7), arg7, 7, "XtGetSelectionValuesIncremental", "Time");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  xm_XtSelectionCallback_Descr = XEN_LIST_2(arg5, arg6);
  XtGetSelectionValuesIncremental(XEN_TO_C_Widget(arg1), 
				  XEN_TO_C_Atom(arg2), outs, len, 
				  gxm_XtSelectionCallbackProc, 
				  (XtPointer *)arg6, XEN_TO_C_Time(arg7));
  FREE(outs);
  return(XEN_FALSE);
}  

static XEN gxm_XtGetSelectionValueIncremental(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtGetSelectionValueIncremental "void XtGetSelectionValueIncremental(w, selection, target, callback, client_data, time) is similar \
to XtGetSelectionValue except that the selection_callback procedure will be called repeatedly upon delivery of multiple segments of the selection value."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetSelectionValueIncremental", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtGetSelectionValueIncremental", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XtGetSelectionValueIncremental", "Atom");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 7), arg4, 4, "XtGetSelectionValueIncremental", "XtSelectionCallbackProc");
  XEN_ASSERT_TYPE(XEN_Time_P(arg6), arg6, 6, "XtGetSelectionValueIncremental", "Time");
  xm_XtSelectionCallback_Descr = XEN_LIST_2(arg4, arg5);
  XtGetSelectionValueIncremental(XEN_TO_C_Widget(arg1), 
				 XEN_TO_C_Atom(arg2), XEN_TO_C_Atom(arg3), 
				 gxm_XtSelectionCallbackProc, 
				 (XtPointer)arg5, XEN_TO_C_Time(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XtGetSelectionRequest(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtGetSelectionRequest "XSelectionRequestEvent* XtGetSelectionRequest(w, selection, request_id)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetSelectionRequest", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtGetSelectionRequest", "Atom");
  XEN_ASSERT_TYPE(XEN_XtRequestId_P(arg3), arg3, 3, "XtGetSelectionRequest", "XtRequestId");
  return(C_TO_XEN_XSelectionRequestEvent(XtGetSelectionRequest(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_XtRequestId(arg3))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtGetSelectionTimeout(void)
{
  #define H_XtGetSelectionTimeout "unsigned long XtGetSelectionTimeout() has been superseded by XtAppGetSelectionTimeout."
  return(C_TO_XEN_ULONG(XtGetSelectionTimeout()));
}

static XEN gxm_XtSetSelectionTimeout(XEN arg1)
{
  #define H_XtSetSelectionTimeout "void XtSetSelectionTimeout(timeout) has been superseded by XtAppSetSelectionTimeout."
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XtSetSelectionTimeout", "ulong");
  XtSetSelectionTimeout(XEN_TO_C_ULONG(arg1));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XtAppGetSelectionTimeout(XEN arg1)
{
  #define H_XtAppGetSelectionTimeout "unsigned long XtAppGetSelectionTimeout(app_context) returns the current selection timeout value, in milliseconds."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppGetSelectionTimeout", "XtAppContext");
  return(C_TO_XEN_ULONG(XtAppGetSelectionTimeout(XEN_TO_C_XtAppContext(arg1))));
}

static XEN gxm_XtAppSetSelectionTimeout(XEN arg1, XEN arg2)
{
  #define H_XtAppSetSelectionTimeout "void XtAppSetSelectionTimeout(app_context, timeout) sets the app's selection timeout mechanism."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppSetSelectionTimeout", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtAppSetSelectionTimeout", "ulong");
  XtAppSetSelectionTimeout(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_ULONG(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtGetSelectionValues(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XtGetSelectionValues "void XtGetSelectionValues(w, selection, targets, count, callback, client_data, time) is similar to \
XtGetSelectionValue except that it takes a list of target types and a list of client data and obtains the current value of the selection \
converted to each of the targets."
  /* DIFF: XtGetSelectionValues arg 3 is list of Atoms
   */
  Atom *outs;
  int len;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetSelectionValues", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtGetSelectionValues", "Atom");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtGetSelectionValues", "list of Atom");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtGetSelectionValues", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg5) && (XEN_REQUIRED_ARGS(arg5) == 7), arg5, 5, "XtGetSelectionValues", "XtSelectionCallbackProc");
  XEN_ASSERT_TYPE(XEN_Time_P(arg7), arg7, 7, "XtGetSelectionValues", "Time");
  len = XEN_TO_C_INT(arg4);
  if (len <= 0) return(XEN_FALSE);
  outs = XEN_TO_C_Atoms(arg3, len);
  xm_XtSelectionCallback_Descr = XEN_LIST_2(arg5, arg6);
  XtGetSelectionValues(XEN_TO_C_Widget(arg1), 
		       XEN_TO_C_Atom(arg2), outs, len, 
		       gxm_XtSelectionCallbackProc, 
		       (XtPointer *)arg6, XEN_TO_C_Time(arg7));
  FREE(outs);
  return(XEN_FALSE);
}

static XEN gxm_XtGetSelectionValue(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtGetSelectionValue "void XtGetSelectionValue(w, selection, target, callback, client_data, time) requests the value of the \
selection that has been converted to the target type. "
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetSelectionValue", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtGetSelectionValue", "Atom");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg3), arg3, 3, "XtGetSelectionValue", "Atom");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 7), arg4, 4, "XtGetSelectionValue", "XtSelectionCallbackProc");
  XEN_ASSERT_TYPE(XEN_Time_P(arg6), arg6, 6, "XtGetSelectionValue", "Time");
  xm_XtSelectionCallback_Descr = XEN_LIST_2(arg4, arg5);
  XtGetSelectionValue(XEN_TO_C_Widget(arg1), 
		      XEN_TO_C_Atom(arg2), 
		      XEN_TO_C_Atom(arg3), 
		      gxm_XtSelectionCallbackProc, 
		      (XtPointer)arg5, XEN_TO_C_Time(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XtDisownSelection(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtDisownSelection "void XtDisownSelection(w, selection, time) informs the selection mechanism that the specified widget is to \
lose ownership of the selection."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtDisownSelection", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtDisownSelection", "Atom");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XtDisownSelection", "Time");
  XtDisownSelection(XEN_TO_C_Widget(arg1), XEN_TO_C_Atom(arg2), XEN_TO_C_Time(arg3));
  return(XEN_FALSE);
}


/*-------- file predicate -------- */

/* (449) XtResolvePathname/XtFindFile local to proc?? */

static XEN xm_filepredicate_proc;

static Boolean gxm_XtFilePredicate(String filename) 
{
  return(XEN_TO_C_BOOLEAN(XEN_CALL_1(xm_filepredicate_proc,
				     C_TO_XEN_STRING(filename),
				     __FUNCTION__)));
}

static XEN gxm_XtResolvePathname(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtResolvePathname "String XtResolvePathname(display, type, filename, suffix, path, substitutions, num_substitutions, predicate)"
  /* DIFF: XtResolvePathname args use #f for NULL
   *       (|XtResolvePathname (|XtDisplay (|Widget (cadr (main-widgets)))) "app-defaults" #f #f #f #f 0 #f)
   */
  char *str;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtResolvePathname", "Display*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg2) || XEN_STRING_P(arg2), arg2, 2, "XtResolvePathname", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg3) || XEN_STRING_P(arg3), arg3, 3, "XtResolvePathname", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg4) || XEN_STRING_P(arg4), arg4, 4, "XtResolvePathname", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg5) || XEN_STRING_P(arg5), arg5, 5, "XtResolvePathname", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg6) || XEN_Substitution_P(arg6), arg6, 6, "XtResolvePathname", "Substitution");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtResolvePathname", "int");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg8) || 
		  (XEN_PROCEDURE_P(arg8) && (XEN_REQUIRED_ARGS(arg8) == 1)), 
		  arg8, 8, "XtResolvePathname", "XtFilePredicate (takes 1 arg)");
  if (XEN_PROCEDURE_P(arg8))
    {
      xm_protect(arg8);
      xm_filepredicate_proc = arg8;
    }
  str = XtResolvePathname(XEN_TO_C_Display(arg1), 
			  (XEN_FALSE_P(arg2)) ? NULL : XEN_TO_C_STRING(arg2), 
			  (XEN_FALSE_P(arg3)) ? NULL : XEN_TO_C_STRING(arg3), 
			  (XEN_FALSE_P(arg4)) ? NULL : XEN_TO_C_STRING(arg4), 
			  (XEN_FALSE_P(arg5)) ? NULL : XEN_TO_C_STRING(arg5), 
			  (XEN_FALSE_P(arg6)) ? NULL : XEN_TO_C_Substitution(arg6), 
			  XEN_TO_C_INT(arg7), 
			  (XEN_FALSE_P(arg8)) ? NULL : gxm_XtFilePredicate);
  if (XEN_PROCEDURE_P(arg8)) xm_unprotect(arg8);
  return(C_TO_XEN_STRING(str));
}

static XEN gxm_XtFindFile(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtFindFile "String XtFindFile(path, substitutions, num_substitutions, predicate) \
searches for a file using substitutions in the path list"
  char *str;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtFindFile", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg2) || XEN_Substitution_P(arg2), arg2, 2, "XtFindFile", "Substitution");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XtFindFile", "int");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg4) || 
		  (XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 1)), 
		  arg4, 4, "XtFindFile", "XtFilePredicate (takes 1 arg)");
  if (XEN_PROCEDURE_P(arg4))
    {
      xm_protect(arg4);
      xm_filepredicate_proc = arg4;
    }
  str = XtFindFile(XEN_TO_C_STRING(arg1), 
		   (XEN_FALSE_P(arg2)) ? NULL : XEN_TO_C_Substitution(arg2), 
		   XEN_TO_C_INT(arg3),
		   (XEN_FALSE_P(arg4) ? NULL : gxm_XtFilePredicate));
  if (XEN_PROCEDURE_P(arg4)) xm_unprotect(arg4);
  return(C_TO_XEN_STRING(str));
}

static XEN gxm_XtSetWMColormapWindows(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtSetWMColormapWindows "void XtSetWMColormapWindows(widget, list, count)"
  /* minor diff: arg2 is a true lisp list */
  Widget *ws = NULL;
  int i, len;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSetWMColormapWindows", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtSetWMColormapWindows", "Widget list");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XtSetWMColormapWindows", "int");
  len = XEN_LIST_LENGTH(arg2);
  if (len > 0)
    {
      ws = (Widget *)CALLOC(len, sizeof(Widget *));
      for (i = 0; i < len; i++, arg2 = XEN_CDR(arg2)) 
	ws[i] = XEN_TO_C_Widget(XEN_CAR(arg2));
    }
  XtSetWMColormapWindows(XEN_TO_C_Widget(arg1), ws, XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XtReleaseGC(XEN arg1, XEN arg2)
{
  #define H_XtReleaseGC "void XtReleaseGC(w, gc) deallocate the specified shared GC."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtReleaseGC", "Widget");
  XEN_ASSERT_TYPE(XEN_GC_P(arg2), arg2, 2, "XtReleaseGC", "GC");
  XtReleaseGC(XEN_TO_C_Widget(arg1), XEN_TO_C_GC(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtDestroyGC(XEN arg1)
{
  #define H_XtDestroyGC "XtDestroyGC(gc) is obsolete -- use XtReleaseGC"
  XEN_ASSERT_TYPE(XEN_GC_P(arg1), arg1, 1, "XtDestroyGC", "GC");
  XtDestroyGC(XEN_TO_C_GC(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtAllocateGC(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtAllocateGC "GC XtAllocateGC(w, depth, value_mask, values, dynamic_mask, unused_mask) returns a sharable GC that may be modified by the client."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAllocateGC", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtAllocateGC", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XtAllocateGC", "XtGCMask");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(arg4), arg4, 4, "XtAllocateGC", "XGCValues*");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg5), arg5, 5, "XtAllocateGC", "XtGCMask");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg6), arg6, 6, "XtAllocateGC", "XtGCMask");
  return(C_TO_XEN_GC(XtAllocateGC(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), 
				  XEN_TO_C_ULONG(arg3), XEN_TO_C_XGCValues(arg4), 
				  XEN_TO_C_ULONG(arg5), XEN_TO_C_ULONG(arg6))));
}

static XEN gxm_XtGetGC(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtGetGC "GC XtGetGC(w, value_mask, values) returns a sharable, read-only GC."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetGC", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtGetGC", "XtGCMask");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(arg3), arg3, 3, "XtGetGC", "XGCValues*");
  return(C_TO_XEN_GC(XtGetGC(XEN_TO_C_Widget(arg1), XEN_TO_C_ULONG(arg2), XEN_TO_C_XGCValues(arg3))));
}


/* -------- background process -------- */

/* (80) XtWorkProc called (protected) until quits or removed explicitly */

#define C_TO_XEN_XM_Background(Code, Context) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("Background"), Code, Context, XEN_ZERO, XEN_ZERO)
#define XM_Background_P(Arg) WRAP_P("Background", Arg)

static Boolean gxm_XtWorkProc(XtPointer cdata)
{
  /* if true, quits */
  int val;
  XEN descr = (XEN)cdata;
  /* (list 'Background function context gc-loc id) */
  val = XEN_TO_C_BOOLEAN(XEN_CALL_1(XEN_CADR(descr), 
				    XEN_CADDR(descr),
				    __FUNCTION__));
  if (val) xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(descr, 3)));
  return(val);
}

static int unprotect_workproc(XEN val, int loc, unsigned long id)
{
  if ((XM_Background_P(val)) &&
      ((XtWorkProcId)XEN_TO_C_ULONG(XEN_LIST_REF(val, 4)) == id))
    {
      xm_unprotect_at(loc);
      return(TRUE);
    }
  return(FALSE);
}

static XEN gxm_XtRemoveWorkProc(XEN arg1)
{
  #define H_XtRemoveWorkProc "void XtRemoveWorkProc(id) explicitly removes the specified background work procedure."
  XtWorkProcId id;
  XEN_ASSERT_TYPE(XEN_XtWorkProcId_P(arg1), arg1, 1, "XtRemoveWorkProc", "XtWorkProcId");
  id = XEN_TO_C_XtWorkProcId(arg1);
  XtRemoveWorkProc(id);
  map_over_protected_elements(unprotect_workproc, id);
  return(XEN_FALSE);
}

static XEN gxm_XtAppAddWorkProc(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtAppAddWorkProc "XtWorkProcId XtAppAddWorkProc(app_context, proc, client_data) adds the specified work procedure for the \
application identified by app_context."
  XtWorkProcId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppAddWorkProc", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 1), arg2, 2, "XtAppAddWorkProc", "(XtWorkProc data)");
  
  descr = C_TO_XEN_XM_Background(arg2, (XEN_BOUND_P(arg3)) ? arg3 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAppAddWorkProc(XEN_TO_C_XtAppContext(arg1), 
			gxm_XtWorkProc, 
			(XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtWorkProcId(id));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtAddWorkProc(XEN arg1, XEN arg2)
{
  #define H_XtAddWorkProc "XtWorkProcId XtAddWorkProc(proc, client_data) has been replaced by XtAppAddWorkProc."
  XtWorkProcId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg1) && (XEN_REQUIRED_ARGS(arg1) == 1), arg1, 1, "XtAddWorkProc", "(XtWorkProc data)");
  descr = C_TO_XEN_XM_Background(arg1, (XEN_BOUND_P(arg2)) ? arg2 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAddWorkProc(gxm_XtWorkProc, 
		     (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtWorkProcId(id));
}
#endif

/* the next 4 are needed where the caller allocates a block of memory, but X frees it (XCreateImage) --
 *   can't use Scheme-allocated memory here etc
 */
static XEN gxm_XtFree(XEN arg1)
{
  #define H_XtFree "void XtFree(ptr)"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XtFree", "pointer");
  XtFree((char *)XEN_TO_C_ULONG(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtRealloc(XEN arg1, XEN arg2)
{
  #define H_XtRealloc "char *XtRealloc(ptr, num)"
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XtRealloc", "pointer");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtRealloc", "int");
  return(C_TO_XEN_ULONG(XtRealloc((char *)XEN_TO_C_ULONG(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XtCalloc(XEN arg1, XEN arg2)
{
  #define H_XtCalloc "char *XtCalloc(num, size)"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XtCalloc", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtCalloc", "int");
  return(C_TO_XEN_ULONG(XtCalloc(XEN_TO_C_INT(arg1), XEN_TO_C_INT(arg2))));
}

static XEN gxm_XtMalloc(XEN arg1)
{
  #define H_XtMalloc "char *XtMalloc(size)"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XtMalloc", "int");
  return(C_TO_XEN_ULONG(XtMalloc(XEN_TO_C_INT(arg1))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtWarning(XEN arg1)
{
  #define H_XtWarning "void XtWarning(message)"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtWarning", "char*");
  XtWarning(XEN_TO_C_STRING(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtAppWarning(XEN arg1, XEN arg2)
{
  #define H_XtAppWarning "void XtAppWarning(app_context, message) calls the installed nonfatal error procedure and passes the specified message."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppWarning", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAppWarning", "char*");
  XtAppWarning(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_STRING(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtError(XEN arg1)
{
  #define H_XtError "void XtError(message)"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtError", "char*");
  XtError(XEN_TO_C_STRING(arg1));
  return(XEN_FALSE);
}
#endif

static XEN xm_XtErrorHandler = XEN_FALSE;
static XEN xm_XtWarningHandler = XEN_FALSE;

static void gxm_XtErrorHandler(String msg)
{
  if (XEN_PROCEDURE_P(xm_XtErrorHandler))
    XEN_CALL_1(xm_XtErrorHandler, 
	       C_TO_XEN_STRING(msg), 
	       __FUNCTION__);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtSetErrorHandler(XEN arg1)
{
  #define H_XtSetErrorHandler "void XtSetErrorHandler(handler) has been superseded by XtAppSetErrorHandler."
  XEN old_val;
  old_val = xm_XtErrorHandler;
  xm_protect(arg1);
  xm_XtErrorHandler = arg1;
  XtSetErrorHandler(gxm_XtErrorHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}
#endif

static XEN gxm_XtAppSetErrorHandler(XEN arg1, XEN arg2)
{
  #define H_XtAppSetErrorHandler "void XtAppSetErrorHandler(app_context, handler) registers the specified procedure, which is called when \
a fatal error condition occurs."
  XEN old_val;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppSetErrorHandler", "XtAppContext");
  old_val = xm_XtErrorHandler;
  xm_protect(arg2);
  xm_XtErrorHandler = arg2;
  XtAppSetErrorHandler(XEN_TO_C_XtAppContext(arg1), gxm_XtErrorHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}

static void gxm_XtWarningHandler(String msg)
{
  if (XEN_PROCEDURE_P(xm_XtWarningHandler))
    XEN_CALL_1(xm_XtWarningHandler, 
	       C_TO_XEN_STRING(msg), 
	       __FUNCTION__);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtSetWarningHandler(XEN arg1)
{
  #define H_XtSetWarningHandler "void XtSetWarningHandler(handler) has been superseded by XtAppSetWarningHandler."
  XEN old_val;
  old_val = xm_XtWarningHandler;
  xm_protect(arg1);
  xm_XtWarningHandler = arg1;
  XtSetWarningHandler(gxm_XtWarningHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}
#endif

static XEN gxm_XtAppSetWarningHandler(XEN arg1, XEN arg2)
{
  #define H_XtAppSetWarningHandler "void XtAppSetWarningHandler(app_context, handler) registers the specified procedure, which is called \
when a nonfatal error condition occurs."
  XEN old_val;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppSetWarningHandler", "XtAppContext");
  old_val = xm_XtWarningHandler;
  xm_protect(arg2);
  xm_XtWarningHandler = arg2;
  XtAppSetWarningHandler(XEN_TO_C_XtAppContext(arg1), gxm_XtWarningHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}

static XEN gxm_XtAppError(XEN arg1, XEN arg2)
{
  #define H_XtAppError "void XtAppError(app_context, message) calls the installed error procedure and passes the specified message."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppError", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAppError", "char*");
  XtAppError(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_STRING(arg2));
  return(XEN_FALSE);
}


#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtWarningMsg(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtWarningMsg "void XtWarningMsg(name, type, class, default, params, num_params)"
  /* DIFF: XtWarningMsg takes final int not int*, arg5 is list of strings
   */
  int size;
  Cardinal csize;
  char **pars;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtWarningMsg", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtWarningMsg", "int");
  size = XEN_TO_C_INT(arg6);
  if (size <= 0) return(XEN_FALSE);
  pars = XEN_TO_C_Strings(arg5, size);
  csize = (Cardinal)size;
  XtWarningMsg(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_STRING(arg3), XEN_TO_C_STRING(arg4), pars, &csize);
  FREE(pars);
  return(XEN_FALSE);
}
#endif

static XEN gxm_XtAppWarningMsg(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XtAppWarningMsg "void XtAppWarningMsg(app_context, name, type, class, default, params, num_params) calls the high-level error \
handler and passes the specified information."
  /* DIFF: XtAppWarningMsg takes final int not int*, arg5 is list of strings
   */
  int size;
  Cardinal csize;
  char **pars;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppWarningMsg", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAppWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtAppWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtAppWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XtAppWarningMsg", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg6), arg6, 6, "XtAppWarningMsg", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtAppWarningMsg", "int");
  size = XEN_TO_C_INT(arg7);
  if (size <= 0) return(XEN_FALSE);
  pars = XEN_TO_C_Strings(arg5, size);
  csize = (Cardinal)size;
  XtAppWarningMsg(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_STRING(arg2), 
		  XEN_TO_C_STRING(arg3), XEN_TO_C_STRING(arg4), XEN_TO_C_STRING(arg5), 
		  pars, &csize);
  FREE(pars);
  return(XEN_FALSE);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtErrorMsg(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtErrorMsg "void XtErrorMsg(name, type, class, default, params, num_params) has been superseded by XtAppErrorMsg."
  /* DIFF: XtErrorMsg takes final int not int*, arg5 is list of strings
   */
  int size;
  Cardinal csize;
  char **pars;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtErrorMsg", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtErrorMsg", "int");
  size = XEN_TO_C_INT(arg6);
  if (size <= 0) return(XEN_FALSE);
  pars = XEN_TO_C_Strings(arg5, size);
  csize = (Cardinal)size;
  XtErrorMsg(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2), XEN_TO_C_STRING(arg3), XEN_TO_C_STRING(arg4), pars, &csize);
  FREE(pars);
  return(XEN_FALSE);
}
#endif

static XEN gxm_XtAppErrorMsg(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7)
{
  #define H_XtAppErrorMsg "void XtAppErrorMsg(app_context, name, type, class, default, params, num_params) calls the high-level error \
handler and passes the specified information."
  /* DIFF: XtAppErrorMsg takes final int not int*, arg5 is list of strings
   */
  int size;
  Cardinal csize;
  char **pars;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppErrorMsg", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAppErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtAppErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtAppErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XtAppErrorMsg", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg6), arg6, 6, "XtAppErrorMsg", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtAppErrorMsg", "int");
  size = XEN_TO_C_INT(arg7);
  if (size <= 0) return(XEN_FALSE);
  pars = XEN_TO_C_Strings(arg6, size);
  csize = (Cardinal)size;
  XtAppErrorMsg(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_STRING(arg2), 
		XEN_TO_C_STRING(arg3), XEN_TO_C_STRING(arg4), 
		XEN_TO_C_STRING(arg5), pars, &csize);
  FREE(pars);
  return(XEN_FALSE);
}

static XEN xm_XtErrorMsgHandler = XEN_FALSE;
static XEN xm_XtWarningMsgHandler = XEN_FALSE;

static void gxm_XtErrorMsgHandler(String name, String type, String clas, String defp, String *pars, Cardinal *num)
{
  /* DIFF: XtErrorMsgHandler takes list of string pars
   */
  int i, len;
  XEN lst = XEN_EMPTY_LIST;
  if (XEN_PROCEDURE_P(xm_XtErrorMsgHandler))
    {
      xm_protect(lst);
      len = (*num);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_STRING(pars[i]), lst);
      XEN_CALL_6(xm_XtErrorMsgHandler, 
		 C_TO_XEN_STRING(name),
		 C_TO_XEN_STRING(type),
		 C_TO_XEN_STRING(clas),
		 C_TO_XEN_STRING(defp),
		 lst,
		 C_TO_XEN_INT(*num),
		 __FUNCTION__);
      xm_unprotect(lst);
    }
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtSetErrorMsgHandler(XEN arg1)
{
  #define H_XtSetErrorMsgHandler "void XtSetErrorMsgHandler(msg_handler) has been superseded by XtAppSetErrorMsgHandler."
  XEN old_val;
  old_val = xm_XtErrorMsgHandler;
  xm_protect(arg1);
  xm_XtErrorMsgHandler = arg1;
  XtSetErrorMsgHandler(gxm_XtErrorMsgHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}
#endif

static XEN gxm_XtAppSetErrorMsgHandler(XEN arg1, XEN arg2)
{
  #define H_XtAppSetErrorMsgHandler "void XtAppSetErrorMsgHandler(app_context, msg_handler) registers the specified procedure, which is called \
when a fatal error occurs."
  XEN old_val;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppSetErrorMsgHandler", "XtAppContext");
  old_val = xm_XtErrorMsgHandler;
  xm_protect(arg2);
  xm_XtErrorMsgHandler = arg2;
  XtAppSetErrorMsgHandler(XEN_TO_C_XtAppContext(arg1), gxm_XtErrorMsgHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}


static void gxm_XtWarningMsgHandler(String name, String type, String clas, String defp, String *pars, Cardinal *num)
{
  /* DIFF: XtWarningMsgHandler takes list of string pars
   */
  int i, len;
  XEN lst = XEN_EMPTY_LIST;
  if (XEN_PROCEDURE_P(xm_XtWarningMsgHandler))
    {
      xm_protect(lst);
      len = (*num);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_STRING(pars[i]), lst);
      XEN_CALL_6(xm_XtWarningMsgHandler, 
		 C_TO_XEN_STRING(name),
		 C_TO_XEN_STRING(type),
		 C_TO_XEN_STRING(clas),
		 C_TO_XEN_STRING(defp),
		 lst,
		 C_TO_XEN_INT(*num),
		 __FUNCTION__);
      xm_unprotect(lst);
    }
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtSetWarningMsgHandler(XEN arg1)
{
  #define H_XtSetWarningMsgHandler "void XtSetWarningMsgHandler(msg_handler) has been superseded by XtAppSetWarningMsgHandler."
  XEN old_val;
  old_val = xm_XtWarningMsgHandler;
  xm_protect(arg1);
  xm_XtWarningMsgHandler = arg1;
  XtSetWarningMsgHandler(gxm_XtWarningMsgHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}
#endif

static XEN gxm_XtAppSetWarningMsgHandler(XEN arg1, XEN arg2)
{
  #define H_XtAppSetWarningMsgHandler "void XtAppSetWarningMsgHandler(app_context, msg_handler) registers the specified procedure, which \
is called when a nonfatal error condition occurs."
  XEN old_val;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppSetWarningMsgHandler", "XtAppContext");
  old_val = xm_XtWarningMsgHandler;
  xm_protect(arg2);
  xm_XtWarningMsgHandler = arg2;
  XtAppSetWarningMsgHandler(XEN_TO_C_XtAppContext(arg1), gxm_XtWarningMsgHandler);
  if (XEN_PROCEDURE_P(old_val)) xm_unprotect(old_val);
  return(old_val);
}

static XEN gxm_XtGetValues(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtGetValues "void XtGetValues(Widget w, ArgList args, Cardinal num_args) returns the values of the \
resources specified for the widget w.  In xm, 'args' is a list of resource names followed by a placeholder \
(normally 0), and the length of the arglist is optional.  For example, to get the current height and width \
of a widget, (" XM_PREFIX "XtGetValues" XM_POSTFIX " w (list " XM_PREFIX "XmNheight" XM_POSTFIX " 0 \
" XM_PREFIX "XmNwidth" XM_POSTFIX " 0)) which returns the list with the values filled in: (list height 123 \
width 321).  If the resource value is an array in C, it is returned as a list."

  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetValues", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtGetValues", "List");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XtGetValues", "int");
  return(gxm_XtGetValues_1(arg1, arg2, XEN_TO_C_INT_DEF(arg3, arg2)));
}

static XEN gxm_XtVaGetValues(XEN arg1, XEN arg2)
{
  #define H_XtVaGetValues "void XtVaGetValues(w, ...) in xm is the same as XtGetValues."
  /* DIFF: XtVaGetValues -> returns original list with vals in place 
   */
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtVaGetValues", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtVaGetValues", "List");
  return(gxm_XtGetValues_1(arg1, arg2, XEN_LIST_LENGTH(arg2) / 2));
}

static XEN gxm_XtVaSetValues(XEN arg1, XEN arg2)
{
  #define H_XtVaSetValues "void XtVaSetValues(w, ...) in xm is the same as XtSetValues."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtVaSetValues", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtVaSetValues", "List");
  {
    Widget w;
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg2);
    w = XEN_TO_C_Widget(arg1);
    XtSetValues(w, args, arglen = XEN_LIST_LENGTH(arg2) / 2);
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(XEN_FALSE);
}

static XEN gxm_XtSetValues(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtSetValues "void XtSetValues(Widget w, ArgList args, Cardinal num_args) sets the values of the \
resources specified for the widget w.  In xm, 'args' is a list of resource names followed by the new value, \
and the length of the arglist is optional.  For example, to set the current height and width \
of a widget, (" XM_PREFIX "XtSetValues" XM_POSTFIX " w (list " XM_PREFIX "XmNheight" XM_POSTFIX " 123 \
" XM_PREFIX "XmNwidth" XM_POSTFIX " 321)).  If the resource value in C is an array, it is a list in xm."

  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSetValues", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtSetValues", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg3), arg3, 3, "XtSetValues", "int");
  {
    Arg *args;
    int arglen;
    Widget w;
    w = XEN_TO_C_Widget(arg1);
    args = XEN_TO_C_Args(arg2);
    XtSetValues(w, args, arglen = XEN_TO_C_INT_DEF(arg3, arg2));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(XEN_FALSE);
}

static XEN gxm_XtCloseDisplay(XEN arg1)
{
  #define H_XtCloseDisplay "void XtCloseDisplay(display) closes the specified display as soon as it is safe to do so."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtCloseDisplay", "Display*");
  XtCloseDisplay(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtDisplayToApplicationContext(XEN arg1)
{
  #define H_XtDisplayToApplicationContext "XtAppContext XtDisplayToApplicationContext(dpy) returns the application context for the specified display."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtDisplayToApplicationContext", "Display*");
  return(C_TO_XEN_XtAppContext(XtDisplayToApplicationContext(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XtWidgetToApplicationContext(XEN arg1)
{
  #define H_XtWidgetToApplicationContext "XtAppContext XtWidgetToApplicationContext(w) returns the application context for the specified widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtWidgetToApplicationContext", "Widget");
  return(C_TO_XEN_XtAppContext(XtWidgetToApplicationContext(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtInitializeWidgetClass(XEN arg1)
{
  #define H_XtInitializeWidgetClass "void XtInitializeWidgetClass(object_class)"
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg1), arg1, 1, "XtInitializeWidgetClass", "WidgetClass");
  XtInitializeWidgetClass(XEN_TO_C_WidgetClass(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtDestroyApplicationContext(XEN arg1)
{
  #define H_XtDestroyApplicationContext "void XtDestroyApplicationContext(app_context) destroys the specified application context as soon as it is safe to do so."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtDestroyApplicationContext", "XtAppContext");
  XtDestroyApplicationContext(XEN_TO_C_XtAppContext(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtCreateApplicationContext(void)
{
  #define H_XtCreateApplicationContext "XtAppContext XtCreateApplicationContext()"
  return(C_TO_XEN_XtAppContext(XtCreateApplicationContext()));
}

static XEN gxm_argv_to_list(XEN lst, int argc, char **argv)
{
  int i, loc;
  loc = xm_protect(lst);
  for (i = argc - 1; i >= 0; i--)
    lst = XEN_CONS(C_TO_XEN_STRING(argv[i]), lst);
  FREE(argv);
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XtOpenDisplay(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtOpenDisplay "Display *XtOpenDisplay(app_context, display_string, application_name, application_class, options, num_options, argc, argv) \
calls XOpenDisplay the specified display name."
  /* DIFF: XtOpenDisplay ignore arg5 6, argc is int, argv is list of strings, returns (list dpy argv ...)
   */
  char **argv;
  int argc;
  XEN lst = XEN_EMPTY_LIST;
  Display *dpy;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtOpenDisplay", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtOpenDisplay", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtOpenDisplay", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtOpenDisplay", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtOpenDisplay", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 8, "XtOpenDisplay", "list of char*");
  argc = XEN_TO_C_INT(arg7);
  argv = XEN_TO_C_Strings(arg8, argc);
  dpy = XtOpenDisplay(XEN_TO_C_XtAppContext(arg1), 
		      XEN_TO_C_STRING(arg2), 
		      XEN_TO_C_STRING(arg3), 
		      XEN_TO_C_STRING(arg4), 
		      NULL, 0, &argc, argv);
  if (dpy)
    lst = XEN_CONS(C_TO_XEN_Display(dpy), lst);
  else lst = XEN_CONS(XEN_FALSE, lst);
  return(gxm_argv_to_list(lst, argc, argv));
}

#if (!XM_DISABLE_DEPRECATED) 
static XEN gxm_XtInitialize(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtInitialize "Widget XtInitialize(shell_name, application_class, options, num_options, argc, argv) calls XtToolkitInitialize \
followed by XtOpenDisplay with display_string NULL and application_name NULL, and finally calls XtAppCreateShell with appcation_name NULL, \
widget_class applicationShellWidgetClass , and the specified args and num_args and returns the created shell. "
  /* DIFF: XtInitialize ignore arg 3 4, argc is int, argv is list of strings
   */
  char **argv;
  int argc;
  Widget w;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XtInitialize", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg6), arg6, 6, "XtInitialize", "list of char*");
  argc = XEN_TO_C_INT(arg5);
  argv = XEN_TO_C_Strings(arg6, argc);
  w = XtInitialize(XEN_TO_C_STRING(arg1), XEN_TO_C_STRING(arg2), NULL, 0, &argc, argv);
  return(gxm_argv_to_list(XEN_CONS(C_TO_XEN_Widget(w), XEN_EMPTY_LIST), argc, argv));
}
#endif

static XEN gxm_XtVaAppInitialize(XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtVaAppInitialize "Widget XtVaAppInitialize(app_context_return, application_class, options, num_options, argc_in_out, argv_in_out, fallback_resources, ...)"
  /* DIFF: XtVaAppInitialize [app] class {options numopts} {argc} argv resources -> (list widget app (new argv)), argc is int not int* fallback/options/num ignored
     Arg *args;
     app is returned not passed (list widget app) 
  */
  XtAppContext app;
  Arg *args;
  Widget res;
  int argc, arglen;
  char **argv;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 1, "XtVaAppInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 4, "XtVaAppInitialize", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg6), arg6, 5, "XtVaAppInitialize", "list of String");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 7, "XtVaAppInitialize", "arg list");
  argc = XEN_TO_C_INT(arg5);
  args = XEN_TO_C_Args(arg8);
  argv = XEN_TO_C_Strings(arg8, argc);
  res = XtAppInitialize(&app, 
			XEN_TO_C_STRING(arg2), 
			NULL,
			0,
			&argc, 
			argv,
			NULL,
			args,
			arglen = XEN_LIST_LENGTH(arg8) / 2);
  if (args)
    {
      fixup_args(res, args, arglen);
      FREE(args);
    }
  return(XEN_LIST_3(C_TO_XEN_Widget(res), 
		    C_TO_XEN_XtAppContext(app),
		    gxm_argv_to_list(XEN_EMPTY_LIST, argc, argv)));
}


static XEN gxm_XtAppInitialize(XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XtAppInitialize "Widget XtAppInitialize(app_context_return, application_class, options, num_options, argc_in_out, argv_in_out, \
fallback_resources, args, num_args) calls XtToolkitInitialize followed by XtCreateApplicationContext ,then calls XtOpenDisplay with \
display_string NULL and application_name NULL, and finally calls XtAppCreateShell with appcation_name NULL, widget_class applicationShellWidgetClass , \
and the specified args and num_args and returns the created shell. "
  /* DIFF: XtAppInitialize [app] class {options numopts} {argc} argv resources args numargs -> (list widget app), argc is int not int* fallback/options/num ignored
     Arg *args;
     app is returned not passed (list widget app) 
  */
  XtAppContext app;
  Arg *args;
  Widget res;
  int argc, arglen;
  char **argv;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 1, "XtAppInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 4, "XtAppInitialize", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg6), arg6, 5, "XtAppInitialize", "list of String*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 7, "XtAppInitialize", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 8, "XtAppInitialize", "int");
  argc = XEN_TO_C_INT(arg5);
  args = XEN_TO_C_Args(arg8);
  argv = XEN_TO_C_Strings(arg6, argc);
  res = XtAppInitialize(&app,
			XEN_TO_C_STRING(arg2), 
			NULL,
			0,
			&argc,
			argv,
			NULL,
			args,
			arglen = XEN_TO_C_INT(arg9));
  if (args)
    {
      fixup_args(res, args, arglen);
      FREE(args);
    }
  return(XEN_LIST_3(C_TO_XEN_Widget(res), 
		    C_TO_XEN_XtAppContext(app),
		    gxm_argv_to_list(XEN_EMPTY_LIST, argc, argv)));
}

static XEN gxm_XtVaOpenApplication(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtVaOpenApplication "Widget XtVaOpenApplication(app_context_return, application_class, options, num_options, argc_in_out, argv_in_out, fallback_resources, widget_class, ...)"
  /* DIFF: XtVaOpenApplication [app] name {options numopts} {argc} argv resources class args -> (list widget app), argc is int not int* options/num ignored
     Arg *args;
     app is returned not passed (list widget app) 
  */
  XtAppContext app;
  Arg *args;
  Widget res;
  int argc, arglen;
  char **argv;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtVaOpenApplication", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XtVaOpenApplication", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtVaOpenApplication", "list of String");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg7), arg7, 7, "XtVaOpenApplication", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 8, "XtVaOpenApplication", "arg list");
  args = XEN_TO_C_Args(arg8);
  argc = XEN_TO_C_INT(arg3);
  argv = XEN_TO_C_Strings(arg5, argc);
  res = XtOpenApplication(&app, 
			  XEN_TO_C_STRING(arg1), 
			  NULL,
			  0,
			  &argc,
			  argv,
			  NULL,
			  XEN_TO_C_WidgetClass(arg7), 
			  args, 
			  arglen = XEN_LIST_LENGTH(arg8) / 2);
  if (args)
    {
      fixup_args(res, args, arglen);
      FREE(args);
    }
  return(XEN_LIST_3(C_TO_XEN_Widget(res), 
		    C_TO_XEN_XtAppContext(app),
		    gxm_argv_to_list(XEN_EMPTY_LIST, argc, argv)));
}

static XEN gxm_XtOpenApplication(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8, XEN arg9)
{
  #define H_XtOpenApplication "Widget XtOpenApplication(app_context_return, application_class, options, num_options, argc_in_out, argv_in_out, \
fallback_resources, widget_class, args, num_args) calls XtToolkitInitialize followed by XtCreateApplicationContext , then calls XtOpenDisplay \
with display_string NULL and application_name NULL, and finally calls XtAppCreateShell with appcation_name NULL, widget_class \
applicationShellWidgetClass ,and the specified args and num_args and returns the created shell."
  /* DIFF: XtOpenApplication [app] name {options numopts} {argc} argv resources class args argnum -> (list widget app), argc is int not int* options/num ignored
  */
  XtAppContext app;
  Arg *args;
  Widget res;
  int argc, arglen;
  char **argv;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtOpenApplication", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtOpenApplication", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtOpenApplication", "list of String*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg7), arg7, 7, "XtOpenApplication", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 8, "XtOpenApplication", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg9), arg9, 9, "XtOpenApplication", "int");
  argc = XEN_TO_C_INT(arg4);
  args = XEN_TO_C_Args(arg8);
  argv = XEN_TO_C_Strings(arg5, argc);
  res = XtOpenApplication(&app, XEN_TO_C_STRING(arg1), 
			  NULL, 0, &argc,
			  argv, NULL, XEN_TO_C_WidgetClass(arg7), 
			  args, arglen = XEN_TO_C_INT(arg9));
  if (args)
    {
      fixup_args(res, args, arglen);
      FREE(args);
    }
  return(XEN_LIST_3(C_TO_XEN_Widget(res), 
		    C_TO_XEN_XtAppContext(app),
		    gxm_argv_to_list(XEN_EMPTY_LIST, argc, argv)));
}

/* (define appres (|XtVaOpenApplication "hioh" 0 0 0 0 0 |applicationShellWidgetClass (list |XmNallowShellResize 1))) */

static XEN gxm_XtDisplayInitialize(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtDisplayInitialize "void XtDisplayInitialize(app_context, display, application_name, application_class, options, num_options, argc, argv) \
builds the resource database, calls the Xlib XrmParseCommand to parse the command line, and performs other per display initialization."
  /* DIFF: XtDisplayInitialize arg 5 6 ignored, argc is normal int, argv is list of strings, returns argv
   */
  char **argv;
  int argc;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtDisplayInitialize", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_Display_P(arg2), arg2, 2, "XtDisplayInitialize", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XtDisplayInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XtDisplayInitialize", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg7), arg7, 7, "XtDisplayInitialize", "int");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg8), arg8, 8, "XtDisplayInitialize", "list of char*");
  argc = XEN_TO_C_INT(arg7);
  argv = XEN_TO_C_Strings(arg8, argc);
  XtDisplayInitialize(XEN_TO_C_XtAppContext(arg1), 
		      XEN_TO_C_Display(arg2), 
		      XEN_TO_C_STRING(arg3), 
		      XEN_TO_C_STRING(arg4), 
		      NULL, 0, 
		      &argc, argv);
  return(gxm_argv_to_list(XEN_EMPTY_LIST, argc, argv));
}

/* -------- XtLanguage callback -------- */
/* (456) a global */

static XEN xm_language_proc = XEN_FALSE;

static String gxm_XtLanguageProc(Display* d, String s, XtPointer context) 
{
  return(XEN_TO_C_STRING(XEN_CALL_3(xm_language_proc,
				    C_TO_XEN_Display(d),
				    C_TO_XEN_STRING(s),
				    (XEN)context,
				    __FUNCTION__)));
}

static XEN gxm_XtSetLanguageProc(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtSetLanguageProc "Widget XtSetLanguageProc(app_context, proc, client_data)"
  /* arg can be null -> use default */
  /* DIFF: XtSetLanguageProc args1 and 2 use #f for NULL, return of #f means none was set
   */
  XEN previous_proc = XEN_FALSE;
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg1) || XEN_XtAppContext_P(arg1), arg1, 1, "XtSetLanguageProc", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg2) || (XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 3)), arg2, 2, "XtSetLanguageProc", "XtLanguageProc");
  previous_proc = xm_language_proc;
  if (XEN_PROCEDURE_P(previous_proc))
    xm_unprotect(previous_proc);
  if (XEN_PROCEDURE_P(arg2))
    xm_protect(arg2);
  if (XEN_FALSE_P(arg1))
    {
      if (XEN_FALSE_P(arg2))
	XtSetLanguageProc(NULL, NULL, NULL);
      else XtSetLanguageProc(NULL,
			     (XtLanguageProc)gxm_XtLanguageProc, 
			     (XtPointer)arg3);
    }
  else 
    {
      if (XEN_FALSE_P(arg2))
	XtSetLanguageProc(XEN_TO_C_XtAppContext(arg1), NULL, NULL);
      else  XtSetLanguageProc(XEN_TO_C_XtAppContext(arg1), 
			      (XtLanguageProc)gxm_XtLanguageProc, 
			      (XtPointer)arg3);
    }
  return(previous_proc);
}

static XEN gxm_XtToolkitInitialize(void)
{
  #define H_XtToolkitInitialize "void XtToolkitInitialize()"
  XtToolkitInitialize();
  return(XEN_FALSE);
}

static XEN gxm_XtVaAppCreateShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtVaAppCreateShell "Widget XtVaAppCreateShell(application_name, application_class, widget_class, display, ...)"
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtVaAppCreateShell", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtVaAppCreateShell", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg3), arg3, 3, "XtVaAppCreateShell", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Display_P(arg4), arg4, 4, "XtVaAppCreateShell", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtVaAppCreateShell", "List");
  args = XEN_TO_C_Args(arg5);
  w = XtAppCreateShell(XEN_TO_C_STRING(arg1), 
		       XEN_TO_C_STRING(arg2), 
		       XEN_TO_C_WidgetClass(arg3), 
		       XEN_TO_C_Display(arg4), 
		       args,
		       arglen = XEN_LIST_LENGTH(arg5) / 2);
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtAppCreateShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtAppCreateShell "Widget XtAppCreateShell(application_name, application_class, widget_class, display, args, num_args) saves \
the specified application name and application class for qualifying all widget resource specifiers."
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtAppCreateShell", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAppCreateShell", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg3), arg3, 3, "XtAppCreateShell", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Display_P(arg4), arg4, 4, "XtAppCreateShell", "Display*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg5), arg5, 5, "XtAppCreateShell", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg6), arg6, 6, "XtAppCreateShell", "int");
  args = XEN_TO_C_Args(arg5);
  w = XtAppCreateShell(XEN_TO_C_STRING(arg1), 
		       XEN_TO_C_STRING(arg2), 
		       XEN_TO_C_WidgetClass(arg3), 
		       XEN_TO_C_Display(arg4), 
		       args, 
		       arglen = XEN_TO_C_INT_DEF(arg6, arg5));
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtCreateApplicationShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtCreateApplicationShell "Widget XtCreateApplicationShell(name, widget_class, args, num_args) calls XtAppCreateShell with the \
application NULL, the application class passed to XtInitialize , and the default application context created by XtInitialize. This \
routine has been replaced by XtAppCreateShell."
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtCreateApplicationShell", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtCreateApplicationShell", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtCreateApplicationShell", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg4), arg4, 4, "XtCreateApplicationShell", "int");
  args = XEN_TO_C_Args(arg3);
  w = XtCreateApplicationShell(XEN_TO_C_STRING(arg1), 
			       XEN_TO_C_WidgetClass(arg2), 
			       args, arglen = XEN_TO_C_INT_DEF(arg4, arg3));
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}
#endif

static XEN gxm_XtVaCreateManagedWidget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtVaCreateManagedWidget "Widget XtVaCreateManagedWidget(name, widget_class, parent, ...)"
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtVaCreateManagedWidget", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtVaCreateManagedWidget", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtVaCreateManagedWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtVaCreateManagedWidget", "List");
  args = XEN_TO_C_Args(arg4);
  w = XtCreateManagedWidget(XEN_TO_C_STRING(arg1),
			    XEN_TO_C_WidgetClass(arg2), 
			    XEN_TO_C_Widget(arg3), 
			    args,
			    arglen = XEN_LIST_LENGTH(arg4) / 2);
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtVaCreateWidget(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtVaCreateWidget "Widget XtVaCreateWidget(name, widget_class, parent, ...)"
  Arg *args;
  int arglen;
  Widget w;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtVaCreateWidget", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtVaCreateWidget", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtVaCreateWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtVaCreateWidget", "List");
  args = XEN_TO_C_Args(arg4);
  w = XtCreateWidget(XEN_TO_C_STRING(arg1), 
		     XEN_TO_C_WidgetClass(arg2), 
		     XEN_TO_C_Widget(arg3), 
		     args,
		     arglen = XEN_LIST_LENGTH(arg4) / 2);
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtCreateManagedWidget(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtCreateManagedWidget "Widget XtCreateManagedWidget(name, widget_class, parent, args, num_args) is a routine \
that calls XtCreateWidget and XtManageChild."
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtCreateManagedWidget", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtCreateManagedWidget", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtCreateManagedWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtCreateManagedWidget", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XtCreateManagedWidget", "int");
  args = XEN_TO_C_Args(arg4);
  w = XtCreateManagedWidget(XEN_TO_C_STRING(arg1), 
			    XEN_TO_C_WidgetClass(arg2), 
			    XEN_TO_C_Widget(arg3), 
			    args, arglen = XEN_TO_C_INT_DEF(arg5, arg4));
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtCreateWidget(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtCreateWidget "Widget XtCreateWidget(name, widget_class, parent, args, num_args) performs much of the boilerplate operations of widget creation."
  Arg *args;
  Widget w;
  int arglen;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtCreateWidget", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtCreateWidget", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtCreateWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtCreateWidget", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XtCreateWidget", "int");
  args = XEN_TO_C_Args(arg4);
  w = XtCreateWidget(XEN_TO_C_STRING(arg1), 
		     XEN_TO_C_WidgetClass(arg2), 
		     XEN_TO_C_Widget(arg3), 
		     args, arglen = XEN_TO_C_INT_DEF(arg5, arg4));
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtCallbackPopdown(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallbackPopdown "void XtCallbackPopdown(w, client_data, call_data) calls XtPopdown with the specified shell_widget and then \
calls XtSetSensitive to resensitize the enable_widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallbackPopdown", "Widget");
  XtCallbackPopdown(XEN_TO_C_Widget(arg1), (XtPointer)arg2, (XtPointer)arg3);
  return(XEN_FALSE);
}

static XEN gxm_XtPopdown(XEN arg1)
{
  #define H_XtPopdown "void XtPopdown(popup_shell)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtPopdown", "Widget");
  XtPopdown(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtCallbackExclusive(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallbackExclusive "void XtCallbackExclusive(w, client_data, call_data)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallbackExclusive", "Widget");
  XtCallbackExclusive(XEN_TO_C_Widget(arg1), (XtPointer)arg2, (XtPointer)arg3);
  return(XEN_FALSE);
}

static XEN gxm_XtCallbackNonexclusive(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallbackNonexclusive "void XtCallbackNonexclusive(w, client_data, call_data)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallbackNonexclusive", "Widget");
  XtCallbackNonexclusive(XEN_TO_C_Widget(arg1), (XtPointer)arg2, (XtPointer)arg3);
  return(XEN_FALSE);
}

static XEN gxm_XtCallbackNone(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallbackNone "void XtCallbackNone(w, client_data, call_data)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallbackNone", "Widget");
  XtCallbackNone(XEN_TO_C_Widget(arg1), (XtPointer)arg2, (XtPointer)arg3);
  return(XEN_FALSE);
}

static XEN gxm_XtPopupSpringLoaded(XEN arg1)
{
  #define H_XtPopupSpringLoaded "void XtPopupSpringLoaded(popup_shell)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtPopupSpringLoaded", "Widget");
  XtPopupSpringLoaded(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtPopup(XEN arg1, XEN arg2)
{
  #define H_XtPopup "void XtPopup(popup_shell, grab_kind)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtPopup", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtPopup", "XtGrabKind");
  XtPopup(XEN_TO_C_Widget(arg1), (XtGrabKind)XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtVaCreatePopupShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtVaCreatePopupShell "Widget XtVaCreatePopupShell(name, widget_class, parent, ...)"
  Arg *args;
  int arglen;
  Widget w;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtVaCreatePopupShell", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtVaCreatePopupShell", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtVaCreatePopupShell", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtVaCreatePopupShell", "List");
  args = XEN_TO_C_Args(arg4);
  w = XtVaCreatePopupShell(XEN_TO_C_STRING(arg1), 
			   XEN_TO_C_WidgetClass(arg2), 
			   XEN_TO_C_Widget(arg3),
			   args,
			   arglen = XEN_LIST_LENGTH(arg4) / 2);
  if (args)
    {
      fixup_args(w, args, arglen);
      FREE(args);
    }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtCreatePopupShell(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtCreatePopupShell "Widget XtCreatePopupShell(name, widget_class, parent, args, num_args) ensures that the specified \
class is a subclass of Shell and, rather than using insert_child to attach the widget to the parent's children list, attaches the shell \
to the parent's pop-ups list directly."
  Widget w;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtCreatePopupShell", "char*");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtCreatePopupShell", "WidgetClass");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg3), arg3, 3, "XtCreatePopupShell", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4), arg4, 4, "XtCreatePopupShell", "ArgList");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XtCreatePopupShell", "int");
  {
    Arg *args;
    int arglen;
    args = XEN_TO_C_Args(arg4);
    w = XtCreatePopupShell(XEN_TO_C_STRING(arg1), 
			   XEN_TO_C_WidgetClass(arg2), 
			   XEN_TO_C_Widget(arg3), 
			   args, arglen = XEN_TO_C_INT_DEF(arg5, arg4));
    if (args)
      {
	fixup_args(w, args, arglen);
	FREE(args);
      }
  }
  return(C_TO_XEN_Widget(w));
}

static XEN gxm_XtHasCallbacks(XEN arg1, XEN arg2)
{
  #define H_XtHasCallbacks "XtCallbackStatus XtHasCallbacks(w, callback_name) first checks to see if the widget has a callback \
list identified by callback_name; returns XtCallbackNoList or XtCallbackHasNone if none, else XtCallbackHasSome"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtHasCallbacks", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtHasCallbacks", "char*");
  return(C_TO_XEN_INT(XtHasCallbacks(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XtCallCallbackList(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallCallbackList "XtCallCallbackList(w, callbacks, call_data) calls each of the callback procedures in the list \
passing client data call_data"

  /* DIFF: XtCallCallbackList takes list of (func data) pairs as arg2 
   */
  XtCallbackRec *calls;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallCallbackList", "Widget");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtCallCallbackList", "list of XtCallbacks");
  calls = XEN_TO_C_XtCallbackList(arg2);
  XtCallCallbackList(XEN_TO_C_Widget(arg1), calls, (XtPointer)arg3);
  FREE(calls);
  return(XEN_FALSE);
}

static XEN gxm_XtCallCallbacks(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtCallCallbacks "void XtCallCallbacks(w, callback_name, call_data) calls each procedure that is registered in the \
specified widget's callback list. The call_data arg is assumed to be a callback struct reference"
  XtPointer val = NULL;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallCallbacks", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtCallCallbacks", "char*");
  if (XEN_LIST_P(arg3)) val = (XtPointer)XEN_TO_C_ULONG(XEN_CADR(arg3));
  XtCallCallbacks(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2), val);
  return(XEN_FALSE);
}

static XEN gxm_XtRemoveAllCallbacks(XEN arg1, XEN arg2)
{
  #define H_XtRemoveAllCallbacks "void XtRemoveAllCallbacks(w, callback_name) removes all the callback procedures from the specified widget's callback list."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveAllCallbacks", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtRemoveAllCallbacks", "char*");
  XtRemoveAllCallbacks(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtRemoveCallbacks(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtRemoveCallbacks "void XtRemoveCallbacks(w, callback_name, callbacks) removes the specified callback procedures from the \
specified widget's callback list."
  /* DIFF: XtRemoveCallbacks takes list of (func data) pairs as arg3
   */
  XtCallbackRec *calls;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveCallbacks", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtRemoveCallbacks", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtRemoveCallbacks", "list of XtCallbacks");
  calls = XEN_TO_C_XtCallbackList(arg3);
  XtRemoveCallbacks(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2), calls);
  FREE(calls);
  return(XEN_FALSE);
}

static XEN gxm_XtAddCallbacks(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtAddCallbacks "void XtAddCallbacks(w, callback_name, callbacks) add the specified list of callbacks to the specified widget's callback list."
  /* DIFF: XtAddCallbacks takes list of (func data) pairs as arg3
   */
  XtCallbackRec *calls;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAddCallbacks", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAddCallbacks", "char*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtAddCallbacks", "list of XtCallbacks");
  calls = XEN_TO_C_XtCallbackList(arg3);
  XtAddCallbacks(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2), calls);
  FREE(calls);
  return(XEN_FALSE);
}

static XEN gxm_XtRemoveCallback(XEN arg1, XEN arg2, XEN arg4)
{
  #define H_XtRemoveCallback "void XtRemoveCallback(w, callback_name, client_data) removes a callback"
  /* DIFF: XtRemoveCallback omits proc arg and is passed whatever XtAddCallback returned
   */
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveCallback", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtRemoveCallback", "char*"); 
  xm_unprotect_at(XEN_TO_C_INT(XEN_LIST_REF(arg4, CALLBACK_GC_LOC)));
  XtRemoveCallback(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2), gxm_XtCallbackProc, (XtPointer)arg4);
  return(XEN_FALSE);
}

/* need these for all callback proc types, and locations to store the list of them */

enum 
{
  GXM_Print, GXM_Any, GXM_Arrow, GXM_Combo, GXM_Command, GXM_Container_Outline, GXM_Container_Select,
  GXM_Convert, GXM_Destination, GXM_Display, GXM_Drag_Drop, GXM_Drag_Motion, GXM_Drag_Proc, GXM_Drag_Start,
  GXM_Drawing, GXM_Drawn, GXM_Drop_Finish, GXM_Drop_Proc, GXM_DropSite_Enter, GXM_DropSite_Leave, GXM_Drop_Start,
  GXM_File, GXM_List, GXM_Notebook, GXM_Operation, GXM_Popup, GXM_PushButton, GXM_RowColumn, GXM_Scale,
  GXM_ScrollBar, GXM_Selection, GXM_SpinBox, GXM_ToggleButton, GXM_TopLevel_Enter, GXM_TopLevel_Leave,
  GXM_Traverse, GXM_Verify
};

static XEN wrap_callback_struct(int type, XtPointer info)
{
  switch (type)
    {
    case GXM_Any: return(C_TO_XEN_XmAnyCallbackStruct((XmAnyCallbackStruct *)info));
    case GXM_Arrow: return(C_TO_XEN_XmArrowButtonCallbackStruct((XmArrowButtonCallbackStruct *)info));
    case GXM_Command: return(C_TO_XEN_XmCommandCallbackStruct((XmCommandCallbackStruct *)info));
    case GXM_Drag_Drop: return(C_TO_XEN_XmDragDropFinishCallbackStruct((XmDragDropFinishCallbackStruct *)info));
    case GXM_Drag_Motion: return(C_TO_XEN_XmDragMotionCallbackStruct((XmDragMotionCallbackStruct *)info));
    case GXM_Drag_Proc: return(C_TO_XEN_XmDragProcCallbackStruct((XmDragProcCallbackStruct *)info));
    case GXM_Drawing: return(C_TO_XEN_XmDrawingAreaCallbackStruct((XmDrawingAreaCallbackStruct *)info));
    case GXM_Drawn: return(C_TO_XEN_XmDrawnButtonCallbackStruct((XmDrawnButtonCallbackStruct *)info));
    case GXM_Drop_Finish: return(C_TO_XEN_XmDropFinishCallbackStruct((XmDropFinishCallbackStruct *)info));
    case GXM_Drop_Proc: return(C_TO_XEN_XmDropProcCallbackStruct((XmDropProcCallbackStruct *)info));
    case GXM_DropSite_Enter: return(C_TO_XEN_XmDropSiteEnterCallbackStruct((XmDropSiteEnterCallbackStruct *)info));
    case GXM_DropSite_Leave: return(C_TO_XEN_XmDropSiteLeaveCallbackStruct((XmDropSiteLeaveCallbackStruct *)info));
    case GXM_Drop_Start: return(C_TO_XEN_XmDropStartCallbackStruct((XmDropStartCallbackStruct *)info));
    case GXM_File: return(C_TO_XEN_XmFileSelectionBoxCallbackStruct((XmFileSelectionBoxCallbackStruct *)info));
    case GXM_List: return(C_TO_XEN_XmListCallbackStruct((XmListCallbackStruct *)info));
    case GXM_PushButton: return(C_TO_XEN_XmPushButtonCallbackStruct((XmPushButtonCallbackStruct *)info));
    case GXM_RowColumn: return(C_TO_XEN_XmRowColumnCallbackStruct((XmRowColumnCallbackStruct *)info));
    case GXM_Scale: return(C_TO_XEN_XmScaleCallbackStruct((XmScaleCallbackStruct *)info));
    case GXM_ScrollBar: return(C_TO_XEN_XmScrollBarCallbackStruct((XmScrollBarCallbackStruct *)info));
    case GXM_Selection: return(C_TO_XEN_XmSelectionBoxCallbackStruct((XmSelectionBoxCallbackStruct *)info));
    case GXM_ToggleButton: return(C_TO_XEN_XmToggleButtonCallbackStruct((XmToggleButtonCallbackStruct *)info));
    case GXM_Verify: return(C_TO_XEN_XmTextVerifyCallbackStruct((XmTextVerifyCallbackStruct *)info));
#if MOTIF_2
    case GXM_Popup: return(C_TO_XEN_XmPopupHandlerCallbackStruct((XmPopupHandlerCallbackStruct *)info));
    case GXM_Drag_Start: return(C_TO_XEN_XmDragStartCallbackStruct((XmDragStartCallbackStruct *)info));
    case GXM_Convert: return(C_TO_XEN_XmConvertCallbackStruct((XmConvertCallbackStruct *)info));
    case GXM_Container_Outline: return(C_TO_XEN_XmContainerOutlineCallbackStruct((XmContainerOutlineCallbackStruct *)info));
    case GXM_Container_Select: return(C_TO_XEN_XmContainerSelectCallbackStruct((XmContainerSelectCallbackStruct *)info));
    case GXM_Destination: return(C_TO_XEN_XmDestinationCallbackStruct((XmDestinationCallbackStruct *)info));
    case GXM_Display: return(C_TO_XEN_XmDisplayCallbackStruct((XmDisplayCallbackStruct *)info));
    case GXM_Combo: return(C_TO_XEN_XmComboBoxCallbackStruct((XmComboBoxCallbackStruct *)info));
    case GXM_Notebook: return(C_TO_XEN_XmNotebookCallbackStruct((XmNotebookCallbackStruct *)info));
    case GXM_Operation: return(C_TO_XEN_XmOperationChangedCallbackStruct((XmOperationChangedCallbackStruct *)info));
    case GXM_SpinBox: return(C_TO_XEN_XmSpinBoxCallbackStruct((XmSpinBoxCallbackStruct *)info));
#if HAVE_XP
    case GXM_Print: return(C_TO_XEN_XmPrintShellCallbackStruct((XmPrintShellCallbackStruct *)info));
#endif
    case GXM_TopLevel_Enter: return(C_TO_XEN_XmTopLevelEnterCallbackStruct((XmTopLevelEnterCallbackStruct *)info));
    case GXM_TopLevel_Leave: return(C_TO_XEN_XmTopLevelLeaveCallbackStruct((XmTopLevelLeaveCallbackStruct *)info));
    case GXM_Traverse: return(C_TO_XEN_XmTraverseObscuredCallbackStruct((XmTraverseObscuredCallbackStruct *)info));
#endif
    }
  return(XEN_FALSE);
}

static int callback_struct_type(Widget w, char *name)
{
#if MOTIF_2
  if (strcmp(name, XmNdestinationCallback) == 0) return(GXM_Destination);
  if (strcmp(name, XmNpopupHandlerCallback) == 0) return (GXM_Popup);
  if (strcmp(name, XmNconvertCallback) == 0) return(GXM_Convert);
  if (strcmp(name, XmNdragStartCallback) == 0) return(GXM_Drag_Start);
#endif
  if (strcmp(name, XmNdropProc) == 0) return(GXM_Drop_Proc);      
  if (strcmp(name, XmNdragProc) == 0) return(GXM_Drag_Proc);      

  if (XmIsArrowButton(w)) return(GXM_Arrow);
  if (XmIsPushButton(w)) return(GXM_PushButton);
  if (XmIsScale(w)) return(GXM_Scale);
  if (XmIsRowColumn(w)) return(GXM_RowColumn);
  if (XmIsScrollBar(w)) return(GXM_ScrollBar);
  if (XmIsToggleButton(w)) return(GXM_ToggleButton);
  if (XmIsList(w)) return(GXM_List);
  if (XmIsFileSelectionBox(w)) return(GXM_File);
  if (XmIsDrawingArea(w)) return(GXM_Drawing);
  if (XmIsScrolledWindow(w)) return(GXM_Traverse);
#if MOTIF_2
  if (XmIsNotebook(w)) return(GXM_Notebook);
  if (XmIsComboBox(w)) return(GXM_Combo);
#endif
  if ((XmIsText(w)) || (XmIsTextField(w)))
    {
      if ((strcmp(name, XmNlosingFocusCallback) == 0) ||
	  (strcmp(name, XmNmodifyVerifyCallback) == 0) ||
	  (strcmp(name, XmNmotionVerifyCallback) == 0))
	return(GXM_Verify);
      return(GXM_Any);
    }
#if MOTIF_2
  if (XmIsContainer(w))
    {
      if (strcmp(name, XmNoutlineChangedCallback) == 0) return(GXM_Container_Outline);
      if ((strcmp(name, XmNselectionCallback) == 0) ||
	  (strcmp(name, XmNdefaultActionCallback) == 0))
	return(GXM_Container_Select);
      return(GXM_Destination); 
    }
  /* how to recognize a SpinBox? */
#if HAVE_XP
  if (XmIsPrintShell(w)) return(GXM_Print);
#endif
#endif
  if (XmIsCommand(w)) return(GXM_Command);
  if (XmIsDisplay(w)) return(GXM_Display);
  if (XmIsSelectionBox(w)) return(GXM_Selection);
  if (XmIsDragContext(w))
    {
      if (strcmp(name, XmNdragDropFinishCallback) == 0) return(GXM_Drag_Drop);
      if (strcmp(name, XmNdropFinishCallback) == 0) return(GXM_Drop_Finish);
      if (strcmp(name, XmNdragMotionCallback) == 0) return(GXM_Drag_Motion);
      if (strcmp(name, XmNdropSiteEnterCallback) == 0) return(GXM_DropSite_Enter);
      if (strcmp(name, XmNdropSiteLeaveCallback) == 0) return(GXM_DropSite_Leave);
      if (strcmp(name, XmNdropStartCallback) == 0) return(GXM_Drop_Start);
      if (strcmp(name, XmNoperationChangedCallback) == 0) return(GXM_Operation);
      if (strcmp(name, XmNtopLevelEnterCallback) == 0) return(GXM_TopLevel_Enter);
      if (strcmp(name, XmNtopLevelLeaveCallback) == 0) return(GXM_TopLevel_Leave);
    }
  if (XmIsDrawnButton(w)) return(GXM_Drawn);
  return(GXM_Any);
}

static XEN gxm_XtAddCallback(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtAddCallback "void XtAddCallback(w, callback_name, callback, client_data) adds the specified callback procedure to \
the specified widget's callback list.  In xm, the client-data is optional, defaulting to #f. The callback procedure takes \
3 args: widget client-data callback-info"
  /* DIFF: XtAddCallback returns the C-side "client-data" (for subsequent XtRemoveCallback)
   */
  char *name;
  Widget w;
  int gc_loc;
  XEN call_descr = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAddCallback", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtAddCallback", "char*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 3), arg3, 3, "XtAddCallback", "(XtCallbackProc widget data callb)");
  w = XEN_TO_C_Widget(arg1);
  name = XEN_TO_C_STRING(arg2);
  call_descr = C_TO_XEN_XM_XtCallback(arg3, (XEN_BOUND_P(arg4)) ? arg4 : XEN_FALSE);
  gc_loc = xm_protect(call_descr);
  XEN_LIST_SET(call_descr, CALLBACK_GC_LOC, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(call_descr, CALLBACK_STRUCT_TYPE, C_TO_XEN_INT(callback_struct_type(w, name)));
  XtAddCallback(w, name, gxm_XtCallbackProc, (XtPointer)call_descr);
  return(call_descr);
}

static XEN gxm_XtParent(XEN arg1)
{
  #define H_XtParent "Widget XtParent(w) returns the widget's parent widget ID."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtParent", "Widget");
  return(C_TO_XEN_Widget(XtParent(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtClass(XEN arg1)
{
  #define H_XtClass "WidgetClass XtClass(w)"
  #define H_XtSuperclass "WidgetClass XtSuperclass(w) returns a pointer to the widget's superclass class structure."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtClass", "Widget");
  return(C_TO_XEN_WidgetClass(XtClass(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtSuperclass(XEN arg1)
{
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSuperclass", "Widget");
  return(C_TO_XEN_WidgetClass(XtSuperclass(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtName(XEN arg1)
{
  #define H_XtName "Widget XtName(w) returns the widget's name."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtName", "Widget");
  return(C_TO_XEN_STRING(XtName(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtWindowOfObject(XEN arg1)
{
  #define H_XtWindowOfObject "Window XtWindowOfObject(object) returns the window of the specified object."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtWindowOfObject", "Widget");
  return(C_TO_XEN_Window(XtWindowOfObject(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtWindow(XEN arg1)
{
  #define H_XtWindow "Window XtWindow(w) returns the window of the specified widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtWindow", "Widget");
  return(C_TO_XEN_Window(XtWindow(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtScreenOfObject(XEN arg1)
{
  #define H_XtScreenOfObject "Screen *XtScreenOfObject(object) returns the screen pointer for the specified object."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtScreenOfObject", "Widget");
  return(C_TO_XEN_Screen(XtScreenOfObject(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtScreen(XEN arg1)
{
  #define H_XtScreen "Screen* XtScreen(w) returns the screen pointer for the specified widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtScreen", "Widget");
  return(C_TO_XEN_Screen(XtScreen(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtDisplayOfObject(XEN arg1)
{
  #define H_XtDisplayOfObject "Display *XtDisplayOfObject(object) returns the display pointer for the specified object."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtDisplayOfObject", "Widget");
  return(C_TO_XEN_Display(XtDisplayOfObject(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtDisplay(XEN arg1)
{
  #define H_XtDisplay "Display* XtDisplay(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtDisplay", "Widget");
  return(C_TO_XEN_Display(XtDisplay(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtVaCreateArgsList(XEN arg1, XEN arg2)
{
  #define H_XtVaCreateArgsList "XtVarArgsList XtVaCreateArgsList(unused, ...) allocates memory and copies its arguments into a single \
list pointer, which may be used with XtVaNestedList."
  /* DIFF: XtVaCreateArgsList just returns its 1st arg
   */
  return(arg1);
}

static XEN gxm_XtMergeArgLists(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtMergeArgLists "ArgList XtMergeArgLists(args1, num_args1, args2, num_args2) allocates enough storage to hold the combined \
ArgList structures and copies them into it."
  /* just merges, not duplicate check, kinda dumb to drop into C for that */
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XtMergeArgLists", "list");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg3), arg3, 3, "XtMergeArgLists", "list");
  return(XEN_APPEND(arg1, arg3));
}

static XEN gxm_XtWindowToWidget(XEN arg1, XEN arg2)
{
  #define H_XtWindowToWidget "Widget XtWindowToWidget(display, window) translates the specified window and display pointer into the appropriate widget instance."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtWindowToWidget", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XtWindowToWidget", "Window");
  return(C_TO_XEN_Widget(XtWindowToWidget(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XtNameToWidget(XEN arg1, XEN arg2)
{
  #define H_XtNameToWidget "Widget XtNameToWidget(reference, names) looks for a widget whose name is the first component in the specified names"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtNameToWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtNameToWidget", "char*");
  return(C_TO_XEN_Widget(XtNameToWidget(XEN_TO_C_Widget(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XtSetSensitive(XEN arg1, XEN arg2)
{
  #define H_XtSetSensitive "void XtSetSensitive(w, sensitive)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSetSensitive", "Widget");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XtSetSensitive", "boolean");
  XtSetSensitive(XEN_TO_C_Widget(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtDestroyWidget(XEN arg1)
{
  #define H_XtDestroyWidget "void XtDestroyWidget(w) provides the only method of destroying a widget, including widgets that need to destroy themselves."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtDestroyWidget", "Widget");
  XtDestroyWidget(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtUnrealizeWidget(XEN arg1)
{
  #define H_XtUnrealizeWidget "void XtUnrealizeWidget(w) destroys the windows of an existing widget and all of its children (recursively down the widget tree)."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUnrealizeWidget", "Widget");
  XtUnrealizeWidget(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtRealizeWidget(XEN arg1)
{
  #define H_XtRealizeWidget "void XtRealizeWidget(w) maps the widget window."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRealizeWidget", "Widget");
  XtRealizeWidget(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtAppPending(XEN arg1)
{
  #define H_XtAppPending "XtInputMask XtAppPending(app_context) returns a nonzero value if there are events pending from the X server, timer \
pending, or other input sources pending. "
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppPending", "XtAppContext");
  return(C_TO_XEN_ULONG(XtAppPending(XEN_TO_C_XtAppContext(arg1))));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtPending(void)
{
  #define H_XtPending "XtInputMask XtPending() has been replaced by XtAppPending."
  return(C_TO_XEN_BOOLEAN(XtPending()));
}
#endif

static XEN gxm_XtAppNextEvent(XEN arg1)
{
  #define H_XtAppNextEvent "void XtAppNextEvent(app_context) flushes the X output buffers of each Display in the application \
context and waits for an event while looking at the other input sources, timeout timeout values, and signal handlers and calling any callback \
procedures triggered by them -> event."
  /* DIFF: XtAppNextEvent app [ev] -> ev
   */
  XEvent *e;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppNextEvent", "XtAppContext");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  XtAppNextEvent(XEN_TO_C_XtAppContext(arg1), e);
  return(C_TO_XEN_XEvent_OBJ(e));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtNextEvent(void)
{
  #define H_XtNextEvent "void XtNextEvent() has been replaced by XtAppNextEvent."
  /* DIFF: XtNextEvent [ev] -> ev
   */
  XEvent *e;
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  XtNextEvent(e);
  return(C_TO_XEN_XEvent_OBJ(e));
}
#endif


/* -------- Input callback -------- */

/* (77) explicitly removed via XtRemoveInput */

#define C_TO_XEN_XM_Input(Code, Context) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("Input"), Code, Context, XEN_ZERO, XEN_ZERO)
#define XM_Input_P(Arg) WRAP_P("Input", Arg)

static void gxm_XtInputCallbackProc(XtPointer cdata, int *fileno, XtInputId *id) 
{
  XEN descr = (XEN)cdata;
  /* (list 'Input function context gc-loc id) */
  XEN_CALL_3(XEN_CADR(descr), 
	     XEN_CADDR(descr), 
	     C_TO_XEN_ULONG(*fileno), 
	     C_TO_XEN_XtInputId(*id), 
	     __FUNCTION__);
}

static int unprotect_inputproc(XEN val, int loc, unsigned long id)
{
  if ((XM_Input_P(val)) &&
      ((XtInputId)XEN_TO_C_ULONG(XEN_LIST_REF(val, 4)) == id))
    {
      xm_unprotect_at(loc);
      return(TRUE);
    }
  return(FALSE);
}

static XEN gxm_XtRemoveInput(XEN arg1)
{
  #define H_XtRemoveInput "void XtRemoveInput(id) causes the read routine to stop watching for input from the input source."
  XtInputId id;
  XEN_ASSERT_TYPE(XEN_XtInputId_P(arg1), arg1, 1, "XtRemoveInput", "XtInputId");
  id = XEN_TO_C_XtInputId(arg1);
  XtRemoveInput(id);
  map_over_protected_elements(unprotect_inputproc, id);
  return(XEN_FALSE);
}

static XEN gxm_XtAppAddInput(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtAppAddInput "XtInputId XtAppAddInput(app_context, source, condition, proc, client_data) registers with the read routine a \
new source of events, which is usually file input but can also be file output."
  XtInputId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppAddInput", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtAppAddInput", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 3), arg4, 4, "XtAppAddInput", "(XtInputCallbackProc data fileno id)");
  descr = C_TO_XEN_XM_Input(arg4, (XEN_BOUND_P(arg5)) ? arg5 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAppAddInput(XEN_TO_C_XtAppContext(arg1), 
		     XEN_TO_C_INT(arg2), 
		     (XtPointer)arg3, 
		     gxm_XtInputCallbackProc, 
		     (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtInputId(id));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtAddInput(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtAddInput "XtInputId XtAddInput(source, condition, proc, client_data) has been replaced by XtAppAddInput."
  XtInputId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg1), arg1, 1, "XtAddInput", "int");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 3), arg3, 3, "XtAddInput", "(XtInputCallbackProc data fileno id)");
  descr = C_TO_XEN_XM_Input(arg3, (XEN_BOUND_P(arg4)) ? arg4 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAddInput(XEN_TO_C_INT(arg1), 
		  (XtPointer)arg2, 
		  gxm_XtInputCallbackProc, 
		  (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtInputId(id));
}
#endif

/* -------- Timer Callback -------- */
/* (79) protect the function, then unprotect after invocation */

#define C_TO_XEN_XM_TimeOut(Code, Context) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("TimeOut"), Code, Context, XEN_ZERO, XEN_ZERO)
#define XM_TimeOut_P(Arg) WRAP_P("TimeOut", Arg)

static void gxm_XtTimerCallbackProc(XtPointer cdata, XtIntervalId* i) 
{
  XEN descr = (XEN)cdata;
  /* (list 'TimeOut function context gc-loc id) */
  int gc_loc;
  gc_loc = XEN_TO_C_INT(XEN_LIST_REF(descr, 3));
  XEN_CALL_2(XEN_CADR(descr), 
	     XEN_CADDR(descr),
	     C_TO_XEN_XtIntervalId(*i),
	     __FUNCTION__);
  xm_unprotect_at(gc_loc);
}

static int unprotect_timeoutproc(XEN val, int loc, unsigned long id)
{
  if ((XM_TimeOut_P(val)) &&
      ((XtIntervalId)XEN_TO_C_ULONG(XEN_LIST_REF(val, 4)) == id))
    {
      xm_unprotect_at(loc);
      return(TRUE);
    }
  return(FALSE);
}

static XEN gxm_XtRemoveTimeOut(XEN arg1)
{
  #define H_XtRemoveTimeOut "void XtRemoveTimeOut(timer) removes the timeout."
  XtIntervalId id;
  XEN_ASSERT_TYPE(XEN_XtIntervalId_P(arg1), arg1, 1, "XtRemoveTimeOut", "XtIntervalId");
  id = XEN_TO_C_XtIntervalId(arg1);
  XtRemoveTimeOut(id);
  map_over_protected_elements(unprotect_timeoutproc, id);
  return(XEN_FALSE);
}

static XEN gxm_XtAppAddTimeOut(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtAppAddTimeOut "XtIntervalId XtAppAddTimeOut(app_context, interval, proc, client_data) creates a timeout and returns an identifier for it."
  XtIntervalId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppAddTimeOut", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtAppAddTimeOut", "ulong");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 2), arg3, 3, "XtAppAddTimeOut", "(XtTimerCallbackProc data id)");
  descr = C_TO_XEN_XM_TimeOut(arg3, (XEN_BOUND_P(arg4)) ? arg4 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAppAddTimeOut(XEN_TO_C_XtAppContext(arg1), 
		       XEN_TO_C_ULONG(arg2), 
		       gxm_XtTimerCallbackProc, 
		       (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtIntervalId(id));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtAddTimeOut(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtAddTimeOut "XtIntervalId XtAddTimeOut(interval, proc, client_data) has been replaced by XtAppAddTimeOut."
  XtIntervalId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XtAddTimeOut", "ulong");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 2), arg2, 2, "XtAddTimeOut", "(XtTimerCallbackProc data id)");
  descr = C_TO_XEN_XM_TimeOut(arg2, (XEN_BOUND_P(arg3)) ? arg3 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAddTimeOut(XEN_TO_C_ULONG(arg1), 
		    gxm_XtTimerCallbackProc, 
		    (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtIntervalId(id));
}
#endif

static XEN gxm_XtLastTimestampProcessed(XEN arg1)
{
  #define H_XtLastTimestampProcessed "Time XtLastTimestampProcessed(display) returns the timestamp of the last event"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtLastTimestampProcessed", "Display*");
  return(C_TO_XEN_Time(XtLastTimestampProcessed(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XtLastEventProcessed(XEN arg1)
{
  #define H_XtLastEventProcessed "XEvent* XtLastEventProcessed(display) returns the last event passed to XtDispatchEvent for the \
specified display and NULL if there has been no event. "
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtLastEventProcessed", "Display*");
  return(C_TO_XEN_XEvent(XtLastEventProcessed(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XtGetKeyboardFocusWidget(XEN arg1)
{
  #define H_XtGetKeyboardFocusWidget "Widget XtGetKeyboardFocusWidget(widget) returns the widget that would be the end result of keyboard \
event forwarding for a keyboard event for the specified widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtGetKeyboardFocusWidget", "Widget");
  return(C_TO_XEN_Widget(XtGetKeyboardFocusWidget(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtSetKeyboardFocus(XEN arg1, XEN arg2)
{
  #define H_XtSetKeyboardFocus "XtSetKeyboardFocus(subtree descendant) causes XtDispatchEvent to remap and send the event to the specified \
descendant widget."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtSetKeyboardFocus", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XtSetKeyboardFocus", "Widget");
  XtSetKeyboardFocus(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtAddExposureToRegion(XEN arg1, XEN arg2)
{
  #define H_XtAddExposureToRegion "void XtAddExposureToRegion(event, region) computes the union of the rectangle defined by the exposure event \
and the specified region. Then, it stores the results back in region."
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg1), arg1, 1, "XtAddExposureToRegion", "XEvent*");
  XEN_ASSERT_TYPE(XEN_Region_P(arg2), arg2, 2, "XtAddExposureToRegion", "Region");
  XtAddExposureToRegion(XEN_TO_C_XEvent(arg1), XEN_TO_C_Region(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtAppMainLoop(XEN arg1)
{

  #define H_XtAppMainLoop "void XtAppMainLoop(app_context) first reads the next incoming X event by calling XtAppNextEvent and then it dispatches \
the event to the appropriate registered procedure by calling XtDispatchEvent."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppMainLoop", "XtAppContext");
  XtAppMainLoop(XEN_TO_C_XtAppContext(arg1));
  return(XEN_FALSE);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtMainLoop(void)
{
  #define H_XtMainLoop "void XtMainLoop() has been replaced by XtAppMainLoop."
  XtMainLoop();
  return(XEN_FALSE);
}
#endif

static XEN gxm_XtAppProcessEvent(XEN arg1, XEN arg2)
{
  #define H_XtAppProcessEvent "void XtAppProcessEvent(app_context, mask) processes one timer, alternate input, signal source, or X event. \
If there is nothing of the appropriate type to process, XtAppProcessEvent blocks until there is."
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppProcessEvent", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtAppProcessEvent", "XtInputMask");
  XtAppProcessEvent(XEN_TO_C_XtAppContext(arg1), XEN_TO_C_ULONG(arg2));
  return(XEN_FALSE);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtProcessEvent(XEN arg1)
{
  #define H_XtProcessEvent "void XtProcessEvent(mask) has been replaced by XtAppProcessEvent."
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg1), arg1, 1, "XtProcessEvent", "XtInputMask");
  XtProcessEvent(XEN_TO_C_ULONG(arg1));
  return(XEN_FALSE);
}
#endif

static XEN gxm_XtRemoveGrab(XEN arg1)
{
  #define H_XtRemoveGrab "void XtRemoveGrab(w) removes widgets from the modal cascade starting at the most recent widget up to and \
including the specified widget. "
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveGrab", "Widget");
  XtRemoveGrab(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtAddGrab(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtAddGrab "void XtAddGrab(w, exclusive, spring_loaded) appends the widget (and associated parameters) to the modal cascade and \
checks that exclusive is #t if spring_loaded is #t."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAddGrab", "Widget");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtAddGrab", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XtAddGrab", "int");
  XtAddGrab(XEN_TO_C_Widget(arg1), XEN_TO_C_INT(arg2), XEN_TO_C_INT(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XtBuildEventMask(XEN arg1)
{
  #define H_XtBuildEventMask "EventMask XtBuildEventMask(w) -> widget's event mask"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtBuildEventMask", "Widget");
  return(C_TO_XEN_ULONG(XtBuildEventMask(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtDispatchEventToWidget(XEN arg1, XEN arg2)
{
  #define H_XtDispatchEventToWidget "Boolean XtDispatchEventToWidget(widget, event) scans the list of registered event handlers for the \
specified widget and calls each handler that has been registered for the specified event type, subject to the continue_to_dispatch value \
returned by each handler."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtDispatchEventToWidget", "Widget");
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg2), arg2, 2, "XtDispatchEventToWidget", "XEvent*");
  return(C_TO_XEN_BOOLEAN(XtDispatchEventToWidget(XEN_TO_C_Widget(arg1), XEN_TO_C_XEvent(arg2))));
}

enum {EVENT_HANDLER_TYPE, EVENT_HANDLER_FUNC, EVENT_HANDLER_DATA, EVENT_HANDLER_GC_LOC, EVENT_HANDLER_WIDGET, EVENT_HANDLER_MASK};

#define C_TO_XEN_XM_XtEventHandler(Code, Context, Widget, Mask) \
  XEN_LIST_6(C_STRING_TO_XEN_SYMBOL("XtEventHandler"), Code, Context, XEN_ZERO, Widget, Mask)
#define XM_XtEventHandler_P(Arg) WRAP_P("XtEventHandler", Arg)

static void gxm_XtEventHandler(Widget w, XtPointer context, XEvent *event, Boolean *flag)
{
  XEN descr = (XEN)context;
  XEN_CALL_4(XEN_LIST_REF(descr, EVENT_HANDLER_FUNC),
	     C_TO_XEN_Widget(w),
	     XEN_LIST_REF(descr, EVENT_HANDLER_DATA),
	     C_TO_XEN_XEvent(event),
	     C_TO_XEN_BOOLEAN(*flag),
	     __FUNCTION__);
}

static int find_xteventproc_1(XEN val, int loc, unsigned long wd)
{
  XEN lst = (XEN)wd;
  unsigned long w;
  XEN code;
  XEN data;
  w = XEN_TO_C_ULONG(XEN_CAR(lst));
  code = XEN_CADR(lst);
  data = XEN_CADDR(lst);
  return((XM_XtEventHandler_P(val)) &&
	 (XEN_Widget_P(XEN_LIST_REF(val, EVENT_HANDLER_WIDGET))) &&
	 (XEN_TO_C_ULONG(XEN_CADR(XEN_LIST_REF(val, EVENT_HANDLER_WIDGET))) == w) &&
	 (XEN_EQ_P(code, XEN_LIST_REF(val, EVENT_HANDLER_FUNC))) &&
	 (XEN_EQ_P(data, XEN_LIST_REF(val, EVENT_HANDLER_DATA))));
}

static XEN find_xteventproc(Widget w, XEN code, XEN data)
{
  /* here we again have to go by the widget */
  XEN lst;
  int i, loc;
  lst = XEN_LIST_3(C_TO_XEN_ULONG((unsigned long)w),code, data);
  loc = xm_protect(lst);
  i = map_over_protected_elements(find_xteventproc_1, (unsigned long)lst);
  xm_unprotect_at(loc);
  if (i >= 0)
    return(xm_protected_element(i));
  return(XEN_FALSE);
}

static XEN gxm_XtInsertRawEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtInsertRawEventHandler "void XtInsertRawEventHandler(w, event_mask, nonmaskable, proc, client_data, position) is similar to \
XtInsertEventHandler except that it does not modify the widget's event mask and never causes an XSelectInput for the specified events."
  XEN call_descr = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtInsertRawEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtInsertRawEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtInsertRawEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtInsertRawEventHandler", "XtEventHandler");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtInsertRawEventHandler", "XtListPosition");
  call_descr = C_TO_XEN_XM_XtEventHandler(arg4, (XEN_BOUND_P(arg5)) ? arg5 : XEN_FALSE, arg1, arg2);
  XEN_LIST_SET(call_descr, EVENT_HANDLER_GC_LOC, C_TO_XEN_INT(xm_protect(call_descr)));
  XtInsertRawEventHandler(XEN_TO_C_Widget(arg1), 
			  XEN_TO_C_ULONG(arg2), 
			  XEN_TO_C_BOOLEAN(arg3), 
			  gxm_XtEventHandler, 
			  (XtPointer)call_descr, 
			  (XtListPosition)XEN_TO_C_INT(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XtInsertEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtInsertEventHandler "void XtInsertEventHandler(w, event_mask, nonmaskable, proc, client_data, position) is identical to \
XtAddEventHandler with the additional position argument. "
  XEN call_descr = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtInsertEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtInsertEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtInsertEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtInsertEventHandler", "XtEventHandler");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg6), arg6, 6, "XtInsertEventHandler", "XtListPosition");
  call_descr = C_TO_XEN_XM_XtEventHandler(arg4, (XEN_BOUND_P(arg5)) ? arg5 : XEN_FALSE, arg1, arg2);
  XEN_LIST_SET(call_descr, EVENT_HANDLER_GC_LOC, C_TO_XEN_INT(xm_protect(call_descr)));
  XtInsertEventHandler(XEN_TO_C_Widget(arg1), 
		       XEN_TO_C_ULONG(arg2), 
		       XEN_TO_C_BOOLEAN(arg3), 
		       gxm_XtEventHandler, 
		       (XtPointer)call_descr, 
		       (XtListPosition)XEN_TO_C_INT(arg6));
  return(XEN_FALSE);
}

static XEN gxm_XtRemoveRawEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtRemoveRawEventHandler "void XtRemoveRawEventHandler(w, event_mask, nonmaskable, proc, client_data) stops the specified \
procedure from receiving the specified events."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveRawEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtRemoveRawEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtRemoveRawEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtRemoveRawEventHandler", "XtEventHandler");
  XtRemoveRawEventHandler(XEN_TO_C_Widget(arg1), 
			  XEN_TO_C_ULONG(arg2), 
			  XEN_TO_C_BOOLEAN(arg3),
			  gxm_XtEventHandler, 
			  (XtPointer)find_xteventproc(XEN_TO_C_Widget(arg1), arg4, arg5));
  return(XEN_FALSE);
}

static XEN gxm_XtAddRawEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtAddRawEventHandler "void XtAddRawEventHandler(w, event_mask, nonmaskable, proc, client_data) is similar to XtAddEventHandler \
except that it does not affect the widget's mask and never causes an XSelectInput for its events."
  XEN call_descr = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAddRawEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtAddRawEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtAddRawEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtAddRawEventHandler", "XtEventHandler");
  call_descr = C_TO_XEN_XM_XtEventHandler(arg4, (XEN_BOUND_P(arg5)) ? arg5 : XEN_FALSE, arg1, arg2);
  XEN_LIST_SET(call_descr, EVENT_HANDLER_GC_LOC, C_TO_XEN_INT(xm_protect(call_descr)));
  XtAddRawEventHandler(XEN_TO_C_Widget(arg1), 
		       XEN_TO_C_ULONG(arg2), 
		       XEN_TO_C_BOOLEAN(arg3), 
		       gxm_XtEventHandler,
		       (XtPointer)call_descr);
  return(XEN_FALSE);
}

static XEN gxm_XtRemoveEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtRemoveEventHandler "XtRemoveEventHandler(w, event_mask, nonmaskable, proc, client_data)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtRemoveEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtRemoveEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtRemoveEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtRemoveEventHandler", "XtEventHandler");
  XtRemoveEventHandler(XEN_TO_C_Widget(arg1), 
		       XEN_TO_C_ULONG(arg2), 
		       XEN_TO_C_BOOLEAN(arg3), 
		       gxm_XtEventHandler, 
		       (XtPointer)find_xteventproc(XEN_TO_C_Widget(arg1), arg4, arg5));
  return(XEN_FALSE);
}

static XEN gxm_XtAddEventHandler(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtAddEventHandler "void XtAddEventHandler(w, event_mask, nonmaskable, proc, client_data) registers a procedure with the dispatch \
mechanism that is to be called when an event that matches the mask occurs on the specified widget."
  XEN call_descr = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAddEventHandler", "Widget");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg2), arg2, 2, "XtAddEventHandler", "EventMask");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg3), arg3, 3, "XtAddEventHandler", "boolean");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XtAddEventHandler", "XtEventHandler");
  call_descr = C_TO_XEN_XM_XtEventHandler(arg4, (XEN_BOUND_P(arg5)) ? arg5 : XEN_FALSE, arg1, arg2);
  XEN_LIST_SET(call_descr, EVENT_HANDLER_GC_LOC, C_TO_XEN_INT(xm_protect(call_descr)));
  XtAddEventHandler(XEN_TO_C_Widget(arg1), 
		    XEN_TO_C_ULONG(arg2), 
		    XEN_TO_C_BOOLEAN(arg3), 
		    gxm_XtEventHandler,
		    (XtPointer)call_descr);
  return(XEN_FALSE);
}

static XEN gxm_XtConvertCase(XEN arg1, XEN arg2)
{
  #define H_XtConvertCase "void XtConvertCase(display, keysym) calls the appropriate converter and returns the results."
  /* DIFF: XtConvertCase dpy keysym [k1 k2] -> (list k1 k2)
   */
  KeySym k1, k2;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtConvertCase", "Display*");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg2), arg2, 2, "XtConvertCase", "KeySym");
  XtConvertCase(XEN_TO_C_Display(arg1), XEN_TO_C_KeySym(arg2), &k1, &k2);
  return(XEN_LIST_2(C_TO_XEN_KeySym(k1),
		    C_TO_XEN_KeySym(k2)));
}

/* -------- case converter -------- */

/* (424) convert case XtRegisterCaseConverter global */

static XEN xm_XtCaseProc = XEN_FALSE;
static void gxm_XtCaseProc(Display* d, KeySym k1, KeySym* k2, KeySym* k3)
{
  XEN val;
  int loc;
  val = XEN_CALL_2(xm_XtCaseProc,
		   C_TO_XEN_Display(d),
		   C_TO_XEN_KeySym(k1),
		   __FUNCTION__);
  loc = xm_protect(val);
  if (XEN_LIST_P(val))
    {
      (*k2) = XEN_TO_C_KeySym(XEN_CAR(val));
      (*k3) = XEN_TO_C_KeySym(XEN_CADR(val));
    }
  xm_unprotect_at(loc);
}

static XEN gxm_XtRegisterCaseConverter(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XtRegisterCaseConverter "void XtRegisterCaseConverter(display, proc, start, stop) registers the specified case converter."
  /* DIFF: XtRegisterCaseConverter user XtCaseProc should return the new KeySyms as a list (not as ref args)
   */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtRegisterCaseConverter", "Display*");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 2), arg2, 2, "XtRegisterCaseConverter", "(XtCaseProc dpy keysym)");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg3), arg3, 3, "XtRegisterCaseConverter", "KeySym");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg4), arg4, 4, "XtRegisterCaseConverter", "KeySym");
  if (XEN_PROCEDURE_P(xm_XtCaseProc)) xm_unprotect(xm_XtCaseProc);
  xm_protect(arg2);
  xm_XtCaseProc = arg2;
  XtRegisterCaseConverter(XEN_TO_C_Display(arg1), gxm_XtCaseProc, XEN_TO_C_KeySym(arg3), XEN_TO_C_KeySym(arg4));
  return(XEN_FALSE);
}


/* -------- keyproc -------- */
/* (454) XtSetKeyTranslator global */

static XEN xm_XtKeyProc = XEN_FALSE;
static void gxm_XtKeyProc(Display *dpy, KeyCode c, Modifiers m, Modifiers *mp, KeySym *sym)
{
  XEN val;
  int loc;
  val = XEN_CALL_3(xm_XtKeyProc,
		   C_TO_XEN_Display(dpy),
		   C_TO_XEN_KeyCode(c),
		   C_TO_XEN_Modifiers(m),
		   __FUNCTION__);
  loc = xm_protect(val);
  if (XEN_LIST_P(val))
    {
      /* KeySym is long, Modifier(s) is int, so these can actually work, I guess */
      (*mp) = XEN_TO_C_Modifiers(XEN_CAR(val));
      (*sym) = XEN_TO_C_KeySym(XEN_CADR(val));
    }
  else XtTranslateKey(dpy, c, m, mp, sym);
  xm_unprotect_at(loc);
}

static XEN gxm_XtSetKeyTranslator(XEN arg1, XEN arg2)
{
  #define H_XtSetKeyTranslator "void XtSetKeyTranslator(display, proc) sets the specified procedure as the current key translator. "
  /* DIFF: XtSetKeyTranslator user XtKeyProc should return the new Modifiers and KeySym as a list (not as ref arg), set arg2 #f to get default proc
   */
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtSetKeyTranslator", "Display*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(arg2) || (XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 3)), arg2, 2, "XtSetKeyTranslator", "(XtKeyProc dpy key mod)");
  if (XEN_PROCEDURE_P(xm_XtKeyProc)) xm_unprotect(xm_XtKeyProc);
  xm_XtKeyProc = arg2;
  if (XEN_FALSE_P(arg2))
    XtSetKeyTranslator(XEN_TO_C_Display(arg1), XtTranslateKey);
  else
    {
      xm_protect(arg2);
      XtSetKeyTranslator(XEN_TO_C_Display(arg1), (XtKeyProc)gxm_XtKeyProc);
    }
  return(XEN_FALSE);
}

static XEN gxm_XtTranslateKey(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtTranslateKey "XtTranslateKey(Display *, XtKeyCode, Modifiers) -> modifiers and keysym"
  /* DIFF: XtTranslateKey omit and rtn last 2 args
   */
  Modifiers m;
  KeySym k;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtTranslateKey", "Display*");
  XEN_ASSERT_TYPE(XEN_KeyCode_P(arg2), arg2, 2, "XtTranslateKey", "KeyCode");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtTranslateKey", "Modifiers");
  XtTranslateKey(XEN_TO_C_Display(arg1), XEN_TO_C_KeyCode(arg2), XEN_TO_C_Modifiers(arg3), &m, &k);
  return(XEN_LIST_2(C_TO_XEN_Modifiers(m),
		    C_TO_XEN_KeySym(k)));
}

static XEN gxm_XtTranslateKeycode(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtTranslateKeycode "void XtTranslateKeycode(display, keycode, modifiers) passes the specified \
arguments directly to the currently registered KeyCode to KeySym translator, returns (modifiers keysym)."
  /* DIFF: XtTranslateKeycode omit and rtn last 2 args
   */
  Modifiers m;
  KeySym k;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtTranslateKeycode", "Display*");
  XEN_ASSERT_TYPE(XEN_KeyCode_P(arg2), arg2, 2, "XtTranslateKeycode", "KeyCode");
  XEN_ASSERT_TYPE(XEN_Modifiers_P(arg3), arg3, 3, "XtTranslateKeycode", "Modifiers");
  XtTranslateKeycode(XEN_TO_C_Display(arg1), XEN_TO_C_KeyCode(arg2), XEN_TO_C_Modifiers(arg3), &m, &k);
  return(XEN_LIST_2(C_TO_XEN_Modifiers(m),
		    C_TO_XEN_KeySym(k)));
}

static XEN gxm_XtGetActionKeysym(XEN arg1)
{
  #define H_XtGetActionKeysym "KeySym XtGetActionKeysym(event) -> (keysym modifiers)"
  /* DIFF: XtGetActionKeysym omit and rtn last arg
   */
  Modifiers m;
  KeySym k;
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg1), arg1, 1, "XtGetActionKeysym", "XEvent*");
  k = XtGetActionKeysym(XEN_TO_C_XEvent(arg1), &m);
  return(XEN_LIST_2(C_TO_XEN_KeySym(k),
		    C_TO_XEN_Modifiers(m)));
}

static XEN gxm_XtGetMultiClickTime(XEN arg1)
{
  #define H_XtGetMultiClickTime "int XtGetMultiClickTime(display) returns the time in milliseconds that the translation manager uses to \
determine if multiple events are to be interpreted as a repeated event "
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtGetMultiClickTime", "Display*");
  return(C_TO_XEN_INT(XtGetMultiClickTime(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XtSetMultiClickTime(XEN arg1, XEN arg2)
{
  #define H_XtSetMultiClickTime "void XtSetMultiClickTime(display, time) sets the time interval used by the translation manager to determine \
when multiple events are interpreted as a repeated event."
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtSetMultiClickTime", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtSetMultiClickTime", "int");
  XtSetMultiClickTime(XEN_TO_C_Display(arg1), XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static void gxm_XtActionProc(Widget w, XEvent* e, String* s, Cardinal* c) {}

static XEN gxm_XtRegisterGrabAction(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtRegisterGrabAction "void XtRegisterGrabAction(action_proc, owner_events, event_mask, pointer_mode, keyboard_mode) adds the \
specified action_proc to a list known to the translation manager."
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg1) && (XEN_REQUIRED_ARGS(arg1) ==4), arg1, 1, "XtRegisterGrabAction", "XtActionProc");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtRegisterGrabAction", "int");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XtRegisterGrabAction", "unsigned int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XtRegisterGrabAction", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XtRegisterGrabAction", "int");
  XtRegisterGrabAction(gxm_XtActionProc, XEN_TO_C_INT(arg2), XEN_TO_C_ULONG(arg3), XEN_TO_C_INT(arg4), XEN_TO_C_INT(arg5));
  return(XEN_FALSE);
}

static XEN gxm_XtCallActionProc(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XtCallActionProc "void XtCallActionProc(widget, action, event, params, num_params) searches for the named action routine in the \
same manner and order as translation tables are bound. If found, the action routine is invoked with the specified widget, event pointer, \
and parameters."
  char **params = NULL;
  int i, len = 0;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallActionProc", "Widget");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XtCallActionProc", "char*");
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg3) || XEN_FALSE_P(arg3), arg3, 3, "XtCallActionProc", "XEvent*");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg4) || XEN_FALSE_P(arg4), arg4, 4, "XtCallActionProc", "list of String");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(arg5), arg5, 5, "XtCallActionProc", "int");
  if (XEN_LIST_P(arg4))
    {
      if (XEN_INTEGER_P(arg5)) 
	len = XEN_TO_C_INT(arg5); 
      else len = XEN_LIST_LENGTH(arg4);
    }
  if (len > 0) 
    {
      params = (char **)CALLOC(len, sizeof(char *));
      for (i = 0; i < len; i++)
	params[i] = XEN_TO_C_STRING(XEN_LIST_REF(arg4, i));
    }
  XtCallActionProc(XEN_TO_C_Widget(arg1), 
		   XEN_TO_C_STRING(arg2), 
		   (XEN_XEvent_P(arg3)) ? XEN_TO_C_XEvent(arg3) : NULL,
		   params, len);
  if (params) FREE(params);
  return(XEN_FALSE);
}

static XEN gxm_XtGetActionList(XEN arg1)
{
  #define H_XtGetActionList "void XtGetActionList(widget_class) -> list of actions"
  /* DIFF: XtGetActionList omit arg2 and 3, return list of lists
   */
  unsigned int len;
  XtActionList act;
  int i;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg1), arg1, 1, "XtGetActionList", "WidgetClass");
  XtGetActionList(XEN_TO_C_WidgetClass(arg1), &act, &len);
  if (len > 0)
    {
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(XEN_LIST_2(C_TO_XEN_STRING(act[i].string),
				  C_TO_XEN_ULONG(act[i].proc)),
		       lst);
      free(act);
    }
  return(lst);
}

#define C_TO_XEN_XM_ActionHook(Code, Context) \
  XEN_LIST_5(C_STRING_TO_XEN_SYMBOL("ActionHook"), Code, Context, XEN_ZERO, XEN_ZERO)
#define XM_ActionHook_P(Arg) WRAP_P("ActionHook", Arg)

static int unprotect_actionhook(XEN val, int loc, unsigned long id)
{
  if ((XM_ActionHook_P(val)) &&
      ((XtActionHookId)XEN_TO_C_ULONG(XEN_LIST_REF(val, 4)) == (XtActionHookId)id))
    {
      xm_unprotect_at(loc);
      return(TRUE);
    }
  return(FALSE);
}

static XEN gxm_XtRemoveActionHook(XEN arg1)
{
  #define H_XtRemoveActionHook "void XtRemoveActionHook(idP) removes the specified action hook procedure from the list in which it was registered."
  XtActionHookId id;
  XEN_ASSERT_TYPE(XEN_XtActionHookId_P(arg1), arg1, 1, "XtRemoveActionHook", "XtActionHookId");
  id = XEN_TO_C_XtActionHookId(arg1);
  XtRemoveActionHook(id);
  map_over_protected_elements(unprotect_actionhook, (unsigned long)id);
  return(XEN_FALSE);
}

static void gxm_XtActionHookProc(Widget w, XtPointer p, String s, XEvent* e, String* s1, Cardinal* c) 
{
  /* DIFF: XtActionHookProc takes 5 args (last is string list)
   */
  XEN descr = (XEN)p;
  /* (list 'ActionHook function context gc-loc id) */
  XEN_CALL_5(XEN_CADR(descr), 
	     C_TO_XEN_Widget(w),
	     XEN_CADDR(descr),
	     C_TO_XEN_STRING(s),
	     C_TO_XEN_XEvent(e),
	     C_TO_XEN_Strings(s1, *c),
	     __FUNCTION__);
}

static XEN gxm_XtAppAddActionHook(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtAppAddActionHook "XtActionHookId XtAppAddActionHook(app_context, proc, client_data) adds the specified procedure to the front of \
a list maintained in the application context."
  XtActionHookId id;
  int gc_loc;
  XEN descr;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppAddActionHook", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg2) && (XEN_REQUIRED_ARGS(arg2) == 6), arg2, 2, "XtAppAddActionHook", "XtActionHookProc");
  descr = C_TO_XEN_XM_ActionHook(arg2, (XEN_BOUND_P(arg3)) ? arg3 : XEN_FALSE);
  gc_loc = xm_protect(descr);
  id = XtAppAddActionHook(XEN_TO_C_XtAppContext(arg1), gxm_XtActionHookProc, (XtPointer)descr);
  XEN_LIST_SET(descr, 3, C_TO_XEN_INT(gc_loc));
  XEN_LIST_SET(descr, 4, C_TO_XEN_ULONG(id));
  return(C_TO_XEN_XtActionHookId(id));
}


/* (72) this is part of an actionrec */
/* this code is a horrible kludge, but what can I do? -- to vector to the procedure corresponding to
 *   the action that triggered the action proc, I need to have some way to find that procedure,
 *   and there's none I can see -- the args incoming (widget event args argn) give me no way to
 *   trace back to the caller, or even to save that data at declaration time via clientData or
 *   its equivalent -- I don't even get to see the affected widget.  By the time install|augment|override
 *   translations is called, my procedure info has been buried (or at least compiled into some unknown form).
 *
 *   XtAppContext->action_table is a list of ActionLists
 *   Widget struct has: XtTMRec tm:
 *     XtTranslations  translations;
 *     XtBoundActions  proc_table;  -- list of XtActionProcs		
 *     struct _XtStateRec *current_state;  
 */

static XEN xtactionprocs[8];
static void gxm_XtActionProc0(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[0], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc1(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[1], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc2(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[2], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc3(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[3], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc4(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[4], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc5(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[5], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc6(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[6], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static void gxm_XtActionProc7(Widget w, XEvent *e, char **args, Cardinal *argn) 
{
  XEN_CALL_3(xtactionprocs[7], C_TO_XEN_Widget(w), C_TO_XEN_XEvent(e), C_TO_XEN_Strings(args, *argn), __FUNCTION__);
}
static int xm_action_ctr = 0;

static XtActionsRec *make_action_rec(int len, XEN larg2)
{
  int i;
  XtActionsRec *act;
  XEN pair, arg2;
  arg2 = XEN_COPY_ARG(larg2);
  act = (XtActionsRec *)CALLOC(len, sizeof(XtActionsRec));
  for (i = 0; i < len; i++, arg2 = XEN_CDR(arg2))
    {
      pair = XEN_CAR(arg2);
      act[i].string = (String)XEN_TO_C_STRING(XEN_CAR(pair));
      if (xm_action_ctr >= 8)
	fprintf(stderr,"too many actions...");
      else
	{
	  switch (xm_action_ctr)
	    {
	    case 0: act[i].proc = (XtActionProc)gxm_XtActionProc0; break;
	    case 1: act[i].proc = (XtActionProc)gxm_XtActionProc1; break;
	    case 2: act[i].proc = (XtActionProc)gxm_XtActionProc2; break;
	    case 3: act[i].proc = (XtActionProc)gxm_XtActionProc3; break;
	    case 4: act[i].proc = (XtActionProc)gxm_XtActionProc4; break;
	    case 5: act[i].proc = (XtActionProc)gxm_XtActionProc5; break;
	    case 6: act[i].proc = (XtActionProc)gxm_XtActionProc6; break;
	    case 7: act[i].proc = (XtActionProc)gxm_XtActionProc7; break;
	    }
	  xm_protect(XEN_CADR(pair));
	  xtactionprocs[xm_action_ctr++] = XEN_CADR(pair);
	}
    }
  return(act);
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtAddActions(XEN arg1)
{
  #define H_XtAddActions "void XtAddActions(actions, num_actions) has been replaced by XtAppAddActions."
  /* DIFF: XtAddActions takes list of lists for arg1 (name proc) pairs, not XtActionList, omits arg2 (pointless)
   *        and action proc itself takes 3 args (no need for trailing count)
   */
  XtActionsRec *act;
  int len;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XtAddActions", "list of XtActions");
  len = XEN_LIST_LENGTH(arg1);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg1, 1, "XtAddActions", "positive integer");
  act = make_action_rec(len, arg1);
  XtAddActions(act, len);
  FREE(act);
  return(arg1);
}
#endif

static XEN gxm_XtAppAddActions(XEN arg1, XEN arg2)
{
  #define H_XtAppAddActions "void XtAppAddActions(app_context, actions, num_actions) adds the specified action table and registers it \
with the translation manager."
  /* DIFF: XtAddAppActions takes list of lists for arg2 (name proc) pairs, not XtActionList, omits arg3 (pointless)
   *        and action proc itself takes 3 args (no need for trailing count)
   */
  XtActionsRec *act;
  int len;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppAddActions", "XtAppContext");
  XEN_ASSERT_TYPE(XEN_LIST_P(arg2), arg2, 2, "XtAppAddActions", "list of XtActions");
  len = XEN_LIST_LENGTH(arg2);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg2, 2, "XtAppAddActions", "positive integer");
  act = make_action_rec(len, arg2);
  XtAppAddActions(XEN_TO_C_XtAppContext(arg1), act, len);
  FREE(act);
  return(arg1);
}

static XEN gxm_XtUninstallTranslations(XEN arg1)
{
  #define H_XtUninstallTranslations "void XtUninstallTranslations(w) causes the entire translation table for widget to be removed."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUninstallTranslations", "Widget");
  XtUninstallTranslations(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtInstallAllAccelerators(XEN arg1, XEN arg2)
{
  #define H_XtInstallAllAccelerators "void XtInstallAllAccelerators(destination, source)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtInstallAllAccelerators", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XtInstallAllAccelerators", "Widget");
  XtInstallAllAccelerators(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtInstallAccelerators(XEN arg1, XEN arg2)
{
  #define H_XtInstallAccelerators "void XtInstallAccelerators(destination, source) installs the accelerators from source onto destination by \
augmenting the destination translations with the source accelerators."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtInstallAccelerators", "Widget");
  XEN_ASSERT_TYPE(XEN_Widget_P(arg2), arg2, 2, "XtInstallAccelerators", "Widget");
  XtInstallAccelerators(XEN_TO_C_Widget(arg1), XEN_TO_C_Widget(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtAugmentTranslations(XEN arg1, XEN arg2)
{
  #define H_XtAugmentTranslations "void XtAugmentTranslations(w, translations) nondestructively merges the new translations into the existing \
widget translations."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtAugmentTranslations", "Widget");
  XEN_ASSERT_TYPE(XEN_XtTranslations_P(arg2), arg2, 2, "XtAugmentTranslations", "XtTranslations");
  XtAugmentTranslations(XEN_TO_C_Widget(arg1), XEN_TO_C_XtTranslations(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtOverrideTranslations(XEN arg1, XEN arg2)
{
  #define H_XtOverrideTranslations "void XtOverrideTranslations(w, translations) destructively merges the new translations into the existing \
widget translations."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtOverrideTranslations", "Widget");
  XEN_ASSERT_TYPE(XEN_XtTranslations_P(arg2), arg2, 2, "XtOverrideTranslations", "XtTranslations");
  XtOverrideTranslations(XEN_TO_C_Widget(arg1), XEN_TO_C_XtTranslations(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XtParseAcceleratorTable(XEN arg1)
{
  #define H_XtParseAcceleratorTable "XtAccelerators XtParseAcceleratorTable(const char *source) compiles source"
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtParseAcceleratorTable", "char*");
  return(C_TO_XEN_ULONG(XtParseAcceleratorTable(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XtParseTranslationTable(XEN arg1)
{
  #define H_XtParseTranslationTable "XtTranslations XtParseTranslationTable(table) compiles the translation table into the opaque internal \
representation of type XtTranslations."
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XtParseTranslationTable", "char*");
  return(C_TO_XEN_XtTranslations(XtParseTranslationTable(XEN_TO_C_STRING(arg1))));
}

static XEN gxm_XtKeysymToKeycodeList(XEN arg1, XEN arg2)
{
  #define H_XtKeysymToKeycodeList "void XtKeysymToKeycodeList(display, keysym) procedure returns all the \
KeyCodes that have keysym in their entry for the keyboard mapping table associated with display -> (keycodes)."
  /* DIFF: XtKeysymToKeycodeList final 2 args omit, returns list
   */
  unsigned int len;
  KeyCode *kr;
  XEN lst = XEN_EMPTY_LIST;
  int i, loc;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XtKeysymToKeycodeList", "Display*");
  XEN_ASSERT_TYPE(XEN_KeySym_P(arg2), arg2, 2, "XtKeysymToKeycodeList", "KeySym");
  XtKeysymToKeycodeList(XEN_TO_C_Display(arg1), XEN_TO_C_KeySym(arg2), &kr, &len);
  loc = xm_protect(lst);
  if (len > 0)
    {
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_KeyCode(kr[i]), lst);
      free(kr);
    }
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XtTranslateCoords(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtTranslateCoords "void XtTranslateCoords(w, x, y) -> (root_x root_y)"
  /* DIFF: XtTranslateCoords omits and returns last 2 args
   */
  Position x, y;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtTranslateCoords", "Widget");
  XEN_ASSERT_TYPE(XEN_Position_P(arg2), arg2, 2, "XtTranslateCoords", "Position");
  XEN_ASSERT_TYPE(XEN_Position_P(arg3), arg3, 3, "XtTranslateCoords", "Position");
  XtTranslateCoords(XEN_TO_C_Widget(arg1), XEN_TO_C_Position(arg2), XEN_TO_C_Position(arg3), &x, &y);
  return(XEN_LIST_2(C_TO_XEN_Position(x),
		    C_TO_XEN_Position(y)));
}

static XEN gxm_XtMakeResizeRequest(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtMakeResizeRequest "XtGeometryResult XtMakeResizeRequest(w, width, height) -> (res width height)"
  /* DIFF: XtMakeResizeRequest w wid hgt [rtnw rtn] -> (list res w h)
   */
  Dimension w, h;
  int val;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtMakeResizeRequest", "Widget");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg2), arg2, 2, "XtMakeResizeRequest", "Dimension");
  XEN_ASSERT_TYPE(XEN_Dimension_P(arg3), arg3, 3, "XtMakeResizeRequest", "Dimension");
  val = XtMakeResizeRequest(XEN_TO_C_Widget(arg1), 
			    XEN_TO_C_Dimension(arg2), 
			    XEN_TO_C_Dimension(arg3), 
			    &w, &h);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_Dimension(w),
		    C_TO_XEN_Dimension(h)));
}

static XEN gxm_XtOwnSelectionIncremental(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6, XEN arg7, XEN arg8)
{
  #define H_XtOwnSelectionIncremental "Boolean XtOwnSelectionIncremental(w, selection, time, convert_callback, lose_callback, \
done_callback, cancel_callback, client_data)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtOwnSelectionIncremental", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtOwnSelectionIncremental", "Atom");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XtOwnSelectionIncremental", "Time");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 10), arg4, 4, "XtOwnSelectionIncremental", "XtConvertSelectionIncrProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg5) && (XEN_REQUIRED_ARGS(arg5) == 3), arg5, 5, "XtOwnSelectionIncremental", "XtLoseSelectionIncrProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg6) && (XEN_REQUIRED_ARGS(arg6) == 5), arg6, 6, "XtOwnSelectionIncremental", "XtSelectionDoneIncrProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg7) && (XEN_REQUIRED_ARGS(arg7) == 5), arg7, 7, "XtOwnSelectionIncremental", "XtCancelConvertSelectionProc");
  return(C_TO_XEN_BOOLEAN(XtOwnSelectionIncremental(XEN_TO_C_Widget(arg1), 
						    XEN_TO_C_Atom(arg2), 
						    XEN_TO_C_Time(arg3), 
						    (XtConvertSelectionIncrProc)gxm_XtConvertSelectionIncrProc, 
						    gxm_XtLoseSelectionIncrProc, 
						    gxm_XtSelectionDoneIncrProc, 
						    gxm_XtCancelConvertSelectionProc, 
						    (XtPointer)arg8)));
}

static XEN gxm_XtOwnSelection(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XtOwnSelection "Boolean XtOwnSelection(w, selection, time, convert_proc, lose_selection, done_proc) informs the selection \
mechanism that a widget believes it owns a selection."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtOwnSelection", "Widget");
  XEN_ASSERT_TYPE(XEN_Atom_P(arg2), arg2, 2, "XtOwnSelection", "Atom");
  XEN_ASSERT_TYPE(XEN_Time_P(arg3), arg3, 3, "XtOwnSelection", "Time");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 7), arg4, 4, "XtOwnSelection", "XtConvertSelectionProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg5) && (XEN_REQUIRED_ARGS(arg5) == 2), arg5, 5, "XtOwnSelection", "XtLoseSelectionProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg6) && (XEN_REQUIRED_ARGS(arg6) == 3), arg6, 6, "XtOwnSelection", "XtSelectionDoneProc");
  return(C_TO_XEN_BOOLEAN(XtOwnSelection(XEN_TO_C_Widget(arg1), 
					 XEN_TO_C_Atom(arg2), 
					 XEN_TO_C_Time(arg3), 
					 (XtConvertSelectionProc)gxm_XtConvertSelectionProc, 
					 gxm_XtLoseSelectionProc, 
					 gxm_XtSelectionDoneProc)));
}

static XEN gxm_XtIsSensitive(XEN arg1)
{
  #define H_XtIsSensitive "Boolean XtIsSensitive(w) returns #t if user input events are being dispatched."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtIsSensitive", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsSensitive(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtIsRealized(XEN arg1)
{
  #define H_XtIsRealized "Boolean XtIsRealized(w) returns #t if the widget has been realized,"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtIsRealized", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsRealized(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtIsManaged(XEN arg1)
{
  #define H_XtIsManaged "Boolean XtIsManaged(widget) returns #t if the specified widget is of class RectObj or any subclass thereof and is managed."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtIsManaged", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsManaged(XEN_TO_C_Widget(arg1))));
}

static XEN gxm_XtIsObject(XEN arg1)
{
  #define H_XtIsObject "Boolean XtIsObject(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtIsObject", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsObject(XEN_TO_C_Widget(arg1))));
}

#if MOTIF_2
static XEN gxm_XtIsSubclass(XEN arg1, XEN arg2)
{
  #define H_XtIsSubclass "Boolean XtIsSubclass(w, widget_class) returns #t if the class of the specified widget is equal to or is a \
subclass of the specified class."
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtIsSubclass", "Widget");
  XEN_ASSERT_TYPE(XEN_WidgetClass_P(arg2), arg2, 2, "XtIsSubclass", "WidgetClass");
  return(C_TO_XEN_BOOLEAN(XtIsSubclass(XEN_TO_C_Widget(arg1), XEN_TO_C_WidgetClass(arg2))));
}
#endif

static XEN gxm_XtAppPeekEvent(XEN arg1)
{
  #define H_XtAppPeekEvent "Boolean XtAppPeekEvent(app_context) fills in the event and returns a nonzero value. If no X \
input is on the queue, XtAppPeekEvent flushes the output buffer and blocks until input is available."
  /* DIFF: XtAppPeekEvent app [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  XEN_ASSERT_TYPE(XEN_XtAppContext_P(arg1), arg1, 1, "XtAppPeekEvent", "XtAppContext");
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XtAppPeekEvent(XEN_TO_C_XtAppContext(arg1), e);
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(val), C_TO_XEN_XEvent_OBJ(e)));
}

#if (!XM_DISABLE_DEPRECATED)
static XEN gxm_XtPeekEvent(void)
{
  #define H_XtPeekEvent "Boolean XtPeekEvent() has been replaced by XtAppPeekEvent."
  /* DIFF: XtPeekEvent [ev] -> (list val ev)
   */
  XEvent *e;
  int val;
  e = (XEvent *)CALLOC(1, sizeof(XEvent));
  val = XtPeekEvent(e);
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(val), C_TO_XEN_XEvent_OBJ(e)));
}
#endif

static XEN gxm_XtCallAcceptFocus(XEN arg1, XEN arg2)
{
  #define H_XtCallAcceptFocus "Boolean XtCallAcceptFocus(w, time) calls the specified widget's accept_focus procedure, passing it the \
specified widget and time, and returns what the accept_focus procedure returns."
  /* DIFF: XtCallAcceptFocus takes Time arg (not Time*)
   */
  Time tm;
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtCallAcceptFocus", "Widget");
  XEN_ASSERT_TYPE(XEN_Time_P(arg2), arg2, 2, "XtCallAcceptFocus", "Time");
  tm = XEN_TO_C_Time(arg2);
  return(C_TO_XEN_BOOLEAN(XtCallAcceptFocus(XEN_TO_C_Widget(arg1), &tm)));
}

static XEN gxm_XtDispatchEvent(XEN arg1)
{
  #define H_XtDispatchEvent "Boolean XtDispatchEvent(event) sends those events to the event handler functions that have been previously \
registered with the dispatch routine."
  XEN_ASSERT_TYPE(XEN_XEvent_P(arg1), arg1, 1, "XtDispatchEvent", "XEvent*");
  return(C_TO_XEN_BOOLEAN(XtDispatchEvent(XEN_TO_C_XEvent(arg1))));
}

static XEN gxm_XtUnmanageChild(XEN arg1)
{
  #define H_XtUnmanageChild "void XtUnmanageChild(child)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtUnmanageChild", "Widget");
  XtUnmanageChild(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtUnmanageChildren(XEN arg1, XEN arg2)
{
  #define H_XtUnmanageChildren "void XtUnmanageChildren(children, num_children)"
  /* DIFF: XtUnmanageChildren arg1 is list of widgets
   */
  WidgetList ws1;
  int len;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XtUnmanageChildren", "WidgetList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtUnmanageChildren", "int");
  len = XEN_TO_C_INT(arg2);
  if (len > 0)
    {
      ws1 = XEN_TO_C_Widgets(arg1, len);
      XtUnmanageChildren(ws1, len);
      if (ws1) FREE(ws1);
    }
  return(XEN_FALSE);
}

static XEN gxm_XtManageChild(XEN arg1)
{
  #define H_XtManageChild "void XtManageChild(child)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg1), arg1, 1, "XtManageChild", "Widget");
  XtManageChild(XEN_TO_C_Widget(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XtManageChildren(XEN arg1, XEN arg2)
{
  #define H_XtManageChildren "void XtManageChildren(children, num_children)"
  /* DIFF: XtManageChildren arg1 is list of widgets
   */
  WidgetList ws1;
  int len;
  XEN_ASSERT_TYPE(XEN_LIST_P(arg1), arg1, 1, "XtManageChildren", "WidgetList");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XtManageChildren", "int");
  len = XEN_TO_C_INT(arg2);
  if (len > 0)
    {
      ws1 = XEN_TO_C_Widgets(arg1, len);
      XtManageChildren(ws1, len);
      if (ws1) FREE(ws1);
    }
  return(XEN_FALSE);
}

static XEN gxm_XtIsRectObj(XEN arg)
{
  #define H_XtIsRectObj "Boolean XtIsRectObj(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsRectObj", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsRectObj(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsWidget(XEN arg)
{
  #define H_XtIsWidget "Boolean XtIsWidget(w)"
  return(C_TO_XEN_BOOLEAN(WRAP_P("Widget", arg) && 
			  (XtIsWidget(XEN_TO_C_Widget(arg)))));
}

static XEN gxm_XtIsComposite(XEN arg)
{
  #define H_XtIsComposite "Boolean XtIsComposite(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsComposite", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsComposite(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsConstraint(XEN arg)
{
  #define H_XtIsConstraint "Boolean XtIsConstraint(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsConstraint", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsConstraint(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsShell(XEN arg)
{
  #define H_XtIsShell "Boolean XtIsShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsOverrideShell(XEN arg)
{
  #define H_XtIsOverrideShell "Boolean XtIsOverrideShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsOverrideShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsOverrideShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsWMShell(XEN arg)
{
  #define H_XtIsWMShell "Boolean XtIsWMShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsWMShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsWMShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsVendorShell(XEN arg)
{
  #define H_XtIsVendorShell "Boolean XtIsVendorShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsVendorShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsVendorShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsTransientShell(XEN arg)
{
  #define H_XtIsTransientShell "Boolean XtIsTransientShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsTransientShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsTransientShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsTopLevelShell(XEN arg)
{
  #define H_XtIsTopLevelShell "Boolean XtIsTopLevelShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsTopLevelShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsTopLevelShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsApplicationShell(XEN arg)
{
  #define H_XtIsApplicationShell "Boolean XtIsApplicationShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsApplicationShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsApplicationShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtIsSessionShell(XEN arg)
{
  #define H_XtIsSessionShell "Boolean XtIsSessionShell(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtIsSessionShell", "Widget");
  return(C_TO_XEN_BOOLEAN(XtIsSessionShell(XEN_TO_C_Widget(arg))));
}

static XEN gxm_XtMapWidget(XEN arg)
{
  #define H_XtMapWidget "XtMapWidget(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtMapWidget", "Widget");
  XtMapWidget(XEN_TO_C_Widget(arg));
  return(XEN_FALSE);
}

static XEN gxm_XtUnmapWidget(XEN arg)
{
  #define H_XtUnmapWidget "XtUnmapWidget(w)"
  XEN_ASSERT_TYPE(XEN_Widget_P(arg), arg, 0, "XtUnmapWidget", "Widget");
  XtUnmapWidget(XEN_TO_C_Widget(arg));
  return(XEN_FALSE);
}

static XEN gxm_XtSetArg(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XtSetArg "XtSetArg in xm is useless -- it returns its arguments as a list"
  return(XEN_LIST_3(arg1, arg2, arg3));
}


#endif
/* end HAVE_MOTIF */


/* ---------------------------------------------------------------------------------------------------- */
#if HAVE_XP
static XEN gxm_XpCancelPage(XEN arg1, XEN arg2)
{
  #define H_XpCancelPage "void XpCancelPage(Display *display,Bool discard)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpCancelPage", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XpCancelPage", "BOOLEAN");
  XpCancelPage(XEN_TO_C_Display(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpEndPage(XEN arg1)
{
  #define H_XpEndPage "void XpEndPage(Display *display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpEndPage", "Display*");
  XpEndPage(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XpStartPage(XEN arg1, XEN arg2)
{
  #define H_XpStartPage "void XpStartPage(Display *display,Window window)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpStartPage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpStartPage", "Window");
  XpStartPage(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpCancelDoc(XEN arg1, XEN arg2)
{
  #define H_XpCancelDoc "void XpCancelDoc(Display *display,Bool discard)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpCancelDoc", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XpCancelDoc", "BOOLEAN");
  XpCancelDoc(XEN_TO_C_Display(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpEndDoc(XEN arg1)
{
  #define H_XpEndDoc "void XpEndDoc(Display *display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpEndDoc", "Display*");
  XpEndDoc(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XpStartDoc(XEN arg1, XEN arg2)
{
  #define H_XpStartDoc "void XpStartDoc(Display *display,XPDocumentType type)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpStartDoc", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XpStartDoc", "XPDocumentType");
  XpStartDoc(XEN_TO_C_Display(arg1), (XPDocumentType)XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpCancelJob(XEN arg1, XEN arg2)
{
  #define H_XpCancelJob "void XpCancelJob(Display *display,Bool discard)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpCancelJob", "Display*");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg2), arg2, 2, "XpCancelJob", "BOOLEAN");
  XpCancelJob(XEN_TO_C_Display(arg1), XEN_TO_C_BOOLEAN(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpEndJob(XEN arg1)
{
  #define H_XpEndJob "void XpEndJob(Display *display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpEndJob", "Display*");
  XpEndJob(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XpStartJob(XEN arg1, XEN arg2)
{
  #define H_XpStartJob "void XpStartJob(Display *display,XPSaveData save_data)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpStartJob", "Display*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg2), arg2, 2, "XpStartJob", "XPSaveData");
  XpStartJob(XEN_TO_C_Display(arg1), (XPSaveData)XEN_TO_C_INT(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpRehashPrinterList(XEN arg1)
{
  #define H_XpRehashPrinterList "void XpRehashPrinterList(Display *display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpRehashPrinterList", "Display*");
  XpRehashPrinterList(XEN_TO_C_Display(arg1));
  return(XEN_FALSE);
}

static XEN gxm_XpDestroyContext(XEN arg1, XEN arg2)
{
  #define H_XpDestroyContext "void XpDestroyContext(Display *display,XPContext print_context)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpDestroyContext", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpDestroyContext", "XPContext");
  XpDestroyContext(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpGetContext(XEN arg1)
{
  #define H_XpGetContext "XPContext XpGetContext(Display *display)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetContext", "Display*");
  return(C_TO_XEN_XPContext(XpGetContext(XEN_TO_C_Display(arg1))));
}

static XEN gxm_XpSetContext(XEN arg1, XEN arg2)
{
  #define H_XpSetContext "void XpSetContext(Display *display,XPContext print_context)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSetContext", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpSetContext", "XPContext");
  XpSetContext(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2));
  return(XEN_FALSE);
}

static XEN gxm_XpCreateContext(XEN arg1, XEN arg2)
{
  #define H_XpCreateContext "XPContext XpCreateContext(Display *display,char *printer_name)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpCreateContext", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XpCreateContext", "char*");
  return(C_TO_XEN_XPContext(XpCreateContext(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2))));
}

static XEN gxm_XpNotifyPdm(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XpNotifyPdm "char *XpNotifyPdm(Display *print_display,Window print_window,XPContext print_context, \
Display *video_display,Window video_window,Bool auth_flag)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpNotifyPdm", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpNotifyPdm", "Window");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg3), arg3, 3, "XpNotifyPdm", "XPContext");
  XEN_ASSERT_TYPE(XEN_Display_P(arg4), arg4, 4, "XpNotifyPdm", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg5), arg5, 5, "XpNotifyPdm", "Window");
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg6), arg6, 6, "XpNotifyPdm", "BOOLEAN");
  return(C_TO_XEN_STRING(XpNotifyPdm(XEN_TO_C_Display(arg1), 
				     XEN_TO_C_Window(arg2), 
				     XEN_TO_C_XPContext(arg3), 
				     XEN_TO_C_Display(arg4), 
				     XEN_TO_C_Window(arg5), 
				     XEN_TO_C_BOOLEAN(arg6))));
}

static XEN gxm_XpGetLocaleNetString(void)
{
  #define H_XpGetLocaleNetString "char *XpGetLocaleNetString(void)"
  return(C_TO_XEN_STRING(XpGetLocaleNetString()));
}

static XEN gxm_XpSendAuth(XEN arg1, XEN arg2)
{
  #define H_XpSendAuth "Status XpSendAuth(Display *display,Window window)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSendAuth", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpSendAuth", "Window");
  return(C_TO_XEN_INT(XpSendAuth(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2))));
}

static XEN gxm_XpGetImageResolution(XEN arg1, XEN arg2)
{
  #define H_XpGetImageResolution "int XpGetImageResolution(Display *display,XPContext print_context)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetImageResolution", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetImageResolution", "XPContext");
  return(C_TO_XEN_INT(XpGetImageResolution(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2))));
}

static XEN gxm_XpGetOneAttribute(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XpGetOneAttribute "char *XpGetOneAttribute(Display *display,XPContext print_context,XPAttributes type,char *attribute_name)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetOneAttribute", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetOneAttribute", "XPContext");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XpGetOneAttribute", "XPAttributes");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XpGetOneAttribute", "char*");
  return(C_TO_XEN_STRING(XpGetOneAttribute(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), 
					   (XPAttributes)XEN_TO_C_INT(arg3), XEN_TO_C_STRING(arg4))));
}

static XEN gxm_XpSetAttributes(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XpSetAttributes "void XpSetAttributes(Display *display,XPContext print_context,XPAttributes type,char *pool,XPAttrReplacement replacement_rule)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSetAttributes", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpSetAttributes", "XPContext");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XpSetAttributes", "XPAttributes");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg4), arg4, 4, "XpSetAttributes", "char*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg5), arg5, 5, "XpSetAttributes", "XPAttrReplacement");
  XpSetAttributes(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), 
		  (XPAttributes)XEN_TO_C_INT(arg3), XEN_TO_C_STRING(arg4), 
		  (XPAttrReplacement)XEN_TO_C_INT(arg5));
  return(XEN_FALSE);
}

static XEN gxm_XpGetAttributes(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XpGetAttributes "char *XpGetAttributes(Display *display,XPContext print_context,XPAttributes type)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetAttributes", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetAttributes", "XPContext");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XpGetAttributes", "XPAttributes");
  return(C_TO_XEN_STRING(XpGetAttributes(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), 
					 (XPAttributes)XEN_TO_C_INT(arg3))));
}

static XEN gxm_XpGetScreenOfContext(XEN arg1, XEN arg2)
{
  #define H_XpGetScreenOfContext "Screen *XpGetScreenOfContext(Display *display,XPContext print_context)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetScreenOfContext", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetScreenOfContext", "XPContext");
  return(C_TO_XEN_Screen(XpGetScreenOfContext(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2))));
}

static XEN gxm_XpSendOneTicket(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XpSendOneTicket "Status XpSendOneTicket(Display *display,Window window,Xauth *ticket,Bool more)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSendOneTicket", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpSendOneTicket", "Window");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XpSendOneTicket", "Xauth*"); /* opaque */
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(arg4), arg4, 4, "XpSendOneTicket", "BOOLEAN");
  return(C_TO_XEN_INT(XpSendOneTicket(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
				      (Xauth *)XEN_TO_C_ULONG(arg3), XEN_TO_C_BOOLEAN(arg4))));
}

static XEN gxm_XpGetAuthParams(XEN arg1, XEN arg2)
{
  #define H_XpGetAuthParams "Status XpGetAuthParams(Display *print_display,Display *video_display)"
  /* DIFF: XpGetAuthParams omits 3 ref args and returns them 
   */
  Atom a1, a2;
  Display *dp;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetAuthParams", "Display*");
  XEN_ASSERT_TYPE(XEN_Display_P(arg2), arg2, 2, "XpGetAuthParams", "Display*");
  val = XpGetAuthParams(XEN_TO_C_Display(arg1), XEN_TO_C_Display(arg2), &dp, &a1, &a2);
  return(XEN_LIST_4(C_TO_XEN_INT(val),
		    C_TO_XEN_Display(dp),
		    C_TO_XEN_Atom(a1),
		    C_TO_XEN_Atom(a2)));
}

static XEN gxm_XpGetPdmStartParams(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XpGetPdmStartParams "Status XpGetPdmStartParams(Display *print_display,Window print_window,XPContext print_context, \
Display *video_display,Window video_window)"
  /* DIFF: XpGetPdmStartParams trailing 6 ref args omitted and returned
   */
  int val, i1, i2;
  Atom a1, a2;
  Display *dp;
  unsigned char *pars;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetPdmStartParams", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpGetPdmStartParams", "Window");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg3), arg3, 3, "XpGetPdmStartParams", "XPContext");
  XEN_ASSERT_TYPE(XEN_Display_P(arg4), arg4, 4, "XpGetPdmStartParams", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg5), arg5, 5, "XpGetPdmStartParams", "Window");
  val = XpGetPdmStartParams(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
			    XEN_TO_C_XPContext(arg3), XEN_TO_C_Display(arg4), 
			    XEN_TO_C_Window(arg5), 
			    &dp, &a1, &a2, &i1, &pars, &i2);
  return(XEN_LIST_7(C_TO_XEN_INT(val),
		    C_TO_XEN_Display(dp),
		    C_TO_XEN_Atom(a1),
		    C_TO_XEN_Atom(a2),
		    C_TO_XEN_INT(i1),
		    C_TO_XEN_INT((int)pars),
		    C_TO_XEN_INT(i2)));
}

static XEN gxm_XpQueryScreens(XEN arg1)
{
  #define H_XpQueryScreens "Screen **XpQueryScreens(Display *display)"
  /* DIFF: XpQueryScreens omits last arg, returns list of Screens
   */
  int len, i, loc;
  Screen **val = NULL;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpQueryScreens", "Display*");
  val = XpQueryScreens(XEN_TO_C_Display(arg1), &len);
  loc = xm_protect(lst);
  if (val)
    {
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(C_TO_XEN_Screen(val[i]), lst);
    }
  xm_unprotect_at(loc);
  return(lst);
}

static XEN gxm_XpQueryExtension(XEN arg1)
{
  #define H_XpQueryExtension "Bool XpQueryExtension(Display *display)"
  /* DIFF: XpQueryExtension omits and rtns last 2 args
   */
  int val, i1, i2;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpQueryExtension", "Display*");
  val = (int)XpQueryExtension(XEN_TO_C_Display(arg1), &i1, &i2);
  return(XEN_LIST_3(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_INT(i1),
		    C_TO_XEN_INT(i2)));
}

static XEN gxm_XpQueryVersion(XEN arg1)
{
  #define H_XpQueryVersion "Status XpQueryVersion(Display *display)"
  /* DIFF: XpQueryVersion omits and rtns last 2 args
   */
  int val;
  short i1, i2;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpQueryVersion", "Display*");
  val = XpQueryVersion(XEN_TO_C_Display(arg1), &i1, &i2);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_INT((int)i1),
		    C_TO_XEN_INT((int)i2)));
}

static XEN gxm_XpFreePrinterList(XEN arg1)
{
  #define H_XpFreePrinterList "void XpFreePrinterList(XPPrinterList printer_list)"
  /* DIFF: XpFreePrinterList is a no-op
   */
  return(XEN_FALSE);
}

static XEN gxm_XpGetPageDimensions(XEN arg1, XEN arg2)
{
  #define H_XpGetPageDimensions "Status XpGetPageDimensions(Display *display,XPContext print_context)"
  /* DIFF: XpGetPageDimensions omits and rtns last 3 args
   */
  unsigned short i1, i2;
  XRectangle *r;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetPageDimensions", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetPageDimensions", "XPContext");
  r = (XRectangle *)CALLOC(1, sizeof(XRectangle));
  val = XpGetPageDimensions(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), &i1, &i2, r);
  return(XEN_LIST_4(C_TO_XEN_INT(val),
		    C_TO_XEN_INT((int)i1),
		    C_TO_XEN_INT((int)i2),
		    C_TO_XEN_XRectangle(r)));
}

static XEN gxm_XpSetImageResolution(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  #define H_XpSetImageResolution "Bool XpSetImageResolution(Display *display,XPContext print_context,int image_res,int *prev_res)"
  /* DIFF: XpSetImageResolution last arg is int, val is returned
   */
  int i, val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSetImageResolution", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpSetImageResolution", "XPContext");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg3), arg3, 3, "XpSetImageResolution", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XpSetImageResolution", "int*");
  val = XpSetImageResolution(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), XEN_TO_C_INT(arg3), &i);
  return(XEN_LIST_2(C_TO_XEN_BOOLEAN(val),
		    C_TO_XEN_INT(i)));
}

static XEN gxm_XpGetPrinterList(XEN arg1, XEN arg2)
{
  #define H_XpGetPrinterList "XPPrinterList XpGetPrinterList(Display *display,char *printer_name)"
  /* DIFF: XpGetPrinterList returns list of printers, omits arg 3
   */
  XPPrinterList xp;
  int i, len, loc;
  XEN lst = XEN_EMPTY_LIST;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetPrinterList", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XpGetPrinterList", "char*");
  xp = XpGetPrinterList(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), &len);
  if (xp)
    {
      loc = xm_protect(lst);
      for (i = len - 1; i >= 0; i--)
	lst = XEN_CONS(XEN_LIST_2(C_TO_XEN_STRING(xp[i].name),
				  C_TO_XEN_STRING(xp[i].desc)),
		       lst);
      XpFreePrinterList(xp);
      xm_unprotect_at(loc);
    }
  return(lst);
}

static XEN gxm_XpSelectInput(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XpSelectInput "void XpSelectInput(Display *display,XPContext print_context,unsigned long event_mask)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpSelectInput", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpSelectInput", "XPContext");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XpSelectInput", "ulong");
  XpSelectInput(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), XEN_TO_C_ULONG(arg3));
  return(XEN_FALSE);
}

static XEN gxm_XpInputSelected(XEN arg1, XEN arg2, XEN arg3)
{
  #define H_XpInputSelected "unsigned long XpInputSelected(Display *display,XPContext print_context,unsigned long *all_events_mask)"
  /* DIFF: XpInputSelected arg3 is int, is returned
   */
  unsigned long val, i1;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpInputSelected", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpInputSelected", "XPContext");
  XEN_ASSERT_TYPE(XEN_ULONG_P(arg3), arg3, 3, "XpInputSelected", "ulong*");
  i1 = XEN_TO_C_ULONG(arg3);
  val = XpInputSelected(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), &i1);
  return(XEN_LIST_2(C_TO_XEN_ULONG(val),
		    C_TO_XEN_ULONG(i1)));
}

static void gxm_XPSaveProc(Display *display, XPContext context, unsigned char *sdata, unsigned int data_len, XPointer client_data)
{
  XEN data = (XEN)client_data;
  XEN_CALL_5(XEN_CAR(data),
	     C_TO_XEN_Display(display),
	     C_TO_XEN_XPContext(context),
	     C_TO_XEN_STRING((const char *)sdata),
	     C_TO_XEN_INT(data_len),
	     XEN_CADDR(data),
	     __FUNCTION__);
  xm_unprotect(data); /* not sure about this -- should it be deferred until the finish proc? */
}

static void gxm_XPFinishProc(Display *display, XPContext context, XPGetDocStatus status, XPointer client_data)
{
  XEN data = (XEN)client_data;
  XEN_CALL_4(XEN_CADR(data),
	     C_TO_XEN_Display(display),
	     C_TO_XEN_XPContext(context),
	     C_TO_XEN_INT(status),
	     XEN_CADDR(data),
	     __FUNCTION__);
  xm_unprotect(data);
}

static XEN gxm_XpGetDocumentData(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  #define H_XpGetDocumentData "Status XpGetDocumentData(Display *display,XPContext context,XPSaveProc save_proc,XPFinishProc finish_proc,XPointer client_data)"
  XEN descr;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpGetDocumentData", "Display*");
  XEN_ASSERT_TYPE(XEN_XPContext_P(arg2), arg2, 2, "XpGetDocumentData", "XPContext");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg3) && (XEN_REQUIRED_ARGS(arg3) == 5), arg3, 3, "XpGetDocumentData", "XPSaveProc");
  XEN_ASSERT_TYPE(XEN_PROCEDURE_P(arg4) && (XEN_REQUIRED_ARGS(arg4) == 4), arg4, 4, "XpGetDocumentData", "XPFinishProc");
  descr = XEN_LIST_3(arg3, arg4, arg5);
  xm_protect(descr);
  return(C_TO_XEN_INT(XpGetDocumentData(XEN_TO_C_Display(arg1), XEN_TO_C_XPContext(arg2), 
					(XPSaveProc)gxm_XPSaveProc,
					(XPFinishProc)gxm_XPFinishProc,
					(char *)descr)));
}

static XEN gxm_XpPutDocumentData(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5, XEN arg6)
{
  #define H_XpPutDocumentData "void XpPutDocumentData(Display *display,Drawable drawable,unsigned char *data,int data_len,char *doc_fmt,char *options)"
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpPutDocumentData", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpPutDocumentData", "Window");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XpPutDocumentData", "uchar*");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(arg4), arg4, 4, "XpPutDocumentData", "int");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg5), arg5, 5, "XpPutDocumentData", "char*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg6), arg6, 6, "XpPutDocumentData", "char*");
  XpPutDocumentData(XEN_TO_C_Display(arg1), XEN_TO_C_Window(arg2), 
		    (unsigned char *)XEN_TO_C_STRING(arg3), 
		    XEN_TO_C_INT(arg4), XEN_TO_C_STRING(arg5), XEN_TO_C_STRING(arg6));
  return(XEN_FALSE);
}
#endif


/* ---------------------------------------------------------------------------------------------------- */
#if HAVE_XPM

XM_TYPE_PTR(XpmImage, XpmImage *)
XM_TYPE_PTR(XpmAttributes, XpmAttributes *) /* _OBJ?? */
XM_TYPE(XpmColorSymbol, XpmColorSymbol *)

#if HAVE_XPM_CREATE_XPM_IMAGE_FROM_PIXMAP
static XEN gxm_XpmCreateXpmImageFromPixmap(XEN arg1, XEN arg2, XEN arg3, XEN arg5)
{
  XpmImage *image;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmCreateXpmImageFromPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg2), arg2, 2, "XpmCreateXpmImageFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XpmCreateXpmImageFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg5) || XEN_FALSE_P(arg5), arg5, 5, "XpmCreateXpmImageFromPixmap", "XpmAttributes*");
  image = (XpmImage *)CALLOC(1, sizeof(XpmImage));
  val = XpmCreateXpmImageFromPixmap(XEN_TO_C_Display(arg1), 
				    XEN_TO_C_Pixmap(arg2), 
				    XEN_TO_C_Pixmap(arg3), 
				    image,
				    (XEN_FALSE_P(arg5)) ? NULL : XEN_TO_C_XpmAttributes(arg5));
  if (val == XpmSuccess)
    return(WRAP_FOR_XEN_OBJ("XpmImage", image));
  FREE(image);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XpmCreatePixmapFromXpmImage(XEN arg1, XEN arg2, XEN arg3, XEN arg4)
{
  /* DIFF: XpmCreatePixmapFromXpmImage omits and returns pixmap args
   */
  Pixmap p1, p2;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmCreatePixmapFromXpmImage", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpmCreatePixmapFromXpmImage", "Drawable");
  XEN_ASSERT_TYPE(XEN_XpmImage_P(arg3), arg3, 3, "XpmCreatePixmapFromXpmImage", "XpmImage*");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg4) || XEN_FALSE_P(arg4), arg4, 4, "XpmCreatePixmapFromXpmImage", "XpmAttributes*");
  val = XpmCreatePixmapFromXpmImage(XEN_TO_C_Display(arg1), 
				    XEN_TO_C_Window(arg2), 
				    XEN_TO_C_XpmImage(arg3), 
				    &p1, &p2,
				    (XEN_FALSE_P(arg4)) ? NULL : XEN_TO_C_XpmAttributes(arg4));
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_Pixmap(p1),
		    C_TO_XEN_Pixmap(p2)));
}
#endif

static XEN gxm_XpmReadFileToPixmap(XEN arg1, XEN arg2, XEN arg3, XEN arg6)
{
  /* DIFF: XpmReadFileToPixmap omits and returns pixmap args
   */
  Pixmap p1, p2;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmReadFileToPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpmReadFileToPixmap", "Drawable");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg3), arg3, 3, "XpmReadFileToPixmap", "char*");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg6) || XEN_FALSE_P(arg6), arg6, 6, "XpmReadFileToPixmap", "XpmAttributes*");
  val = XpmReadFileToPixmap(XEN_TO_C_Display(arg1), 
			    XEN_TO_C_Window(arg2), 
			    XEN_TO_C_STRING(arg3), 
			    &p1, &p2,
			    (XEN_FALSE_P(arg6)) ? NULL : XEN_TO_C_XpmAttributes(arg6));
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_Pixmap(p1),
		    C_TO_XEN_Pixmap(p2)));
}

static XEN gxm_XpmReadFileToXpmImage(XEN arg1)
{
  int val;
  XpmImage *image;
  XEN_ASSERT_TYPE(XEN_STRING_P(arg1), arg1, 1, "XpmReadFileToXpmImage", "char*");
  image = (XpmImage *)CALLOC(1, sizeof(XpmImage));
  val = XpmReadFileToXpmImage(XEN_TO_C_STRING(arg1), image, NULL);
  if (val == XpmSuccess)
    return(WRAP_FOR_XEN_OBJ("XpmImage", image));
  FREE(image);
  return(C_TO_XEN_INT(val));
}

static XEN gxm_XpmCreatePixmapFromData(XEN arg1, XEN arg2, XEN larg3, XEN arg6)
{
  /* DIFF: XpmCreatePixmapFromData omits and returns pixmap args, arg3 (bits) is list of strings
   */
  Pixmap p1, p2;
  int val, i, len;
  char **bits;
  XEN arg3;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmCreatePixmapFromData", "Display*");
  XEN_ASSERT_TYPE(XEN_Window_P(arg2), arg2, 2, "XpmCreatePixmapFromData", "Drawable");
  XEN_ASSERT_TYPE(XEN_LIST_P(larg3), larg3, 3, "XpmCreatePixmapFromData", "list of char*");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg6) || XEN_FALSE_P(arg6), arg6, 6, "XpmCreatePixmapFromData", "XpmAttributes*");
  arg3 = XEN_COPY_ARG(larg3);
  len = XEN_LIST_LENGTH(arg3);
  if (len <= 0) XEN_ASSERT_TYPE(0, arg3, 3, "XpmCreatePixmapFromData", "positive integer");
  bits = (char **)CALLOC(len, sizeof(char *));
  for (i = 0; i < len; i++, arg3 = XEN_CDR(arg3))
    bits[i] = XEN_TO_C_STRING(XEN_CAR(arg3));
  val = XpmCreatePixmapFromData(XEN_TO_C_Display(arg1), 
				XEN_TO_C_Window(arg2), 
				bits,
				&p1, &p2,
				(XEN_FALSE_P(arg6)) ? NULL : XEN_TO_C_XpmAttributes(arg6));
  FREE(bits);
  return(XEN_LIST_3(C_TO_XEN_INT(val),
		    C_TO_XEN_Pixmap(p1),
		    C_TO_XEN_Pixmap(p2)));
}

static XEN gxm_XpmWriteFileFromPixmap(XEN arg1, XEN arg2, XEN arg3, XEN arg4, XEN arg5)
{
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmWriteFileFromPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_STRING_P(arg2), arg2, 2, "XpmWriteFileFromPixmap", "char*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XpmWriteFileFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg4), arg4, 4, "XpmWriteFileFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg5) || XEN_FALSE_P(arg5), arg5, 5, "XpmWriteFileFromPixmap", "XpmAttributes*");
  return(C_TO_XEN_INT(XpmWriteFileFromPixmap(XEN_TO_C_Display(arg1), XEN_TO_C_STRING(arg2), 
					     XEN_TO_C_Pixmap(arg3), XEN_TO_C_Pixmap(arg4), 
					     (XEN_FALSE_P(arg5)) ? NULL : XEN_TO_C_XpmAttributes(arg5))));
}

static XEN gxm_XpmCreateDataFromPixmap(XEN arg1, XEN arg3, XEN arg4, XEN arg5)
{
  /* DIFF: XpmCreateDataFromPixmap arg2 omitted and rtn'd
   */
  char **buf = NULL;
  int val;
  XEN_ASSERT_TYPE(XEN_Display_P(arg1), arg1, 1, "XpmCreateDataFromPixmap", "Display*");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg3), arg3, 3, "XpmCreateDataFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_Pixmap_P(arg4), arg4, 4, "XpmCreateDataFromPixmap", "Pixmap");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(arg5) || XEN_FALSE_P(arg5), arg5, 5, "XpmCreateDataFromPixmap", "XpmAttributes*");
  val = XpmCreateDataFromPixmap(XEN_TO_C_Display(arg1), &buf, 
				XEN_TO_C_Pixmap(arg3), 
				XEN_TO_C_Pixmap(arg4), 
				(XEN_FALSE_P(arg5)) ? NULL : XEN_TO_C_XpmAttributes(arg5));
  return(XEN_LIST_2(C_TO_XEN_INT(val),
		    C_TO_XEN_ULONG(buf)));
}

#if HAVE_XPM_GET_ERROR_STRING
static XEN gxm_XpmGetErrorString(XEN err)
{
  #define H_XpmGetErrorString "(XpmGetErrorString err) -> string describing error"
  XEN_ASSERT_TYPE(XEN_INTEGER_P(err), err, XEN_ONLY_ARG, "XpmGetErrorString", "an Xpm status code");
  return(C_TO_XEN_STRING(XpmGetErrorString(XEN_TO_C_INT(err))));
}
#endif

static XEN gxm_XpmColorSymbol(XEN name, XEN value, XEN pixel)
{
  XpmColorSymbol *r;
  XEN_ASSERT_TYPE(XEN_STRING_P(name), name, 1, "XpmColorSymbol", "char*");
  XEN_ASSERT_TYPE(XEN_FALSE_P(value) || XEN_STRING_P(value), value, 2, "XpmColorSymbol", "char*");
  XEN_ASSERT_TYPE(XEN_Pixel_P(pixel), pixel, 3, "XpmColorSymbol", "Pixel");
  r = (XpmColorSymbol *)CALLOC(1, sizeof(XpmColorSymbol));
  r->name = XEN_TO_C_STRING(name);
  r->value = (XEN_FALSE_P(value)) ? NULL : XEN_TO_C_STRING(value);
  r->pixel = XEN_TO_C_Pixel(pixel);
  return(WRAP_FOR_XEN_OBJ("XpmColorSymbol",r));
}

static XEN gxm_XpmImage(XEN width, XEN height, XEN cpp, XEN ncolors, XEN data)
{
  XpmImage *r;
  XEN_ASSERT_TYPE(XEN_ULONG_P(width), width, 1, "XpmImage", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(height), height, 2, "XpmImage", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(cpp), cpp, 3, "XpmImage", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(ncolors), ncolors, 4, "XpmImage", "ulong");
  XEN_ASSERT_TYPE(XEN_ULONG_P(data), data, 5, "XpmImage", "ulong");
  r = (XpmImage *)CALLOC(1, sizeof(XpmImage));
  r->width = XEN_TO_C_ULONG(width);
  r->height = XEN_TO_C_ULONG(height);
  r->cpp = XEN_TO_C_ULONG(cpp);
  r->ncolors = XEN_TO_C_ULONG(ncolors);
  r->data = (unsigned int *)XEN_TO_C_ULONG(data);
  return(WRAP_FOR_XEN_OBJ("XpmImage", r));
}

static XEN gxm_XpmAttributes(void)
{
  return(WRAP_FOR_XEN_OBJ("XpmAttributes", 
			  (XpmAttributes *)CALLOC(1, sizeof(XpmAttributes))));
}

static XEN gxm_cpp(XEN ptr)
{
  XEN_ASSERT_TYPE((XEN_XpmImage_P(ptr)) || (XEN_XpmAttributes_P(ptr)), ptr, XEN_ONLY_ARG, "cpp", "XpmImage");
  if (XEN_XpmImage_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmImage(ptr))->cpp)));
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->cpp)));
}

static XEN gxm_set_cpp(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE((XEN_XpmImage_P(ptr)) || (XEN_XpmAttributes_P(ptr)), ptr, XEN_ARG_1, "set cpp", "XpmImage");
  if (XEN_XpmImage_P(ptr)) (XEN_TO_C_XpmImage(ptr))->cpp = XEN_TO_C_ULONG(val);
  (XEN_TO_C_XpmAttributes(ptr))->cpp = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_ncolors(XEN ptr)
{
  XEN_ASSERT_TYPE((XEN_XpmImage_P(ptr)) || (XEN_XpmAttributes_P(ptr)), ptr, XEN_ONLY_ARG, "ncolors", "XpmImage");
  if (XEN_XpmImage_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmImage(ptr))->ncolors)));
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->ncolors)));
}

static XEN gxm_set_ncolors(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE((XEN_XpmImage_P(ptr)) || (XEN_XpmAttributes_P(ptr)), ptr, XEN_ARG_1, "ncolors", "XpmImage");
  if (XEN_XpmImage_P(ptr)) (XEN_TO_C_XpmImage(ptr))->ncolors = XEN_TO_C_ULONG(val);
  else (XEN_TO_C_XpmAttributes(ptr))->ncolors = XEN_TO_C_ULONG(val);
  return(val);
}

#if 0
static XEN gxm_set_data(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmImage_P(ptr), ptr, XEN_ARG_1, "data", "XpmImage");
  (XEN_TO_C_XpmImage(ptr))->data = (unsigned int *)XEN_TO_C_ULONG(val);
  return(val);
}
#endif

static XEN gxm_valuemask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "valuemask", "XpmAttributes");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->valuemask)));
}

static XEN gxm_set_valuemask(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set valuemask", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->valuemask = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_x_hotspot(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "x_hotspot", "XpmAttributes");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->x_hotspot)));
}

static XEN gxm_set_x_hotspot(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set x_hotspot", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->x_hotspot = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_y_hotspot(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "y_hotspot", "XpmAttributes");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->y_hotspot)));
}

static XEN gxm_set_y_hotspot(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set y_hotspot", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->y_hotspot = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_colorsymbols(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "colorsymbols", "XpmAttributes");
  return(C_TO_XEN_XpmColorSymbol((XpmColorSymbol *)((XEN_TO_C_XpmAttributes(ptr))->colorsymbols)));
}

static XEN gxm_set_colorsymbols(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set colorsymbols", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->colorsymbols = XEN_TO_C_XpmColorSymbol(val);
  return(val);
}

static XEN gxm_numsymbols(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "numsymbols", "XpmAttributes");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->numsymbols)));
}

static XEN gxm_set_numsymbols(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set numsymbols", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->numsymbols = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_npixels(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "npixels", "XpmAttributes");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->npixels)));
}

static XEN gxm_set_npixels(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ARG_1, "set npixels", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->npixels = XEN_TO_C_ULONG(val);
  return(val);
}

#endif
/* HAVE_XPM */

/* ---------------------------------------------------------------------------------------------------- */

#if HAVE_GUILE
static void define_procedures(void)
{
  xm_gc_table = XEN_MAKE_VECTOR(1, XEN_FALSE);
  XEN_PROTECT_FROM_GC(xm_gc_table);
  xm_protected_size = 512;
  xm_protected = XEN_MAKE_VECTOR(xm_protected_size, XEN_FALSE);
  XEN_VECTOR_SET(xm_gc_table, 0, xm_protected);

#if HAVE_XP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpStartPage" XM_POSTFIX, gxm_XpStartPage, 2, 0, 0, H_XpStartPage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpEndPage" XM_POSTFIX, gxm_XpEndPage, 1, 0, 0, H_XpEndPage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpCancelPage" XM_POSTFIX, gxm_XpCancelPage, 2, 0, 0, H_XpCancelPage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpStartJob" XM_POSTFIX, gxm_XpStartJob, 2, 0, 0, H_XpStartJob);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpEndJob" XM_POSTFIX, gxm_XpEndJob, 1, 0, 0, H_XpEndJob);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpCancelJob" XM_POSTFIX, gxm_XpCancelJob, 2, 0, 0, H_XpCancelJob);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpStartDoc" XM_POSTFIX, gxm_XpStartDoc, 2, 0, 0, H_XpStartDoc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpEndDoc" XM_POSTFIX, gxm_XpEndDoc, 1, 0, 0, H_XpEndDoc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpCancelDoc" XM_POSTFIX, gxm_XpCancelDoc, 2, 0, 0, H_XpCancelDoc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpRehashPrinterList" XM_POSTFIX, gxm_XpRehashPrinterList, 1, 0, 0, H_XpRehashPrinterList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpCreateContext" XM_POSTFIX, gxm_XpCreateContext, 2, 0, 0, H_XpCreateContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSetContext" XM_POSTFIX, gxm_XpSetContext, 2, 0, 0, H_XpSetContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetContext" XM_POSTFIX, gxm_XpGetContext, 1, 0, 0, H_XpGetContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpDestroyContext" XM_POSTFIX, gxm_XpDestroyContext, 2, 0, 0, H_XpDestroyContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetLocaleNetString" XM_POSTFIX, gxm_XpGetLocaleNetString, 0, 0, 0, H_XpGetLocaleNetString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpNotifyPdm" XM_POSTFIX, gxm_XpNotifyPdm, 6, 0, 0, H_XpNotifyPdm);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSendAuth" XM_POSTFIX, gxm_XpSendAuth, 2, 0, 0, H_XpSendAuth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetImageResolution" XM_POSTFIX, gxm_XpGetImageResolution, 2, 0, 0, H_XpGetImageResolution);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetAttributes" XM_POSTFIX, gxm_XpGetAttributes, 3, 0, 0, H_XpGetAttributes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSetAttributes" XM_POSTFIX, gxm_XpSetAttributes, 5, 0, 0, H_XpSetAttributes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetOneAttribute" XM_POSTFIX, gxm_XpGetOneAttribute, 4, 0, 0, H_XpGetOneAttribute);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetScreenOfContext" XM_POSTFIX, gxm_XpGetScreenOfContext, 2, 0, 0, H_XpGetScreenOfContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpFreePrinterList" XM_POSTFIX, gxm_XpFreePrinterList, 1, 0, 0, H_XpFreePrinterList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpQueryVersion" XM_POSTFIX, gxm_XpQueryVersion, 1, 0, 0, H_XpQueryVersion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpQueryExtension" XM_POSTFIX, gxm_XpQueryExtension, 1, 0, 0, H_XpQueryExtension);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpQueryScreens" XM_POSTFIX, gxm_XpQueryScreens, 1, 0, 0, H_XpQueryScreens);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetPdmStartParams" XM_POSTFIX, gxm_XpGetPdmStartParams, 5, 0, 0, H_XpGetPdmStartParams);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetAuthParams" XM_POSTFIX, gxm_XpGetAuthParams, 2, 0, 0, H_XpGetAuthParams);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSendOneTicket" XM_POSTFIX, gxm_XpSendOneTicket, 4, 0, 0, H_XpSendOneTicket);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetPageDimensions" XM_POSTFIX, gxm_XpGetPageDimensions, 2, 0, 0, H_XpGetPageDimensions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSetImageResolution" XM_POSTFIX, gxm_XpSetImageResolution, 4, 0, 0, H_XpSetImageResolution);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetPrinterList" XM_POSTFIX, gxm_XpGetPrinterList, 2, 0, 0, H_XpGetPrinterList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpSelectInput" XM_POSTFIX, gxm_XpSelectInput, 3, 0, 0, H_XpSelectInput);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpInputSelected" XM_POSTFIX, gxm_XpInputSelected, 3, 0, 0, H_XpInputSelected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpPutDocumentData" XM_POSTFIX, gxm_XpPutDocumentData, 6, 0, 0, H_XpPutDocumentData);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpGetDocumentData" XM_POSTFIX, gxm_XpGetDocumentData, 5, 0, 0, H_XpGetDocumentData);
#endif
#if HAVE_MOTIF
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetArg" XM_POSTFIX, gxm_XtSetArg, 3, 0, 0, H_XtSetArg);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtManageChildren" XM_POSTFIX, gxm_XtManageChildren, 2, 0, 0, H_XtManageChildren);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtManageChild" XM_POSTFIX, gxm_XtManageChild, 1, 0, 0, H_XtManageChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUnmanageChildren" XM_POSTFIX, gxm_XtUnmanageChildren, 2, 0, 0, H_XtUnmanageChildren);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUnmanageChild" XM_POSTFIX, gxm_XtUnmanageChild, 1, 0, 0, H_XtUnmanageChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDispatchEvent" XM_POSTFIX, gxm_XtDispatchEvent, 1, 0, 0, H_XtDispatchEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallAcceptFocus" XM_POSTFIX, gxm_XtCallAcceptFocus, 2, 0, 0, H_XtCallAcceptFocus);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppPeekEvent" XM_POSTFIX, gxm_XtAppPeekEvent, 1, 0, 0, H_XtAppPeekEvent);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsSubclass" XM_POSTFIX, gxm_XtIsSubclass, 2, 0, 0, H_XtIsSubclass);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsObject" XM_POSTFIX, gxm_XtIsObject, 1, 0, 0, H_XtIsObject);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsManaged" XM_POSTFIX, gxm_XtIsManaged, 1, 0, 0, H_XtIsManaged);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsRealized" XM_POSTFIX, gxm_XtIsRealized, 1, 0, 0, H_XtIsRealized);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsSensitive" XM_POSTFIX, gxm_XtIsSensitive, 1, 0, 0, H_XtIsSensitive);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtOwnSelection" XM_POSTFIX, gxm_XtOwnSelection, 6, 0, 0, H_XtOwnSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtOwnSelectionIncremental" XM_POSTFIX, gxm_XtOwnSelectionIncremental, 8, 0, 0, H_XtOwnSelectionIncremental);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtMakeResizeRequest" XM_POSTFIX, gxm_XtMakeResizeRequest, 3, 0, 0, H_XtMakeResizeRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtTranslateCoords" XM_POSTFIX, gxm_XtTranslateCoords, 3, 0, 0, H_XtTranslateCoords);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtKeysymToKeycodeList" XM_POSTFIX, gxm_XtKeysymToKeycodeList, 2, 0, 0, H_XtKeysymToKeycodeList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtParseTranslationTable" XM_POSTFIX, gxm_XtParseTranslationTable, 1, 0, 0, H_XtParseTranslationTable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtParseAcceleratorTable" XM_POSTFIX, gxm_XtParseAcceleratorTable, 1, 0, 0, H_XtParseAcceleratorTable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtOverrideTranslations" XM_POSTFIX, gxm_XtOverrideTranslations, 2, 0, 0, H_XtOverrideTranslations);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAugmentTranslations" XM_POSTFIX, gxm_XtAugmentTranslations, 2, 0, 0, H_XtAugmentTranslations);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInstallAccelerators" XM_POSTFIX, gxm_XtInstallAccelerators, 2, 0, 0, H_XtInstallAccelerators);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInstallAllAccelerators" XM_POSTFIX, gxm_XtInstallAllAccelerators, 2, 0, 0, H_XtInstallAllAccelerators);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUninstallTranslations" XM_POSTFIX, gxm_XtUninstallTranslations, 1, 0, 0, H_XtUninstallTranslations);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppAddActions" XM_POSTFIX, gxm_XtAppAddActions, 2, 0, 0, H_XtAppAddActions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppAddActionHook" XM_POSTFIX, gxm_XtAppAddActionHook, 2, 1, 0, H_XtAppAddActionHook);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveActionHook" XM_POSTFIX, gxm_XtRemoveActionHook, 1, 0, 0, H_XtRemoveActionHook);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetActionList" XM_POSTFIX, gxm_XtGetActionList, 1, 0, 0, H_XtGetActionList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallActionProc" XM_POSTFIX, gxm_XtCallActionProc, 4, 1, 0, H_XtCallActionProc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRegisterGrabAction" XM_POSTFIX, gxm_XtRegisterGrabAction, 5, 0, 0, H_XtRegisterGrabAction);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetMultiClickTime" XM_POSTFIX, gxm_XtSetMultiClickTime, 2, 0, 0, H_XtSetMultiClickTime);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetMultiClickTime" XM_POSTFIX, gxm_XtGetMultiClickTime, 1, 0, 0, H_XtGetMultiClickTime);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetActionKeysym" XM_POSTFIX, gxm_XtGetActionKeysym, 1, 0, 0, H_XtGetActionKeysym);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtTranslateKeycode" XM_POSTFIX, gxm_XtTranslateKeycode, 3, 0, 0, H_XtTranslateKeycode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtTranslateKey" XM_POSTFIX, gxm_XtTranslateKey, 3, 0, 0, H_XtTranslateKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetKeyTranslator" XM_POSTFIX, gxm_XtSetKeyTranslator, 2, 0, 0, H_XtSetKeyTranslator);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRegisterCaseConverter" XM_POSTFIX, gxm_XtRegisterCaseConverter, 4, 0, 0, H_XtRegisterCaseConverter);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtConvertCase" XM_POSTFIX, gxm_XtConvertCase, 2, 0, 0, H_XtConvertCase);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddEventHandler" XM_POSTFIX, gxm_XtAddEventHandler, 4, 1, 0, H_XtAddEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveEventHandler" XM_POSTFIX, gxm_XtRemoveEventHandler, 5, 0, 0, H_XtRemoveEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddRawEventHandler" XM_POSTFIX, gxm_XtAddRawEventHandler, 5, 0, 0, H_XtAddRawEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveRawEventHandler" XM_POSTFIX, gxm_XtRemoveRawEventHandler, 5, 0, 0, H_XtRemoveRawEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInsertEventHandler" XM_POSTFIX, gxm_XtInsertEventHandler, 6, 0, 0, H_XtInsertEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInsertRawEventHandler" XM_POSTFIX, gxm_XtInsertRawEventHandler, 6, 0, 0, H_XtInsertRawEventHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDispatchEventToWidget" XM_POSTFIX, gxm_XtDispatchEventToWidget, 2, 0, 0, H_XtDispatchEventToWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtBuildEventMask" XM_POSTFIX, gxm_XtBuildEventMask, 1, 0, 0, H_XtBuildEventMask);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddGrab" XM_POSTFIX, gxm_XtAddGrab, 3, 0, 0, H_XtAddGrab);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveGrab" XM_POSTFIX, gxm_XtRemoveGrab, 1, 0, 0, H_XtRemoveGrab);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppProcessEvent" XM_POSTFIX, gxm_XtAppProcessEvent, 2, 0, 0, H_XtAppProcessEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppMainLoop" XM_POSTFIX, gxm_XtAppMainLoop, 1, 0, 0, H_XtAppMainLoop);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddExposureToRegion" XM_POSTFIX, gxm_XtAddExposureToRegion, 2, 0, 0, H_XtAddExposureToRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetKeyboardFocus" XM_POSTFIX, gxm_XtSetKeyboardFocus, 2, 0, 0, H_XtSetKeyboardFocus);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetKeyboardFocusWidget" XM_POSTFIX, gxm_XtGetKeyboardFocusWidget, 1, 0, 0, H_XtGetKeyboardFocusWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtLastEventProcessed" XM_POSTFIX, gxm_XtLastEventProcessed, 1, 0, 0, H_XtLastEventProcessed);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtLastTimestampProcessed" XM_POSTFIX, gxm_XtLastTimestampProcessed, 1, 0, 0, H_XtLastTimestampProcessed);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppAddTimeOut" XM_POSTFIX, gxm_XtAppAddTimeOut, 3, 1, 0, H_XtAppAddTimeOut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveTimeOut" XM_POSTFIX, gxm_XtRemoveTimeOut, 1, 0, 0, H_XtRemoveTimeOut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppAddInput" XM_POSTFIX, gxm_XtAppAddInput, 4, 1, 0, H_XtAppAddInput);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveInput" XM_POSTFIX, gxm_XtRemoveInput, 1, 0, 0, H_XtRemoveInput);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppNextEvent" XM_POSTFIX, gxm_XtAppNextEvent, 1, 0, 0, H_XtAppNextEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppPending" XM_POSTFIX, gxm_XtAppPending, 1, 0, 0, H_XtAppPending);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRealizeWidget" XM_POSTFIX, gxm_XtRealizeWidget, 1, 0, 0, H_XtRealizeWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUnrealizeWidget" XM_POSTFIX, gxm_XtUnrealizeWidget, 1, 0, 0, H_XtUnrealizeWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDestroyWidget" XM_POSTFIX, gxm_XtDestroyWidget, 1, 0, 0, H_XtDestroyWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetSensitive" XM_POSTFIX, gxm_XtSetSensitive, 2, 0, 0, H_XtSetSensitive);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtNameToWidget" XM_POSTFIX, gxm_XtNameToWidget, 2, 0, 0, H_XtNameToWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWindowToWidget" XM_POSTFIX, gxm_XtWindowToWidget, 2, 0, 0, H_XtWindowToWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtMergeArgLists" XM_POSTFIX, gxm_XtMergeArgLists, 4, 0, 0, H_XtMergeArgLists);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaCreateArgsList" XM_POSTFIX, gxm_XtVaCreateArgsList, 2, 0, 0, H_XtVaCreateArgsList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDisplay" XM_POSTFIX, gxm_XtDisplay, 1, 0, 0, H_XtDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDisplayOfObject" XM_POSTFIX, gxm_XtDisplayOfObject, 1, 0, 0, H_XtDisplayOfObject);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtScreen" XM_POSTFIX, gxm_XtScreen, 1, 0, 0, H_XtScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtScreenOfObject" XM_POSTFIX, gxm_XtScreenOfObject, 1, 0, 0, H_XtScreenOfObject);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWindow" XM_POSTFIX, gxm_XtWindow, 1, 0, 0, H_XtWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWindowOfObject" XM_POSTFIX, gxm_XtWindowOfObject, 1, 0, 0, H_XtWindowOfObject);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtName" XM_POSTFIX, gxm_XtName, 1, 0, 0, H_XtName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSuperclass" XM_POSTFIX, gxm_XtSuperclass, 1, 0, 0, H_XtSuperclass);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtClass" XM_POSTFIX, gxm_XtClass, 1, 0, 0, H_XtClass);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtParent" XM_POSTFIX, gxm_XtParent, 1, 0, 0, H_XtParent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddCallback" XM_POSTFIX, gxm_XtAddCallback, 3, 1, 0, H_XtAddCallback);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveCallback" XM_POSTFIX, gxm_XtRemoveCallback, 3, 0, 0, H_XtRemoveCallback);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddCallbacks" XM_POSTFIX, gxm_XtAddCallbacks, 3, 0, 0, H_XtAddCallbacks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveCallbacks" XM_POSTFIX, gxm_XtRemoveCallbacks, 3, 0, 0, H_XtRemoveCallbacks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveAllCallbacks" XM_POSTFIX, gxm_XtRemoveAllCallbacks, 2, 0, 0, H_XtRemoveAllCallbacks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallCallbacks" XM_POSTFIX, gxm_XtCallCallbacks, 3, 0, 0, H_XtCallCallbacks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallCallbackList" XM_POSTFIX, gxm_XtCallCallbackList, 3, 0, 0, H_XtCallCallbackList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtHasCallbacks" XM_POSTFIX, gxm_XtHasCallbacks, 2, 0, 0, H_XtHasCallbacks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreatePopupShell" XM_POSTFIX, gxm_XtCreatePopupShell, 4, 1, 0, H_XtCreatePopupShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaCreatePopupShell" XM_POSTFIX, gxm_XtVaCreatePopupShell, 4, 0, 0, H_XtVaCreatePopupShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtPopup" XM_POSTFIX, gxm_XtPopup, 2, 0, 0, H_XtPopup);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtPopupSpringLoaded" XM_POSTFIX, gxm_XtPopupSpringLoaded, 1, 0, 0, H_XtPopupSpringLoaded);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallbackNone" XM_POSTFIX, gxm_XtCallbackNone, 3, 0, 0, H_XtCallbackNone);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallbackNonexclusive" XM_POSTFIX, gxm_XtCallbackNonexclusive, 3, 0, 0, H_XtCallbackNonexclusive);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallbackExclusive" XM_POSTFIX, gxm_XtCallbackExclusive, 3, 0, 0, H_XtCallbackExclusive);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtPopdown" XM_POSTFIX, gxm_XtPopdown, 1, 0, 0, H_XtPopdown);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCallbackPopdown" XM_POSTFIX, gxm_XtCallbackPopdown, 3, 0, 0, H_XtCallbackPopdown);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreateWidget" XM_POSTFIX, gxm_XtCreateWidget, 4, 1, 0, H_XtCreateWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreateManagedWidget" XM_POSTFIX, gxm_XtCreateManagedWidget, 4, 1, 0, H_XtCreateManagedWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaCreateWidget" XM_POSTFIX, gxm_XtVaCreateWidget, 4, 0, 0, H_XtVaCreateWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaCreateManagedWidget" XM_POSTFIX, gxm_XtVaCreateManagedWidget, 4, 0, 0, H_XtVaCreateManagedWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppCreateShell" XM_POSTFIX, gxm_XtAppCreateShell, 5, 1, 0, H_XtAppCreateShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaAppCreateShell" XM_POSTFIX, gxm_XtVaAppCreateShell, 5, 0, 0, H_XtVaAppCreateShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtToolkitInitialize" XM_POSTFIX, gxm_XtToolkitInitialize, 0, 0, 0, H_XtToolkitInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetLanguageProc" XM_POSTFIX, gxm_XtSetLanguageProc, 3, 0, 0, H_XtSetLanguageProc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDisplayInitialize" XM_POSTFIX, gxm_XtDisplayInitialize, 8, 0, 0, H_XtDisplayInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtOpenApplication" XM_POSTFIX, gxm_XtOpenApplication, 9, 0, 0, H_XtOpenApplication);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaOpenApplication" XM_POSTFIX, gxm_XtVaOpenApplication, 8, 0, 0, H_XtVaOpenApplication);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppInitialize" XM_POSTFIX, gxm_XtAppInitialize, 8, 0, 0, H_XtAppInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaAppInitialize" XM_POSTFIX, gxm_XtVaAppInitialize, 7, 0, 0, H_XtVaAppInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtOpenDisplay" XM_POSTFIX, gxm_XtOpenDisplay, 8, 0, 0, H_XtOpenDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreateApplicationContext" XM_POSTFIX, gxm_XtCreateApplicationContext, 0, 0, 0, H_XtCreateApplicationContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDestroyApplicationContext" XM_POSTFIX, gxm_XtDestroyApplicationContext, 1, 0, 0, H_XtDestroyApplicationContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInitializeWidgetClass" XM_POSTFIX, gxm_XtInitializeWidgetClass, 1, 0, 0, H_XtInitializeWidgetClass);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWidgetToApplicationContext" XM_POSTFIX, gxm_XtWidgetToApplicationContext, 1, 0, 0, H_XtWidgetToApplicationContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDisplayToApplicationContext" XM_POSTFIX, gxm_XtDisplayToApplicationContext, 1, 0, 0, H_XtDisplayToApplicationContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCloseDisplay" XM_POSTFIX, gxm_XtCloseDisplay, 1, 0, 0, H_XtCloseDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetValues" XM_POSTFIX, gxm_XtSetValues, 2, 1, 0, H_XtSetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaSetValues" XM_POSTFIX, gxm_XtVaSetValues, 2, 0, 0, H_XtVaSetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetValues" XM_POSTFIX, gxm_XtGetValues, 2, 1, 0, H_XtGetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtVaGetValues" XM_POSTFIX, gxm_XtVaGetValues, 2, 0, 0, H_XtVaGetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppSetErrorMsgHandler" XM_POSTFIX, gxm_XtAppSetErrorMsgHandler, 2, 0, 0, H_XtAppSetErrorMsgHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppSetWarningMsgHandler" XM_POSTFIX, gxm_XtAppSetWarningMsgHandler, 2, 0, 0, H_XtAppSetWarningMsgHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppErrorMsg" XM_POSTFIX, gxm_XtAppErrorMsg, 7, 0, 0, H_XtAppErrorMsg);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppWarningMsg" XM_POSTFIX, gxm_XtAppWarningMsg, 7, 0, 0, H_XtAppWarningMsg);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppSetErrorHandler" XM_POSTFIX, gxm_XtAppSetErrorHandler, 2, 0, 0, H_XtAppSetErrorHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppSetWarningHandler" XM_POSTFIX, gxm_XtAppSetWarningHandler, 2, 0, 0, H_XtAppSetWarningHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppError" XM_POSTFIX, gxm_XtAppError, 2, 0, 0, H_XtAppError);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtMalloc" XM_POSTFIX, gxm_XtMalloc, 1, 0, 0, H_XtMalloc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCalloc" XM_POSTFIX, gxm_XtCalloc, 2, 0, 0, H_XtCalloc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRealloc" XM_POSTFIX, gxm_XtRealloc, 2, 0, 0, H_XtRealloc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtFree" XM_POSTFIX, gxm_XtFree, 1, 0, 0, H_XtFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppAddWorkProc" XM_POSTFIX, gxm_XtAppAddWorkProc, 2, 1, 0, H_XtAppAddWorkProc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRemoveWorkProc" XM_POSTFIX, gxm_XtRemoveWorkProc, 1, 0, 0, H_XtRemoveWorkProc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetGC" XM_POSTFIX, gxm_XtGetGC, 3, 0, 0, H_XtGetGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAllocateGC" XM_POSTFIX, gxm_XtAllocateGC, 6, 0, 0, H_XtAllocateGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDestroyGC" XM_POSTFIX, gxm_XtDestroyGC, 1, 0, 0, H_XtDestroyGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtReleaseGC" XM_POSTFIX, gxm_XtReleaseGC, 2, 0, 0, H_XtReleaseGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetWMColormapWindows" XM_POSTFIX, gxm_XtSetWMColormapWindows, 3, 0, 0, H_XtSetWMColormapWindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtFindFile" XM_POSTFIX, gxm_XtFindFile, 4, 0, 0, H_XtFindFile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtResolvePathname" XM_POSTFIX, gxm_XtResolvePathname, 8, 0, 0, H_XtResolvePathname);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtDisownSelection" XM_POSTFIX, gxm_XtDisownSelection, 3, 0, 0, H_XtDisownSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionValue" XM_POSTFIX, gxm_XtGetSelectionValue, 6, 0, 0, H_XtGetSelectionValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionValues" XM_POSTFIX, gxm_XtGetSelectionValues, 7, 0, 0, H_XtGetSelectionValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppSetSelectionTimeout" XM_POSTFIX, gxm_XtAppSetSelectionTimeout, 2, 0, 0, H_XtAppSetSelectionTimeout);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppGetSelectionTimeout" XM_POSTFIX, gxm_XtAppGetSelectionTimeout, 1, 0, 0, H_XtAppGetSelectionTimeout);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionRequest" XM_POSTFIX, gxm_XtGetSelectionRequest, 3, 0, 0, H_XtGetSelectionRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionValueIncremental" XM_POSTFIX, gxm_XtGetSelectionValueIncremental, 6, 0, 0, H_XtGetSelectionValueIncremental);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionValuesIncremental" XM_POSTFIX, gxm_XtGetSelectionValuesIncremental, 7, 0, 0, H_XtGetSelectionValuesIncremental);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreateSelectionRequest" XM_POSTFIX, gxm_XtCreateSelectionRequest, 2, 0, 0, H_XtCreateSelectionRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSendSelectionRequest" XM_POSTFIX, gxm_XtSendSelectionRequest, 3, 0, 0, H_XtSendSelectionRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCancelSelectionRequest" XM_POSTFIX, gxm_XtCancelSelectionRequest, 2, 0, 0, H_XtCancelSelectionRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGrabKey" XM_POSTFIX, gxm_XtGrabKey, 6, 0, 0, H_XtGrabKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUngrabKey" XM_POSTFIX, gxm_XtUngrabKey, 3, 0, 0, H_XtUngrabKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGrabKeyboard" XM_POSTFIX, gxm_XtGrabKeyboard, 5, 0, 0, H_XtGrabKeyboard);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUngrabKeyboard" XM_POSTFIX, gxm_XtUngrabKeyboard, 2, 0, 0, H_XtUngrabKeyboard);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGrabButton" XM_POSTFIX, gxm_XtGrabButton, 9, 0, 0, H_XtGrabButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUngrabButton" XM_POSTFIX, gxm_XtUngrabButton, 3, 0, 0, H_XtUngrabButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGrabPointer" XM_POSTFIX, gxm_XtGrabPointer, 8, 0, 0, H_XtGrabPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUngrabPointer" XM_POSTFIX, gxm_XtUngrabPointer, 2, 0, 0, H_XtUngrabPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetApplicationNameAndClass" XM_POSTFIX, gxm_XtGetApplicationNameAndClass, 1, 0, 0, H_XtGetApplicationNameAndClass);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetDisplays" XM_POSTFIX, gxm_XtGetDisplays, 1, 0, 0, H_XtGetDisplays);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtToolkitThreadInitialize" XM_POSTFIX, gxm_XtToolkitThreadInitialize, 0, 0, 0, H_XtToolkitThreadInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppLock" XM_POSTFIX, gxm_XtAppLock, 1, 0, 0, H_XtAppLock);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppUnlock" XM_POSTFIX, gxm_XtAppUnlock, 1, 0, 0, H_XtAppUnlock);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsRectObj" XM_POSTFIX, gxm_XtIsRectObj, 1, 0, 0, H_XtIsRectObj);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsWidget" XM_POSTFIX, gxm_XtIsWidget, 1, 0, 0, H_XtIsWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsComposite" XM_POSTFIX, gxm_XtIsComposite, 1, 0, 0, H_XtIsComposite);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsConstraint" XM_POSTFIX, gxm_XtIsConstraint, 1, 0, 0, H_XtIsConstraint);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsShell" XM_POSTFIX, gxm_XtIsShell, 1, 0, 0, H_XtIsShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsOverrideShell" XM_POSTFIX, gxm_XtIsOverrideShell, 1, 0, 0, H_XtIsOverrideShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsWMShell" XM_POSTFIX, gxm_XtIsWMShell, 1, 0, 0, H_XtIsWMShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsVendorShell" XM_POSTFIX, gxm_XtIsVendorShell, 1, 0, 0, H_XtIsVendorShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsTransientShell" XM_POSTFIX, gxm_XtIsTransientShell, 1, 0, 0, H_XtIsTransientShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsTopLevelShell" XM_POSTFIX, gxm_XtIsTopLevelShell, 1, 0, 0, H_XtIsTopLevelShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsApplicationShell" XM_POSTFIX, gxm_XtIsApplicationShell, 1, 0, 0, H_XtIsApplicationShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIsSessionShell" XM_POSTFIX, gxm_XtIsSessionShell, 1, 0, 0, H_XtIsSessionShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtMapWidget" XM_POSTFIX, gxm_XtMapWidget, 1, 0, 0, H_XtMapWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtUnmapWidget" XM_POSTFIX, gxm_XtUnmapWidget, 1, 0, 0, H_XtUnmapWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppContext" XM_POSTFIX, gxm_XtAppContext, 1, 0, 0, "wraps bare XtAppContext pointer for xm");
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLoadQueryFont" XM_POSTFIX, gxm_XLoadQueryFont, 2, 0, 0, H_XLoadQueryFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryFont" XM_POSTFIX, gxm_XQueryFont, 2, 0, 0, H_XQueryFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetMotionEvents" XM_POSTFIX, gxm_XGetMotionEvents, 4, 0, 0, H_XGetMotionEvents);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDeleteModifiermapEntry" XM_POSTFIX, gxm_XDeleteModifiermapEntry, 3, 0, 0, H_XDeleteModifiermapEntry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetModifierMapping" XM_POSTFIX, gxm_XGetModifierMapping, 1, 0, 0, H_XGetModifierMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XInsertModifiermapEntry" XM_POSTFIX, gxm_XInsertModifiermapEntry, 3, 0, 0, H_XInsertModifiermapEntry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XNewModifiermap" XM_POSTFIX, gxm_XNewModifiermap, 1, 0, 0, H_XNewModifiermap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateImage" XM_POSTFIX, gxm_XCreateImage, 0, 0, 1, H_XCreateImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetImage" XM_POSTFIX, gxm_XGetImage, 8, 0, 0, H_XGetImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetSubImage" XM_POSTFIX, gxm_XGetSubImage, 0, 0, 1, H_XGetSubImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XOpenDisplay" XM_POSTFIX, gxm_XOpenDisplay, 1, 0, 0, H_XOpenDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFetchBytes" XM_POSTFIX, gxm_XFetchBytes, 1, 0, 0, H_XFetchBytes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFetchBuffer" XM_POSTFIX, gxm_XFetchBuffer, 2, 0, 0, H_XFetchBuffer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetAtomName" XM_POSTFIX, gxm_XGetAtomName, 2, 0, 0, H_XGetAtomName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayName" XM_POSTFIX, gxm_XDisplayName, 1, 0, 0, H_XDisplayName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKeysymToString" XM_POSTFIX, gxm_XKeysymToString, 1, 0, 0, H_XKeysymToString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSynchronize" XM_POSTFIX, gxm_XSynchronize, 2, 0, 0, H_XSynchronize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetAfterFunction" XM_POSTFIX, gxm_XSetAfterFunction, 2, 0, 0, H_XSetAfterFunction);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XInternAtom" XM_POSTFIX, gxm_XInternAtom, 3, 0, 0, H_XInternAtom);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCopyColormapAndFree" XM_POSTFIX, gxm_XCopyColormapAndFree, 2, 0, 0, H_XCopyColormapAndFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateColormap" XM_POSTFIX, gxm_XCreateColormap, 4, 0, 0, H_XCreateColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreatePixmapCursor" XM_POSTFIX, gxm_XCreatePixmapCursor, 7, 0, 0, H_XCreatePixmapCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateGlyphCursor" XM_POSTFIX, gxm_XCreateGlyphCursor, 7, 0, 0, H_XCreateGlyphCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateFontCursor" XM_POSTFIX, gxm_XCreateFontCursor, 2, 0, 0, H_XCreateFontCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLoadFont" XM_POSTFIX, gxm_XLoadFont, 2, 0, 0, H_XLoadFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateGC" XM_POSTFIX, gxm_XCreateGC, 4, 0, 0, H_XCreateGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFlushGC" XM_POSTFIX, gxm_XFlushGC, 2, 0, 0, H_XFlushGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreatePixmap" XM_POSTFIX, gxm_XCreatePixmap, 5, 0, 0, H_XCreatePixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateBitmapFromData" XM_POSTFIX, gxm_XCreateBitmapFromData, 5, 0, 0, H_XCreateBitmapFromData);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreatePixmapFromBitmapData" XM_POSTFIX, gxm_XCreatePixmapFromBitmapData, 8, 0, 0, H_XCreatePixmapFromBitmapData);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateSimpleWindow" XM_POSTFIX, gxm_XCreateSimpleWindow, 9, 0, 0, H_XCreateSimpleWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetSelectionOwner" XM_POSTFIX, gxm_XGetSelectionOwner, 2, 0, 0, H_XGetSelectionOwner);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateWindow" XM_POSTFIX, gxm_XCreateWindow, 0, 0, 1, H_XCreateWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListInstalledColormaps" XM_POSTFIX, gxm_XListInstalledColormaps, 2, 0, 0, H_XListInstalledColormaps);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListFonts" XM_POSTFIX, gxm_XListFonts, 3, 0, 0, H_XListFonts);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListFontsWithInfo" XM_POSTFIX, gxm_XListFontsWithInfo, 3, 0, 0, H_XListFontsWithInfo);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetFontPath" XM_POSTFIX, gxm_XGetFontPath, 1, 0, 0, H_XGetFontPath);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListExtensions" XM_POSTFIX, gxm_XListExtensions, 1, 0, 0, H_XListExtensions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListProperties" XM_POSTFIX, gxm_XListProperties, 2, 0, 0, H_XListProperties);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKeycodeToKeysym" XM_POSTFIX, gxm_XKeycodeToKeysym, 3, 0, 0, H_XKeycodeToKeysym);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLookupKeysym" XM_POSTFIX, gxm_XLookupKeysym, 2, 0, 0, H_XLookupKeysym);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetKeyboardMapping" XM_POSTFIX, gxm_XGetKeyboardMapping, 3, 0, 0, H_XGetKeyboardMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStringToKeysym" XM_POSTFIX, gxm_XStringToKeysym, 1, 0, 0, H_XStringToKeysym);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMaxRequestSize" XM_POSTFIX, gxm_XMaxRequestSize, 1, 0, 0, H_XMaxRequestSize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XExtendedMaxRequestSize" XM_POSTFIX, gxm_XExtendedMaxRequestSize, 1, 0, 0, H_XExtendedMaxRequestSize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayMotionBufferSize" XM_POSTFIX, gxm_XDisplayMotionBufferSize, 1, 0, 0, H_XDisplayMotionBufferSize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XVisualIDFromVisual" XM_POSTFIX, gxm_XVisualIDFromVisual, 1, 0, 0, H_XVisualIDFromVisual);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XInitThreads" XM_POSTFIX, gxm_XInitThreads, 0, 0, 0, H_XInitThreads);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLockDisplay" XM_POSTFIX, gxm_XLockDisplay, 1, 0, 0, H_XLockDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnlockDisplay" XM_POSTFIX, gxm_XUnlockDisplay, 1, 0, 0, H_XUnlockDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRootWindow" XM_POSTFIX, gxm_XRootWindow, 2, 0, 0, H_RootWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultRootWindow" XM_POSTFIX, gxm_XDefaultRootWindow, 1, 0, 0, H_DefaultRootWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRootWindowOfScreen" XM_POSTFIX, gxm_XRootWindowOfScreen, 1, 0, 0, H_RootWindowOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultVisual" XM_POSTFIX, gxm_XDefaultVisual, 2, 0, 0, H_DefaultVisual);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultVisualOfScreen" XM_POSTFIX, gxm_XDefaultVisualOfScreen, 1, 0, 0, H_DefaultVisualOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultGC" XM_POSTFIX, gxm_XDefaultGC, 2, 0, 0, H_DefaultGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultGCOfScreen" XM_POSTFIX, gxm_XDefaultGCOfScreen, 1, 0, 0, H_DefaultGCOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBlackPixel" XM_POSTFIX, gxm_XBlackPixel, 2, 0, 0, H_BlackPixel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWhitePixel" XM_POSTFIX, gxm_XWhitePixel, 2, 0, 0, H_WhitePixel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllPlanes" XM_POSTFIX, gxm_XAllPlanes, 0, 0, 0, H_AllPlanes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBlackPixelOfScreen" XM_POSTFIX, gxm_XBlackPixelOfScreen, 1, 0, 0, H_BlackPixelOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWhitePixelOfScreen" XM_POSTFIX, gxm_XWhitePixelOfScreen, 1, 0, 0, H_WhitePixelOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XNextRequest" XM_POSTFIX, gxm_XNextRequest, 1, 0, 0, H_NextRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLastKnownRequestProcessed" XM_POSTFIX, gxm_XLastKnownRequestProcessed, 1, 0, 0, H_LastKnownRequestProcessed);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XServerVendor" XM_POSTFIX, gxm_XServerVendor, 1, 0, 0, H_ServerVendor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayString" XM_POSTFIX, gxm_XDisplayString, 1, 0, 0, H_DisplayString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultColormap" XM_POSTFIX, gxm_XDefaultColormap, 2, 0, 0, H_DefaultColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultColormapOfScreen" XM_POSTFIX, gxm_XDefaultColormapOfScreen, 1, 0, 0, H_DefaultColormapOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayOfScreen" XM_POSTFIX, gxm_XDisplayOfScreen, 1, 0, 0, H_DisplayOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XScreenOfDisplay" XM_POSTFIX, gxm_XScreenOfDisplay, 2, 0, 0, H_ScreenOfDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultScreenOfDisplay" XM_POSTFIX, gxm_XDefaultScreenOfDisplay, 1, 0, 0, H_DefaultScreenOfDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEventMaskOfScreen" XM_POSTFIX, gxm_XEventMaskOfScreen, 1, 0, 0, H_EventMaskOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XScreenNumberOfScreen" XM_POSTFIX, gxm_XScreenNumberOfScreen, 1, 0, 0, H_XScreenNumberOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetErrorHandler" XM_POSTFIX, gxm_XSetErrorHandler, 1, 0, 0, H_XSetErrorHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetIOErrorHandler" XM_POSTFIX, gxm_XSetIOErrorHandler, 1, 0, 0, H_XSetIOErrorHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListPixmapFormats" XM_POSTFIX, gxm_XListPixmapFormats, 1, 0, 0, H_XListPixmapFormats);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XListDepths" XM_POSTFIX, gxm_XListDepths, 2, 0, 0, H_XListDepths);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XReconfigureWMWindow" XM_POSTFIX, gxm_XReconfigureWMWindow, 5, 0, 0, H_XReconfigureWMWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetWMProtocols" XM_POSTFIX, gxm_XGetWMProtocols, 2, 0, 0, H_XGetWMProtocols);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWMProtocols" XM_POSTFIX, gxm_XSetWMProtocols, 4, 0, 0, H_XSetWMProtocols);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XIconifyWindow" XM_POSTFIX, gxm_XIconifyWindow, 3, 0, 0, H_XIconifyWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWithdrawWindow" XM_POSTFIX, gxm_XWithdrawWindow, 3, 0, 0, H_XWithdrawWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetCommand" XM_POSTFIX, gxm_XGetCommand, 2, 0, 0, H_XGetCommand);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetWMColormapWindows" XM_POSTFIX, gxm_XGetWMColormapWindows, 2, 0, 0, H_XGetWMColormapWindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWMColormapWindows" XM_POSTFIX, gxm_XSetWMColormapWindows, 4, 0, 0, H_XSetWMColormapWindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeStringList" XM_POSTFIX, gxm_XFreeStringList, 1, 0, 0, H_XFreeStringList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetTransientForHint" XM_POSTFIX, gxm_XSetTransientForHint, 3, 0, 0, H_XSetTransientForHint);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XActivateScreenSaver" XM_POSTFIX, gxm_XActivateScreenSaver, 1, 0, 0, H_XActivateScreenSaver);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocColor" XM_POSTFIX, gxm_XAllocColor, 3, 0, 0, H_XAllocColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocColorCells" XM_POSTFIX, gxm_XAllocColorCells, 5, 0, 0, H_XAllocColorCells);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocColorPlanes" XM_POSTFIX, gxm_XAllocColorPlanes, 0, 0, 1, H_XAllocColorPlanes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocNamedColor" XM_POSTFIX, gxm_XAllocNamedColor, 5, 0, 0, H_XAllocNamedColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllowEvents" XM_POSTFIX, gxm_XAllowEvents, 3, 0, 0, H_XAllowEvents);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAutoRepeatOff" XM_POSTFIX, gxm_XAutoRepeatOff, 1, 0, 0, H_XAutoRepeatOff);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAutoRepeatOn" XM_POSTFIX, gxm_XAutoRepeatOn, 1, 0, 0, H_XAutoRepeatOn);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBell" XM_POSTFIX, gxm_XBell, 2, 0, 0, H_XBell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBitmapBitOrder" XM_POSTFIX, gxm_XBitmapBitOrder, 1, 0, 0, H_BitmapBitOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBitmapPad" XM_POSTFIX, gxm_XBitmapPad, 1, 0, 0, H_BitmapPad);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBitmapUnit" XM_POSTFIX, gxm_XBitmapUnit, 1, 0, 0, H_BitmapUnit);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCellsOfScreen" XM_POSTFIX, gxm_XCellsOfScreen, 1, 0, 0, H_CellsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeActivePointerGrab" XM_POSTFIX, gxm_XChangeActivePointerGrab, 4, 0, 0, H_XChangeActivePointerGrab);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeGC" XM_POSTFIX, gxm_XChangeGC, 4, 0, 0, H_XChangeGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeKeyboardControl" XM_POSTFIX, gxm_XChangeKeyboardControl, 3, 0, 0, H_XChangeKeyboardControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeKeyboardMapping" XM_POSTFIX, gxm_XChangeKeyboardMapping, 5, 0, 0, H_XChangeKeyboardMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangePointerControl" XM_POSTFIX, gxm_XChangePointerControl, 6, 0, 0, H_XChangePointerControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeProperty" XM_POSTFIX, gxm_XChangeProperty, 7, 1, 0, H_XChangeProperty);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XChangeWindowAttributes" XM_POSTFIX, gxm_XChangeWindowAttributes, 4, 0, 0, H_XChangeWindowAttributes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCheckIfEvent" XM_POSTFIX, gxm_XCheckIfEvent, 3, 0, 0, H_XCheckIfEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCheckMaskEvent" XM_POSTFIX, gxm_XCheckMaskEvent, 2, 0, 0, H_XCheckMaskEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCheckTypedEvent" XM_POSTFIX, gxm_XCheckTypedEvent, 2, 0, 0, H_XCheckTypedEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCheckTypedWindowEvent" XM_POSTFIX, gxm_XCheckTypedWindowEvent, 3, 0, 0, H_XCheckTypedWindowEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCheckWindowEvent" XM_POSTFIX, gxm_XCheckWindowEvent, 3, 0, 0, H_XCheckWindowEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCirculateSubwindows" XM_POSTFIX, gxm_XCirculateSubwindows, 3, 0, 0, H_XCirculateSubwindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCirculateSubwindowsDown" XM_POSTFIX, gxm_XCirculateSubwindowsDown, 2, 0, 0, H_XCirculateSubwindowsDown);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCirculateSubwindowsUp" XM_POSTFIX, gxm_XCirculateSubwindowsUp, 2, 0, 0, H_XCirculateSubwindowsUp);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XClearArea" XM_POSTFIX, gxm_XClearArea, 7, 0, 0, H_XClearArea);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XClearWindow" XM_POSTFIX, gxm_XClearWindow, 2, 0, 0, H_XClearWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCloseDisplay" XM_POSTFIX, gxm_XCloseDisplay, 1, 0, 0, H_XCloseDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConfigureWindow" XM_POSTFIX, gxm_XConfigureWindow, 4, 0, 0, H_XConfigureWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConnectionNumber" XM_POSTFIX, gxm_XConnectionNumber, 1, 0, 0, H_XConnectionNumber);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConvertSelection" XM_POSTFIX, gxm_XConvertSelection, 6, 0, 0, H_XConvertSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCopyArea" XM_POSTFIX, gxm_XCopyArea, 0, 0, 1, H_XCopyArea);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCopyGC" XM_POSTFIX, gxm_XCopyGC, 4, 0, 0, H_XCopyGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCopyPlane" XM_POSTFIX, gxm_XCopyPlane, 0, 0, 1, H_XCopyPlane);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultDepth" XM_POSTFIX, gxm_XDefaultDepth, 2, 0, 0, H_DefaultDepth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultDepthOfScreen" XM_POSTFIX, gxm_XDefaultDepthOfScreen, 1, 0, 0, H_DefaultDepthOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultScreen" XM_POSTFIX, gxm_XDefaultScreen, 1, 0, 0, H_DefaultScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefineCursor" XM_POSTFIX, gxm_XDefineCursor, 3, 0, 0, H_XDefineCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDeleteProperty" XM_POSTFIX, gxm_XDeleteProperty, 3, 0, 0, H_XDeleteProperty);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDestroyWindow" XM_POSTFIX, gxm_XDestroyWindow, 2, 0, 0, H_XDestroyWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDestroySubwindows" XM_POSTFIX, gxm_XDestroySubwindows, 2, 0, 0, H_XDestroySubwindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDoesBackingStore" XM_POSTFIX, gxm_XDoesBackingStore, 1, 0, 0, H_XDoesBackingStore);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDoesSaveUnders" XM_POSTFIX, gxm_XDoesSaveUnders, 1, 0, 0, H_XDoesSaveUnders);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisableAccessControl" XM_POSTFIX, gxm_XDisableAccessControl, 1, 0, 0, H_XDisableAccessControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayCells" XM_POSTFIX, gxm_XDisplayCells, 2, 0, 0, H_XDisplayCells);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayHeight" XM_POSTFIX, gxm_XDisplayHeight, 2, 0, 0, H_XDisplayHeight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayHeightMM" XM_POSTFIX, gxm_XDisplayHeightMM, 2, 0, 0, H_XDisplayHeightMM);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayKeycodes" XM_POSTFIX, gxm_XDisplayKeycodes, 1, 0, 0, H_XDisplayKeycodes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayPlanes" XM_POSTFIX, gxm_XDisplayPlanes, 2, 0, 0, H_XDisplayPlanes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayWidth" XM_POSTFIX, gxm_XDisplayWidth, 2, 0, 0, H_XDisplayWidth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDisplayWidthMM" XM_POSTFIX, gxm_XDisplayWidthMM, 2, 0, 0, H_XDisplayWidthMM);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawArc" XM_POSTFIX, gxm_XDrawArc, 9, 0, 0, H_XDrawArc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawArcs" XM_POSTFIX, gxm_XDrawArcs, 5, 0, 0, H_XDrawArcs);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawImageString" XM_POSTFIX, gxm_XDrawImageString, 7, 0, 0, H_XDrawImageString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawLine" XM_POSTFIX, gxm_XDrawLine, 7, 0, 0, H_XDrawLine);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawLines" XM_POSTFIX, gxm_XDrawLines, 6, 0, 0, H_XDrawLines);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawLinesDirect" XM_POSTFIX, gxm_XDrawLinesDirect, 6, 0, 0, H_XDrawLinesDirect);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "freeXPoints" XM_POSTFIX, gxm_FreeXPoints, 1, 0, 0, H_freeXPoints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "moveXPoints" XM_POSTFIX, gxm_MoveXPoints, 4, 0, 0, H_moveXPoints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "vector->XPoints" XM_POSTFIX, gxm_Vector2XPoints, 1, 0, 0, H_vector2XPoints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawPoint" XM_POSTFIX, gxm_XDrawPoint, 5, 0, 0, H_XDrawPoint);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawPoints" XM_POSTFIX, gxm_XDrawPoints, 6, 0, 0, H_XDrawPoints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawRectangle" XM_POSTFIX, gxm_XDrawRectangle, 7, 0, 0, H_XDrawRectangle);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawRectangles" XM_POSTFIX, gxm_XDrawRectangles, 5, 0, 0, H_XDrawRectangles);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawSegments" XM_POSTFIX, gxm_XDrawSegments, 5, 0, 0, H_XDrawSegments);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawString" XM_POSTFIX, gxm_XDrawString, 7, 0, 0, H_XDrawString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDrawText" XM_POSTFIX, gxm_XDrawText, 7, 0, 0, H_XDrawText);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEnableAccessControl" XM_POSTFIX, gxm_XEnableAccessControl, 1, 0, 0, H_XEnableAccessControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEventsQueued" XM_POSTFIX, gxm_XEventsQueued, 2, 0, 0, H_XEventsQueued);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFetchName" XM_POSTFIX, gxm_XFetchName, 2, 0, 0, H_XFetchName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFillArc" XM_POSTFIX, gxm_XFillArc, 9, 0, 0, H_XFillArc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFillArcs" XM_POSTFIX, gxm_XFillArcs, 5, 0, 0, H_XFillArcs);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFillPolygon" XM_POSTFIX, gxm_XFillPolygon, 7, 0, 0, H_XFillPolygon);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFillRectangle" XM_POSTFIX, gxm_XFillRectangle, 7, 0, 0, H_XFillRectangle);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFillRectangles" XM_POSTFIX, gxm_XFillRectangles, 5, 0, 0, H_XFillRectangles);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFlush" XM_POSTFIX, gxm_XFlush, 1, 0, 0, H_XFlush);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XForceScreenSaver" XM_POSTFIX, gxm_XForceScreenSaver, 2, 0, 0, H_XForceScreenSaver);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFree" XM_POSTFIX, gxm_XFree, 1, 0, 0, H_XFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeColormap" XM_POSTFIX, gxm_XFreeColormap, 2, 0, 0, H_XFreeColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeColors" XM_POSTFIX, gxm_XFreeColors, 5, 0, 0, H_XFreeColors);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeCursor" XM_POSTFIX, gxm_XFreeCursor, 2, 0, 0, H_XFreeCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeExtensionList" XM_POSTFIX, gxm_XFreeExtensionList, 1, 0, 0, "a no-op in xm");
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeFont" XM_POSTFIX, gxm_XFreeFont, 2, 0, 0, H_XFreeFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeFontInfo" XM_POSTFIX, gxm_XFreeFontInfo, 3, 0, 0, H_XFreeFontInfo);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeFontNames" XM_POSTFIX, gxm_XFreeFontNames, 1, 0, 0, H_XFreeFontNames);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeFontPath" XM_POSTFIX, gxm_XFreeFontPath, 1, 0, 0, H_XFreeFontPath);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeGC" XM_POSTFIX, gxm_XFreeGC, 2, 0, 0, H_XFreeGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeModifiermap" XM_POSTFIX, gxm_XFreeModifiermap, 1, 0, 0, H_XFreeModifiermap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreePixmap" XM_POSTFIX, gxm_XFreePixmap, 2, 0, 0, H_XFreePixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGeometry" XM_POSTFIX, gxm_XGeometry, 0, 0, 1, H_XGeometry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetErrorText" XM_POSTFIX, gxm_XGetErrorText, 4, 0, 0, H_XGetErrorText);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetFontProperty" XM_POSTFIX, gxm_XGetFontProperty, 2, 0, 0, H_XGetFontProperty);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetGCValues" XM_POSTFIX, gxm_XGetGCValues, 3, 0, 0, H_XGetGCValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGCValues" XM_POSTFIX, gxm_XGCValues, 0, 0, 0, "creates a new XGCValues object for xm");
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEvent" XM_POSTFIX, gxm_XEvent, 0, 1, 0, "creates a new XEvent object for xm");
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetGeometry" XM_POSTFIX, gxm_XGetGeometry, 2, 0, 0, H_XGetGeometry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetIconName" XM_POSTFIX, gxm_XGetIconName, 2, 0, 0, H_XGetIconName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetInputFocus" XM_POSTFIX, gxm_XGetInputFocus, 1, 0, 0, H_XGetInputFocus);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetKeyboardControl" XM_POSTFIX, gxm_XGetKeyboardControl, 1, 0, 0, H_XGetKeyboardControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetPointerControl" XM_POSTFIX, gxm_XGetPointerControl, 1, 0, 0, H_XGetPointerControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetPointerMapping" XM_POSTFIX, gxm_XGetPointerMapping, 3, 0, 0, H_XGetPointerMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetScreenSaver" XM_POSTFIX, gxm_XGetScreenSaver, 1, 0, 0, H_XGetScreenSaver);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetTransientForHint" XM_POSTFIX, gxm_XGetTransientForHint, 2, 0, 0, H_XGetTransientForHint);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetWindowProperty" XM_POSTFIX, gxm_XGetWindowProperty, 0, 0, 1, H_XGetWindowProperty);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetWindowAttributes" XM_POSTFIX, gxm_XGetWindowAttributes, 2, 0, 0, H_XGetWindowAttributes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGrabButton" XM_POSTFIX, gxm_XGrabButton, 0, 0, 1, H_XGrabButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGrabKey" XM_POSTFIX, gxm_XGrabKey, 7, 0, 0, H_XGrabKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGrabKeyboard" XM_POSTFIX, gxm_XGrabKeyboard, 6, 0, 0, H_XGrabKeyboard);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGrabPointer" XM_POSTFIX, gxm_XGrabPointer, 9, 0, 0, H_XGrabPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGrabServer" XM_POSTFIX, gxm_XGrabServer, 1, 0, 0, H_XGrabServer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XHeightMMOfScreen" XM_POSTFIX, gxm_XHeightMMOfScreen, 1, 0, 0, H_HeightMMOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XHeightOfScreen" XM_POSTFIX, gxm_XHeightOfScreen, 1, 0, 0, H_HeightOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XIfEvent" XM_POSTFIX, gxm_XIfEvent, 3, 0, 0, H_XIfEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XImageByteOrder" XM_POSTFIX, gxm_XImageByteOrder, 1, 0, 0, H_ImageByteOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XInstallColormap" XM_POSTFIX, gxm_XInstallColormap, 2, 0, 0, H_XInstallColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKeysymToKeycode" XM_POSTFIX, gxm_XKeysymToKeycode, 2, 0, 0, H_XKeysymToKeycode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKillClient" XM_POSTFIX, gxm_XKillClient, 2, 0, 0, H_XKillClient);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLookupColor" XM_POSTFIX, gxm_XLookupColor, 5, 0, 0, H_XLookupColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLowerWindow" XM_POSTFIX, gxm_XLowerWindow, 2, 0, 0, H_XLowerWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMapRaised" XM_POSTFIX, gxm_XMapRaised, 2, 0, 0, H_XMapRaised);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMapSubwindows" XM_POSTFIX, gxm_XMapSubwindows, 2, 0, 0, H_XMapSubwindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMapWindow" XM_POSTFIX, gxm_XMapWindow, 2, 0, 0, H_XMapWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMaskEvent" XM_POSTFIX, gxm_XMaskEvent, 2, 0, 0, H_XMaskEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMaxCmapsOfScreen" XM_POSTFIX, gxm_XMaxCmapsOfScreen, 1, 0, 0, H_MaxCmapsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMinCmapsOfScreen" XM_POSTFIX, gxm_XMinCmapsOfScreen, 1, 0, 0, H_MinCmapsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMoveResizeWindow" XM_POSTFIX, gxm_XMoveResizeWindow, 6, 0, 0, H_XMoveResizeWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMoveWindow" XM_POSTFIX, gxm_XMoveWindow, 4, 0, 0, H_XMoveWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XNextEvent" XM_POSTFIX, gxm_XNextEvent, 1, 0, 0, H_XNextEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XNoOp" XM_POSTFIX, gxm_XNoOp, 1, 0, 0, H_XNoOp);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XParseColor" XM_POSTFIX, gxm_XParseColor, 4, 0, 0, H_XParseColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XParseGeometry" XM_POSTFIX, gxm_XParseGeometry, 1, 0, 0, H_XParseGeometry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPeekEvent" XM_POSTFIX, gxm_XPeekEvent, 1, 0, 0, H_XPeekEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPeekIfEvent" XM_POSTFIX, gxm_XPeekIfEvent, 3, 0, 0, H_XPeekIfEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPending" XM_POSTFIX, gxm_XPending, 1, 0, 0, H_XPending);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPlanesOfScreen" XM_POSTFIX, gxm_XPlanesOfScreen, 1, 0, 0, H_PlanesOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XProtocolRevision" XM_POSTFIX, gxm_XProtocolRevision, 1, 0, 0, H_ProtocolRevision);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XProtocolVersion" XM_POSTFIX, gxm_XProtocolVersion, 1, 0, 0, H_ProtocolVersion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPutBackEvent" XM_POSTFIX, gxm_XPutBackEvent, 2, 0, 0, H_XPutBackEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPutImage" XM_POSTFIX, gxm_XPutImage, 0, 0, 1, H_XPutImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQLength" XM_POSTFIX, gxm_XQLength, 1, 0, 0, H_QLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryBestCursor" XM_POSTFIX, gxm_XQueryBestCursor, 4, 0, 0, H_XQueryBestCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryBestSize" XM_POSTFIX, gxm_XQueryBestSize, 5, 0, 0, H_XQueryBestSize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryBestStipple" XM_POSTFIX, gxm_XQueryBestStipple, 4, 0, 0, H_XQueryBestStipple);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryBestTile" XM_POSTFIX, gxm_XQueryBestTile, 4, 0, 0, H_XQueryBestTile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryColor" XM_POSTFIX, gxm_XQueryColor, 3, 0, 0, H_XQueryColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryColors" XM_POSTFIX, gxm_XQueryColors, 3, 1, 0, H_XQueryColors);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryExtension" XM_POSTFIX, gxm_XQueryExtension, 2, 0, 0, H_XQueryExtension);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryKeymap" XM_POSTFIX, gxm_XQueryKeymap, 1, 0, 0, H_XQueryKeymap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryPointer" XM_POSTFIX, gxm_XQueryPointer, 2, 0, 0, H_XQueryPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryTextExtents" XM_POSTFIX, gxm_XQueryTextExtents, 3, 0, 0, H_XQueryTextExtents);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XQueryTree" XM_POSTFIX, gxm_XQueryTree, 2, 0, 0, H_XQueryTree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRaiseWindow" XM_POSTFIX, gxm_XRaiseWindow, 2, 0, 0, H_XRaiseWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XReadBitmapFile" XM_POSTFIX, gxm_XReadBitmapFile, 3, 0, 0, H_XReadBitmapFile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XReadBitmapFileData" XM_POSTFIX, gxm_XReadBitmapFileData, 1, 0, 0, H_XReadBitmapFileData);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRebindKeysym" XM_POSTFIX, gxm_XRebindKeysym, 6, 0, 0, H_XRebindKeysym);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRecolorCursor" XM_POSTFIX, gxm_XRecolorCursor, 4, 0, 0, H_XRecolorCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRefreshKeyboardMapping" XM_POSTFIX, gxm_XRefreshKeyboardMapping, 1, 0, 0, H_XRefreshKeyboardMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XReparentWindow" XM_POSTFIX, gxm_XReparentWindow, 5, 0, 0, H_XReparentWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XResetScreenSaver" XM_POSTFIX, gxm_XResetScreenSaver, 1, 0, 0, H_XResetScreenSaver);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XResizeWindow" XM_POSTFIX, gxm_XResizeWindow, 4, 0, 0, H_XResizeWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRestackWindows" XM_POSTFIX, gxm_XRestackWindows, 3, 0, 0, H_XRestackWindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRotateBuffers" XM_POSTFIX, gxm_XRotateBuffers, 2, 0, 0, H_XRotateBuffers);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRotateWindowProperties" XM_POSTFIX, gxm_XRotateWindowProperties, 5, 0, 0, H_XRotateWindowProperties);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XScreenCount" XM_POSTFIX, gxm_XScreenCount, 1, 0, 0, H_ScreenCount);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSelectInput" XM_POSTFIX, gxm_XSelectInput, 3, 0, 0, H_XSelectInput);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSendEvent" XM_POSTFIX, gxm_XSendEvent, 5, 0, 0, H_XSendEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetAccessControl" XM_POSTFIX, gxm_XSetAccessControl, 2, 0, 0, H_XSetAccessControl);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetArcMode" XM_POSTFIX, gxm_XSetArcMode, 3, 0, 0, H_XSetArcMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetBackground" XM_POSTFIX, gxm_XSetBackground, 3, 0, 0, H_XSetBackground);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetClipMask" XM_POSTFIX, gxm_XSetClipMask, 3, 0, 0, H_XSetClipMask);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetClipOrigin" XM_POSTFIX, gxm_XSetClipOrigin, 4, 0, 0, H_XSetClipOrigin);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetClipRectangles" XM_POSTFIX, gxm_XSetClipRectangles, 7, 0, 0, H_XSetClipRectangles);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetCloseDownMode" XM_POSTFIX, gxm_XSetCloseDownMode, 2, 0, 0, H_XSetCloseDownMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetCommand" XM_POSTFIX, gxm_XSetCommand, 4, 0, 0, H_XSetCommand);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetDashes" XM_POSTFIX, gxm_XSetDashes, 4, 1, 0, H_XSetDashes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetFillRule" XM_POSTFIX, gxm_XSetFillRule, 3, 0, 0, H_XSetFillRule);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetFillStyle" XM_POSTFIX, gxm_XSetFillStyle, 3, 0, 0, H_XSetFillStyle);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetFont" XM_POSTFIX, gxm_XSetFont, 3, 0, 0, H_XSetFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetFontPath" XM_POSTFIX, gxm_XSetFontPath, 3, 0, 0, H_XSetFontPath);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetForeground" XM_POSTFIX, gxm_XSetForeground, 3, 0, 0, H_XSetForeground);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetFunction" XM_POSTFIX, gxm_XSetFunction, 3, 0, 0, H_XSetFunction);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetGraphicsExposures" XM_POSTFIX, gxm_XSetGraphicsExposures, 3, 0, 0, H_XSetGraphicsExposures);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetIconName" XM_POSTFIX, gxm_XSetIconName, 3, 0, 0, H_XSetIconName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetInputFocus" XM_POSTFIX, gxm_XSetInputFocus, 4, 0, 0, H_XSetInputFocus);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetLineAttributes" XM_POSTFIX, gxm_XSetLineAttributes, 6, 0, 0, H_XSetLineAttributes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetModifierMapping" XM_POSTFIX, gxm_XSetModifierMapping, 2, 0, 0, H_XSetModifierMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetPlaneMask" XM_POSTFIX, gxm_XSetPlaneMask, 3, 0, 0, H_XSetPlaneMask);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetPointerMapping" XM_POSTFIX, gxm_XSetPointerMapping, 2, 1, 0, H_XSetPointerMapping);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetScreenSaver" XM_POSTFIX, gxm_XSetScreenSaver, 5, 0, 0, H_XSetScreenSaver);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetSelectionOwner" XM_POSTFIX, gxm_XSetSelectionOwner, 4, 0, 0, H_XSetSelectionOwner);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetState" XM_POSTFIX, gxm_XSetState, 6, 0, 0, H_XSetState);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetStipple" XM_POSTFIX, gxm_XSetStipple, 3, 0, 0, H_XSetStipple);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetSubwindowMode" XM_POSTFIX, gxm_XSetSubwindowMode, 3, 0, 0, H_XSetSubwindowMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetTSOrigin" XM_POSTFIX, gxm_XSetTSOrigin, 4, 0, 0, H_XSetTSOrigin);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetTile" XM_POSTFIX, gxm_XSetTile, 3, 0, 0, H_XSetTile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowBackground" XM_POSTFIX, gxm_XSetWindowBackground, 3, 0, 0, H_XSetWindowBackground);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowBackgroundPixmap" XM_POSTFIX, gxm_XSetWindowBackgroundPixmap, 3, 0, 0, H_XSetWindowBackgroundPixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowBorder" XM_POSTFIX, gxm_XSetWindowBorder, 3, 0, 0, H_XSetWindowBorder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowBorderPixmap" XM_POSTFIX, gxm_XSetWindowBorderPixmap, 3, 0, 0, H_XSetWindowBorderPixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowBorderWidth" XM_POSTFIX, gxm_XSetWindowBorderWidth, 3, 0, 0, H_XSetWindowBorderWidth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowColormap" XM_POSTFIX, gxm_XSetWindowColormap, 3, 0, 0, H_XSetWindowColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreBuffer" XM_POSTFIX, gxm_XStoreBuffer, 4, 0, 0, H_XStoreBuffer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreBytes" XM_POSTFIX, gxm_XStoreBytes, 3, 0, 0, H_XStoreBytes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreColor" XM_POSTFIX, gxm_XStoreColor, 3, 0, 0, H_XStoreColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreColors" XM_POSTFIX, gxm_XStoreColors, 4, 0, 0, H_XStoreColors);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreName" XM_POSTFIX, gxm_XStoreName, 3, 0, 0, H_XStoreName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStoreNamedColor" XM_POSTFIX, gxm_XStoreNamedColor, 5, 0, 0, H_XStoreNamedColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSync" XM_POSTFIX, gxm_XSync, 2, 0, 0, H_XSync);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XTextExtents" XM_POSTFIX, gxm_XTextExtents, 3, 0, 0, H_XTextExtents);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XTextWidth" XM_POSTFIX, gxm_XTextWidth, 3, 0, 0, H_XTextWidth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XTranslateCoordinates" XM_POSTFIX, gxm_XTranslateCoordinates, 5, 0, 0, H_XTranslateCoordinates);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUndefineCursor" XM_POSTFIX, gxm_XUndefineCursor, 2, 0, 0, H_XUndefineCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUngrabButton" XM_POSTFIX, gxm_XUngrabButton, 4, 0, 0, H_XUngrabButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUngrabKey" XM_POSTFIX, gxm_XUngrabKey, 4, 0, 0, H_XUngrabKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUngrabKeyboard" XM_POSTFIX, gxm_XUngrabKeyboard, 2, 0, 0, H_XUngrabKeyboard);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUngrabPointer" XM_POSTFIX, gxm_XUngrabPointer, 2, 0, 0, H_XUngrabPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUngrabServer" XM_POSTFIX, gxm_XUngrabServer, 1, 0, 0, H_XUngrabServer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUninstallColormap" XM_POSTFIX, gxm_XUninstallColormap, 2, 0, 0, H_XUninstallColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnloadFont" XM_POSTFIX, gxm_XUnloadFont, 2, 0, 0, H_XUnloadFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnmapSubwindows" XM_POSTFIX, gxm_XUnmapSubwindows, 2, 0, 0, H_XUnmapSubwindows);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnmapWindow" XM_POSTFIX, gxm_XUnmapWindow, 2, 0, 0, H_XUnmapWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XVendorRelease" XM_POSTFIX, gxm_XVendorRelease, 1, 0, 0, H_VendorRelease);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWarpPointer" XM_POSTFIX, gxm_XWarpPointer, 9, 0, 0, H_XWarpPointer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWidthMMOfScreen" XM_POSTFIX, gxm_XWidthMMOfScreen, 1, 0, 0, H_WidthMMOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWidthOfScreen" XM_POSTFIX, gxm_XWidthOfScreen, 1, 0, 0, H_WidthOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWindowEvent" XM_POSTFIX, gxm_XWindowEvent, 3, 0, 0, H_XWindowEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWriteBitmapFile" XM_POSTFIX, gxm_XWriteBitmapFile, 7, 0, 0, H_XWriteBitmapFile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSupportsLocale" XM_POSTFIX, gxm_XSupportsLocale, 0, 0, 0, H_XSupportsLocale);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetLocaleModifiers" XM_POSTFIX, gxm_XSetLocaleModifiers, 1, 0, 0, H_XSetLocaleModifiers);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateFontSet" XM_POSTFIX, gxm_XCreateFontSet, 2, 0, 0, H_XCreateFontSet);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFreeFontSet" XM_POSTFIX, gxm_XFreeFontSet, 2, 0, 0, H_XFreeFontSet);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFontsOfFontSet" XM_POSTFIX, gxm_XFontsOfFontSet, 1, 0, 0, H_XFontsOfFontSet);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XBaseFontNameListOfFontSet" XM_POSTFIX, gxm_XBaseFontNameListOfFontSet, 1, 0, 0, H_XBaseFontNameListOfFontSet);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLocaleOfFontSet" XM_POSTFIX, gxm_XLocaleOfFontSet, 1, 0, 0, H_XLocaleOfFontSet);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XContextDependentDrawing" XM_POSTFIX, gxm_XContextDependentDrawing, 1, 0, 0, H_XContextDependentDrawing);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDirectionalDependentDrawing" XM_POSTFIX, gxm_XDirectionalDependentDrawing, 1, 0, 0, H_XDirectionalDependentDrawing);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XContextualDrawing" XM_POSTFIX, gxm_XContextualDrawing, 1, 0, 0, H_XContextualDrawing);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFilterEvent" XM_POSTFIX, gxm_XFilterEvent, 2, 0, 0, H_XFilterEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocIconSize" XM_POSTFIX, gxm_XAllocIconSize, 0, 0, 0, H_XAllocIconSize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocStandardColormap" XM_POSTFIX, gxm_XAllocStandardColormap, 0, 0, 0, H_XAllocStandardColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAllocWMHints" XM_POSTFIX, gxm_XAllocWMHints, 0, 0, 0, H_XAllocWMHints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XClipBox" XM_POSTFIX, gxm_XClipBox, 1, 0, 0, H_XClipBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateRegion" XM_POSTFIX, gxm_XCreateRegion, 0, 0, 0, H_XCreateRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDefaultString" XM_POSTFIX, gxm_XDefaultString, 0, 0, 0, H_XDefaultString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDeleteContext" XM_POSTFIX, gxm_XDeleteContext, 3, 0, 0, H_XDeleteContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDestroyRegion" XM_POSTFIX, gxm_XDestroyRegion, 1, 0, 0, H_XDestroyRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEmptyRegion" XM_POSTFIX, gxm_XEmptyRegion, 1, 0, 0, H_XEmptyRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEqualRegion" XM_POSTFIX, gxm_XEqualRegion, 2, 0, 0, H_XEqualRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFindContext" XM_POSTFIX, gxm_XFindContext, 3, 0, 0, H_XFindContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetIconSizes" XM_POSTFIX, gxm_XGetIconSizes, 2, 0, 0, H_XGetIconSizes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetRGBColormaps" XM_POSTFIX, gxm_XGetRGBColormaps, 3, 0, 0, H_XGetRGBColormaps);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetStandardColormap" XM_POSTFIX, gxm_XGetStandardColormap, 3, 0, 0, H_XGetStandardColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetVisualInfo" XM_POSTFIX, gxm_XGetVisualInfo, 3, 0, 0, H_XGetVisualInfo);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetWMHints" XM_POSTFIX, gxm_XGetWMHints, 2, 0, 0, H_XGetWMHints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XIntersectRegion" XM_POSTFIX, gxm_XIntersectRegion, 3, 0, 0, H_XIntersectRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConvertCase" XM_POSTFIX, gxm_XConvertCase, 1, 0, 0, H_XConvertCase);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XLookupString" XM_POSTFIX, gxm_XLookupString, 1, 0, 0, H_XLookupString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMatchVisualInfo" XM_POSTFIX, gxm_XMatchVisualInfo, 4, 0, 0, H_XMatchVisualInfo);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XOffsetRegion" XM_POSTFIX, gxm_XOffsetRegion, 3, 0, 0, H_XOffsetRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPointInRegion" XM_POSTFIX, gxm_XPointInRegion, 3, 0, 0, H_XPointInRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPolygonRegion" XM_POSTFIX, gxm_XPolygonRegion, 3, 0, 0, H_XPolygonRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRectInRegion" XM_POSTFIX, gxm_XRectInRegion, 5, 0, 0, H_XRectInRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSaveContext" XM_POSTFIX, gxm_XSaveContext, 4, 0, 0, H_XSaveContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUniqueContext" XM_POSTFIX, gxm_XUniqueContext, 0, 0, 0, H_XUniqueContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetRGBColormaps" XM_POSTFIX, gxm_XSetRGBColormaps, 5, 0, 0, H_XSetRGBColormaps);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWMHints" XM_POSTFIX, gxm_XSetWMHints, 3, 0, 0, H_XSetWMHints);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetRegion" XM_POSTFIX, gxm_XSetRegion, 3, 0, 0, H_XSetRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetStandardColormap" XM_POSTFIX, gxm_XSetStandardColormap, 4, 0, 0, H_XSetStandardColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XShrinkRegion" XM_POSTFIX, gxm_XShrinkRegion, 3, 0, 0, H_XShrinkRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSubtractRegion" XM_POSTFIX, gxm_XSubtractRegion, 3, 0, 0, H_XSubtractRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnionRectWithRegion" XM_POSTFIX, gxm_XUnionRectWithRegion, 3, 0, 0, H_XUnionRectWithRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnionRegion" XM_POSTFIX, gxm_XUnionRegion, 3, 0, 0, H_XUnionRegion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XXorRegion" XM_POSTFIX, gxm_XXorRegion, 3, 0, 0, H_XXorRegion);

  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultScreen" XM_POSTFIX, gxm_DefaultScreen, 1, 0, 0, H_DefaultScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultRootWindow" XM_POSTFIX, gxm_DefaultRootWindow, 1, 0, 0, H_DefaultRootWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "QLength" XM_POSTFIX, gxm_QLength, 1, 0, 0, H_QLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ScreenCount" XM_POSTFIX, gxm_ScreenCount, 1, 0, 0, H_ScreenCount);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ServerVendor" XM_POSTFIX, gxm_ServerVendor, 1, 0, 0, H_ServerVendor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ProtocolVersion" XM_POSTFIX, gxm_ProtocolVersion, 1, 0, 0, H_ProtocolVersion);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ProtocolRevision" XM_POSTFIX, gxm_ProtocolRevision, 1, 0, 0, H_ProtocolRevision);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "VendorRelease" XM_POSTFIX, gxm_VendorRelease, 1, 0, 0, H_VendorRelease);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayString" XM_POSTFIX, gxm_DisplayString, 1, 0, 0, H_DisplayString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "BitmapUnit" XM_POSTFIX, gxm_BitmapUnit, 1, 0, 0, H_BitmapUnit);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "BitmapBitOrder" XM_POSTFIX, gxm_BitmapBitOrder, 1, 0, 0, H_BitmapBitOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "BitmapPad" XM_POSTFIX, gxm_BitmapPad, 1, 0, 0, H_BitmapPad);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ImageByteOrder" XM_POSTFIX, gxm_ImageByteOrder, 1, 0, 0, H_ImageByteOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "NextRequest" XM_POSTFIX, gxm_NextRequest, 1, 0, 0, H_NextRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "LastKnownRequestProcessed" XM_POSTFIX, gxm_LastKnownRequestProcessed, 1, 0, 0, H_LastKnownRequestProcessed);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultScreenOfDisplay" XM_POSTFIX, gxm_DefaultScreenOfDisplay, 1, 0, 0, H_DefaultScreenOfDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayOfScreen" XM_POSTFIX, gxm_DisplayOfScreen, 1, 0, 0, H_DisplayOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "RootWindowOfScreen" XM_POSTFIX, gxm_RootWindowOfScreen, 1, 0, 0, H_RootWindowOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "BlackPixelOfScreen" XM_POSTFIX, gxm_BlackPixelOfScreen, 1, 0, 0, H_BlackPixelOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "WhitePixelOfScreen" XM_POSTFIX, gxm_WhitePixelOfScreen, 1, 0, 0, H_WhitePixelOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultColormapOfScreen" XM_POSTFIX, gxm_DefaultColormapOfScreen, 1, 0, 0, H_DefaultColormapOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultDepthOfScreen" XM_POSTFIX, gxm_DefaultDepthOfScreen, 1, 0, 0, H_DefaultDepthOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultGCOfScreen" XM_POSTFIX, gxm_DefaultGCOfScreen, 1, 0, 0, H_DefaultGCOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultVisualOfScreen" XM_POSTFIX, gxm_DefaultVisualOfScreen, 1, 0, 0, H_DefaultVisualOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "WidthOfScreen" XM_POSTFIX, gxm_WidthOfScreen, 1, 0, 0, H_WidthOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "HeightOfScreen" XM_POSTFIX, gxm_HeightOfScreen, 1, 0, 0, H_HeightOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "WidthMMOfScreen" XM_POSTFIX, gxm_WidthMMOfScreen, 1, 0, 0, H_WidthMMOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "HeightMMOfScreen" XM_POSTFIX, gxm_HeightMMOfScreen, 1, 0, 0, H_HeightMMOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "PlanesOfScreen" XM_POSTFIX, gxm_PlanesOfScreen, 1, 0, 0, H_PlanesOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "CellsOfScreen" XM_POSTFIX, gxm_CellsOfScreen, 1, 0, 0, H_CellsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "MinCmapsOfScreen" XM_POSTFIX, gxm_MinCmapsOfScreen, 1, 0, 0, H_MinCmapsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "MaxCmapsOfScreen" XM_POSTFIX, gxm_MaxCmapsOfScreen, 1, 0, 0, H_MaxCmapsOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DoesSaveUnders" XM_POSTFIX, gxm_DoesSaveUnders, 1, 0, 0, H_DoesSaveUnders);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DoesBackingStore" XM_POSTFIX, gxm_DoesBackingStore, 1, 0, 0, H_DoesBackingStore);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "EventMaskOfScreen" XM_POSTFIX, gxm_EventMaskOfScreen, 1, 0, 0, H_EventMaskOfScreen);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "RootWindow" XM_POSTFIX, gxm_RootWindow, 2, 0, 0, H_RootWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultVisual" XM_POSTFIX, gxm_DefaultVisual, 2, 0, 0, H_DefaultVisual);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultGC" XM_POSTFIX, gxm_DefaultGC, 2, 0, 0, H_DefaultGC);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "BlackPixel" XM_POSTFIX, gxm_BlackPixel, 2, 0, 0, H_BlackPixel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "WhitePixel" XM_POSTFIX, gxm_WhitePixel, 2, 0, 0, H_WhitePixel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayWidth" XM_POSTFIX, gxm_DisplayWidth, 2, 0, 0, H_DisplayWidth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayHeight" XM_POSTFIX, gxm_DisplayHeight, 2, 0, 0, H_DisplayHeight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayWidthMM" XM_POSTFIX, gxm_DisplayWidthMM, 2, 0, 0, H_DisplayWidthMM);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayHeightMM" XM_POSTFIX, gxm_DisplayHeightMM, 2, 0, 0, H_DisplayHeightMM);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayPlanes" XM_POSTFIX, gxm_DisplayPlanes, 2, 0, 0, H_DisplayPlanes);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DisplayCells" XM_POSTFIX, gxm_DisplayCells, 2, 0, 0, H_DisplayCells);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultColormap" XM_POSTFIX, gxm_DefaultColormap, 2, 0, 0, H_DefaultColormap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "ScreenOfDisplay" XM_POSTFIX, gxm_ScreenOfDisplay, 2, 0, 0, H_ScreenOfDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "DefaultDepth" XM_POSTFIX, gxm_DefaultDepth, 2, 0, 0, H_DefaultDepth);

  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsKeypadKey" XM_POSTFIX, gxm_IsKeypadKey, 1, 0, 0, H_IsKeypadKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsPrivateKeypadKey" XM_POSTFIX, gxm_IsPrivateKeypadKey, 1, 0, 0, H_IsPrivateKeypadKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsCursorKey" XM_POSTFIX, gxm_IsCursorKey, 1, 0, 0, H_IsCursorKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsPFKey" XM_POSTFIX, gxm_IsPFKey, 1, 0, 0, H_IsPFKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsFunctionKey" XM_POSTFIX, gxm_IsFunctionKey, 1, 0, 0, H_IsFunctionKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsMiscFunctionKey" XM_POSTFIX, gxm_IsMiscFunctionKey, 1, 0, 0, H_IsMiscFunctionKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "IsModifierKey" XM_POSTFIX, gxm_IsModifierKey, 1, 0, 0, H_IsModifierKey);

#if HAVE_MOTIF
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateMessageBox" XM_POSTFIX, gxm_XmCreateMessageBox, 3, 1, 0, H_XmCreateMessageBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateMessageDialog" XM_POSTFIX, gxm_XmCreateMessageDialog, 3, 1, 0, H_XmCreateMessageDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateErrorDialog" XM_POSTFIX, gxm_XmCreateErrorDialog, 3, 1, 0, H_XmCreateErrorDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateInformationDialog" XM_POSTFIX, gxm_XmCreateInformationDialog, 3, 1, 0, H_XmCreateInformationDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateQuestionDialog" XM_POSTFIX, gxm_XmCreateQuestionDialog, 3, 1, 0, H_XmCreateQuestionDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateWarningDialog" XM_POSTFIX, gxm_XmCreateWarningDialog, 3, 1, 0, H_XmCreateWarningDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateWorkingDialog" XM_POSTFIX, gxm_XmCreateWorkingDialog, 3, 1, 0, H_XmCreateWorkingDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateTemplateDialog" XM_POSTFIX, gxm_XmCreateTemplateDialog, 3, 1, 0, H_XmCreateTemplateDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMessageBoxGetChild" XM_POSTFIX, gxm_XmMessageBoxGetChild, 2, 0, 0, H_XmMessageBoxGetChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateArrowButtonGadget" XM_POSTFIX, gxm_XmCreateArrowButtonGadget, 3, 1, 0, H_XmCreateArrowButtonGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateArrowButton" XM_POSTFIX, gxm_XmCreateArrowButton, 3, 1, 0, H_XmCreateArrowButton);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateNotebook" XM_POSTFIX, gxm_XmCreateNotebook, 3, 1, 0, H_XmCreateNotebook);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmNotebookGetPageInfo" XM_POSTFIX, gxm_XmNotebookGetPageInfo, 2, 0, 0, H_XmNotebookGetPageInfo);
#if HAVE_XP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPrintSetup" XM_POSTFIX, gxm_XmPrintSetup, 4, 1, 0, H_XmPrintSetup);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPrintToFile" XM_POSTFIX, gxm_XmPrintToFile, 4, 0, 0, H_XmPrintToFile);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPrintPopupPDM" XM_POSTFIX, gxm_XmPrintPopupPDM, 2, 0, 0, H_XmPrintPopupPDM);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRedisplayWidget" XM_POSTFIX, gxm_XmRedisplayWidget, 1, 0, 0, H_XmRedisplayWidget);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTransferSetParameters" XM_POSTFIX, gxm_XmTransferSetParameters, 5, 0, 0, H_XmTransferSetParameters);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTransferDone" XM_POSTFIX, gxm_XmTransferDone, 2, 0, 0, H_XmTransferDone);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTransferValue" XM_POSTFIX, gxm_XmTransferValue, 5, 0, 0, H_XmTransferValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTransferStartRequest" XM_POSTFIX, gxm_XmTransferStartRequest, 1, 0, 0, H_XmTransferStartRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTransferSendRequest" XM_POSTFIX, gxm_XmTransferSendRequest, 2, 0, 0, H_XmTransferSendRequest);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateComboBox" XM_POSTFIX, gxm_XmCreateComboBox, 3, 1, 0, H_XmCreateComboBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDropDownComboBox" XM_POSTFIX, gxm_XmCreateDropDownComboBox, 3, 1, 0, H_XmCreateDropDownComboBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDropDownList" XM_POSTFIX, gxm_XmCreateDropDownList, 3, 1, 0, H_XmCreateDropDownList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBoxAddItem" XM_POSTFIX, gxm_XmComboBoxAddItem, 4, 0, 0, H_XmComboBoxAddItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBoxDeletePos" XM_POSTFIX, gxm_XmComboBoxDeletePos, 2, 0, 0, H_XmComboBoxDeletePos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBoxSelectItem" XM_POSTFIX, gxm_XmComboBoxSelectItem, 2, 0, 0, H_XmComboBoxSelectItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBoxSetItem" XM_POSTFIX, gxm_XmComboBoxSetItem, 2, 0, 0, H_XmComboBoxSetItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBoxUpdate" XM_POSTFIX, gxm_XmComboBoxUpdate, 1, 0, 0, H_XmComboBoxUpdate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateContainer" XM_POSTFIX, gxm_XmCreateContainer, 3, 1, 0, H_XmCreateContainer);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerGetItemChildren" XM_POSTFIX, gxm_XmContainerGetItemChildren, 2, 0, 0, H_XmContainerGetItemChildren);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerRelayout" XM_POSTFIX, gxm_XmContainerRelayout, 1, 0, 0, H_XmContainerRelayout);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerReorder" XM_POSTFIX, gxm_XmContainerReorder, 3, 0, 0, H_XmContainerReorder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerCut" XM_POSTFIX, gxm_XmContainerCut, 2, 0, 0, H_XmContainerCut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerCopy" XM_POSTFIX, gxm_XmContainerCopy, 2, 0, 0, H_XmContainerCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerPaste" XM_POSTFIX, gxm_XmContainerPaste, 1, 0, 0, H_XmContainerPaste);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerCopyLink" XM_POSTFIX, gxm_XmContainerCopyLink, 2, 0, 0, H_XmContainerCopyLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainerPasteLink" XM_POSTFIX, gxm_XmContainerPasteLink, 1, 0, 0, H_XmContainerPasteLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSpinBox" XM_POSTFIX, gxm_XmCreateSpinBox, 3, 1, 0, H_XmCreateSpinBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSpinBoxValidatePosition" XM_POSTFIX, gxm_XmSpinBoxValidatePosition, 1, 0, 0, H_XmSpinBoxValidatePosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimpleSpinBox" XM_POSTFIX, gxm_XmCreateSimpleSpinBox, 3, 1, 0, H_XmCreateSimpleSpinBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSimpleSpinBoxAddItem" XM_POSTFIX, gxm_XmSimpleSpinBoxAddItem, 3, 0, 0, H_XmSimpleSpinBoxAddItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSimpleSpinBoxDeletePos" XM_POSTFIX, gxm_XmSimpleSpinBoxDeletePos, 2, 0, 0, H_XmSimpleSpinBoxDeletePos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSimpleSpinBoxSetItem" XM_POSTFIX, gxm_XmSimpleSpinBoxSetItem, 2, 0, 0, H_XmSimpleSpinBoxSetItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteRegistered" XM_POSTFIX, gxm_XmDropSiteRegistered, 1, 0, 0, H_XmDropSiteRegistered);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldCopyLink" XM_POSTFIX, gxm_XmTextFieldCopyLink, 2, 0, 0, H_XmTextFieldCopyLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldPasteLink" XM_POSTFIX, gxm_XmTextFieldPasteLink, 1, 0, 0, H_XmTextFieldPasteLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetCenterline" XM_POSTFIX, gxm_XmTextGetCenterline, 1, 0, 0, H_XmTextGetCenterline);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonGadgetSetValue" XM_POSTFIX, gxm_XmToggleButtonGadgetSetValue, 3, 0, 0, H_XmToggleButtonGadgetSetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateIconGadget" XM_POSTFIX, gxm_XmCreateIconGadget, 3, 1, 0, H_XmCreateIconGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateIconHeader" XM_POSTFIX, gxm_XmCreateIconHeader, 3, 1, 0, H_XmCreateIconHeader);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmObjectAtPoint" XM_POSTFIX, gxm_XmObjectAtPoint, 3, 0, 0, H_XmObjectAtPoint);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmConvertStringToUnits" XM_POSTFIX, gxm_XmConvertStringToUnits, 4, 0, 0, H_XmConvertStringToUnits);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateGrabShell" XM_POSTFIX, gxm_XmCreateGrabShell, 3, 1, 0, H_XmCreateGrabShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonSetValue" XM_POSTFIX, gxm_XmToggleButtonSetValue, 3, 0, 0, H_XmToggleButtonSetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextPasteLink" XM_POSTFIX, gxm_XmTextPasteLink, 1, 0, 0, H_XmTextPasteLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextCopyLink" XM_POSTFIX, gxm_XmTextCopyLink, 2, 0, 0, H_XmTextCopyLink);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScaleSetTicks" XM_POSTFIX, gxm_XmScaleSetTicks, 7, 0, 0, H_XmScaleSetTicks);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmInternAtom" XM_POSTFIX, gxm_XmInternAtom, 3, 0, 0, H_XmInternAtom);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetAtomName" XM_POSTFIX, gxm_XmGetAtomName, 2, 0, 0, H_XmGetAtomName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePanedWindow" XM_POSTFIX, gxm_XmCreatePanedWindow, 3, 1, 0, H_XmCreatePanedWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateBulletinBoard" XM_POSTFIX, gxm_XmCreateBulletinBoard, 3, 1, 0, H_XmCreateBulletinBoard);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateBulletinBoardDialog" XM_POSTFIX, gxm_XmCreateBulletinBoardDialog, 3, 1, 0, H_XmCreateBulletinBoardDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateCascadeButtonGadget" XM_POSTFIX, gxm_XmCreateCascadeButtonGadget, 3, 1, 0, H_XmCreateCascadeButtonGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCascadeButtonGadgetHighlight" XM_POSTFIX, gxm_XmCascadeButtonGadgetHighlight, 2, 0, 0, H_XmCascadeButtonGadgetHighlight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmAddProtocols" XM_POSTFIX, gxm_XmAddProtocols, 3, 1, 0, H_XmAddProtocols);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRemoveProtocols" XM_POSTFIX, gxm_XmRemoveProtocols, 3, 1, 0, H_XmRemoveProtocols);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmAddProtocolCallback" XM_POSTFIX, gxm_XmAddProtocolCallback, 5, 0, 0, H_XmAddProtocolCallback);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRemoveProtocolCallback" XM_POSTFIX, gxm_XmRemoveProtocolCallback, 5, 0, 0, H_XmRemoveProtocolCallback);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmActivateProtocol" XM_POSTFIX, gxm_XmActivateProtocol, 3, 0, 0, H_XmActivateProtocol);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDeactivateProtocol" XM_POSTFIX, gxm_XmDeactivateProtocol, 3, 0, 0, H_XmDeactivateProtocol);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSetProtocolHooks" XM_POSTFIX, gxm_XmSetProtocolHooks, 7, 0, 0, H_XmSetProtocolHooks);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateCascadeButton" XM_POSTFIX, gxm_XmCreateCascadeButton, 3, 1, 0, H_XmCreateCascadeButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCascadeButtonHighlight" XM_POSTFIX, gxm_XmCascadeButtonHighlight, 2, 0, 0, H_XmCascadeButtonHighlight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePushButtonGadget" XM_POSTFIX, gxm_XmCreatePushButtonGadget, 3, 1, 0, H_XmCreatePushButtonGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePushButton" XM_POSTFIX, gxm_XmCreatePushButton, 3, 1, 0, H_XmCreatePushButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateCommand" XM_POSTFIX, gxm_XmCreateCommand, 3, 1, 0, H_XmCreateCommand);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCommandGetChild" XM_POSTFIX, gxm_XmCommandGetChild, 2, 0, 0, H_XmCommandGetChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCommandSetValue" XM_POSTFIX, gxm_XmCommandSetValue, 2, 0, 0, H_XmCommandSetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCommandAppendValue" XM_POSTFIX, gxm_XmCommandAppendValue, 2, 0, 0, H_XmCommandAppendValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCommandError" XM_POSTFIX, gxm_XmCommandError, 2, 0, 0, H_XmCommandError);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateCommandDialog" XM_POSTFIX, gxm_XmCreateCommandDialog, 3, 1, 0, H_XmCreateCommandDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMenuPosition" XM_POSTFIX, gxm_XmMenuPosition, 2, 0, 0, H_XmMenuPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateRowColumn" XM_POSTFIX, gxm_XmCreateRowColumn, 3, 1, 0, H_XmCreateRowColumn);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateWorkArea" XM_POSTFIX, gxm_XmCreateWorkArea, 3, 1, 0, H_XmCreateWorkArea);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateRadioBox" XM_POSTFIX, gxm_XmCreateRadioBox, 3, 1, 0, H_XmCreateRadioBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateOptionMenu" XM_POSTFIX, gxm_XmCreateOptionMenu, 3, 1, 0, H_XmCreateOptionMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmOptionLabelGadget" XM_POSTFIX, gxm_XmOptionLabelGadget, 1, 0, 0, H_XmOptionLabelGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmOptionButtonGadget" XM_POSTFIX, gxm_XmOptionButtonGadget, 1, 0, 0, H_XmOptionButtonGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateMenuBar" XM_POSTFIX, gxm_XmCreateMenuBar, 3, 1, 0, H_XmCreateMenuBar);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePopupMenu" XM_POSTFIX, gxm_XmCreatePopupMenu, 3, 1, 0, H_XmCreatePopupMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePulldownMenu" XM_POSTFIX, gxm_XmCreatePulldownMenu, 3, 1, 0, H_XmCreatePulldownMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetPostedFromWidget" XM_POSTFIX, gxm_XmGetPostedFromWidget, 1, 0, 0, H_XmGetPostedFromWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetTearOffControl" XM_POSTFIX, gxm_XmGetTearOffControl, 1, 0, 0, H_XmGetTearOffControl);
#if (!XM_DISABLE_DEPRECATED)
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmAddToPostFromList" XM_POSTFIX, gxm_XmAddToPostFromList, 2, 0, 0, H_XmAddToPostFromList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRemoveFromPostFromList" XM_POSTFIX, gxm_XmRemoveFromPostFromList, 2, 0, 0, H_XmRemoveFromPostFromList);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScaleSetValue" XM_POSTFIX, gxm_XmScaleSetValue, 2, 0, 0, H_XmScaleSetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScaleGetValue" XM_POSTFIX, gxm_XmScaleGetValue, 1, 0, 0, H_XmScaleGetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateScale" XM_POSTFIX, gxm_XmCreateScale, 3, 1, 0, H_XmCreateScale);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardBeginCopy" XM_POSTFIX, gxm_XmClipboardBeginCopy, 5, 0, 0, H_XmClipboardBeginCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardStartCopy" XM_POSTFIX, gxm_XmClipboardStartCopy, 6, 0, 0, H_XmClipboardStartCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardCopy" XM_POSTFIX, gxm_XmClipboardCopy, 7, 0, 0, H_XmClipboardCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardEndCopy" XM_POSTFIX, gxm_XmClipboardEndCopy, 3, 0, 0, H_XmClipboardEndCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardCancelCopy" XM_POSTFIX, gxm_XmClipboardCancelCopy, 3, 0, 0, H_XmClipboardCancelCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardWithdrawFormat" XM_POSTFIX, gxm_XmClipboardWithdrawFormat, 3, 0, 0, H_XmClipboardWithdrawFormat);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardCopyByName" XM_POSTFIX, gxm_XmClipboardCopyByName, 6, 0, 0, H_XmClipboardCopyByName);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardUndoCopy" XM_POSTFIX, gxm_XmClipboardUndoCopy, 2, 0, 0, H_XmClipboardUndoCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardLock" XM_POSTFIX, gxm_XmClipboardLock, 2, 0, 0, H_XmClipboardLock);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardUnlock" XM_POSTFIX, gxm_XmClipboardUnlock, 3, 0, 0, H_XmClipboardUnlock);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardStartRetrieve" XM_POSTFIX, gxm_XmClipboardStartRetrieve, 3, 0, 0, H_XmClipboardStartRetrieve);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardEndRetrieve" XM_POSTFIX, gxm_XmClipboardEndRetrieve, 2, 0, 0, H_XmClipboardEndRetrieve);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardRetrieve" XM_POSTFIX, gxm_XmClipboardRetrieve, 4, 0, 0, H_XmClipboardRetrieve);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardInquireCount" XM_POSTFIX, gxm_XmClipboardInquireCount, 2, 0, 0, H_XmClipboardInquireCount);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardInquireFormat" XM_POSTFIX, gxm_XmClipboardInquireFormat, 4, 0, 0, H_XmClipboardInquireFormat);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardInquireLength" XM_POSTFIX, gxm_XmClipboardInquireLength, 3, 0, 0, H_XmClipboardInquireLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardInquirePendingItems" XM_POSTFIX, gxm_XmClipboardInquirePendingItems, 3, 0, 0, H_XmClipboardInquirePendingItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmClipboardRegisterFormat" XM_POSTFIX, gxm_XmClipboardRegisterFormat, 3, 0, 0, H_XmClipboardRegisterFormat);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetXmScreen" XM_POSTFIX, gxm_XmGetXmScreen, 1, 0, 0, H_XmGetXmScreen);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateScrollBar" XM_POSTFIX, gxm_XmCreateScrollBar, 3, 1, 0, H_XmCreateScrollBar);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrollBarGetValues" XM_POSTFIX, gxm_XmScrollBarGetValues, 1, 0, 0, H_XmScrollBarGetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrollBarSetValues" XM_POSTFIX, gxm_XmScrollBarSetValues, 6, 0, 0, H_XmScrollBarSetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDialogShell" XM_POSTFIX, gxm_XmCreateDialogShell, 3, 1, 0, H_XmCreateDialogShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateScrolledWindow" XM_POSTFIX, gxm_XmCreateScrolledWindow, 3, 1, 0, H_XmCreateScrolledWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrollVisible" XM_POSTFIX, gxm_XmScrollVisible, 4, 0, 0, H_XmScrollVisible);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetDragContext" XM_POSTFIX, gxm_XmGetDragContext, 2, 0, 0, H_XmGetDragContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetXmDisplay" XM_POSTFIX, gxm_XmGetXmDisplay, 1, 0, 0, H_XmGetXmDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSelectionBoxGetChild" XM_POSTFIX, gxm_XmSelectionBoxGetChild, 2, 0, 0, H_XmSelectionBoxGetChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSelectionBox" XM_POSTFIX, gxm_XmCreateSelectionBox, 3, 1, 0, H_XmCreateSelectionBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSelectionDialog" XM_POSTFIX, gxm_XmCreateSelectionDialog, 3, 1, 0, H_XmCreateSelectionDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreatePromptDialog" XM_POSTFIX, gxm_XmCreatePromptDialog, 3, 1, 0, H_XmCreatePromptDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDragStart" XM_POSTFIX, gxm_XmDragStart, 3, 1, 0, H_XmDragStart);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDragCancel" XM_POSTFIX, gxm_XmDragCancel, 1, 0, 0, H_XmDragCancel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTargetsAreCompatible" XM_POSTFIX, gxm_XmTargetsAreCompatible, 5, 0, 0, H_XmTargetsAreCompatible);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSeparatorGadget" XM_POSTFIX, gxm_XmCreateSeparatorGadget, 3, 1, 0, H_XmCreateSeparatorGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDragIcon" XM_POSTFIX, gxm_XmCreateDragIcon, 3, 1, 0, H_XmCreateDragIcon);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSeparator" XM_POSTFIX, gxm_XmCreateSeparator, 3, 1, 0, H_XmCreateSeparator);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDrawingArea" XM_POSTFIX, gxm_XmCreateDrawingArea, 3, 1, 0, H_XmCreateDrawingArea);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateDrawnButton" XM_POSTFIX, gxm_XmCreateDrawnButton, 3, 1, 0, H_XmCreateDrawnButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteRegister" XM_POSTFIX, gxm_XmDropSiteRegister, 2, 1, 0, H_XmDropSiteRegister);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteUnregister" XM_POSTFIX, gxm_XmDropSiteUnregister, 1, 0, 0, H_XmDropSiteUnregister);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteStartUpdate" XM_POSTFIX, gxm_XmDropSiteStartUpdate, 1, 0, 0, H_XmDropSiteStartUpdate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteUpdate" XM_POSTFIX, gxm_XmDropSiteUpdate, 2, 1, 0, H_XmDropSiteUpdate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteEndUpdate" XM_POSTFIX, gxm_XmDropSiteEndUpdate, 1, 0, 0, H_XmDropSiteEndUpdate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteRetrieve" XM_POSTFIX, gxm_XmDropSiteRetrieve, 2, 1, 0, H_XmDropSiteRetrieve);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteQueryStackingOrder" XM_POSTFIX, gxm_XmDropSiteQueryStackingOrder, 1, 0, 0, H_XmDropSiteQueryStackingOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteConfigureStackingOrder" XM_POSTFIX, gxm_XmDropSiteConfigureStackingOrder, 3, 0, 0, H_XmDropSiteConfigureStackingOrder);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropTransferStart" XM_POSTFIX, gxm_XmDropTransferStart, 2, 1, 0, H_XmDropTransferStart);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropTransferAdd" XM_POSTFIX, gxm_XmDropTransferAdd, 2, 0, 0, H_XmDropTransferAdd);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetString" XM_POSTFIX, gxm_XmTextFieldGetString, 1, 0, 0, H_XmTextFieldGetString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetSubstring" XM_POSTFIX, gxm_XmTextFieldGetSubstring, 3, 0, 0, H_XmTextFieldGetSubstring);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetLastPosition" XM_POSTFIX, gxm_XmTextFieldGetLastPosition, 1, 0, 0, H_XmTextFieldGetLastPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetString" XM_POSTFIX, gxm_XmTextFieldSetString, 2, 0, 0, H_XmTextFieldSetString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldReplace" XM_POSTFIX, gxm_XmTextFieldReplace, 4, 0, 0, H_XmTextFieldReplace);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldInsert" XM_POSTFIX, gxm_XmTextFieldInsert, 3, 0, 0, H_XmTextFieldInsert);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetAddMode" XM_POSTFIX, gxm_XmTextFieldSetAddMode, 2, 0, 0, H_XmTextFieldSetAddMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetAddMode" XM_POSTFIX, gxm_XmTextFieldGetAddMode, 1, 0, 0, H_XmTextFieldGetAddMode);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetEditable" XM_POSTFIX, gxm_XmTextFieldGetEditable, 1, 0, 0, H_XmTextFieldGetEditable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetEditable" XM_POSTFIX, gxm_XmTextFieldSetEditable, 2, 0, 0, H_XmTextFieldSetEditable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetMaxLength" XM_POSTFIX, gxm_XmTextFieldGetMaxLength, 1, 0, 0, H_XmTextFieldGetMaxLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetMaxLength" XM_POSTFIX, gxm_XmTextFieldSetMaxLength, 2, 0, 0, H_XmTextFieldSetMaxLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetCursorPosition" XM_POSTFIX, gxm_XmTextFieldGetCursorPosition, 1, 0, 0, H_XmTextFieldGetCursorPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetInsertionPosition" XM_POSTFIX, gxm_XmTextFieldGetInsertionPosition, 1, 0, 0, H_XmTextFieldGetInsertionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetCursorPosition" XM_POSTFIX, gxm_XmTextFieldSetCursorPosition, 2, 0, 0, H_XmTextFieldSetCursorPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetInsertionPosition" XM_POSTFIX, gxm_XmTextFieldSetInsertionPosition, 2, 0, 0, H_XmTextFieldSetInsertionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetSelectionPosition" XM_POSTFIX, gxm_XmTextFieldGetSelectionPosition, 1, 0, 0, H_XmTextFieldGetSelectionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetSelection" XM_POSTFIX, gxm_XmTextFieldGetSelection, 1, 0, 0, H_XmTextFieldGetSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldRemove" XM_POSTFIX, gxm_XmTextFieldRemove, 1, 0, 0, H_XmTextFieldRemove);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldCopy" XM_POSTFIX, gxm_XmTextFieldCopy, 2, 0, 0, H_XmTextFieldCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldCut" XM_POSTFIX, gxm_XmTextFieldCut, 2, 0, 0, H_XmTextFieldCut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldPaste" XM_POSTFIX, gxm_XmTextFieldPaste, 1, 0, 0, H_XmTextFieldPaste);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldClearSelection" XM_POSTFIX, gxm_XmTextFieldClearSelection, 2, 0, 0, H_XmTextFieldClearSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetSelection" XM_POSTFIX, gxm_XmTextFieldSetSelection, 4, 0, 0, H_XmTextFieldSetSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldXYToPos" XM_POSTFIX, gxm_XmTextFieldXYToPos, 3, 0, 0, H_XmTextFieldXYToPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldPosToXY" XM_POSTFIX, gxm_XmTextFieldPosToXY, 2, 0, 0, H_XmTextFieldPosToXY);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldShowPosition" XM_POSTFIX, gxm_XmTextFieldShowPosition, 2, 0, 0, H_XmTextFieldShowPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldSetHighlight" XM_POSTFIX, gxm_XmTextFieldSetHighlight, 4, 0, 0, H_XmTextFieldSetHighlight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFieldGetBaseline" XM_POSTFIX, gxm_XmTextFieldGetBaseline, 1, 0, 0, H_XmTextFieldGetBaseline);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateTextField" XM_POSTFIX, gxm_XmCreateTextField, 3, 1, 0, H_XmCreateTextField);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFileSelectionBoxGetChild" XM_POSTFIX, gxm_XmFileSelectionBoxGetChild, 2, 0, 0, H_XmFileSelectionBoxGetChild);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFileSelectionDoSearch" XM_POSTFIX, gxm_XmFileSelectionDoSearch, 2, 0, 0, H_XmFileSelectionDoSearch);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateFileSelectionBox" XM_POSTFIX, gxm_XmCreateFileSelectionBox, 3, 1, 0, H_XmCreateFileSelectionBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateFileSelectionDialog" XM_POSTFIX, gxm_XmCreateFileSelectionDialog, 3, 1, 0, H_XmCreateFileSelectionDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetHighlight" XM_POSTFIX, gxm_XmTextSetHighlight, 4, 0, 0, H_XmTextSetHighlight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateScrolledText" XM_POSTFIX, gxm_XmCreateScrolledText, 3, 1, 0, H_XmCreateScrolledText);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateText" XM_POSTFIX, gxm_XmCreateText, 3, 1, 0, H_XmCreateText);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetSubstring" XM_POSTFIX, gxm_XmTextGetSubstring, 3, 0, 0, H_XmTextGetSubstring);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetString" XM_POSTFIX, gxm_XmTextGetString, 1, 0, 0, H_XmTextGetString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetLastPosition" XM_POSTFIX, gxm_XmTextGetLastPosition, 1, 0, 0, H_XmTextGetLastPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetString" XM_POSTFIX, gxm_XmTextSetString, 2, 0, 0, H_XmTextSetString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextReplace" XM_POSTFIX, gxm_XmTextReplace, 4, 0, 0, H_XmTextReplace);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextInsert" XM_POSTFIX, gxm_XmTextInsert, 3, 0, 0, H_XmTextInsert);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetAddMode" XM_POSTFIX, gxm_XmTextSetAddMode, 2, 0, 0, H_XmTextSetAddMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetAddMode" XM_POSTFIX, gxm_XmTextGetAddMode, 1, 0, 0, H_XmTextGetAddMode);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetEditable" XM_POSTFIX, gxm_XmTextGetEditable, 1, 0, 0, H_XmTextGetEditable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetEditable" XM_POSTFIX, gxm_XmTextSetEditable, 2, 0, 0, H_XmTextSetEditable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetMaxLength" XM_POSTFIX, gxm_XmTextGetMaxLength, 1, 0, 0, H_XmTextGetMaxLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetMaxLength" XM_POSTFIX, gxm_XmTextSetMaxLength, 2, 0, 0, H_XmTextSetMaxLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetTopCharacter" XM_POSTFIX, gxm_XmTextGetTopCharacter, 1, 0, 0, H_XmTextGetTopCharacter);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetTopCharacter" XM_POSTFIX, gxm_XmTextSetTopCharacter, 2, 0, 0, H_XmTextSetTopCharacter);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetCursorPosition" XM_POSTFIX, gxm_XmTextGetCursorPosition, 1, 0, 0, H_XmTextGetCursorPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetInsertionPosition" XM_POSTFIX, gxm_XmTextGetInsertionPosition, 1, 0, 0, H_XmTextGetInsertionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetInsertionPosition" XM_POSTFIX, gxm_XmTextSetInsertionPosition, 2, 0, 0, H_XmTextSetInsertionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetCursorPosition" XM_POSTFIX, gxm_XmTextSetCursorPosition, 2, 0, 0, H_XmTextSetCursorPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextRemove" XM_POSTFIX, gxm_XmTextRemove, 1, 0, 0, H_XmTextRemove);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextCopy" XM_POSTFIX, gxm_XmTextCopy, 2, 0, 0, H_XmTextCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextCut" XM_POSTFIX, gxm_XmTextCut, 2, 0, 0, H_XmTextCut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextPaste" XM_POSTFIX, gxm_XmTextPaste, 1, 0, 0, H_XmTextPaste);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetSelection" XM_POSTFIX, gxm_XmTextGetSelection, 1, 0, 0, H_XmTextGetSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetSelection" XM_POSTFIX, gxm_XmTextSetSelection, 4, 0, 0, H_XmTextSetSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextClearSelection" XM_POSTFIX, gxm_XmTextClearSelection, 2, 0, 0, H_XmTextClearSelection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetSelectionPosition" XM_POSTFIX, gxm_XmTextGetSelectionPosition, 1, 0, 0, H_XmTextGetSelectionPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextXYToPos" XM_POSTFIX, gxm_XmTextXYToPos, 3, 0, 0, H_XmTextXYToPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextPosToXY" XM_POSTFIX, gxm_XmTextPosToXY, 2, 0, 0, H_XmTextPosToXY);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetSource" XM_POSTFIX, gxm_XmTextGetSource, 1, 0, 0, H_XmTextGetSource);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSetSource" XM_POSTFIX, gxm_XmTextSetSource, 4, 0, 0, H_XmTextSetSource);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextShowPosition" XM_POSTFIX, gxm_XmTextShowPosition, 2, 0, 0, H_XmTextShowPosition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextScroll" XM_POSTFIX, gxm_XmTextScroll, 2, 0, 0, H_XmTextScroll);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextGetBaseline" XM_POSTFIX, gxm_XmTextGetBaseline, 1, 0, 0, H_XmTextGetBaseline);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextDisableRedisplay" XM_POSTFIX, gxm_XmTextDisableRedisplay, 1, 0, 0, H_XmTextDisableRedisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextEnableRedisplay" XM_POSTFIX, gxm_XmTextEnableRedisplay, 1, 0, 0, H_XmTextEnableRedisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextFindString" XM_POSTFIX, gxm_XmTextFindString, 4, 0, 0, H_XmTextFindString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateForm" XM_POSTFIX, gxm_XmCreateForm, 3, 1, 0, H_XmCreateForm);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateFormDialog" XM_POSTFIX, gxm_XmCreateFormDialog, 3, 1, 0, H_XmCreateFormDialog);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateFrame" XM_POSTFIX, gxm_XmCreateFrame, 3, 1, 0, H_XmCreateFrame);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonGadgetGetState" XM_POSTFIX, gxm_XmToggleButtonGadgetGetState, 1, 0, 0, H_XmToggleButtonGadgetGetState);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonGadgetSetState" XM_POSTFIX, gxm_XmToggleButtonGadgetSetState, 3, 0, 0, H_XmToggleButtonGadgetSetState);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateToggleButtonGadget" XM_POSTFIX, gxm_XmCreateToggleButtonGadget, 3, 1, 0, H_XmCreateToggleButtonGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonGetState" XM_POSTFIX, gxm_XmToggleButtonGetState, 1, 0, 0, H_XmToggleButtonGetState);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonSetState" XM_POSTFIX, gxm_XmToggleButtonSetState, 3, 0, 0, H_XmToggleButtonSetState);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateToggleButton" XM_POSTFIX, gxm_XmCreateToggleButton, 3, 1, 0, H_XmCreateToggleButton);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateLabelGadget" XM_POSTFIX, gxm_XmCreateLabelGadget, 3, 1, 0, H_XmCreateLabelGadget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateLabel" XM_POSTFIX, gxm_XmCreateLabel, 3, 1, 0, H_XmCreateLabel);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsMotifWMRunning" XM_POSTFIX, gxm_XmIsMotifWMRunning, 1, 0, 0, H_XmIsMotifWMRunning);
#if MOTIF_2_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToolTipGetLabel" XM_POSTFIX, gxm_XmToolTipGetLabel, 1, 0, 0, H_XmToolTipGetLabel);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListAddItem" XM_POSTFIX, gxm_XmListAddItem, 3, 0, 0, H_XmListAddItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListAddItems" XM_POSTFIX, gxm_XmListAddItems, 4, 0, 0, H_XmListAddItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListAddItemsUnselected" XM_POSTFIX, gxm_XmListAddItemsUnselected, 4, 0, 0, H_XmListAddItemsUnselected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListAddItemUnselected" XM_POSTFIX, gxm_XmListAddItemUnselected, 3, 0, 0, H_XmListAddItemUnselected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeleteItem" XM_POSTFIX, gxm_XmListDeleteItem, 2, 0, 0, H_XmListDeleteItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeleteItems" XM_POSTFIX, gxm_XmListDeleteItems, 2, 1, 0, H_XmListDeleteItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeletePositions" XM_POSTFIX, gxm_XmListDeletePositions, 2, 1, 0, H_XmListDeletePositions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeletePos" XM_POSTFIX, gxm_XmListDeletePos, 2, 0, 0, H_XmListDeletePos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeleteItemsPos" XM_POSTFIX, gxm_XmListDeleteItemsPos, 3, 0, 0, H_XmListDeleteItemsPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeleteAllItems" XM_POSTFIX, gxm_XmListDeleteAllItems, 1, 0, 0, H_XmListDeleteAllItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListReplaceItems" XM_POSTFIX, gxm_XmListReplaceItems, 4, 0, 0, H_XmListReplaceItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListReplaceItemsPos" XM_POSTFIX, gxm_XmListReplaceItemsPos, 4, 0, 0, H_XmListReplaceItemsPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListReplaceItemsUnselected" XM_POSTFIX, gxm_XmListReplaceItemsUnselected, 4, 0, 0, H_XmListReplaceItemsUnselected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListReplaceItemsPosUnselected" XM_POSTFIX, gxm_XmListReplaceItemsPosUnselected, 4, 0, 0, H_XmListReplaceItemsPosUnselected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListReplacePositions" XM_POSTFIX, gxm_XmListReplacePositions, 3, 1, 0, H_XmListReplacePositions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSelectItem" XM_POSTFIX, gxm_XmListSelectItem, 3, 0, 0, H_XmListSelectItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSelectPos" XM_POSTFIX, gxm_XmListSelectPos, 3, 0, 0, H_XmListSelectPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeselectItem" XM_POSTFIX, gxm_XmListDeselectItem, 2, 0, 0, H_XmListDeselectItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeselectPos" XM_POSTFIX, gxm_XmListDeselectPos, 2, 0, 0, H_XmListDeselectPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListDeselectAllItems" XM_POSTFIX, gxm_XmListDeselectAllItems, 1, 0, 0, H_XmListDeselectAllItems);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetPos" XM_POSTFIX, gxm_XmListSetPos, 2, 0, 0, H_XmListSetPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetBottomPos" XM_POSTFIX, gxm_XmListSetBottomPos, 2, 0, 0, H_XmListSetBottomPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetItem" XM_POSTFIX, gxm_XmListSetItem, 2, 0, 0, H_XmListSetItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetBottomItem" XM_POSTFIX, gxm_XmListSetBottomItem, 2, 0, 0, H_XmListSetBottomItem);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetAddMode" XM_POSTFIX, gxm_XmListSetAddMode, 2, 0, 0, H_XmListSetAddMode);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListItemExists" XM_POSTFIX, gxm_XmListItemExists, 2, 0, 0, H_XmListItemExists);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListItemPos" XM_POSTFIX, gxm_XmListItemPos, 2, 0, 0, H_XmListItemPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListGetKbdItemPos" XM_POSTFIX, gxm_XmListGetKbdItemPos, 1, 0, 0, H_XmListGetKbdItemPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetKbdItemPos" XM_POSTFIX, gxm_XmListSetKbdItemPos, 2, 0, 0, H_XmListSetKbdItemPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListYToPos" XM_POSTFIX, gxm_XmListYToPos, 2, 0, 0, H_XmListYToPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListPosToBounds" XM_POSTFIX, gxm_XmListPosToBounds, 2, 0, 0, H_XmListPosToBounds);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListGetMatchPos" XM_POSTFIX, gxm_XmListGetMatchPos, 2, 0, 0, H_XmListGetMatchPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListSetHorizPos" XM_POSTFIX, gxm_XmListSetHorizPos, 2, 0, 0, H_XmListSetHorizPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListUpdateSelectedList" XM_POSTFIX, gxm_XmListUpdateSelectedList, 1, 0, 0, H_XmListUpdateSelectedList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListPosSelected" XM_POSTFIX, gxm_XmListPosSelected, 2, 0, 0, H_XmListPosSelected);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateList" XM_POSTFIX, gxm_XmCreateList, 3, 1, 0, H_XmCreateList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateScrolledList" XM_POSTFIX, gxm_XmCreateScrolledList, 3, 1, 0, H_XmCreateScrolledList);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTranslateKey" XM_POSTFIX, gxm_XmTranslateKey, 3, 0, 0, H_XmTranslateKey);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateMainWindow" XM_POSTFIX, gxm_XmCreateMainWindow, 3, 1, 0, H_XmCreateMainWindow);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmInstallImage" XM_POSTFIX, gxm_XmInstallImage, 2, 0, 0, H_XmInstallImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmUninstallImage" XM_POSTFIX, gxm_XmUninstallImage, 1, 0, 0, H_XmUninstallImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetPixmap" XM_POSTFIX, gxm_XmGetPixmap, 4, 0, 0, H_XmGetPixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetPixmapByDepth" XM_POSTFIX, gxm_XmGetPixmapByDepth, 5, 0, 0, H_XmGetPixmapByDepth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDestroyPixmap" XM_POSTFIX, gxm_XmDestroyPixmap, 2, 0, 0, H_XmDestroyPixmap);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmUpdateDisplay" XM_POSTFIX, gxm_XmUpdateDisplay, 1, 0, 0, H_XmUpdateDisplay);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmWidgetGetBaselines" XM_POSTFIX, gxm_XmWidgetGetBaselines, 1, 0, 0, H_XmWidgetGetBaselines);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmWidgetGetDisplayRect" XM_POSTFIX, gxm_XmWidgetGetDisplayRect, 1, 0, 0, H_XmWidgetGetDisplayRect);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRegisterSegmentEncoding" XM_POSTFIX, gxm_XmRegisterSegmentEncoding, 2, 0, 0, H_XmRegisterSegmentEncoding);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMapSegmentEncoding" XM_POSTFIX, gxm_XmMapSegmentEncoding, 1, 0, 0, H_XmMapSegmentEncoding);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCvtCTToXmString" XM_POSTFIX, gxm_XmCvtCTToXmString, 1, 0, 0, H_XmCvtCTToXmString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCvtXmStringToCT" XM_POSTFIX, gxm_XmCvtXmStringToCT, 1, 0, 0, H_XmCvtXmStringToCT);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmConvertUnits" XM_POSTFIX, gxm_XmConvertUnits, 5, 0, 0, H_XmConvertUnits);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimpleMenuBar" XM_POSTFIX, gxm_XmCreateSimpleMenuBar, 3, 1, 0, H_XmCreateSimpleMenuBar);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimplePopupMenu" XM_POSTFIX, gxm_XmCreateSimplePopupMenu, 3, 1, 0, H_XmCreateSimplePopupMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimplePulldownMenu" XM_POSTFIX, gxm_XmCreateSimplePulldownMenu, 3, 1, 0, H_XmCreateSimplePulldownMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimpleOptionMenu" XM_POSTFIX, gxm_XmCreateSimpleOptionMenu, 3, 1, 0, H_XmCreateSimpleOptionMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimpleRadioBox" XM_POSTFIX, gxm_XmCreateSimpleRadioBox, 3, 1, 0, H_XmCreateSimpleRadioBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateSimpleCheckBox" XM_POSTFIX, gxm_XmCreateSimpleCheckBox, 3, 1, 0, H_XmCreateSimpleCheckBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimpleMenuBar" XM_POSTFIX, gxm_XmVaCreateSimpleMenuBar, 3, 0, 0, H_XmVaCreateSimpleMenuBar);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimplePopupMenu" XM_POSTFIX, gxm_XmVaCreateSimplePopupMenu, 4, 0, 0, H_XmVaCreateSimplePopupMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimplePulldownMenu" XM_POSTFIX, gxm_XmVaCreateSimplePulldownMenu, 5, 0, 0, H_XmVaCreateSimplePulldownMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimpleOptionMenu" XM_POSTFIX, gxm_XmVaCreateSimpleOptionMenu, 7, 0, 0, H_XmVaCreateSimpleOptionMenu);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimpleRadioBox" XM_POSTFIX, gxm_XmVaCreateSimpleRadioBox, 5, 0, 0, H_XmVaCreateSimpleRadioBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVaCreateSimpleCheckBox" XM_POSTFIX, gxm_XmVaCreateSimpleCheckBox, 4, 0, 0, H_XmVaCreateSimpleCheckBox);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTrackingEvent" XM_POSTFIX, gxm_XmTrackingEvent, 3, 0, 0, H_XmTrackingEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSetColorCalculation" XM_POSTFIX, gxm_XmSetColorCalculation, 1, 0, 0, H_XmSetColorCalculation);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetColorCalculation" XM_POSTFIX, gxm_XmGetColorCalculation, 0, 0, 0, H_XmGetColorCalculation);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetColors" XM_POSTFIX, gxm_XmGetColors, 3, 0, 0, H_XmGetColors);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmChangeColor" XM_POSTFIX, gxm_XmChangeColor, 2, 0, 0, H_XmChangeColor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCreate" XM_POSTFIX, gxm_XmStringCreate, 2, 0, 0, H_XmStringCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCreateLocalized" XM_POSTFIX, gxm_XmStringCreateLocalized, 1, 0, 0, H_XmStringCreateLocalized);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringDirectionCreate" XM_POSTFIX, gxm_XmStringDirectionCreate, 1, 0, 0, H_XmStringDirectionCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringSeparatorCreate" XM_POSTFIX, gxm_XmStringSeparatorCreate, 0, 0, 0, H_XmStringSeparatorCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringInitContext" XM_POSTFIX, gxm_XmStringInitContext, 1, 0, 0, H_XmStringInitContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringFreeContext" XM_POSTFIX, gxm_XmStringFreeContext, 1, 0, 0, H_XmStringFreeContext);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringConcatAndFree" XM_POSTFIX, gxm_XmStringConcatAndFree, 2, 0, 0, H_XmStringConcatAndFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringIsVoid" XM_POSTFIX, gxm_XmStringIsVoid, 1, 0, 0, H_XmStringIsVoid);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringPeekNextTriple" XM_POSTFIX, gxm_XmStringPeekNextTriple, 1, 0, 0, H_XmStringPeekNextTriple);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringGetNextTriple" XM_POSTFIX, gxm_XmStringGetNextTriple, 1, 0, 0, H_XmStringGetNextTriple);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringComponentCreate" XM_POSTFIX, gxm_XmStringComponentCreate, 3, 0, 0, H_XmStringComponentCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringUnparse" XM_POSTFIX, gxm_XmStringUnparse, 7, 0, 0, H_XmStringUnparse);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringParseText" XM_POSTFIX, gxm_XmStringParseText, 7, 0, 0, H_XmStringParseText);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringToXmStringTable" XM_POSTFIX, gxm_XmStringToXmStringTable, 2, 0, 0, H_XmStringToXmStringTable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringTableToXmString" XM_POSTFIX, gxm_XmStringTableToXmString, 3, 0, 0, H_XmStringTableToXmString);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringTableUnparse" XM_POSTFIX, gxm_XmStringTableUnparse, 8, 0, 0, H_XmStringTableUnparse);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringTableParseStringArray" XM_POSTFIX, gxm_XmStringTableParseStringArray, 7, 0, 0, H_XmStringTableParseStringArray);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDirectionToStringDirection" XM_POSTFIX, gxm_XmDirectionToStringDirection, 1, 0, 0, H_XmDirectionToStringDirection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringDirectionToDirection" XM_POSTFIX, gxm_XmStringDirectionToDirection, 1, 0, 0, H_XmStringDirectionToDirection);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringGenerate" XM_POSTFIX, gxm_XmStringGenerate, 4, 0, 0, H_XmStringGenerate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringPutRendition" XM_POSTFIX, gxm_XmStringPutRendition, 2, 0, 0, H_XmStringPutRendition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseMappingCreate" XM_POSTFIX, gxm_XmParseMappingCreate, 1, 1, 0, H_XmParseMappingCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseMappingSetValues" XM_POSTFIX, gxm_XmParseMappingSetValues, 2, 1, 0, H_XmParseMappingSetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseMappingGetValues" XM_POSTFIX, gxm_XmParseMappingGetValues, 2, 1, 0, H_XmParseMappingGetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseMappingFree" XM_POSTFIX, gxm_XmParseMappingFree, 1, 0, 0, H_XmParseMappingFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseTableFree" XM_POSTFIX, gxm_XmParseTableFree, 1, 1, 0, H_XmParseTableFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringTableProposeTablist" XM_POSTFIX, gxm_XmStringTableProposeTablist, 5, 0, 0, H_XmStringTableProposeTablist);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabSetValue" XM_POSTFIX, gxm_XmTabSetValue, 2, 0, 0, H_XmTabSetValue);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabGetValues" XM_POSTFIX, gxm_XmTabGetValues, 1, 0, 0, H_XmTabGetValues);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabFree" XM_POSTFIX, gxm_XmTabFree, 1, 0, 0, H_XmTabFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListFree" XM_POSTFIX, gxm_XmTabListFree, 1, 0, 0, H_XmTabListFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabCreate" XM_POSTFIX, gxm_XmTabCreate, 5, 0, 0, H_XmTabCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListTabCount" XM_POSTFIX, gxm_XmTabListTabCount, 1, 0, 0, H_XmTabListTabCount);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListRemoveTabs" XM_POSTFIX, gxm_XmTabListRemoveTabs, 2, 1, 0, H_XmTabListRemoveTabs);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListReplacePositions" XM_POSTFIX, gxm_XmTabListReplacePositions, 3, 1, 0, H_XmTabListReplacePositions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListGetTab" XM_POSTFIX, gxm_XmTabListGetTab, 2, 0, 0, H_XmTabListGetTab);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListCopy" XM_POSTFIX, gxm_XmTabListCopy, 3, 0, 0, H_XmTabListCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabListInsertTabs" XM_POSTFIX, gxm_XmTabListInsertTabs, 4, 0, 0, H_XmTabListInsertTabs);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableCvtFromProp" XM_POSTFIX, gxm_XmRenderTableCvtFromProp, 3, 0, 0, H_XmRenderTableCvtFromProp);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableCvtToProp" XM_POSTFIX, gxm_XmRenderTableCvtToProp, 2, 0, 0, H_XmRenderTableCvtToProp);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenditionUpdate" XM_POSTFIX, gxm_XmRenditionUpdate, 2, 1, 0, H_XmRenditionUpdate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenditionRetrieve" XM_POSTFIX, gxm_XmRenditionRetrieve, 2, 1, 0, H_XmRenditionRetrieve);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenditionFree" XM_POSTFIX, gxm_XmRenditionFree, 1, 0, 0, H_XmRenditionFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenditionCreate" XM_POSTFIX, gxm_XmRenditionCreate, 3, 1, 0, H_XmRenditionCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableGetRenditions" XM_POSTFIX, gxm_XmRenderTableGetRenditions, 0, 3, 0, H_XmRenderTableGetRenditions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableGetRendition" XM_POSTFIX, gxm_XmRenderTableGetRendition, 2, 0, 0, H_XmRenderTableGetRendition);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableGetTags" XM_POSTFIX, gxm_XmRenderTableGetTags, 1, 0, 0, H_XmRenderTableGetTags);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableFree" XM_POSTFIX, gxm_XmRenderTableFree, 1, 0, 0, H_XmRenderTableFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableCopy" XM_POSTFIX, gxm_XmRenderTableCopy, 0, 3, 0, H_XmRenderTableCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableRemoveRenditions" XM_POSTFIX, gxm_XmRenderTableRemoveRenditions, 0, 3, 0, H_XmRenderTableRemoveRenditions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTableAddRenditions" XM_POSTFIX, gxm_XmRenderTableAddRenditions, 4, 0, 0, H_XmRenderTableAddRenditions);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringConcat" XM_POSTFIX, gxm_XmStringConcat, 2, 0, 0, H_XmStringConcat);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCopy" XM_POSTFIX, gxm_XmStringCopy, 1, 0, 0, H_XmStringCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCompare" XM_POSTFIX, gxm_XmStringCompare, 2, 0, 0, H_XmStringCompare);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringEmpty" XM_POSTFIX, gxm_XmStringEmpty, 1, 0, 0, H_XmStringEmpty);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringHasSubstring" XM_POSTFIX, gxm_XmStringHasSubstring, 2, 0, 0, H_XmStringHasSubstring);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringFree" XM_POSTFIX, gxm_XmStringFree, 1, 0, 0, H_XmStringFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringBaseline" XM_POSTFIX, gxm_XmStringBaseline, 2, 0, 0, H_XmStringBaseline);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringWidth" XM_POSTFIX, gxm_XmStringWidth, 2, 0, 0, H_XmStringWidth);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringHeight" XM_POSTFIX, gxm_XmStringHeight, 2, 0, 0, H_XmStringHeight);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringExtent" XM_POSTFIX, gxm_XmStringExtent, 2, 0, 0, H_XmStringExtent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringLineCount" XM_POSTFIX, gxm_XmStringLineCount, 1, 0, 0, H_XmStringLineCount);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringDraw" XM_POSTFIX, gxm_XmStringDraw, 0, 0, 1, H_XmStringDraw);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringDrawImage" XM_POSTFIX, gxm_XmStringDrawImage, 0, 0, 1, H_XmStringDrawImage);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringDrawUnderline" XM_POSTFIX, gxm_XmStringDrawUnderline, 0, 0, 1, H_XmStringDrawUnderline);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetDestination" XM_POSTFIX, gxm_XmGetDestination, 1, 0, 0, H_XmGetDestination);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsTraversable" XM_POSTFIX, gxm_XmIsTraversable, 1, 0, 0, H_XmIsTraversable);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetVisibility" XM_POSTFIX, gxm_XmGetVisibility, 1, 0, 0, H_XmGetVisibility);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetTabGroup" XM_POSTFIX, gxm_XmGetTabGroup, 1, 0, 0, H_XmGetTabGroup);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetFocusWidget" XM_POSTFIX, gxm_XmGetFocusWidget, 1, 0, 0, H_XmGetFocusWidget);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmProcessTraversal" XM_POSTFIX, gxm_XmProcessTraversal, 2, 0, 0, H_XmProcessTraversal);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCreateMenuShell" XM_POSTFIX, gxm_XmCreateMenuShell, 3, 1, 0, H_XmCreateMenuShell);

  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsMessageBox" XM_POSTFIX, gxm_XmIsMessageBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsArrowButtonGadget" XM_POSTFIX, gxm_XmIsArrowButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsArrowButton" XM_POSTFIX, gxm_XmIsArrowButton, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsNotebook" XM_POSTFIX, gxm_XmIsNotebook, 1, 0, 0, NULL);
#if HAVE_XP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsPrintShell" XM_POSTFIX, gxm_XmIsPrintShell, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsComboBox" XM_POSTFIX, gxm_XmIsComboBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsContainer" XM_POSTFIX, gxm_XmIsContainer, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsGrabShell" XM_POSTFIX, gxm_XmIsGrabShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsIconGadget" XM_POSTFIX, gxm_XmIsIconGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsIconHeader" XM_POSTFIX, gxm_XmIsIconHeader, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsPanedWindow" XM_POSTFIX, gxm_XmIsPanedWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsBulletinBoard" XM_POSTFIX, gxm_XmIsBulletinBoard, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsPrimitive" XM_POSTFIX, gxm_XmIsPrimitive, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsCascadeButtonGadget" XM_POSTFIX, gxm_XmIsCascadeButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsCascadeButton" XM_POSTFIX, gxm_XmIsCascadeButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsPushButtonGadget" XM_POSTFIX, gxm_XmIsPushButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsPushButton" XM_POSTFIX, gxm_XmIsPushButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsCommand" XM_POSTFIX, gxm_XmIsCommand, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsRowColumn" XM_POSTFIX, gxm_XmIsRowColumn, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsScale" XM_POSTFIX, gxm_XmIsScale, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsScreen" XM_POSTFIX, gxm_XmIsScreen, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsScrollBar" XM_POSTFIX, gxm_XmIsScrollBar, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDialogShell" XM_POSTFIX, gxm_XmIsDialogShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsScrolledWindow" XM_POSTFIX, gxm_XmIsScrolledWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDisplay" XM_POSTFIX, gxm_XmIsDisplay, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsSelectionBox" XM_POSTFIX, gxm_XmIsSelectionBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDragContext" XM_POSTFIX, gxm_XmIsDragContext, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsSeparatorGadget" XM_POSTFIX, gxm_XmIsSeparatorGadget, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDragIconObjectClass" XM_POSTFIX, gxm_XmIsDragIconObjectClass, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsSeparator" XM_POSTFIX, gxm_XmIsSeparator, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDrawingArea" XM_POSTFIX, gxm_XmIsDrawingArea, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDrawnButton" XM_POSTFIX, gxm_XmIsDrawnButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDropSiteManager" XM_POSTFIX, gxm_XmIsDropSiteManager, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsDropTransfer" XM_POSTFIX, gxm_XmIsDropTransfer, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsTextField" XM_POSTFIX, gxm_XmIsTextField, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsFileSelectionBox" XM_POSTFIX, gxm_XmIsFileSelectionBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsText" XM_POSTFIX, gxm_XmIsText, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsForm" XM_POSTFIX, gxm_XmIsForm, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsFrame" XM_POSTFIX, gxm_XmIsFrame, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsGadget" XM_POSTFIX, gxm_XmIsGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsToggleButtonGadget" XM_POSTFIX, gxm_XmIsToggleButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsToggleButton" XM_POSTFIX, gxm_XmIsToggleButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsLabelGadget" XM_POSTFIX, gxm_XmIsLabelGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsLabel" XM_POSTFIX, gxm_XmIsLabel, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsVendorShell" XM_POSTFIX, gxm_XmIsVendorShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsList" XM_POSTFIX, gxm_XmIsList, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsMainWindow" XM_POSTFIX, gxm_XmIsMainWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsManager" XM_POSTFIX, gxm_XmIsManager, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIsMenuShell" XM_POSTFIX, gxm_XmIsMenuShell, 1, 0, 0, NULL);

#if (!XM_DISABLE_DEPRECATED)
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWarning" XM_POSTFIX, gxm_XtWarning, 1, 0, 0, H_XtWarning);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppWarning" XM_POSTFIX, gxm_XtAppWarning, 2, 0, 0, H_XtAppWarning);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetWarningMsgHandler" XM_POSTFIX, gxm_XtSetWarningMsgHandler, 1, 0, 0, H_XtSetWarningMsgHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetWarningHandler" XM_POSTFIX, gxm_XtSetWarningHandler, 1, 0, 0, H_XtSetWarningHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWarningMsg" XM_POSTFIX, gxm_XtWarningMsg, 6, 0, 0, H_XtWarningMsg);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtErrorMsg" XM_POSTFIX, gxm_XtErrorMsg, 6, 0, 0, H_XtErrorMsg);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtError" XM_POSTFIX, gxm_XtError, 1, 0, 0, H_XtError);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetErrorMsgHandler" XM_POSTFIX, gxm_XtSetErrorMsgHandler, 1, 0, 0, H_XtSetErrorMsgHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetErrorHandler" XM_POSTFIX, gxm_XtSetErrorHandler, 1, 0, 0, H_XtSetErrorHandler);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInitialize" XM_POSTFIX, gxm_XtInitialize, 6, 0, 0, H_XtInitialize);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtCreateApplicationShell" XM_POSTFIX, gxm_XtCreateApplicationShell, 3, 1, 0, H_XtCreateApplicationShell);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtSetSelectionTimeout" XM_POSTFIX, gxm_XtSetSelectionTimeout, 1, 0, 0, H_XtSetSelectionTimeout);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtGetSelectionTimeout" XM_POSTFIX, gxm_XtGetSelectionTimeout, 0, 0, 0, H_XtGetSelectionTimeout);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddActions" XM_POSTFIX, gxm_XtAddActions, 1, 0, 0, H_XtAddActions);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddInput" XM_POSTFIX, gxm_XtAddInput, 3, 1, 0, H_XtAddInput);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddWorkProc" XM_POSTFIX, gxm_XtAddWorkProc, 1, 1, 0, H_XtAddWorkProc);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAddTimeOut" XM_POSTFIX, gxm_XtAddTimeOut, 2, 1, 0, H_XtAddTimeOut);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtMainLoop" XM_POSTFIX, gxm_XtMainLoop, 0, 0, 0, H_XtMainLoop);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtProcessEvent" XM_POSTFIX, gxm_XtProcessEvent, 1, 0, 0, H_XtProcessEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtPending" XM_POSTFIX, gxm_XtPending, 0, 0, 0, H_XtPending);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtNextEvent" XM_POSTFIX, gxm_XtNextEvent, 0, 0, 0, H_XtNextEvent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtPeekEvent" XM_POSTFIX, gxm_XtPeekEvent, 0, 0, 0, H_XtPeekEvent);

  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryCreate" XM_POSTFIX, gxm_XmFontListEntryCreate, 3, 0, 0, H_XmFontListEntryCreate);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryCreate_r" XM_POSTFIX, gxm_XmFontListEntryCreate_r, 4, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryFree" XM_POSTFIX, gxm_XmFontListEntryFree, 1, 0, 0, H_XmFontListEntryFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryGetFont" XM_POSTFIX, gxm_XmFontListEntryGetFont, 2, 0, 0, H_XmFontListEntryGetFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryGetTag" XM_POSTFIX, gxm_XmFontListEntryGetTag, 1, 0, 0, H_XmFontListEntryGetTag);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListAppendEntry" XM_POSTFIX, gxm_XmFontListAppendEntry, 2, 0, 0, H_XmFontListAppendEntry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListNextEntry" XM_POSTFIX, gxm_XmFontListNextEntry, 1, 0, 0, H_XmFontListNextEntry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListRemoveEntry" XM_POSTFIX, gxm_XmFontListRemoveEntry, 2, 0, 0, H_XmFontListRemoveEntry);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntryLoad" XM_POSTFIX, gxm_XmFontListEntryLoad, 4, 0, 0, H_XmFontListEntryLoad);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListFree" XM_POSTFIX, gxm_XmFontListFree, 1, 0, 0, H_XmFontListFree);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListCopy" XM_POSTFIX, gxm_XmFontListCopy, 1, 0, 0, H_XmFontListCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListInitFontContext" XM_POSTFIX, gxm_XmFontListInitFontContext, 1, 0, 0, H_XmFontListInitFontContext);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListFreeFontContext" XM_POSTFIX, gxm_XmFontListFreeFontContext, 1, 0, 0, H_XmFontListFreeFontContext);

  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontContext?" XM_POSTFIX, XEN_XmFontContext_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListEntry?" XM_POSTFIX, XEN_XmFontListEntry_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontList?" XM_POSTFIX, XEN_XmFontList_p, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListCreate_r" XM_POSTFIX, gxm_XmFontListCreate_r, 3, 0, 0, H_XmFontListCreate_r);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListCreate" XM_POSTFIX, gxm_XmFontListCreate, 2, 0, 0, H_XmFontListCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTrackingLocate" XM_POSTFIX, gxm_XmTrackingLocate, 3, 0, 0, H_XmTrackingLocate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListGetNextFont" XM_POSTFIX, gxm_XmFontListGetNextFont, 1, 0, 0, H_XmFontListGetNextFont);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringByteCompare" XM_POSTFIX, gxm_XmStringByteCompare, 2, 0, 0, H_XmStringByteCompare);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCreateLtoR" XM_POSTFIX, gxm_XmStringCreateLtoR, 2, 0, 0, H_XmStringCreateLtoR);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringCreateSimple" XM_POSTFIX, gxm_XmStringCreateSimple, 1, 0, 0, H_XmStringCreateSimple);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringGetLtoR" XM_POSTFIX, gxm_XmStringGetLtoR, 2, 0, 0, H_XmStringGetLtoR);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringGetNextSegment" XM_POSTFIX, gxm_XmStringGetNextSegment, 1, 0, 0, H_XmStringGetNextSegment);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringSegmentCreate" XM_POSTFIX, gxm_XmStringSegmentCreate, 4, 0, 0, H_XmStringSegmentCreate);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringPeekNextComponent" XM_POSTFIX, gxm_XmStringPeekNextComponent, 1, 0, 0, H_XmStringPeekNextComponent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringGetNextComponent" XM_POSTFIX, gxm_XmStringGetNextComponent, 1, 0, 0, H_XmStringGetNextComponent);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFontListAdd" XM_POSTFIX, gxm_XmFontListAdd, 3, 0, 0, H_XmFontListAdd);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringLength" XM_POSTFIX, gxm_XmStringLength, 1, 0, 0, H_XmStringLength);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringNConcat" XM_POSTFIX, gxm_XmStringNConcat, 3, 0, 0, H_XmStringNConcat);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringNCopy" XM_POSTFIX, gxm_XmStringNCopy, 2, 0, 0, H_XmStringNCopy);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrolledWindowSetAreas" XM_POSTFIX, gxm_XmScrolledWindowSetAreas, 4, 0, 0, H_XmScrolledWindowSetAreas);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSetFontUnits" XM_POSTFIX, gxm_XmSetFontUnits, 3, 0, 0, H_XmSetFontUnits);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSetFontUnit" XM_POSTFIX, gxm_XmSetFontUnit, 2, 0, 0, H_XmSetFontUnit);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGetMenuCursor" XM_POSTFIX, gxm_XmGetMenuCursor, 1, 0, 0, H_XmGetMenuCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSetMenuCursor" XM_POSTFIX, gxm_XmSetMenuCursor, 2, 0, 0, H_XmSetMenuCursor);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmListGetSelectedPos" XM_POSTFIX, gxm_XmListGetSelectedPos, 1, 0, 0, H_XmListGetSelectedPos);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMainWindowSetAreas" XM_POSTFIX, gxm_XmMainWindowSetAreas, 6, 0, 0, H_XmMainWindowSetAreas);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMainWindowSep1" XM_POSTFIX, gxm_XmMainWindowSep1, 1, 0, 0, H_XmMainWindowSep1);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMainWindowSep2" XM_POSTFIX, gxm_XmMainWindowSep2, 1, 0, 0, H_XmMainWindowSep2);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMainWindowSep3" XM_POSTFIX, gxm_XmMainWindowSep3, 1, 0, 0, H_XmMainWindowSep3);
#endif

#endif

#if HAVE_XPM
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmCreatePixmapFromData" XM_POSTFIX, gxm_XpmCreatePixmapFromData, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmCreateDataFromPixmap" XM_POSTFIX, gxm_XpmCreateDataFromPixmap, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmReadFileToPixmap" XM_POSTFIX, gxm_XpmReadFileToPixmap, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmReadFileToXpmImage" XM_POSTFIX, gxm_XpmReadFileToXpmImage, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmReadPixmapFile" XM_POSTFIX, gxm_XpmReadFileToPixmap, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmWriteFileFromPixmap" XM_POSTFIX, gxm_XpmWriteFileFromPixmap, 5, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmWritePixmapFile" XM_POSTFIX, gxm_XpmWriteFileFromPixmap, 5, 0, 0, NULL);
#if HAVE_XPM_GET_ERROR_STRING
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmGetErrorString" XM_POSTFIX, gxm_XpmGetErrorString, 1, 0, 0, H_XpmGetErrorString);
#endif
#if HAVE_XPM_CREATE_XPM_IMAGE_FROM_PIXMAP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmCreatePixmapFromXpmImage" XM_POSTFIX, gxm_XpmCreatePixmapFromXpmImage, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmCreateXpmImageFromPixmap" XM_POSTFIX, gxm_XpmCreateXpmImageFromPixmap, 4, 0, 0, NULL);
#endif
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGetPixel" XM_POSTFIX, gxm_XGetPixel, 3, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDestroyImage" XM_POSTFIX, gxm_XDestroyImage, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPutPixel" XM_POSTFIX, gxm_XPutPixel, 4, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSubImage" XM_POSTFIX, gxm_XSubImage, 5, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XAddPixel" XM_POSTFIX, gxm_XAddPixel, 2, 0, 0, NULL);


  /*  ADD: XtAppContext? XtRequestId? XtWorkProcId? XtInputId? XtIntervalId? Screen? XEvent? XRectangle? XArc?
      ADD: XPoint? XSegment? XColor? XmTab? Atom? Colormap? Depth? Display? Drawable? Font? GC? KeySym? Pixel? Pixmap? Region?
      ADD: Time? Visual? Window? XFontProp? XFontStruct? XGCValues? XImage? XVisualInfo? XWMHints? XWindowAttributes? XWindowChanges?
      ADD: KeyCode? XContext? Substitution? XmString? XmToggleButton? XmDrawingArea?
      ADD: XmPushButton? XmTextField? XmFileSelectionBox? XmText? XmFrame? XmLabel? XmList? XmArrowButton? XmScrollBar? XmCommand?
      ADD: XmScale? XmRowColumn? XmNotebook? XmPrintShell? XmComboBox? XmContainer? XmIconHeader? XmGrabShell? XmPanedWindow? XmScrolledWindow?
      ADD: XmCascadeButton? XmForm? XmBulletinBoard? XmScreen? XmDialogShell? XmDisplay? XmSelectionBox? XmDragContext? XmDragIconObjectClass?
      ADD: XmSeparator? XmDropSiteManager? XmDropTransfer? XmVendorShell? XmMainWindow? XmMessageBox? XmManager? XmMenuShell? XmIconGadget?
      ADD: XmLabelGadget? XmPushButtonGadget? XmSeparatorGadget? XmArrowButtonGadget? XmCascadeButtonGadget? XmToggleButtonGadget? XmDrawnButton?
      ADD: XmPrimitive? XmTabList? XmParseMapping? XmFontList? XmFontListEntry? XmTextSource? XmStringContext?
      ADD: XStandardColormap? WidgetClass? Widget? XTextItem? XCharStruct? XmParseTable? XmFontContext? XFontSet?
      ADD: XpmAttributes? XpmImage? XmRendition? XmRenderTable? XModifierKeymap? XPContext?
  */
#if HAVE_MOTIF
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Pixel" XM_POSTFIX, gxm_Pixel, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "GC" XM_POSTFIX, gxm_GC, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Widget" XM_POSTFIX, gxm_Widget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtAppContext?" XM_POSTFIX, XEN_XtAppContext_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtRequestId?" XM_POSTFIX, XEN_XtRequestId_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtWorkProcId?" XM_POSTFIX, XEN_XtWorkProcId_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtInputId?" XM_POSTFIX, XEN_XtInputId_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XtIntervalId?" XM_POSTFIX, XEN_XtIntervalId_p, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Screen?" XM_POSTFIX, XEN_Screen_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XEvent?" XM_POSTFIX, XEN_XEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XRectangle?" XM_POSTFIX, XEN_XRectangle_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XArc?" XM_POSTFIX, XEN_XArc_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPoint?" XM_POSTFIX, XEN_XPoint_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSegment?" XM_POSTFIX, XEN_XSegment_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XColor?" XM_POSTFIX, XEN_XColor_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Atom?" XM_POSTFIX, XEN_Atom_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Colormap?" XM_POSTFIX, XEN_Colormap_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XModifierKeymap?" XM_POSTFIX, XEN_XModifierKeymap_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Depth?" XM_POSTFIX, XEN_Depth_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Display?" XM_POSTFIX, XEN_Display_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Drawable?" XM_POSTFIX, XEN_Window_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Font?" XM_POSTFIX, XEN_Font_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "GC?" XM_POSTFIX, XEN_GC_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "KeySym?" XM_POSTFIX, XEN_KeySym_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Pixel?" XM_POSTFIX, XEN_Pixel_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Pixmap?" XM_POSTFIX, XEN_Pixmap_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Region?" XM_POSTFIX, XEN_Region_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Time?" XM_POSTFIX, XEN_Time_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Visual?" XM_POSTFIX, XEN_Visual_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Window?" XM_POSTFIX, XEN_Window_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFontProp?" XM_POSTFIX, XEN_XFontProp_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFontSet?" XM_POSTFIX, XEN_XFontSet_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFontStruct?" XM_POSTFIX, XEN_XFontStruct_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGCValues?" XM_POSTFIX, XEN_XGCValues_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XImage?" XM_POSTFIX, XEN_XImage_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XVisualInfo?" XM_POSTFIX, XEN_XVisualInfo_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWMHints?" XM_POSTFIX, XEN_XWMHints_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWindowAttributes?" XM_POSTFIX, XEN_XWindowAttributes_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XWindowChanges?" XM_POSTFIX, XEN_XWindowChanges_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "KeyCode?" XM_POSTFIX, XEN_KeyCode_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XContext?" XM_POSTFIX, XEN_XContext_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCharStruct?" XM_POSTFIX, XEN_XCharStruct_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XTextItem?" XM_POSTFIX, XEN_XTextItem_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XStandardColormap?" XM_POSTFIX, XEN_XStandardColormap_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Substitution?" XM_POSTFIX, XEN_Substitution_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Cursor?" XM_POSTFIX, XEN_Cursor_p, 1, 0, 0, NULL);
#if HAVE_XP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPContext?" XM_POSTFIX, XEN_XPContext_p, 1, 0, 0, NULL);
#endif
#if HAVE_MOTIF
  XEN_DEFINE_PROCEDURE(XM_PREFIX "Widget?" XM_POSTFIX, XEN_Widget_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmStringContext?" XM_POSTFIX, XEN_XmStringContext_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "WidgetClass?" XM_POSTFIX, XEN_WidgetClass_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmString?" XM_POSTFIX, XEN_XmString_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButton?" XM_POSTFIX, gxm_XmIsToggleButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDrawingArea?" XM_POSTFIX, gxm_XmIsDrawingArea, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPushButton?" XM_POSTFIX, gxm_XmIsPushButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextField?" XM_POSTFIX, gxm_XmIsTextField, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFileSelectionBox?" XM_POSTFIX, gxm_XmIsFileSelectionBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmText?" XM_POSTFIX, gxm_XmIsText, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmFrame?" XM_POSTFIX, gxm_XmIsFrame, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmLabel?" XM_POSTFIX, gxm_XmIsLabel, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmList?" XM_POSTFIX, gxm_XmIsList, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmArrowButton?" XM_POSTFIX, gxm_XmIsArrowButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrollBar?" XM_POSTFIX, gxm_XmIsScrollBar, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCommand?" XM_POSTFIX, gxm_XmIsCommand, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScale?" XM_POSTFIX, gxm_XmIsScale, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRowColumn?" XM_POSTFIX, gxm_XmIsRowColumn, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTab?" XM_POSTFIX, XEN_XmTab_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmNotebook?" XM_POSTFIX, gxm_XmIsNotebook, 1, 0, 0, NULL);
#if HAVE_XP
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPrintShell?" XM_POSTFIX, gxm_XmIsPrintShell, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmComboBox?" XM_POSTFIX, gxm_XmIsComboBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmContainer?" XM_POSTFIX, gxm_XmIsContainer, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIconHeader?" XM_POSTFIX, gxm_XmIsIconHeader, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmGrabShell?" XM_POSTFIX, gxm_XmIsGrabShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRendition?" XM_POSTFIX, XEN_XmRendition_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmRenderTable?" XM_POSTFIX, XEN_XmRenderTable_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmIconGadget?" XM_POSTFIX, gxm_XmIsIconGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTabList?" XM_POSTFIX, XEN_XmTabList_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmParseMapping?" XM_POSTFIX, XEN_XmParseMapping_p, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPanedWindow?" XM_POSTFIX, gxm_XmIsPanedWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScrolledWindow?" XM_POSTFIX, gxm_XmIsScrolledWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCascadeButton?" XM_POSTFIX, gxm_XmIsCascadeButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmForm?" XM_POSTFIX, gxm_XmIsForm, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmBulletinBoard?" XM_POSTFIX, gxm_XmIsBulletinBoard, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmScreen?" XM_POSTFIX, gxm_XmIsScreen, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDialogShell?" XM_POSTFIX, gxm_XmIsDialogShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDisplay?" XM_POSTFIX, gxm_XmIsDisplay, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSelectionBox?" XM_POSTFIX, gxm_XmIsSelectionBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDragContext?" XM_POSTFIX, gxm_XmIsDragContext, 1, 0, 0, NULL);
#if MOTIF_2
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDragIconObjectClass?" XM_POSTFIX, gxm_XmIsDragIconObjectClass, 1, 0, 0, NULL);
#endif
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSeparator?" XM_POSTFIX, gxm_XmIsSeparator, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropSiteManager?" XM_POSTFIX, gxm_XmIsDropSiteManager, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDropTransfer?" XM_POSTFIX, gxm_XmIsDropTransfer, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmVendorShell?" XM_POSTFIX, gxm_XmIsVendorShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMainWindow?" XM_POSTFIX, gxm_XmIsMainWindow, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMessageBox?" XM_POSTFIX, gxm_XmIsMessageBox, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmManager?" XM_POSTFIX, gxm_XmIsManager, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmMenuShell?" XM_POSTFIX, gxm_XmIsMenuShell, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmLabelGadget?" XM_POSTFIX, gxm_XmIsLabelGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPushButtonGadget?" XM_POSTFIX, gxm_XmIsPushButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmSeparatorGadget?" XM_POSTFIX, gxm_XmIsSeparatorGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmArrowButtonGadget?" XM_POSTFIX, gxm_XmIsArrowButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmCascadeButtonGadget?" XM_POSTFIX, gxm_XmIsCascadeButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmToggleButtonGadget?" XM_POSTFIX, gxm_XmIsToggleButtonGadget, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmDrawnButton?" XM_POSTFIX, gxm_XmIsDrawnButton, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmPrimitive?" XM_POSTFIX, gxm_XmIsPrimitive, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XmTextSource?" XM_POSTFIX, XEN_XmTextSource_p, 1, 0, 0, NULL);
#endif
#if HAVE_XPM
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmAttributes?" XM_POSTFIX, XEN_XpmAttributes_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmImage?" XM_POSTFIX, XEN_XpmImage_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XpmColorSymbol?" XM_POSTFIX, XEN_XpmColorSymbol_p, 1, 0, 0, NULL);
#endif

  XEN_DEFINE_PROCEDURE(XM_PREFIX "XButtonEvent?" XM_POSTFIX, XEN_XButtonEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCirculateEvent?" XM_POSTFIX, XEN_XCirculateEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCirculateRequestEvent?" XM_POSTFIX, XEN_XCirculateRequestEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XClientMessageEvent?" XM_POSTFIX, XEN_XClientMessageEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XColormapEvent?" XM_POSTFIX, XEN_XColormapEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConfigureEvent?" XM_POSTFIX, XEN_XConfigureEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XConfigureRequestEvent?" XM_POSTFIX, XEN_XConfigureRequestEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCreateWindowEvent?" XM_POSTFIX, XEN_XCreateWindowEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XCrossingEvent?" XM_POSTFIX, XEN_XCrossingEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XDestroyWindowEvent?" XM_POSTFIX, XEN_XDestroyWindowEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XErrorEvent?" XM_POSTFIX, XEN_XErrorEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XExposeEvent?" XM_POSTFIX, XEN_XExposeEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XFocusChangeEvent?" XM_POSTFIX, XEN_XFocusChangeEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGraphicsExposeEvent?" XM_POSTFIX, XEN_XGraphicsExposeEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XGravityEvent?" XM_POSTFIX, XEN_XGravityEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKeyEvent?" XM_POSTFIX, XEN_XKeyEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XKeymapEvent?" XM_POSTFIX, XEN_XKeymapEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMapEvent?" XM_POSTFIX, XEN_XMapEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMapRequestEvent?" XM_POSTFIX, XEN_XMapRequestEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMappingEvent?" XM_POSTFIX, XEN_XMappingEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XMotionEvent?" XM_POSTFIX, XEN_XMotionEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XNoExposeEvent?" XM_POSTFIX, XEN_XNoExposeEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XPropertyEvent?" XM_POSTFIX, XEN_XPropertyEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XReparentEvent?" XM_POSTFIX, XEN_XReparentEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XResizeRequestEvent?" XM_POSTFIX, XEN_XResizeRequestEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSelectionClearEvent?" XM_POSTFIX, XEN_XSelectionClearEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSelectionEvent?" XM_POSTFIX, XEN_XSelectionEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSelectionRequestEvent?" XM_POSTFIX, XEN_XSelectionRequestEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XSetWindowAttributes?" XM_POSTFIX, XEN_XSetWindowAttributes_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XUnmapEvent?" XM_POSTFIX, XEN_XUnmapEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XVisibilityEvent?" XM_POSTFIX, XEN_XVisibilityEvent_p, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE(XM_PREFIX "XIconSize?" XM_POSTFIX, XEN_XIconSize_p, 1, 0, 0, NULL);

  XEN_DEFINE_PROCEDURE("xm-gc-elements", xm_gc_elements, 0, 0, 0, NULL);

  XEN_DEFINE_PROCEDURE("->string", c_to_xen_string, 1, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE("->strings", c_to_xen_strings, 2, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE("->ints", c_to_xen_ints, 2, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE("->Atoms", c_to_xen_atoms, 2, 0, 0, NULL);
  XEN_DEFINE_PROCEDURE("->XRectangles", c_to_xen_xrectangles, 2, 0, 0, NULL);
}
#endif



/* -------------------------------- struct handlers -------------------------------- */

static char xm_print_buf[1024];

/* XRectangle */

static XEN gxm_XRectangle(XEN x, XEN y, XEN width, XEN height)
{
  #define H_XRectangle "(XRectangle x y width height) returns the given XRectangle"
  XRectangle *r;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(x), x, 1, "XRectangle", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(y), y, 2, "XRectangle", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(width), width, 3, "XRectangle", "INT");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(height), height, 4, "XRectangle", "INT");
  r = (XRectangle *)CALLOC(1, sizeof(XRectangle));
  r->x = (short)XEN_TO_C_INT(x);
  r->y = (short)XEN_TO_C_INT(y);
  r->width = XEN_TO_C_INT(width);
  r->height = XEN_TO_C_INT(height);
  return(C_TO_XEN_XRectangle(r));
}

static char *XRectangle_to_string(XEN obj)
{
  XRectangle *r;
  r = XEN_TO_C_XRectangle(obj);
  sprintf(xm_print_buf, 
	  "%d %d %d %d",
	  r->x, r->y, r->width, r->height);
  return(xm_print_buf);
}

/* XSegment */

static XEN gxm_XSegment(XEN x1, XEN y1, XEN x2, XEN y2)
{
  XSegment *r;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(x1), x1, 1, "XSegment", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(y1), y1, 2, "XSegment", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(x2), x2, 3, "XSegment", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(y2), y2, 4, "XSegment", "short");
  r = (XSegment *)CALLOC(1, sizeof(XSegment));
  r->x1 = (short)XEN_TO_C_INT(x1);
  r->y1 = (short)XEN_TO_C_INT(y1);
  r->x2 = (short)XEN_TO_C_INT(x2);
  r->y2 = (short)XEN_TO_C_INT(y2);
  return(C_TO_XEN_XSegment(r));
}

static char *XSegment_to_string(XEN obj)
{
  XSegment *r;
  r = XEN_TO_C_XSegment(obj);
  sprintf(xm_print_buf, 
	  "%d %d %d %d",
	  r->x1, r->y1, r->x2, r->y2);
  return(xm_print_buf);
}

static XEN gxm_y2(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ONLY_ARG, "y2", "XSegment");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSegment(ptr))->y2)));
}

static XEN gxm_set_y2(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_y2", "a number");
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ARG_2, "set_y2", "XSegment");
  (XEN_TO_C_XSegment(ptr))->y2 = (short)XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_x2(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ONLY_ARG, "x2", "XSegment");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSegment(ptr))->x2)));
}

static XEN gxm_set_x2(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_x2", "a number");
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ARG_2, "set_x2", "XSegment");
  (XEN_TO_C_XSegment(ptr))->x2 = (short)XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_y1(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ONLY_ARG, "y1", "XSegment");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSegment(ptr))->y1)));
}

static XEN gxm_set_y1(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_y1", "a number");
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ARG_2, "set_y1", "XSegment");
  (XEN_TO_C_XSegment(ptr))->y1 = (short)XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_x1(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ONLY_ARG, "x1", "XSegment");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSegment(ptr))->x1)));
}

static XEN gxm_set_x1(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_x1", "a number");
  XEN_ASSERT_TYPE(XEN_XSegment_P(ptr), ptr, XEN_ARG_2, "set_x1", "XSegment");
  (XEN_TO_C_XSegment(ptr))->x1 = (short)XEN_TO_C_INT(val);
  return(val);
}

/* XPoint */

static XEN gxm_XPoint(XEN x, XEN y)
{
  XPoint *r;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(x), x, 1, "XPoint", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(y), y, 2, "XPoint", "short");
  r = (XPoint *)CALLOC(1, sizeof(XPoint));
  r->x = (short)XEN_TO_C_INT(x);
  r->y = (short)XEN_TO_C_INT(y);
  return(C_TO_XEN_XPoint(r));
}

static char *XPoint_to_string(XEN obj)
{
  XPoint *r;
  r = XEN_TO_C_XPoint(obj);
  sprintf(xm_print_buf, 
	  "%d %d",
	  r->x, r->y);
  return(xm_print_buf);
}

/* XArc */

static XEN gxm_XArc(XEN x, XEN y, XEN width, XEN height, XEN angle1, XEN angle2)
{
  XArc *r;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(x), x, 1, "XArc", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(y), y, 2, "XArc", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(width), width, 3, "XArc", "INT");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(height), height, 4, "XArc", "INT");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(angle1), angle1, 5, "XArc", "short");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(angle2), angle2, 6, "XArc", "short");
  r = (XArc *)CALLOC(1, sizeof(XArc));
  r->x = (short)XEN_TO_C_INT(x);
  r->y = (short)XEN_TO_C_INT(y);
  r->width = XEN_TO_C_INT(width);
  r->height = XEN_TO_C_INT(height);
  r->angle1 = (short)XEN_TO_C_INT(angle1);
  r->angle2 = (short)XEN_TO_C_INT(angle2);
  return(C_TO_XEN_XArc(r));
}

static char *XArc_to_string(XEN obj)
{
  XArc *r;
  r = XEN_TO_C_XArc(obj);
  sprintf(xm_print_buf, 
	  "%d %d %d %d %d %d",
	  r->x, r->y, r->width, r->height, r->angle1, r->angle2);
  return(xm_print_buf);
}


static XEN gxm_angle2(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XArc_P(ptr), ptr, XEN_ONLY_ARG, "angle2", "XArc");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->angle2)));
}

static XEN gxm_set_angle2(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_angle2", "a number");
  XEN_ASSERT_TYPE(XEN_XArc_P(ptr), ptr, XEN_ARG_2, "set_angle2", "XArc");
  (XEN_TO_C_XArc(ptr))->angle2 = (short)XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_angle1(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XArc_P(ptr), ptr, XEN_ONLY_ARG, "angle1", "XArc");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->angle1)));
}

static XEN gxm_set_angle1(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_NUMBER_P(val), val, XEN_ARG_1, "set_angle1", "a number");
  XEN_ASSERT_TYPE(XEN_XArc_P(ptr), ptr, XEN_ARG_2, "set_angle1", "XArc");
  (XEN_TO_C_XArc(ptr))->angle1 = (short)XEN_TO_C_INT(val);
  return(val);
}

/* XColor */

static XEN gxm_XColor(XEN pixel, XEN red, XEN green, XEN blue, XEN flags, XEN pad)
{
  XColor *r;
  XEN_ASSERT_TYPE(XEN_ULONG_IF_BOUND_P(pixel), pixel, 1, "XColor", "ulong");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(red), red, 2, "XColor", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(green), green, 3, "XColor", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(blue), blue, 4, "XColor", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(flags), flags, 5, "XColor", "char");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(pad), pad, 6, "XColor", "char");
  r = (XColor *)CALLOC(1, sizeof(XColor));
  if (XEN_BOUND_P(pixel)) r->pixel = XEN_TO_C_ULONG(pixel);
  if (XEN_BOUND_P(red)) r->red = XEN_TO_C_INT(red);
  if (XEN_BOUND_P(green)) r->green = XEN_TO_C_INT(green);
  if (XEN_BOUND_P(blue)) r->blue = XEN_TO_C_INT(blue);
  if (XEN_BOUND_P(flags)) r->flags = (char)XEN_TO_C_INT(flags);
  if (XEN_BOUND_P(pad)) r->pad = (char)XEN_TO_C_INT(pad);
  return(C_TO_XEN_XColor(r));
}

static char *XColor_to_string(XEN obj)
{
  XColor *r;
  r = XEN_TO_C_XColor(obj);
  sprintf(xm_print_buf, 
	  "pixel: %d, rgb: %d %d %d, flags: %x", 
	  (int)(r->pixel), r->red, r->green, r->blue, (int)(r->flags));
  return(xm_print_buf);
}

static char *xm_obj_to_string(XEN obj)
{
  if (XEN_XColor_P(obj)) return(XColor_to_string(obj));
  if (XEN_XRectangle_P(obj)) return(XRectangle_to_string(obj));
  if (XEN_XPoint_P(obj)) return(XPoint_to_string(obj));
  if (XEN_XArc_P(obj)) return(XArc_to_string(obj));
  if (XEN_XSegment_P(obj)) return(XSegment_to_string(obj));
  return(NULL);
}

static XEN gxm_to_s(XEN obj)
{
  return(C_TO_XEN_STRING(xm_obj_to_string(obj)));
}

static XEN gxm_pad(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ONLY_ARG, "pad", "XColor");
  return(C_TO_XEN_char((char)((XEN_TO_C_XColor(ptr))->pad)));
}

static XEN gxm_set_pad(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ARG_1, "set_pad", "XColor");
  (XEN_TO_C_XColor(ptr))->pad = XEN_TO_C_char(val);
  return(val);
}

static XEN gxm_blue(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ONLY_ARG, "blue", "XColor");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XColor(ptr))->blue)));
}

static XEN gxm_set_blue(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ARG_1, "set_blue", "XColor");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_blue", "an integer");
  (XEN_TO_C_XColor(ptr))->blue = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_green(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ONLY_ARG, "green", "XColor");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XColor(ptr))->green)));
}

static XEN gxm_set_green(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ARG_1, "set_green", "XColor");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_green", "an integer");
  (XEN_TO_C_XColor(ptr))->green = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_red(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ONLY_ARG, "red", "XColor");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XColor(ptr))->red)));
}

static XEN gxm_set_red(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ARG_1, "set_red", "XColor");
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_red", "an integer");
  (XEN_TO_C_XColor(ptr))->red = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_XWindowChanges(XEN x, XEN y, XEN width, XEN height, XEN border_width, XEN sibling, XEN stack_mode)
{
  XWindowChanges *r;
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(x), x, 1, "XWindowChanges", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(y), y, 2, "XWindowChanges", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(width), width, 3, "XWindowChanges", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(height), height, 4, "XWindowChanges", "int");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(border_width), border_width, 5, "XWindowChanges", "int");
  XEN_ASSERT_TYPE(XEN_Window_P(sibling) || XEN_NOT_BOUND_P(sibling), sibling, 6, "XWindowChanges", "Window");
  XEN_ASSERT_TYPE(XEN_INTEGER_IF_BOUND_P(stack_mode), stack_mode, 7, "XWindowChanges", "int");
  r = (XWindowChanges *)CALLOC(1, sizeof(XWindowChanges));
  if (XEN_BOUND_P(x)) r->x = XEN_TO_C_INT(x);
  if (XEN_BOUND_P(y)) r->y = XEN_TO_C_INT(y);
  if (XEN_BOUND_P(width)) r->width = XEN_TO_C_INT(width);
  if (XEN_BOUND_P(height)) r->height = XEN_TO_C_INT(height);
  if (XEN_BOUND_P(border_width)) r->border_width = XEN_TO_C_INT(border_width);
  if (XEN_BOUND_P(sibling)) r->sibling = XEN_TO_C_Window(sibling);
  if (XEN_BOUND_P(stack_mode)) r->stack_mode = XEN_TO_C_INT(stack_mode);
  return(C_TO_XEN_XWindowChanges(r));
}

static XEN gxm_XSetWindowAttributes(XEN arglist)
{
  int len;
  XSetWindowAttributes *r;
  r = (XSetWindowAttributes *)CALLOC(1, sizeof(XSetWindowAttributes));
  len = XEN_LIST_LENGTH(arglist);
  if ((len > 0) && (XEN_Pixmap_P(XEN_LIST_REF(arglist, 0)))) r->background_pixmap = XEN_TO_C_Pixmap(XEN_LIST_REF(arglist, 0));
  if ((len > 1) && (XEN_ULONG_P(XEN_LIST_REF(arglist, 1)))) r->background_pixel = XEN_TO_C_ULONG(XEN_LIST_REF(arglist, 1));
  if ((len > 2) && (XEN_Pixmap_P(XEN_LIST_REF(arglist, 2)))) r->border_pixmap = XEN_TO_C_Pixmap(XEN_LIST_REF(arglist, 2));
  if ((len > 3) && (XEN_ULONG_P(XEN_LIST_REF(arglist, 3)))) r->border_pixel = XEN_TO_C_ULONG(XEN_LIST_REF(arglist, 3));
  if ((len > 4) && (XEN_INTEGER_P(XEN_LIST_REF(arglist, 4)))) r->bit_gravity = XEN_TO_C_INT(XEN_LIST_REF(arglist, 4));
  if ((len > 5) && (XEN_INTEGER_P(XEN_LIST_REF(arglist, 5)))) r->win_gravity = XEN_TO_C_INT(XEN_LIST_REF(arglist, 5));
  if ((len > 6) && (XEN_INTEGER_P(XEN_LIST_REF(arglist, 6)))) r->backing_store = XEN_TO_C_INT(XEN_LIST_REF(arglist, 6));
  if ((len > 7) && (XEN_ULONG_P(XEN_LIST_REF(arglist, 7)))) r->backing_planes = XEN_TO_C_ULONG(XEN_LIST_REF(arglist, 7));
  if ((len > 8) && (XEN_ULONG_P(XEN_LIST_REF(arglist, 8)))) r->backing_pixel = XEN_TO_C_ULONG(XEN_LIST_REF(arglist, 8));
  if ((len > 9) && (XEN_BOOLEAN_P(XEN_LIST_REF(arglist, 9)))) r->save_under = XEN_TO_C_BOOLEAN(XEN_LIST_REF(arglist, 9));
  if ((len > 10) && (XEN_INTEGER_P(XEN_LIST_REF(arglist, 10)))) r->event_mask = XEN_TO_C_INT(XEN_LIST_REF(arglist, 10));
  if ((len > 11) && (XEN_INTEGER_P(XEN_LIST_REF(arglist, 11)))) r->do_not_propagate_mask = XEN_TO_C_INT(XEN_LIST_REF(arglist, 11));
  if ((len > 12) && (XEN_BOOLEAN_P(XEN_LIST_REF(arglist, 12)))) r->override_redirect = XEN_TO_C_BOOLEAN(XEN_LIST_REF(arglist, 12));
  if ((len > 13) && (XEN_Colormap_P(XEN_LIST_REF(arglist, 13)))) r->colormap = XEN_TO_C_Colormap(XEN_LIST_REF(arglist, 13));
  if ((len > 14) && (XEN_Cursor_P(XEN_LIST_REF(arglist, 14)))) r->cursor = XEN_TO_C_Cursor(XEN_LIST_REF(arglist, 14));
  return(C_TO_XEN_XSetWindowAttributes(r));
}

static XEN gxm_stack_mode(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowChanges_P(ptr), ptr, XEN_ONLY_ARG, "stack_mode", "XWindowChanges");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->stack_mode)));
}

static XEN gxm_sibling(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowChanges_P(ptr), ptr, XEN_ONLY_ARG, "sibling", "XWindowChanges");
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XWindowChanges(ptr))->sibling)));
}

static XEN gxm_obdata(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "obdata", "XImage");
  return(C_TO_XEN_ULONG((XPointer)((XEN_TO_C_XImage(ptr))->obdata)));
}

static XEN gxm_bytes_per_line(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "bytes_per_line", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->bytes_per_line)));
}

static XEN gxm_bitmap_pad(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "bitmap_pad", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->bitmap_pad)));
}

static XEN gxm_bitmap_bit_order(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "bitmap_bit_order", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->bitmap_bit_order)));
}

static XEN gxm_bitmap_unit(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "bitmap_unit", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->bitmap_unit)));
}

static XEN gxm_byte_order(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "byte_order", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->byte_order)));
}

static XEN gxm_xoffset(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "xoffset", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->xoffset)));
}

static XEN gxm_screen(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_Screen((Screen *)((XEN_TO_C_XWindowAttributes(ptr))->screen)));
#if MOTIF_2
  if (XEN_XmTopLevelEnterCallbackStruct_P(ptr)) return(C_TO_XEN_Screen((Screen *)((XEN_TO_C_XmTopLevelEnterCallbackStruct(ptr))->screen)));
  if (XEN_XmTopLevelLeaveCallbackStruct_P(ptr)) return(C_TO_XEN_Screen((Screen *)((XEN_TO_C_XmTopLevelLeaveCallbackStruct(ptr))->screen)));
#endif
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->screen)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "screen", "a struct with a screen field");
}

static XEN gxm_your_event_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "your_event_mask", "XWindowAttributes");
  return(C_TO_XEN_INT((long)((XEN_TO_C_XWindowAttributes(ptr))->your_event_mask)));
}

static XEN gxm_all_event_masks(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "all_event_masks", "XWindowAttributes");
  return(C_TO_XEN_INT((long)((XEN_TO_C_XWindowAttributes(ptr))->all_event_masks)));
}

static XEN gxm_map_state(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "map_state", "XWindowAttributes");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->map_state)));
}

static XEN gxm_map_installed(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "map_installed", "XWindowAttributes");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XWindowAttributes(ptr))->map_installed)));
}

static XEN gxm_set_visual(XEN ptr, XEN val)
{
#if HAVE_XPM
  XEN_ASSERT_TYPE(XEN_Visual_P(val), val, XEN_ONLY_ARG, "set_visual", "Visual");
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "set_visual", "Visual");
  (XEN_TO_C_XpmAttributes(ptr))->visual = (Visual *)XEN_TO_C_Visual(val);
#endif
  return(val);
}

static XEN gxm_visual(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_Visual((Visual *)((XEN_TO_C_XWindowAttributes(ptr))->visual)));
#if HAVE_XPM
  if (XEN_XpmAttributes_P(ptr)) return(C_TO_XEN_Visual((Visual *)((XEN_TO_C_XpmAttributes(ptr))->visual)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "visual", "a struct with a visual field");
}

static XEN gxm_cursor(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "cursor", "XSetWindowAttributes");
  return(C_TO_XEN_Cursor((Cursor)((XEN_TO_C_XSetWindowAttributes(ptr))->cursor)));
}

static XEN gxm_do_not_propagate_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), 
		  ptr, XEN_ONLY_ARG, "do_not_propagate_mask", "a struct with a do_not_propagate_mask field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((long)((XEN_TO_C_XWindowAttributes(ptr))->do_not_propagate_mask)));
  return(C_TO_XEN_INT((long)((XEN_TO_C_XSetWindowAttributes(ptr))->do_not_propagate_mask)));
}

static XEN gxm_event_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "event_mask", "XSetWindowAttributes");
  return(C_TO_XEN_INT((long)((XEN_TO_C_XSetWindowAttributes(ptr))->event_mask)));
}

static XEN gxm_save_under(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "save_under", "a struct with a save_under field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XWindowAttributes(ptr))->save_under)));
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XSetWindowAttributes(ptr))->save_under)));
}

static XEN gxm_backing_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "backing_pixel", "a struct with a backing_pixel field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XWindowAttributes(ptr))->backing_pixel)));
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XSetWindowAttributes(ptr))->backing_pixel)));
}

static XEN gxm_backing_planes(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "backing_planes", "a struct with a backing_planes field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XWindowAttributes(ptr))->backing_planes)));
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XSetWindowAttributes(ptr))->backing_planes)));
}

static XEN gxm_win_gravity(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "win_gravity", "a struct with a win_gravity field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->win_gravity)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSetWindowAttributes(ptr))->win_gravity)));
}

static XEN gxm_bit_gravity(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWindowAttributes_P(ptr) || XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "bit_gravity", "a struct with a bit_gravity field");
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->bit_gravity)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XSetWindowAttributes(ptr))->bit_gravity)));
}

static XEN gxm_border_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "border_pixel", "XSetWindowAttributes");
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XSetWindowAttributes(ptr))->border_pixel)));
}

static XEN gxm_border_pixmap(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "border_pixmap", "XSetWindowAttributes");
  return(C_TO_XEN_Pixmap((Pixmap)((XEN_TO_C_XSetWindowAttributes(ptr))->border_pixmap)));
}

static XEN gxm_background_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "background_pixel", "XSetWindowAttributes");
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XSetWindowAttributes(ptr))->background_pixel)));
}

static XEN gxm_background_pixmap(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSetWindowAttributes_P(ptr), ptr, XEN_ONLY_ARG, "background_pixmap", "XSetWindowAttributes");
  return(C_TO_XEN_Pixmap((Pixmap)((XEN_TO_C_XSetWindowAttributes(ptr))->background_pixmap)));
}

static XEN gxm_bits_per_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr), ptr, XEN_ONLY_ARG, "bits_per_pixel", "XImage");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->bits_per_pixel)));
}

static XEN gxm_visuals(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Depth_P(ptr), ptr, XEN_ONLY_ARG, "visuals", "Depth");
  return(C_TO_XEN_Visual((Visual *)((XEN_TO_C_Depth(ptr))->visuals)));
}

static XEN gxm_nvisuals(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Depth_P(ptr), ptr, XEN_ONLY_ARG, "nvisuals", "Depth");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Depth(ptr))->nvisuals)));
}

static XEN gxm_set_depth(XEN ptr, XEN val)
{
#if HAVE_XPM
  XEN_ASSERT_TYPE(XEN_XpmAttributes_P(ptr), ptr, XEN_ONLY_ARG, "set_depth", "XpmAttributes");
  (XEN_TO_C_XpmAttributes(ptr))->depth = XEN_TO_C_ULONG(val);
#endif
  return(val);
}

static XEN gxm_depth(XEN ptr)
{
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->depth)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->depth)));
  if (XEN_Depth_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_Depth(ptr))->depth)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->depth)));
#if HAVE_XPM
  if (XEN_XpmAttributes_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->depth)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "depth", "a struct with a depth field");
}

static XEN gxm_map_entries(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Visual_P(ptr), ptr, XEN_ONLY_ARG, "map_entries", "Visual");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Visual(ptr))->map_entries)));
}

static XEN gxm_bits_per_rgb(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Visual_P(ptr) || XEN_XVisualInfo_P(ptr), ptr, XEN_ONLY_ARG, "bits_per_rgb", "Visual or XVisualInfo");
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->bits_per_rgb)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_Visual(ptr))->bits_per_rgb)));
}

static XEN gxm_blue_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr) || XEN_Visual_P(ptr) || XEN_XVisualInfo_P(ptr), ptr, XEN_ONLY_ARG, "blue_mask", "a struct with a blue_mask field");
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XImage(ptr))->blue_mask)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->blue_mask)));
  return(C_TO_XEN_INT((long)((XEN_TO_C_Visual(ptr))->blue_mask)));
}

static XEN gxm_green_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr) || XEN_Visual_P(ptr) || XEN_XVisualInfo_P(ptr), ptr, XEN_ONLY_ARG, "green_mask", "a struct with a green_mask field");
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XImage(ptr))->green_mask)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->green_mask)));
  return(C_TO_XEN_INT((long)((XEN_TO_C_Visual(ptr))->green_mask)));
}

static XEN gxm_red_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XImage_P(ptr) || XEN_Visual_P(ptr) || XEN_XVisualInfo_P(ptr), ptr, XEN_ONLY_ARG, "red_mask", "a struct with a red_mask field");
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XImage(ptr))->red_mask)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->red_mask)));
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_Visual(ptr))->red_mask)));
}

static XEN gxm_colormap_size(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XVisualInfo_P(ptr), ptr, XEN_ONLY_ARG, "colormap_size", "XVisualInfo*");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->colormap_size)));
}

static XEN gxm_class(XEN ptr)
{
#ifndef __cplusplus
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->class)));
  if (XEN_Visual_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_Visual(ptr))->class)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->class)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "class", "a struct with a class field");
}

static XEN gxm_visualid(XEN ptr)
{
  if (XEN_Visual_P(ptr)) return(C_TO_XEN_ULONG((VisualID)((XEN_TO_C_Visual(ptr))->visualid)));
  if (XEN_XStandardColormap_P(ptr)) return(C_TO_XEN_ULONG((VisualID)((XEN_TO_C_XStandardColormap(ptr))->visualid)));
  if (XEN_XVisualInfo_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisualInfo(ptr))->visualid)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "visualid", "a struct with a visualid field");
}

static XEN gxm_set_pixel(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Pixel_P(val), val, XEN_ONLY_ARG, "set_pixel", "a Pixel");  
  if (XEN_XColor_P(ptr)) (XEN_TO_C_XColor(ptr))->pixel = XEN_TO_C_Pixel(val);
#if HAVE_XPM
  else if (XEN_XpmColorSymbol_P(ptr)) (XEN_TO_C_XpmColorSymbol(ptr))->pixel = XEN_TO_C_Pixel(val);
#endif
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_pixel", "a struct with a pixel field");
  return(val);
}

static XEN gxm_pixel(XEN ptr)
{
  if (XEN_XColor_P(ptr)) return(C_TO_XEN_Pixel((Pixel)((XEN_TO_C_XColor(ptr))->pixel)));
#if HAVE_MOTIF
  if (XEN_XmScrollBarCallbackStruct_P(ptr)) return(C_TO_XEN_Pixel((Pixel)((XEN_TO_C_XmScrollBarCallbackStruct(ptr))->pixel)));
#endif
#if HAVE_XPM
  if (XEN_XpmColorSymbol_P(ptr)) return(C_TO_XEN_Pixel((Pixel)((XEN_TO_C_XpmColorSymbol(ptr))->pixel)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "pixel", "a struct with a pixel field");
}

static XEN gxm_window_group(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "window_group", "XWMHints");
  return(C_TO_XEN_ULONG((XID)((XEN_TO_C_XWMHints(ptr))->window_group)));
}

static XEN gxm_icon_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "icon_mask", "XWMHints");
  return(C_TO_XEN_Pixmap((Pixmap)((XEN_TO_C_XWMHints(ptr))->icon_mask)));
}

static XEN gxm_icon_y(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "icon_y", "XWMHints");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XWMHints(ptr))->icon_y)));
}

static XEN gxm_icon_x(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "icon_x", "XWMHints");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XWMHints(ptr))->icon_x)));
}

static XEN gxm_icon_window(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "icon_window", "XWMHints");
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XWMHints(ptr))->icon_window)));
}

static XEN gxm_icon_pixmap(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "icon_pixmap", "XWMHints");
  return(C_TO_XEN_Pixmap((Pixmap)((XEN_TO_C_XWMHints(ptr))->icon_pixmap)));
}

static XEN gxm_initial_state(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "initial_state", "XWMHints");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XWMHints(ptr))->initial_state)));
}

static XEN gxm_input(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XWMHints_P(ptr), ptr, XEN_ONLY_ARG, "input", "XWMHints");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XWMHints(ptr))->input)));
}

static XEN gxm_flags(XEN ptr)
{
  if (XEN_XColor_P(ptr)) return(C_TO_XEN_char((char)((XEN_TO_C_XColor(ptr))->flags)));
#if MOTIF_2
  if (XEN_XmSelectionCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmSelectionCallbackStruct(ptr))->flags)));
  if (XEN_XmDestinationCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDestinationCallbackStruct(ptr))->flags)));
  if (XEN_XmConvertCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmConvertCallbackStruct(ptr))->flags)));
#endif
  if (XEN_XWMHints_P(ptr)) return(C_TO_XEN_INT((long)((XEN_TO_C_XWMHints(ptr))->flags)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "flags", "a struct with a flags field");
}

static XEN gxm_set_flags(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XColor_P(ptr), ptr, XEN_ONLY_ARG, "set_flags", "XColor");
  (XEN_TO_C_XColor(ptr))->flags = XEN_TO_C_char(val);
  return(val);
}

static XEN gxm_per_char(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr), ptr, XEN_ONLY_ARG, "per_char", "XFontStruct");
  return(C_TO_XEN_XCharStruct((XCharStruct *)((XEN_TO_C_XFontStruct(ptr))->per_char)));
}

static XEN gxm_max_bounds(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr), ptr, XEN_ONLY_ARG, "max_bounds", "XFontStruct");
  return(C_TO_XEN_XCharStruct((XCharStruct *)(&(XEN_TO_C_XFontStruct(ptr))->max_bounds)));
}

static XEN gxm_min_bounds(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr), ptr, XEN_ONLY_ARG, "min_bounds", "XFontStruct");
  return(C_TO_XEN_XCharStruct((XCharStruct *)(&(XEN_TO_C_XFontStruct(ptr))->min_bounds)));
}

static XEN gxm_min_height(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "min_height", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->min_height)));
}

static XEN gxm_min_width(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "min_width", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->min_width)));
}

static XEN gxm_max_height(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "max_height", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->max_height)));
}

static XEN gxm_max_width(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "max_width", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->max_width)));
}

static XEN gxm_height_inc(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "height_inc", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->height_inc)));
}

static XEN gxm_width_inc(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XIconSize_P(ptr), ptr, XEN_ONLY_ARG, "width_inc", "XIconSize");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XIconSize(ptr))->width_inc)));
}

static XEN gxm_properties(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr), ptr, XEN_ONLY_ARG, "properties", "XFontStruct");
  return(C_TO_XEN_XFontProp((XFontProp *)((XEN_TO_C_XFontStruct(ptr))->properties)));
}

static XEN gxm_fid(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr), ptr, XEN_ONLY_ARG, "fid", "XFontStruct");
  return(C_TO_XEN_Font((Font)((XEN_TO_C_XFontStruct(ptr))->fid)));
}

static XEN gxm_card32(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontProp_P(ptr), ptr, XEN_ONLY_ARG, "card32", "XFontProp");
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XFontProp(ptr))->card32)));
}

static XEN gxm_set_name(XEN ptr, XEN val)
{
#if HAVE_XPM
  XEN_ASSERT_TYPE(XEN_STRING_P(val), val, XEN_ARG_2, "set_name", "a string");
  XEN_ASSERT_TYPE(XEN_XpmColorSymbol_P(ptr), ptr, XEN_ARG_1, "set_name", "XpmColorSymbol");
  (XEN_TO_C_XpmColorSymbol(ptr))->name = XEN_TO_C_STRING(val);
#endif
  return(val);
}

static XEN gxm_name(XEN ptr)
{
  if (XEN_XFontProp_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XFontProp(ptr))->name)));
#if HAVE_XPM
  if (XEN_XpmColorSymbol_P(ptr)) return(C_TO_XEN_STRING((char *)((XEN_TO_C_XpmColorSymbol(ptr))->name)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "name", "a struct with a name field");
}

static XEN gxm_attributes(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XCharStruct_P(ptr), ptr, XEN_ONLY_ARG, "attributes", "XCharStruct");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->attributes)));
}

static XEN gxm_descent(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr) || XEN_XCharStruct_P(ptr), ptr, XEN_ONLY_ARG, "descent", "a struct with a descent field");
  if (XEN_XFontStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XFontStruct(ptr))->descent)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->descent)));
}

static XEN gxm_ascent(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFontStruct_P(ptr) || XEN_XCharStruct_P(ptr), ptr, XEN_ONLY_ARG, "ascent", "a struct with an ascent field");
  if (XEN_XFontStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XFontStruct(ptr))->ascent)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->ascent)));
}

static XEN gxm_rbearing(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XCharStruct_P(ptr), ptr, XEN_ONLY_ARG, "rbearing", "XCharStruct");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->rbearing)));
}

static XEN gxm_lbearing(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XCharStruct_P(ptr), ptr, XEN_ONLY_ARG, "lbearing", "XCharStruct");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->lbearing)));
}

static XEN gxm_request_code(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ONLY_ARG, "request_code", "XErrorEvent");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XErrorEvent(ptr))->request_code)));
}

static XEN gxm_set_request_code(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set request_code", "an integer");
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ARG_1, "set request_code", "XErrorEvent");
  (XEN_TO_C_XErrorEvent(ptr))->request_code = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_error_code(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ONLY_ARG, "error_code", "XErrorEvent");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XErrorEvent(ptr))->error_code)));
}

static XEN gxm_set_error_code(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set error_code", "an integer");
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ARG_1, "set error_code", "XErrorEvent");
  (XEN_TO_C_XErrorEvent(ptr))->error_code = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_resourceid(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ONLY_ARG, "resourceid", "XErrorEvent");
  return(C_TO_XEN_ULONG((XID)((XEN_TO_C_XErrorEvent(ptr))->resourceid)));
}

static XEN gxm_set_resourceid(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_ULONG_P(val), val, XEN_ARG_2, "set resourceid", "an XID");
  XEN_ASSERT_TYPE(XEN_XErrorEvent_P(ptr), ptr, XEN_ARG_1, "set resourceid", "XErrorEvent");
  (XEN_TO_C_XErrorEvent(ptr))->resourceid = (XID)XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_first_keycode(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XMappingEvent_P(ptr), ptr, XEN_ONLY_ARG, "first_keycode", "XMappingEvent");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XMappingEvent(ptr))->first_keycode)));
}

static XEN gxm_set_first_keycode(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set first_keycode", "an integer");
  XEN_ASSERT_TYPE(XEN_XMappingEvent_P(ptr), ptr, XEN_ARG_1, "set first_keycode", "XMappingEvent");
  (XEN_TO_C_XMappingEvent(ptr))->first_keycode = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_request(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XMappingEvent_P(ptr), ptr, XEN_ONLY_ARG, "request", "XMappingEvent");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XMappingEvent(ptr))->request)));
}

static XEN gxm_set_request(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set request", "an integer");
  XEN_ASSERT_TYPE(XEN_XMappingEvent_P(ptr), ptr, XEN_ARG_1, "set request", "XMappingEvent");
  (XEN_TO_C_XMappingEvent(ptr))->request = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_format(XEN ptr)
{
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->format)));
#if HAVE_MOTIF_2
  if (XEN_XmSelectionCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmSelectionCallbackStruct(ptr))->format)));
  if (XEN_XmConvertCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmConvertCallbackStruct(ptr))->format)));
#endif
#if HAVE_MOTIF
  if (XEN_XmTextBlock_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmTextBlock(ptr))->format)));
#endif
  if (XEN_XClientMessageEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XClientMessageEvent(ptr))->format)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "format", "XClientMessageEvent");
}

static XEN gxm_set_format(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set format", "an integer");
  if (XEN_XClientMessageEvent_P(ptr)) (XEN_TO_C_XClientMessageEvent(ptr))->format = XEN_TO_C_INT(val);
#if HAVE_MOTIF
  else if (XEN_XmTextBlock_P(ptr)) (XEN_TO_C_XmTextBlock(ptr))->format = XEN_TO_C_INT(val);
#endif
  else XEN_ASSERT_TYPE(0, ptr, XEN_ARG_1, "set format", "XClientMessageEvent or XmTextBlock");
  return(val);
}

static XEN gxm_message_type(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XClientMessageEvent_P(ptr), ptr, XEN_ONLY_ARG, "message_type", "XClientMessageEvent");
  return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XClientMessageEvent(ptr))->message_type)));
}

static XEN gxm_set_message_type(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Atom_P(val), val, XEN_ARG_2, "set message_type", "an Atom");
  XEN_ASSERT_TYPE(XEN_XClientMessageEvent_P(ptr), ptr, XEN_ARG_1, "set message_type", "XClientMessageEvent");
  (XEN_TO_C_XClientMessageEvent(ptr))->message_type = XEN_TO_C_Atom(val);
  return(val);
}

static XEN gxm_new(XEN ptr)
{
#ifndef __cplusplus
  XEN_ASSERT_TYPE(XEN_XColormapEvent_P(ptr), ptr, XEN_ONLY_ARG, "new", "XColormapEvent");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XColormapEvent(ptr))->new)));
#endif
  return(XEN_FALSE);
}

static XEN gxm_set_new(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ONLY_ARG, "set new", "a boolean");
#ifndef __cplusplus
  if (XEN_XColormapEvent_P(ptr)) (XEN_TO_C_XColormapEvent(ptr))->new = XEN_TO_C_BOOLEAN(val);
  else 
#endif
    XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set new", "XColormapEvent");
  return(val);
}

static XEN gxm_colormap(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_XWindowAttributes(ptr))->colormap)));
  if (XEN_XSetWindowAttributes_P(ptr)) return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_XSetWindowAttributes(ptr))->colormap)));
  if (XEN_XColormapEvent_P(ptr)) return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_XColormapEvent(ptr))->colormap)));
  if (XEN_XStandardColormap_P(ptr)) return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_XStandardColormap(ptr))->colormap)));
#if HAVE_XPM
  if (XEN_XpmAttributes_P(ptr)) return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_XpmAttributes(ptr))->colormap)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "colormap", "a struct with a colormap field");
}

static XEN gxm_set_colormap(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Colormap_P(val), val, XEN_ONLY_ARG, "set_colormap", "a Colormap");
#if HAVE_XPM
  if (XEN_XpmAttributes_P(ptr)) (XEN_TO_C_XpmAttributes(ptr))->colormap = XEN_TO_C_Colormap(val);
  else 
#endif
    if (XEN_XColormapEvent_P(ptr)) (XEN_TO_C_XColormapEvent(ptr))->colormap = XEN_TO_C_Colormap(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_colormap", "XpmAttributes or XColormapEvent");
  return(val);
}

static XEN gxm_property(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSelectionEvent_P(ptr) || XEN_XSelectionRequestEvent_P(ptr), ptr, XEN_ONLY_ARG, "property", "a struct with a property field");
  if (XEN_XSelectionEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionEvent(ptr))->property)));
  return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionRequestEvent(ptr))->property)));
}

static XEN gxm_set_property(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Atom_P(val), val, XEN_ONLY_ARG, "set_property", "an Atom");
  if (XEN_XSelectionEvent_P(ptr)) (XEN_TO_C_XSelectionEvent(ptr))->property = XEN_TO_C_Atom(val);
  else if (XEN_XSelectionRequestEvent_P(ptr)) (XEN_TO_C_XSelectionRequestEvent(ptr))->property = XEN_TO_C_Atom(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "property", "XSelection(Request)Event");
  return(val);
}

static XEN gxm_target(XEN ptr)
{
#if MOTIF_2
  if (XEN_XmPopupHandlerCallbackStruct_P(ptr)) return(C_TO_XEN_Widget((Widget)((XEN_TO_C_XmPopupHandlerCallbackStruct(ptr))->target)));
  if (XEN_XmSelectionCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmSelectionCallbackStruct(ptr))->target)));
  if (XEN_XmConvertCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmConvertCallbackStruct(ptr))->target)));
#endif
  if (XEN_XSelectionEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionEvent(ptr))->target)));
  if (XEN_XSelectionRequestEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionRequestEvent(ptr))->target)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "target", "a struct with a target field");
}

static XEN gxm_set_target(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Atom_P(val), val, XEN_ONLY_ARG, "set_target", "an Atom");
  if (XEN_XSelectionEvent_P(ptr)) (XEN_TO_C_XSelectionEvent(ptr))->target = XEN_TO_C_Atom(val);
  else if (XEN_XSelectionRequestEvent_P(ptr)) (XEN_TO_C_XSelectionRequestEvent(ptr))->target = XEN_TO_C_Atom(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "target", "XSelection(Request)Event");
  return(val);
}

static XEN gxm_requestor(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSelectionEvent_P(ptr) || XEN_XSelectionRequestEvent_P(ptr), ptr, XEN_ONLY_ARG, "requestor", "a struct with a requestor field");
  if (XEN_XSelectionEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XSelectionEvent(ptr))->requestor)));
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XSelectionRequestEvent(ptr))->requestor)));
}

static XEN gxm_set_requestor(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set_requestor", "a Window");
  if (XEN_XSelectionEvent_P(ptr)) (XEN_TO_C_XSelectionEvent(ptr))->requestor = XEN_TO_C_Window(val);
  else if (XEN_XSelectionRequestEvent_P(ptr)) (XEN_TO_C_XSelectionRequestEvent(ptr))->requestor = XEN_TO_C_Window(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "requestor", "XSelection(Request)Event");
  return(val);
}

static XEN gxm_owner(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XSelectionRequestEvent_P(ptr), ptr, XEN_ONLY_ARG, "owner", "XSelectionRequestEvent");
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XSelectionRequestEvent(ptr))->owner)));
}

static XEN gxm_set_owner(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ARG_2, "set_owner", "a Window");
  XEN_ASSERT_TYPE(XEN_XSelectionRequestEvent_P(ptr), ptr, XEN_ARG_1, "owner", "XSelectionRequestEvent");
  (XEN_TO_C_XSelectionRequestEvent(ptr))->owner = XEN_TO_C_Window(val);
  return(val);
}

static XEN gxm_selection(XEN ptr)
{
#if MOTIF_2
  if (XEN_XmTransferDoneCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmTransferDoneCallbackStruct(ptr))->selection)));
  if (XEN_XmSelectionCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmSelectionCallbackStruct(ptr))->selection)));
  if (XEN_XmDestinationCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmDestinationCallbackStruct(ptr))->selection)));
  if (XEN_XmConvertCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmConvertCallbackStruct(ptr))->selection)));
#endif
  if (XEN_XSelectionEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionEvent(ptr))->selection)));
  if (XEN_XSelectionRequestEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionRequestEvent(ptr))->selection)));
  if (XEN_XSelectionClearEvent_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XSelectionClearEvent(ptr))->selection)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "selection", "a struct with a selection field");
}

static XEN gxm_set_selection(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Atom_P(val), val, XEN_ONLY_ARG, "set_selection", "an Atom");
  if (XEN_XSelectionEvent_P(ptr)) (XEN_TO_C_XSelectionEvent(ptr))->selection = XEN_TO_C_Atom(val);
  else if (XEN_XSelectionRequestEvent_P(ptr)) (XEN_TO_C_XSelectionRequestEvent(ptr))->selection = XEN_TO_C_Atom(val);
  else if (XEN_XSelectionClearEvent_P(ptr)) (XEN_TO_C_XSelectionClearEvent(ptr))->selection = XEN_TO_C_Atom(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set selection", "XSelection(Request|Clear)Event");
  return(val);
}

static XEN gxm_atom(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XPropertyEvent_P(ptr), ptr, XEN_ONLY_ARG, "atom", "XPropertyEvent");
  return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XPropertyEvent(ptr))->atom)));
}

static XEN gxm_set_atom(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Atom_P(val), val, XEN_ARG_2, "set_atom", "an Atom");
  XEN_ASSERT_TYPE(XEN_XPropertyEvent_P(ptr), ptr, XEN_ARG_1, "set atom", "XPropertyEvent");
  (XEN_TO_C_XPropertyEvent(ptr))->atom = XEN_TO_C_Atom(val);
  return(val);
}

static XEN gxm_place(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XCirculateRequestEvent_P(ptr) || XEN_XCirculateEvent_P(ptr), ptr, XEN_ONLY_ARG, "place", "a struct with a place field");
  if (XEN_XCirculateRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCirculateRequestEvent(ptr))->place)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCirculateEvent(ptr))->place)));
}

static XEN gxm_set_place(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set_place", "an integer");
  if (XEN_XCirculateRequestEvent_P(ptr)) (XEN_TO_C_XCirculateRequestEvent(ptr))->place = XEN_TO_C_INT(val);
  else if (XEN_XCirculateEvent_P(ptr)) (XEN_TO_C_XCirculateEvent(ptr))->place = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set place", "a struct with a place field");
  return(val);
}

static XEN gxm_value_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XConfigureRequestEvent_P(ptr), ptr, XEN_ONLY_ARG, "value_mask", "XConfigureRequestEvent");
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XConfigureRequestEvent(ptr))->value_mask)));
}

static XEN gxm_set_value_mask(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_ULONG_P(val), val, XEN_ARG_2, "set_value_mask", "an unsigned long");
  XEN_ASSERT_TYPE(XEN_XConfigureRequestEvent_P(ptr), ptr, XEN_ARG_1, "set value_mask", "XConfigureRequestEvent");
  (XEN_TO_C_XConfigureRequestEvent(ptr))->value_mask = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_above(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XConfigureRequestEvent_P(ptr) || XEN_XConfigureEvent_P(ptr), ptr, XEN_ONLY_ARG, "above", "a struct with an above field");
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XConfigureRequestEvent(ptr))->above)));
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XConfigureEvent(ptr))->above)));
}

static XEN gxm_set_above(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set above", "a Window");
  if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->above = XEN_TO_C_Window(val);
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->above = XEN_TO_C_Window(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set above", "a struct with an above field");
  return(val);
}

static XEN gxm_from_configure(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XUnmapEvent_P(ptr), ptr, XEN_ONLY_ARG, "from_configure", "XUnmapEvent");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XUnmapEvent(ptr))->from_configure)));
}

static XEN gxm_set_from_configure(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ARG_2, "set from_configure", "a boolean");
  XEN_ASSERT_TYPE(XEN_XUnmapEvent_P(ptr), ptr, XEN_ARG_1, "set from_configure", "XUnmapEvent");
  (XEN_TO_C_XUnmapEvent(ptr))->from_configure = XEN_TO_C_BOOLEAN(val);
  return(val);
}


static XEN gxm_event(XEN ptr)
{
  /* Xlib.h says event is a window in these cases -- kinda strange looking */
  if (XEN_XCirculateEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XCirculateEvent(ptr))->event)));
  if (XEN_XGravityEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XGravityEvent(ptr))->event)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XConfigureEvent(ptr))->event)));
  if (XEN_XReparentEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XReparentEvent(ptr))->event)));
  if (XEN_XMapEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XMapEvent(ptr))->event)));
  if (XEN_XUnmapEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XUnmapEvent(ptr))->event)));
  if (XEN_XDestroyWindowEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XDestroyWindowEvent(ptr))->event)));
#if HAVE_MOTIF
  if (XEN_AnyCallbackStruct_P(ptr)) return(C_TO_XEN_XEvent((XEvent *)((XEN_TO_C_XmAnyCallbackStruct(ptr))->event)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "event", "a struct with an event field");
}

static XEN gxm_set_event(XEN ptr, XEN val)
{
  if (XEN_XCirculateEvent_P(ptr)) (XEN_TO_C_XCirculateEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XGravityEvent_P(ptr)) (XEN_TO_C_XGravityEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XReparentEvent_P(ptr)) (XEN_TO_C_XReparentEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XMapEvent_P(ptr)) (XEN_TO_C_XMapEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XUnmapEvent_P(ptr)) (XEN_TO_C_XUnmapEvent(ptr))->event = XEN_TO_C_Window(val); else
  if (XEN_XDestroyWindowEvent_P(ptr)) (XEN_TO_C_XDestroyWindowEvent(ptr))->event = XEN_TO_C_Window(val); else
#if HAVE_MOTIF
  if (XEN_AnyCallbackStruct_P(ptr)) (XEN_TO_C_XmAnyCallbackStruct(ptr))->event = XEN_TO_C_XEvent(val); else
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ARG_1, "set event", "a struct with an event field");
  return(val);
}

static XEN gxm_override_redirect(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XWindowAttributes(ptr))->override_redirect)));
  if (XEN_XSetWindowAttributes_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XSetWindowAttributes(ptr))->override_redirect)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XConfigureEvent(ptr))->override_redirect)));
  if (XEN_XReparentEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XReparentEvent(ptr))->override_redirect)));
  if (XEN_XMapEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XMapEvent(ptr))->override_redirect)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XCreateWindowEvent(ptr))->override_redirect)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "override_redirect", "a struct with an override_redirect field");
}

static XEN gxm_set_override_redirect(XEN ptr, XEN val)
{
  Bool b;
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ONLY_ARG, "set override_redirect", "a boolean");
  b = (Bool)XEN_TO_C_BOOLEAN(val);
  if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->override_redirect = b;
  else if (XEN_XReparentEvent_P(ptr)) (XEN_TO_C_XReparentEvent(ptr))->override_redirect = b;
  else if (XEN_XMapEvent_P(ptr)) (XEN_TO_C_XMapEvent(ptr))->override_redirect = b;
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->override_redirect = b;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set override_redirect", "a struct with an override_redirect field");
  return(val);
}

static XEN gxm_border_width(XEN ptr)
{
  if (XEN_XWindowChanges_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->border_width)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->border_width)));
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->border_width)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureEvent(ptr))->border_width)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCreateWindowEvent(ptr))->border_width)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "border_width", "a struct with a border_width field");
}

static XEN gxm_set_border_width(XEN ptr, XEN val)
{
  int wid;
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set border_width", "an integer");
  wid = XEN_TO_C_INT(val);
  if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->border_width = wid;
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->border_width = wid;
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->border_width = wid;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "border_width", "a struct with a border_width field");
  return(val);
}

static XEN gxm_parent(XEN ptr)
{
  if (XEN_XCirculateRequestEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XCirculateRequestEvent(ptr))->parent)));
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XConfigureRequestEvent(ptr))->parent)));
  if (XEN_XReparentEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XReparentEvent(ptr))->parent)));
  if (XEN_XMapRequestEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XMapRequestEvent(ptr))->parent)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XCreateWindowEvent(ptr))->parent)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "parent", "a struct with a parent field");
}

static XEN gxm_set_parent(XEN ptr, XEN val)
{
  Window w;
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set parent", "a Window");
  w = XEN_TO_C_Window(val);
  if (XEN_XCirculateRequestEvent_P(ptr)) (XEN_TO_C_XCirculateRequestEvent(ptr))->parent = w;
  else if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->parent = w;
  else if (XEN_XReparentEvent_P(ptr)) (XEN_TO_C_XReparentEvent(ptr))->parent = w;
  else if (XEN_XMapRequestEvent_P(ptr)) (XEN_TO_C_XMapRequestEvent(ptr))->parent = w;
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->parent= w;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set parent", "a struct with a parent field");
  return(val);
}

static XEN gxm_minor_code(XEN ptr)
{
  if (XEN_XErrorEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XErrorEvent(ptr))->minor_code)));
  if (XEN_XNoExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XNoExposeEvent(ptr))->minor_code)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->minor_code)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "minor_code", "a struct with a minor_code field");
}

static XEN gxm_set_minor_code(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set minor_code", "an integer");
  if (XEN_XErrorEvent_P(ptr)) (XEN_TO_C_XErrorEvent(ptr))->minor_code = XEN_TO_C_INT(val);
  else if (XEN_XNoExposeEvent_P(ptr)) (XEN_TO_C_XNoExposeEvent(ptr))->minor_code = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->minor_code = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set minor_code", "a struct with a minor_code field");
  return(val);
}

static XEN gxm_major_code(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XNoExposeEvent_P(ptr) || XEN_XGraphicsExposeEvent_P(ptr), ptr, XEN_ONLY_ARG, "major_code", "a struct with a major_code field");
  if (XEN_XNoExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XNoExposeEvent(ptr))->major_code)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->major_code)));
}

static XEN gxm_set_major_code(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set major_code", "an integer");
  if (XEN_XNoExposeEvent_P(ptr)) (XEN_TO_C_XNoExposeEvent(ptr))->major_code = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->major_code = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set major_code", "a struct with a major_code field");
  return(val);
}

static XEN gxm_drawable(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XNoExposeEvent_P(ptr) || XEN_XGraphicsExposeEvent_P(ptr), ptr, XEN_ONLY_ARG, "drawable", "a struct with a drawable field");
  if (XEN_XNoExposeEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XNoExposeEvent(ptr))->drawable)));
  return(C_TO_XEN_Window((Window)((XEN_TO_C_XGraphicsExposeEvent(ptr))->drawable)));
}

static XEN gxm_set_drawable(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set drawable", "a Window");
  if (XEN_XNoExposeEvent_P(ptr)) (XEN_TO_C_XNoExposeEvent(ptr))->drawable = XEN_TO_C_Window(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->drawable = XEN_TO_C_Window(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set drawable", "a struct with a drawable field");
  return(val);
}

static XEN gxm_count(XEN ptr)
{
  if (XEN_XMappingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XMappingEvent(ptr))->count)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->count)));
  if (XEN_XExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XExposeEvent(ptr))->count)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "count", "a struct with a count field");
}

static XEN gxm_set_count(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set count", "an integer");
  if (XEN_XMappingEvent_P(ptr)) (XEN_TO_C_XMappingEvent(ptr))->count = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->count = XEN_TO_C_INT(val);
  else if (XEN_XExposeEvent_P(ptr)) (XEN_TO_C_XExposeEvent(ptr))->count = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set count", "a struct with a count field");
  return(val);
}

static XEN gxm_key_vector(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XKeymapEvent_P(ptr), ptr, XEN_ONLY_ARG, "key_vector", "XKeymapEvent");
  return(C_TO_XEN_STRING((char *)((XEN_TO_C_XKeymapEvent(ptr))->key_vector)));
}

static XEN gxm_set_key_vector(XEN ptr, XEN val)
{
  char *keys;
  int i;
  XEN_ASSERT_TYPE(XEN_STRING_P(val), val, XEN_ONLY_ARG, "set key_vector", "a string");
  keys = XEN_TO_C_STRING(val);
  if (XEN_XKeymapEvent_P(ptr))
    {
      for (i = 0; i < 32; i++)
	(XEN_TO_C_XKeymapEvent(ptr))->key_vector[i] = keys[i];
    }
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set key_vector", "XKeymapEvent");
  return(val);
}

static XEN gxm_focus(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XCrossingEvent_P(ptr), ptr, XEN_ONLY_ARG, "focus", "XCrossingEvent");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XCrossingEvent(ptr))->focus)));
}

static XEN gxm_set_focus(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ONLY_ARG, "set focus", "a boolean");
  XEN_ASSERT_TYPE(XEN_XCrossingEvent_P(ptr), ptr, XEN_ONLY_ARG, "set focus", "XCrossingEvent");
  (XEN_TO_C_XCrossingEvent(ptr))->focus = (Bool)XEN_TO_C_BOOLEAN(val);
  return(val);
}

static XEN gxm_detail(XEN ptr)
{
#if MOTIF_2 && HAVE_XP
  if (XEN_XmPrintShellCallbackStruct_P(ptr)) return(C_TO_XEN_ULONG((XtPointer)((XEN_TO_C_XmPrintShellCallbackStruct(ptr))->detail)));
#endif
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->detail)));
  if (XEN_XFocusChangeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XFocusChangeEvent(ptr))->detail)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->detail)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "detail", "a struct with a detail field");
}

static XEN gxm_set_detail(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set detail", "an integer");
  if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->detail = XEN_TO_C_INT(val);
  else if (XEN_XFocusChangeEvent_P(ptr)) (XEN_TO_C_XFocusChangeEvent(ptr))->detail = XEN_TO_C_INT(val);
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->detail = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set detail", "a struct with a detail field");
  return(val);
}

static XEN gxm_mode(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XFocusChangeEvent_P(ptr) || XEN_XCrossingEvent_P(ptr), ptr, XEN_ONLY_ARG, "mode", "a struct with a mode field");
  if (XEN_XFocusChangeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XFocusChangeEvent(ptr))->mode)));
  return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->mode)));
}

static XEN gxm_set_mode(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set mode", "an integer");
  if (XEN_XFocusChangeEvent_P(ptr)) (XEN_TO_C_XFocusChangeEvent(ptr))->mode = XEN_TO_C_INT(val);
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->mode  = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set mode", "a struct with a mode field");
  return(val);
}

static XEN gxm_is_hint(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XMotionEvent_P(ptr), ptr, XEN_ONLY_ARG, "is_hint", "XMotionEvent");
  return(C_TO_XEN_char((char)((XEN_TO_C_XMotionEvent(ptr))->is_hint)));
}

static XEN gxm_set_is_hint(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set is_hint", "an integer");
  XEN_ASSERT_TYPE(XEN_XMotionEvent_P(ptr), ptr, XEN_ARG_1, "set is_hint", "XMotionEvent");
  (XEN_TO_C_XMotionEvent(ptr))->is_hint = (char)XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_button(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XButtonEvent_P(ptr), ptr, XEN_ONLY_ARG, "button", "XButtonEvent");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XButtonEvent(ptr))->button)));
}

static XEN gxm_set_button(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_ULONG_P(val), val, XEN_ARG_2, "set button", "an unsigned long");
  XEN_ASSERT_TYPE(XEN_XButtonEvent_P(ptr), ptr, XEN_ARG_1, "set button", "XButtonEvent");
  (XEN_TO_C_XButtonEvent(ptr))->button = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_same_screen(XEN ptr)
{
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XCrossingEvent(ptr))->same_screen)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XMotionEvent(ptr))->same_screen)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XButtonEvent(ptr))->same_screen)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XKeyEvent(ptr))->same_screen)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "same_screen", "a struct with a same_screen field");
}

static XEN gxm_set_same_screen(XEN ptr, XEN val)
{
  Bool b;
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ONLY_ARG, "set same_screen", "a boolean");
  b = (Bool)XEN_TO_C_BOOLEAN(val);
  if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->same_screen = b;
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->same_screen = b;
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->same_screen = b;
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->same_screen = b;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set same_screen", "a struct with a same_screen field");
  return(val);
}

static XEN gxm_keycode(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XKeyEvent_P(ptr), ptr, XEN_ONLY_ARG, "keycode", "XKeyEvent");
  return(C_TO_XEN_KeyCode((XEN_TO_C_XKeyEvent(ptr))->keycode));
}

static XEN gxm_set_keycode(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_KeyCode_P(val), val, XEN_ARG_2, "set keycode", "a KeyCode");
  XEN_ASSERT_TYPE(XEN_XKeyEvent_P(ptr), ptr, XEN_ARG_1, "set keycode", "XKeyEvent");
  (XEN_TO_C_XKeyEvent(ptr))->keycode = XEN_TO_C_KeyCode(val);
  return(val);
}

static XEN gxm_state(XEN ptr)
{
  if (XEN_XColormapEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XColormapEvent(ptr))->state)));
  if (XEN_XPropertyEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XPropertyEvent(ptr))->state)));
  if (XEN_XVisibilityEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XVisibilityEvent(ptr))->state)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XCrossingEvent(ptr))->state)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XMotionEvent(ptr))->state)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XButtonEvent(ptr))->state)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XKeyEvent(ptr))->state)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "state", "a struct with a state field");
}

static XEN gxm_set_state(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val) || XEN_ULONG_P(val), val, XEN_ONLY_ARG, "set state", "an integer");
  if (XEN_XColormapEvent_P(ptr)) (XEN_TO_C_XColormapEvent(ptr))->state = XEN_TO_C_INT(val);
  else if (XEN_XPropertyEvent_P(ptr)) (XEN_TO_C_XPropertyEvent(ptr))->state = XEN_TO_C_INT(val);
  else if (XEN_XVisibilityEvent_P(ptr)) (XEN_TO_C_XVisibilityEvent(ptr))->state = XEN_TO_C_INT(val);
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->state = XEN_TO_C_ULONG(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->state = XEN_TO_C_ULONG(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->state = XEN_TO_C_ULONG(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->state = XEN_TO_C_ULONG(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set state", "a struct with a state field");
  return(val);
}

static XEN gxm_y_root(XEN ptr)
{
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->y_root)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XMotionEvent(ptr))->y_root)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XButtonEvent(ptr))->y_root)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XKeyEvent(ptr))->y_root)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "y_root", "a struct with a y_root field");
}

static XEN gxm_set_y_root(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set y_root", "an integer");
  if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->y_root = XEN_TO_C_INT(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->y_root = XEN_TO_C_INT(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->y_root = XEN_TO_C_INT(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->y_root = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set y_root", "a struct with a y_root field");
  return(val);
}

static XEN gxm_x_root(XEN ptr)
{
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->x_root)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XMotionEvent(ptr))->x_root)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XButtonEvent(ptr))->x_root)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XKeyEvent(ptr))->x_root)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "x_root", "a struct with an x_root field");
}

static XEN gxm_set_x_root(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set x_root", "an integer");
  if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->x_root = XEN_TO_C_INT(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->x_root = XEN_TO_C_INT(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->x_root = XEN_TO_C_INT(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->x_root = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set x_root", "a struct with a x_root field");
  return(val);
}

static XEN gxm_set_x(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set_x", "an integer");
  if (XEN_XRectangle_P(ptr)) (XEN_TO_C_XRectangle(ptr))->x = (short)XEN_TO_C_INT(val);
  else if (XEN_XPoint_P(ptr)) (XEN_TO_C_XPoint(ptr))->x = (short)XEN_TO_C_INT(val);
  else if (XEN_XArc_P(ptr)) (XEN_TO_C_XArc(ptr))->x = (short)XEN_TO_C_INT(val);
  else if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XGravityEvent_P(ptr)) (XEN_TO_C_XGravityEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XReparentEvent_P(ptr)) (XEN_TO_C_XReparentEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XExposeEvent_P(ptr)) (XEN_TO_C_XExposeEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->x = XEN_TO_C_INT(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->x = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_x", "a struct with an x field");
  return(val);
}

static XEN gxm_set_y(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ONLY_ARG, "set_y", "an integer");
  if (XEN_XRectangle_P(ptr)) (XEN_TO_C_XRectangle(ptr))->y = (short)XEN_TO_C_INT(val);
  else if (XEN_XPoint_P(ptr)) (XEN_TO_C_XPoint(ptr))->y = (short)XEN_TO_C_INT(val);
  else if (XEN_XArc_P(ptr)) (XEN_TO_C_XArc(ptr))->y = (short)XEN_TO_C_INT(val);
  else if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XGravityEvent_P(ptr)) (XEN_TO_C_XGravityEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XReparentEvent_P(ptr)) (XEN_TO_C_XReparentEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XExposeEvent_P(ptr)) (XEN_TO_C_XExposeEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->y = XEN_TO_C_INT(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->y = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_y", "a struct with a y field");
  return(val);
}

static XEN gxm_y(XEN ptr)
{
  if (XEN_XRectangle_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XRectangle(ptr))->y)));
  if (XEN_XPoint_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XPoint(ptr))->y)));
  if (XEN_XArc_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->y)));
  if (XEN_XWindowChanges_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->y)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->y)));
#if HAVE_MOTIF
  if (XEN_XmDropProcCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropProcCallbackStruct(ptr))->y)));
  if (XEN_XmDragProcCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDragProcCallbackStruct(ptr))->y)));
  if (XEN_XmDropStartCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropStartCallbackStruct(ptr))->y)));
  if (XEN_XmDragMotionCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDragMotionCallbackStruct(ptr))->y)));
  if (XEN_XmDropSiteEnterCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropSiteEnterCallbackStruct(ptr))->y)));
#if HAVE_MOTIF_2
  if (XEN_XmTopLevelEnterCallbackStruct_P(ptr)) return(C_TO_XEN_Position((Position)((XEN_TO_C_XmTopLevelEnterCallbackStruct(ptr))->y)));
#endif
#endif
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->y)));
  if (XEN_XGravityEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGravityEvent(ptr))->y)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureEvent(ptr))->y)));
  if (XEN_XReparentEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XReparentEvent(ptr))->y)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCreateWindowEvent(ptr))->y)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->y)));
  if (XEN_XExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XExposeEvent(ptr))->y)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->y)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XMotionEvent(ptr))->y)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XButtonEvent(ptr))->y)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XKeyEvent(ptr))->y)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "y", "a struct with a y field");
}

static XEN gxm_x(XEN ptr)
{
  if (XEN_XRectangle_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XRectangle(ptr))->x)));
  if (XEN_XPoint_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XPoint(ptr))->x)));
  if (XEN_XArc_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->x)));
  if (XEN_XWindowChanges_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->x)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->x)));
#if HAVE_MOTIF
  if (XEN_XmDropProcCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropProcCallbackStruct(ptr))->x)));
  if (XEN_XmDragProcCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDragProcCallbackStruct(ptr))->x)));
  if (XEN_XmDropStartCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropStartCallbackStruct(ptr))->x)));
  if (XEN_XmDragMotionCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDragMotionCallbackStruct(ptr))->x)));
  if (XEN_XmDropSiteEnterCallbackStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XmDropSiteEnterCallbackStruct(ptr))->x)));
#if HAVE_MOTIF_2
  if (XEN_XmTopLevelEnterCallbackStruct_P(ptr)) return(C_TO_XEN_Position((Position)((XEN_TO_C_XmTopLevelEnterCallbackStruct(ptr))->x)));
#endif
#endif
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->x)));
  if (XEN_XGravityEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGravityEvent(ptr))->x)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureEvent(ptr))->x)));
  if (XEN_XReparentEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XReparentEvent(ptr))->x)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCreateWindowEvent(ptr))->x)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->x)));
  if (XEN_XExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XExposeEvent(ptr))->x)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCrossingEvent(ptr))->x)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XMotionEvent(ptr))->x)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XButtonEvent(ptr))->x)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XKeyEvent(ptr))->x)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "x", "a struct with an x field");
}

static XEN gxm_time(XEN ptr)
{
#if MOTIF_2
  if (XEN_XmDestinationCallbackStruct_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XmDestinationCallbackStruct(ptr))->time)));
#endif
  if (XEN_XSelectionEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XSelectionEvent(ptr))->time)));
  if (XEN_XSelectionRequestEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XSelectionRequestEvent(ptr))->time)));
  if (XEN_XSelectionClearEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XSelectionClearEvent(ptr))->time)));
  if (XEN_XPropertyEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XPropertyEvent(ptr))->time)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XCrossingEvent(ptr))->time)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XMotionEvent(ptr))->time)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XButtonEvent(ptr))->time)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_Time((Time)((XEN_TO_C_XKeyEvent(ptr))->time)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "time", "a struct with a time field");
}

static XEN gxm_set_time(XEN ptr, XEN val)
{
  Time tm;
  XEN_ASSERT_TYPE(XEN_Time_P(val), val, XEN_ONLY_ARG, "set time", "Time");
  tm = XEN_TO_C_Time(val);
  if (XEN_XSelectionEvent_P(ptr)) (XEN_TO_C_XSelectionEvent(ptr))->time = tm;
  else if (XEN_XSelectionRequestEvent_P(ptr)) (XEN_TO_C_XSelectionRequestEvent(ptr))->time = tm;
  else if (XEN_XSelectionClearEvent_P(ptr)) (XEN_TO_C_XSelectionClearEvent(ptr))->time = tm;
  else if (XEN_XPropertyEvent_P(ptr)) (XEN_TO_C_XPropertyEvent(ptr))->time = tm;
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->time = tm;
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->time = tm;
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->time = tm;
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->time = tm;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "time", "a struct with a time field");
  return(val);
}

static XEN gxm_subwindow(XEN ptr)
{
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XCrossingEvent(ptr))->subwindow)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XMotionEvent(ptr))->subwindow)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XButtonEvent(ptr))->subwindow)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XKeyEvent(ptr))->subwindow)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "subwindow", "a struct with a subwindow field");
}

static XEN gxm_set_subwindow(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set subwindow", "a Window");
  if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->subwindow = XEN_TO_C_Window(val);
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->subwindow = XEN_TO_C_Window(val);
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->subwindow = XEN_TO_C_Window(val);
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->subwindow = XEN_TO_C_Window(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set subwindow", "a struct with a subwindow field");
  return(val);
}

static XEN gxm_window(XEN ptr)
{
#if HAVE_MOTIF
  if (XEN_XmDrawnButtonCallbackStruct_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XmDrawnButtonCallbackStruct(ptr))->window)));
  if (XEN_XmDrawingAreaCallbackStruct_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XmDrawingAreaCallbackStruct(ptr))->window)));
  if (XEN_XmDropStartCallbackStruct_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XmDropStartCallbackStruct(ptr))->window)));
#if MOTIF_2
  if (XEN_XmTopLevelEnterCallbackStruct_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XmTopLevelEnterCallbackStruct(ptr))->window)));
  if (XEN_XmTopLevelLeaveCallbackStruct_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XmTopLevelLeaveCallbackStruct(ptr))->window)));
#endif
#endif
  if (XEN_XEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XAnyEvent(ptr))->window)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "window", "a struct with a window field");
}

static XEN gxm_set_window(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set window", "a Window");
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "set window", "XEvent");
  (XEN_TO_C_XAnyEvent(ptr))->window = XEN_TO_C_Window(val);
  return(val);
}

static XEN gxm_send_event(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "send_event", "XEvent");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_XAnyEvent(ptr))->send_event)));
}

static XEN gxm_set_send_event(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_BOOLEAN_P(val), val, XEN_ONLY_ARG, "set send_event", "a boolean");
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "set send_event", "XEvent");
  (XEN_TO_C_XAnyEvent(ptr))->send_event = (Bool)XEN_TO_C_BOOLEAN(val);
  return(val);
}

static XEN gxm_serial(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "serial", "XEvent");
  return(C_TO_XEN_ULONG((ulong)((XEN_TO_C_XAnyEvent(ptr))->serial)));
}

static XEN gxm_set_serial(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "set serial", "XEvent");
  (XEN_TO_C_XAnyEvent(ptr))->serial = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_type(XEN ptr)
{
#if MOTIF_2
  if (XEN_XmSelectionCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmSelectionCallbackStruct(ptr))->type)));
  if (XEN_XmConvertCallbackStruct_P(ptr)) return(C_TO_XEN_Atom((Atom)((XEN_TO_C_XmConvertCallbackStruct(ptr))->type)));
#endif
  if (XEN_XEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XAnyEvent(ptr))->type)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "type", "a struct with a type field");
}

static XEN gxm_set_type(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "set type", "XEvent");
  (XEN_TO_C_XAnyEvent(ptr))->type = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_root_input_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "root_input_mask", "Screen");
  return(C_TO_XEN_INT((long)((XEN_TO_C_Screen(ptr))->root_input_mask)));
}

static XEN gxm_save_unders(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "save_unders", "Screen");
  return(C_TO_XEN_BOOLEAN((Bool)((XEN_TO_C_Screen(ptr))->save_unders)));
}

static XEN gxm_backing_store(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_BOOLEAN((int)((XEN_TO_C_XWindowAttributes(ptr))->backing_store)));
  if (XEN_XSetWindowAttributes_P(ptr)) return(C_TO_XEN_BOOLEAN((int)((XEN_TO_C_XSetWindowAttributes(ptr))->backing_store)));
  if (XEN_Screen_P(ptr)) return(C_TO_XEN_BOOLEAN((int)((XEN_TO_C_Screen(ptr))->backing_store)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "backing_store", "a struct with a backing_store field");
}

static XEN gxm_min_maps(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "min_maps", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->min_maps)));
}

static XEN gxm_max_maps(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "max_maps", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->max_maps)));
}

static XEN gxm_black_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "black_pixel", "Screen");
  return(C_TO_XEN_Pixel((XEN_TO_C_Screen(ptr))->black_pixel));
}

static XEN gxm_white_pixel(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "white_pixel", "Screen");
  return(C_TO_XEN_Pixel((XEN_TO_C_Screen(ptr))->white_pixel));
}

static XEN gxm_cmap(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "cmap", "Screen");
  return(C_TO_XEN_Colormap((Colormap)((XEN_TO_C_Screen(ptr))->cmap)));
}

static XEN gxm_default_gc(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "default_gc", "Screen");
  return(C_TO_XEN_GC((GC)((XEN_TO_C_Screen(ptr))->default_gc)));
}

static XEN gxm_root_visual(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "root_visual", "Screen");
  return(C_TO_XEN_Visual((Visual *)((XEN_TO_C_Screen(ptr))->root_visual)));
}

static XEN gxm_root_depth(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "root_depth", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->root_depth)));
}

static XEN gxm_depths(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "depths", "Screen");
  return(C_TO_XEN_Depth((Depth *)((XEN_TO_C_Screen(ptr))->depths)));
}

static XEN gxm_ndepths(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "ndepths", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->ndepths)));
}

static XEN gxm_mheight(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "mheight", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->mheight)));
}

static XEN gxm_mwidth(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "mwidth", "Screen");
  return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->mwidth)));
}


static XEN gxm_set_height(XEN ptr, XEN val)
{
  if (XEN_XRectangle_P(ptr)) (XEN_TO_C_XRectangle(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XArc_P(ptr)) (XEN_TO_C_XArc(ptr))->height = XEN_TO_C_INT(val);
#if HAVE_XPM
  else if (XEN_XpmImage_P(ptr)) (XEN_TO_C_XpmImage(ptr))->height = XEN_TO_C_ULONG(val);
  else if (XEN_XpmAttributes_P(ptr)) (XEN_TO_C_XpmAttributes(ptr))->height = XEN_TO_C_ULONG(val);
#endif
  else if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XResizeRequestEvent_P(ptr)) (XEN_TO_C_XResizeRequestEvent(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->height = XEN_TO_C_INT(val);
  else if (XEN_XExposeEvent_P(ptr)) (XEN_TO_C_XExposeEvent(ptr))->height = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_height", "a struct with a height field");
  return(val);
}

static XEN gxm_set_width(XEN ptr, XEN val)
{
  if (XEN_XRectangle_P(ptr)) (XEN_TO_C_XRectangle(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XArc_P(ptr)) (XEN_TO_C_XArc(ptr))->width = XEN_TO_C_INT(val);
#if HAVE_XPM
  else if (XEN_XpmImage_P(ptr)) (XEN_TO_C_XpmImage(ptr))->width = XEN_TO_C_ULONG(val);
  else if (XEN_XpmAttributes_P(ptr)) (XEN_TO_C_XpmAttributes(ptr))->width = XEN_TO_C_ULONG(val);
#endif
  else if (XEN_XConfigureRequestEvent_P(ptr)) (XEN_TO_C_XConfigureRequestEvent(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XResizeRequestEvent_P(ptr)) (XEN_TO_C_XResizeRequestEvent(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XConfigureEvent_P(ptr)) (XEN_TO_C_XConfigureEvent(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XCreateWindowEvent_P(ptr)) (XEN_TO_C_XCreateWindowEvent(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XGraphicsExposeEvent_P(ptr)) (XEN_TO_C_XGraphicsExposeEvent(ptr))->width = XEN_TO_C_INT(val);
  else if (XEN_XExposeEvent_P(ptr)) (XEN_TO_C_XExposeEvent(ptr))->width = XEN_TO_C_INT(val);
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set_width", "a struct with a width field");
  return(val);
}

static XEN gxm_height(XEN ptr)
{
  if (XEN_XRectangle_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XRectangle(ptr))->height)));
  if (XEN_XArc_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->height)));
  if (XEN_XWindowChanges_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->height)));
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->height)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->height)));
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->height)));
  if (XEN_XResizeRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XResizeRequestEvent(ptr))->height)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureEvent(ptr))->height)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCreateWindowEvent(ptr))->height)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->height)));
  if (XEN_XExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XExposeEvent(ptr))->height)));
  if (XEN_Screen_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->height)));
#if HAVE_XPM
  if (XEN_XpmImage_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmImage(ptr))->height)));
  if (XEN_XpmAttributes_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->height)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "height", "a struct with a height field");
}

static XEN gxm_width(XEN ptr)
{
  if (XEN_XRectangle_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XRectangle(ptr))->width)));
  if (XEN_XArc_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XArc(ptr))->width)));
  if (XEN_XWindowChanges_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowChanges(ptr))->width)));
  if (XEN_XImage_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XImage(ptr))->width)));
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XWindowAttributes(ptr))->width)));
  if (XEN_XCharStruct_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCharStruct(ptr))->width)));
  if (XEN_XConfigureRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureRequestEvent(ptr))->width)));
  if (XEN_XResizeRequestEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XResizeRequestEvent(ptr))->width)));
  if (XEN_XConfigureEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XConfigureEvent(ptr))->width)));
  if (XEN_XCreateWindowEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XCreateWindowEvent(ptr))->width)));
  if (XEN_XGraphicsExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XGraphicsExposeEvent(ptr))->width)));
  if (XEN_XExposeEvent_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_XExposeEvent(ptr))->width)));
  if (XEN_Screen_P(ptr)) return(C_TO_XEN_INT((int)((XEN_TO_C_Screen(ptr))->width)));
#if HAVE_XPM
  if (XEN_XpmImage_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmImage(ptr))->width)));
  if (XEN_XpmAttributes_P(ptr)) return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XpmAttributes(ptr))->width)));
#endif
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "width", "a struct with a width field");
}

static XEN gxm_root(XEN ptr)
{
  if (XEN_XWindowAttributes_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XWindowAttributes(ptr))->root)));
  if (XEN_XCrossingEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XCrossingEvent(ptr))->root)));
  if (XEN_XMotionEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XMotionEvent(ptr))->root)));
  if (XEN_XButtonEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XButtonEvent(ptr))->root)));
  if (XEN_XKeyEvent_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_XKeyEvent(ptr))->root)));
  if (XEN_Screen_P(ptr)) return(C_TO_XEN_Window((Window)((XEN_TO_C_Screen(ptr))->root)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "root", "a struct with a root field");
}

static XEN gxm_set_root(XEN ptr, XEN val)
{
  Window w;
  XEN_ASSERT_TYPE(XEN_Window_P(val), val, XEN_ONLY_ARG, "set root", "a Window");
  w = XEN_TO_C_Window(val);
  if (XEN_XWindowAttributes_P(ptr)) (XEN_TO_C_XWindowAttributes(ptr))->root = w;
  else if (XEN_XCrossingEvent_P(ptr)) (XEN_TO_C_XCrossingEvent(ptr))->root = w;
  else if (XEN_XMotionEvent_P(ptr)) (XEN_TO_C_XMotionEvent(ptr))->root = w;
  else if (XEN_XButtonEvent_P(ptr)) (XEN_TO_C_XButtonEvent(ptr))->root = w;
  else if (XEN_XKeyEvent_P(ptr)) (XEN_TO_C_XKeyEvent(ptr))->root = w;
  else if (XEN_Screen_P(ptr)) (XEN_TO_C_Screen(ptr))->root = w;
  else XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "set root", "a struct with a root field");
  return(val);
}

static XEN gxm_display(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr) || XEN_Screen_P(ptr), ptr, XEN_ONLY_ARG, "display", "XEvent or Screen");
  if (XEN_XEvent_P(ptr)) return(C_TO_XEN_Display((Display *)((XEN_TO_C_XAnyEvent(ptr))->display)));
  return(C_TO_XEN_Display((Display *)((XEN_TO_C_Screen(ptr))->display)));
}

static XEN gxm_set_display(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Display_P(val), val, XEN_ONLY_ARG, "set display", "a Display*");
  XEN_ASSERT_TYPE(XEN_XEvent_P(ptr), ptr, XEN_ONLY_ARG, "set display", "XEvent");
  (XEN_TO_C_XAnyEvent(ptr))->display = XEN_TO_C_Display(val);
  return(val);
}

/* XGCValues */

static XEN gxm_function(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "function", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->function)));
}

static XEN gxm_set_function(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_function", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_function", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->function = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_plane_mask(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "plane_mask", "XGCValues");
  return(C_TO_XEN_ULONG((unsigned long)((XEN_TO_C_XGCValues(ptr))->plane_mask)));
}

static XEN gxm_set_plane_mask(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "set_plane_mask", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->plane_mask = XEN_TO_C_ULONG(val);
  return(val);
}

static XEN gxm_foreground(XEN ptr)
{
  if (XEN_XGCValues_P(ptr)) return(C_TO_XEN_Pixel((Pixel)((XEN_TO_C_XGCValues(ptr))->foreground)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "foreground", "a struct with a foreground field");
}

static XEN gxm_set_foreground(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Pixel_P(val), val, XEN_ARG_2, "set_foreground", "a Pixel");  
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_foreground", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->foreground = XEN_TO_C_Pixel(val);
  return(val);
}

static XEN gxm_background(XEN ptr)
{
  if (XEN_XGCValues_P(ptr)) return(C_TO_XEN_Pixel((Pixel)((XEN_TO_C_XGCValues(ptr))->background)));
  XEN_ASSERT_TYPE(0, ptr, XEN_ONLY_ARG, "background", "a struct with a background field");
}

static XEN gxm_set_background(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Pixel_P(val), val, XEN_ARG_2, "set_background", "a Pixel");  
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_background", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->background = XEN_TO_C_Pixel(val);
  return(val);
}

static XEN gxm_line_width(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "line_width", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->line_width)));
}

static XEN gxm_set_line_width(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_line_width", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_line_width", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->line_width = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_line_style(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "line_style", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->line_style)));
}

static XEN gxm_set_line_style(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_line_style", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_line_style", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->line_style = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_cap_style(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "cap_style", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->cap_style)));
}

static XEN gxm_set_cap_style(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_cap_style", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_cap_style", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->cap_style = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_join_style(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "join_style", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->join_style)));
}

static XEN gxm_set_join_style(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_join_style", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_join_style", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->join_style = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_fill_style(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "fill_style", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->fill_style)));
}

static XEN gxm_set_fill_style(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_fill_style", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_fill_style", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->fill_style = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_fill_rule(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "fill_rule", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->fill_rule)));
}

static XEN gxm_set_fill_rule(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_fill_rule", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_fill_rule", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->fill_rule = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_arc_mode(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "arc_mode", "XGCValues");
  return(C_TO_XEN_INT((int)((XEN_TO_C_XGCValues(ptr))->arc_mode)));
}

static XEN gxm_set_arc_mode(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_INTEGER_P(val), val, XEN_ARG_2, "set_arc_mode", "an integer");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_arc_mode", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->arc_mode = XEN_TO_C_INT(val);
  return(val);
}

static XEN gxm_tile(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "tile", "XGCValues");
  return(C_TO_XEN_Pixmap((Pixmap)((XEN_TO_C_XGCValues(ptr))->tile)));
}

static XEN gxm_set_tile(XEN ptr, XEN val)
{
  XEN_ASSERT_TYPE(XEN_Pixmap_P(val), val, XEN_ARG_2, "set_tile", "a Pixmap");
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ARG_1, "set_tile", "XGCValues");
  (XEN_TO_C_XGCValues(ptr))->tile = XEN_TO_C_Pixmap(val);
  return(val);
}

static XEN gxm_stipple(XEN ptr)
{
  XEN_ASSERT_TYPE(XEN_XGCValues_P(ptr), ptr, XEN_ONLY_ARG, "stipple", "XGCValues");
  re