#include "rpggame.h"

/*
This file is to contain ALL function exposed to cubescript that allow the scripting and configuration of entities and game objects
this involves simple things like setting the colour of a projectile to more complex ones like setting dialogue
*/

namespace rpgobj
{
	rpgent *selected;
	void renumerate()
	{
		int num = 0;
		loopv(game::rpgobjs)
		{
			rpgent *d = game::rpgobjs[i];
			d->temp.id = num++;

			rpgchar *c = d->getchar();
			if(c)
			{
				loopvj(c->inventory)
				{
					c->inventory[j]->temp.id = num++;
				}
				loopvj(c->spellbook)
				{
					c->spellbook[j]->temp.id = num++;
				}
			}
		}
		game::lastid = num - 1;
	}

	rpgent *getent(int who)
	{
		loopv(game::rpgobjs)
		{
			if(game::rpgobjs[i]->temp.id == who)
				return game::rpgobjs[i];

			rpgchar *d = game::rpgobjs[i]->getchar();

			if(d)
			{
				loopvj(d->inventory)
				{
					rpgent *item = d->inventory[j];
					if(item->temp.id == who)
						return item;
				}
				loopvj(d->spellbook)
				{
					rpgent *spell = d->spellbook[j];
					if(spell->temp.id == who)
						return spell;
				}
			}
		}

		return NULL;
	}

	int getident(rpgent *d)
	{
		if(d) return d->temp.id;
		return -1;
	}

	ICOMMAND(r_select, "i", (int *id),
		selected = getent(*id);
	);

	ICOMMAND(r_addeffect, "iiii", (int *t, int *s, int *d, int *r),
		if(!selected) return;
		rpgent *e = selected;
		e->effects.add(new status(*t, *s, *d, *r));
	);

	ICOMMAND(r_addowneffect, "iii", (int *t, int *s, int *r),
		if(!selected || selected->etype != ENT_ITEM) return;
		status *st = new status(*t, *s, 0, *r);
		st->duration = -1;

		((rpgitem *) selected->subtype)->owneffects.add(st);
	);


	ICOMMAND(r_additem, "s", (const char *s),
		if(!selected) return;
		rpgent *e = selected;

		if(!e->getchar()) return;
		rpgent *item = new rpgent(DEFAULTMODEL, ++game::lastid);
		selected = item;

		defformatstring(ds)("spawn_%s", s);
		execute(ds);

		if(item->etype == ENT_ITEM)
		{
			e->getchar()->inventory.add(item);
		}
		else if(item->etype == ENT_SPELL)
		{
			e->getchar()->spellbook.add(item);
		}
		else
		{
			conoutf("r_additem: Error adding item to \"%s\", \"%s\" is not a valid item type", e->name, item->name);
			delete item;
		}

		selected = e;
	);

	///TODO WRITEME
	//ICOMMAND(r_applyeffect, "iiiii", ent effect strength duration element

	ICOMMAND(r_destroy, "", (),
		if(selected == game::player1)
		{
			conoutf("Warning: a script just *tried* to delete the player");
			return;
		}

		loopv(game::rpgobjs)
		{
			if(game::rpgobjs[i] == selected)
			{
				delete game::rpgobjs[i];
				game::rpgobjs.remove(i);
				return;
			}
			rpgchar *c = game::rpgobjs[i]->getchar();
			if(c)
			{
				loopvj(c->inventory)
				{
					if(c->inventory[j] == selected)
					{
						game::rpgobjs[i]->dequip(c->inventory[j]);
						delete c->inventory[j];
						c->inventory.remove(j);
						return;
					}
				}
				loopvj(c->spellbook)
				{
					if(c->spellbook[j] == selected)
					{
						delete c->spellbook[j];
						c->spellbook.remove(j);
						return;
					}
				}
			}
		 }

		 selected = NULL;
		 game::hover = NULL;
	);

	 ICOMMAND(r_drop, "", (),
		loopv(game::rpgobjs)
		{
			rpgent *e = game::rpgobjs[i];
			rpgchar *ec = e->getchar();
			if(ec)
			{
				loopvj(ec->inventory)
				{
					if(ec->inventory[j] == selected)
					{
						e->drop(ec->inventory[j]);
						return;
					}
				}
				loopvj(ec->spellbook)
				{
					if(ec->spellbook[j] == selected)
					{
						e->drop(ec->spellbook[j]);
						return;
					}
				}
			}
		}
	);

	ICOMMAND(r_loopinv, "s", (char *s),
		rpgent *ent = selected;
		if(!selected || selected->etype != ENT_CHAR || !s[0])
			return;

		rpgchar *c = (rpgchar *) ent->subtype;
		loopv(c->inventory)
		{
			selected = c->inventory[i];
			execute(s);
		}
		loopv(c->spellbook)
		{
			selected = c->spellbook[i];
			execute(s);
		}
		selected = ent;
	);

	ICOMMAND(r_pickup, "i", (int *i),
		rpgent *d = getent(*i);
		if(!selected || !d) return;

		selected->pickup(d);
	);

	ICOMMAND(r_say, "ss", (const char *t, const char *s),
		if(!selected) return;
		selected->dialogue.add(new rpgchat(newstring(s), newstring(t)))
	);

	ICOMMAND(r_dist, "i", (int *d),
		rpgent *ent = getent(*d);

		if(!ent || !selected)
		{
			floatret(-1);
			return;
		};

		floatret(ent->o.dist(selected->o));
	);

	ICOMMAND(r_face, "i", (int *d),
		if(!selected) return;
		rpgent *vic = getent(*d);

		vec o = vec(vic->o).sub(selected->o).normalize();

		vectoyawpitch(o, selected->yaw, selected->pitch);
	);

	ICOMMAND(r_kill, "", (int *i),
		if(selected)
			selected->die();
	);

	///TODO WRITEME
	//ICOMMAND(r_reset, "ii" ent 'remove corpse'

	ICOMMAND(r_response, "sis", (const char *t, int *d, const char *s),
		if(!game::hover && !game::hover->dialogue.inrange(game::hover->chatpos)) return; //-1, aka closed will fail

		game::hover->dialogue[game::hover->chatpos]->dests.add(new response(newstring(t), *d, newstring(s)));
	);

	ICOMMAND(r_ressurrect, "i", (int *death),
		if(selected)
			selected->respawn(*death);
	);

	ICOMMAND(r_spawn, "si", (const char *sp, int *in),
		loopv(entities::ents)
		{
			extentity *e = entities::ents[i];
			if(e->type == SPAWN)
			{
				if(e->attr2 == *in)
				{
					selected = new rpgent(DEFAULTMODEL, ++game::lastid);
					game::rpgobjs.add(selected);
					selected->o = e->o;

					defformatstring(ds)("spawn_%s", sp);
					execute(ds);
				}
			}
		}
	);

	ICOMMAND(r_talk, "ii", (int *e, int *d),
		rpgent *r = getent(*e);

		if( !r || (selected != game::player1 && r != game::player1)) return;

		game::hover = r;
		//note -1 is closed
		game::hover->chatpos = *d;
		//the GUI will automatically open, as the chat hook looks for game::selected->chatpos >= 0
	);

	ICOMMAND(r_telemap, "s", (const char *map),
		if(!selected) return;
		if(selected != game::player1)
		{
			//TODO allow other creatures to go to other maps
			//TODO 2; allow nearby creatures that're following the player to go with him (eg, to attack him)
			game::rpgobjs.removeobj(selected);
			selected = NULL;
			return;
		}

		game::transfer = true;
		load_world(map);
	);

	ICOMMAND(r_teleport, "i", (int *i, int *d),
		if(!selected) return;
		entities::teleport(*selected, *d);
	);

	///TODO WRITEME
	//ICOMMAND(r_trigger, "ii" ent status

	///TODO make the below accept 2 arguments, if only 1 is provided, (ie arg2 is NULL), assume it's the last created, otherwise treat the first as the entity ident

	#define N(b, n, f, t, c, c2) ICOMMAND(r_ ## b ## _ ## n, f, (t *i), \
		if(!selected) \
			return; \
			\
		rpg ## b *e = selected->get ## b  (); \
		if(!e) \
			return; \
		c \
	); \
	ICOMMAND(r_get_ ## b ## _ ## n, "", (), \
		if(!selected) return; \
		rpg##b *e = selected->get ## b  (); \
		if(!e) \
			return; \
		c2 \
	)


	#define NI(b, n, min, max) N(b, n, "i", int, e->n = clamp((int)max, (int)min, *i), intret(e->n))
	#define NF(b, n, min, max) N(b, n, "f", float, e->n = clamp((float)max, (float)min, *i), floatret(e->n))
	#define NS(b, n) N(b, n, "s", const char, if(e->n) {delete[] e->n;} e->n = newstring(i), if(e->n) result(e->n))
	#define NB(b, n) N(b, n, "i", int, e->n = *i != 0, intret(e->n))

	NB(object, active);

	NI(item, slots,		0,		SLOT_MAX - 1);
	NI(item, weight,	0,		1000);
	NS(item, drop);
	NS(item, equip);

	NI(spell, cooldown,	0,		100000);
	NI(spell, range,	2,		1024);
	NI(spell, type,		STYPE_TARGET,	STYPE_SELF);
	NI(spell, cost,		0,		100000);
	NI(spell, castdelay,	0,		20000);
	NI(spell, effect,	0,		0x7FFFFFFF);
	NI(spell, fade,		1,		1000000);
	NI(spell, gravity,	-10000,		10000);

	#undef N
	#undef NI
	#undef NF
	#undef NS
	#undef NB

	#define N(n, f, t, c, c2) ICOMMAND(r_##n, f, (t *i), \
		rpgent *e = selected; \
		if(!e) return; \
		c; \
	); \
	ICOMMAND(r_get_ ## n, "", (), \
		rpgent *e = selected; \
		if(!e) return; \
		c2 \
	)

	#define NI(n, min, max) N(n, "i", int, e->n = clamp((int)max, (int)min, *i), intret(e->n))
	#define NF(n, min, max) N(n, "f", float, e->n = clamp((float)max, (float)min, *i), floatret(e->n))
	#define NS(n) N(n, "s", const char, if(e->n) {delete[] e->n;} e->n = newstring(i), if(e->n) result(e->n))
	#define NB(n) N(n, "i", int, e->n = *i != 0, intret(e->n))

	N(type, "i", int,
		*i = clamp(ENT_MAX - 1, 0, *i);
		e->cleansubtypes();
		switch(e->etype = *i)
		{
			case ENT_CHAR:
				if(game::rpgobjs.length()-1) e->type = ENT_AI;
				else e->type = ENT_PLAYER;
				e->subtype = new rpgchar();
				break;
			case ENT_ITEM:
				e->type = ENT_INANIMATE;
				e->subtype = new rpgitem();
				break;
			case ENT_SPELL:
				e->type = ENT_INANIMATE;
				e->subtype = new rpgspell();
				break;
			case ENT_OBJECT:
				e->type = ENT_INANIMATE;
				e->subtype = new rpgobject();
				break;
		}
		,
		intret(e->etype);
	);

	NS(icon);
	NS(model);
	NS(name);
	NS(description);
	NS(death);
	NS(interact);
	NS(approach);

	#undef N
	#undef NI
	#undef NF
	#undef NS
	#undef NB

	#define N(n, f, t, c) ICOMMAND(r_proj_##n, f, (t *i), \
		if(!effects.length()) \
		{ \
			conoutf("error: no effects (use r_proj_new)"); \
			return; \
		} \
		projeffect *e = effects[effects.length()-1]; \
		c; \
	);
	#define NI(n, min, max) N(n, "i", int, e->n = clamp((int)max, (int)min, *i))
	#define NF(n, min, max) N(n, "f", float, e->n = clamp((float)max, (float)min, *i))
	#define NS(n) N(n, "s", const char, if(e->n) {delete[] e->n;} e->n = newstring(i))
	#define NB(n) N(n, "i", int, e->n = *i != 0)

	ICOMMAND(r_proj_new, "", (), effects.add(new projeffect()););
	//simplifies variable configuration commands

	NI(basevel,		0,		100000);
	NI(kickback,		-200,		200);
	NI(flags,		0,		PFX_MAX - 1);
	NI(trailpart,		0,		PART_LENS_FLARE - 1);
	NI(trailcol,		0,		0xFFFFFF);
	NI(trailfade,		1,		120000);
	NI(gravity,		-10000,		10000);
	NI(projpart,		0,		PART_LENS_FLARE - 1);
	NI(projcol,		0,		0xFFFFFF);
	NI(lightradius,		32,		4096);
	NI(lightcolour,		-0xFFFFFF,	0xFFFFFF);
	NI(deathpart,		0,		PART_LENS_FLARE - 1);
	NI(deathpartcol,	0,		0xFFFFFF);
	NI(deathfade,		1,		120000);
	NI(deathdecal,		-1,		DECAL_RIPPLE);
	NI(deathlightflags,	0,		7);
	NI(deathlightinitcol,	-0xFFFFFF,	0xFFFFFF);
	NI(deathlightfade,	1,		120000);

	NF(trailsize,		0.01f,		100);
	NF(projsize,		0.01f,		100);
	NF(deathpartsize,	0.01f,		100);


	NS(mdl);

	#undef NB
	#undef NI
	#undef NF
	#undef NS
	#undef N
};