/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public final class RXTXPort
extends SerialPort {
    private static boolean debug = false;
    private static boolean debug_verbose = false;
    boolean MonitorThreadAlive = false;
    private int fd = 0;
    int eis = 0;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean MonitorThreadCloseLock = true;
    boolean closeLock = false;

    static {
        if (debug) {
            System.out.println("RXTXPort {}");
        }
        System.loadLibrary("Serial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    private static native void Initialize();

    public RXTXPort(String name) throws PortInUseException {
        if (debug) {
            System.out.println("RXTXPort:RXTXPort(" + name + ")");
        }
        this.fd = this.open(name);
        this.name = name;
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        if (debug) {
            System.out.println("RXTXPort:RXTXPort(" + name + ") fd = " + this.fd);
        }
        this.timeout = -1;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public synchronized void setSerialPortParams(int b, int d, int s, int p) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setSerialPortParams(" + b + " " + d + " " + s + " " + p + ")");
        }
        this.nativeSetSerialPortParams(b, d, s, p);
        this.speed = b;
        this.dataBits = s == 3 ? 5 : d;
        this.stopBits = s;
        this.parity = p;
    }

    private native void nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int flowcontrol) {
        if (debug) {
            System.out.println("RXTXPort:setFlowControlMode()");
        }
        try {
            this.setflowcontrol(flowcontrol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flowmode = flowcontrol;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int f) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveFramming()");
        }
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveFramming()");
        }
    }

    public boolean isReceiveFramingEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveFrammingEnabled()");
        }
        return false;
    }

    public int getReceiveFramingByte() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveFrammingByte()");
        }
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveTimeout()");
        }
        this.enableReceiveTimeout(0);
    }

    public void enableReceiveTimeout(int time) {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveTimeout()");
        }
        if (time < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = time;
        this.NativeEnableReceiveTimeoutThreshold(time, this.threshold, this.InputBuffer);
    }

    public boolean isReceiveTimeoutEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveTimeoutEnabled()");
        }
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveTimeout()");
        }
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int thresh) {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveThreshold()");
        }
        if (thresh < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = thresh;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void disableReceiveThreshold() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveThreshold()");
        }
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveThreshold()");
        }
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveThresholdEnable()");
        }
        return this.threshold > 0;
    }

    public void setInputBufferSize(int size) {
        if (debug) {
            System.out.println("RXTXPort:setInputBufferSize( " + size + ")");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = size;
    }

    public int getInputBufferSize() {
        if (debug) {
            System.out.println("RXTXPort:getInputBufferSize()");
        }
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int size) {
        if (debug) {
            System.out.println("RXTXPort:setOutputBufferSize( " + size + ")");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = size;
    }

    public int getOutputBufferSize() {
        if (debug) {
            System.out.println("RXTXPort:getOutputBufferSize()");
        }
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    protected native void writeByte(int var1) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    protected native void nativeDrain() throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        if (debug) {
            System.out.println("RXTXPort:checkMonitorThread()");
        }
        if (this.monThread != null) {
            if (debug) {
                System.out.println("monThreadisInterrupted = " + this.monThreadisInterrupted);
            }
            return this.monThreadisInterrupted;
        }
        if (debug) {
            System.out.println("monThread is null ");
        }
        return true;
    }

    public boolean sendEvent(int event, boolean state) {
        if (debug_verbose) {
            System.out.print("RXTXPort:sendEvent(");
        }
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (event) {
            case 1: {
                if (!debug_verbose) break;
                System.out.println("DATA_AVAILABLE " + this.monThread.Data + ")");
                break;
            }
            case 2: {
                if (!debug_verbose) break;
                System.out.println("OUTPUT_BUFFER_EMPTY " + this.monThread.Output + ")");
                break;
            }
            case 3: {
                if (!debug_verbose) break;
                System.out.println("CTS " + this.monThread.CTS + ")");
                break;
            }
            case 4: {
                if (!debug_verbose) break;
                System.out.println("DSR " + this.monThread.Output + ")");
                break;
            }
            case 5: {
                if (!debug_verbose) break;
                System.out.println("RI " + this.monThread.RI + ")");
                break;
            }
            case 6: {
                if (!debug_verbose) break;
                System.out.println("CD " + this.monThread.CD + ")");
                break;
            }
            case 7: {
                if (!debug_verbose) break;
                System.out.println("OE " + this.monThread.OE + ")");
                break;
            }
            case 8: {
                if (!debug_verbose) break;
                System.out.println("PE " + this.monThread.PE + ")");
                break;
            }
            case 9: {
                if (!debug_verbose) break;
                System.out.println("FE " + this.monThread.FE + ")");
                break;
            }
            case 10: {
                if (!debug_verbose) break;
                System.out.println("BI " + this.monThread.BI + ")");
                break;
            }
            default: {
                if (!debug_verbose) break;
                System.out.println("XXXXXXXXXXXXXX " + event + ")");
            }
        }
        if (debug_verbose) {
            System.out.println("checking flags ");
        }
        switch (event) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + event);
                return false;
            }
        }
        if (debug_verbose) {
            System.out.println("getting event");
        }
        SerialPortEvent e = new SerialPortEvent(this, event, state ^ true, state);
        if (debug_verbose) {
            System.out.println("sending event");
        }
        if (this.monThreadisInterrupted) {
            if (debug_verbose) {
                System.out.println("return");
            }
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(e);
        }
        if (debug_verbose) {
            System.out.println("return");
        }
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        if (debug) {
            System.out.println("RXTXPort:addEventListener()");
        }
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = lsnr;
        if (!this.MonitorThreadAlive) {
            this.MonitorThreadLock = true;
            this.monThread = new MonitorThread();
            this.monThread.start();
            this.waitForTheNativeCodeSilly();
            this.MonitorThreadAlive = true;
        }
        if (debug) {
            System.out.println("RXTXPort:Interrupt=false");
        }
    }

    public void removeEventListener() {
        if (debug) {
            System.out.println("RXTXPort:removeEventListener()");
        }
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            System.out.println("RXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            Runtime.getRuntime().gc();
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            if (debug) {
                System.out.println("RXTXPort:Interrupt=true");
            }
            this.monThreadisInterrupted = true;
            this.MonitorThreadCloseLock = true;
            if (debug) {
                System.out.println("RXTXPort:calling interruptEventLoop");
            }
            this.interruptEventLoop();
            if (debug) {
                System.out.print("RXTXPort:waiting on closelock");
            }
            while (this.MonitorThreadCloseLock) {
                if (debug) {
                    System.out.print(".");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (debug) {
                System.out.println();
            }
            if (debug) {
                System.out.println("RXTXPort:calling monThread.join()");
            }
            try {
                this.monThread.join(1000L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (debug) {
                System.out.println("RXTXPort:waiting on isAlive()");
            }
            while (this.monThread.isAlive()) {
                if (debug) {
                    System.out.println("MonThread is still alive!");
                }
                try {
                    this.monThread.join(1000L);
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
                this.monThread.stop();
            }
        }
        if (debug) {
            System.out.println("RXTXPort:calling gc()");
        }
        this.monThread = null;
        this.SPEventListener = null;
        Runtime.getRuntime().gc();
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    public void notifyOnDataAvailable(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnDataAvailable( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, enable);
        this.monThread.Data = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOutputEmpty(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnOutputEmpty( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, enable);
        this.monThread.Output = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCTS(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnCTS( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, enable);
        this.monThread.CTS = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnDSR(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnDSR( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, enable);
        this.monThread.DSR = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnRingIndicator(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnRingIndicator( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, enable);
        this.monThread.RI = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCarrierDetect(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnCarrierDetect( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, enable);
        this.monThread.CD = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOverrunError(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnOverrunError( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, enable);
        this.monThread.OE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnParityError(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnParityError( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, enable);
        this.monThread.PE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnFramingError(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnFramingError( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, enable);
        this.monThread.FE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnBreakInterrupt( " + enable + " )");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, enable);
        this.monThread.BI = enable;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    public synchronized void close() {
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " )");
        }
        if (this.closeLock) {
            return;
        }
        this.closeLock = true;
        if (this.fd <= 0) {
            System.out.println("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " ) setting monThreadisInterrupted");
        }
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " ) calling nativeClose");
        }
        this.nativeClose(this.name);
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " ) calling super.close");
        }
        super.close();
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " ) calling System.gc");
        }
        this.fd = 0;
        Runtime.getRuntime().gc();
        this.closeLock = false;
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " ) leaving");
        }
    }

    protected void finalize() {
        if (debug) {
            System.out.println("RXTXPort:finalize()");
        }
        if (this.fd > 0) {
            this.close();
        }
    }

    public void setRcvFifoTrigger(int trigger) {
    }

    private static native boolean nativeStaticSetDTR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetRTS(String var0, boolean var1) throws UnsupportedCommOperationException;

    private native byte nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native byte nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    public static boolean staticSetDTR(String port, boolean flag) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:staticSetDTR( " + port + " " + flag);
        }
        return RXTXPort.nativeStaticSetDTR(port, flag);
    }

    public static boolean staticSetRTS(String port, boolean flag) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:staticSetRTS( " + port + " " + flag);
        }
        return RXTXPort.nativeStaticSetRTS(port, flag);
    }

    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("getParityErrorChar()");
        }
        byte ret = this.nativeGetParityErrorChar();
        if (debug) {
            System.out.println("getParityErrorChar() returns " + ret);
        }
        return ret;
    }

    public boolean setParityErrorChar(byte b) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("setParityErrorChar(" + b + ")");
        }
        return this.nativeSetParityErrorChar(b);
    }

    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("getEndOfInputChar()");
        }
        byte ret = this.nativeGetEndOfInputChar();
        if (debug) {
            System.out.println("getEndOfInputChar() returns " + ret);
        }
        return ret;
    }

    public boolean setEndOfInputChar(byte b) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("setEndOfInputChar(" + b + ")");
        }
        return this.nativeSetEndOfInputChar(b);
    }

    public boolean setUARTType(String type, boolean test) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setUARTType()");
        }
        return this.nativeSetUartType(type, test);
    }

    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    public boolean setBaudBase(int BaudBase) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setBaudBase()");
        }
        return this.nativeSetBaudBase(BaudBase);
    }

    public int getBaudBase() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:getBaudBase()");
        }
        return this.nativeGetBaudBase();
    }

    public boolean setDivisor(int Divisor) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setDivisor()");
        }
        return this.nativeSetDivisor(Divisor);
    }

    public int getDivisor() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:getDivisor()");
        }
        return this.nativeGetDivisor();
    }

    public boolean setLowLatency() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setLowLatency()");
        }
        return this.nativeSetLowLatency();
    }

    public boolean getLowLatency() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:getLowLatency()");
        }
        return this.nativeGetLowLatency();
    }

    public boolean setCallOutHangup(boolean NoHup) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setCallOutHangup()");
        }
        return this.nativeSetCallOutHangup(NoHup);
    }

    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:getCallOutHangup()");
        }
        return this.nativeGetCallOutHangup();
    }

    class SerialOutputStream
    extends OutputStream {
        public void write(int b) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialOutputStream:write(int)");
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.writeByte(b);
        }

        public void write(byte[] b) throws IOException {
            if (debug_verbose) {
                System.out.println("Entering RXTXPort:SerialOutputStream:write(" + b.length + ") ");
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            RXTXPort.this.writeArray(b, 0, b.length);
            if (debug) {
                System.out.println("Leaving RXTXPort:SerialOutputStream:write(" + b.length + ")");
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] send = new byte[len];
            System.arraycopy(b, off, send, 0, len);
            if (debug_verbose) {
                System.out.println("Entering RXTXPort:SerialOutputStream:write(" + send.length + " " + off + " " + len + " " + ") ");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            RXTXPort.this.writeArray(send, 0, len);
            if (debug) {
                System.out.println("Leaving RXTXPort:SerialOutputStream:write(" + send.length + " " + off + " " + len + " " + ") ");
            }
        }

        public void flush() throws IOException {
            if (debug) {
                System.out.println("RXTXPort:SerialOutputStream:flush() enter");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            RXTXPort.this.nativeDrain();
            if (debug) {
                System.out.println("RXTXPort:SerialOutputStream:flush() leave");
            }
        }

        SerialOutputStream() {
        }
    }

    class SerialInputStream
    extends InputStream {
        public int read() throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read()");
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return -1;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            int result = RXTXPort.this.readByte();
            if (debug) {
                System.out.println("readByte= " + result);
            }
            return result;
        }

        public int read(byte[] b) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read(" + b.length + ")");
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            int result = this.read(b, 0, b.length);
            if (debug) {
                System.out.println("read = " + result);
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") ");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int Minimum = len;
            Minimum = RXTXPort.this.threshold == 0 ? (this.available() == 0 ? 1 : Math.min(Minimum, this.available())) : Math.min(Minimum, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            RXTXPort.this.waitForTheNativeCodeSilly();
            int result = RXTXPort.this.readArray(b, off, Minimum);
            if (debug) {
                System.out.println("RXTXPort:SerialInputStream:read(" + b.length + " " + off + " " + len + ") = " + result + " bytes containing ");
            }
            return result;
        }

        public int available() throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                throw new IOException("Port has been Closed");
            }
            int r = RXTXPort.this.nativeavailable();
            if (debug_verbose && r > 0) {
                System.out.println("available() returning " + r);
            }
            return r;
        }

        SerialInputStream() {
        }
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
            if (debug) {
                System.out.println("RXTXPort:MontitorThread:MonitorThread()");
            }
        }

        public void run() {
            if (debug) {
                System.out.println("RXTXPort:MontitorThread:run()");
            }
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
            if (debug) {
                System.out.println("eventLoop() returned");
            }
        }

        protected void finalize() throws Throwable {
            if (debug) {
                System.out.println("MonitorThread finalizing");
            }
        }
    }
}

