\name{getMainWindow.ggobi}
\alias{getMainWindow.ggobi}
\alias{getCurrentDisplay.ggobi}
\title{Get control panel or current display widget for a GGobi instance}
\description{
  \code{getMainWindow.ggobi} allows one to get access to the \code{GtkWindow}
  object that is the top-level control panel window for a
  GGobi instance. This can be used to navigate the widget hierarchy
  and add or remove elements such as menus.
  Additionally, one can use this to simply  hide the window
  programmatically which can be useful in the case that one is
  creating a customized GUI with GGobi displays embedded within it.

  \code{getCurrentDisplay.ggobi} returns the R-level
  representation of the Gtk object representing the
  current display in the specified GGobi.
  
}
\usage{
getMainWindow.ggobi(.gobi = getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the identifier for the GGobi instance of interest.
    This can be an integer or a GGobi reference object returned from
    \code{\link{ggobi}}.}
}
\details{

}
\value{
 A Gtk object of class \code{GtkWindow}.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
  \code{\link{ggobi}}
  \code{\link[RGtk]{gtkWindow}}
  \code{\link[RGtk]{gtkWidgetHide}}
  \code{\link[RGtk]{gtkWidgetShow}}  
}
\examples{
 o = ggobi()
 w = getMainWindow.ggobi(o)
 w$Hide()
 w$Show()
}
\keyword{iplot}
\keyword{dynamic}

