/*
**	colors.c 11/23/97 Mikael Forselius <mikaelf@comenius.se>
**
**	Aug 14 1999 - Tony Mantler <tonym@mac.linux-m68k.org>
**		- Changed CLUT IDs to avoid bug in MacOS
**
**	This file is subject to the terms and conditions of the GNU General Public
**	License.  See the file COPYING in the main directory of this archive
**	for more details.
**
**	Color and palette management
*/

#include <Palettes.h>
#include <Resources.h>
#include "penguin_prototypes.h"
#include "colors.h"

typedef struct RGBs {
	unsigned short	red;
	unsigned short	green;
	unsigned short	blue;
} RGBs;

static RGBs		clutRGBs[256];

void			load_rgbs(short nbits, RGBs *pOutRGBs);
void			set_clut_rgbs(short nBits, RGBs *pRGBs, short gdID);

/*
 *	SwapMainDeviceBW
 *
 *	Swaps the black and white colors in the
 *	hardware CLUT. Results in reverse video.
 */
void
SwapMainDeviceBW(void)
{
	short			gdID, depth;
	GDHandle		hMainDevice;

	hMainDevice = GetMainDevice();
	if ( (hMainDevice != nil) && ((*hMainDevice)->gdType == clutType) ) {
		gdID = (*hMainDevice)->gdID & 0xFF;
		depth = (*(*hMainDevice)->gdPMap)->pixelSize;
		if ((depth >= 1) && (depth <= 8)) {
			load_rgbs(depth, clutRGBs);
			set_clut_rgbs(depth, clutRGBs, gdID);
		} 
	}
}

void
load_rgbs(short nBits, RGBs *pOutRGBs)
{
	short		i, cIndex, nColors;
	short		refNum, hasRsrcColors;
	CTabHandle	hCLUT;
	ColorSpec	*pCSpec;
	
	nColors = 1 << nBits;
	hasRsrcColors = false;

	// Try to open 'Penguin Colors', if that
	// fails - the main file ("Penguin") CLUTs
	// will be used
	refNum = OpenResFile("\pPenguin Colors");

	hCLUT = (CTabHandle)Get1Resource('clut', nBits+1000);
	if (hCLUT != nil) {

		pCSpec = (*hCLUT)->ctTable;

		// pixmap or device color table?
		if ((*hCLUT)->ctFlags & 0x8000) {

			// device
			for(i = 0; i < nColors; i++) {
				pOutRGBs->red = pCSpec->rgb.red;
				pOutRGBs->green = pCSpec->rgb.green;
				pOutRGBs->blue = pCSpec->rgb.blue;
				++pOutRGBs;
				++pCSpec;
			}

		} else {

			// pixmap
			for(i = 0; i < nColors; i++) {
				cIndex = pCSpec->value;
				pOutRGBs[cIndex].red = pCSpec->rgb.red;
				pOutRGBs[cIndex].green = pCSpec->rgb.green;
				pOutRGBs[cIndex].blue = pCSpec->rgb.blue;
				++pCSpec;
			}

		}

	}

	// If 'Penguin Colors' was opened - close it
	if (refNum != -1) {
		CloseResFile(refNum);
		cprintf ("Setting Penguin colors from 'Penguin Colors' file\n");
	} else
		cprintf ("Setting Penguin default colors\n");

}

void
set_clut_rgbs(short nBits, RGBs *pRGBs, short gdID)
{
	short		i, nColors;
	ColorSpec	cSpec[256], *pCSpec;

	nColors = 1 << nBits;

	pCSpec = cSpec;

	for(i = 0; i < nColors; i++) {
		pCSpec->value = gdID;
		pCSpec->rgb.red = pRGBs->red;
		pCSpec->rgb.green = pRGBs->green;
		pCSpec->rgb.blue = pRGBs->blue;
		++pCSpec;
		++pRGBs;
	}
	SetEntries(0, nColors-1, cSpec);

}
