/*
**	machine.h 980120 Mikael Forselius <mikaelf@comenius.se>
**
**	Return machine name
*/

// *Special* Gestalt number for 'gestaltHardwareAttr'
enum {
//	gestaltHasVIA1				= 0,	/* VIA1 exists */
//	gestaltHasVIA2				= 1,	/* VIA2 exists */
	gestaltHasRBV				=  2,	/* RBV &M01 */
//	gestaltHasASC				= 3,	/* Apple Sound Chip exists */
//	gestaltHasSCC				= 4,	/* SCC exists */
	gestaltHasOSS				=  5,	/* OSS &M01 */
	gestaltHasSCSIDMA			=  6,	/* 53C80 SCSI DMA &M01 */
//	gestaltHasSCSI				= 7,	/* SCSI exists */
	gestaltHasSWIMIOP			=  8,	/* SWIM IOP &M01 */
	gestaltHasSCCIOP			=  9,	/* SCC IOP &M01 */
	gestaltHasFitch				= 10,	/* Fitch memory Controller &M02 */
	gestaltHasIWM				= 11,	/* IWM &M01 */
	gestaltHasPWM				= 12,	/* PWM disk speed buffer &M02 */
	gestaltHasRAMSndBuff		= 13,	/* RAM-based sound buffer &M02 */
	gestaltHasVideoDAConv		= 14,	/* Video D/A Converter &M02 */
	gestaltHasPGC				= 15,	/* PGC (parity control) &M02 */
	gestaltHasRPU				= 16,	/* Random Parity Unit */
	gestaltHasOMC				= 17,	/* Orwell Memory Controller */
	gestaltHasVISARBV			= 18,	/* VISA Ram Based Video */
//	gestaltHasSoftPowerOff		= 19,	/* Capable of software power off */
	gestaltHasSonic				= 20,	/* Sonic (built-in ethernet) &M01 */
//	gestaltHasSCSI961			= 21,	/* 53C96 SCSI controller on internal bus */
//	gestaltHasSCSI962			= 22,	/* 53C96 SCSI controller on external bus */
	gestaltHasDAFBVideo			= 23,	/* DAFB Video &M01 */
//	gestaltHasUniversalROM		= 24,	/* Do we have a Universal ROM? */
	gestaltHasJMC				= 25,	/* Jaws Memory Controller? */
	gestaltNeedsRESET			= 26	/* ??? set on PowerMac, C660AV and under MAE 1.0 */
//	gestaltHasEnhancedLtalk		= 30	/* Do we have Enhanced LocalTalk? */
};

extern unsigned long	lmROMBase		: 0x02AE;
extern unsigned long	lmVIA			: 0x01D4;
extern unsigned long	lmVIA2			: 0x0CEC;
extern unsigned long	lmSCCRd			: 0x01D8;
extern unsigned long	lmSCCWr			: 0x01DC;
extern unsigned long	lmIWM			: 0x01E0;
extern unsigned long	lmSCSIBase		: 0x0C00;
extern unsigned long	lmASCBase		: 0x0CC0;
extern unsigned long	lmPMgrBase		: 0x0D18;
extern unsigned long	lmUnivROMBits	: 0x0DD4;
extern unsigned short	lmHWCfgFlags	: 0x0B22;

extern void				ShowMachProfile(void);
extern char				*GetModelName(long gestaltID, Str255 strMac);
extern int				IsVIA2Mac(void);
extern int				IsRBVMac(void);
extern int				IsOSSMac(void);
extern int				MacHasHardware(unsigned long gestaltBit);
