// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/gc_for_orp.cpp,v 1.16 2002/01/11 15:47:38 weldon Exp $
//
 

#include "platform.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "gc_globals.h"
#include "nursery_step_gen.h"
#include "orp_for_gc.h"
#include "cheney_fetcher.h"

#include "root_set_enum.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "finalize.h"
#include "orp_synch.h"
#include "step_generation.h"

#ifdef GC_PT_WB
#include <math.h>
#endif
//  Toss this - Linux port mods
//#include "process.h"

#ifdef GC_SAPPHIRE
#include "ssb.h"
#include "orp_process.h"
#include "orp_threads.h"
#include "sapphire.h"
#endif // GC_SAPPHIRE

//*******************************************************************************
//
// To assist in debugging build the constraint bit vector by hand each time using
// the old class data structures.
//    
//*******************************************************************************
#ifdef GC_CLASS_REVEAL
#include "class.h" 
#include "orp_utils.h"  
#include "environment.h" 
#else
#ifndef _CLASS_H_ 
// Do not define if already available.
// get functions for the class property field.
inline unsigned int get_prop_alignment (unsigned int class_properties)
{
    return (unsigned int)(class_properties & CL_PROP_ALIGNMENT_MASK);
}
inline unsigned int get_prop_non_ref_array (unsigned int class_properties)
{
    return (class_properties & CL_PROP_NON_REF_ARRAY_MASK);
}
inline unsigned int get_prop_array (unsigned int class_properties)
{
    return (class_properties & CL_PROP_ARRAY_MASK);
}
inline unsigned int get_prop_pinned (unsigned int class_properties)
{
    return (class_properties & CL_PROP_PINNED_MASK);
}
inline unsigned int get_prop_finalizable (unsigned int class_properties)
{
    return (class_properties & CL_PROP_FINALIZABLE_MASK);
} 
#endif // ndef _CLASS_H_
#endif // GC_CLASS_REVEAL
// ********* end orp_for_gc.h TEMPORARY *********


Gc_Interface *p_gc; 

Step_Plus_Nursery_Generation *p_young_gen;

//#include "root_set_enum.h"
//#include "orp_threads.h"
#include "mrl_gc_v1.h"
#include "gc_globals.h"
// #include "thread_gc.h"
#include "gc_hooks.h"

//*****************************************************
//
// Some helper functions.
// If these need to be changed then the class.h function
// probable need to be looked at also.
//*****************************************************

#define BITS_PER_BYTE 8

#ifdef OBJECT_SPLITTING

#define LARGE_ARRAY_HACK_SET_MASK (1<<((sizeof(unsigned int) * BITS_PER_BYTE)-3))
#define LARGE_ARRAY_HACK_CLEAR_MASK ~LARGE_ARRAY_HACK_SET_MASK

#endif // OBJECT_SPLITTING


// We want to use signed arithmetic when we do allocation pointer/limit compares.
// In order to do this all sizes must be positive so when we want to overflow instead of 
// setting the high bit we set the next to high bit. If we set the high bit and the allocation buffer
// is at the top of memory we might not detect an overflow the unsigned overflow would produce
// a small positive number that is smaller then the limit.

#define NEXT_TO_HIGH_BIT_SET_MASK (1<<((sizeof(unsigned) * BITS_PER_BYTE)-2))
#define NEXT_TO_HIGH_BIT_CLEAR_MASK ~NEXT_TO_HIGH_BIT_SET_MASK

inline unsigned int get_instance_data_size (unsigned int encoded_size) 
{
    return (encoded_size & NEXT_TO_HIGH_BIT_CLEAR_MASK);
}

extern ORP_Control *p_orp_control;


Gc_Interface *p_init_gc(ORP_Control *p_orp_control,
						char *p_plan_file_name);

 
// ******************************************************************
/****
*
*  Routines to support the initialization and termination of GC.
* 
*****/


//
// API for the ORP to hand to the GC any arguments starting with -gc. 
// It is up to the GC to parse these arguments.
//
// Input: name - a string holding the name of the parameter 
//               assumed to begin with "-gc"
//        arg  - a string holding the argument following name on 
//               the command line.
//
void gc_next_command_line_argument(const char *name, const char *arg)
{

    char *gc_str = "-gc";
    char *ms_str = "-ms";
    char *mx_str = "-mx";
    char *fixed_str  = "fixed";
    char *copy_str = "copy";

    char *zeroing_thread_str = "zeroing_thread";
    char *fetcher_thread_str = "fetcher_thread";
    char *cheney_clock_str = "cheney_clock";
    char *fetcher_gap_str = "fetcher_gap=";
    
    char *Xms_str = "-Xms";
	char *Xmx_str = "-Xmx";
	int unit_k = 'k';
	int unit_m = 'm';


    char *verbosegc_str = "-verbosegc";
    char *plan_str = "PLAN=";
    char *stats_str = "stats";

    // Compatability requires that we accept -verbosegc, -ms and -mx

    if (strcmp(name, ms_str) == 0) {
        initial_heap_size_bytes = atoi(arg);
        initial_heap_size_bytes = (initial_heap_size_bytes & GC_BLOCK_HIGH_MASK); // Round down a block.
        if (verbose_gc) {
            orp_cout << "initial heap size is " << initial_heap_size_bytes << endl;
        }
        return;
    }
    if (strcmp(name, mx_str) == 0) {
        final_heap_size_bytes = atoi(arg);
        final_heap_size_bytes = (final_heap_size_bytes & GC_BLOCK_HIGH_MASK);
        if (verbose_gc) {
            orp_cout << "final heap size is " << final_heap_size_bytes << endl;
        }
        return;
    }
    
    if (strncmp(name, Xms_str,4) == 0) {
		const char * newarg = arg + 4;
		int len = strlen(newarg);
		int unit = 1;
		if (tolower(newarg[len - 1]) == unit_k) {
			unit = 1024;
		} else if (tolower(newarg[len - 1]) == unit_m) {
			unit = 1024 * 1024;
		}
        initial_heap_size_bytes = atoi(newarg);
		initial_heap_size_bytes *= unit;
        
        initial_heap_size_bytes = (initial_heap_size_bytes & GC_BLOCK_HIGH_MASK); // Round down a block.

        if (verbose_gc) {
            orp_cout << "initial heap size is " << initial_heap_size_bytes << endl;
        }
        return;
    }

    if (strncmp(name, Xmx_str,4) == 0) {
		const char * newarg = arg + 4;
		int len = strlen(newarg);
		int unit = 1;
		if (tolower(newarg[len - 1]) == unit_k) {
			unit = 1024;
		} else if (tolower(newarg[len - 1]) == unit_m) {
			unit = 1024 * 1024;
		}
        final_heap_size_bytes = atoi(newarg);
		final_heap_size_bytes *= unit;
        final_heap_size_bytes = (final_heap_size_bytes & GC_BLOCK_HIGH_MASK);
        if (verbose_gc) {
            orp_cout << "final heap size is " << final_heap_size_bytes << endl;
        }
        return;
    }


    if (strcmp(name, verbosegc_str) == 0) {
        verbose_gc = true;
        orp_cout << "verbose_gc is " << verbose_gc << endl;
        return;
    }
	
    // ignore all other strings that aren't gc.

    if(strcmp(name, gc_str) == 0) {
        if (strcmp(arg, stats_str) == 0) {
            stats_gc = true;
            orp_cout << "stats_gc is " << stats_gc << endl;
        } else if (strcmp(arg, fixed_str) == 0) {
            fixed_gc = true;
        } else if (strcmp(arg, copy_str) == 0) {
            copy_gc = true;
        } else if (strcmp(arg, zeroing_thread_str) == 0) {
            use_zeroing_thread = true;
        } else if (strcmp(arg, fetcher_thread_str) == 0) {
            use_fetcher_thread = true;
            init_fetcher_thread();
        } else if (strcmp(arg, cheney_clock_str) == 0) {
            use_cheney_clock = true;
        } else if (strncmp(arg, fetcher_gap_str, strlen(fetcher_gap_str)) == 0) {        
    		const char * newarg = arg + strlen(fetcher_gap_str);
    		int len = strlen(newarg);
	    	int unit = 1;
		    if (tolower(newarg[len - 1]) == unit_k) {
			    unit = 1024;
		    } else if (tolower(newarg[len - 1]) == unit_m) {
                orp_cout << "Fetcher gaps in millions makes little sense." << endl;
			    unit = 1024 * 1024;
		    }
            fetcher_gap = atoi(newarg);
    		fetcher_gap *= unit;

        } else {
            orp_cout << "-gc ignoring argument it does not understand." << name << " " << arg << endl;   
        }
        return;
    }

    //
    // Try to avoid supporting these command line arguments externally.
    //

#if 0
    if (strncmp(arg, plan_str, strlen(plan_str)) == 0) {
        p_plan_file_name = arg;
        orp_cout << "plan file is " << p_plan_file_name << endl;
    } else if (strncmp(arg, los_str, strlen(los_str)) == 0) {
        large_object_size = atoi(arg);
        orp_cout << "LOS size is " << large_object_size << endl;
    } 

#endif // 0

     orp_cout << "gc next_command_line_argument passed argument it does not understand." << name << " " << arg << endl;

} //gc::next_command_line_argument

 

//
// gc_init initialized the GC internal data structures.
// This routine is called after the last call to gc_next_command_line_argument.
// The ORP should call this *before* any other calls to this interface except
// calls to gc_next_command_line_argument.
//
// 
// gc_init needs a couple of routines to build empty classes so it can
// generated filler objects when it needs to align an object.
//

// THESE ROUTINES GO OUTSIDE THE EXPECTED GC/ORE INTERFACES AND SHOULD
// BE ELIMINATED......

//
// A couple of simple helper function to support gc_init.
//

//
// A function that is not part of the interface but can be used to make sure 
// our compile flags make sense.
// 

void check_compile_flags()
{
#ifdef GC_NONE_V0
   	if (verbose_gc) {
        orp_cout << "Using null collector (for debugging only) - GC_NONE_V0." << endl ;
    }
    return;
#endif

    int collectors_defined = 0;

#ifdef GC_COPY_V2
    collectors_defined++;
  	if (verbose_gc) {
        orp_cout << "Using Copy collector GC_COPY_V2." << endl ;
    }
#endif

#ifdef GC_GEN_V3
    collectors_defined++;
   	if (verbose_gc) {
        orp_cout << "Using Generational Collector GC_GEN_V3." << endl ;
    }
#endif

#ifdef GC_TRAIN_V5
#ifndef GC_GEN_V3
#error
		// If GC_TRAIN_V5 if defined then GC_GEN_V3 must also be defined for the compilations
		// to work. This is just a check.
#endif // GC_TRAIN_V5
#endif // GC_GEN_V3

#ifdef GC_TRAIN_V5
    // RLH-TRAIN Since GC_GEN_V3 is also defined 
    // we don't increment collectors_defined. This needs to be fixed... 
#ifndef GC_GEN_V3  
    collectors_defined++;
#endif
   	if (verbose_gc) {
        orp_cout << "Using Train Collector." << endl ;
    }
#endif // GC_TRAIN_V5
#ifdef GC_SAPPHIRE
    if (verbose_gc) {
        orp_cout << "Using Sapphire concurrent collector." << endl;
    }
#endif // GC_SAPPHIRE

    if (collectors_defined != 1) {
        cerr << "Error: One and only One collector can be defined. " << endl;
        orp_exit(1);
    }
}

//
// The class loader is notifying us that another class has
// just been loaded.
//

void gc_class_loaded (VTable *p_vt)
{
    if (!p_loaded_vtable_directory) {
        p_loaded_vtable_directory = new Pair_Table();
    }
 
    p_loaded_vtable_directory->add_entry(p_vt); // RDS STRICTLY DEBUG
}


#ifdef OBJECT_SPLITTING
signed int first_cold_offset = -1;
#endif // OBJECT_SPLITTING

//
// API for the ORP to ask the GC to initialize itself.
//
void gc_init()
{

    void gc_system_start_hook();

	gc_system_start_hook();

#ifdef SPACE_DEMOGRAPHICS
    for (unsigned idx=0;idx<DEMOGRAPHICS_ARRAY_SIZE;idx++) {
        space_demographics_size[idx]= 0;
    }
#endif

    //
    // At development time, check to ensure that the compile time
    // flags were set correctly. If verbosegc is on announce what
    // gc is running.
    //
    check_compile_flags();

	//
	// The following flag will be set to true 
	// (by the ORP calling gc_orp_initialized) when the ORP is fully initialized
	// Till then we can't do a stop-the-world.
	//
	orp_initialized = false;

// GC_INTERIOR_POINTERS

    interior_pointer_table = new slot_offset_list();
 
    p_orp_control = new ORP_Control();
	if (verbose_gc) {
		global_verbose_gc = true; 
	}

    //
    // initialize the new gc.
    //
    p_gc = p_init_gc(p_orp_control,
		             p_plan_file_name);

#ifdef OBJECT_SPLITTING
    if (first_cold_offset == -1) 
        first_cold_offset = gc_get_cold_region_offset() - OBJECT_HEADER_SIZE;
#endif // OBJECT_SPLITTING

    // Zero thread can be defined only for the copy collector on NT.
#ifndef ORP_NT

    assert (!use_zeroing_thread);
    // zeroing thread only implemented for NT.

#endif
    // 
    // check_compile_flags has ensured that we have a legal configuration, announce it.
	if (verbose_gc) {
		p_gc->set_verbose_level(1);
    } else {
		global_verbose_gc = false;
		p_gc->set_verbose_level(0);
	}
}


//
// This API is used by the ORP to notify the GC that the
// ORP has completed bootstrapping and initialization, and 
// is henceforth ready to field requests for enumerating 
// live references.
//
// Prior to this function being called the GC might see some
// strange sights such as NULL or incomplete vtables. The GC will
// need to consider these as normal and work with the ORP to ensure 
// that bootstrapping works. This means that the GC will make few
// demands on the ORP prior to this routine being called.
//
// However, once called the GC will feel free to do 
// stop-the-world collections and will assume that the entire
// orp_for_gc interface is available and fully functioning.
//
// If this routine is called twice the result is undefined.
//
void gc_orp_initialized()
{
    if (orp_initialized) {
        orp_cout << " Internal error - Multiple calls to gc_orp_initialized encountered."
            << endl;
    }
	orp_initialized = true;
}

//
// This is called once the ORP has no use for the heap or the 
// garbage collector data structures. The assumption is that the 
// ORP is exiting but needs to give the GC time to run destructors 
// and free up memory it has gotten from the OS.
// After this routine has been called the ORP can not relie on any
// data structures created by the GC.
//
// Errors: If gc_enumerate_finalizable_objects has been called and
//         gc_wrapup gc discovers an object that has not had it
//         finalizer run then it will attempt to report an error.
//

extern void wrapup_gc(); // in exit.cpp
 
void gc_wrapup() 
{
	wrapup_gc (); // part of the exit.cpp code.
}

/****
*
*  Routines to support finalization of objects.
* 
*****/

//
// This function is provided by the ORP and called by GC 
// when an object becomes "f-reachable, finalizable"
// The ORP later finalizes those objects in a way that
// is not part of this interface.
// This routine will be available from orp_for_gc.h
//
// ORPExport void orp_finalize_object(Java_java_lang_Object *p_obj);
// 


JNIEXPORT void JNICALL 
Java_java_lang_ref_Reference_hellotest (JNIEnv *the_env, jclass p_class) 
{
    orp_cout << "From hellotest 441 in gc_for_orp.cpp" << endl;
}
//
// Get the object with the referent and register it with the weak ref queue associated
// with the referent. Note that the referent is installed by this routine and retrieved by
// the get routine since the fact that there is an object in the referent field is not known
// by the normal channels. This allows the gc to ignore the field when it does its walk of 
// live data structures. In turn the gc must manage the referent during the weak ref passes.
// 

JNIEXPORT jobject JNICALL Java_java_lang_ref_Reference_get (JNIEnv *the_env, jobject p_obj)
{
    // Get the actual ref_Reference object.
    java_lang_ref_Reference *the_object = 
        (java_lang_ref_Reference *)(((Object_Handle )p_obj)->java_reference);
    // Get the referent
    Java_java_lang_Object *the_referent = 
        (Java_java_lang_Object *)(the_object->referent);
    Object_Handle new_handle = orp_create_local_object_handle();
    new_handle->java_reference = (Java_java_lang_Object *)the_referent;
    return new_handle;
}


// This is pretty straight forward and not as complicated as the specs would lead one to 
// believe. The initialization code for soft, weak, and phantom references needs to call the
// appropriate register routine specified here.
//
// After each collection the queue is traversed and each object is inspected. If the referent
// has not been moved (or marked if in LOS) then it is not reachable and the soft/weak/phantom ref 
// is processed as indicated by the language semantics.  
// If the object has been moved then the reference object is 

// Things need to be done atomically so here is a helper function.

// Because of race condition we use compare exchagne.
// Input
//    referent    - the object known placed in the slot only to the GC 
//    a_reference - the object to enqueue
//    ref_list       - the location of the list to enqueue the object on.
//                     it could be the soft, weak, phantom or finalize queue.
//
void enqueue_mumble_ref (Java_java_lang_Object *a_reference,
                         Java_java_lang_Object *referent, 
                         PVOID *ref_list)
{
    // Place the referent in the private slot in the object known to the GC code only.
	((Java_java_lang_ref_Reference *)a_reference)->referent = (Java_java_lang_Object *)referent;
    // Get the old soft reference list.
    PVOID old_value = *ref_list;
    // Link this soft reference onto the list.
    gc_heap_slot_write_ref ((Java_java_lang_Object *)a_reference,
        (Java_java_lang_Object **)&(((Java_java_lang_ref_Reference *)a_reference)->next),
        (Java_java_lang_Object *)old_value);
    // Relink the references, making sure it is done atomically.
    while (InterlockedCompareExchangePointer (ref_list, a_reference, old_value) != old_value) {
        // Repeat if you have failed.
        old_value = *ref_list;
        gc_heap_slot_write_ref ((Java_java_lang_Object *)a_reference,
            (Java_java_lang_Object **)&(((Java_java_lang_ref_Reference *)a_reference)->next),
            (Java_java_lang_Object *)old_value);
    }
}

// These routines register soft, weak, and phantom refs.

JNIEXPORT void JNICALL Java_java_lang_ref_Reference_register_soft_ref (JNIEnv *the_env, jobject p_obj, jobject referent)
{
    
    assert (orp_get_gc_enabled_state());
    orp_disable_gc();          //---------------------------------v

    // Get the actual ref_Reference object.
    Java_java_lang_Object *the_object = 
       (Java_java_lang_Object *) ((Object_Handle )p_obj)->java_reference;
    Java_java_lang_Object *the_referent = 
        (Java_java_lang_Object *)((Object_Handle )referent)->java_reference;

    enqueue_mumble_ref (the_object, the_referent, (PVOID *)&global_soft_ref_queue);

#ifdef GC_TRACE_WEAK_REF
    orp_cout << "Registering soft ref " << the_object << endl;
#endif // GC_TRACE_WEAK_REF
 
    gc_trace (the_referent, 
        "gc_register_soft_ref, ln 559 in gc_for_orp.cpp - Register Reference object with this referent.");
 
    orp_enable_gc();           //----------------------------------^
}

JNIEXPORT void JNICALL Java_java_lang_ref_Reference_enqueue_reference (JNIEnv *the_env, jobject p_obj)
{
    assert (orp_get_gc_enabled_state());
    orp_disable_gc();       //---------------------------------v
    //
    // Disable the gc code so it moves out of this critical section to a
    // gc safe point. This avoids the race condition of a reference being enqueued by
    // a thread at the same time the GC tries to enqueue it.
    // We know we have the queue lock or we wouldn't be here.
    //
    java_lang_ref_Reference *p_ref_Reference =  
        (java_lang_ref_Reference *)(((Object_Handle )p_obj)->java_reference);

    if (p_ref_Reference->queue) {
        // If the object has not already been enqueued, do it, if it has
        // been enqueued don't enqueue it again. Since there can be no race
        // conditions here, gc is disabled and by convention we hold the
        // queue lock then just enqueue it onto head1.
        if (!(p_ref_Reference->enqueued)) {
            java_lang_ref_ReferenceQueue *the_queue = p_ref_Reference->queue;
            assert (the_queue->which == 0); 
            p_ref_Reference->next = the_queue->head1;
            the_queue->head1 = p_ref_Reference;
            p_ref_Reference->enqueued = true;
        }
    }
    orp_enable_gc();          //----------------------------------^
}

JNIEXPORT void JNICALL Java_java_lang_ref_Reference_register_phantom_ref (JNIEnv *the_env, 
                                                                          jobject p_obj,
                                                                          jobject referent)
{
    assert (orp_get_gc_enabled_state());
    orp_disable_gc();          //---------------------------------v
    // Get the actual ref_Reference object.
    Java_java_lang_Object *the_object = 
       (Java_java_lang_Object *) ((Object_Handle )p_obj)->java_reference;
    Java_java_lang_Object *the_referent = 
        (Java_java_lang_Object *)((Object_Handle )referent)->java_reference;

    enqueue_mumble_ref (the_object, the_referent, (PVOID *)&global_phantom_ref_queue);

#ifdef GC_TRACE_WEAK_REF
    orp_cout << "Registering phantom ref " << the_object << endl;
#endif // GC_TRACE_WEAK_REF
 
    gc_trace (the_referent, 
        "gc_register_phantom_ref, ln 560 in gc_for_orp.cpp - Register Reference object with this referent.");
 
    orp_enable_gc();          //----------------------------------^
}

JNIEXPORT void JNICALL Java_java_lang_ref_Reference_register_weak_ref (JNIEnv *the_env, jobject p_obj, jobject referent)
{

    assert (orp_get_gc_enabled_state());
    orp_disable_gc();          //---------------------------------v
    // Get the actual ref_Reference object.
    Java_java_lang_Object *the_object = 
       (Java_java_lang_Object *) ((Object_Handle )p_obj)->java_reference;
    Java_java_lang_Object *the_referent = 
        (Java_java_lang_Object *)((Object_Handle )referent)->java_reference;

    enqueue_mumble_ref (the_object, the_referent, (PVOID *)&global_weak_ref_queue);
 
    gc_trace (the_referent, 
        "Java_java_lang_ref_Reference_register_weak_ref, ln 476 in gc_for_orp.cpp - Register Reference object with this referent.");
 
    orp_enable_gc();          //----------------------------------^
}

//
// A function called by the ORP before exit.
//
// The GC assumes that all Java objects are dead and
// enumerates all those that have overridden finalize()
// using the orp_finalize_object API.
//
// The GC may assume that finalizers are the only Java
// code that runs after that function has been called.
// 
// The GC should assume that all objects are live
// and shouldn't reclaim any memory.
//
// The expected scenario is:
// 1. The ORP calls gc_enumerate_finalizable_objects()
// 2. The ORP runs all finalizers (note that in
//    a pathological case this could be a non-trivial
//    piece of code and multiple garbage collections
//    may happen in that phase).
// 3. The ORP calls gc_wrapup()
//
// Issues:
// 1. What happens when a finalizer creates new objects
//    which require finalization?  Do we keep calling
//    gc_enumerate_finalizable_objects() until convergence?
//    - For now gc_enumerate_finalizable_objects will be
//      called only once and finalizers that create finalizable
//      object will have undefined results.
//
void gc_enumerate_finalizable_objects() 
{
    // enumerate all objects with an overwritten finalize method prior to exit.
    p_gc->run_all_finalizers ();
}

/****
*
*  Routines to support querying the layout of objects.
* 
*****/

//
// This routine gets from the ORP a zero terminated array of offsets
// of all the pointers in an instance of a the class. This routine
// is then responsible for remembering these locations in whatever 
// format seems appropriate. The interface orp_for_gc contains
// a partial definition of the class Class including the gc_information field
// which is a slot in the class data structure that is reserved for the GC.
// The purpose of this slot is to allow the GC to associate the
// information provided in an optimized permanent form. 
// 
//
// Input: p_class - a pointer to the base of a class data structure. 
//        ref_array - a zero deliminated transient array holding offsets
//                    to all the pointers in an instance of p_class.          
//              
void gc_class_ref_map (Partial_Reveal_Class *p_class,
                       unsigned int *ref_array)
{
#ifdef GC_NONE_V0
    assert (p_class->gc_information == NULL);
    return;
#endif // GC_NONE_V0

    // Calculate the size of the array needed and malloc it up.
    int i = 0;
    unsigned int size;

    for (i = 0; ref_array[i] != 0; i++) {
    
    }
    // We need at least enough for the 0.
    size = (i+1) * sizeof (unsigned int);
    unsigned int *new_ref_array = (unsigned int *)malloc (size);

    if (new_ref_array == NULL) {
        orp_cout << "Unable to allocated needed memory from OS. " << endl;
        exit (1);
    }

    // Copy the contents over into the new area.
    
    memcpy (new_ref_array, ref_array, size);

    p_class->gc_information = new_ref_array;

#if (GC_DEBUG>1)
    // Check the results.
    for (i = 0; ref_array[i] != 0; i++) {
        if (new_ref_array[i] != ref_array[i]) {
            assert (0);
        }
    }
    if (new_ref_array[i] != 0) {
        assert (0);
    }
#endif

}
// This routine provides the ORP with a read only zero terminated array 
// of offsets of all pointers in the instance of a class. The 
// array is in the same format as the array passed to it in 
// gc_ref_map. The ORP will not alter this array or expect it to
// persist. ref_array is populated.
// 
// Input:    p_class - a pointer to the base of a class data structure.
//           length - the size of the array to be filled. If this is not
//                    sufficient then it is an internal error.
// Returns   ref_array - a zero deliminated potentially transient array holding offsets
//                       to all the pointers in an instance of p_class.   
void gc_get_class_ref_map (VTable *p_vtable,
                           unsigned int length,
                           unsigned int *ref_array)
{
#ifdef GC_NONE_V0
    return;
#endif // GC_NONE_V0
    unsigned int i = 0;

    unsigned int *the_class_ref_array = p_vtable->gc_information;
    for (i = 0; the_class_ref_array[i] != 0; i++) {
   
    }
    assert (i <= length); 
    unsigned size = (i+1) * sizeof (unsigned int);

    // Copy the contents over into the new area provided by the ORP.
    
    memcpy (ref_array, the_class_ref_array, size);
} 
/****
*
*  Routines to support barriers such as read and write barriers.
* 
*****/

//
// This API is used by the ORP (JIT) to find out if
// the GC requires read or write barriers. If the GC requests
// write barriers and the JIT does not support write barriers the results
// are undefined.
//
// Output: 
//         1 if the garbage collector expects to be notified whenever
//              a slot holding a pointer to an object is modified in the heap.
//         0 otherwise.
//
// Comments: Future version might extend possible return values 
//           so that the system can support other barriers such as a 
//           read barrier or a write barrier on all heap writes, not 
//           just pointer writes.
//
//

static GC_Barriers which_barrier = 

#ifdef GC_READ_BARRIER
    GC_TRACE_BARRIER;
#elif defined GC_SAPPHIRE
	GC_SAPPHIRE_WRITE_BARRIER;
#elif defined GC_FIXED_V1
    GC_NO_BARRIER;
#elif defined GC_COPY_V2
    GC_NO_BARRIER;
#elif defined GC_SAPPHIRE
	GC_SAPPHIRE_WRITE_BARRIER;
#elif defined GC_PT_WB
    GC_NO_BARRIER;
#elif defined GC_GEN_V3
    GC_CARD_MARK_WRITE_BARRIER;
#else
#error
#endif 

GCExport GC_Barriers gc_requires_barriers() 
{
    if (fixed_gc || copy_gc) {
        return GC_NO_BARRIER;
    }
    return which_barrier;
}

//
// If gc_requires_write_barriers() returns 1, the Jit-ted code 
// should call this after doing the putfield or an array store or
// a reference.
//
// Sapphire -
// If gc_requires_write_barrier() returns 2 (Sapphire) then this
// is called whenever anything is stored into the heap, not only 
// references.
// 
//
// Likewise the ORP needs to call it whenever it stores a pointer into the
// heap.
//
// Input: p_base_of_obj_with_ref - the base of the object that
//                                 had a pointer stored in it.
//
// For Sapphire we need to find out if processing the entire object is faster
// than just processing the parts that have been changed. For the initial implementation
// we will process the entire object, mostly because it is easier and keeps the normal
// case write barrier simpler.
//
void __fastcall gc_write_barrier_fastcall(Java_java_lang_Object *p_base_of_object_holding_ref) 
{
    gc_write_barrier(p_base_of_object_holding_ref);
} //gc_write_barrier_fastcall

inline void gc_write_barrier(Java_java_lang_Object *p_base_of_object_holding_ref) 
{
    assert (p_base_of_object_holding_ref->vt);
#ifdef GC_COUNT_WRITE_BARRIERS
//    orp_cout << "+" ;
    gc_write_barrier_count = gc_write_barrier_count + 1;
#endif // GC_COUNT_WRITE_BARRIERS

#ifdef GC_SAPPHIRE
// We should be using gc_write_barrier_atomic but for IA32 we will use this.
    // There were writes to multiple fields if this is called.
    gc_sapphire_heap_wrote_object (p_base_of_object_holding_ref);
    return;
#endif

#if ( defined(GC_NONE_V0) || defined(DISABLE_GC_WRITE_BARRIERS) || defined(GC_COPY_V2))
	return;
#endif

#if (GC_DEBUG>1)
    write_barrier_hook(p_base_of_object_holding_ref);
#endif

    if (fixed_gc || copy_gc) {
        return;
    }
    // Note that some of the JITS on IA32 pass the slot and not the base so this might not always
    // be passing a reasonable value. There is compensation code in gc_trace. 
    // On IA64 only the base should be passed.
    gc_trace (p_base_of_object_holding_ref, "gc_write_barrier called on this object.");
 
    //
    // Checking for NULL seems like a loser even if we knew the pointer being stored.
    //    if (p_new_obj_ref == NULL) return;     // FAST CODE PATH

#ifdef GC_GEN_V3

// #ifdef GC_CARD_XOR_TRICK
    //
    // We tried the following idea. Filter out the write barrier if the
    // pointer being stored and the object it points to falls in the same block.
    // While the compiler provided both the pointer and the slot for the test it
    // was found that this trick was a loser.

// #endif

    // ------------- The normal release code starts here. ---------------


    GC_BLOCK_INFO(p_base_of_object_holding_ref)->card_table[GC_CARD_INDEX(p_base_of_object_holding_ref)] = true;

    return;

#endif // GC_GEN_V3
    orp_cout << " Internal bug - write barrier call seems broken. " << endl;
    assert (0);
}

// How do I know whether this needs to do a st.rel? The JIT should
// be able to tell me if the object is volatile?

void gc_write_barrier_atomic(Java_java_lang_Object *p_base_of_object_with_slot,
										 Java_java_lang_Object **p_slot,
										 Java_java_lang_Object *value)
{   
    assert (p_slot != NULL);
    assert (p_base_of_object_with_slot != NULL);

#if (  defined(GC_NONE_V0) || defined(DISABLE_GC_WRITE_BARRIERS) || defined(GC_COPY_V2) || defined(GC_NONE_V0))
    *p_slot = value;
	return;
#endif

	// At this point we know we need to do a write barrier.
    gc_trace (p_base_of_object_with_slot, "gc_write_barrier called on this object.");

    GC_BLOCK_INFO(p_base_of_object_with_slot)->card_table[GC_CARD_INDEX(p_base_of_object_with_slot)] = true;

    // update the slot
    *p_slot = value;
}

#if 1 // non inlined version needed for JIT. and  GC_SAPPHIRE
//
// Code for the gc algorithms requiring write barriers, including sapphire.
//
// The following routines are the only way to alter any value in the gc heap.  
//

// In a place with gc disabled an entire object was written, for example inside
// clone. This means that the entire object must be scanned and treated as if
// all the fields had been altered. 

void gc_heap_wrote_object (Java_java_lang_Object *p_base_of_object)
{
#ifdef GC_SAPPHIRE
// We should be using gc_write_barrier_atomic but for IA32 we will use this.
    // There were writes to multiple fields if this is called.
    gc_sapphire_heap_wrote_object (p_base_of_object);
    return;
#endif
#ifdef GC_PT_WB
    return;
#endif // GC_PT_WB
    gc_write_barrier(p_base_of_object);
}

inline void gc_heap_write_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         Java_java_lang_Object *value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_ref (p_base_of_object_with_slot,
        offset,
        value);
#else
    Java_java_lang_Object **p_slot = 
        (Java_java_lang_Object **)(((char *)p_base_of_object_with_slot) + offset);
    
#if (defined(GC_COPY_V2) || defined(DISABLE_GC_WRITE_BARRIERS) || defined(GC_PT_WB)) 
    *p_slot = value;
#else

#ifdef GC_PRIVATE_HEAP
    if (GC_BLOCK_INFO(p_base_of_object_holding_ref)->private_area_p) && (!GC_BLOCK_INFO(value)->private_area_p)) {
        // At this point we know that we are creating a public object out of a private object so we need
        // to move this object and other objects reachable from this object into a public space.
        // The value returned will be the new location of the public object that will be placed in the slot.
        Java_java_lang_Object *new_value = do_thread_local_gc(value);
    }
#endif

    *p_slot = value;
    gc_write_barrier (p_base_of_object_with_slot);
#endif
#endif
}

void gc_heap_slot_write_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         Java_java_lang_Object **p_slot,
                         Java_java_lang_Object *value)
{
    gc_heap_write_ref (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}

// Non reference writes caller does conversion.

void gc_heap_write_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int8 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int8 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int8 *p_slot = 
        (int8 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int8 *p_slot,
                         int8 value)
{
    gc_heap_write_int8 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int16 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int16 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int16 *p_slot = 
        (int16 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int16 *p_slot,
                         int16 value)
{
    gc_heap_write_int16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         uint16 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_uint16 (p_base_of_object_with_slot,
        offset,
        value);
#else
    uint16 *p_slot = 
        (uint16 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         uint16 *p_slot,
                         uint16 value)
{
    gc_heap_write_uint16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int32 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int32 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int32 *p_slot = 
        (int32 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int32 *p_slot,
                         int32 value)
{
    gc_heap_write_int32 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         float value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_float (p_base_of_object_with_slot,
        offset,
        value);
#else
    float *p_slot = 
        (float *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         float *p_slot,
                         float value)
{
    gc_heap_write_float (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         double value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_double (p_base_of_object_with_slot,
        offset,
        value);
#else
    double *p_slot = 
        (double *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         double *p_slot,
                         double value)
{
    gc_heap_write_double (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         POINTER_SIZE_INT value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
    
#ifdef POINTER64
    gc_heap_write_int64 (p_base_of_object_with_slot,
                                  offset,
                                  (int64)value);
#else
    gc_heap_write_int32 (p_base_of_object_with_slot,
                                  offset,
                                  (int32)value);
#endif
}

void gc_heap_slot_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         POINTER_SIZE_INT *p_slot,
                         POINTER_SIZE_INT value)
{
    gc_heap_write_pointer_size_int (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_heap_write_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int64 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int64 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int64 *p_slot = 
        (int64 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_heap_slot_write_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int64 *p_slot,
                         int64 value)
{
    gc_heap_write_int64 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}



  
// There are some global slots that are shared by different threads. Sapphire 
// needs to know about writes to these slots. One example of such slots is in
// the string pools used by the class loader.
void gc_heap_write_global_slot(Java_java_lang_Object **p_slot,
                               Java_java_lang_Object *value)
{
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_global_slot (p_slot, value);
#else
    *p_slot = value;
#endif
};

// The following should generate a st.rel followed by a mf to get sequential consistency
// for volatiles. As of June 12, 2000  this is my (RLH) assumption of what the ORP spec 
// will/should be.

void gc_volatile_heap_write_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         Java_java_lang_Object *value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_ref (p_base_of_object_with_slot,
        offset,
        value);
#else
    Java_java_lang_Object **p_slot = 
        (Java_java_lang_Object **)(((char *)p_base_of_object_with_slot) + offset);
    
#if (defined(GC_COPY_V2) || defined(DISABLE_GC_WRITE_BARRIERS)) 
    *p_slot = value;
#else
    *p_slot = value;
    gc_write_barrier (p_base_of_object_with_slot);
#endif
#endif
}

void gc_volatile_heap_slot_write_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         Java_java_lang_Object **p_slot,
                         Java_java_lang_Object *value)
{
    gc_volatile_heap_write_ref (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}

// Non reference writes caller does conversion.

void gc_volatile_heap_write_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int8 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int8 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int8 *p_slot = 
        (int8 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int8 *p_slot,
                         int8 value)
{
    gc_volatile_heap_write_int8 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int16 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int16 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int16 *p_slot = 
        (int16 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int16 *p_slot,
                         int16 value)
{
    gc_volatile_heap_write_int16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         uint16 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_uint16 (p_base_of_object_with_slot,
        offset,
        value);
#else
    uint16 *p_slot = 
        (uint16 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         uint16 *p_slot,
                         uint16 value)
{
    gc_volatile_heap_write_uint16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int32 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int32 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int32 *p_slot = 
        (int32 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int32 *p_slot,
                         int32 value)
{
    gc_volatile_heap_write_int32 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         float value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_float (p_base_of_object_with_slot,
        offset,
        value);
#else
    float *p_slot = 
        (float *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         float *p_slot,
                         float value)
{
    gc_volatile_heap_write_float (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         double value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_double (p_base_of_object_with_slot,
        offset,
        value);
#else
    double *p_slot = 
        (double *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         double *p_slot,
                         double value)
{
    gc_volatile_heap_write_double (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         POINTER_SIZE_INT value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef POINTER64
    gc_volatile_heap_write_int64 (p_base_of_object_with_slot,
                                  offset,
                                  (int64)value);
#else
    gc_volatile_heap_write_int32 (p_base_of_object_with_slot,
                                  offset,
                                  (int32)value);
#endif
}

void gc_volatile_heap_slot_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         POINTER_SIZE_INT *p_slot,
                         POINTER_SIZE_INT value)
{
    gc_volatile_heap_write_pointer_size_int (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}




void gc_volatile_heap_write_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset,
                         int64 value)
{ 
    
    assert (p_base_of_object_with_slot != NULL);
#ifdef GC_SAPPHIRE
    gc_sapphire_heap_write_int64 (p_base_of_object_with_slot,
        offset,
        value);
#else
    int64 *p_slot = 
        (int64 *)(((char *)p_base_of_object_with_slot) + offset);
    *p_slot = value;
#endif
}

void gc_volatile_heap_slot_write_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int64 *p_slot,
                         int64 value)
{
    gc_volatile_heap_write_int64 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot),
        value);
}

#endif // GC_SAPPHIRE

#ifndef GC_SAPPHIRE
//
// Implement equal for non sapphire GC. See sapphire.cpp for the sapphire code.
//
int gc_sapphire_equal (Java_java_lang_Object *p_obj1, Java_java_lang_Object *p_obj2)
{
    if (p_obj1 == p_obj2) {
        return true;
    }
    return false;
}
#endif // GC_SAPPHIRE

/****
*
*  Routines to support read barriers
*
****/

#ifdef GC_READ_BARRIERS 
// non inlined version needed for JIT. and  GC_SAPPHIRE
//
// Code for the gc algorithms and traces requiring read barriers.
//
// The following routines are to be called whenever a value in the
// gc heap is read  
//

// In a place with gc disabled an entire object could be read, for example inside
// clone. This means that the entire object must be scanned and treated as if
// all the fields had been read. 

void gc_heap_read_object (Java_java_lang_Object *p_base_of_object)
{
}

inline Java_java_lang_Object *gc_heap_read_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((Java_java_lang_Object *)((char *)_p_base_of_object_with_slot + offset));
}

// The slot versions of the read barrier routines just call the normal barriers.
Java_java_lang_Object *gc_heap_slot_read_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         Java_java_lang_Object **p_slot)
{
    return gc_heap_read_ref (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

// Non reference writes caller does conversion.
int8 gc_heap_read_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((int8 *)((char *)_p_base_of_object_with_slot + offset));
}

int8 gc_heap_slot_read_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int8 *p_slot)
{
    return gc_heap_read_int8 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

int16 gc_heap_read_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((int16 *)((char *)_p_base_of_object_with_slot + offset));
}

int16 gc_heap_slot_read_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int16 *p_slot)
{
    return gc_heap_read_int16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

uint16 gc_heap_read_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{
     return *((uint16 *)((char *)_p_base_of_object_with_slot + offset));
}

uint16 gc_heap_slot_read_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         uint16 *p_slot)
{
    return gc_heap_read_uint16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

int32 gc_heap_read_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{
    return *((int32 *)((char *)_p_base_of_object_with_slot + offset));
}

int32 gc_heap_slot_read_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int32 *p_slot)
{
    return gc_heap_read_int32 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

float gc_heap_read_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{
    return *((float *)((char *)_p_base_of_object_with_slot + offset));
}

float gc_heap_slot_read_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         float *p_slot)
{
    return gc_heap_read_float (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

double gc_heap_read_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((double *)((char *)_p_base_of_object_with_slot + offset));
}

double gc_heap_slot_read_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         double *p_slot)
{
    return gc_heap_read_double (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

POINTER_SIZE_INT gc_heap_read_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((POINTER_SIZE_INT *)((char *)_p_base_of_object_with_slot + offset));
}

POINTER_SIZE_INT gc_heap_slot_read_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         POINTER_SIZE_INT *p_slot)
{
    return gc_heap_read_pointer_size_int (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

int64 gc_heap_read_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((int64 *)((char *)_p_base_of_object_with_slot + offset));
}

int64 gc_heap_slot_read_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int64 *p_slot)
{
    return gc_heap_read_int64 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}
  
// There are some global slots that are shared by different threads. Some gc  
// algorithms needs to know about reads from these slots.
Java_java_lang_Object *gc_heap_read_global_slot(Java_java_lang_Object **p_slot)
{
    return *((Java_java_lang_Object *)((char *)_p_base_of_object_with_slot + offset));
};

// The following should generate a ls.acq and a mfence to get sequential consistency
// for volatiles. As of June 12, 2000  this is my (RLH) assumption of what the Memory
// access ordering spec will/should be. Though the need for the mfence might not be 
// required.

Java_java_lang_Objec *gc_volatile_heap_read_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((Java_java_lang_Object *)((char *)_p_base_of_object_with_slot + offset));
}

Java_java_lang_Object *gc_volatile_heap_slot_read_ref (Java_java_lang_Object *p_base_of_object_with_slot,
                         Java_java_lang_Object **p_slot)
{
    return gc_volatile_heap_read_ref (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

// Non reference writes caller does conversion.

int8 gc_volatile_heap_read_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((int8 *)((char *)_p_base_of_object_with_slot + offset));
}

int8 gc_volatile_heap_slot_read_int8 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int8 *p_slot)
{
    return gc_volatile_heap_read_int8 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

int16 gc_volatile_heap_read_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{
    return *((int16 *)((char *)_p_base_of_object_with_slot + offset));
}

int16 gc_volatile_heap_slot_read_int16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int16 *p_slot)
{
    return gc_volatile_heap_read_int16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

uint16 gc_volatile_heap_read_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((uint16 *)((char *)_p_base_of_object_with_slot + offset));
}

uint16 gc_volatile_heap_slot_read_uint16 (Java_java_lang_Object *p_base_of_object_with_slot,
                         uint16 *p_slot)
{
    return gc_volatile_heap_read_uint16 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

int32 gc_volatile_heap_read_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{     
    return *((int32 *)((char *)_p_base_of_object_with_slot + offset));
}

int32 gc_volatile_heap_slot_read_int32 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int32 *p_slot)
{
    return gc_volatile_heap_read_int32 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

float gc_volatile_heap_read_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((float *)((char *)_p_base_of_object_with_slot + offset));
}

float gc_volatile_heap_slot_read_float (Java_java_lang_Object *p_base_of_object_with_slot,
                         float *p_slot)
{
    return gc_volatile_heap_read_float (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}


double gc_volatile_heap_read_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{
    return *((double *)((char *)_p_base_of_object_with_slot + offset));
}

double gc_volatile_heap_slot_read_double (Java_java_lang_Object *p_base_of_object_with_slot,
                         double *p_slot)
{
    return gc_volatile_heap_read_double (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

POINTER_SIZE_INT gc_volatile_heap_read_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((POINTER_SIZE_INT *)((char *)_p_base_of_object_with_slot + offset));
}

POINTER_SIZE_INT gc_volatile_heap_slot_read_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_slot,
                         POINTER_SIZE_INT *p_slot)
{
    return gc_volatile_heap_read_pointer_size_int (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot));
}

uint64 gc_volatile_heap_read_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         unsigned offset)
{ 
    return *((uint64 *)((char *)_p_base_of_object_with_slot + offset));
}

uint64 gc_volatile_heap_slot_read_int64 (Java_java_lang_Object *p_base_of_object_with_slot,
                         int64 *p_slot)
{
    return gc_volatile_heap_read_int64 (p_base_of_object_with_slot,
        (unsigned)((char *)p_slot - (char *)p_base_of_object_with_slot);
}

#endif // GC_READ_BARRIERS

/****
*
*  Routines to support building the root set during a collection.
* 
*****/

//
// Call from the ORP to the GC to enumerate another
// live reference.
//
// Input: ref - the location of a slot holding a pointer that
//              is NULL or points to a valid object in the heap.
//
void gc_add_root_set_entry(Java_java_lang_Object **ref) 
{
#ifdef GC_NONE_V0 // ignore root set entries when no GC is being done.
    assert (0); // Remove, check to see if you can avoid GC when GC_NONE_V0 is defined.
    return;
#endif 

#if ((GC_DEBUG>0) && !(defined(GC_NONE_V0)))
    root_set_entry_hook(ref);
#endif
    // RLH-TRAIN below needs to filter all pointers not to YOS or focus car.
    p_gc->gc_add_root_set_entry(ref);
}

// GC_INTERIOR_POINTERS
// 
// Call from the ORP to the gc to enumerate an interior pointer. **ref is a slot holding a pointer
// into the interior of an object. The base of the object is located at *ref - offset. The strategy
// employed is to place the slot, the object base and the offset into a slot_base_offset table. We then
// call gc_add_root_set_entry with the slot in the table holding the base of the object. Upon completion
// of the garbage collection the routine fixup_interior_pointers is called and the slot_base_offset table
// is traversed and the new interior pointer is calculated by adding the base of the object and the offset.
// This new interior pointer value is then placed into the slot.
//
// This routine can be called multiple times with the same interiour pointer without any problems.
// The offset is checked to make sure it is positive but the logic is not dependent on this fact.

GCExport void gc_add_root_set_entry_interior_pointer (void **slot, int offset)
{
    Java_java_lang_Object *p_obj = (Java_java_lang_Object *)((byte *)*slot - (byte *)offset);
    assert (p_obj->vt);
    interior_pointer_table->add_entry (slot, p_obj, offset);
    // pass the slot from the interior pointer table to the gc.
    gc_add_root_set_entry (interior_pointer_table->get_last_base_slot());
}

/****
*
*  Routines to support the allocation and initialization of objects.
* 
*****/

//
// Allocation of objects.
//
// There is a tension between fast allocation of objects and 
// honoring various constraints the ORP might place on the object. 
// These constraints include registering the objects for 
// finalization, aligning the objects on multiple word boundaries, 
// pinning objects for performance reasons, registering objects 
// related to weak pointers and so forth.
//
// We have tried to resolve this tension by overloading the 
// size argument that is passed to the allocation routine. If 
// the size of the argument has a high bit of 0, then the 
// allocation routine will assume that no constraints exist 
// on the allocation of this object and allocation can potentially 
// be made very fast. If on the other hand the size is large then 
// the routine will query the class data structure to determine 
// what constraints are being made on the allocation of this object.
//
//
// See orp_for_gc interface for masks that allow the gc to quickly 
// determine the constraints.

//
// This routine is the primary routine used to allocate objects. 
// It assumes nothing about the state of the ORP internal data 
// structures or the runtime stack. If gc_malloc_or_null is able 
// to allocate the object without invoking a GC or calling the ORP
// then it does so. It places p_vtable into the object, ensures 
// that the object is zeroed and then returns a Java_java_lang_Object 
// pointer to the object. If it is not able to allocate the object 
// without invoking a GC then it returns NULL.
//
// Input: size - the size of the object to allocate. If the high bit
//               set then various constraints as described above are
//               placed on the allocation of this object.
//        p_vtable - a pointer to the vtable of the class being 
//                   allocated. This routine will place this value 
//                   in the appropriate slot of the new object.
//
Java_java_lang_Object *gc_malloc_or_null(unsigned size, VTable *p_vtable)
{
    // All requests for space should be multiples of 4 (IA32) or 8(IA64)
    assert((size % GC_OBJECT_ALIGNMENT) == 0);
    int foo = GC_OBJECT_ALIGNMENT;

    // Sometimes we debug and always return a NULL so that we can sort the 
    // problems out in gc_malloc.
    //    return NULL;

    // We only deal with the fastest of cases here.
    // gc_malloc deals with the slower cases.
#ifdef GC_NONE_V0
    return NULL;
#endif

#ifdef GC_SAPPHIRE
	return NULL;
#endif

    // If this is a hot spot fold it into the check below...
	if (size > los_threshold_bytes) {
		return NULL;
	}
    //
	// Try to allocate an object from the current nursery.
	// This can fail if the object won't fit in what is left of the 
    // nursery. This might happen if you are trying to create a
    // Large Object so we are prepared to pick up the pieces below.

    // We are going to all this trouble to eliminate the
    // los check.

    // It will also fail if the high bit of size is set to 1 which is the
    // slow case.

    //
    // NEED TO REMOVE (nursery *), orp_get_nursery returns returns a void * which is the 
    // p_TLS_jvmthread->nursery field. 
    //
	Java_java_lang_Object *p_return_object;
    
    block_info *my_nursery = (block_info *)orp_get_nursery();
    Object_Gc_Header *p_obj_start = (Object_Gc_Header *)my_nursery->free;
    char *new_free = (char *)p_obj_start + size;
    if (GC_BLOCK_INFO(new_free) == GC_BLOCK_INFO(p_obj_start)) {
        p_return_object = P_OBJ_FROM_START(p_obj_start);
        p_return_object->vt = (VTable *)p_vtable;
        my_nursery->free = new_free; // Commit
    } else {
        p_return_object = NULL;
    }

    gc_trace (p_return_object, "Allocated in gc_malloc_or_null.");
	//
	// return the object we just allocated. It may be NULL and we fall into
    // the slow code of gc_malloc.
	//
    return p_return_object;
    // END OF FAST CASE CODE.
}



#ifdef POINTER64
#define ALIGN8
#endif


Java_java_lang_Object *gc_malloc_gc_none_v0_memory(unsigned size)
{
    // Simple allocate "size" bytes using regular malloc.
    
    // Clear the high bit since we know that with this simple interface
    // all objects will be pinned and not finalized or require special LOS 
    // handling.

    size = (size & NEXT_TO_HIGH_BIT_CLEAR_MASK);
#ifdef _DEBUG
    p_TLS_orpthread->number_of_objects_allocated++;  
#endif

#ifdef POINTER64
#define CHUNK_OF_RAM 100 * 1024
#else
#define CHUNK_OF_RAM 10 * 1024 * 1024
#endif

    void *b;
    // the Feb 99 gc_for_orp interface assumes the caller has calculated the
    // required size including the OBJECT_HEADER_SIZE. This is not a concern since
    // the worse that will happen is that there will be some space filled with 0.
	size += OBJECT_HEADER_SIZE;
    unsigned unpadded_size = size;
#ifdef ALIGN8
    size += 8; // add extra bytes so that we can align on 8-byte boundry
#else
    size += 4; // add extra bytes so that we can align on 4-byte boundry
#endif

    if(size >= CHUNK_OF_RAM) {
        // For really large objects
        b = malloc(size);
    } else {

        if (p_TLS_orpthread->p_memory_free == 0)
        {
            void *p_xx = malloc(CHUNK_OF_RAM);
            p_TLS_orpthread->p_memory_start = (uint8 *)p_xx;
            p_TLS_orpthread->p_memory_end = p_TLS_orpthread->p_memory_start + CHUNK_OF_RAM - 1;
            p_TLS_orpthread->p_memory_free = p_TLS_orpthread->p_memory_start;
        }
        if (p_TLS_orpthread->p_memory_free + size >=
            p_TLS_orpthread->p_memory_end) 
        {
            void *p_xx = malloc(CHUNK_OF_RAM);
            p_TLS_orpthread->p_memory_start = (uint8 *)p_xx;
            p_TLS_orpthread->p_memory_end = p_TLS_orpthread->p_memory_start + CHUNK_OF_RAM - 1;
            p_TLS_orpthread->p_memory_free = p_TLS_orpthread->p_memory_start;        
        
        }

        b = (void *)p_TLS_orpthread->p_memory_free;
        p_TLS_orpthread->p_memory_free += size;
        assert(p_TLS_orpthread->p_memory_free <= p_TLS_orpthread->p_memory_end);
    }

    if(!b) {
        // BUGBUG: Should throw an exception here.
        orp_cout << "Out of memory" << endl;
        assert(0);
        orp_exit(1);
    }
    assert(b);
    memset(b, 0, size);
    // point b at the Vtable pointer.
    b = (void *)( (char *)b + OBJECT_HEADER_SIZE);
#ifdef ALIGN8
    b = (void *)((uint64)b + 7);
    b = (void *)((uint64)b & ~0x07);  // 8-byte align the object (we added 8 extra bytes above)
#else
    b = (void *)((uint64)b + 3);
    b = (void *)((uint64)b & ~0x03);  // 4-byte align the object (we added 4 extra bytes above)
#endif

    return (Java_java_lang_Object *)b;

} //gc_malloc_gc_none_v0_memory



Java_java_lang_Object *gc_malloc_gc_none_v0(unsigned size, Partial_Reveal_VTable *vtable)
{
    // Allocte memory first. Then, fix the vtable pointer before the object is returned.
	assert(size > 0);
	Java_java_lang_Object *obj = gc_malloc_gc_none_v0_memory(size);
	assert(obj);
  	assert(vtable);

  	*((void **)obj) = vtable;
	return obj;

}   // gc_malloc_gc_none_v0




//
// This routine is used to allocate an object. See the above 
// discussion on the overloading of size.
// The GC assumes that the ORP is ready to support a GC if it 
// calls this function.
//
// Input: size - the size of the object to allocate. If the high bit
//               set then various constraints as described above are
//               placed on the allocation of this object.
//        p_vtable - a pointer to the vtable of the class being allocated.
//                   This routine will place this value in the 
//                   appropriate slot of the new object.
//

Java_java_lang_Object *gc_malloc_slow(unsigned size,  VTable *p_vtable);

Java_java_lang_Object *gc_malloc(unsigned size, VTable *p_vtable) // VTable will be void
{
   // All chunks of data requested need to be multiples of GC_OBJECT_ALIGNMENT
    assert((size % GC_OBJECT_ALIGNMENT) == 0);

#ifdef GC_NONE_V0
    return gc_malloc_gc_none_v0 (size, p_vtable);
#endif

    assert (p_vtable);
    unsigned int class_constraints = p_vtable->class_properties;

    unsigned int real_size = get_instance_data_size (size);
    Java_java_lang_Object *result = gc_malloc_slow (real_size, p_vtable);

	assert (result->vt);
    gc_trace (result, "object is allocated");
    
    return  result; 
}

Java_java_lang_Object *gc_pinned_malloc (unsigned size, 
                                         VTable *p_vtable, 
                                         area_id area_hint)
{
    assert((size % GC_OBJECT_ALIGNMENT) == 0);
    return p_gc->gc_pinned_malloc(size,
                                  p_vtable,
                                  false, // returnNullOnFail,
                                  false
                                  );
}


// If there are no alignment or pinning constraints but possible finalization 
// or weak ref constraints then one can use this routine.

Java_java_lang_Object *gc_malloc_slow_no_constraints (unsigned size, VTable *p_vtable)
{

#ifdef GC_NONE_V0

	return gc_malloc_gc_none_v0(size, p_vtable);

#endif

    Java_java_lang_Object *p_return_object;

restart:

#ifdef OBJECT_SPLITTING
  	
    // For large arrays 
    if (size >= los_threshold_bytes) {
        // Either the hack bit is set and size of the array is therefore big, or it is not set 
        // and we have a really big array(or object) which had to land in the LOS anyway.
        return (Java_java_lang_Object *)p_gc->gc_pinned_malloc(
                                        (size & LARGE_ARRAY_HACK_CLEAR_MASK), 
		                                p_vtable, 
			    					    false, // returnNullOnFail
                                        false);
	}
#else
    //
	// See if this is a large object which needs special treatment:
	//
	if (size >= los_threshold_bytes) {
                // CLEANUP - remove this cast.
	    return (Java_java_lang_Object *)p_gc->gc_pinned_malloc(size, 
		                              p_vtable, 
			    					  false, // returnNullOnFail
                                      false);
	}
#endif // OBJECT_SPLITTING

    // End of LOS case.

    // We have a normal object free of the alignment or pinning 
    // constraints listed above, however,  it could need to be 
    // registered for finalization or be a weak ref.
    //
	// Try to allocate an object from the current nursery.
	// This can fail if the object won't fit in what is left of the 
    // nursery. This might happen if you are trying to create a
    // Large Object so we are prepared to pick up the pieces below.

    // We are going to all this trouble to eliminate the
    // los check.

#ifdef GC_SAPPHIRE
	Java_java_lang_Object *sapphire_gc_malloc (unsigned object_size, Partial_Reveal_VTable *p_vtable);
	p_return_object = sapphire_gc_malloc (size, p_vtable);
    if (p_return_object != NULL) {
		// We are doing a collection so 
		return p_return_object;
	}
#endif // GC_SAPPHIRE

    block_info *my_nursery = (block_info *)orp_get_nursery();
    void *p_obj_start = (void *)my_nursery->free;
    char *new_free = (char *)p_obj_start + size;
    if (GC_BLOCK_INFO(new_free) == GC_BLOCK_INFO(p_obj_start)) {
        // OK, there was enough space - return the object.
        p_return_object = P_OBJ_FROM_START(p_obj_start);
        p_return_object->vt = (VTable *)p_vtable;
        my_nursery->free = new_free; // Commit
	    return p_return_object;
    } else {
        p_return_object = NULL;
    }
#if (GC_DEBUG>0)
//    assert(  !orp_is_gc_enabled(p_TLS_orpthread) );
#endif
	//
	// OK, there was enough space - return the object we just allocated.
	//
	if (p_return_object) {
        
        gc_trace (p_return_object, "Allocated in gc_malloc_slow_no_constraints.");
	    return p_return_object;
    }


    //
	// The nursery for this thread is full. 
	// Retrieve the exhausted nursery.
	//
	block_info *p_old_nursery = (block_info *)orp_get_nursery();
    assert (p_old_nursery);

#if (GC_DEBUG>0)
//	p_old_nursery->set_owner_thread(0);
#endif
    
    // Remove nursery from thread structure.
	orp_change_nursery(NULL);
    
    //
	// Allocate a new nursery for this thread's use. 
	//
	block_info *p_new_nursery = p_cycle_nursery(p_old_nursery,
                                                   false);
    assert (p_new_nursery->nursery_status == active_nursery);
    assert ((block_info *)orp_get_nursery() == NULL);
    assert (p_new_nursery);
    assert (p_new_nursery->next == NULL);
//    orp_cout << " Setting new nursery to active " << ((void *)p_new_nursery) << endl;

    orp_change_nursery(p_new_nursery);
    // This finalizer code needs to be moved into its own thread!!!!
    // This kludge ends is very very buggy since the finalizer has access to this threads state
    // including things like this threads locks and can do things that can cause deadlock and so forth.
    if (running_finalizers_deferred) {
        orp_run_pending_finalizers();
        running_finalizers_deferred = 0;
    }
    goto restart;
}

//
// A helper function that is prepared to make sure that space is available for
// the object. We assume that the orp is prepared for a gc to happen within this
// routine.
//
Java_java_lang_Object *gc_malloc_slow(unsigned size, VTable *p_vtable) 
{

#ifdef GC_NONE_V0
	return gc_malloc_gc_none_v0(size, p_vtable);
#endif

	Java_java_lang_Object *p_return_object = NULL;

    unsigned int class_constraints = p_vtable->class_properties;

    if (class_constraints == 0) {
        p_return_object = gc_malloc_slow_no_constraints (size, p_vtable);
        return p_return_object;
    }

    if (get_prop_alignment(class_constraints)) {
#ifdef POINTER64
        // There is no special alignment hack needed for IA64
        assert(0);
#endif
        // We hava a special object that needs 
        //
        // In phase 1 of alignment, re-direct all objects
        // with special alignment needs to the LOS.
        // CLEANUP -- remove this cast....
        p_return_object = (Java_java_lang_Object *)p_gc->gc_pinned_malloc (size,
                                                  p_vtable,
                                                  false, // returnNullOnFail is false
                                                  true);
    }

#if 0 // 1 // FOR VERSION1 ONLY Just fall through and let los_threshold deal with pinned objects.
    if (p_return_object == NULL) {
        //
        // For GC Version 1 allocate everything out of fixed space.
        //
        p_return_object = p_gc->gc_pinned_malloc(size,
                                                 p_vtable,
                                                 false, // return null on fail
                                                 false  // double align
                                                );
    }
#endif

    // See what constraints are placed on this allocation and call the appropriate routine.
    // CLEANUP  -- remvoe this cast.
    if (p_return_object == NULL) {
        if (get_prop_pinned(class_constraints)) {
#ifdef OBJECT_SPLITTING
        // These should not have LARGE_ARRAY_HACK_SET_MASK set.
        assert(!(size & LARGE_ARRAY_HACK_SET_MASK));
#endif // OBJECT_SPLITTING
       
            p_return_object = (Java_java_lang_Object *)p_gc->gc_pinned_malloc(size,
                                                     p_vtable,
                                                     false,
                                                     false);
        }
    }

    if (p_return_object == NULL) {
        // alloc up an array or a normal object that needs to be finalized.
        p_return_object = gc_malloc_slow_no_constraints (size, p_vtable);
    }

    assert (p_return_object);

    if (get_prop_finalizable (class_constraints)) {
        p_young_gen->record_finalizable_object((Java_java_lang_Object *)p_return_object);
    }

    gc_trace (p_return_object, "Allocated in gc_malloc_slow.");
    return p_return_object;
}

//
// For bootstrapping situations, when we still don't have
// a class for the object. This routine is only available prior to 
// a call to the call gc_orp_initialized. If it is called after
// the call to gc_orp_initialized then the results are undefined. 
// The GC places NULL in the vtable slot of the newly allocated
// object.
// 
// The object allocated will be pinned, not finalizable and not an array.
//
// Input: size - the size of the object to allocate. The high bit
//               will never be set on this argument.
// Output: The newly allocated object
//
Java_java_lang_Object *gc_pinned_malloc_noclass(unsigned size) {

#ifdef GC_NONE_V0	
    // Only memory needs to be returned. VTable pointer need not be set.
	return gc_malloc_gc_none_v0_memory(size);
#else    // CLEANUP -- remove this cast.
	Java_java_lang_Object *p_return =
        (Java_java_lang_Object *)p_gc->gc_pinned_malloc_noclass(size); 
	gc_trace(p_return, "Allocated as a pinned object."); 
    return p_return;
#endif
}

/****
*
*  Routines to support threads.
* 
*****/
//
// This routine is called during thread startup to set
// an initial nursery for the thread.
//
// Comment - gc_thread_init and gc_thread_kill assume that
//           the current thread is the one we are interested in
//           If we passed in the thread then these things could be
//           cross inited and cross killed.
//
void gc_thread_init() 
{
#ifdef GC_SAPPHIRE
    ssb_container *an_ssb_container = (ssb_container *) malloc(sizeof (ssb_container));
    memset (an_ssb_container, 0, sizeof(ssb_container));
    p_TLS_orpthread->ssb_container = (void *)an_ssb_container;
#endif
    // The gc_get_new_nursery code is used to get a new nursery.
    return;
}

//
// Return a new nursery that the ORP requests. This can be during thread
// initialization so that calls to orp_get_nursery() will have a nursery to
// return.
// 
void *gc_get_new_nursery ()
{

#ifdef GC_NONE_V0
    //
    // Version one doesn't need nurseries.
    //
    return NULL;
#endif

    if (fixed_gc) {
        return NULL;
    }
    
    block_info *p_nursery = p_cycle_nursery(NULL, false);
    assert(p_nursery);
    return p_nursery;
}
//
// If the thread has a nursery it nolonger will use this
// is called. Typically after gc_thread_kill is called.
//
void gc_release_nursery (void *p_nursery)
{
    block_info *the_nursery = (block_info *)p_nursery;

    //
	// Store away that thread's nursery for subsequent
	// scavenging (during the next stop-the-world collection).
	//

    if (the_nursery != NULL) {
        // orphan the nursery.
        assert (the_nursery->nursery_status == active_nursery);
        the_nursery->nursery_status = spent_nursery;
    }
}
//
// This is called just before the thread is reclaimed.
//
void gc_thread_kill() {
    return;
}

/****
*
*  Routines to support the functionality required by the Java language specification.
* 
*****/

//
// API for the ORP to force a GC, typically in response to a call to 
// java.lang.Runtime.gc
//
void gc_force_gc() 
{
#ifdef GC_NONE_V0
    return;
#endif // GC_NONE_V0
#ifdef ORP_POSIX
    return;
#endif // ORP_POSIX
#if 0
    orp_cout << "ignoring force gc for now. " << endl;

    return;
#endif // Debugging sometimes is easier with forced gc's disabled.

    // Grab the GC lock and reclaim the heap.

    orp_enable_gc();

   	p_gc_lock->_lock_enum_or_null(false);

	p_gc->reclaim_heap(0, true); // force = true
    
  	p_gc_lock->_unlock_enum_or_null();

    orp_disable_gc();

}

//
// API for the ORP to determine the total GC heap, typically in response to a
// call to java.lang.Runtime.totalMemory
//
int64 gc_total_memory() 
{
#ifdef GC_NONE_V0
    return 0;
#endif // GC_NONE_V0
    
	int64 total_space_bytes;

	total_space_bytes =
		(int64)(get_total_block_count() * GC_BLOCK_SIZE_BYTES);

	//
	// MISSING: NEED TO ADD FREE SPACE IN UNUSED NURSERIES.
	//
	return total_space_bytes;
}

//
// API for the ORP to get an approximate view of the free space, 
// typically in response to a call to java.lang.Runtime.freeMemory
//
int64 gc_free_memory() 
{
#ifdef GC_NONE_V0
    return 0;
#endif // GC_NONE_V0
	int64 total_free_space_bytes;

	total_free_space_bytes =
		(int64)(get_free_block_count() * GC_BLOCK_SIZE_BYTES);

	//
	// MISSING: NEED TO ADD FREE SPACE IN UNUSED NURSERIES.
	//
	return total_free_space_bytes;
}

Gc_Interface *p_init_gc(ORP_Control *p_orp_control,
						char *p_plan_file_name)
{
    return new Mrl_Gc_V1(p_orp_control, p_plan_file_name);
}


#ifdef OBJECT_SPLITTING
int gc_get_cold_region_offset()
{
	return p_gc->get_large_nursery_size() / 2;
}
//
// If we turn object splitting back on this needs to be called with the vtable and not the class.
// This should be a straight forward change to jit_runtime_support.cpp.
//
unsigned int get_proper_array_size(Partial_Reveal_VTable *vt, unsigned int size)
{
   unsigned int class_constraints = vt->class_properties;

    if (get_prop_alignment(class_constraints)) {
		// Special alignment-constrained arrays land up in the LOS, 
		// and we need to return the same size for that....
		return size;
	}

    if (size >= los_threshold_bytes) { 
        // Lands up in LOS by definition
        return size;
    }

    if (2 * size >= los_threshold_bytes) { 
        // Still throw into the LOS...but rig the size so that it gets directed 
        // properly from gc_malloc_slow_no_constraints() into the LOS allocator.
        return (size | LARGE_ARRAY_HACK_SET_MASK);
    }
	// We allocate ALL "unconstrained" or "small" arrays in the split YOS....
	return size * 2;
}

#endif // OBJECT_SPLITTING


/****
*
*  Routines to support the functionality required by Jini to see if an object is pinned.
* 
*****/

bool gc_is_object_pinned (Java_java_lang_Object *obj)
{
#ifdef GC_NONE_V0
    return true;
#endif
    return p_global_bs->is_object_in_large_object_space(obj);
}

//
// End of code for the supported interface.
//

// *************************************************************************
//
//      ***********************************************************
//      *                                                         *
//      *    Warning                                   Warning    *
//      *           Warning                     Warning           *
//      *                  Warning       Warning                  *
//      *                         Warning                         *
//      *                  Warning       Warning                  *
//      *           Warning                     Warning           *
//      *    Warning                                   Warning    *
//      *                                                         *
//      ***********************************************************
//
// Code found below this line is provided for debugging and tuning 
// the current system. Implementors should not assume that these 
// routines will be available later today, much less tomorrow. The 
// mere thought that they might be around at the next release should 
// be dealt with by discussing if they should be moved above this line.
//
// *************************************************************************

// Uncomment the following when debugging ORP live
// reference enumeration problems, to generate 
// verbose debugging information:
// #define CHECK_LIVE_REFS

#if (GC_DEBUG>1)

#include "gc_for_orp.h"
#include "object_layout.h"
#include "gc_header.h"
#include "block_store.h"
#include "gc_space.h"

extern Block_Store *p_global_bs;

#endif // (GC_DEBUG>1)
// end file gc_interface.cpp
