// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/linux_api.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _Linux_H_
#define _Linux_H_

//
// This module encapsulates the OS-dependent routines. This particular
// one is for Linux.
//


#include "platform.h"

class Linux_Api {
    
public:

// protected:
    //
    // This routine reserves the specified amount of contiguous
    // virtual address space without committing any physical pages.
    //
    void *_p_os_reserve_virtual_space(unsigned long size);
    //
    // This routine commits the specified number of bytes of real
    // memory to commit at the specified virtual address space
    // in a region that was previously reserved.
    //
    //
    void *_p_os_commit_virtual_space(void *p_start, 
                                     unsigned long size);
    //
    // This routine elevates the level of the invoking worker (GC)
    // thread above those of the Java threads. 
    //
    void _p_os_boost_gc_thread_priority();
    //
    // This routine returns the level of the invoking worker thread
    // to normal.
    //
    void _p_os_drop_gc_thread_priority();

private:
};


#endif // _Linux_H_
