// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_ThreadGroup.cpp,v 1.4 2001/08/23 05:25:44 gwu2 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>
#include "environment.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_utils.h"
#include "orp_threads.h"
#include "java_lang_Thread.h"

 
#include "gc_for_orp.h"

#include "ini.h"
 
#ifdef ORP_POSIX
#include "platform2.h"
#endif


void init_threadgroup()
{
    Global_Env *env = ORP_Global_State::loader_env;

    // allocate the root ThreadGroup object
    String *ss = env->string_pool.lookup("java/lang/ThreadGroup");

    Loader_Exception ld_exc;
    Class *clss = class_load_verify_prepare(env, ss, &ld_exc);
    class_initialize(clss);

    volatile Classpath_Java_java_lang_ThreadGroup *root_thr_group_volatile;
#if 1
    Field *root_field = class_lookup_field_recursive(clss, "root", "Ljava/lang/ThreadGroup;");
    Classpath_Java_java_lang_ThreadGroup **root_addr = (Classpath_Java_java_lang_ThreadGroup **)root_field->get_address();
    assert(root_addr);
    assert(*root_addr);
    root_thr_group_volatile = *root_addr;
#else
    root_thr_group_volatile = (Classpath_Java_java_lang_ThreadGroup *)class_alloc_new_object(clss);

    Method *jltgi = 0;

    jltgi = object_lookup_method( (void *)root_thr_group_volatile, "<init>", "()V");

    orp_execute_java_method(jltgi, 0, root_thr_group_volatile, 0);
#endif


    // allocate the Thread object for ... public static void main(String args[])
    ss = env->string_pool.lookup("java/lang/Thread");

    clss = class_load_verify_prepare(env, ss, &ld_exc);
    class_initialize(clss);

    // do <init> by hand below for main's Thread object
    volatile Classpath_Java_java_lang_Thread *p_main_thread_volatile;
    p_main_thread_volatile = (Classpath_Java_java_lang_Thread *)class_alloc_new_object(clss);

//    p_main_thread_volatile->priority = java_lang_Thread_NORM_PRIORITY;
    gc_heap_slot_write_int32 ((Java_java_lang_Object *)p_main_thread_volatile,
        (int32 *)&(p_main_thread_volatile->priority),
        (int32)java_lang_Thread_NORM_PRIORITY);

//    p_main_thread_volatile->data = (Java_java_lang_Object *)0x00000000; ////(POINTER_SIZE_INT)p_TLS_orpthread;
#ifdef OLD_VERSION_CLASSPATH
    gc_heap_slot_write_ref ((Java_java_lang_Object *)p_main_thread_volatile,
        (Java_java_lang_Object **)&(p_main_thread_volatile->data),
        (Java_java_lang_Object *)NULL);
#else
    //wgs#: change "data" field to long type
    gc_heap_slot_write_pointer_size_int ((Java_java_lang_Object *)p_main_thread_volatile,
        (POINTER_SIZE_INT *)&(p_main_thread_volatile->data),
        (POINTER_SIZE_INT)0);
#endif

//    p_main_thread_volatile->daemon_flag = 0;
    //    gc_heap_write_int32 ((Java_java_lang_Object *)p_main_thread_volatile,
    //  (int32 *)&(p_main_thread_volatile->daemon_flag),
    //  (int32)0x0);

//    p_main_thread_volatile->group = (struct Classjava_lang_ThreadGroup *)root_thr_group_volatile;
    gc_heap_slot_write_ref ((Java_java_lang_Object *)p_main_thread_volatile,
        (Java_java_lang_Object **)&(p_main_thread_volatile->group),
        (Java_java_lang_Object *)root_thr_group_volatile);

    gc_heap_slot_write_ref ((Java_java_lang_Object *)p_main_thread_volatile,
	(Java_java_lang_Object **)&(p_main_thread_volatile->name), 
	(Java_java_lang_Object *)create_java_lang_String_from_C_string("main")); 


    p_TLS_orpthread->thread_id = GetCurrentThreadId();
    p_TLS_orpthread->p_java_lang_thread = (volatile Java_java_lang_Thread *)p_main_thread_volatile;

	int stat =
        DuplicateHandle(GetCurrentProcess(),	// handle to process with handle to duplicate
				GetCurrentThread(),		 	// handle to duplicate
				GetCurrentProcess(),		 	    // handle to process to duplicate to
                &(p_TLS_orpthread->thread_handle), // pointer to duplicate handle
				NULL,						 	// access for duplicate handle
				false,						 	// handle inheritance flag
				DUPLICATE_SAME_ACCESS		 	// optional actions
				);
    assert(stat);

    p_TLS_orpthread->thread_id = GetCurrentThreadId();

#ifdef ORP_POSIX
#else
    assert(p_TLS_orpthread->event_handle_monitor);
#endif

} //init_threadgroup

