// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_Runtime.cpp,v 1.13 2001/12/19 08:16:24 gwu2 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>
#include "root_set_enum.h"
#include "environment.h"
#include "object_layout.h"
#include "Class.h"
#include "orp_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"
#include "native_utils.h"
#include "method_lookup.h"
#include "jit_runtime_support.h"
#include "jit_intf_cpp.h"

#ifndef OBJECT_LOCK_V2
#include "find_natives.h"
#else
#include "find_natives_olv2.h"
#endif
#ifdef ORP_NT
#include <winbase.h>
#endif

#include "java_lang_Object.h"
#include "java_lang_Runtime.h"
#include "gc_for_orp.h"
#include "gnu_specific.h"


#ifdef ORP_POSIX
static char *ext = ".so";
static char *prefix = "lib";
#else
static char *ext = ".dll";
#endif


/*
 * Class:     java_lang_Runtime
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_java_lang_Runtime_init
  (JNIEnv *jenv, jobject obj)
{
	jclass runtime_class = jenv->FindClass("java/lang/Runtime");
	assert(runtime_class);
	jmethodID field_id = jenv->GetFieldID(runtime_class, "finalize_on_exit","Z");
	
	assert(field_id);
	jenv->SetBooleanField(obj, field_id, false);
} // Java_java_lang_Runtime_init


/*
 * Class:     java_lang_Runtime
 * Method:    loadLibrary
 * Signature: (Ljava/lang/String;)V
 */
// Implement loadLibrary in native to walk around the Class.<clinit>
// problem for new classpath
JNIEXPORT void JNICALL Java_java_lang_Runtime_loadLibrary
  (JNIEnv *jenv, jobject jobj , jstring lib_name)
{

#if 0
	orp_monitor_enter( (Java_java_lang_Object *)(jobj));
#endif

/*
	// Call the "checklink" method.
	jclass runtime_class = jenv->FindClass("java/lang/Runtime");
	assert(runtime_class);
	jmethodID checkLink_ID = jenv->GetMethodID(runtime_class, "checkLink", 
										"(Ljava/lang/String;)V");
	jenv->DeleteLocalRef(runtime_class);
	jvalue jarg[1];
	jarg[0].l = lib_name;
	jenv->CallVoidMethodA(jobj, checkLink_ID, jarg);
*/
	// Now, load the required library using "add_dll"
	jint len;
	char* name = JavaStringToCharArray (jenv, lib_name, &len);
	assert(name);
#ifdef ORP_POSIX
    len = strlen(name) + strlen(ext) + strlen(prefix) + 2;
#else
    len = strlen(name) + strlen(ext) + 2;
#endif

    char *pathname = (char *)malloc(len);
#ifdef ORP_POSIX
    sprintf(pathname, "%s%s%s", prefix, name, ext);
#else
    sprintf(pathname, "%s%s", name, ext);
#endif
    
	ORPExport void add_dll(const char *file_name, Class_Loader *loader);
	add_dll(pathname, 0);

    free(pathname);

    free(name);

	return ;

#if 0	
  orp_monitor_enter( (Java_java_lang_Object *)(jobj));
#endif

} // Java_java_lang_Runtime_loadLibrary


/*
 * Class:     java_lang_Runtime
 * Method:    gc
 * Signature: ()V
 */

JNIEXPORT void JNICALL Java_java_lang_Runtime_gc
  (JNIEnv *jenv, jobject jobj)
{
    gc_force_gc();
} // Java_java_lang_Runtime_gc


/*
 * Class:     java_lang_Runtime
 * Method:    exit
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_java_lang_Runtime_exitInternal
  (JNIEnv *jenv, jobject jobj, jint status)
{
#if 0 
	// Call the "checkExit" method.
	jclass runtime_class = jenv->FindClass("java/lang/Runtime");
	assert(runtime_class);
	jmethodID checkExit_ID = jenv->GetStaticMethodID(runtime_class, "checkExit", "(I)V");
	jvalue jarg[1];
	jarg[0].i = status;
	jenv->CallVoidMethodA(jobj, checkExit_ID, jarg);

	// Run finalizers if needed.
	jfieldID field_id = jenv->GetFieldID(runtime_class, "finalize_on_exit", "Z");
	assert(field_id);
	jboolean finalize_on_exit = jenv->GetBooleanField(jobj, field_id);

	if (finalize_on_exit) {
		// Need to run finalizers here...What is the right code for this??
		assert(0);
	}
#endif
	// Exit with the status that was passed in.
	orp_exit(status);

} // Java_java_lang_Runtime_exit


/*
 * Class:     java_lang_Runtime
 * Method:    freeMemory
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_java_lang_Runtime_freeMemory
  (JNIEnv *, jobject)
{
    return gc_free_memory();
} // Java_java_lang_Runtime_freeMemory



/*
 * Class:     java_lang_Runtime
 * Method:    load
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT jint JNICALL Java_java_lang_Runtime_nativeLoad
  (JNIEnv *jenv, jobject jobj, jstring libname)
{
    // A nop for now.
    jboolean isCopy;
    const char *name = jenv->GetStringUTFChars(libname, &isCopy);
    ORPExport void add_dll(const char *file_name, Class_Loader *loader);
    add_dll(name, 0);
    jenv->ReleaseStringUTFChars(libname, name);
    return 1;
} // Java_java_lang_Runtime_nativeLoad




/*
 * Class:     java_lang_Runtime
 * Method:    runFinalization
 * Signature: ()V
 */
JNIEXPORT void JNICALL Java_java_lang_Runtime_runFinalization
  (JNIEnv *, jobject)
{
	// This is currently a no-op since we run finalizers immediately after the
    // GC discovers objects that should be finalized.
} // Java_java_lang_Runtime_runFinalization


/*
 * Class:     Runtime
 * Method:    runFinalizersOnExitInternal
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_java_lang_Runtime_runFinalizersOnExitInternal
  (JNIEnv *, jclass, jboolean)
{

}


/*
 * Class:     java_lang_Runtime
 * Method:    totalMemory
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_java_lang_Runtime_totalMemory
  (JNIEnv *, jobject)
{
    return gc_total_memory();
} // Java_java_lang_Runtime_totalMemory



/*
 * Class:     java_lang_Runtime
 * Method:    traceInstructions
 * Signature: (Z)V
 */
JNIEXPORT void JNICALL Java_java_lang_Runtime_traceInstructions
  (JNIEnv *, jobject, jboolean)
{
  // This method is no-op for a "normal interpreter" (see The Java Class
  // Libraries Second Edition, Volume 1, Addison-Wesley 1998).
} // Java_java_lang_Runtime_traceInstructions


/*
 * Class:     java_lang_Runtime
 * Method:    traceMethodCalls
 * Signature: (Z)V
 */

JNIEXPORT void JNICALL Java_java_lang_Runtime_traceMethodCalls
  (JNIEnv *, jobject, jboolean)
{
  // This method is no-op for a "normal interpreter" (see The Java Class
  // Libraries Second Edition, Volume 1, Addison-Wesley 1998)
} // Java_java_lang_Runtime_traceMethodCalls


/*
 * Class:     Runtime
 * Method:    execInternal
 * Signature: ([Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Process;
 */
JNIEXPORT jobject JNICALL Java_java_lang_Runtime_execInternal
  (JNIEnv *jenv, jobject pthis, jobjectArray cmd, jobjectArray env)
{
    jclass pclzz = FindClass(jenv, "java/lang/PlatformProcess");
	Class *pclss = (Class *)((Object_Handle)pclzz)->java_reference;
	orp_disable_gc(); 
	Java_java_lang_Object *new_obj = (Java_java_lang_Object *)class_alloc_new_object(pclss);
	Object_Handle clo = orp_create_local_object_handle();
	clo->java_reference = (Java_java_lang_Object *)new_obj;
	orp_enable_gc();  

	jmethodID cntr = GetMethodID (jenv, pclzz, "<init>", "([Ljava/lang/String;[Ljava/lang/String;)V");
	CallVoidMethod(jenv, clo, cntr, cmd, env);

    return (jobject)clo;
}


/*
 * Class:     Runtime
 * Method:    getLibraryPath
 * Signature: ()Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_java_lang_Runtime_getLibraryPath
  (JNIEnv *jenv, jclass jc)
{
#ifdef OLD_VERSION_CLASSPATH
    return jenv->NewStringUTF("");
#else
//this is for GNU Classpath implementation of Runtime(),
//otherwise a call of File.pathSeparatorChar will incur (deadly) recursive 
//initialization problem. 

    return NULL;

    //return jenv->NewStringUTF("");
#endif
} //Java_java_lang_Runtime_getLibraryPath



/*
 * Class:     Runtime
 * Method:    nativeGetLibname
 * Signature: (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_java_lang_Runtime_nativeGetLibname
  (JNIEnv *jenv, jobject jobj, jstring libpath, jstring libname)
{
    jboolean isCopy;
    const char *path = jenv->GetStringUTFChars(libpath, &isCopy);
    const char *name = jenv->GetStringUTFChars(libname, &isCopy);

    // Extra bytes:
    //  1 - terminating '\0'
    // +1 - path separator '/' or '\\'
    // -------
    //  2 - total
    int len = strlen(path) + strlen(name) + strlen(ext) + 2 
#ifdef ORP_POSIX
              + strlen(prefix)
#endif
		;

    char *pathname = (char *)malloc(len);
#ifndef ORP_POSIX
    if(strlen(path)) {
      sprintf(pathname, "%s%c%s%s", path, DIR_SEPARATOR, name, ext);
    } else {
      sprintf(pathname, "%s%s", name, ext);
    }
#else
    if(strlen(path)) {
      sprintf(pathname, "%s%c%s%s%s", path, DIR_SEPARATOR, prefix,  name, ext);
    } else {
      sprintf(pathname, "%s%s%s", prefix, name, ext);
    }
#endif
    //printf("***** name='%s'\n", pathname);
    jstring result = jenv->NewStringUTF(pathname);
    free(pathname);
    jenv->ReleaseStringUTFChars(libpath, path);
    jenv->ReleaseStringUTFChars(libname, name);
    return result;
} //Java_java_lang_Runtime_nativeGetLibname



JNIEXPORT jobject JNICALL Java_gnu_vm_stack_StackTrace_copyCurrentStackTrace
  (JNIEnv *jenv, jclass)
{
#ifndef USE_IA64_JIT
	jclass stackframe_class = jenv->FindClass("gnu/vm/stack/StackFrame");
	jmethodID stackframe_init_method_id = jenv->GetMethodID(stackframe_class,"<init>",
			"(Ljava/lang/Object;Ljava/lang/reflect/Method;ILjava/lang/String;)V");
	
	int frame_array_size = 100;
	jobject *frame_array;
	frame_array = (jobject *)malloc(frame_array_size*sizeof(jobject));
	jclass method_class = jenv->FindClass("java/lang/reflect/Method");
	jmethodID method_init_method_id = jenv->GetMethodID(method_class,"<init>",
		"(Ljava/lang/Class;Ljava/lang/String;I)V");
	
	Boolean have_thr_context = FALSE;
	Frame_Context thr_context;
	if (p_TLS_orpthread->throw_context) {
		orp_copy_frame_context(&thr_context, p_TLS_orpthread->throw_context);
		have_thr_context = TRUE;
	}
	int java_frame_num = 0;
	Frame_Context context;
	context.ljf   = (uint32)get_orp_last_java_frame();
	context.eip   = 0;
	context.p_eip = &(context.eip);
	
	Boolean is_first = TRUE;
	Boolean finished = FALSE;
	Boolean throw_context_used = FALSE;
	while (!finished) {
        orp_disable_gc();       //--------------------------------------------v
		Boolean result = unwind_to_next_java_frame(&context,is_first,FALSE);
        orp_enable_gc();        //--------------------------------------------^
		if (result) {
			JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
			is_first = FALSE;
			Method *m = jit_info->get_method();
			const String* m_str_name = m->get_name();
			const char* m_c_name = m_str_name->bytes;
			jstring m_name = jenv->NewStringUTF(m_c_name);
			
			jclass def_class = orp_create_local_object_handle();
			((Object_Handle)def_class)->java_reference = (Java_java_lang_Object *)m->get_class();
			
			jobject method_object = jenv->NewObject(method_class,method_init_method_id,
				def_class,m_name,0);
			jobject stackframe_object = jenv->NewObject(stackframe_class,
				stackframe_init_method_id,(jobject)NULL,method_object,-1,0);
			java_frame_num++;
			if(  java_frame_num == frame_array_size) {
				frame_array_size *=10;
				frame_array = (jobject *)realloc(frame_array,frame_array_size*sizeof(jobject));
			}
			frame_array[java_frame_num-1] =stackframe_object;			
		} else {
			if((!throw_context_used)&&(have_thr_context)) {
				throw_context_used = TRUE;
				orp_copy_frame_context(&context, &thr_context);
				is_first = TRUE;
				java_frame_num++;
				JIT_Specific_Info *jit_info = methods.find((void *)*context.p_eip);
				Method *m = jit_info->get_method();
				const String* m_str_name = m->get_name();
				const char* m_c_name = m_str_name->bytes;
				jstring m_name = jenv->NewStringUTF(m_c_name);
				
				jclass def_class = orp_create_local_object_handle();
				((Object_Handle)def_class)->java_reference = (Java_java_lang_Object *)m->get_class();
				
				jobject method_object = jenv->NewObject(method_class,method_init_method_id,
					def_class,m_name,0);
				jobject stackframe_object = jenv->NewObject(stackframe_class,
					stackframe_init_method_id,(jobject)NULL,method_object,-1,0);
				if(  java_frame_num == frame_array_size) {
					frame_array_size *=10;
					frame_array = (jobject *)realloc(frame_array,frame_array_size*sizeof(jobject));
				}
				frame_array[java_frame_num-1] =stackframe_object;			
			}else{
				finished = TRUE;
			}
		} //if (result)
	} // while (!finished)
	
	jobjectArray stackframe_array = jenv->NewObjectArray(java_frame_num,stackframe_class,0);
	for (int i=0;i<java_frame_num;i++)
		jenv->SetObjectArrayElement(stackframe_array,i,frame_array[java_frame_num-1-i]);
	free(frame_array);
	
	jclass stacktrace_class = jenv->FindClass("gnu/vm/stack/StackTrace");
	jmethodID method_id = jenv->GetMethodID(stacktrace_class, "<init>","([Lgnu/vm/stack/StackFrame;)V");
	jobject trace = jenv->NewObject(stacktrace_class,method_id,stackframe_array);
	return trace;
#else
    assert(0);
    return 0;
#endif
} //Java_gnu_vm_stack_StackTrace_copyCurrentStackTrace

Java_java_lang_String *java_lang_String_intern(Java_java_lang_String *jstr_obj)
{
	Classpath_Java_java_lang_String *cpstr_obj= 
		(Classpath_Java_java_lang_String *)jstr_obj;
	JavaArrayOfChar *ch_arr = cpstr_obj->value;
	unsigned utf_len = get_utf8_length_of_unicode(ch_arr->body,ch_arr->length);
	char *buff = (char *)malloc(utf_len+1);
	pack_utf8(buff,ch_arr->body,ch_arr->length);
	String *str = ORP_Global_State::loader_env->string_pool.lookup(buff);
	free(buff);
	Java_java_lang_String *jl_str = NULL;
	if (str->intern)
		jl_str = str->intern;
	else
		jl_str = orp_instantiate_cp_string_resolved(str);
	return jl_str;

} // Java_java_lang_String_intern

