// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/dlink.h,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//

#ifndef _DLINK_H
#define _DLINK_H

class Dlink {
public:
    Dlink() {_next = _prev = this;}
    //
    // routines for manipulating double linked list
    //
    void unlink(){_prev->_next=_next;_next->_prev=_prev;_next=_prev=this;}
    // insert "this" after "prev_link"
    void insert_after(Dlink *prev_link) {
        _prev = prev_link;
        _next = prev_link->_next;
        prev_link->_next = this;
        _next->_prev = this;
    }
    void insert_before(Dlink *next_link) {
        _next = next_link;
        _prev = next_link->_prev;
        next_link->_prev = this;
        _prev->_next = this;
    }
    Dlink *get_next() {return _next;}
    Dlink *get_prev() {return _prev;}
protected:
    Dlink *_next, *_prev;
};

#endif // _DLINK_H
