// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/debugger/include/debugger_jvmdi_ia32.h,v 1.2 2001/12/07 00:16:00 xli18 Exp $
//


#ifndef _DEBUGGER_JVMDI_IA32_H_
#define _DEBUGGER_JVMDI_IA32_H_

extern JIT *o1_jit;

extern bool enter_the_debugger;

static char buff[BUFF_SIZE];
static char buff_class[BUFF_SIZE];
static char buff_method[BUFF_SIZE];
static char buff_descriptor[BUFF_SIZE];

static char disasm_buffer[80000];

#define UNKNOWN_LINE_NUM 999999
#define UNKNOWN_BYTECODE_NUM 999999

extern bool jvmdi_verbose;

extern bool print_exceptions;
enum breakpoint_level{source_level,bytecode_level};

void my_gets(char *bp);
void separate_str(char *str,char separator,char* sub1,char* sub2);
void separate_str_from_end(char *str,char separator,char* sub1,char* sub2);
void str_chg_chs(char *str,char old_c,char new_c);
void temp_jvmdi_debugger(void *p_eip_arg);
void init_jvmdi_debugger();


#define NBREAKPOINTS 8
#define BREAKPOINT_AT_BEGIN 0
#define BP_LOC_UNKNOWN -1

extern jvmdi_bp breakpoints[];
extern uint8 breakpoints_num;

extern jvmdi_bp bytecode_breakpoints[];
extern uint8 bytecode_breakpoints_num;


extern bool jvmdi_verbose;

#define SINGLE_STEP_PTS 1024
#define BYTECODE_SINGLE_STEP_PTS 1024
#define EXCEPTION_HANDLER_BREAK_PTS 1024

extern jvmdi_ss single_step_points[];
// generelly,the bytecode single step points is no more than 2, but instruction "jsr",
// "tableswithch" and "lookupswitch" may need more.
extern jvmdi_ss bytecode_single_step_points[];
extern jvmdi_ss exception_handler_break_points[];
extern jvmdi_bp bytecode_step_into_break_point;

#endif