/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "TexView.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TTextureViewWnd *TextureViewWnd;
//---------------------------------------------------------------------------
__fastcall TTextureViewWnd::TTextureViewWnd(TComponent* Owner,Art *_art,int _texID)
    : TForm(Owner)
{
    art=_art; texID=_texID;
    doubleSize=true;
}
//---------------------------------------------------------------------------
void __fastcall TTextureViewWnd::PaintBox1Paint(TObject *Sender)
{
    art->RequestTextureData(texID);
    if (!art->data) return;
    Graphics::TBitmap *tex=new Graphics::TBitmap;
    if (doubleSize)
    {
        tex->Width=art->origSizeX[texID]*2;
        tex->Height=art->origSizeY[texID]*2;
        tex->PixelFormat=pf24bit;
        for (int y=0;y<art->origSizeY[texID]*2;y++)
        {
            char *buf=(char*)tex->ScanLine[y];
            for (int x=0;x<art->origSizeX[texID]*2;x++)
            {
                *(buf++)=art->palB[0][art->data[texID][(y>>1)*art->sizeX[texID]+(x>>1)]];
                *(buf++)=art->palG[0][art->data[texID][(y>>1)*art->sizeX[texID]+(x>>1)]];
                *(buf++)=art->palR[0][art->data[texID][(y>>1)*art->sizeX[texID]+(x>>1)]];
            }
        }
    }
    else
    {
        tex->Width=art->origSizeX[texID];
        tex->Height=art->origSizeY[texID];
        tex->PixelFormat=pf24bit;
        for (int y=0;y<art->origSizeY[texID];y++)
        {
            char *buf=(char*)tex->ScanLine[y];
            for (int x=0;x<art->origSizeX[texID];x++)
            {
                *(buf++)=art->palB[0][art->data[texID][y*art->sizeX[texID]+x]];
                *(buf++)=art->palG[0][art->data[texID][y*art->sizeX[texID]+x]];
                *(buf++)=art->palR[0][art->data[texID][y*art->sizeX[texID]+x]];
            }
        }
    }
    PaintBox1->Canvas->Draw(0,0,tex);
    delete tex;
}
//---------------------------------------------------------------------------
void __fastcall TTextureViewWnd::FormShow(TObject *Sender)
{
    ClientWidth=art->origSizeX[texID]*2;
    ClientHeight=art->origSizeY[texID]*2;
    PaintBox1->Hint="Double click for small view";
}
//---------------------------------------------------------------------------
void __fastcall TTextureViewWnd::FormDblClick(TObject *Sender)
{
    doubleSize=!doubleSize;
    if (doubleSize)
    {
        ClientWidth=art->origSizeX[texID]*2;
        ClientHeight=art->origSizeY[texID]*2;
        PaintBox1->Hint="Double click for small view";
    }
    else
    {
        ClientWidth=art->origSizeX[texID];
        ClientHeight=art->origSizeY[texID];
        PaintBox1->Hint="Double click for large view";
    }
}
//---------------------------------------------------------------------------

