/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef PLATFORM_UNIX
#include <vcl.h>
#endif
#include <math.h>
#include "FixPoly.h"
//---------------------------------------------------------------------------

static int PointInPoly(SplitPoly &poly,float x,float y)
{
    int c=0;
    for (int i=0,j=poly.points-1;i<poly.points;j=i++)
    {
        if ((((poly.point[i].y<=y)&&(y<poly.point[j].y))||
            ((poly.point[j].y<=y)&&(y<poly.point[i].y)))&&
            (x<(poly.point[j].x-poly.point[i].x)*
            (y-poly.point[i].y)/(poly.point[j].y-
            poly.point[i].y)+poly.point[i].x))
            c=!c;
    }
    return c;
}

static int IsLineOutside(SplitPoly &poly,int i,int j)
{
    if ((((i+1)%poly.points)==j)||(((j+1)%poly.points)==i))
        return 0;
    float x1=poly.point[i].x;
    float y1=poly.point[i].y;
    float x2=poly.point[j].x;
    float y2=poly.point[j].y;
    float xmid=(x1+x2)/2;
    float ymid=(y1+y2)/2;
    if (!PointInPoly(poly,xmid,ymid))
        return 1;
    float a=y1-y2;
    float b=x2-x1;
    float c=x1*(y2-y1)-y1*(x2-x1);
    for (int i=0,j=1;i<poly.points;i++,j=(j+1)%poly.points)
    {
        float d=poly.point[i].y-poly.point[j].y;
        float e=poly.point[j].x-poly.point[i].x;
        float f=poly.point[i].x*(poly.point[j].y-poly.point[i].y)-poly.point[i].y*(poly.point[j].x-poly.point[i].x);
        float x,y;
        if ((a*e-b*d)<0.001)
            continue;
        x=(b*f-c*e)/(a*e-b*d);
        y=-(a*f-c*d)/(a*e-b*d);
        if (fabs(x2-x1)>fabs(y2-y1))
        {
            if (x2>x1)
            {
                if ((x<=x1)||(x>=x2)||(fabs(x-x1)<0.001)||(fabs(x-x2)<0.001))
                    continue;
            }
            else
            {
                if ((x<=x2)||(x>=x1)||(fabs(x-x1)<0.001)||(fabs(x-x2)<0.001))
                    continue;
            }
        }
        else
        {
            if (y2>y1)
            {
                if ((y<=y1)||(y>=y2)||(fabs(y-y1)<0.001)||(fabs(y-y2)<0.001))
                    continue;
            }
            else
            {
                if ((y<=y2)||(y>=y1)||(fabs(y-y1)<0.001)||(fabs(y-y2)<0.001))
                    continue;
            }
        }
        if (fabs(poly.point[j].x-poly.point[i].x)>fabs(poly.point[j].y-poly.point[i].y))
        {
            if (poly.point[j].x>poly.point[i].x)
            {
                if ((x>=poly.point[i].x)&&(x<=poly.point[j].x)&&(fabs(x-poly.point[i].x)>0.001)&&(fabs(x-poly.point[j].x)>0.001))
                    return 1;
            }
            else
            {
                if ((x>=poly.point[j].x)&&(x<=poly.point[i].x)&&(fabs(x-poly.point[i].x)>0.001)&&(fabs(x-poly.point[j].x)>0.001))
                    return 1;
            }
        }
        else
        {
            if (poly.point[j].y>poly.point[i].y)
            {
                if ((y>=poly.point[i].y)&&(y<=poly.point[j].y)&&(fabs(y-poly.point[i].y)>0.01)&&(fabs(y-poly.point[j].y)>0.01))
                    return 1;
            }
            else
            {
                if ((y>=poly.point[j].y)&&(y<=poly.point[i].y)&&(fabs(y-poly.point[i].y)>0.01)&&(fabs(y-poly.point[j].y)>0.01))
                    return 1;
            }
        }
    }
    return 0;
}

void FixPoly(SplitPolys &polys)
{
    int sp=0;
    int split=1;
    int tries=polys.poly[0].points;
    static SplitPoly temp;
    while (split&&tries)
    {
        split=0;
        int p=polys.poly[0].points;
        int n=1;
        for (int i=(sp+2)%p;i!=sp;i=(i+1)%p)
        {
            n++;
            if (IsLineOutside(polys.poly[0],sp,i))
            {
                split=1;
                if (n<3)
                {
                    sp=(sp+1)%p;
                    break;
                }
                int pn=polys.polys++;
                polys.poly[pn].points=n;
                for (int j=sp,k=0,count=n;count;count--,j=(j+1)%p,k++)
                    polys.poly[pn].point[k]=polys.poly[0].point[j];
                temp.points=polys.poly[0].points-(n-2);
                if (temp.points<3)
                {
                    polys.poly[0]=polys.poly[pn];
                    polys.polys--;
                    return;
                }
                temp.point[0]=polys.poly[0].point[sp];
                for (int j=(sp+n-1)%p,k=1;j!=sp;j=(j+1)%p,k++)
                    temp.point[k]=polys.poly[0].point[j];
                polys.poly[0]=temp;
                sp=0;
                tries=polys.poly[0].points;
                break;
            }
            if (i==sp)
                break;
        }
        tries--;
    }
    temp.points=polys.poly[0].points;
    for (int j=sp,k=0,n=temp.points;n;j=(j+1)%polys.poly[0].points,k++,n--)
        temp.point[k]=polys.poly[0].point[j];
    polys.poly[0]=temp;
}

