/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __LINUX_INC_H__
#define __LINUX_INC_H__

// General defines to make porting a tad easier... - DDOI
#define HWND int
#define DWORD unsigned int
#define HANDLE int
#define D3DMATRIX MATRIX
#define CDirectDraw CSDL
#define HFONT int
#define HDC int
#define hInst int
#define HGLRC int
#define BYTE unsigned char
#define _USERENTRY

#define stricmp strcasecmp

#define WAVE_FORMAT_PCM (0x0001)

#define RGBA_MAKE(r, g, b, a) ((unsigned long) (((a) << 24) | ((r) << 16) | ((g) << 8) | (b))) 

#define WORD unsigned short
#define DWORD unsigned int
// Get a .bmp spec and check out if this is 64 bits for real - DDOI
#define LONG long long

// needed in Sound.h
typedef struct { 
    WORD  wFormatTag; 
    WORD  nChannels; 
    DWORD nSamplesPerSec; 
    DWORD nAvgBytesPerSec; 
    WORD  nBlockAlign; 
    WORD  wBitsPerSample; 
    WORD  cbSize; 
} WAVEFORMATEX; 

// some stuff needed in OpenGLRender.cpp
typedef struct tagBITMAPFILEHEADER { 
  WORD    bfType; 
  DWORD   bfSize; 
  WORD    bfReserved1; 
  WORD    bfReserved2; 
  DWORD   bfOffBits; 
} BITMAPFILEHEADER, *PBITMAPFILEHEADER;

typedef struct tagBITMAPINFOHEADER{
  DWORD  biSize; 
  LONG   biWidth; 
  LONG   biHeight; 
  WORD   biPlanes; 
  WORD   biBitCount;
  DWORD  biCompression; 
  DWORD  biSizeImage; 
  LONG   biXPelsPerMeter; 
  LONG   biYPelsPerMeter; 
  DWORD  biClrUsed; 
  DWORD  biClrImportant; 
} BITMAPINFOHEADER, *PBITMAPINFOHEADER;  

// Implement these somewhere - DDOI
char *strlwr (char *string);
DWORD GetTickCount(void);

// rcg11032000 Win32 virtual keys -> SDL keys.

// This VkKeyScan() hack covers all the ASCII keys, as the "scancode" is
//  the same as the ASCII equivalent where possible in SDL.
#define VkKeyScan(x) ((WORD) (x))

#define VK_BACK               SDLK_BACKSPACE
#define VK_TAB                SDLK_TAB
#define VK_CLEAR              SDLK_CLEAR
#define VK_RETURN             SDLK_RETURN
#define VK_SHIFT              SDLK_RSHIFT
#define VK_CONTROL            SDLK_RCTRL
#define VK_MENU               SDLK_RALT
#define VK_PAUSE              SDLK_PAUSE
#define VK_CAPITAL            SDLK_CAPSLOCK
#define VK_ESCAPE             SDLK_ESCAPE
#define VK_SPACE              SDLK_SPACE
#define VK_PRIOR              SDLK_PAGEUP
#define VK_NEXT               SDLK_PAGEDOWN
#define VK_END                SDLK_END
#define VK_HOME               SDLK_HOME
#define VK_LEFT               SDLK_LEFT
#define VK_UP                 SDLK_UP
#define VK_RIGHT              SDLK_RIGHT
#define VK_DOWN               SDLK_DOWN
#define VK_PRINT              SDLK_PRINT
#define VK_SNAPSHOT           SDLK_PRINT
#define VK_INSERT             SDLK_INSERT
#define VK_DELETE             SDLK_DELETE
#define VK_LWIN               SDLK_LSUPER
#define VK_RWIN               SDLK_RSUPER

// !!! 0 - 9?
// !!! A - Z?

#define VK_NUMPAD0            SDLK_KP0
#define VK_NUMPAD1            SDLK_KP1
#define VK_NUMPAD2            SDLK_KP2
#define VK_NUMPAD3            SDLK_KP3
#define VK_NUMPAD4            SDLK_KP4
#define VK_NUMPAD5            SDLK_KP5
#define VK_NUMPAD6            SDLK_KP6
#define VK_NUMPAD7            SDLK_KP7
#define VK_NUMPAD8            SDLK_KP8
#define VK_NUMPAD9            SDLK_KP9
#define VK_MULTIPLY           SDLK_KP_MULTIPLY
#define VK_ADD                SDLK_KP_PLUS
#define VK_SUBTRACT           SDLK_KP_MINUS
#define VK_DECIMAL            SDLK_KP_PERIOD
#define VK_DIVIDE             SDLK_KP_DIVIDE
#define VK_F1                 SDLK_F1
#define VK_F2                 SDLK_F2
#define VK_F3                 SDLK_F3
#define VK_F4                 SDLK_F4
#define VK_F5                 SDLK_F5
#define VK_F6                 SDLK_F6
#define VK_F7                 SDLK_F7
#define VK_F8                 SDLK_F8
#define VK_F9                 SDLK_F9
#define VK_F10                SDLK_F10
#define VK_F11                SDLK_F11
#define VK_F12                SDLK_F12
#define VK_F13                SDLK_F13
#define VK_F14                SDLK_F14
#define VK_F15                SDLK_F15
#define VK_NUMLOCK            SDLK_NUMLOCK
#define VK_SCROLL             SDLK_SCROLLOCK
#define VK_LSHIFT             SDLK_LSHIFT
#define VK_RSHIFT             SDLK_RSHIFT
#define VK_LCONTROL           SDLK_LCONTROL
#define VK_RCONTROL           SDLK_RCONTROL
#define VK_LMENU              SDLK_LALT
#define VK_RMENU              SDLK_RALT

// !!! are these keys important?  --ryan.
//#define VK_SELECT
//#define VK_EXECUTE
//#define VK_HELP
//#define VK_APPS
//#define VK_SLEEP
//#define VK_SEPARATOR
//#define VK_F16
//#define VK_F17
//#define VK_F18
//#define VK_F19
//#define VK_F20
//#define VK_F21
//#define VK_F22
//#define VK_F23
//#define VK_F24
//#define VK_BROWSER_BACK
//#define VK_BROWSER_FORWARD
//#define VK_BROWSER_REFRESH
//#define VK_BROWSER_STOP
//#define VK_BROWSER_SEARCH
//#define VK_BROWSER_FAVORITES
//#define VK_BROWSER_HOME
//#define VK_VOLUME_MUTE
//#define VK_VOLUME_DOWN
//#define VK_VOLUME_UP
//#define VK_MEDIA_NEXT_TRACK
//#define VK_MEDIA_PREV_TRACK
//#define VK_MEDIA_STOP
//#define VK_MEDIA_PLAY_PAUSE
//#define VK_LAUNCH_MAIL
//#define VK_LAUNCH_MEDIA_SELECT
//#define VK_LAUNCH_APP1
//#define VK_LAUNCH_APP2
//#define VK_OEM_1
//#define VK_OEM_PLUS
//#define VK_OEM_COMMA
//#define VK_OEM_MINUS
//#define VK_OEM_PERIOD
//#define VK_OEM_2
//#define VK_OEM_3
//#define VK_OEM_4
//#define VK_OEM_5
//#define VK_OEM_6
//#define VK_OEM_7
//#define VK_OEM_8
//#define VK_OEM_102
//#define VK_PROCESSKEY
//#define VK_PACKET
//#define VK_ATTN
//#define VK_CRSEL
//#define VK_EXSEL
//#define VK_EREOF
//#define VK_PLAY
//#define VK_ZOOM
//#define VK_NONAME
//#define VK_PA1
//#define VK_OEM_CLEAR

// Stay tuned... more to come - DDOI
#endif
