/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __VIEW_H__
#define __VIEW_H__

#ifndef PLATFORM_UNIX
#include "Direct3D.h"
#endif
#include "Math3D.h"

static Vector _vect;

class CView
{
	CDirect3D *D3D;
	int isActive;
	float x,y,z,ax,ay,az;
	D3DMATRIX matrix;
	D3DVIEWPORT7 vd;
	int update;
public:
	CView(CDirect3D *d3d);
	~CView();
    D3DVIEWPORT7* GetViewport() { return &vd; }
	void SetViewRect(RECT r);
	void SetXPos(float _x) { x=_x; update=1; }
	void SetYPos(float _y) { y=_y; update=1; }
	void SetZPos(float _z) { z=_z; update=1; }
	void SetXAngle(float _x) { ax=_x; update=1; }
	void SetYAngle(float _y) { ay=_y; update=1; }
	void SetZAngle(float _z) { az=_z; update=1; }
	void AddXPos(float _d) { x+=_d; update=1; }
	void AddYPos(float _d) { y+=_d; update=1; }
	void AddZPos(float _d) { z+=_d; update=1; }
	void GoForward(float d);
	void GoSide(float d);
	void AddXAngle(float _a) { ax+=_a; update=1; }
	void AddYAngle(float _a) { ay+=_a; update=1; }
	void AddZAngle(float _a) { az+=_a; update=1; }
	float GetXPos() { return x; }
	float GetYPos() { return y; }
	float GetZPos() { return z; }
	Vector& GetPos() { _vect=Vector(x,y,z); return _vect; }
	Vector& GetAngle() { _vect=Vector(ax,ay,az); return _vect; }
	float GetXAngle() { return ax; }
	float GetYAngle() { return ay; }
	float GetZAngle() { return az; }
	void Update();
	void Activate(int active) { isActive=active; }
	D3DMATRIX& GetMatrix() { return matrix; }
	void SetBackgroundColor(D3DCOLOR color);
	void Translate(Vector& pt);
	void Restore(CDirect3D *d3d);
};

#endif
