/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __VERTEX_H__
#define __VERTEX_H__

#include "Direct3D.h"
#include <math.h>

#define VERT_BLOCK_SIZE 2048

class CVertex
{
public:
	float x,y,z,nx,ny,nz,tu,tv;
	CVertex(float _x,float _y,float _z,float _nx,float _ny,float _nz,
		float _tu,float _tv): x(_x), y(_y), z(_z), nx(_nx), ny(_ny),
		nz(_nz), tu(_tu), tv(_tv) {}
	CVertex() {}
    void Normalize()
    {
        float d=sqrt(nx*nx+ny*ny+nz*nz);
        if (d)
        {
            nx/=d;
            ny/=d;
            nz/=d;
        }
    }
};

class CLVertex
{
public:
	float x,y,z,tu,tv;
	D3DCOLOR color,specular;
	CLVertex(float _x,float _y,float _z,D3DCOLOR _color,
		D3DCOLOR _specular,float _tu,float _tv): x(_x), y(_y), z(_z), 
		color(_color), specular(_specular), tu(_tu), tv(_tv) {}
	CLVertex() {}
};

class CTLVertex
{
public:
	float sx,sy,sz,rhw,tu,tv;
	D3DCOLOR color,specular;
	CTLVertex(float _sx,float _sy,float _sz,float _rhw,D3DCOLOR _color,
		D3DCOLOR _specular,float _tu,float _tv): sx(_sx), sy(_sy),
		sz(_sz),rhw(_rhw), color(_color), specular(_specular), tu(_tu), 
		tv(_tv) {}
	CTLVertex() {}
};

static CVertex _vert;
static CLVertex _lvert;
static CTLVertex _tlvert;

class CVertexList
{
	D3DVERTEX *list;
	int count,arraySize;
public:
	CVertexList() { list=new D3DVERTEX[VERT_BLOCK_SIZE]; count=0;
		arraySize=VERT_BLOCK_SIZE; }
	~CVertexList() { delete[] list; }
	void Clear() { count=0; }
	void SetVertex(int i,CVertex& v) { list[i].x=v.x; list[i].y=v.y;
		list[i].z=v.z; list[i].nx=v.nx; list[i].ny=v.ny; list[i].nz=v.nz;
		list[i].tu=v.tu; list[i].tv=v.tv; }
	int AddVertex(CVertex& v);
	CVertex& GetVertex(int i) { _vert=CVertex(list[i].x,list[i].y,
		list[i].z,list[i].nx,list[i].ny,list[i].nz,list[i].tu,
		list[i].tv); return _vert; }
	D3DVERTEX *GetList() { return list; }
	int GetCount() { return count; }
	void Reflect(float waterLevel);
    void Normalize()
    {
        for (int i=0;i<count;i++)
        {
            float d=sqrt(list[i].nx*list[i].nx+list[i].ny*list[i].ny+list[i].nz*list[i].nz);
            if (d)
            {
                list[i].nx/=d;
                list[i].ny/=d;
                list[i].nz/=d;
            }
        }
    }
};

class CLVertexList
{
	D3DLVERTEX *list;
	int count,arraySize;
public:
	CLVertexList() { list=new D3DLVERTEX[VERT_BLOCK_SIZE]; count=0; 
		arraySize=VERT_BLOCK_SIZE; }
	~CLVertexList() { delete[] list; }
	void Clear() { count=0; }
	void SetVertex(int i,CLVertex& v) { list[i].x=v.x; list[i].y=v.y;
		list[i].z=v.z; list[i].color=v.color; list[i].specular=
		v.specular; list[i].tu=v.tu; list[i].tv=v.tv; }
	inline int AddVertex(CLVertex& v)
	{
		SetVertex(count,v);
		count++;
		if (count>=arraySize)
		{
			D3DLVERTEX *newList=new D3DLVERTEX[arraySize+VERT_BLOCK_SIZE];
			memcpy(newList,list,arraySize*sizeof(D3DLVERTEX));
			delete[] list;
			list=newList;
			arraySize+=VERT_BLOCK_SIZE;
		}
		return count-1;
	}
	CLVertex& GetVertex(int i) { _lvert=CLVertex(list[i].x,list[i].y,
		list[i].z,list[i].color,list[i].specular,list[i].tu,
		list[i].tv); return _lvert; }
	D3DLVERTEX *GetList() { return list; }
	int GetCount() { return count; }
	void Reflect(float waterLevel);
};

class CTLVertexList
{
	D3DTLVERTEX *list;
	int count,arraySize;
public:
	CTLVertexList() { list=new D3DTLVERTEX[VERT_BLOCK_SIZE]; count=0;
		arraySize=VERT_BLOCK_SIZE; }
	~CTLVertexList() { delete[] list; }
	void Clear() { count=0; }
	void SetVertex(int i,CTLVertex& v) { list[i].sx=v.sx; list[i].sy=
		v.sy; list[i].sz=v.sz; list[i].rhw=v.rhw; list[i].color=v.color;
		list[i].specular=v.specular; list[i].tu=v.tu; list[i].tv=v.tv; }
	int AddVertex(CTLVertex& v);
	CTLVertex& GetVertex(int i) { _tlvert=CTLVertex(list[i].sx,list[i].sy,
		list[i].sz,list[i].rhw,list[i].color,list[i].specular,
		list[i].tu,list[i].tv); return _tlvert; }
	D3DTLVERTEX *GetList() { return list; }
	int GetCount() { return count; }
};

class CIndexList
{
	WORD *list;
	int count,arraySize;
public:
	CIndexList() { list=new WORD[VERT_BLOCK_SIZE]; count=0; 
		arraySize=VERT_BLOCK_SIZE; }
	~CIndexList() { delete[] list; }
	void Clear() { count=0; }
	void SetIndex(int i,WORD n) { list[i]=n; }
	int AddIndex(WORD n);
	WORD GetIndex(int i) { return list[i]; }
	WORD *GetList() { return list; }
	int GetCount() { return count; }
};

#endif
