/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef SoundH
#define SoundH

#ifndef PLATFORM_UNIX
#include <mmsystem.h>
#else
#include "linux_inc.h"
#endif

#include "GroupFile.h"
#include "RTSFile.h"

#define CHANNEL_MAIN 0
#define CHANNEL_RTS 1
#define CHANNEL_ANIM 2

typedef struct
{
    char *name;
    int len;
    WAVEFORMATEX format;
    void *data;
} Sound;

#define SOUNDCACHE_STEP 16
#define SOUND_CHANNELS 32

class SoundEngine
{
public:
    SoundEngine();
    virtual ~SoundEngine();
    virtual int Initialized();
    virtual void SetChannelType(int c,int t)=0;
    virtual int PlaySound(Sound *snd,int t,int pri,int loop)=0;
    virtual void StopSound(int c)=0;
    virtual void SoundMute(int mute)=0;
};

extern Sound* LoadSound(GroupFile *group,char *name);
extern Sound* LoadRTSSound(RTSFile *rts,int i);

//---------------------------------------------------------------------------
#endif
