/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __SOFTRENDER_H__
#define __SOFTRENDER_H__

#ifdef PLATFORM_UNIX
#include "SDLRender.h"
#else

#include <vcl.h>
#include "Render.h"
#include "DirectDraw.h"
#include "Poly.h"
#include "art.h"

struct ProjVertex
{
    int x,y;
    float w,uDivZ,vDivZ;
    unsigned long color;
};

class SoftRender: public Render
{
private:
    int init;
    CDirectDraw *dd;
    Graphics::TBitmap *bmp;
    HWND hWnd;
    HDC dc;
    struct FontListElem
    {
        HFONT font;
        FontListElem *next;
    };
    FontListElem *firstFont;
    FontListElem *lastFont;
    FontListElem *curFont;
    int polyDrawn,polyTotal,polyReflect;
    SpriteToDraw spritesToDraw[MAX_SPRITES];
    int numSpritesToDraw;
    bool renderEnabled;
    bool sceneEnabled;
    void **screen;
    void **colorTable[MAX_PAL];
    float xp,yp,zp,xa,ya,za;
    float projYMult;
    unsigned long **wbuffer;

    void RenderPolyListNonBSP(PolyList &list);
    void TexturedTriangle(ProjVertex *v1,ProjVertex *v2,ProjVertex *v3,Texture *tex);
public:
    SoftRender(HINSTANCE hInst,HWND hWnd,int scrnX,int scrnY,int depth);
    ~SoftRender();
    int Initialized();
    void EnumModes(ModeList *modes16,ModeList *modes32);
    void ChangeResolution(int scrnX,int scrnY,int depth);
    void SetRenderWnd(HWND hWnd);
    void BeginRender();
    void RenderPoly(Poly &poly);
    void RenderPolyList(PolyList &list);
    void EndRender();
    void BeginScene();
    void EndScene();
    void SetXPos(float x);
    void SetYPos(float y);
    void SetZPos(float z);
    void AddXPos(float x);
    void AddYPos(float y);
    void AddZPos(float z);
    void SetXRotate(float x);
    void SetYRotate(float y);
    void SetZRotate(float z);
    void AddXRotate(float x);
    void AddYRotate(float y);
    void AddZRotate(float z);
    void GoForward(float d);
    void GoSide(float d);
    float GetXPos();
    float GetYPos();
    float GetZPos();
    float GetXRotate();
    float GetYRotate();
    float GetZRotate();
    Texture* LoadTextureBMP(char *filename);
    Texture* LoadAlphaTextureBMP(char *filename,char *alphaname);
    void CreateMemoryTexture(Texture* tex);
    void UpdateMemoryTexture(Texture* tex);
    void ReloadTexture(Texture* tex);
    void FreeTexture(Texture* tex);
    void UseOriginView();
    void UseNormalView();
    void StartText();
    void EndText();
    void RenderText(int x,int y,char *text,unsigned long color);
    void* AddFont(HFONT font);
    void UseFont(void* font);
    void GetStats(RenderStats *stat);
    void BeginBitmaps();
    void RenderBitmap(int x,int y,Art *art,int texIndex,unsigned long color);
    void RenderBitmap(int x,int y,Art *art,int texIndex,int palNum,unsigned long color);
    void RenderBitmap(int x,int y,Texture *tex,int w,int h,unsigned long color);
    void RenderBitmapYFlipped(int x,int y,Art *art,int texIndex,unsigned long color);
    void RenderScaledBitmap(int x,int y,int w,int h,Art *art,int texIndex,unsigned long color);
    void RenderScaledBitmap(int x,int y,int w,int h,Art *art,int texIndex,int palNum,unsigned long color);
    void EndBitmaps();
    void LoadPalette(int i,unsigned short *pal);
};
#endif

#endif
