/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __DIRECTINPUT_H__
#define __DIRECTINPUT_H__

#include <windows.h>
#include <dinput.h>

#define DINPUT_ALL 0
#define DINPUT_MOUSE 1
#define DINPUT_JOYSTICK 2

#define MB_DOWN 0
#define MB_UP 4

class CDirectInput
{
	HWND hWnd;
	HINSTANCE hInst;
	LPDIRECTINPUT lpDI;
	IDirectInputDevice2 *lpMouse;
	IDirectInputDevice2 *lpStick;
    int init;
public:
	CDirectInput(HINSTANCE inst,HWND wnd);
	~CDirectInput();
    int Initialized();
	void Acquire(int device=DINPUT_ALL);
	void Unacquire(int device=DINPUT_ALL);
	void GetInput(int device,int axis[4],int button[8]);
};

#endif
